#!/usr/bin/perl -w
#
# script to generate mapping between
# Yudit internal ids and codepoints in 
# Tamil TSCII fonts (http://www.tscii.org)
# Thuraiappah Vaseeharan <t_vasee@yahoo.com>
# Mon Dec 31 20:13:51 CST 2001

print <<EOT
NAME=tscii.my
COMM=Map Yudit cluster id to a TSCII glyph.
COMM=auto generated by Tamil.tscii.pl
TYPE=0
SECTION=encode
ENCODE=1
# KEY_WIDTH == 2 for 32 bit key
KEY_WIDTH=2
VALUE_WIDTH=1
KEY_LENGTH=0
VALUE_LENGTH=0
EOT
;

@vowels = (0xab..0xb7) ; 
# in unicode order
@consonants = (0xb8..0xba, 0x192, 0xbb..0xbf, 0xc9, 0xc0..0xc3, 0xc8, 0xc4, 0xc7, 0xc6, 0xc5, 0x201e, 0x2026, 0x2020) ;
@ukaram = (0xcc, 0x2122, 0xcd, 0xa4, 0x161, 0xce..0xd1, 0xdb, 0xd2..0xd5, 0xda, 0xd6, 0xd9, 0xd8, 0xd7, 0xa4, 0xa4, 0xa4) ;
@Ukaaram = (0xdc, 0x203a, 0xdd, 0xa5, 0x153, 0xde..0xe1, 0xeb, 0xe2..0xe5, 0xea, 0xe6, 0xe9, 0xe8, 0xe7, 0xa5, 0xa5, 0xa5) ;
%granthas = ( 	0x192 => 1, 
		0x201e => 1, 
		0x2025 => 1, 
		0x2020 => 1) ;

@modifiers_0 = (0xa2, 0xa3) ; # i I
#@modifiers_1 = (0xa4, 0xa5) ; # u U 
@modifiers_2 = (0xa6..0xa8) ; # e E ai
@modifiers_3 = qw(o O au) ; # o O au
%didI = ( 0xa2 => 0xca,
	  0xa3 => 0xcb) ;
%first_part = ( 'o' => 0xa6, 
		'O' => 0xa7,
		'au' => 0xa6 ) ;
%last_part = (  'o' => 0xa1 ,
		'O' => 0xa1 ,
		'au' => 0xaa ) ; 

# independent vowels, consonants
print "COMM=begin tamil clusters\n" ;
print "COMM=uyir, akara meys\n" ;
$id = 0x80060000 ; 
foreach $v (@vowels) { 
	printf("%x -> %04x\n", $id++, $v) ;
}
foreach $c (@consonants) {
	printf("%x -> %04x\n", $id++, $c) ;
}
$aravu = 0xa1 ;
foreach $c (@consonants) {
	printf("%x -> %04x %04x\n", $id++, $c, $aravu) ;
}
print "COMM=meys\n" ;
# meys (consonant + pulli)
$id = 0x8006f000 ;

@meys = (0xec..0xee, 0x2c6, 0xef..0xf3, 0xfd, 0xf4..0xf7, 0xfc, 0xf8, 0xfb, 0xfa, 0xf9, 0x2030, 0x0160, 0x2039) ;
foreach $m (@meys) {
	printf("%x -> %04x\n", $id++, $m) ;
}

print "COMM=uyir-meys\n" ;
# uyir-meys
$id1 = 0x8006d000 ;
$id2 = 0x8006e000 ;

$count = 0 ;
foreach $c (@consonants) {
	# i, I
	foreach $m (@modifiers_0) {
		if ($c == 0xbc) {
			printf("%x -> %04x\n", $id1++, $didI{$m}) ;
		} else {
			printf("%x -> %04x %04x\n", $id1++, $c, $m) ;
		}
	}
	# u
	if ($granthas{$c}) {
		printf("%x -> %04x %04x\n", $id1++, $c, $ukaram[$count]) ;
	} else {
		printf("%x -> %04x\n", $id1++, $ukaram[$count]) ;
	}
	# U
	if ($granthas{$c}) {
		printf("%x -> %04x %04x\n", $id1++, $c, $Ukaaram[$count]) ;
	} else {
		printf("%x -> %04x\n", $id1++, $Ukaaram[$count]) ;
	}
	# e, E, ai
	foreach $m (@modifiers_2) {
		printf("%x -> %04x %04x\n", $id2++, $m, $c) ;
	}
	# o, O, au
	foreach $m (@modifiers_3) {
		printf("%x -> %04x %04x %04x\n", $id2++, $first_part{$m}, $c, $last_part{$m}) ;
	}
	$count++ ;
}
print "COMM=end tamil\n" ;
