/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt --conf-parser -i /home/runner/work/yubihsm-shell/yubihsm-shell/src/cmdline.ggo --output-dir /home/runner/work/yubihsm-shell/yubihsm-shell/src cmdline 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "cmdline.h"

const char *gengetopt_args_info_purpose = "";

const char *gengetopt_args_info_usage = "Usage: " CMDLINE_PARSER_PACKAGE " [OPTION]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "  -a, --action=ENUM             Action to perform  (possible\n                                  values=\"benchmark\", \"blink-device\",\n                                  \"create-otp-aead\", \"decrypt-aesccm\",\n                                  \"decrypt-aescbc\", \"decrypt-aesecb\",\n                                  \"decrypt-oaep\", \"decrypt-otp\",\n                                  \"decrypt-pkcs1v15\", \"delete-object\",\n                                  \"derive-ecdh\", \"encrypt-aesccm\",\n                                  \"encrypt-aescbc\", \"encrypt-aesecb\",\n                                  \"generate-asymmetric-key\",\n                                  \"generate-csr\", \"generate-hmac-key\",\n                                  \"generate-otp-aead-key\",\n                                  \"generate-wrap-key\",\n                                  \"generate-symmetric-key\",\n                                  \"get-device-info\", \"get-logs\",\n                                  \"get-object-info\", \"get-opaque\",\n                                  \"get-option\", \"get-pseudo-random\",\n                                  \"get-public-key\", \"get-storage-info\",\n                                  \"get-template\", \"get-wrapped\",\n                                  \"get-rsa-wrapped\", \"get-rsa-wrapped-key\",\n                                  \"get-device-pubkey\", \"list-objects\",\n                                  \"put-asymmetric-key\",\n                                  \"put-authentication-key\", \"put-hmac-key\",\n                                  \"put-opaque\", \"put-option\",\n                                  \"put-otp-aead-key\", \"put-symmetric-key\",\n                                  \"put-template\", \"put-wrap-key\",\n                                  \"put-rsa-wrapkey\", \"put-public-wrapkey\",\n                                  \"put-wrapped\", \"put-rsa-wrapped\",\n                                  \"put-rsa-wrapped-key\",\n                                  \"randomize-otp-aead\", \"reset\",\n                                  \"set-log-index\",\n                                  \"sign-attestation-certificate\",\n                                  \"sign-ecdsa\", \"sign-eddsa\",\n                                  \"sign-hmac\", \"sign-pkcs1v15\",\n                                  \"sign-pss\", \"sign-ssh-certificate\")",
  "  -p, --password=STRING         Authentication password",
  "      --authkey=SHORT           Authentication key  (default=`1')",
  "  -i, --object-id=SHORT         Object ID  (default=`0')",
  "  -l, --label=STRING            Object label  (default=`')",
  "  -d, --domains=STRING          Object domains\n                                  (default=`1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16')",
  "  -c, --capabilities=STRING     Capabilities for an object  (default=`0')",
  "  -t, --object-type=STRING      Object type  (default=`any')",
  "  -y, --ykhsmauth-label=STRING  Credential label on YubiKey (implicitly enables\n                                  ykhsmauth)",
  "  -r, --ykhsmauth-reader=STRING Only use a matching YubiKey reader name\n                                  (default=`')",
  "      --delegated=STRING        Delegated capabilities  (default=`0')",
  "      --new-password=STRING     New authentication password",
  "  -A, --algorithm=STRING        Operation algorithm  (default=`any')",
  "      --oaep=STRING             OAEP algorithm. Used primarily with asymmetric\n                                  wrap  (default=`rsa-oaep-sha256')",
  "      --mgf1=STRING             MGF1 algorithm. Used primarily with asymmetric\n                                  wrap  (default=`mgf1-sha256')",
  "      --nonce=INT               OTP nonce",
  "      --iv=STRING               An initialization vector as a hexadecimal\n                                  string",
  "      --count=INT               Number of bytes to request  (default=`256')",
  "      --duration=INT            Blink duration in seconds  (default=`10')",
  "      --wrap-id=SHORT           Wrap key ID",
  "      --include-seed            Include seed when exporting an ED25519 key\n                                  under wrap  (default=off)",
  "      --template-id=SHORT       Template ID",
  "      --attestation-id=SHORT    Attestation ID",
  "      --log-index=INT           Log index",
  "      --opt-name=STRING         Device option name",
  "      --opt-value=STRING        Device option value",
  "      --with-compression        Compress a X509Certificate before importing it\n                                  into the device or detect compressed\n                                  certificates when listing objects\n                                  (default=off)",
  "  -S, --subject=STRING          The subject to use for certificate request. The\n                                  subject must be written as:\n                                  /CN=host.example.com/OU=test/O=example.com/",
  "      --in=STRING               Input data (filename)  (default=`-')",
  "      --out=STRING              Output data (filename)  (default=`-')",
  "      --informat=ENUM           Input format  (possible values=\"default\",\n                                  \"base64\", \"binary\", \"PEM\",\n                                  \"password\", \"hex\", \"ASCII\"\n                                  default=`default')",
  "      --outformat=ENUM          Input and output format  (possible\n                                  values=\"default\", \"base64\", \"binary\",\n                                  \"PEM\", \"hex\", \"ASCII\"\n                                  default=`default')",
  "  -f, --config-file=STRING      Configuration file to read  (default=`')",
  "  -C, --connector=STRING        List of connectors to use",
  "      --cacert=STRING           HTTPS cacert for connector",
  "      --cert=STRING             HTTPS client certificate to authenticate with",
  "      --key=STRING              HTTPS client certificate key",
  "      --proxy=STRING            Proxy server to use for connector",
  "      --noproxy=STRING          Comma separated list of hosts ignore proxy for",
  "  -v, --verbose=INT             Print more information  (default=`0')",
  "  -P, --pre-connect             Connect immediately in interactive mode\n                                  (default=off)",
  "      --device-pubkey=STRING    List of device public keys allowed for\n                                  asymmetric authentication",
    0
};

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_SHORT
  , ARG_ENUM
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

static int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error);
struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


const char *cmdline_parser_action_values[] = {"benchmark", "blink-device", "create-otp-aead", "decrypt-aesccm", "decrypt-aescbc", "decrypt-aesecb", "decrypt-oaep", "decrypt-otp", "decrypt-pkcs1v15", "delete-object", "derive-ecdh", "encrypt-aesccm", "encrypt-aescbc", "encrypt-aesecb", "generate-asymmetric-key", "generate-csr", "generate-hmac-key", "generate-otp-aead-key", "generate-wrap-key", "generate-symmetric-key", "get-device-info", "get-logs", "get-object-info", "get-opaque", "get-option", "get-pseudo-random", "get-public-key", "get-storage-info", "get-template", "get-wrapped", "get-rsa-wrapped", "get-rsa-wrapped-key", "get-device-pubkey", "list-objects", "put-asymmetric-key", "put-authentication-key", "put-hmac-key", "put-opaque", "put-option", "put-otp-aead-key", "put-symmetric-key", "put-template", "put-wrap-key", "put-rsa-wrapkey", "put-public-wrapkey", "put-wrapped", "put-rsa-wrapped", "put-rsa-wrapped-key", "randomize-otp-aead", "reset", "set-log-index", "sign-attestation-certificate", "sign-ecdsa", "sign-eddsa", "sign-hmac", "sign-pkcs1v15", "sign-pss", "sign-ssh-certificate", 0}; /*< Possible values for action. */
const char *cmdline_parser_informat_values[] = {"default", "base64", "binary", "PEM", "password", "hex", "ASCII", 0}; /*< Possible values for informat. */
const char *cmdline_parser_outformat_values[] = {"default", "base64", "binary", "PEM", "hex", "ASCII", 0}; /*< Possible values for outformat. */

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->action_given = 0 ;
  args_info->password_given = 0 ;
  args_info->authkey_given = 0 ;
  args_info->object_id_given = 0 ;
  args_info->label_given = 0 ;
  args_info->domains_given = 0 ;
  args_info->capabilities_given = 0 ;
  args_info->object_type_given = 0 ;
  args_info->ykhsmauth_label_given = 0 ;
  args_info->ykhsmauth_reader_given = 0 ;
  args_info->delegated_given = 0 ;
  args_info->new_password_given = 0 ;
  args_info->algorithm_given = 0 ;
  args_info->oaep_given = 0 ;
  args_info->mgf1_given = 0 ;
  args_info->nonce_given = 0 ;
  args_info->iv_given = 0 ;
  args_info->count_given = 0 ;
  args_info->duration_given = 0 ;
  args_info->wrap_id_given = 0 ;
  args_info->include_seed_given = 0 ;
  args_info->template_id_given = 0 ;
  args_info->attestation_id_given = 0 ;
  args_info->log_index_given = 0 ;
  args_info->opt_name_given = 0 ;
  args_info->opt_value_given = 0 ;
  args_info->with_compression_given = 0 ;
  args_info->subject_given = 0 ;
  args_info->in_given = 0 ;
  args_info->out_given = 0 ;
  args_info->informat_given = 0 ;
  args_info->outformat_given = 0 ;
  args_info->config_file_given = 0 ;
  args_info->connector_given = 0 ;
  args_info->cacert_given = 0 ;
  args_info->cert_given = 0 ;
  args_info->key_given = 0 ;
  args_info->proxy_given = 0 ;
  args_info->noproxy_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->pre_connect_given = 0 ;
  args_info->device_pubkey_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->action_arg = NULL;
  args_info->action_orig = NULL;
  args_info->password_arg = NULL;
  args_info->password_orig = NULL;
  args_info->authkey_arg = 1;
  args_info->authkey_orig = NULL;
  args_info->object_id_arg = 0;
  args_info->object_id_orig = NULL;
  args_info->label_arg = gengetopt_strdup ("");
  args_info->label_orig = NULL;
  args_info->domains_arg = gengetopt_strdup ("1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16");
  args_info->domains_orig = NULL;
  args_info->capabilities_arg = gengetopt_strdup ("0");
  args_info->capabilities_orig = NULL;
  args_info->object_type_arg = gengetopt_strdup ("any");
  args_info->object_type_orig = NULL;
  args_info->ykhsmauth_label_arg = NULL;
  args_info->ykhsmauth_label_orig = NULL;
  args_info->ykhsmauth_reader_arg = gengetopt_strdup ("");
  args_info->ykhsmauth_reader_orig = NULL;
  args_info->delegated_arg = gengetopt_strdup ("0");
  args_info->delegated_orig = NULL;
  args_info->new_password_arg = NULL;
  args_info->new_password_orig = NULL;
  args_info->algorithm_arg = gengetopt_strdup ("any");
  args_info->algorithm_orig = NULL;
  args_info->oaep_arg = gengetopt_strdup ("rsa-oaep-sha256");
  args_info->oaep_orig = NULL;
  args_info->mgf1_arg = gengetopt_strdup ("mgf1-sha256");
  args_info->mgf1_orig = NULL;
  args_info->nonce_orig = NULL;
  args_info->iv_arg = NULL;
  args_info->iv_orig = NULL;
  args_info->count_arg = 256;
  args_info->count_orig = NULL;
  args_info->duration_arg = 10;
  args_info->duration_orig = NULL;
  args_info->wrap_id_orig = NULL;
  args_info->include_seed_flag = 0;
  args_info->template_id_orig = NULL;
  args_info->attestation_id_orig = NULL;
  args_info->log_index_orig = NULL;
  args_info->opt_name_arg = NULL;
  args_info->opt_name_orig = NULL;
  args_info->opt_value_arg = NULL;
  args_info->opt_value_orig = NULL;
  args_info->with_compression_flag = 0;
  args_info->subject_arg = NULL;
  args_info->subject_orig = NULL;
  args_info->in_arg = gengetopt_strdup ("-");
  args_info->in_orig = NULL;
  args_info->out_arg = gengetopt_strdup ("-");
  args_info->out_orig = NULL;
  args_info->informat_arg = informat_arg_default;
  args_info->informat_orig = NULL;
  args_info->outformat_arg = outformat_arg_default;
  args_info->outformat_orig = NULL;
  args_info->config_file_arg = gengetopt_strdup ("");
  args_info->config_file_orig = NULL;
  args_info->connector_arg = NULL;
  args_info->connector_orig = NULL;
  args_info->cacert_arg = NULL;
  args_info->cacert_orig = NULL;
  args_info->cert_arg = NULL;
  args_info->cert_orig = NULL;
  args_info->key_arg = NULL;
  args_info->key_orig = NULL;
  args_info->proxy_arg = NULL;
  args_info->proxy_orig = NULL;
  args_info->noproxy_arg = NULL;
  args_info->noproxy_orig = NULL;
  args_info->verbose_arg = 0;
  args_info->verbose_orig = NULL;
  args_info->pre_connect_flag = 0;
  args_info->device_pubkey_arg = NULL;
  args_info->device_pubkey_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->help_help = gengetopt_args_info_help[0] ;
  args_info->version_help = gengetopt_args_info_help[1] ;
  args_info->action_help = gengetopt_args_info_help[2] ;
  args_info->action_min = 0;
  args_info->action_max = 0;
  args_info->password_help = gengetopt_args_info_help[3] ;
  args_info->authkey_help = gengetopt_args_info_help[4] ;
  args_info->object_id_help = gengetopt_args_info_help[5] ;
  args_info->label_help = gengetopt_args_info_help[6] ;
  args_info->domains_help = gengetopt_args_info_help[7] ;
  args_info->capabilities_help = gengetopt_args_info_help[8] ;
  args_info->object_type_help = gengetopt_args_info_help[9] ;
  args_info->ykhsmauth_label_help = gengetopt_args_info_help[10] ;
  args_info->ykhsmauth_reader_help = gengetopt_args_info_help[11] ;
  args_info->delegated_help = gengetopt_args_info_help[12] ;
  args_info->new_password_help = gengetopt_args_info_help[13] ;
  args_info->algorithm_help = gengetopt_args_info_help[14] ;
  args_info->oaep_help = gengetopt_args_info_help[15] ;
  args_info->mgf1_help = gengetopt_args_info_help[16] ;
  args_info->nonce_help = gengetopt_args_info_help[17] ;
  args_info->iv_help = gengetopt_args_info_help[18] ;
  args_info->count_help = gengetopt_args_info_help[19] ;
  args_info->duration_help = gengetopt_args_info_help[20] ;
  args_info->wrap_id_help = gengetopt_args_info_help[21] ;
  args_info->include_seed_help = gengetopt_args_info_help[22] ;
  args_info->template_id_help = gengetopt_args_info_help[23] ;
  args_info->attestation_id_help = gengetopt_args_info_help[24] ;
  args_info->log_index_help = gengetopt_args_info_help[25] ;
  args_info->opt_name_help = gengetopt_args_info_help[26] ;
  args_info->opt_value_help = gengetopt_args_info_help[27] ;
  args_info->with_compression_help = gengetopt_args_info_help[28] ;
  args_info->subject_help = gengetopt_args_info_help[29] ;
  args_info->in_help = gengetopt_args_info_help[30] ;
  args_info->out_help = gengetopt_args_info_help[31] ;
  args_info->informat_help = gengetopt_args_info_help[32] ;
  args_info->outformat_help = gengetopt_args_info_help[33] ;
  args_info->config_file_help = gengetopt_args_info_help[34] ;
  args_info->connector_help = gengetopt_args_info_help[35] ;
  args_info->connector_min = 0;
  args_info->connector_max = 0;
  args_info->cacert_help = gengetopt_args_info_help[36] ;
  args_info->cert_help = gengetopt_args_info_help[37] ;
  args_info->key_help = gengetopt_args_info_help[38] ;
  args_info->proxy_help = gengetopt_args_info_help[39] ;
  args_info->noproxy_help = gengetopt_args_info_help[40] ;
  args_info->verbose_help = gengetopt_args_info_help[41] ;
  args_info->pre_connect_help = gengetopt_args_info_help[42] ;
  args_info->device_pubkey_help = gengetopt_args_info_help[43] ;
  args_info->device_pubkey_min = 0;
  args_info->device_pubkey_max = 0;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    short short_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}

/**
 * The passed arg parameter is NOT set to 0 from this function
 */
static void
free_multiple_field(unsigned int len, void *arg, char ***orig)
{
  unsigned int i;
  if (arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*orig)[i]));
      }

    free (arg);
    free (*orig);
    *orig = 0;
  }
}

static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{

  free_multiple_field (args_info->action_given, (void *)(args_info->action_arg), &(args_info->action_orig));
  args_info->action_arg = 0;
  free_string_field (&(args_info->password_arg));
  free_string_field (&(args_info->password_orig));
  free_string_field (&(args_info->authkey_orig));
  free_string_field (&(args_info->object_id_orig));
  free_string_field (&(args_info->label_arg));
  free_string_field (&(args_info->label_orig));
  free_string_field (&(args_info->domains_arg));
  free_string_field (&(args_info->domains_orig));
  free_string_field (&(args_info->capabilities_arg));
  free_string_field (&(args_info->capabilities_orig));
  free_string_field (&(args_info->object_type_arg));
  free_string_field (&(args_info->object_type_orig));
  free_string_field (&(args_info->ykhsmauth_label_arg));
  free_string_field (&(args_info->ykhsmauth_label_orig));
  free_string_field (&(args_info->ykhsmauth_reader_arg));
  free_string_field (&(args_info->ykhsmauth_reader_orig));
  free_string_field (&(args_info->delegated_arg));
  free_string_field (&(args_info->delegated_orig));
  free_string_field (&(args_info->new_password_arg));
  free_string_field (&(args_info->new_password_orig));
  free_string_field (&(args_info->algorithm_arg));
  free_string_field (&(args_info->algorithm_orig));
  free_string_field (&(args_info->oaep_arg));
  free_string_field (&(args_info->oaep_orig));
  free_string_field (&(args_info->mgf1_arg));
  free_string_field (&(args_info->mgf1_orig));
  free_string_field (&(args_info->nonce_orig));
  free_string_field (&(args_info->iv_arg));
  free_string_field (&(args_info->iv_orig));
  free_string_field (&(args_info->count_orig));
  free_string_field (&(args_info->duration_orig));
  free_string_field (&(args_info->wrap_id_orig));
  free_string_field (&(args_info->template_id_orig));
  free_string_field (&(args_info->attestation_id_orig));
  free_string_field (&(args_info->log_index_orig));
  free_string_field (&(args_info->opt_name_arg));
  free_string_field (&(args_info->opt_name_orig));
  free_string_field (&(args_info->opt_value_arg));
  free_string_field (&(args_info->opt_value_orig));
  free_string_field (&(args_info->subject_arg));
  free_string_field (&(args_info->subject_orig));
  free_string_field (&(args_info->in_arg));
  free_string_field (&(args_info->in_orig));
  free_string_field (&(args_info->out_arg));
  free_string_field (&(args_info->out_orig));
  free_string_field (&(args_info->informat_orig));
  free_string_field (&(args_info->outformat_orig));
  free_string_field (&(args_info->config_file_arg));
  free_string_field (&(args_info->config_file_orig));
  free_multiple_string_field (args_info->connector_given, &(args_info->connector_arg), &(args_info->connector_orig));
  free_string_field (&(args_info->cacert_arg));
  free_string_field (&(args_info->cacert_orig));
  free_string_field (&(args_info->cert_arg));
  free_string_field (&(args_info->cert_orig));
  free_string_field (&(args_info->key_arg));
  free_string_field (&(args_info->key_orig));
  free_string_field (&(args_info->proxy_arg));
  free_string_field (&(args_info->proxy_orig));
  free_string_field (&(args_info->noproxy_arg));
  free_string_field (&(args_info->noproxy_orig));
  free_string_field (&(args_info->verbose_orig));
  free_multiple_string_field (args_info->device_pubkey_given, &(args_info->device_pubkey_arg), &(args_info->device_pubkey_orig));
  
  

  clear_given (args_info);
}

/**
 * @param val the value to check
 * @param values the possible values
 * @return the index of the matched value:
 * -1 if no value matched,
 * -2 if more than one value has matched
 */
static int
check_possible_values(const char *val, const char *values[])
{
  int i, found, last;
  size_t len;

  if (!val)   /* otherwise strlen() crashes below */
    return -1; /* -1 means no argument for the option */

  found = last = 0;

  for (i = 0, len = strlen(val); values[i]; ++i)
    {
      if (strncmp(val, values[i], len) == 0)
        {
          ++found;
          last = i;
          if (strlen(values[i]) == len)
            return i; /* exact macth no need to check more */
        }
    }

  if (found == 1) /* one match: OK */
    return last;

  return (found ? -2 : -1); /* return many values or none matched */
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  int found = -1;
  if (arg) {
    if (values) {
      found = check_possible_values(arg, values);      
    }
    if (found >= 0)
      fprintf(outfile, "%s=\"%s\" # %s\n", opt, arg, values[found]);
    else
      fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  write_multiple_into_file(outfile, args_info->action_given, "action", args_info->action_orig, cmdline_parser_action_values);
  if (args_info->password_given)
    write_into_file(outfile, "password", args_info->password_orig, 0);
  if (args_info->authkey_given)
    write_into_file(outfile, "authkey", args_info->authkey_orig, 0);
  if (args_info->object_id_given)
    write_into_file(outfile, "object-id", args_info->object_id_orig, 0);
  if (args_info->label_given)
    write_into_file(outfile, "label", args_info->label_orig, 0);
  if (args_info->domains_given)
    write_into_file(outfile, "domains", args_info->domains_orig, 0);
  if (args_info->capabilities_given)
    write_into_file(outfile, "capabilities", args_info->capabilities_orig, 0);
  if (args_info->object_type_given)
    write_into_file(outfile, "object-type", args_info->object_type_orig, 0);
  if (args_info->ykhsmauth_label_given)
    write_into_file(outfile, "ykhsmauth-label", args_info->ykhsmauth_label_orig, 0);
  if (args_info->ykhsmauth_reader_given)
    write_into_file(outfile, "ykhsmauth-reader", args_info->ykhsmauth_reader_orig, 0);
  if (args_info->delegated_given)
    write_into_file(outfile, "delegated", args_info->delegated_orig, 0);
  if (args_info->new_password_given)
    write_into_file(outfile, "new-password", args_info->new_password_orig, 0);
  if (args_info->algorithm_given)
    write_into_file(outfile, "algorithm", args_info->algorithm_orig, 0);
  if (args_info->oaep_given)
    write_into_file(outfile, "oaep", args_info->oaep_orig, 0);
  if (args_info->mgf1_given)
    write_into_file(outfile, "mgf1", args_info->mgf1_orig, 0);
  if (args_info->nonce_given)
    write_into_file(outfile, "nonce", args_info->nonce_orig, 0);
  if (args_info->iv_given)
    write_into_file(outfile, "iv", args_info->iv_orig, 0);
  if (args_info->count_given)
    write_into_file(outfile, "count", args_info->count_orig, 0);
  if (args_info->duration_given)
    write_into_file(outfile, "duration", args_info->duration_orig, 0);
  if (args_info->wrap_id_given)
    write_into_file(outfile, "wrap-id", args_info->wrap_id_orig, 0);
  if (args_info->include_seed_given)
    write_into_file(outfile, "include-seed", 0, 0 );
  if (args_info->template_id_given)
    write_into_file(outfile, "template-id", args_info->template_id_orig, 0);
  if (args_info->attestation_id_given)
    write_into_file(outfile, "attestation-id", args_info->attestation_id_orig, 0);
  if (args_info->log_index_given)
    write_into_file(outfile, "log-index", args_info->log_index_orig, 0);
  if (args_info->opt_name_given)
    write_into_file(outfile, "opt-name", args_info->opt_name_orig, 0);
  if (args_info->opt_value_given)
    write_into_file(outfile, "opt-value", args_info->opt_value_orig, 0);
  if (args_info->with_compression_given)
    write_into_file(outfile, "with-compression", 0, 0 );
  if (args_info->subject_given)
    write_into_file(outfile, "subject", args_info->subject_orig, 0);
  if (args_info->in_given)
    write_into_file(outfile, "in", args_info->in_orig, 0);
  if (args_info->out_given)
    write_into_file(outfile, "out", args_info->out_orig, 0);
  if (args_info->informat_given)
    write_into_file(outfile, "informat", args_info->informat_orig, cmdline_parser_informat_values);
  if (args_info->outformat_given)
    write_into_file(outfile, "outformat", args_info->outformat_orig, cmdline_parser_outformat_values);
  if (args_info->config_file_given)
    write_into_file(outfile, "config-file", args_info->config_file_orig, 0);
  write_multiple_into_file(outfile, args_info->connector_given, "connector", args_info->connector_orig, 0);
  if (args_info->cacert_given)
    write_into_file(outfile, "cacert", args_info->cacert_orig, 0);
  if (args_info->cert_given)
    write_into_file(outfile, "cert", args_info->cert_orig, 0);
  if (args_info->key_given)
    write_into_file(outfile, "key", args_info->key_orig, 0);
  if (args_info->proxy_given)
    write_into_file(outfile, "proxy", args_info->proxy_orig, 0);
  if (args_info->noproxy_given)
    write_into_file(outfile, "noproxy", args_info->noproxy_orig, 0);
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", args_info->verbose_orig, 0);
  if (args_info->pre_connect_given)
    write_into_file(outfile, "pre-connect", 0, 0 );
  write_multiple_into_file(outfile, args_info->device_pubkey_given, "device-pubkey", args_info->device_pubkey_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required2 (struct gengetopt_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->action_given, args_info->action_min, args_info->action_max, "'--action' ('-a')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->connector_given, args_info->connector_min, args_info->connector_max, "'--connector' ('-C')"))
     error_occurred = 1;
  
  if (check_multiple_option_occurrences(prog_name, args_info->device_pubkey_given, args_info->device_pubkey_min, args_info->device_pubkey_max, "'--device-pubkey'"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  if (possible_values && (found = check_possible_values((value ? value : default_value), possible_values)) < 0)
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s' (`-%c')%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt, short_opt,
          (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: %s argument, \"%s\", for option `--%s'%s\n", 
          package_name, (found == -2) ? "ambiguous" : "invalid", value, long_opt,
          (additional_error ? additional_error : ""));
      return 1; /* failure */
    }
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_SHORT:
    if (val) *((short *)field) = (short)strtol (val, &stop_char, 0);
    break;
  case ARG_ENUM:
    if (val) *((int *)field) = found;
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_SHORT:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
    case ARG_ENUM:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_SHORT:
      *((short **)field) = (short *)realloc (*((short **)field), (field_given + prev_given) * sizeof (short)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_SHORT:
          (*((short **)field))[i + field_given] = tmp->arg.short_arg; break;
        case ARG_ENUM:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
      case ARG_ENUM:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_SHORT:
        if (! *((short **)field)) {
          *((short **)field) = (short *)malloc (sizeof (short));
          (*((short **)field))[0] = default_value->short_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * action_list = NULL;
  struct generic_list * connector_list = NULL;
  struct generic_list * device_pubkey_list = NULL;
  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "action",	1, NULL, 'a' },
        { "password",	1, NULL, 'p' },
        { "authkey",	1, NULL, 0 },
        { "object-id",	1, NULL, 'i' },
        { "label",	1, NULL, 'l' },
        { "domains",	1, NULL, 'd' },
        { "capabilities",	1, NULL, 'c' },
        { "object-type",	1, NULL, 't' },
        { "ykhsmauth-label",	1, NULL, 'y' },
        { "ykhsmauth-reader",	1, NULL, 'r' },
        { "delegated",	1, NULL, 0 },
        { "new-password",	1, NULL, 0 },
        { "algorithm",	1, NULL, 'A' },
        { "oaep",	1, NULL, 0 },
        { "mgf1",	1, NULL, 0 },
        { "nonce",	1, NULL, 0 },
        { "iv",	1, NULL, 0 },
        { "count",	1, NULL, 0 },
        { "duration",	1, NULL, 0 },
        { "wrap-id",	1, NULL, 0 },
        { "include-seed",	0, NULL, 0 },
        { "template-id",	1, NULL, 0 },
        { "attestation-id",	1, NULL, 0 },
        { "log-index",	1, NULL, 0 },
        { "opt-name",	1, NULL, 0 },
        { "opt-value",	1, NULL, 0 },
        { "with-compression",	0, NULL, 0 },
        { "subject",	1, NULL, 'S' },
        { "in",	1, NULL, 0 },
        { "out",	1, NULL, 0 },
        { "informat",	1, NULL, 0 },
        { "outformat",	1, NULL, 0 },
        { "config-file",	1, NULL, 'f' },
        { "connector",	1, NULL, 'C' },
        { "cacert",	1, NULL, 0 },
        { "cert",	1, NULL, 0 },
        { "key",	1, NULL, 0 },
        { "proxy",	1, NULL, 0 },
        { "noproxy",	1, NULL, 0 },
        { "verbose",	1, NULL, 'v' },
        { "pre-connect",	0, NULL, 'P' },
        { "device-pubkey",	1, NULL, 0 },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "hVa:p:i:l:d:c:t:y:r:A:S:f:C:v:P", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'a':	/* Action to perform.  */
        
          if (update_multiple_arg_temp(&action_list, 
              &(local_args_info.action_given), optarg, cmdline_parser_action_values, 0, ARG_ENUM,
              "action", 'a',
              additional_error))
            goto failure;
        
          break;
        case 'p':	/* Authentication password.  */
        
        
          if (update_arg( (void *)&(args_info->password_arg), 
               &(args_info->password_orig), &(args_info->password_given),
              &(local_args_info.password_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "password", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Object ID.  */
        
        
          if (update_arg( (void *)&(args_info->object_id_arg), 
               &(args_info->object_id_orig), &(args_info->object_id_given),
              &(local_args_info.object_id_given), optarg, 0, "0", ARG_SHORT,
              check_ambiguity, override, 0, 0,
              "object-id", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Object label.  */
        
        
          if (update_arg( (void *)&(args_info->label_arg), 
               &(args_info->label_orig), &(args_info->label_given),
              &(local_args_info.label_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "label", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Object domains.  */
        
        
          if (update_arg( (void *)&(args_info->domains_arg), 
               &(args_info->domains_orig), &(args_info->domains_given),
              &(local_args_info.domains_given), optarg, 0, "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "domains", 'd',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Capabilities for an object.  */
        
        
          if (update_arg( (void *)&(args_info->capabilities_arg), 
               &(args_info->capabilities_orig), &(args_info->capabilities_given),
              &(local_args_info.capabilities_given), optarg, 0, "0", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "capabilities", 'c',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Object type.  */
        
        
          if (update_arg( (void *)&(args_info->object_type_arg), 
               &(args_info->object_type_orig), &(args_info->object_type_given),
              &(local_args_info.object_type_given), optarg, 0, "any", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "object-type", 't',
              additional_error))
            goto failure;
        
          break;
        case 'y':	/* Credential label on YubiKey (implicitly enables ykhsmauth).  */
        
        
          if (update_arg( (void *)&(args_info->ykhsmauth_label_arg), 
               &(args_info->ykhsmauth_label_orig), &(args_info->ykhsmauth_label_given),
              &(local_args_info.ykhsmauth_label_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "ykhsmauth-label", 'y',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Only use a matching YubiKey reader name.  */
        
        
          if (update_arg( (void *)&(args_info->ykhsmauth_reader_arg), 
               &(args_info->ykhsmauth_reader_orig), &(args_info->ykhsmauth_reader_given),
              &(local_args_info.ykhsmauth_reader_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "ykhsmauth-reader", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'A':	/* Operation algorithm.  */
        
        
          if (update_arg( (void *)&(args_info->algorithm_arg), 
               &(args_info->algorithm_orig), &(args_info->algorithm_given),
              &(local_args_info.algorithm_given), optarg, 0, "any", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "algorithm", 'A',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* The subject to use for certificate request. The subject must be written as: /CN=host.example.com/OU=test/O=example.com/.  */
        
        
          if (update_arg( (void *)&(args_info->subject_arg), 
               &(args_info->subject_orig), &(args_info->subject_given),
              &(local_args_info.subject_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "subject", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Configuration file to read.  */
        
        
          if (update_arg( (void *)&(args_info->config_file_arg), 
               &(args_info->config_file_orig), &(args_info->config_file_given),
              &(local_args_info.config_file_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "config-file", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* List of connectors to use.  */
        
          if (update_multiple_arg_temp(&connector_list, 
              &(local_args_info.connector_given), optarg, 0, 0, ARG_STRING,
              "connector", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Print more information.  */
        
        
          if (update_arg( (void *)&(args_info->verbose_arg), 
               &(args_info->verbose_orig), &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, "0", ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Connect immediately in interactive mode.  */
        
        
          if (update_arg((void *)&(args_info->pre_connect_flag), 0, &(args_info->pre_connect_given),
              &(local_args_info.pre_connect_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "pre-connect", 'P',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Authentication key.  */
          if (strcmp (long_options[option_index].name, "authkey") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->authkey_arg), 
                 &(args_info->authkey_orig), &(args_info->authkey_given),
                &(local_args_info.authkey_given), optarg, 0, "1", ARG_SHORT,
                check_ambiguity, override, 0, 0,
                "authkey", '-',
                additional_error))
              goto failure;
          
          }
          /* Delegated capabilities.  */
          else if (strcmp (long_options[option_index].name, "delegated") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->delegated_arg), 
                 &(args_info->delegated_orig), &(args_info->delegated_given),
                &(local_args_info.delegated_given), optarg, 0, "0", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "delegated", '-',
                additional_error))
              goto failure;
          
          }
          /* New authentication password.  */
          else if (strcmp (long_options[option_index].name, "new-password") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->new_password_arg), 
                 &(args_info->new_password_orig), &(args_info->new_password_given),
                &(local_args_info.new_password_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "new-password", '-',
                additional_error))
              goto failure;
          
          }
          /* OAEP algorithm. Used primarily with asymmetric wrap.  */
          else if (strcmp (long_options[option_index].name, "oaep") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->oaep_arg), 
                 &(args_info->oaep_orig), &(args_info->oaep_given),
                &(local_args_info.oaep_given), optarg, 0, "rsa-oaep-sha256", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "oaep", '-',
                additional_error))
              goto failure;
          
          }
          /* MGF1 algorithm. Used primarily with asymmetric wrap.  */
          else if (strcmp (long_options[option_index].name, "mgf1") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->mgf1_arg), 
                 &(args_info->mgf1_orig), &(args_info->mgf1_given),
                &(local_args_info.mgf1_given), optarg, 0, "mgf1-sha256", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "mgf1", '-',
                additional_error))
              goto failure;
          
          }
          /* OTP nonce.  */
          else if (strcmp (long_options[option_index].name, "nonce") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nonce_arg), 
                 &(args_info->nonce_orig), &(args_info->nonce_given),
                &(local_args_info.nonce_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "nonce", '-',
                additional_error))
              goto failure;
          
          }
          /* An initialization vector as a hexadecimal string.  */
          else if (strcmp (long_options[option_index].name, "iv") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->iv_arg), 
                 &(args_info->iv_orig), &(args_info->iv_given),
                &(local_args_info.iv_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "iv", '-',
                additional_error))
              goto failure;
          
          }
          /* Number of bytes to request.  */
          else if (strcmp (long_options[option_index].name, "count") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->count_arg), 
                 &(args_info->count_orig), &(args_info->count_given),
                &(local_args_info.count_given), optarg, 0, "256", ARG_INT,
                check_ambiguity, override, 0, 0,
                "count", '-',
                additional_error))
              goto failure;
          
          }
          /* Blink duration in seconds.  */
          else if (strcmp (long_options[option_index].name, "duration") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->duration_arg), 
                 &(args_info->duration_orig), &(args_info->duration_given),
                &(local_args_info.duration_given), optarg, 0, "10", ARG_INT,
                check_ambiguity, override, 0, 0,
                "duration", '-',
                additional_error))
              goto failure;
          
          }
          /* Wrap key ID.  */
          else if (strcmp (long_options[option_index].name, "wrap-id") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->wrap_id_arg), 
                 &(args_info->wrap_id_orig), &(args_info->wrap_id_given),
                &(local_args_info.wrap_id_given), optarg, 0, 0, ARG_SHORT,
                check_ambiguity, override, 0, 0,
                "wrap-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Include seed when exporting an ED25519 key under wrap.  */
          else if (strcmp (long_options[option_index].name, "include-seed") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->include_seed_flag), 0, &(args_info->include_seed_given),
                &(local_args_info.include_seed_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "include-seed", '-',
                additional_error))
              goto failure;
          
          }
          /* Template ID.  */
          else if (strcmp (long_options[option_index].name, "template-id") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->template_id_arg), 
                 &(args_info->template_id_orig), &(args_info->template_id_given),
                &(local_args_info.template_id_given), optarg, 0, 0, ARG_SHORT,
                check_ambiguity, override, 0, 0,
                "template-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Attestation ID.  */
          else if (strcmp (long_options[option_index].name, "attestation-id") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->attestation_id_arg), 
                 &(args_info->attestation_id_orig), &(args_info->attestation_id_given),
                &(local_args_info.attestation_id_given), optarg, 0, 0, ARG_SHORT,
                check_ambiguity, override, 0, 0,
                "attestation-id", '-',
                additional_error))
              goto failure;
          
          }
          /* Log index.  */
          else if (strcmp (long_options[option_index].name, "log-index") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->log_index_arg), 
                 &(args_info->log_index_orig), &(args_info->log_index_given),
                &(local_args_info.log_index_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "log-index", '-',
                additional_error))
              goto failure;
          
          }
          /* Device option name.  */
          else if (strcmp (long_options[option_index].name, "opt-name") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->opt_name_arg), 
                 &(args_info->opt_name_orig), &(args_info->opt_name_given),
                &(local_args_info.opt_name_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "opt-name", '-',
                additional_error))
              goto failure;
          
          }
          /* Device option value.  */
          else if (strcmp (long_options[option_index].name, "opt-value") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->opt_value_arg), 
                 &(args_info->opt_value_orig), &(args_info->opt_value_given),
                &(local_args_info.opt_value_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "opt-value", '-',
                additional_error))
              goto failure;
          
          }
          /* Compress a X509Certificate before importing it into the device or detect compressed certificates when listing objects.  */
          else if (strcmp (long_options[option_index].name, "with-compression") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->with_compression_flag), 0, &(args_info->with_compression_given),
                &(local_args_info.with_compression_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "with-compression", '-',
                additional_error))
              goto failure;
          
          }
          /* Input data (filename).  */
          else if (strcmp (long_options[option_index].name, "in") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->in_arg), 
                 &(args_info->in_orig), &(args_info->in_given),
                &(local_args_info.in_given), optarg, 0, "-", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "in", '-',
                additional_error))
              goto failure;
          
          }
          /* Output data (filename).  */
          else if (strcmp (long_options[option_index].name, "out") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->out_arg), 
                 &(args_info->out_orig), &(args_info->out_given),
                &(local_args_info.out_given), optarg, 0, "-", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "out", '-',
                additional_error))
              goto failure;
          
          }
          /* Input format.  */
          else if (strcmp (long_options[option_index].name, "informat") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->informat_arg), 
                 &(args_info->informat_orig), &(args_info->informat_given),
                &(local_args_info.informat_given), optarg, cmdline_parser_informat_values, "default", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "informat", '-',
                additional_error))
              goto failure;
          
          }
          /* Input and output format.  */
          else if (strcmp (long_options[option_index].name, "outformat") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->outformat_arg), 
                 &(args_info->outformat_orig), &(args_info->outformat_given),
                &(local_args_info.outformat_given), optarg, cmdline_parser_outformat_values, "default", ARG_ENUM,
                check_ambiguity, override, 0, 0,
                "outformat", '-',
                additional_error))
              goto failure;
          
          }
          /* HTTPS cacert for connector.  */
          else if (strcmp (long_options[option_index].name, "cacert") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cacert_arg), 
                 &(args_info->cacert_orig), &(args_info->cacert_given),
                &(local_args_info.cacert_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cacert", '-',
                additional_error))
              goto failure;
          
          }
          /* HTTPS client certificate to authenticate with.  */
          else if (strcmp (long_options[option_index].name, "cert") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cert_arg), 
                 &(args_info->cert_orig), &(args_info->cert_given),
                &(local_args_info.cert_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cert", '-',
                additional_error))
              goto failure;
          
          }
          /* HTTPS client certificate key.  */
          else if (strcmp (long_options[option_index].name, "key") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->key_arg), 
                 &(args_info->key_orig), &(args_info->key_given),
                &(local_args_info.key_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "key", '-',
                additional_error))
              goto failure;
          
          }
          /* Proxy server to use for connector.  */
          else if (strcmp (long_options[option_index].name, "proxy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->proxy_arg), 
                 &(args_info->proxy_orig), &(args_info->proxy_given),
                &(local_args_info.proxy_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "proxy", '-',
                additional_error))
              goto failure;
          
          }
          /* Comma separated list of hosts ignore proxy for.  */
          else if (strcmp (long_options[option_index].name, "noproxy") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->noproxy_arg), 
                 &(args_info->noproxy_orig), &(args_info->noproxy_given),
                &(local_args_info.noproxy_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "noproxy", '-',
                additional_error))
              goto failure;
          
          }
          /* List of device public keys allowed for asymmetric authentication.  */
          else if (strcmp (long_options[option_index].name, "device-pubkey") == 0)
          {
          
            if (update_multiple_arg_temp(&device_pubkey_list, 
                &(local_args_info.device_pubkey_given), optarg, 0, 0, ARG_STRING,
                "device-pubkey", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->action_arg),
    &(args_info->action_orig), args_info->action_given,
    local_args_info.action_given, 0,
    ARG_ENUM, action_list);
  update_multiple_arg((void *)&(args_info->connector_arg),
    &(args_info->connector_orig), args_info->connector_given,
    local_args_info.connector_given, 0,
    ARG_STRING, connector_list);
  update_multiple_arg((void *)&(args_info->device_pubkey_arg),
    &(args_info->device_pubkey_orig), args_info->device_pubkey_given,
    local_args_info.device_pubkey_given, 0,
    ARG_STRING, device_pubkey_list);

  args_info->action_given += local_args_info.action_given;
  local_args_info.action_given = 0;
  args_info->connector_given += local_args_info.connector_given;
  local_args_info.connector_given = 0;
  args_info->device_pubkey_given += local_args_info.device_pubkey_given;
  local_args_info.device_pubkey_given = 0;
  
  if (check_required)
    {
      error_occurred += cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (action_list, 0 );
  free_list (connector_list, 1 );
  free_list (device_pubkey_list, 1 );
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
