/*
 * YICS: Connect a FICS interface to the Yahoo! Chess server.
 * Copyright (C) 2004  Chris Howie
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "opcodes.h"
#include "ropcodes.h"
#include "console.h"
#include "network.h"
#include "debug.h"
#include "globals.h"
#include "util.h"

Opcode opcodes[3] = {
	{0x63,	op_exit},
	{0x64,	op_roomaction},
	{-1,	NULL}
};

void handle_opcode() {
	int opcode = ngetc();
	Opcode *search = opcodes;

	if (opcode >= 0) {
		while (search->opcode != -1) {
			if (search->opcode == (uchar)opcode) {
				if (search->handler != NULL)
					search->handler();
				return;
			}
			search++;
		}

		/* We don't know how many bytes to eat */
		dief("Opcode %02X not implemented.", opcode);
	}

	sysiprint("The server has terminated the connection!\n");
	op_exit();
}

void op_exit() {
	time_t t;
	char tm[32];

	nclose();
	sysiprint("\n"
		"Logging you out.\n\n"

		"Thank you for using YICS!  If you have any suggestions or "
		"bug reports, please post them on the project website, "
		"located at http://www.yics.org .  Do NOT send such "
		"reports by email; they will be ignored.\n\n");

	sysiprint("Logout at ");

	time(&t);
	mstrncpy(tm, ctime(&t), sizeof(tm));
	tm[strlen(tm) - 1] = '\0';
	sysiprint(tm);

	sysiprint(".\n");
	
	die("");
}

void op_roomaction() {
	String *packet = NULL, *tmp = NULL;
	uchar opcode = 0;
	RoomOpcode *search = ropcodes;
#if defined(MEMDEBUGP)
#  if MEMDEBUGP
	int lstr;
#  endif
#endif

	if (netlog != NULL)
		fputc(4, netlog);

	nread(NULL, 4);	/* session id */

	packet = nreadutfString(StringNull());
	if (packet == NULL)
		die("Out of memory!");

	opcode = (uchar)packet->string[0];

	tmp = StringNew(&packet->string[1], packet->length - 1);
	StringFree(packet);
	packet = tmp;

	while (search->opcode != -1) {
		if (search->opcode == opcode) {

		#if defined(MEMDEBUGP)
		#  if MEMDEBUGP
			lstr = string_count;
		#  endif
		#endif

			if (search->handler != NULL)
				search->handler(packet);

		#if defined(MEMDEBUGP)
		#  if MEMDEBUGP
			if (string_count > lstr)
				printf("Possible leak, ropcode %02x: %d -> %d\n",
					opcode, lstr, string_count);
		#  endif
		#endif

			StringFree(packet);
			return;
		}
		search++;
	}

	StringFree(packet);
	iprintf("\nWARNING: Room opcode %02x not implemented.\n", opcode);
	prompt();
}
