/* $Id: paths.c,v 1.2 1998/04/30 05:11:57 mrogre Exp $ */
/* Copyright (c) 1998 Joe Rumsey (mrogre@mediaone.net) */
#include "copyright.h"
#include <config.h>

#include "struct.h"
#include "defs.h"
#include "paths.h"
#include "data.h"
#include "proto.h"

#define MAXPATH 50

int paths[NUMPATHS][MAXPATH][2] = {
    { /* PEELLEFT = 0*/
	0, 3,
	15,3,
	14,3,
	13,3,
	12,3,
	11,3,
	10,3,
	9,3,
	8,3,
	-1,-1,
    },
    { /* PEELRIGHT = 1 */
	0,3,
	1,3,
	2,3,
	3,3,
	4,3,
	5,3,
	6,3,
	7,3,
	8,3,
	-1,-1,
    },
    { /* LOOP = 2 */
	8,2,
	9,2,
	10,2,
	11,2,
	12,2,
	13,2,
	14,2,
	15,2,
	0,2,
	1,2,
	2,2,
	3,2,
	4,2,
	5,2,
	6,2,
	7,2,
	8,2,
	-1,-1,
    },
    { /* SWOOP1 = 3 */
	8,20,
	9,3,
	10,3,
	11,3,
	12,3,
	-1,-1,
    },
    { /* SWOOP2 = 4 */
	8,20,
	7,3,
	6,3,
	5,3,
	4,3,
	-1,-1,
    },
    { /* ZIGZAG = 5 */
	7,15,	8,2,
	9,15,	8,2,
	7,15,	8,2,
	9,15,   8,2,
	-1,-1,
    },
    { /* LOOP2 = 6 */
	8,2, 7,2, 6,2, 5,2, 4,2, 3,2, 2,2, 1,2, 0,2, 15,2, 14,2, 13,2, 12,2, 11,2, 10,2, 9,2, 8,2,
	-1,-1,
    },
    { /* SPIN = 7 */
	8,1, 7,1, 6,1, 5,1, 4,1, 3,1, 2,1, 1,1, 0,1, 15,1, 14,1, 13,1, 12,1, 11,1, 10,1, 9,1, 8,1,
	-1,-1,
    },
    { /* LEFTDIAG */
	8,2,
	9,2,
	10,30,
	9,2,
	8,1,
	-1,-1,
    },
    { /* RIGHTDIAG */
	8,2,
	7,2,
	6,30,
	7,2,
	8,1,
	-1,-1,
    },
    { /* ENTER1 */
	8,65, 9,5, 10,5, 11,5, 12,5, 13,5, 14,20, -1,-1,
    },	  
    { /* ENTER2 */
	8,65, 7,5, 6,5, 5,5, 4,5, 3,5, 2,20, -1,-1,
    },
	    /* ENTER3 */
    {-1,-1},
    /* ENTER4 */
    { 10,45, 11,5, 12,20, 13,5, 14,10, -1,-1, },
    /* ENTER5 */
    { 6,45, 5,5, 4,20, 3,5, 2,10, -1,-1, },
    /* ENTER6 */
    { 8,80, 6,10, 4,40, 0,20, 14,30, -1,-1},
    /* ENTER7 */
    { 8,80, 10,10, 12,40, 0,20, 2,30, -1,-1},
    /* ENTER8 */
    { 0,50, 2,50, 3,5, 4,5, 5,5, 6,5, 7,5, 8,5, 9,5, 10,5, 11,5, 12,30, 13,5, 14,5, 15,5, 0,5, -1,-1},
    /* ENTER9 */
    { 0,50, 14,50, 13,5, 12,5, 11,5, 10,5, 9,5, 8,5, 7,5, 6,5, 5,5, 4,30, 3,5, 2,5, 1,5, 0,5, -1,-1},
    /* ENTER10 */
    { 4,80, 10,30, 0,70, -1,-1 },
    /* ENTER11 */
    { 12,80, 6,30, 0,70, -1,-1 },
    /* ENTER12 */
    { 14,80, -1, -1},
    /* ENTER13 */
    { 2,80, -1,-1},
    /* ENTER14 */									     
    { 4,8, 3,6, 2,8, 1,10, 2,8, 3,6, 4,4, 5,6, 6,8, 7,10, 6,8, 5,6, 4,4, 3,6, 2,8, 1,10, 0,20, -1,-1},
    /* 15 */
    { 12,60, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,3,	
	  15,3, 14,3, 13,3, 12,3, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,3,		
	  15,3, 14,3, 13,3, 12,3, 11,3, 10,3, 9,3, 8,3, 7,3, 6,3, 5,3, 4,3, 3,3, 2,3, 1,3, 0,20, -1,-1},	
    /* 16 */
    { 4,60, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,3,
	  1,3, 2,3, 3,3, 4,3, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,3,
	  1,3, 2,3, 3,3, 4,3, 5,3, 6,3, 7,3, 8,3, 9,3, 10,3, 11,3, 12,3, 13,3, 14,3, 15,3, 0,20, -1, -1},
    /* 17 */
    {
	7,15,	8,3,
	9,15,	8,3,
	7,15,	8,3,
	9,15,   8,3,
	7,15,	8,3,
	9,15,	8,3,
	-1,-1,	  
    },
    /* 18 */
    { 12,60, 4,30, 12,30, 4,30, 12,30, 8,20, -1,-1 },
    /* 19 */
    { 10,80, -1,-1, },
    /* 20 */
    { 6,80, -1,-1, },
};	

/* These aren't used anymore! (see filepath.c) Maybe we should nuke them? */
#if 0
/* enter_paths are for new ships.  consists of starting co-ordinates, number of frames
   to wait at the start (presumably offscreen) and a path to follow.
   path -1 means this ship is not used on this level
   at end of path, ship flies into convoy position on it's own from wherever it winds up
*/

/* Not that anyone else is likely to touch this mess, but if you do, I highly recommend doing it
   in emacs M-x picture-mode. */

/* Well, (says gc918206@gbar.dtu.dk (Martin Eskildsen)) I touched... ;-)
 * The problem with the previous implementation was that it relied on the manifest
 * constants WINWIDTH and WINHEIGHT being 400 and 500, respectively (they are in file
 * defs.h) which caused some of the aliens to start on-screen instead of off-screen
 * if you tried to enlarge the window by changing the constants (it's somewhat small
 * on my 14 inch monitor otherwise).
 * I therefore made a couple of scaling macros, below, and applied them to all X- and
 * Y coordinates (it took only one, admittedly, big and ugly emacs macro to do this :-).
 */
#define SX(n) ((WINWIDTH*(n))/400)
#define SY(n) ((WINHEIGHT*(n))/500)
	  
struct enter_path ep[NUMLEVELS][MAXALIENS] = {
    {	  
	{ 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(200), SY(-30), 435, P_ENTER1 },
	{ 0, SX(-1), SY(-1), -1, -1},
        { 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(200), SY(-30), 430, P_ENTER2 },
	{ 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(-1), SY(-1), -1, -1},
	{ 0, SX(-1), SY(-1), -1, -1},
	  
	{ 1, SX(-1), SY(-1), -1, -1},
	{ 1, SX(-1), SY(-1), -1, -1},
	{ 1, SX(200), SY(-30),425, P_ENTER1 },
	{ 1, SX(200), SY(-30),420, P_ENTER2 },
	{ 1, SX(200), SY(-30),415, P_ENTER1 },
	{ 1, SX(200), SY(-30),410, P_ENTER2 },
	{ 1, SX(200), SY(-30),405, P_ENTER1 },
	{ 1, SX(200), SY(-30),400, P_ENTER2 },
	{ 1, SX(-1), SY(-1), -1, -1},
	{ 1, SX(-1), SY(-1), -1, -1},
	             
	{ 2, SX(200), SY(-30),345, P_ENTER1 },
	{ 2, SX(200), SY(-30),340,P_ENTER2 },
	{ 2, SX(200), SY(-30),335, P_ENTER1 },
	{ 2, SX(200), SY(-30),330, P_ENTER2 },
	{ 2, SX(200), SY(-30),325, P_ENTER1 },
	{ 2, SX(200), SY(-30),320, P_ENTER2 },
	{ 2, SX(200), SY(-30),315, P_ENTER1 },
	{ 2, SX(200), SY(-30),310, P_ENTER2 },
	{ 2, SX(200), SY(-30),305, P_ENTER1 },
	{ 2, SX(200), SY(-30),300, P_ENTER2 },
	              
	{ 3, SX(200), SY(-30),245, P_ENTER1 },
	{ 3, SX(200), SY(-30),240, P_ENTER2 },
	{ 3, SX(200), SY(-30),235, P_ENTER1 },
	{ 3, SX(200), SY(-30),230, P_ENTER2 },
	{ 3, SX(200), SY(-30),225, P_ENTER1 },
	{ 3, SX(200), SY(-30),220, P_ENTER2 },
	{ 3, SX(200), SY(-30),215, P_ENTER1 },
	{ 3, SX(200), SY(-30),210, P_ENTER2 },
	{ 3, SX(200), SY(-30),205, P_ENTER1 },
	{ 3, SX(200), SY(-30),200, P_ENTER2 },
	             
	{ 4, SX(200), SY(-30),145, P_ENTER1 },
	{ 4, SX(200), SY(-30),140, P_ENTER2 },
	{ 4, SX(200), SY(-30),135, P_ENTER1 },
	{ 4, SX(200), SY(-30),130, P_ENTER2 },
	{ 4, SX(200), SY(-30),125, P_ENTER1 },
	{ 4, SX(200), SY(-30),120, P_ENTER2 },
	{ 4, SX(200), SY(-30),115, P_ENTER1 },
	{ 4, SX(200), SY(-30),110, P_ENTER2 },
	{ 4, SX(200), SY(-30),105, P_ENTER1 },
	{ 4, SX(200), SY(-30),100, P_ENTER2 },
	             
	{ 5, SX(200), SY(-30), 50, P_ENTER1 },
	{ 5, SX(200), SY(-30), 45, P_ENTER2 },
	{ 5, SX(200), SY(-30), 40, P_ENTER1 },
	{ 5, SX(200), SY(-30), 35, P_ENTER2 },
	{ 5, SX(200), SY(-30), 30, P_ENTER1 },
	{ 5, SX(200), SY(-30), 25, P_ENTER2 },
	{ 5, SX(200), SY(-30), 20, P_ENTER1 },
	{ 5, SX(200), SY(-30), 15, P_ENTER2 },
	{ 5, SX(200), SY(-30), 10, P_ENTER1 },
	{ 5, SX(200), SY(-30),  5, P_ENTER2 },
	  
    },
    {
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(200), SY( -30), 435, P_ENTER1 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(200), SY( -30), 430, P_ENTER2 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(200), SY( -30), 425, P_ENTER1 },
	{ 1, SX(200), SY( -30), 420, P_ENTER2 },
	{ 1, SX(200), SY( -30), 415, P_ENTER1 },
	{ 1, SX(200), SY( -30), 410, P_ENTER2 },
	{ 1, SX(200), SY( -30), 405, P_ENTER1 },
	{ 1, SX(200), SY( -30), 400, P_ENTER2 },
	{ 1, SX( -1), SY(  -1),  -1, -1},	 
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             
	{ 2, SX(410), SY( 125), 345, P_ENTER4 },
	{ 2, SX(410), SY( 125), 340, P_ENTER4 },
	{ 2, SX(410), SY( 125), 335, P_ENTER4 },
	{ 2, SX(410), SY( 125), 330, P_ENTER4 },
	{ 2, SX(410), SY( 125), 325, P_ENTER4 },
	{ 2, SX(410), SY( 125), 320, P_ENTER4 },
	{ 2, SX(410), SY( 125), 315, P_ENTER4 },
	{ 2, SX(410), SY( 125), 310, P_ENTER4 },
	{ 2, SX(410), SY( 125), 305, P_ENTER4 },
	{ 2, SX(410), SY( 125), 300, P_ENTER4 },
	               		 
	{ 3, SX(-30), SY( 125), 245, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 240, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 235, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 230, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 225, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 220, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 215, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 210, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 205, P_ENTER5 },
	{ 3, SX(-30), SY( 125), 200, P_ENTER5 },
	              		 
	{ 4, SX(410), SY( 125), 145, P_ENTER4 },
	{ 4, SX(410), SY( 125), 140, P_ENTER4 },
	{ 4, SX(410), SY( 125), 135, P_ENTER4 },
	{ 4, SX(410), SY( 125), 130, P_ENTER4 },
	{ 4, SX(410), SY( 125), 125, P_ENTER4 },
	{ 4, SX(410), SY( 125), 120, P_ENTER4 },
	{ 4, SX(410), SY( 125), 115, P_ENTER4 },
	{ 4, SX(410), SY( 125), 110, P_ENTER4 },
	{ 4, SX(410), SY( 125), 105, P_ENTER4 },
	{ 4, SX(410), SY( 125), 100, P_ENTER4 },
	              		 
	{ 6, SX(-30), SY( 125),  50, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  45, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  40, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  35, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  30, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  25, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  20, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  15, P_ENTER5 },
	{ 6, SX(-30), SY( 125),  10, P_ENTER5 },
	{ 6, SX(-30), SY( 125),   5, P_ENTER5 },
	        		 
    },
    { /* level 3*/
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 125), 405, P_ENTER5 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 125), 400, P_ENTER5 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(-30), SY( 125), 435, P_ENTER5 },
	{ 1, SX(-30), SY( 125), 430, P_ENTER5 },
	{ 1, SX(-30), SY( 125), 425, P_ENTER5 },
	{ 1, SX(-30), SY( 125), 420, P_ENTER5 },
	{ 1, SX(-30), SY( 125), 415, P_ENTER5 },
	{ 1, SX(-30), SY( 125), 410, P_ENTER5 },
	{ 1, SX( -1), SY(  -1),  -1, -1},	 
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             	  
	{ 2, SX(100), SY( -30), 345, P_ENTER6 },
	{ 2, SX(300), SY( -30), 340, P_ENTER7 },
	{ 2, SX(100), SY( -30), 335, P_ENTER6 },
	{ 2, SX(300), SY( -30), 330, P_ENTER7 },
	{ 2, SX(100), SY( -30), 325, P_ENTER6 },
	{ 2, SX(300), SY( -30), 320, P_ENTER7 },
	{ 2, SX(100), SY( -30), 315, P_ENTER6 },
	{ 2, SX(300), SY( -30), 310, P_ENTER7 },
	{ 2, SX(100), SY( -30), 305, P_ENTER6 },
	{ 2, SX(300), SY( -30), 300, P_ENTER7 },
/*--*/  { 6, SX(100), SY( -30), 245, P_ENTER6 },
	{ 6, SX(300), SY( -30), 240, P_ENTER7 },
	{ 6, SX(100), SY( -30), 235, P_ENTER6 },
	{ 6, SX(300), SY( -30), 230, P_ENTER7 },
	{ 6, SX(100), SY( -30), 225, P_ENTER6 },
	{ 6, SX(300), SY( -30), 220, P_ENTER7 },
	{ 6, SX(100), SY( -30), 215, P_ENTER6 },
	{ 6, SX(300), SY( -30), 210, P_ENTER7 },
	{ 6, SX(100), SY( -30), 205, P_ENTER6 },
	{ 6, SX(300), SY( -30), 200, P_ENTER7 },
/*--*/  { 7, SX(100), SY( -30), 145, P_ENTER6 },
	{ 7, SX(300), SY( -30), 140, P_ENTER7 },
	{ 7, SX(100), SY( -30), 135, P_ENTER6 },
	{ 7, SX(300), SY( -30), 130, P_ENTER7 },
	{ 7, SX(100), SY( -30), 125, P_ENTER6 },
	{ 7, SX(300), SY( -30), 120, P_ENTER7 },
	{ 7, SX(100), SY( -30), 115, P_ENTER6 },
	{ 7, SX(300), SY( -30), 110, P_ENTER7 },
	{ 7, SX(100), SY( -30), 105, P_ENTER6 },
	{ 7, SX(300), SY( -30), 100, P_ENTER7 },
/*--*/  { 7, SX(100), SY( -30),  45, P_ENTER6 },
	{ 7, SX(300), SY( -30),  40, P_ENTER7 },
	{ 7, SX(100), SY( -30),  35, P_ENTER6 },
	{ 7, SX(300), SY( -30),  30, P_ENTER7 },
	{ 7, SX(100), SY( -30),  25, P_ENTER6 },
	{ 7, SX(300), SY( -30),  20, P_ENTER7 },
	{ 7, SX(100), SY( -30),  15, P_ENTER6 },
	{ 7, SX(300), SY( -30),  10, P_ENTER7 },
	{ 7, SX(100), SY( -30),   5, P_ENTER6 },
	{ 7, SX(300), SY( -30),   0, P_ENTER7 },
	                	 
    },
    { /*level 4*/
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(100), SY( 530), 405, P_ENTER8 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX(100), SY( 530), 400, P_ENTER8 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(100), SY( 530), 435, P_ENTER8 },
	{ 1, SX(100), SY( 530), 430, P_ENTER8 },
	{ 1, SX(100), SY( 530), 425, P_ENTER8 },
	{ 1, SX(100), SY( 530), 420, P_ENTER8 },
	{ 1, SX(100), SY( 530), 415, P_ENTER8 },
	{ 1, SX(100), SY( 530), 410, P_ENTER8 },
	{ 1, SX( -1), SY(  -1),  -1, -1},	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	               	
	{ 2, SX(430), SY( 530), 345, P_ENTER12},
	{ 2, SX(430), SY( 530), 340, P_ENTER12},
	{ 2, SX(430), SY( 530), 335, P_ENTER12},
	{ 2, SX(430), SY( 530), 330, P_ENTER12},
	{ 2, SX(430), SY( 530), 325, P_ENTER12},
	{ 2, SX(430), SY( 530), 320, P_ENTER12},
	{ 2, SX(430), SY( 530), 315, P_ENTER12},
	{ 2, SX(430), SY( 530), 310, P_ENTER12},
	{ 2, SX(430), SY( 530), 305, P_ENTER12},
	{ 2, SX(430), SY( 530), 300, P_ENTER12},
/*--*/  { 3, SX(-30), SY( 530), 245, P_ENTER13},
	{ 3, SX(-30), SY( 530), 240, P_ENTER13},
	{ 3, SX(-30), SY( 530), 235, P_ENTER13},
	{ 3, SX(-30), SY( 530), 230, P_ENTER13},
	{ 3, SX(-30), SY( 530), 225, P_ENTER13},
	{ 3, SX(-30), SY( 530), 220, P_ENTER13},
	{ 3, SX(-30), SY( 530), 215, P_ENTER13},
	{ 3, SX(-30), SY( 530), 210, P_ENTER13},
	{ 3, SX(-30), SY( 530), 205, P_ENTER13},
	{ 3, SX(-30), SY( 530), 200, P_ENTER13},
/*--*/  { 7, SX(-30), SY( 250), 145, P_ENTER16},
	{ 7, SX(-30), SY( 250), 140, P_ENTER16},
	{ 7, SX(-30), SY( 250), 135, P_ENTER16},
	{ 7, SX(-30), SY( 250), 130, P_ENTER16},
	{ 7, SX(-30), SY( 250), 125, P_ENTER16},
	{ 7, SX(-30), SY( 250), 120, P_ENTER16},
	{ 7, SX(-30), SY( 250), 115, P_ENTER16},
	{ 7, SX(-30), SY( 250), 110, P_ENTER16},
	{ 7, SX(-30), SY( 250), 105, P_ENTER16},
	{ 7, SX(-30), SY( 250), 100, P_ENTER16},
/*--*/  { 7, SX(430), SY( 250),  45, P_ENTER15},
	{ 7, SX(430), SY( 250),  40, P_ENTER15},
	{ 7, SX(430), SY( 250),  35, P_ENTER15},
	{ 7, SX(430), SY( 250),  30, P_ENTER15},
	{ 7, SX(430), SY( 250),  25, P_ENTER15},
	{ 7, SX(430), SY( 250),  20, P_ENTER15},
	{ 7, SX(430), SY( 250),  15, P_ENTER15},
	{ 7, SX(430), SY( 250),  10, P_ENTER15},
	{ 7, SX(430), SY( 250),   5, P_ENTER15},
	{ 7, SX(430), SY( 250),   0, P_ENTER15},
	                	 
    },
    { /*level 5*/
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(100), SY( 530), 405, P_ENTER8 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX(100), SY( 530), 400, P_ENTER8 },
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(100), SY( 530), 435, P_ENTER8 },
	{ 1, SX(100), SY( 530), 430, P_ENTER8 },
	{ 1, SX(100), SY( 530), 425, P_ENTER8 },
	{ 1, SX(100), SY( 530), 420, P_ENTER8 },
	{ 1, SX(100), SY( 530), 415, P_ENTER8 },
	{ 1, SX(100), SY( 530), 410, P_ENTER8 },
	{ 1, SX( -1), SY(  -1),  -1, -1},	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	               	
	{ 2, SX(430), SY( 530), 345, P_ENTER12},
	{ 2, SX(430), SY( 530), 340, P_ENTER12},
	{ 2, SX(430), SY( 530), 335, P_ENTER12},
	{ 2, SX(430), SY( 530), 330, P_ENTER12},
	{ 2, SX(430), SY( 530), 325, P_ENTER12},
	{ 2, SX(430), SY( 530), 320, P_ENTER12},
	{ 2, SX(430), SY( 530), 315, P_ENTER12},
	{ 2, SX(430), SY( 530), 310, P_ENTER12},
	{ 2, SX(430), SY( 530), 305, P_ENTER12},
	{ 2, SX(430), SY( 530), 300, P_ENTER12},
/*--*/  { 3, SX(-30), SY( 530), 245, P_ENTER13},
	{ 3, SX(-30), SY( 530), 240, P_ENTER13},
	{ 3, SX(-30), SY( 530), 235, P_ENTER13},
	{ 3, SX(-30), SY( 530), 230, P_ENTER13},
	{ 3, SX(-30), SY( 530), 225, P_ENTER13},
	{ 3, SX(-30), SY( 530), 220, P_ENTER13},
	{ 3, SX(-30), SY( 530), 215, P_ENTER13},
	{ 3, SX(-30), SY( 530), 210, P_ENTER13},
	{ 3, SX(-30), SY( 530), 205, P_ENTER13},
	{ 3, SX(-30), SY( 530), 200, P_ENTER13},
/*--*/  { 7, SX(100), SY( 530), 140, P_ENTER8 },
	{ 7, SX(300), SY( 530), 140, P_ENTER9 },
	{ 7, SX(100), SY( 530), 130, P_ENTER8 },
	{ 7, SX(300), SY( 530), 130, P_ENTER9 },
	{ 7, SX(100), SY( 530), 120, P_ENTER8 },
	{ 7, SX(300), SY( 530), 120, P_ENTER9 },
	{ 7, SX(100), SY( 530), 110, P_ENTER8 },
	{ 7, SX(300), SY( 530), 110, P_ENTER9 },
	{ 7, SX(100), SY( 530), 100, P_ENTER8 },
	{ 7, SX(300), SY( 530), 100, P_ENTER9 },
/*--*/  { 7, SX(200), SY( -30),  45, P_ENTER1 },
	{ 7, SX(200), SY( -30),  40, P_ENTER2 },
	{ 7, SX(200), SY( -30),  35, P_ENTER1 },
	{ 7, SX(200), SY( -30),  30, P_ENTER2 },
	{ 7, SX(200), SY( -30),  25, P_ENTER1 },
	{ 7, SX(200), SY( -30),  20, P_ENTER2 },
	{ 7, SX(200), SY( -30),  15, P_ENTER1 },
	{ 7, SX(200), SY( -30),  10, P_ENTER2 },
	{ 7, SX(200), SY( -30),   5, P_ENTER1 },
	{ 7, SX(200), SY( -30),   0, P_ENTER2 },
	                	 
    },
    { /*level 6*/
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},    
	{ 0, SX(-30), SY( 350), 405, P_ENTER14},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},        
	{ 0, SX(-30), SY( 350), 400, P_ENTER14},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},    
	{ 1, SX(-30), SY( 350), 435, P_ENTER14},
	{ 1, SX(-30), SY( 350), 430, P_ENTER14},
	{ 1, SX(-30), SY( 350), 425, P_ENTER14},
	{ 1, SX(-30), SY( 350), 420, P_ENTER14},
	{ 1, SX(-30), SY( 350), 415, P_ENTER14},
	{ 1, SX(-30), SY( 350), 410, P_ENTER14},
	{ 1, SX( -1), SY(  -1),  -1, -1},	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	               	
	{ 2, SX(430), SY( 530), 345, P_ENTER12},
	{ 2, SX(430), SY( 530), 340, P_ENTER12},
	{ 2, SX(430), SY( 530), 335, P_ENTER12},
	{ 2, SX(430), SY( 530), 330, P_ENTER12},
	{ 2, SX(430), SY( 530), 325, P_ENTER12},
	{ 2, SX(430), SY( 530), 320, P_ENTER12},
	{ 2, SX(430), SY( 530), 315, P_ENTER12},
	{ 2, SX(430), SY( 530), 310, P_ENTER12},
	{ 2, SX(430), SY( 530), 305, P_ENTER12},
	{ 2, SX(430), SY( 530), 300, P_ENTER12},
/*--*/  { 6, SX(-30), SY( 530), 245, P_ENTER13},
	{ 6, SX(-30), SY( 530), 240, P_ENTER13},
	{ 6, SX(-30), SY( 530), 235, P_ENTER13},
	{ 6, SX(-30), SY( 530), 230, P_ENTER13},
	{ 6, SX(-30), SY( 530), 225, P_ENTER13},
	{ 6, SX(-30), SY( 530), 220, P_ENTER13},
	{ 6, SX(-30), SY( 530), 215, P_ENTER13},
	{ 6, SX(-30), SY( 530), 210, P_ENTER13},
	{ 6, SX(-30), SY( 530), 205, P_ENTER13},
	{ 6, SX(-30), SY( 530), 200, P_ENTER13},
/*--*/  { 7, SX(100), SY( 530), 145, P_ENTER8 },
	{ 7, SX(100), SY( 530), 140, P_ENTER8 },
	{ 7, SX(100), SY( 530), 135, P_ENTER8 },
	{ 7, SX(100), SY( 530), 130, P_ENTER8 },
	{ 7, SX(100), SY( 530), 125, P_ENTER8 },
	{ 7, SX(100), SY( 530), 120, P_ENTER8 },
	{ 7, SX(100), SY( 530), 115, P_ENTER8 },
	{ 7, SX(100), SY( 530), 110, P_ENTER8 },
	{ 7, SX(100), SY( 530), 105, P_ENTER8 },
	{ 7, SX(100), SY( 530), 100, P_ENTER8 },
/*--*/  { 7, SX(-30), SY( 250),  45, P_ENTER14},
	{ 7, SX(-30), SY( 250),  40, P_ENTER14},
	{ 7, SX(-30), SY( 250),  35, P_ENTER14},
	{ 7, SX(-30), SY( 250),  30, P_ENTER14},
	{ 7, SX(-30), SY( 250),  25, P_ENTER14},
	{ 7, SX(-30), SY( 250),  20, P_ENTER14},
	{ 7, SX(-30), SY( 250),  15, P_ENTER14},
	{ 7, SX(-30), SY( 250),  10, P_ENTER14},
	{ 7, SX(-30), SY( 250),   5, P_ENTER14},
	{ 7, SX(-30), SY( 250),   0, P_ENTER14},	                	     
    },

    { /* level 7 */
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 250), 406, P_ENTER10},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX(430), SY( 250), 400, P_ENTER11},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},

	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(-30), SY( 250), 435, P_ENTER10},
	{ 1, SX(430), SY( 250), 430, P_ENTER11},
	{ 1, SX(-30), SY( 250), 425, P_ENTER10},
	{ 1, SX(430), SY( 250), 420, P_ENTER11},
	{ 1, SX(-30), SY( 250), 415, P_ENTER10},
	{ 1, SX(430), SY( 250), 410, P_ENTER11},
	{ 1, SX( -1), SY(  -1),  -1, -1},	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             	
	{ 2, SX(100), SY( 530), 340, P_ENTER8 },
	{ 2, SX(300), SY( 530), 340, P_ENTER9 },
	{ 2, SX(100), SY( 530), 330, P_ENTER8 },
	{ 2, SX(300), SY( 530), 330, P_ENTER9 },
	{ 2, SX(100), SY( 530), 320, P_ENTER8 },
	{ 2, SX(300), SY( 530), 320, P_ENTER9 },
	{ 2, SX(100), SY( 530), 310, P_ENTER8 },
	{ 2, SX(300), SY( 530), 310, P_ENTER9 },
	{ 2, SX(100), SY( 530), 300, P_ENTER8 },
	{ 2, SX(300), SY( 530), 300, P_ENTER9 },
/*--*/  { 3, SX(100), SY( 530), 240, P_ENTER8 },
	{ 3, SX(300), SY( 530), 240, P_ENTER9 },
	{ 3, SX(100), SY( 530), 230, P_ENTER8 },
	{ 3, SX(300), SY( 530), 230, P_ENTER9 },
	{ 3, SX(100), SY( 530), 220, P_ENTER8 },
	{ 3, SX(300), SY( 530), 220, P_ENTER9 },
	{ 3, SX(100), SY( 530), 210, P_ENTER8 },
	{ 3, SX(300), SY( 530), 210, P_ENTER9 },
	{ 3, SX(100), SY( 530), 200, P_ENTER8 },
	{ 3, SX(300), SY( 530), 200, P_ENTER9 },
/*--*/  { 6, SX(100), SY( 530), 140, P_ENTER8 },
	{ 6, SX(300), SY( 530), 140, P_ENTER9 },
	{ 6, SX(100), SY( 530), 130, P_ENTER8 },
	{ 6, SX(300), SY( 530), 130, P_ENTER9 },
	{ 6, SX(100), SY( 530), 120, P_ENTER8 },
	{ 6, SX(300), SY( 530), 120, P_ENTER9 },
	{ 6, SX(100), SY( 530), 110, P_ENTER8 },
	{ 6, SX(300), SY( 530), 110, P_ENTER9 },
	{ 6, SX(100), SY( 530), 100, P_ENTER8 },
	{ 6, SX(300), SY( 530), 100, P_ENTER9 },
/*--*/  { 6, SX(100), SY( 530),  40, P_ENTER8 },
	{ 6, SX(300), SY( 530),  40, P_ENTER9 },
	{ 6, SX(100), SY( 530),  30, P_ENTER8 },
	{ 6, SX(300), SY( 530),  30, P_ENTER9 },
	{ 6, SX(100), SY( 530),  20, P_ENTER8 },
	{ 6, SX(300), SY( 530),  20, P_ENTER9 },
	{ 6, SX(100), SY( 530),  10, P_ENTER8 },
	{ 6, SX(300), SY( 530),  10, P_ENTER9 },
	{ 6, SX(100), SY( 530),   0, P_ENTER8 },
	{ 6, SX(300), SY( 530),   0, P_ENTER9 },
	                	 
    },
    { /* level 8 */
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 250), 405, P_ENTER16},
	{ 0, SX( -1), SY(  -1),  -1, -1},         
	{ 0, SX( -1), SY(  -1),  -1, -1},        
	{ 0, SX(-30), SY( 250), 400, P_ENTER16},
	{ 0, SX( -1), SY(  -1),  -1, -1},         
	{ 0, SX( -1), SY(  -1),  -1, -1},     
	{ 0, SX( -1), SY(  -1),  -1, -1},     
				      
	{ 1, SX( -1), SY(  -1),  -1, -1},     
	{ 1, SX( -1), SY(  -1),  -1, -1},     
	{ 1, SX(-30), SY( 250), 435, P_ENTER16},
	{ 1, SX(-30), SY( 250), 430, P_ENTER16},
	{ 1, SX(-30), SY( 250), 425, P_ENTER16},
	{ 1, SX(-30), SY( 250), 420, P_ENTER16},
	{ 1, SX(-30), SY( 250), 415, P_ENTER16},
	{ 1, SX(-30), SY( 250), 410, P_ENTER16},
	{ 1, SX( -1), SY(  -1),  -1, -1},         
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             	
	{ 6, SX(-30), SY( 530), 340, P_ENTER13},
	{ 6, SX(430), SY( 530), 340, P_ENTER12},
	{ 6, SX(-30), SY( 530), 330, P_ENTER13},
	{ 6, SX(430), SY( 530), 330, P_ENTER12},
	{ 6, SX(-30), SY( 530), 320, P_ENTER13},
	{ 6, SX(430), SY( 530), 320, P_ENTER12},
	{ 6, SX(-30), SY( 530), 310, P_ENTER13},
	{ 6, SX(430), SY( 530), 310, P_ENTER12},
	{ 6, SX(-30), SY( 530), 300, P_ENTER13},
	{ 6, SX(430), SY( 530), 300, P_ENTER12},
/*--*/  { 7, SX(200), SY( -30), 245, P_ENTER2 },
	{ 7, SX(200), SY( -30), 240, P_ENTER2 },
	{ 7, SX(200), SY( -30), 235, P_ENTER2 },
	{ 7, SX(200), SY( -30), 230, P_ENTER2 },
	{ 7, SX(200), SY( -30), 225, P_ENTER2 },
	{ 7, SX(200), SY( -30), 220, P_ENTER2 },
	{ 7, SX(200), SY( -30), 215, P_ENTER2 },
	{ 7, SX(200), SY( -30), 210, P_ENTER2 },
	{ 7, SX(200), SY( -30), 205, P_ENTER2 },
	{ 7, SX(200), SY( -30), 200, P_ENTER2 },
/*--*/  { 8, SX(200), SY( -30),  95, P_ENTER17},
	{ 8, SX(200), SY( -30),  90, P_ENTER17},
	{ 8, SX(200), SY( -30),  85, P_ENTER17},
	{ 8, SX(200), SY( -30),  80, P_ENTER17},
	{ 8, SX(200), SY( -30),  75, P_ENTER17},
	{ 8, SX(200), SY( -30),  70, P_ENTER17},
	{ 8, SX(200), SY( -30),  65, P_ENTER17},
	{ 8, SX(200), SY( -30),  60, P_ENTER17},
	{ 8, SX(200), SY( -30),  55, P_ENTER17},
	{ 8, SX(200), SY( -30),  50, P_ENTER17},
/*--*/  { 8, SX(200), SY( -30),  45, P_ENTER17},
	{ 8, SX(200), SY( -30),  40, P_ENTER17},
	{ 8, SX(200), SY( -30),  35, P_ENTER17},
	{ 8, SX(200), SY( -30),  30, P_ENTER17},
	{ 8, SX(200), SY( -30),  25, P_ENTER17},
	{ 8, SX(200), SY( -30),  20, P_ENTER17},
	{ 8, SX(200), SY( -30),  15, P_ENTER17},
	{ 8, SX(200), SY( -30),  10, P_ENTER17},
	{ 8, SX(200), SY( -30),   5, P_ENTER17},
	{ 8, SX(200), SY( -30),   0, P_ENTER17},
	                	 
    },
    { /* level 9 */
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 250), 405, P_ENTER16},
	{ 0, SX( -1), SY(  -1),  -1, -1},         
	{ 0, SX( -1), SY(  -1),  -1, -1},        
	{ 0, SX(-30), SY( 250), 400, P_ENTER16},
	{ 0, SX( -1), SY(  -1),  -1, -1},         
	{ 0, SX( -1), SY(  -1),  -1, -1},     
	{ 0, SX( -1), SY(  -1),  -1, -1},     
	        		      
	{ 1, SX( -1), SY(  -1),  -1, -1},     
	{ 1, SX( -1), SY(  -1),  -1, -1},     
	{ 1, SX(-30), SY( 250), 435, P_ENTER16},
	{ 1, SX(-30), SY( 250), 430, P_ENTER16},
	{ 1, SX(-30), SY( 250), 425, P_ENTER16},
	{ 1, SX(-30), SY( 250), 420, P_ENTER16},
	{ 1, SX(-30), SY( 250), 415, P_ENTER16},
	{ 1, SX(-30), SY( 250), 410, P_ENTER16},
	{ 1, SX( -1), SY(  -1),  -1, -1},         
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             	
	{ 6, SX(100), SY( 530), 340, P_ENTER8 },
	{ 6, SX(300), SY( 530), 340, P_ENTER9 },
	{ 6, SX(100), SY( 530), 330, P_ENTER8 },
	{ 6, SX(300), SY( 530), 330, P_ENTER9 },
	{ 6, SX(100), SY( 530), 320, P_ENTER8 },
	{ 6, SX(300), SY( 530), 320, P_ENTER9 },
	{ 6, SX(100), SY( 530), 310, P_ENTER8 },
	{ 6, SX(300), SY( 530), 310, P_ENTER9 },
	{ 6, SX(100), SY( 530), 300, P_ENTER8 },
	{ 6, SX(300), SY( 530), 300, P_ENTER9 },
/*--*/  { 7, SX(200), SY( -30), 245, P_ENTER1 },
	{ 7, SX(200), SY( -30), 240, P_ENTER1 },
	{ 7, SX(200), SY( -30), 235, P_ENTER1 },
	{ 7, SX(200), SY( -30), 230, P_ENTER1 },
	{ 7, SX(200), SY( -30), 225, P_ENTER1 },
	{ 7, SX(200), SY( -30), 220, P_ENTER1 },
	{ 7, SX(200), SY( -30), 215, P_ENTER1 },
	{ 7, SX(200), SY( -30), 210, P_ENTER1 },
	{ 7, SX(200), SY( -30), 205, P_ENTER1 },
	{ 7, SX(200), SY( -30), 200, P_ENTER1 },
/*--*/  { 8, SX(430), SY( 530), 145, P_ENTER12},
	{ 8, SX(430), SY( 530), 140, P_ENTER12},
	{ 8, SX(430), SY( 530), 135, P_ENTER12},
	{ 8, SX(430), SY( 530), 130, P_ENTER12},
	{ 8, SX(430), SY( 530), 125, P_ENTER12},
	{ 8, SX(430), SY( 530), 120, P_ENTER12},
	{ 8, SX(430), SY( 530), 115, P_ENTER12},
	{ 8, SX(430), SY( 530), 110, P_ENTER12},
	{ 8, SX(430), SY( 530), 105, P_ENTER12},
	{ 8, SX(430), SY( 530), 100, P_ENTER12},
/*--*/  { 9, SX(360), SY( -30),   0, P_ENTER17},/* muahaha! */ 
	{ 9, SX(320), SY( -30),   0, P_ENTER17},
	{ 9, SX(280), SY( -30),   0, P_ENTER17},
	{ 9, SX(240), SY( -30),   0, P_ENTER17},
	{ 9, SX(200), SY( -30),   0, P_ENTER17},
	{ 9, SX(160), SY( -30),   0, P_ENTER17},
	{ 9, SX(120), SY( -30),   0, P_ENTER17},
	{ 9, SX( 80), SY( -30),   0, P_ENTER17},
	{ 9, SX( 40), SY( -30),   0, P_ENTER17},
	{ 9, SX(  0), SY( -30),   0, P_ENTER17},
	       	        	 
    },
    { /* level 10 */
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX(-30), SY( 250), 405, P_ENTER10},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},	 
	{ 0, SX(430), SY( 250), 400, P_ENTER11},
	{ 0, SX( -1), SY(  -1),  -1, -1},	  
	{ 0, SX( -1), SY(  -1),  -1, -1},
	{ 0, SX( -1), SY(  -1),  -1, -1},
	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX( -1), SY(  -1),  -1, -1},
	{ 1, SX(-30), SY( 250), 435, P_ENTER10},
	{ 1, SX(430), SY( 250), 430, P_ENTER11},
	{ 1, SX(-30), SY( 250), 425, P_ENTER10},
	{ 1, SX(430), SY( 250), 420, P_ENTER11},
	{ 1, SX(-30), SY( 250), 415, P_ENTER10},
	{ 1, SX(430), SY( 250), 410, P_ENTER11},
	{ 1, SX( -1), SY(  -1),  -1, -1},	  
	{ 1, SX( -1), SY(  -1),  -1, -1},
	             	            
	{ 7, SX(200), SY( -30), 345, P_ENTER2 },
	{ 7, SX(200), SY( -30), 340, P_ENTER1 },
	{ 7, SX(200), SY( -30), 335, P_ENTER2 },
	{ 7, SX(200), SY( -30), 330, P_ENTER1 },
	{ 7, SX(200), SY( -30), 325, P_ENTER2 },
	{ 7, SX(200), SY( -30), 320, P_ENTER1 },
	{ 7, SX(200), SY( -30), 315, P_ENTER2 },
	{ 7, SX(200), SY( -30), 310, P_ENTER1 },
	{ 7, SX(200), SY( -30), 305, P_ENTER2 },
	{ 7, SX(200), SY( -30), 300, P_ENTER1 },
/*--*/  { 8, SX(430), SY( 250), 245, P_ENTER15},
	{ 8, SX(-30), SY( 250), 240, P_ENTER16},
	{ 8, SX(430), SY( 250), 235, P_ENTER15},
	{ 8, SX(-30), SY( 250), 230, P_ENTER16},
	{ 8, SX(430), SY( 250), 225, P_ENTER15},
	{ 8, SX(-30), SY( 250), 220, P_ENTER16},
	{ 8, SX(430), SY( 250), 215, P_ENTER15},
	{ 8, SX(-30), SY( 250), 210, P_ENTER16},
	{ 8, SX(430), SY( 250), 205, P_ENTER15},
	{ 8, SX(-30), SY( 250), 200, P_ENTER16},
/*--*/  { 9, SX(100), SY( 530), 145, P_ENTER8 },
	{ 9, SX(300), SY( 530), 140, P_ENTER9 },
	{ 9, SX(100), SY( 530), 135, P_ENTER8 },
	{ 9, SX(300), SY( 530), 130, P_ENTER9 },
	{ 9, SX(100), SY( 530), 125, P_ENTER8 },
	{ 9, SX(300), SY( 530), 120, P_ENTER9 },
	{ 9, SX(100), SY( 530), 115, P_ENTER8 },
	{ 9, SX(300), SY( 530), 110, P_ENTER9 },
	{ 9, SX(100), SY( 530), 105, P_ENTER8 },
	{ 9, SX(300), SY( 530), 100, P_ENTER9 },
/*--*/  {10, SX(430), SY( 250),  45, P_ENTER18},
	{10, SX(430), SY( 250),  40, P_ENTER18},
	{10, SX(430), SY( 250),  35, P_ENTER18},
	{10, SX(430), SY( 250),  30, P_ENTER18},
	{10, SX(430), SY( 250),  25, P_ENTER18},
	{10, SX(430), SY( 250),  20, P_ENTER18},
	{10, SX(430), SY( 250),  15, P_ENTER18},
	{10, SX(430), SY( 250),  10, P_ENTER18},
	{10, SX(430), SY( 250),   5, P_ENTER18},
	{10, SX(430), SY( 250),   0, P_ENTER18},
	                	 
    },
    { /* level 11 */
	{11, SX( -1), SY(  -1),  -1, -1},
	{11, SX( -1), SY(  -1),  -1, -1},
	{11, SX( -1), SY(  -1),  -1, -1},
	{11, SX(-30), SY( 250), 405, P_ENTER10},
	{11, SX( -1), SY(  -1),  -1, -1},	  
	{11, SX( -1), SY(  -1),  -1, -1},	 
	{11, SX(430), SY( 250), 400, P_ENTER11},
	{11, SX( -1), SY(  -1),  -1, -1},	  
	{11, SX( -1), SY(  -1),  -1, -1},
	{11, SX( -1), SY(  -1),  -1, -1},
	  
	{12, SX( -1), SY(  -1),  -1, -1},
	{12, SX( -1), SY(  -1),  -1, -1},
	{12, SX(-30), SY( 250), 435, P_ENTER10},
	{12, SX(430), SY( 250), 430, P_ENTER11},
	{12, SX(-30), SY( 250), 425, P_ENTER10},
	{12, SX(430), SY( 250), 420, P_ENTER11},
	{12, SX(-30), SY( 250), 415, P_ENTER10},
	{12, SX(430), SY( 250), 410, P_ENTER11},
	{12, SX( -1), SY(  -1),  -1, -1},	  
	{12, SX( -1), SY(  -1),  -1, -1},
	             	            
	{13, SX(200), SY( -30), 345, P_ENTER2 },
	{13, SX(200), SY( -30), 340, P_ENTER1 },
	{13, SX(200), SY( -30), 335, P_ENTER2 },
	{13, SX(200), SY( -30), 330, P_ENTER1 },
	{13, SX(200), SY( -30), 325, P_ENTER2 },
	{13, SX(200), SY( -30), 320, P_ENTER1 },
	{13, SX(200), SY( -30), 315, P_ENTER2 },
	{13, SX(200), SY( -30), 310, P_ENTER1 },
	{13, SX(200), SY( -30), 305, P_ENTER2 },
	{13, SX(200), SY( -30), 300, P_ENTER1 },
/*--*/  {14, SX(430), SY( 530), 245, P_ENTER12},
	{14, SX(-30), SY( 530), 240, P_ENTER13},
	{14, SX(430), SY( 530), 235, P_ENTER12},
	{14, SX(-30), SY( 530), 230, P_ENTER13},
	{14, SX(430), SY( 530), 225, P_ENTER12},
	{14, SX(-30), SY( 530), 220, P_ENTER13},
	{14, SX(430), SY( 530), 215, P_ENTER12},
	{14, SX(-30), SY( 530), 210, P_ENTER13},
	{14, SX(430), SY( 530), 205, P_ENTER12},
	{14, SX(-30), SY( 530), 200, P_ENTER13},
/*--*/  {15, SX(-30), SY( 530), 145, P_ENTER13},
	{15, SX(-30), SY( 530), 140, P_ENTER13},
	{15, SX(-30), SY( 530), 135, P_ENTER13},
	{15, SX(-30), SY( 530), 130, P_ENTER13},
	{15, SX(-30), SY( 530), 125, P_ENTER13},
	{15, SX(-30), SY( 530), 120, P_ENTER13},
	{15, SX(-30), SY( 530), 115, P_ENTER13},
	{15, SX(-30), SY( 530), 110, P_ENTER13},
	{15, SX(-30), SY( 530), 105, P_ENTER13},
	{15, SX(-30), SY( 530), 100, P_ENTER13},
/*--*/  {16, SX(430), SY( 530),  45, P_ENTER12},
	{16, SX(430), SY( 530),  40, P_ENTER12},
	{16, SX(430), SY( 530),  35, P_ENTER12},
	{16, SX(430), SY( 530),  30, P_ENTER12},
	{16, SX(430), SY( 530),  25, P_ENTER12},
	{16, SX(430), SY( 530),  20, P_ENTER12},
	{16, SX(430), SY( 530),  15, P_ENTER12},
	{16, SX(430), SY( 530),  10, P_ENTER12},
	{16, SX(430), SY( 530),   5, P_ENTER12},
	{16, SX(430), SY( 530),   0, P_ENTER12},
    },	      			     
    { /* level 12 */                    
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX(-30), SY( 250), 405, P_ENTER10},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},        
        {11, SX(430), SY( 250), 400, P_ENTER11},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
                                        
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX(-30), SY( 250), 435, P_ENTER10},
        {12, SX(430), SY( 250), 430, P_ENTER11},
        {12, SX(-30), SY( 250), 425, P_ENTER10},
        {12, SX(430), SY( 250), 420, P_ENTER11},
        {12, SX(-30), SY( 250), 415, P_ENTER10},
        {12, SX(430), SY( 250), 410, P_ENTER11},
        {12, SX( -1), SY(  -1),  -1, -1},         
        {12, SX( -1), SY(  -1),  -1, -1},       
                                        
        {13, SX(200), SY( -30), 345, P_ENTER2 },
        {13, SX(200), SY( -30), 340, P_ENTER1 },
        {13, SX(200), SY( -30), 335, P_ENTER2 },
        {13, SX(200), SY( -30), 330, P_ENTER1 },
        {13, SX(200), SY( -30), 325, P_ENTER2 },
        {13, SX(200), SY( -30), 320, P_ENTER1 },
        {13, SX(200), SY( -30), 315, P_ENTER2 },
        {13, SX(200), SY( -30), 310, P_ENTER1 },
        {13, SX(200), SY( -30), 305, P_ENTER2 },
        {13, SX(200), SY( -30), 300, P_ENTER1 },
/*--*/  {14, SX(430), SY( 250), 245, P_ENTER15},
        {14, SX(-30), SY( 250), 240, P_ENTER16},
        {14, SX(430), SY( 250), 235, P_ENTER15},
        {14, SX(-30), SY( 250), 230, P_ENTER16},
        {14, SX(430), SY( 250), 225, P_ENTER15},
        {14, SX(-30), SY( 250), 220, P_ENTER16},
        {14, SX(430), SY( 250), 215, P_ENTER15},
        {14, SX(-30), SY( 250), 210, P_ENTER16},
        {14, SX(430), SY( 250), 205, P_ENTER15},
        {14, SX(-30), SY( 250), 200, P_ENTER16},
/*--*/  {15, SX(360), SY( -30), 100, P_ENTER17},
        {15, SX(320), SY( -30), 100, P_ENTER17},
        {15, SX(280), SY( -30), 100, P_ENTER17},
        {15, SX(240), SY( -30), 100, P_ENTER17},
        {15, SX(200), SY( -30), 100, P_ENTER17},
        {15, SX(160), SY( -30), 100, P_ENTER17},
        {15, SX(120), SY( -30), 100, P_ENTER17},
        {15, SX( 80), SY( -30), 100, P_ENTER17},
        {15, SX( 40), SY( -30), 100, P_ENTER17},
        {15, SX(  0), SY( -30), 100, P_ENTER17},
/*--*/  {16, SX(360), SY( -30),   0, P_ENTER17},
        {16, SX(320), SY( -30),   0, P_ENTER17},
        {16, SX(280), SY( -30),   0, P_ENTER17},
        {16, SX(240), SY( -30),   0, P_ENTER17},
        {16, SX(200), SY( -30),   0, P_ENTER17},
        {16, SX(160), SY( -30),   0, P_ENTER17},
        {16, SX(120), SY( -30),   0, P_ENTER17},
        {16, SX( 80), SY( -30),   0, P_ENTER17},
        {16, SX( 40), SY( -30),   0, P_ENTER17},
        {16, SX(  0), SY( -30),   0, P_ENTER17},
    },	                             
    { /* level 13 */                    
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX(-30), SY( 250), 405, P_ENTER10},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},        
        {11, SX(430), SY( 250), 400, P_ENTER11},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
                                        
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX(-30), SY( 250), 435, P_ENTER10},
        {12, SX(430), SY( 250), 430, P_ENTER11},
        {12, SX(-30), SY( 250), 425, P_ENTER10},
        {12, SX(430), SY( 250), 420, P_ENTER11},
        {12, SX(-30), SY( 250), 415, P_ENTER10},
        {12, SX(430), SY( 250), 410, P_ENTER11},
        {12, SX( -1), SY(  -1),  -1, -1},         
        {12, SX( -1), SY(  -1),  -1, -1},       
                                        
        {13, SX(200), SY( -30), 345, P_ENTER2 },
        {13, SX(200), SY( -30), 340, P_ENTER1 },
        {13, SX(200), SY( -30), 335, P_ENTER2 },
        {13, SX(200), SY( -30), 330, P_ENTER1 },
        {13, SX(200), SY( -30), 325, P_ENTER2 },
        {13, SX(200), SY( -30), 320, P_ENTER1 },
        {13, SX(200), SY( -30), 315, P_ENTER2 },
        {13, SX(200), SY( -30), 310, P_ENTER1 },
        {13, SX(200), SY( -30), 305, P_ENTER2 },
        {13, SX(200), SY( -30), 300, P_ENTER1 },
/*--*/  {14, SX(430), SY( 250), 245, P_ENTER15},
        {14, SX(-30), SY( 250), 240, P_ENTER16},
        {14, SX(430), SY( 250), 235, P_ENTER15},
        {14, SX(-30), SY( 250), 230, P_ENTER16},
        {14, SX(430), SY( 250), 225, P_ENTER15},
        {14, SX(-30), SY( 250), 220, P_ENTER16},
        {14, SX(430), SY( 250), 215, P_ENTER15},
        {14, SX(-30), SY( 250), 210, P_ENTER16},
        {14, SX(430), SY( 250), 205, P_ENTER15},
        {14, SX(-30), SY( 250), 200, P_ENTER16},
/*--*/  {15, SX(100), SY( 530), 145, P_ENTER8 },
        {15, SX(300), SY( 530), 140, P_ENTER9 },
        {15, SX(100), SY( 530), 135, P_ENTER8 },
        {15, SX(300), SY( 530), 130, P_ENTER9 },
        {15, SX(100), SY( 530), 125, P_ENTER8 },
        {15, SX(300), SY( 530), 120, P_ENTER9 },
        {15, SX(100), SY( 530), 115, P_ENTER8 },
        {15, SX(300), SY( 530), 110, P_ENTER9 },
        {15, SX(100), SY( 530), 105, P_ENTER8 },
        {15, SX(300), SY( 530), 100, P_ENTER9 },
/*--*/  {16, SX(100), SY( 530),  40, P_ENTER8 },
        {16, SX(300), SY( 530),  40, P_ENTER9 },
        {16, SX(100), SY( 530),  30, P_ENTER8 },
        {16, SX(300), SY( 530),  30, P_ENTER9 },
        {16, SX(100), SY( 530),  20, P_ENTER8 },
        {16, SX(300), SY( 530),  20, P_ENTER9 },
        {16, SX(100), SY( 530),  10, P_ENTER8 },
        {16, SX(300), SY( 530),  10, P_ENTER9 },
        {16, SX(100), SY( 530),   0, P_ENTER8 },
        {16, SX(300), SY( 530),   0, P_ENTER9 },
    },
    { /* level 14 */                    
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX(-30), SY( 250), 405, P_ENTER10},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},        
        {11, SX(430), SY( 250), 400, P_ENTER11},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
                                        
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX(-30), SY( 250), 435, P_ENTER10},
        {12, SX(430), SY( 250), 430, P_ENTER11},
        {12, SX(-30), SY( 250), 425, P_ENTER10},
        {12, SX(430), SY( 250), 420, P_ENTER11},
        {12, SX(-30), SY( 250), 415, P_ENTER10},
        {12, SX(430), SY( 250), 410, P_ENTER11},
        {12, SX( -1), SY(  -1),  -1, -1},         
        {12, SX( -1), SY(  -1),  -1, -1},       
                                        
        {13, SX(430), SY( 250), 345, P_ENTER18},
        {13, SX(430), SY( 250), 340, P_ENTER18},
        {13, SX(430), SY( 250), 335, P_ENTER18},
        {13, SX(430), SY( 250), 330, P_ENTER18},
        {13, SX(430), SY( 250), 325, P_ENTER18},
        {13, SX(430), SY( 250), 320, P_ENTER18},
        {13, SX(430), SY( 250), 315, P_ENTER18},
        {13, SX(430), SY( 250), 310, P_ENTER18},
        {13, SX(430), SY( 250), 305, P_ENTER18},
        {13, SX(430), SY( 250), 300, P_ENTER18},
/*--*/  {14, SX(430), SY( 250), 245, P_ENTER18},
        {14, SX(430), SY( 250), 240, P_ENTER18},
        {14, SX(430), SY( 250), 235, P_ENTER18},
        {14, SX(430), SY( 250), 230, P_ENTER18},
        {14, SX(430), SY( 250), 225, P_ENTER18},
        {14, SX(430), SY( 250), 220, P_ENTER18},
        {14, SX(430), SY( 250), 215, P_ENTER18},
        {14, SX(430), SY( 250), 210, P_ENTER18},
        {14, SX(430), SY( 250), 205, P_ENTER18},
        {14, SX(430), SY( 250), 200, P_ENTER18},
/*--*/  {15, SX(-30), SY( -30), 145, P_ENTER20},
        {15, SX(-30), SY( -30), 140, P_ENTER20},
        {15, SX(-30), SY( -30), 135, P_ENTER20},
        {15, SX(-30), SY( -30), 130, P_ENTER20},
        {15, SX(-30), SY( -30), 125, P_ENTER20},
        {15, SX(-30), SY( -30), 120, P_ENTER20},
        {15, SX(-30), SY( -30), 115, P_ENTER20},
        {15, SX(-30), SY( -30), 110, P_ENTER20},
        {15, SX(-30), SY( -30), 105, P_ENTER20},
        {15, SX(-30), SY( -30), 100, P_ENTER20},
/*--*/  {16, SX(430), SY( -30),  45, P_ENTER19},
        {16, SX(430), SY( -30),  40, P_ENTER19},
        {16, SX(430), SY( -30),  35, P_ENTER19},
        {16, SX(430), SY( -30),  30, P_ENTER19},
        {16, SX(430), SY( -30),  25, P_ENTER19},
        {16, SX(430), SY( -30),  20, P_ENTER19},
        {16, SX(430), SY( -30),  15, P_ENTER19},
        {16, SX(430), SY( -30),  10, P_ENTER19},
        {16, SX(430), SY( -30),   5, P_ENTER19},
        {16, SX(430), SY( -30),   0, P_ENTER19},
    },	      	        	     
    { /* level 15 */                    
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX(-30), SY( 250), 405, P_ENTER10},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},        
        {11, SX(430), SY( 250), 400, P_ENTER11},
        {11, SX( -1), SY(  -1),  -1, -1},         
        {11, SX( -1), SY(  -1),  -1, -1},       
        {11, SX( -1), SY(  -1),  -1, -1},       
                                        
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX( -1), SY(  -1),  -1, -1},       
        {12, SX(-30), SY( 250), 435, P_ENTER10},
        {12, SX(430), SY( 250), 430, P_ENTER11},
        {12, SX(-30), SY( 250), 425, P_ENTER10},
        {12, SX(430), SY( 250), 420, P_ENTER11},
        {12, SX(-30), SY( 250), 415, P_ENTER10},
        {12, SX(430), SY( 250), 410, P_ENTER11},
        {12, SX( -1), SY(  -1),  -1, -1},         
        {12, SX( -1), SY(  -1),  -1, -1},       
                                        
        {13, SX(200), SY( -30), 345, P_ENTER2 },
        {13, SX(200), SY( -30), 340, P_ENTER1 },
        {13, SX(200), SY( -30), 335, P_ENTER2 },
        {13, SX(200), SY( -30), 330, P_ENTER1 },
        {13, SX(200), SY( -30), 325, P_ENTER2 },
        {13, SX(200), SY( -30), 320, P_ENTER1 },
        {13, SX(200), SY( -30), 315, P_ENTER2 },
        {13, SX(200), SY( -30), 310, P_ENTER1 },
        {13, SX(200), SY( -30), 305, P_ENTER2 },
        {13, SX(200), SY( -30), 300, P_ENTER1 },
/*--*/  {14, SX(430), SY( 250), 245, P_ENTER15},
        {14, SX(-30), SY( 250), 240, P_ENTER16},
        {14, SX(430), SY( 250), 235, P_ENTER15},
        {14, SX(-30), SY( 250), 230, P_ENTER16},
        {14, SX(430), SY( 250), 225, P_ENTER15},
        {14, SX(-30), SY( 250), 220, P_ENTER16},
        {14, SX(430), SY( 250), 215, P_ENTER15},
        {14, SX(-30), SY( 250), 210, P_ENTER16},
        {14, SX(430), SY( 250), 205, P_ENTER15},
        {14, SX(-30), SY( 250), 200, P_ENTER16},
/*--*/  {15, SX(100), SY( 530), 145, P_ENTER8 },
        {15, SX(300), SY( 530), 140, P_ENTER9 },
        {15, SX(100), SY( 530), 135, P_ENTER8 },
        {15, SX(300), SY( 530), 130, P_ENTER9 },
        {15, SX(100), SY( 530), 125, P_ENTER8 },
        {15, SX(300), SY( 530), 120, P_ENTER9 },
        {15, SX(100), SY( 530), 115, P_ENTER8 },
        {15, SX(300), SY( 530), 110, P_ENTER9 },
        {15, SX(100), SY( 530), 105, P_ENTER8 },
        {15, SX(300), SY( 530), 100, P_ENTER9 },
/*--*/  {16, SX(100), SY( 530),  40, P_ENTER8 },
        {16, SX(300), SY( 530),  40, P_ENTER9 },
        {16, SX(100), SY( 530),  30, P_ENTER8 },
        {16, SX(300), SY( 530),  30, P_ENTER9 },
        {16, SX(100), SY( 530),  20, P_ENTER8 },
        {16, SX(300), SY( 530),  20, P_ENTER9 },
        {16, SX(100), SY( 530),  10, P_ENTER8 },
        {16, SX(300), SY( 530),  10, P_ENTER9 },
        {16, SX(100), SY( 530),   0, P_ENTER8 },
        {16, SX(300), SY( 530),   0, P_ENTER9 },
    },
};

#endif /* This isn't used anymore! Maybe we should nuke it */

void path_dir(int path, int pos, int *dir, int *steer)
{
    *dir =   paths[path][pos][0];
    *steer = paths[path][pos][1];
}

void enter_path_dir(int path, int pos, int *dir, int *steer)
{
    *dir =   get_dir(path,pos);
    *steer = get_duration(path, pos);
}

void start_path(int path, struct alien *al)
{
    int i;

    for(i=0;(i<MAXPATH) && (paths[path][i][0] >= 0);i++) {
	if(paths[path][i][0] == al->dir)
	    break;
	if(paths[path][i][0] < 0) {
	    al->steer = TURNSPEED;
	    al->path = -1;
	    return;
	}
    }
    if(i >= MAXPATH) {
	al->steer = TURNSPEED;
	al->path = -1;
	return;
    }

    al->path = path;
    al->path_pos = i;
    al->steer = paths[path][i][1];
}

void new_alien(int level, int anum, struct alien *al)
{
    if(get_shape(anum) >= 0) {
	al->alive = 1;
	al->dying = 0;
	al->entering = 1;
	get_xy(anum, &al->x, &al->y);
	al->enterdelay = get_delay(anum);
	al->enterdelay /= 1 + ((metaLevel -1) * .5);

	al->path = get_path(anum);
	al->path_pos = 0;
	al->dir = get_dir(al->path, 0);
	al->steer = get_duration(al->path, 0);
	if(metaLevel > 1)
	    al->steer /= 1 + ((metaLevel - 1) * .5);
	/*al->steer -= (metaLevel - 1) * (al->steer / 3);*/

	al->escorting = -1;
	al->shape = getImage(alien_shape[get_shape(anum)]);
    } else {
	al->alive = 0;
    }

    /*
    al->alive = 1;
    al->dying = 0;
    al->x = ep[l][anum].x;
    al->y = ep[l][anum].y;
    al->entering = 1;
    al->enterdelay = ep[l][anum].delay;
    al->path = ep[l][i].path;
    al->path_pos = 0;
    al->dir = paths[ep[l][anum].path][0][0];
    al->steer = 2*(paths[ep[l][anum].path][0][1]/3);
    al->escorting = -1;
    al->shape = getImage(alien_shape[ep[l][i].shape]);
    */
}
