/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.FontStruct;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphics11
extends MyGraphics {
    Graphics G;
    public static int MaxR = 1000000;
    static int[] px = new int[500];
    static int[] py = new int[500];
    int[] xx = new int[64];
    int[] yy = new int[64];
    FontStruct FS = new FontStruct();
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphics11(Graphics graphics) {
        this.G = graphics;
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
        this.G.setColor(color);
        this.G.fillRect(n, n2, n3, n4);
    }

    public void setColor(Color color) {
        this.G.setColor(color);
    }

    public void setColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.getColorType() == 2) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setFillColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject instanceof PointObject && constructionObject.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (constructionObject.getColorType() != 1) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            this.setColor(constructionObject);
            constructionObject.setColorType(n);
        } else {
            this.setColor(constructionObject);
        }
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.G.drawRect((int)d2, (int)d3, (int)d4, (int)d5);
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        if (constructionObject.getColorType() == 1) {
            this.drawThickLine(d2, d3, d4, d5);
        } else {
            this.drawLine(d2, d3, d4, d5);
        }
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.G.drawLine((int)d2, (int)d3, (int)d4, (int)d5);
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        this.drawLine(d2 + 1.0, d3, d4 + 1.0, d5);
        this.drawLine(d2 - 1.0, d3, d4 - 1.0, d5);
        this.drawLine(d2, d3 + 1.0, d4, d5 + 1.0);
        this.drawLine(d2, d3 - 1.0, d4, d5 - 1.0);
        this.drawLine(d2, d3, d4, d5);
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        int n = (int)d6;
        int n2 = (int)(d6 + d7 + 1.0);
        if (d4 < (double)MaxR) {
            this.G.drawArc((int)d2, (int)d3, (int)d4, (int)d5, n, n2 - n);
        } else if (d7 < 1.0) {
            double d8 = d2 + d4 / 2.0;
            double d9 = d3 + d5 / 2.0;
            double d10 = d4 / 2.0;
            double d11 = d5 / 2.0;
            int n3 = (int)(d8 + Math.cos(d6 / 180.0 * Math.PI) * d10);
            int n4 = (int)(d9 - Math.sin(d6 / 180.0 * Math.PI) * d11);
            int n5 = (int)(d8 + Math.cos((d6 + d7) / 180.0 * Math.PI) * d10);
            int n6 = (int)(d9 - Math.sin((d6 + d7) / 180.0 * Math.PI) * d11);
            this.drawLine(n3, n4, n5, n6);
        }
    }

    public void drawThickArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawArc(d2 - 1.0, d3 - 1.0, d4 + 2.0, d4 + 2.0, d6, d7);
        this.drawArc(d2 + 1.0, d3 + 1.0, d4 - 2.0, d4 - 2.0, d6, d7);
        this.drawArc(d2, d3, d4, d5, d6, d7);
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        if (constructionObject.getColorType() == 1) {
            this.drawThickArc(d2, d3, d4, d5, d6, d7);
        } else {
            this.drawArc(d2, d3, d4, d5, d6, d7);
        }
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawString(String string, double d2, double d3) {
        this.G.drawString(string, (int)d2, (int)d3);
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        if (d4 < (double)MaxR) {
            this.G.drawOval((int)d2, (int)d3, (int)d4, (int)d5);
        }
    }

    public void drawThickOval(double d2, double d3, double d4, double d5) {
        this.drawOval(d2, d3, d4, d5);
        this.drawOval(d2 - 1.0, d3 - 1.0, d4 + 2.0, d5 + 2.0);
        this.drawOval(d2 + 1.0, d3 + 1.0, d4 - 2.0, d5 - 2.0);
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        if (constructionObject.getColorType() == 1) {
            this.drawThickOval(d2, d3, d4, d5);
        } else {
            this.drawOval(d2, d3, d4, d5);
        }
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        this.G.fillRect((int)d2, (int)d3, (int)d4, (int)d5);
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawRect((int)d2, (int)d3, (int)d4, (int)d5);
        }
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        int n = (int)d6;
        int n2 = (int)(d6 + d7 + 1.0);
        if (d4 >= (double)MaxR) {
            return;
        }
        this.setFillColor(constructionObject);
        if (bl3) {
            this.G.fillArc((int)d2, (int)d3, (int)(d4 + 1.0), (int)(d5 + 1.0), n, n2 - n);
        } else {
            double d8 = d6 / 180.0 * Math.PI;
            double d9 = (d6 + d7) / 180.0 * Math.PI;
            MyGraphics11.px[0] = (int)((d2 += d4 / 2.0) + d4 / 2.0 * Math.cos(d8));
            MyGraphics11.py[0] = (int)((d3 += d4 / 2.0) - d5 / 2.0 * Math.sin(d8));
            int n3 = 1;
            while (d8 < d9) {
                MyGraphics11.px[n3] = (int)(d2 + d4 / 2.0 * Math.cos(d8 += 0.01282282715750936));
                MyGraphics11.py[n3] = (int)(d3 - d5 / 2.0 * Math.sin(d8));
                if (++n3 < 499) continue;
            }
            MyGraphics11.px[n3] = (int)(d2 + d4 / 2.0 * Math.cos((d6 + d7) / 180.0 * Math.PI));
            MyGraphics11.py[n3] = (int)(d3 - d5 / 2.0 * Math.sin((d6 + d7) / 180.0 * Math.PI));
            this.G.fillPolygon(px, py, ++n3);
            d2 -= d4 / 2.0;
            d3 -= d4 / 2.0;
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawArc((int)d2, (int)d3, (int)d4, (int)d5, n, n2 - n);
        }
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        if (d4 >= (double)MaxR) {
            return;
        }
        if (constructionObject.getColorType() != 3) {
            this.setFillColor(constructionObject);
            this.G.fillOval((int)d2, (int)d3, (int)(d4 + 1.0), (int)(d5 + 1.0));
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawOval((int)d2, (int)d3, (int)d4, (int)d5);
        }
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        int n2;
        this.setFillColor(constructionObject);
        for (n2 = 0; n2 < n; ++n2) {
            this.xx[n2] = (int)dArray[n2];
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.yy[n2] = (int)dArray2[n2];
        }
        if (constructionObject.getColorType() != 3) {
            this.G.fillPolygon(this.xx, this.yy, n);
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawPolygon(this.xx, this.yy, n);
        }
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.G.drawImage(image, n, n2, imageObserver);
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.G.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
    }

    public void setFont(int n, boolean bl) {
        Font font = this.FS.getFont(n, bl);
        if (font != null) {
            this.G.setFont(font);
        } else {
            font = new Font(Global.getParameter("font.name", "dialog"), bl ? 1 : 0, n);
            this.FS.storeFont(n, bl, font);
            this.G.setFont(font);
        }
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public Graphics getGraphics() {
        return this.G;
    }

    public int stringWidth(String string) {
        return this.getFontMetrics().stringWidth(string);
    }

    public int stringHeight(String string) {
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String string) {
        return 0;
    }

    public int drawStringExtended(String string, double d2, double d3) {
        this.drawString(string, d2, d3 + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }
}

