/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import org.web3d.vrml.export.compressors.BitPacker;
import org.web3d.vrml.export.compressors.BitUnpacker;
import org.web3d.vrml.export.compressors.HuffmanNode;
import org.web3d.vrml.export.compressors.IntegerHuffmanNode;

public class HuffmanTable {
    private HashMap values = new HashMap();
    private int totalBits;
    private int dataLength = 0;
    private int maxTagLength;
    private HuffmanNode[][] dtable;

    HuffmanTable() {
    }

    public void setDataLength(int n) {
        this.dataLength = n;
    }

    public int streamBits() {
        return this.totalBits;
    }

    private void calcStreamBits(LinkedList linkedList) {
        this.totalBits = 0;
        this.maxTagLength = 0;
        for (HuffmanNode huffmanNode : linkedList) {
            this.totalBits += huffmanNode.frequency * huffmanNode.tagLength;
            if (huffmanNode.tagLength <= this.maxTagLength) continue;
            this.maxTagLength = huffmanNode.tagLength;
        }
    }

    void addEntry(HuffmanNode huffmanNode) {
        HuffmanNode huffmanNode2 = (HuffmanNode)this.values.get(huffmanNode);
        if (huffmanNode2 != null) {
            huffmanNode2.addCount();
        } else {
            huffmanNode.addCount();
            this.values.put(huffmanNode, huffmanNode);
        }
    }

    public HuffmanNode getEntry(HuffmanNode huffmanNode) {
        HuffmanNode huffmanNode2 = (HuffmanNode)this.values.get(huffmanNode);
        return huffmanNode2;
    }

    public void writeDict(DataOutputStream dataOutputStream) throws IOException {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.values.values());
        int n = this.values.size();
        int n2 = dataOutputStream.size();
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(this.maxTagLength);
        dataOutputStream.writeByte(this.dataLength);
        BitPacker bitPacker = new BitPacker(this.dataLength * n + this.maxTagLength * n + n);
        for (HuffmanNode huffmanNode : linkedList) {
            bitPacker.pack(huffmanNode.tag, this.maxTagLength);
            bitPacker.pack(huffmanNode.tagLength, 5);
            huffmanNode.writeData(bitPacker, this.dataLength);
        }
        byte[] byArray = new byte[bitPacker.size()];
        bitPacker.getResult(byArray);
        n = bitPacker.size();
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray, 0, n);
    }

    public void readDict(InputStream inputStream) throws IOException {
        this.clear();
        byte[] byArray = new byte[4];
        int n = HuffmanTable.readInt(inputStream, byArray);
        this.maxTagLength = inputStream.read();
        this.dataLength = inputStream.read();
        int n2 = HuffmanTable.readInt(inputStream, byArray);
        byte[] byArray2 = new byte[n2];
        inputStream.read(byArray2);
        BitUnpacker bitUnpacker = new BitUnpacker(byArray2);
        this.dtable = new HuffmanNode[this.maxTagLength][2 << this.maxTagLength];
        for (int i = 0; i < n; ++i) {
            IntegerHuffmanNode integerHuffmanNode = new IntegerHuffmanNode();
            int n3 = bitUnpacker.unpack(this.maxTagLength);
            int n4 = bitUnpacker.unpack(5);
            int n5 = bitUnpacker.unpack(this.dataLength);
            integerHuffmanNode.tag = n3;
            integerHuffmanNode.tagLength = n4;
            integerHuffmanNode.setValue(n5);
            this.values.put(integerHuffmanNode, integerHuffmanNode);
            this.dtable[n4 - 1][n3] = integerHuffmanNode;
        }
    }

    public void decode(byte[] byArray, int[] nArray) {
        BitUnpacker bitUnpacker = new BitUnpacker(byArray);
        int n = 0;
        int n2 = 0;
        int n3 = nArray.length;
        int n4 = 0;
        while (n2 < n3) {
            IntegerHuffmanNode integerHuffmanNode;
            if ((integerHuffmanNode = (IntegerHuffmanNode)this.dtable[++n4 - 1][n = n << 1 | bitUnpacker.unpack(1)]) == null || integerHuffmanNode.tagLength != n4) continue;
            nArray[n2++] = integerHuffmanNode.getValue();
            n = 0;
            n4 = 0;
        }
    }

    public void clear() {
        this.values.clear();
    }

    public void computeTags() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.values.values());
        this.computeTags(linkedList);
        this.calcStreamBits(linkedList);
    }

    private void computeTags(LinkedList linkedList) {
        if (this.values.isEmpty()) {
            return;
        }
        Collections.sort(linkedList, HuffmanNode.frequencyComparator);
        HuffmanNode huffmanNode = (HuffmanNode)linkedList.removeFirst();
        while (linkedList.size() > 0) {
            HuffmanNode huffmanNode2 = (HuffmanNode)linkedList.removeFirst();
            HuffmanNode huffmanNode3 = new HuffmanNode();
            huffmanNode3.addChildren(huffmanNode, huffmanNode2);
            this.addNodeInOrder(linkedList, huffmanNode3, HuffmanNode.frequencyComparator);
            huffmanNode = (HuffmanNode)linkedList.removeFirst();
        }
        huffmanNode.collectLeaves(0, 0, linkedList);
        Collections.sort(linkedList, HuffmanNode.tagLengthComparator);
    }

    private void addNodeInOrder(LinkedList linkedList, HuffmanNode huffmanNode, Comparator comparator) {
        ListIterator<HuffmanNode> listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            HuffmanNode huffmanNode2 = (HuffmanNode)listIterator.next();
            if (comparator.compare(huffmanNode2, huffmanNode) <= 0) continue;
            huffmanNode2 = (HuffmanNode)listIterator.previous();
            break;
        }
        listIterator.add(huffmanNode);
    }

    void print(String string, Collection collection) {
        System.out.println(string + "\nentries: " + collection.size() + "\n");
        Collections.sort((LinkedList)collection, IntegerHuffmanNode.dataComparator);
        for (HuffmanNode huffmanNode : collection) {
            System.out.println(huffmanNode.toString() + "\n");
        }
    }

    public void print() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.values.values());
        this.print("\nposition tokens and tags", linkedList);
    }

    private static int readInt(InputStream inputStream, byte[] byArray) throws IOException {
        inputStream.read(byArray);
        byte by = byArray[0];
        int n = byArray[1] & 0xFF;
        int n2 = byArray[2] & 0xFF;
        int n3 = byArray[3] & 0xFF;
        return (by << 24) + (n << 16) + (n2 << 8) + (n3 << 0);
    }
}

