'ASCII theme using the first 8 colors'

from visidata import vd


vd.themes['ascii8'] = dict(
    disp_note_none='',
    disp_truncator='>',
    disp_oddspace='.',
    disp_more_left='<',
    disp_more_right='>',
    disp_error_val='',
    disp_ambig_width=1,

    disp_pending='',
    disp_note_pending=':',
    disp_note_fmtexc='?',
    disp_note_getexc='!',
    disp_note_typeexc='!',

    color_note_pending='bold magenta',
    color_note_type='yellow',
    color_note_row='yellow',

    disp_column_sep='|',
    disp_keycol_sep='|',
    disp_rowtop_sep='|',
    disp_rowmid_sep='|',
    disp_rowbot_sep='|',
    disp_rowend_sep='|',
    disp_keytop_sep='|',
    disp_keymid_sep='|',
    disp_keybot_sep='|',
    disp_endtop_sep='|',
    disp_endmid_sep='|',
    disp_endbot_sep='|',
    disp_selected_note='+',
    disp_sort_asc='^^^^^^',
    disp_sort_desc='vvvvvv',
    color_default='white on black',
    color_default_hdr='bold',
    color_bottom_hdr='underline',
    color_current_row='reverse',
    color_current_col='bold',
    color_current_hdr='bold reverse',
    color_column_sep='blue',
    color_key_col='cyan',
    color_hidden_col='8',
    color_selected_row='yellow',
    color_edit_cell='white',
    color_graph_hidden='blue',
    color_graph_selected='bold',
    color_status_replay='green',

    color_graph_axis='bold',
    color_sidebar='black on blue',
    color_add_pending='green',
    color_change_pending='reverse yellow',
    color_delete_pending='red',
    disp_rstatus_fmt=' {sheet.longname} {sheet.nRows:9d} {sheet.rowtype} {sheet.modifiedStatus} {sheet.options.disp_selected_note}{sheet.nSelectedRows}',
    disp_status_fmt='{sheet.shortcut}> {sheet.name}| ',
    disp_lstatus_max=0,
    disp_status_sep=' | ',
    color_keystrokes='bold black on cyan',
    color_status='bold black on cyan',
    color_error='red',
    color_warning='yellow',
    color_top_status='underline',
    color_active_status='black on cyan',
    color_inactive_status='8 on black',
    color_working='bold white',
    color_longname_status='black on cyan',

    color_menu='black on cyan',
    color_menu_active='yellow on black',
    color_menu_spec='black on green',
    color_menu_help='black on cyan',
    disp_menu_boxchars='||--    ||',
    disp_menu_more='>',
    disp_menu_push='+',
    disp_menu_input='_',
    disp_menu_fmt='7-bit ASCII 3-bit color',
    plot_colors = 'white',
    disp_histogram='*',
    disp_graph_lines_x_charset='||||',
    disp_graph_lines_y_charset='----'
)
