from typing import Any

from stripe import error as error
from stripe.request_metrics import RequestMetrics as RequestMetrics

version: Any
major: Any
minor: Any
patch: Any

def new_default_http_client(*args, **kwargs): ...

class HTTPClient:
    MAX_DELAY: int
    INITIAL_DELAY: float
    MAX_RETRY_AFTER: int
    def __init__(self, verify_ssl_certs: bool = ..., proxy: Any | None = ...) -> None: ...
    def request_with_retries(self, method, url, headers, post_data: Any | None = ...): ...
    def request_stream_with_retries(self, method, url, headers, post_data: Any | None = ...): ...
    def request(self, method, url, headers, post_data: Any | None = ...) -> None: ...
    def request_stream(self, method, url, headers, post_data: Any | None = ...) -> None: ...
    def close(self) -> None: ...

class RequestsClient(HTTPClient):
    name: str
    def __init__(self, timeout: int = ..., session: Any | None = ..., **kwargs) -> None: ...
    def request(self, method, url, headers, post_data: Any | None = ...): ...
    def request_stream(self, method, url, headers, post_data: Any | None = ...): ...
    def close(self) -> None: ...

class UrlFetchClient(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = ..., proxy: Any | None = ..., deadline: int = ...) -> None: ...
    def request(self, method, url, headers, post_data: Any | None = ...): ...
    def request_stream(self, method, url, headers, post_data: Any | None = ...): ...
    def close(self) -> None: ...

class PycurlClient(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = ..., proxy: Any | None = ...) -> None: ...
    def parse_headers(self, data): ...
    def request(self, method, url, headers, post_data: Any | None = ...): ...
    def request_stream(self, method, url, headers, post_data: Any | None = ...): ...
    def close(self) -> None: ...

class Urllib2Client(HTTPClient):
    name: str
    def __init__(self, verify_ssl_certs: bool = ..., proxy: Any | None = ...) -> None: ...
    def request(self, method, url, headers, post_data: Any | None = ...): ...
    def request_stream(self, method, url, headers, post_data: Any | None = ...): ...
    def close(self) -> None: ...
