// a conversation on quines, between Julian Rohrhuber, Jens Gulden and Tim Walters.


// is this quine a cheat?

{ thisFunction.asCompileString ++ ".value" }.value


// ... and Jens Goulden wrote the first proper one:

(
{ |a="", b=""| if (a!="", { a ++ "\"" ++ a.escapeChar($\\).escapeChar($\") ++ "\", \"" ++ b.escapeChar($\\).escapeChar($\") ++ "\"" ++ b }, { thisFunction.value("{ |a=\"\", b=\"\"| if (a!=\"\", { a ++ \"\\\"\" ++ a.escapeChar($\\\\).escapeChar($\\\") ++ \"\\\", \\\"\" ++ b.escapeChar($\\\\).escapeChar($\\\") ++ \"\\\"\" ++ b }, { thisFunction.value(", ") } ) }.value") } ) }.value
)


//" // the quotes mess up the syntax highlighting..



// so, with the addition of a "quote" method, something like this works:

(_ + '.(*' +  quote(_)  + '! 2)').(*"(_ + '.(*' +  quote(_)  + '! 2)')" ! 2)


// but maybe we can make an acoustic quine by sending the code as timecode over audio.


// quine with surplus
// acoustic quine
(



{|x|
	var dt = 0.00019;
	{
	var num, u, t;
		x = x ++ '.(' ++  quote(x)  ++ ')';
		x.do {|x| num = num.add(x.ascii * dt) };
		u = TDuty.ar(Dseq(num), 0, Dseq(num / dt), doneAction:2);
		t = Timer.ar(u);
		SendTrig.ar(u, 0, t);
		u * 0.5
	}.play;
	
	OSCresponder(s.addr, '/tr', { |t,r,msg| (msg[3] / dt + 0.5).asInteger.asAscii.post }).add;''
	
}.("{|x|
	var dt = 0.00019;
	{
	var num, u, t;
		x = x ++ '.(' ++  quote(x)  ++ ')';
		x.do {|x| num = num.add(x.ascii * dt) };
		u = TDuty.ar(Dseq(num), doneAction:2);
		t = Timer.ar(u);
		SendTrig.ar(u, 0, t);
		u * 0.5
	}.play;
	
	OSCresponder(s.addr, '/tr', { |t,r,msg| (msg[3] / dt + 0.5).asInteger.asAscii.post }).add;''
	
}")
)



// here is a short form, folded into a string, suggested by Tim Walters

(
var a = "{|x|
	var dt = 0.00019;
	{
	var num, u, t;
		x = 'var a = ' ++ quote(x) ++ '; a.interpret.(a)';
		x.do {|x| num = num.add(x.ascii * dt) };
		u = TDuty.ar(Dseq(num), doneAction:2);
		t = Timer.ar(u);
		SendTrig.ar(u, 0, t);
		u * 0.5
	}.play;
	
	OSCresponder(s.addr, '/tr', { |t,r,msg| (msg[3] / dt + 0.5).asInteger.asAscii.post }).add;''
	
}"; a.interpret.(a)
);






// Jens Gulden answered and suggested to make the times explicit instead
// folding the top of the quine over the roll
(


{|num|
    var dt = 0.00019;
    {
        var m, u, t;
        num.do({|n, i|
            if ( i != 0 , { m = m.add(0.00836).add(0.00608) });
            n.asString.do({|x| m = m.add(x.ascii * dt)});            
        });
        num = num.add(0.00874).add(0.0076).add(0.01729).add(0.00608).addAll(m).add(0.01767).add(0.00779).add(0.01121);
        u = TDuty.ar(Dseq(num), doneAction:2);
        t = Timer.ar(u);
        SendTrig.ar(u, 0, t);
        u * 0.5
    }.play;

    OSCresponder(s.addr, '/tr', { |t,r,msg| (msg[3] / dt + 0.5).asInteger.asAscii.post }).add;''

}.([ 0.02337, 0.02356, 0.0209, 0.02223, 0.02071, 0.02356, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.02242, 0.01843, 0.02166, 0.00608, 0.019, 0.02204, 0.00608, 0.01159, 0.00608, 0.00912, 0.00874, 0.00912, 0.00912, 0.00912, 0.00931, 0.01083, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.02337, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.02242, 0.01843, 0.02166, 0.00608, 0.02071, 0.00836, 0.00608, 0.02223, 0.00836, 0.00608, 0.02204, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.0209, 0.02223, 0.02071, 0.00874, 0.019, 0.02109, 0.0076, 0.02337, 0.02356, 0.0209, 0.00836, 0.00608, 0.01995, 0.02356, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.01995, 0.01938, 0.00608, 0.0076, 0.00608, 0.01995, 0.00608, 0.00627, 0.01159, 0.00608, 0.00912, 0.00608, 0.00836, 0.00608, 0.02337, 0.00608, 0.02071, 0.00608, 0.01159, 0.00608, 0.02071, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01064, 0.00969, 0.01026, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01026, 0.00912, 0.01064, 0.00779, 0.00608, 0.02375, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.0209, 0.00874, 0.01843, 0.02185, 0.01577, 0.02204, 0.02166, 0.01995, 0.0209, 0.01957, 0.00874, 0.019, 0.02109, 0.0076, 0.02337, 0.02356, 0.0228, 0.02356, 0.00608, 0.02071, 0.00608, 0.01159, 0.00608, 0.02071, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.0228, 0.00874, 0.01843, 0.02185, 0.01881, 0.01995, 0.01995, 0.00608, 0.00798, 0.00608, 0.019, 0.02204, 0.00779, 0.02375, 0.00779, 0.01121, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.02375, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.0209, 0.02223, 0.02071, 0.00608, 0.01159, 0.00608, 0.0209, 0.02223, 0.02071, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01064, 0.01045, 0.00988, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01045, 0.01026, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00931, 0.01045, 0.0095, 0.01083, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01026, 0.00912, 0.01064, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.01235, 0.02052, 0.02052, 0.0076, 0.02071, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00912, 0.01045, 0.01045, 0.01083, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00931, 0.01045, 0.01026, 0.01045, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.0076, 0.00912, 0.00874, 0.00912, 0.00931, 0.00931, 0.0095, 0.00931, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.02223, 0.00608, 0.01159, 0.00608, 0.01596, 0.01292, 0.02223, 0.02204, 0.02299, 0.00874, 0.01843, 0.02166, 0.0076, 0.01292, 0.02185, 0.01919, 0.02147, 0.0076, 0.0209, 0.02223, 0.02071, 0.00779, 0.00836, 0.00608, 0.019, 0.02109, 0.0209, 0.01919, 0.01235, 0.01881, 0.02204, 0.01995, 0.02109, 0.0209, 0.01102, 0.0095, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.02204, 0.00608, 0.01159, 0.00608, 0.01596, 0.01995, 0.02071, 0.01919, 0.02166, 0.00874, 0.01843, 0.02166, 0.0076, 0.02223, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.01577, 0.01919, 0.0209, 0.019, 0.01596, 0.02166, 0.01995, 0.01957, 0.00874, 0.01843, 0.02166, 0.0076, 0.02223, 0.00836, 0.00608, 0.00912, 0.00836, 0.00608, 0.02204, 0.00779, 0.01121, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.00608, 0.02223, 0.00608, 0.00798, 0.00608, 0.00912, 0.00874, 0.01007, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.02375, 0.00874, 0.02128, 0.02052, 0.01843, 0.02299, 0.01121, 0.0019, 0.0019, 0.00608, 0.00608, 0.00608, 0.00608, 0.01501, 0.01577, 0.01273, 0.02166, 0.01919, 0.02185, 0.02128, 0.02109, 0.0209, 0.019, 0.01919, 0.02166, 0.0076, 0.02185, 0.00874, 0.01843, 0.019, 0.019, 0.02166, 0.00836, 0.00608, 0.00741, 0.00893, 0.02204, 0.02166, 0.00741, 0.00836, 0.00608, 0.02337, 0.00608, 0.02356, 0.02204, 0.00836, 0.02166, 0.00836, 0.02071, 0.02185, 0.01957, 0.02356, 0.00608, 0.0076, 0.02071, 0.02185, 0.01957, 0.01729, 0.00969, 0.01767, 0.00608, 0.00893, 0.00608, 0.019, 0.02204, 0.00608, 0.00817, 0.00608, 0.00912, 0.00874, 0.01007, 0.00779, 0.00874, 0.01843, 0.02185, 0.01387, 0.0209, 0.02204, 0.01919, 0.01957, 0.01919, 0.02166, 0.00874, 0.01843, 0.02185, 0.01235, 0.02185, 0.01881, 0.01995, 0.01995, 0.00874, 0.02128, 0.02109, 0.02185, 0.02204, 0.00608, 0.02375, 0.00779, 0.00874, 0.01843, 0.019, 0.019, 0.01121, 0.00741, 0.00741, 0.0019, 0.0019, 0.02375]);

);



// so, we can, after all, wrap it all up into the extension of time..

// this one is currently out of order ...

// indepted to time
(
var a = [ 0.01353, 0.01364, 0.0132, 0.01364, 0.0011, 0.00099, 0.01353, 0.0011, 0.00099, 0.01298, 0.01067, 0.01254, 0.00352, 0.0121, 0.01287, 0.01199, 0.00484, 0.00352, 0.01287, 0.00484, 0.00352, 0.01276, 0.00484, 0.00352, 0.01089, 0.00352, 0.00671, 0.00352, 0.00737, 0.01144, 0.01067, 0.01254, 0.00506, 0.0121, 0.01188, 0.00649, 0.0011, 0.00099, 0.00099, 0.0132, 0.00352, 0.00671, 0.00352, 0.00429, 0.00517, 0.00517, 0.00352, 0.01155, 0.0121, 0.011, 0.01111, 0.01232, 0.01276, 0.01111, 0.011, 0.00352, 0.01276, 0.01221, 0.00352, 0.01276, 0.01155, 0.01199, 0.01111, 0.00429, 0.00352, 0.00473, 0.00473, 0.00352, 0.01089, 0.00352, 0.00473, 0.00473, 0.00352, 0.00429, 0.0044, 0.00429, 0.00352, 0.00473, 0.00473, 0.00352, 0.01089, 0.00352, 0.00473, 0.00473, 0.00352, 0.00429, 0.01298, 0.01067, 0.01254, 0.00352, 0.01067, 0.00352, 0.00671, 0.00352, 0.00429, 0.00352, 0.00473, 0.00473, 0.00352, 0.0132, 0.00506, 0.01067, 0.01265, 0.00737, 0.01221, 0.01199, 0.01232, 0.01155, 0.01188, 0.01111, 0.00913, 0.01276, 0.01254, 0.01155, 0.0121, 0.01133, 0.00352, 0.00473, 0.00473, 0.00352, 0.00429, 0.00649, 0.00429, 0.00352, 0.00473, 0.00473, 0.00352, 0.01089, 0.00352, 0.00473, 0.00473, 0.0011, 0.00099, 0.00099, 0.00099, 0.00429, 0.01067, 0.00506, 0.01089, 0.01221, 0.01188, 0.01188, 0.01111, 0.01089, 0.01276, 0.00352, 0.01353, 0.01364, 0.01089, 0.01364, 0.00352, 0.0044, 0.01089, 0.00352, 0.00517, 0.00352, 0.00528, 0.00506, 0.00528, 0.00528, 0.00528, 0.00539, 0.00539, 0.00451, 0.00506, 0.01254, 0.01221, 0.01287, 0.0121, 0.011, 0.00506, 0.01067, 0.01265, 0.00803, 0.0121, 0.01276, 0.01111, 0.01133, 0.01111, 0.01254, 0.00506, 0.01067, 0.01265, 0.00715, 0.01265, 0.01089, 0.01155, 0.01155, 0.01375, 0.00506, 0.01166, 0.01221, 0.01155, 0.0121, 0.00506, 0.01155, 0.0121, 0.01276, 0.01111, 0.01254, 0.01232, 0.01254, 0.01111, 0.01276, 0.00506, 0.0044, 0.01067, 0.00451, 0.00429, 0.00352, 0.00473, 0.00473, 0.00352, 0.01089, 0.00352, 0.00473, 0.00473, 0.00352, 0.00429, 0.00451, 0.00429, 0.00649, 0.0011, 0.00099, 0.00099, 0.0132, 0.00506, 0.011, 0.01221, 0.00352, 0.01353, 0.01364, 0.0132, 0.01364, 0.00352, 0.0121, 0.01287, 0.01199, 0.00352, 0.00671, 0.00352, 0.0121, 0.01287, 0.01199, 0.00506, 0.01067, 0.011, 0.011, 0.0044, 0.0132, 0.00506, 0.01067, 0.01265, 0.01089, 0.01155, 0.01155, 0.00352, 0.00462, 0.00352, 0.00528, 0.00506, 0.00528, 0.00528, 0.00528, 0.00539, 0.00539, 0.00451, 0.00352, 0.01375, 0.00649, 0.0011, 0.00099, 0.00099, 0.01287, 0.00352, 0.00671, 0.00352, 0.00924, 0.00748, 0.01287, 0.01276, 0.01331, 0.00506, 0.01067, 0.01254, 0.0044, 0.00748, 0.01265, 0.01111, 0.01243, 0.0044, 0.0121, 0.01287, 0.01199, 0.00451, 0.00484, 0.00352, 0.011, 0.01221, 0.0121, 0.01111, 0.00715, 0.01089, 0.01276, 0.01155, 0.01221, 0.0121, 0.00638, 0.0055, 0.00451, 0.00649, 0.0011, 0.00099, 0.00099, 0.01276, 0.00352, 0.00671, 0.00352, 0.00924, 0.01155, 0.01199, 0.01111, 0.01254, 0.00506, 0.01067, 0.01254, 0.0044, 0.01287, 0.00451, 0.00649, 0.0011, 0.00099, 0.00099, 0.00913, 0.01111, 0.0121, 0.011, 0.00924, 0.01254, 0.01155, 0.01133, 0.00506, 0.01067, 0.01254, 0.0044, 0.01287, 0.00484, 0.00352, 0.00528, 0.00484, 0.00352, 0.01276, 0.00451, 0.00649, 0.0011, 0.00099, 0.00099, 0.01287, 0.00352, 0.00462, 0.00352, 0.00528, 0.00506, 0.00583, 0.0011, 0.00099, 0.01375, 0.00506, 0.01232, 0.01188, 0.01067, 0.01331, 0.00649, 0.0011, 0.00099, 0.0011, 0.00099, 0.00869, 0.00913, 0.00737, 0.01254, 0.01111, 0.01265, 0.01232, 0.01221, 0.0121, 0.011, 0.01111, 0.01254, 0.0044, 0.01265, 0.00506, 0.01067, 0.011, 0.011, 0.01254, 0.00484, 0.00352, 0.00429, 0.00517, 0.01276, 0.01254, 0.00429, 0.00484, 0.00352, 0.01353, 0.00352, 0.01364, 0.01276, 0.00484, 0.01254, 0.00484, 0.01199, 0.01265, 0.01133, 0.01364, 0.00352, 0.0044, 0.01199, 0.01265, 0.01133, 0.01001, 0.00561, 0.01023, 0.00352, 0.00517, 0.00352, 0.00528, 0.00506, 0.00528, 0.00528, 0.00528, 0.00539, 0.00539, 0.00451, 0.00506, 0.01067, 0.01265, 0.00803, 0.0121, 0.01276, 0.01111, 0.01133, 0.01111, 0.01254, 0.00506, 0.01067, 0.01265, 0.00715, 0.01265, 0.01089, 0.01155, 0.01155, 0.00506, 0.01232, 0.01221, 0.01265, 0.01276, 0.00352, 0.01375, 0.00451, 0.00506, 0.01067, 0.011, 0.011, 0.00649, 0.00429, 0.00429, 0.0011, 0.00099, 0.0011, 0.01375 ];
a.collect {|c| (c / 0.00011).round.asInteger.asAscii }.join.interpret.(a)

)


// and a concluding question, posed by James McCartney, 09/14/2006:
// If I GPL a quine program, is the output GPL? 
// (nb. a quine is a program whose output is the same program).


