/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORYFILESWIDGET_H
#define _SC_REPOSITORYFILESWIDGET_H

// sc
#include "sublib/TargetId.h"
#include "svn/DirEntry.h"
class RepositoryModel;
class RepositoryLvi;
class DirEntryLvi;
class ActionStorage;
class Project;
class ScCmd;
class ScParam;
class DragInfo;

namespace svn
{
  class Error;
}

// qt
#include <QtGui/QListView>
class QPopupMenu;



class RepositoryFilesWidget : public QListView, public TargetId
{
  typedef std::map<sc::String,DirEntryLvi*> Entries;

  typedef QListView super;
  Q_OBJECT 

public:
  RepositoryFilesWidget( RepositoryModel* rpModel, QWidget* eventTarget,
    QWidget *parent=0, const char *name=0 );
  virtual ~RepositoryFilesWidget();

  void focusInEvent( QFocusEvent* );
  void focusOutEvent( QFocusEvent* );
  void clear();

  void customEvent( QCustomEvent* ce );  ///<  QWidget overwrite

  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  QDragObject* dragObject();

  QPopupMenu* getMenu();

  void reload();

public slots:
  void updateView();
  void contextMenuRequest( QListViewItem* item, const QPoint& p ,int col );
  void expanded( QListViewItem* item );
  void collapsed( QListViewItem* item );
  void doubleClicked( QListViewItem* item, const QPoint& p, int col );

  void proplist( QListViewItem* item );
  void log();
  void blame();
  void branch();
  void tag();
  void switchx();
  void diff();
  void merge();
  void mkdir();
  void import();
  void exportx();
  void checkout();
  void remove();
  void loggraph();

signals:
  void prjChanged( Project* prj );
  
private slots:
  void itemRenamed( QListViewItem* item, int col, const QString& text );
  void updateSelection();
  void updateViewTree();
  void list( const sc::String& url, bool reload );
  void dragTimeout();

private:
  void getSelection( svn::DirEntries& entries );

private:
  RepositoryModel* _rpModel;
  QWidget*         _eventTarget;

  ActionStorage*   _actions;
  QPopupMenu*      _menu;
  Entries          _entries;      ///< used to remove duplicates

  bool             _doubleClick;  ///< expanded/collapsed triggerd by double click?
  bool             _clearItems;   ///< clear item on next update?

  DragInfo*        _dragInfo;     ///< temporary drag&drop info
};

#endif // _SC_REPOSITORYFILESWIDGET_H
