/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "CommandStartedFinishedTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/ConfigManager.h"
#include "subcommander/WcViewModel.h"
#include "subcommander/Bookmark.h"
#include "subcommander/ScModel.h"
#include "sublib/TargetRepository.h"

// qt
#include <QtGui/QApplication>


class CommandStartedFinishedTest::TestBookmark : public Bookmark
{
public:
  TestBookmark() : Bookmark( NULL, 1, 0 )
  {
  }

  bool getUpdate() const
  {
    return false;
  }
};

class CommandStartedFinishedTest::TestScModel : public ScModel
{
public:
  TestScModel( ConfigManager* cm ) : ScModel(cm)
  {
  }

  void runAsync( ScCmd* cmd, CmdProgressCallback* pcb )
  {
    runSync(cmd,pcb);
  }
};


void CommandStartedFinishedTest::setUp()
{
  TargetRepository::setup();
  _started = 0;
  _finished = 0;

  _bm = new TestBookmark();
  _cm = new ConfigManager();
  _sc = new TestScModel(_cm);

  _viewModel = new WcViewModel( _bm, _sc );

  connect(
    _viewModel, SIGNAL(commandStarted(Bookmark*)), this, SLOT(started(Bookmark*)));
  connect(
    _viewModel, SIGNAL(commandFinished(Bookmark*)), this, SLOT(finished(Bookmark*)));
}

void CommandStartedFinishedTest::tearDown()
{
  delete _viewModel;
  delete _sc;
  delete _cm;
  delete _bm;
  TargetRepository::teardown();
}

void CommandStartedFinishedTest::run()
{
  _viewModel->status( sc::String("path"), false );

#ifdef Q_WS_MAC
  sleep(1); // MacOSX needs some time to queue the event... !?
#endif // Q_WS_MAC
  
  qApp->processEvents();

  CPPUNIT_ASSERT( _started == 1 );
  CPPUNIT_ASSERT( _finished == 1 );
}

void CommandStartedFinishedTest::started( Bookmark* bm )
{
  _started++;
  CPPUNIT_ASSERT_EQUAL( _bm, bm );
}

void CommandStartedFinishedTest::finished( Bookmark* bm )
{
  _finished++;
  CPPUNIT_ASSERT_EQUAL( _bm, bm );
}
