# encoding: utf-8
=begin

* Name: SiSU

** Description: documents, structuring, processing, publishing, search
*** system environment, debug related

** Author: Ralph Amissah
  <ralph@amissah.com>
  <ralph.amissah@gmail.com>

** Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
  2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015 Ralph Amissah,
  All Rights Reserved.

** License: GPL 3 or later:

  SiSU, a framework for document structuring, publishing and search

  Copyright (C) Ralph Amissah

  This program is free software: you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation, either version 3 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program. If not, see <http://www.gnu.org/licenses/>.

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
  <http://www.fsf.org/licensing/licenses/gpl.html>
  <http://www.gnu.org/licenses/gpl.html>

  <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

** SiSU uses:
  * Standard SiSU markup syntax,
  * Standard SiSU meta-markup syntax, and the
  * Standard SiSU object citation numbering and system

** Hompages:
  <http://www.jus.uio.no/sisu>
  <http://www.sisudoc.org>

** Git
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
  <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/utils_composite.rb;hb=HEAD>

=end
module SiSU_Composite_Doc_Utils
  def inserts_array(loadfilename)
    IO.readlines(loadfilename,'')
  end
  def insert_filename?(para)
    if para =~ /^<<\s+((?:https?|file):\/\/\S+?\.ss[it])$/ # and NetTest
      url($1.strip)
    elsif para =~/^<<\s*(\S+?\.ss[it])$/
      $1.strip
    end
  end
  def extract_filenames(loadfilename,file_names_arr)
    file_names_arr << loadfilename
    ssi_files=[]
    if loadfilename =~/\S+?\.ss[im]$/
      inserts_array(loadfilename).each do |para|
        filen=insert_filename?(para)
        file_names_arr << filen
        if filen =~/\S+?\.ssi$/
          ssi_files << filen
        end
      end
    end
    ssi_files.each do |fn|
      extract_filenames(fn,file_names_arr)
    end
    file_names_arr.flatten.compact.uniq.sort
  end
  def composite_and_imported_filenames_array(loadfilename)
    file_names_arr=[]
    begin
      if FileTest.file?(loadfilename)
        if loadfilename =~/\S+?\.ss[itm]$/
          if (@opt.act[:verbose][:set]==:on \
          || @opt.act[:verbose_plus][:set]==:on \
          || @opt.act[:maintenance][:set]==:on)
            SiSU_Screen::Ansi.new(
              @opt.act[:color_state][:set],
              'loading:',
              loadfilename,
            ).txt_grey
          end
          file_names_arr=extract_filenames(loadfilename,file_names_arr)
        end
      end
      if (@opt.act[:verbose_plus][:set]==:on \
      || @opt.act[:maintenance][:set]==:on)
        p file_names_arr ;p file_names_arr.length
      end
      file_names_arr
    rescue
      SiSU_Errors::Rescued.new($!,$@,@opt.selections.str,@opt.fns).location do
        __LINE__.to_s + ':' + __FILE__
      end
    ensure
    end
  end
end
__END__
