/* SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Copyright:
 *   2020      Evan Nemerson <evan@nemerson.com>
 */

#define SIMDE_TEST_X86_AVX512_INSN cmplt

#include <test/x86/avx512/test-avx512.h>
#include <simde/x86/avx512/set.h>
#include <simde/x86/avx512/cmplt.h>

static int
test_simde_mm512_cmplt_epi8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_mm512_set_epi8(INT8_C( -77), INT8_C( -25), INT8_C( -46), INT8_C(  46),
                           INT8_C(  13), INT8_C(   4), INT8_C( -85), INT8_C( -85),
                           INT8_C( -84), INT8_C( -54), INT8_C(  24), INT8_C(  27),
                           INT8_C(-115), INT8_C(  32), INT8_C( -88), INT8_C( -66),
                           INT8_C( 113), INT8_C( -86), INT8_C(  24), INT8_C(  39),
                           INT8_C( -74), INT8_C(  61), INT8_C( 110), INT8_C(  70),
                           INT8_C(  64), INT8_C(  85), INT8_C(-108), INT8_C(  -7),
                           INT8_C(-115), INT8_C( -79), INT8_C( -97), INT8_C( -25),
                           INT8_C( 108), INT8_C( -91), INT8_C(  98), INT8_C(  90),
                           INT8_C( -86), INT8_C(-115), INT8_C(  85), INT8_C( -77),
                           INT8_C( -94), INT8_C( -97), INT8_C( 118), INT8_C( -72),
                           INT8_C( -59), INT8_C(   1), INT8_C(   5), INT8_C(  40),
                           INT8_C( -51), INT8_C(-106), INT8_C( -27), INT8_C(-101),
                           INT8_C(  27), INT8_C( -43), INT8_C( -67), INT8_C(-118),
                           INT8_C(   9), INT8_C( -56), INT8_C(-102), INT8_C( -49),
                           INT8_C( -36), INT8_C(  56), INT8_C(  85), INT8_C(  82)),
      simde_mm512_set_epi8(INT8_C(  15), INT8_C( -44), INT8_C(  -4), INT8_C(  65),
                           INT8_C( 115), INT8_C(  75), INT8_C(-128), INT8_C( -29),
                           INT8_C( -41), INT8_C( -89), INT8_C( -75), INT8_C( -12),
                           INT8_C(   8), INT8_C( -18), INT8_C(   0), INT8_C(  50),
                           INT8_C( -20), INT8_C(  66), INT8_C(  59), INT8_C(  42),
                           INT8_C( 112), INT8_C(-128), INT8_C(  83), INT8_C(   7),
                           INT8_C(  66), INT8_C( -29), INT8_C( -70), INT8_C(  42),
                           INT8_C(-100), INT8_C(  85), INT8_C( -81), INT8_C( -93),
                           INT8_C(   9), INT8_C( -66), INT8_C( -12), INT8_C(  91),
                           INT8_C(  12), INT8_C(  45), INT8_C( 127), INT8_C(-123),
                           INT8_C( -53), INT8_C(  78), INT8_C(  39), INT8_C(-107),
                           INT8_C(   4), INT8_C( -32), INT8_C( -36), INT8_C(  -2),
                           INT8_C( -88), INT8_C(  39), INT8_C( -66), INT8_C( -14),
                           INT8_C( -93), INT8_C( -77), INT8_C( -69), INT8_C(   8),
                           INT8_C(-103), INT8_C( 105), INT8_C(  72), INT8_C(  -8),
                           INT8_C(  49), INT8_C(-104), INT8_C(  40), INT8_C(  17)),
      UINT64_C(13658143053960466808) },
    { simde_mm512_set_epi8(INT8_C(-103), INT8_C(  71), INT8_C(  97), INT8_C(  13),
                           INT8_C( -23), INT8_C(-103), INT8_C(-115), INT8_C(  49),
                           INT8_C(  20), INT8_C(  -2), INT8_C(  49), INT8_C(  20),
                           INT8_C( -48), INT8_C(  19), INT8_C(  36), INT8_C(   5),
                           INT8_C( 110), INT8_C( -17), INT8_C( -78), INT8_C( -81),
                           INT8_C( -87), INT8_C( -42), INT8_C( -90), INT8_C( -74),
                           INT8_C( -81), INT8_C( -59), INT8_C( -73), INT8_C( 101),
                           INT8_C( -93), INT8_C(  16), INT8_C(  54), INT8_C(-126),
                           INT8_C(  73), INT8_C(-113), INT8_C( -63), INT8_C(   0),
                           INT8_C(  -4), INT8_C( -98), INT8_C(  69), INT8_C( -82),
                           INT8_C(-103), INT8_C(-100), INT8_C( -26), INT8_C(   6),
                           INT8_C( -99), INT8_C(  22), INT8_C(   1), INT8_C(-119),
                           INT8_C(  62), INT8_C( -91), INT8_C( 126), INT8_C( -42),
                           INT8_C( -88), INT8_C( -10), INT8_C(  66), INT8_C(-108),
                           INT8_C(   4), INT8_C( -81), INT8_C(-101), INT8_C( -87),
                           INT8_C( -36), INT8_C( 114), INT8_C( 105), INT8_C(  70)),
      simde_mm512_set_epi8(INT8_C(-106), INT8_C( 118), INT8_C(-104), INT8_C(  91),
                           INT8_C(  22), INT8_C( -65), INT8_C(  99), INT8_C(  90),
                           INT8_C( -59), INT8_C( 121), INT8_C(  74), INT8_C(  82),
                           INT8_C(  17), INT8_C( -59), INT8_C(  19), INT8_C(-103),
                           INT8_C(  84), INT8_C(  62), INT8_C( 105), INT8_C( -37),
                           INT8_C( -29), INT8_C(-118), INT8_C(  43), INT8_C(  43),
                           INT8_C(  33), INT8_C(-102), INT8_C(  -5), INT8_C( -51),
                           INT8_C( -22), INT8_C(   3), INT8_C(  47), INT8_C( -50),
                           INT8_C( -25), INT8_C(  25), INT8_C( -33), INT8_C( -68),
                           INT8_C(  52), INT8_C( -60), INT8_C(  19), INT8_C(-103),
                           INT8_C(  71), INT8_C(  88), INT8_C(  82), INT8_C( -50),
                           INT8_C( -90), INT8_C(  -3), INT8_C( -25), INT8_C(  35),
                           INT8_C(-100), INT8_C( -67), INT8_C(  46), INT8_C(  77),
                           INT8_C( -70), INT8_C(   1), INT8_C(  82), INT8_C( 114),
                           INT8_C( -55), INT8_C(  11), INT8_C( -95), INT8_C( 111),
                           INT8_C(  48), INT8_C(  71), INT8_C(  90), INT8_C( -66)),
      UINT64_C(6879384398415355768) },
    { simde_mm512_set_epi8(INT8_C( -71), INT8_C( 111), INT8_C( -21), INT8_C(  61),
                           INT8_C(   5), INT8_C(  96), INT8_C(  81), INT8_C(   9),
                           INT8_C(-121), INT8_C(  39), INT8_C( -77), INT8_C( 111),
                           INT8_C( -66), INT8_C(  56), INT8_C( -30), INT8_C( -47),
                           INT8_C(  60), INT8_C( -59), INT8_C(  45), INT8_C(  86),
                           INT8_C( -57), INT8_C( -53), INT8_C( 106), INT8_C(  23),
                           INT8_C( -11), INT8_C(  82), INT8_C(  92), INT8_C( -19),
                           INT8_C(  64), INT8_C( 103), INT8_C( -89), INT8_C( -98),
                           INT8_C( -33), INT8_C(  99), INT8_C(  24), INT8_C(  46),
                           INT8_C(  12), INT8_C(  -4), INT8_C( -89), INT8_C( 107),
                           INT8_C( -35), INT8_C(  71), INT8_C(  43), INT8_C( 111),
                           INT8_C( -31), INT8_C( -90), INT8_C(  -5), INT8_C(  22),
                           INT8_C(  27), INT8_C( -27), INT8_C( -44), INT8_C( 119),
                           INT8_C( -73), INT8_C(  55), INT8_C(-108), INT8_C( -98),
                           INT8_C( 121), INT8_C(-114), INT8_C(  51), INT8_C(  28),
                           INT8_C(  69), INT8_C(  37), INT8_C(  17), INT8_C( -56)),
      simde_mm512_set_epi8(INT8_C( -65), INT8_C(  52), INT8_C(  -9), INT8_C(  14),
                           INT8_C(  23), INT8_C(-117), INT8_C( 110), INT8_C(  60),
                           INT8_C(  81), INT8_C(-125), INT8_C( 120), INT8_C(  71),
                           INT8_C( 100), INT8_C( -41), INT8_C( 116), INT8_C(-126),
                           INT8_C(-101), INT8_C(  34), INT8_C( -39), INT8_C(  84),
                           INT8_C( -70), INT8_C(-112), INT8_C(  -6), INT8_C( -59),
                           INT8_C(  82), INT8_C(  94), INT8_C(  76), INT8_C( 114),
                           INT8_C( 127), INT8_C( -86), INT8_C( -89), INT8_C(  93),
                           INT8_C(   1), INT8_C( 119), INT8_C( -87), INT8_C( -11),
                           INT8_C( -62), INT8_C( -56), INT8_C( -72), INT8_C( -84),
                           INT8_C(  46), INT8_C(  34), INT8_C( -72), INT8_C(-127),
                           INT8_C(  99), INT8_C( 102), INT8_C(  60), INT8_C(  57),
                           INT8_C( -62), INT8_C( -50), INT8_C( -30), INT8_C(  99),
                           INT8_C( -14), INT8_C(  93), INT8_C( -12), INT8_C(-120),
                           INT8_C( 126), INT8_C(   7), INT8_C(  84), INT8_C(  10),
                           INT8_C( -53), INT8_C( 100), INT8_C( 113), INT8_C( -25)),
      UINT64_C(12369770630542733031) },
    { simde_mm512_set_epi8(INT8_C(  56), INT8_C(  -4), INT8_C(  -4), INT8_C( -38),
                           INT8_C(  25), INT8_C( 103), INT8_C( -62), INT8_C(  92),
                           INT8_C(  31), INT8_C( -43), INT8_C( -18), INT8_C(  90),
                           INT8_C( -11), INT8_C(  80), INT8_C(-102), INT8_C( -32),
                           INT8_C( -48), INT8_C(  -4), INT8_C(-124), INT8_C(-111),
                           INT8_C( 122), INT8_C(  50), INT8_C(  20), INT8_C(  73),
                           INT8_C(  10), INT8_C( -61), INT8_C(  30), INT8_C(  39),
                           INT8_C(  47), INT8_C(  -1), INT8_C( -24), INT8_C(-123),
                           INT8_C(  91), INT8_C(   9), INT8_C( -27), INT8_C(  35),
                           INT8_C(   0), INT8_C( -62), INT8_C( -75), INT8_C( 104),
                           INT8_C(  44), INT8_C(  16), INT8_C(-126), INT8_C(  97),
                           INT8_C( -20), INT8_C( -56), INT8_C( -70), INT8_C( -25),
                           INT8_C(  96), INT8_C( 112), INT8_C( 102), INT8_C(   2),
                           INT8_C( -70), INT8_C( -47), INT8_C(  77), INT8_C( -51),
                           INT8_C( -63), INT8_C(  15), INT8_C( -89), INT8_C( -32),
                           INT8_C(  72), INT8_C( 102), INT8_C( -45), INT8_C(  80)),
      simde_mm512_set_epi8(INT8_C(  46), INT8_C( -69), INT8_C(  -3), INT8_C(   7),
                           INT8_C( -53), INT8_C( -75), INT8_C(-113), INT8_C(  66),
                           INT8_C(-117), INT8_C(  -4), INT8_C( -75), INT8_C(-100),
                           INT8_C( -10), INT8_C(-123), INT8_C( 108), INT8_C(  99),
                           INT8_C(  34), INT8_C(  28), INT8_C(  20), INT8_C(  -3),
                           INT8_C( -41), INT8_C(  37), INT8_C( 126), INT8_C(  37),
                           INT8_C(  86), INT8_C(-126), INT8_C(  57), INT8_C( -79),
                           INT8_C(-102), INT8_C( -22), INT8_C( -65), INT8_C( -86),
                           INT8_C( -13), INT8_C(  63), INT8_C( -35), INT8_C(  12),
                           INT8_C(  52), INT8_C( 115), INT8_C(  54), INT8_C(-115),
                           INT8_C(  85), INT8_C(-123), INT8_C(  -3), INT8_C( -67),
                           INT8_C(  75), INT8_C( -64), INT8_C(  52), INT8_C( 126),
                           INT8_C(  62), INT8_C( -88), INT8_C(  10), INT8_C(  75),
                           INT8_C( -91), INT8_C(  62), INT8_C(  97), INT8_C(  54),
                           INT8_C( -80), INT8_C( -98), INT8_C( -77), INT8_C(  80),
                           INT8_C(  14), INT8_C( 105), INT8_C( -43), INT8_C(  19)),
      UINT64_C(3480141911697332022) },
    { simde_mm512_set_epi8(INT8_C(  30), INT8_C(  13), INT8_C(  72), INT8_C( 124),
                           INT8_C(   6), INT8_C( -85), INT8_C( -61), INT8_C( -45),
                           INT8_C(-117), INT8_C(  64), INT8_C(-110), INT8_C(  -2),
                           INT8_C(  83), INT8_C(  64), INT8_C(  94), INT8_C(  33),
                           INT8_C(  87), INT8_C( -89), INT8_C( -85), INT8_C( -82),
                           INT8_C(  61), INT8_C( -90), INT8_C(  27), INT8_C(-115),
                           INT8_C( -84), INT8_C( -79), INT8_C( -56), INT8_C(  66),
                           INT8_C(  57), INT8_C(  48), INT8_C(  34), INT8_C(  90),
                           INT8_C(  51), INT8_C(  19), INT8_C( 105), INT8_C( -57),
                           INT8_C( -67), INT8_C(-104), INT8_C(   1), INT8_C(-128),
                           INT8_C(  95), INT8_C(  94), INT8_C( -45), INT8_C( -86),
                           INT8_C( 116), INT8_C(  95), INT8_C(  64), INT8_C(-106),
                           INT8_C(  32), INT8_C( -60), INT8_C(-105), INT8_C(  23),
                           INT8_C( 115), INT8_C( -71), INT8_C( -22), INT8_C( -60),
                           INT8_C( -51), INT8_C(  42), INT8_C( -96), INT8_C(  -3),
                           INT8_C(  39), INT8_C( -17), INT8_C(  55), INT8_C(-100)),
      simde_mm512_set_epi8(INT8_C(  33), INT8_C( -73), INT8_C(  56), INT8_C(-105),
                           INT8_C( 103), INT8_C(-109), INT8_C(  18), INT8_C( -30),
                           INT8_C(  97), INT8_C(  18), INT8_C( 119), INT8_C( -24),
                           INT8_C( 104), INT8_C(  64), INT8_C( -85), INT8_C( -21),
                           INT8_C(  18), INT8_C(-115), INT8_C(  98), INT8_C(  20),
                           INT8_C(  51), INT8_C(  30), INT8_C( -90), INT8_C( -24),
                           INT8_C( -99), INT8_C( -91), INT8_C(  11), INT8_C( -84),
                           INT8_C(  56), INT8_C(  98), INT8_C( -91), INT8_C( -93),
                           INT8_C(   0), INT8_C( 119), INT8_C( 113), INT8_C( 107),
                           INT8_C( 103), INT8_C(  96), INT8_C( -68), INT8_C(-127),
                           INT8_C( -84), INT8_C(  51), INT8_C( 103), INT8_C(  56),
                           INT8_C( -12), INT8_C(  53), INT8_C(  32), INT8_C(-117),
                           INT8_C( -90), INT8_C( -10), INT8_C(  29), INT8_C( 115),
                           INT8_C( 127), INT8_C(  10), INT8_C( -23), INT8_C( 108),
                           INT8_C(  92), INT8_C(  -2), INT8_C( -94), INT8_C(  83),
                           INT8_C( -55), INT8_C( 115), INT8_C( -67), INT8_C( -25)),
      UINT64_C(10063351798194798005) },
    { simde_mm512_set_epi8(INT8_C(  30), INT8_C( -62), INT8_C(  -2), INT8_C( 110),
                           INT8_C( -99), INT8_C(   0), INT8_C( 114), INT8_C(-101),
                           INT8_C( -98), INT8_C(-101), INT8_C( 110), INT8_C( 127),
                           INT8_C( -57), INT8_C( 112), INT8_C(   1), INT8_C( -68),
                           INT8_C( -53), INT8_C(  40), INT8_C(  60), INT8_C(  -7),
                           INT8_C( 119), INT8_C( -84), INT8_C(  59), INT8_C(  41),
                           INT8_C(  94), INT8_C(  56), INT8_C( -73), INT8_C(-113),
                           INT8_C(-101), INT8_C(  70), INT8_C(  -5), INT8_C(-102),
                           INT8_C( -24), INT8_C( -88), INT8_C( -82), INT8_C( -98),
                           INT8_C( 103), INT8_C( 114), INT8_C( -24), INT8_C(  -1),
                           INT8_C(  33), INT8_C( -48), INT8_C(  56), INT8_C( -37),
                           INT8_C( -82), INT8_C( 126), INT8_C(  -6), INT8_C( 117),
                           INT8_C(-112), INT8_C( -39), INT8_C(  59), INT8_C(  25),
                           INT8_C( -19), INT8_C(  35), INT8_C( -12), INT8_C( -23),
                           INT8_C(-128), INT8_C( -16), INT8_C( -33), INT8_C( -91),
                           INT8_C( -40), INT8_C( -21), INT8_C( -38), INT8_C(  79)),
      simde_mm512_set_epi8(INT8_C(  42), INT8_C( 118), INT8_C(  39), INT8_C(  16),
                           INT8_C(  45), INT8_C( -16), INT8_C(  38), INT8_C(  64),
                           INT8_C( -47), INT8_C(  99), INT8_C(  10), INT8_C( -26),
                           INT8_C( -31), INT8_C( -27), INT8_C(  -3), INT8_C( 108),
                           INT8_C( -96), INT8_C( -87), INT8_C( -84), INT8_C(   9),
                           INT8_C(  24), INT8_C(  14), INT8_C( 123), INT8_C( -80),
                           INT8_C(   1), INT8_C(  70), INT8_C(  95), INT8_C(   7),
                           INT8_C( -79), INT8_C( -64), INT8_C(  81), INT8_C( -84),
                           INT8_C(-123), INT8_C( -69), INT8_C( -73), INT8_C(  98),
                           INT8_C( -88), INT8_C( 100), INT8_C( -60), INT8_C( 125),
                           INT8_C(  62), INT8_C( -77), INT8_C(  32), INT8_C(  40),
                           INT8_C(  68), INT8_C(  75), INT8_C( 112), INT8_C(-128),
                           INT8_C( -18), INT8_C(  -3), INT8_C(   2), INT8_C(  28),
                           INT8_C( -88), INT8_C(  15), INT8_C( -42), INT8_C(  -1),
                           INT8_C(  10), INT8_C( -70), INT8_C( -90), INT8_C( -93),
                           INT8_C(  65), INT8_C( 119), INT8_C( 107), INT8_C(  29)),
      UINT64_C(16846020600598811022) },
    { simde_mm512_set_epi8(INT8_C(  21), INT8_C( 119), INT8_C(  54), INT8_C( -98),
                           INT8_C(-127), INT8_C(  24), INT8_C( -58), INT8_C(-124),
                           INT8_C(  58), INT8_C(   6), INT8_C(  90), INT8_C( -82),
                           INT8_C(  81), INT8_C(-114), INT8_C( -76), INT8_C( -79),
                           INT8_C(-107), INT8_C( 107), INT8_C( -44), INT8_C(  36),
                           INT8_C(  -3), INT8_C( -89), INT8_C( 118), INT8_C(-104),
                           INT8_C(  90), INT8_C( 122), INT8_C(   4), INT8_C(  68),
                           INT8_C(  34), INT8_C(  55), INT8_C(  65), INT8_C(  86),
                           INT8_C(  74), INT8_C( -50), INT8_C(-117), INT8_C(   7),
                           INT8_C(  11), INT8_C(  -4), INT8_C(  -3), INT8_C( 109),
                           INT8_C( -44), INT8_C( -96), INT8_C(  98), INT8_C(  87),
                           INT8_C( -59), INT8_C(  95), INT8_C( -16), INT8_C( -64),
                           INT8_C( -50), INT8_C(  -5), INT8_C( -97), INT8_C( -47),
                           INT8_C( -88), INT8_C(  77), INT8_C( -27), INT8_C( -13),
                           INT8_C( -76), INT8_C( -43), INT8_C( 104), INT8_C(  53),
                           INT8_C(   4), INT8_C( -45), INT8_C(  81), INT8_C( 115)),
      simde_mm512_set_epi8(INT8_C(  58), INT8_C(  41), INT8_C(  85), INT8_C( -51),
                           INT8_C(   1), INT8_C(  51), INT8_C(  56), INT8_C(-109),
                           INT8_C( 109), INT8_C( 112), INT8_C(  72), INT8_C( -55),
                           INT8_C( -35), INT8_C( -66), INT8_C( -30), INT8_C( -94),
                           INT8_C(  71), INT8_C(  55), INT8_C( 100), INT8_C(  34),
                           INT8_C(  17), INT8_C( 115), INT8_C( 127), INT8_C(  32),
                           INT8_C( 101), INT8_C(  91), INT8_C(  97), INT8_C( -40),
                           INT8_C(  45), INT8_C( -66), INT8_C( -66), INT8_C(  34),
                           INT8_C( -55), INT8_C(  18), INT8_C( -74), INT8_C(  -1),
                           INT8_C(  33), INT8_C( -59), INT8_C(  16), INT8_C( -80),
                           INT8_C(  -4), INT8_C(  84), INT8_C(  30), INT8_C( -62),
                           INT8_C(-115), INT8_C(  37), INT8_C(  41), INT8_C(  57),
                           INT8_C( -41), INT8_C( -67), INT8_C( -77), INT8_C(  48),
                           INT8_C( 113), INT8_C(  84), INT8_C(  44), INT8_C(  98),
                           INT8_C( -38), INT8_C(   2), INT8_C(-122), INT8_C( -26),
                           INT8_C(  77), INT8_C(  90), INT8_C(  30), INT8_C( 127)),
      UINT64_C(13823429244140896205) },
    { simde_mm512_set_epi8(INT8_C( -22), INT8_C( 124), INT8_C(  34), INT8_C( -16),
                           INT8_C(   8), INT8_C( 122), INT8_C(  46), INT8_C(-121),
                           INT8_C(  29), INT8_C(  20), INT8_C(  -3), INT8_C( -93),
                           INT8_C(  62), INT8_C( 115), INT8_C(  28), INT8_C( -90),
                           INT8_C(  27), INT8_C(  21), INT8_C( -60), INT8_C(  15),
                           INT8_C(  72), INT8_C(-113), INT8_C(   5), INT8_C( -77),
                           INT8_C(  42), INT8_C( -54), INT8_C( -42), INT8_C(-118),
                           INT8_C( -22), INT8_C(  63), INT8_C( -17), INT8_C( -10),
                           INT8_C( -67), INT8_C(  58), INT8_C( -23), INT8_C(-108),
                           INT8_C(-119), INT8_C( 102), INT8_C(  88), INT8_C( 112),
                           INT8_C(-126), INT8_C(-115), INT8_C(  -3), INT8_C(  -3),
                           INT8_C( 115), INT8_C( -28), INT8_C(  73), INT8_C(  86),
                           INT8_C(  27), INT8_C( -49), INT8_C(  40), INT8_C(   0),
                           INT8_C(  84), INT8_C(-105), INT8_C( -76), INT8_C( -85),
                           INT8_C(  88), INT8_C( 123), INT8_C(  42), INT8_C(  35),
                           INT8_C(  67), INT8_C( -90), INT8_C(  86), INT8_C( -23)),
      simde_mm512_set_epi8(INT8_C(-115), INT8_C(  -9), INT8_C(  73), INT8_C(  35),
                           INT8_C(-126), INT8_C(-117), INT8_C( -35), INT8_C(  40),
                           INT8_C(-119), INT8_C( -28), INT8_C( -11), INT8_C( -21),
                           INT8_C( -21), INT8_C(  36), INT8_C( -54), INT8_C( -56),
                           INT8_C(  78), INT8_C(   7), INT8_C( -48), INT8_C( -59),
                           INT8_C( 121), INT8_C(  74), INT8_C( -58), INT8_C( 102),
                           INT8_C(  91), INT8_C( 126), INT8_C( -48), INT8_C( 121),
                           INT8_C( -54), INT8_C(  92), INT8_C( -18), INT8_C( 115),
                           INT8_C( -82), INT8_C(-102), INT8_C( -44), INT8_C(  35),
                           INT8_C(  20), INT8_C(-107), INT8_C(  72), INT8_C(  -9),
                           INT8_C( -37), INT8_C( -54), INT8_C( -20), INT8_C( -31),
                           INT8_C(  67), INT8_C(  96), INT8_C( -94), INT8_C(  -5),
                           INT8_C( -22), INT8_C(  67), INT8_C(  22), INT8_C( -62),
                           INT8_C( -72), INT8_C( -76), INT8_C( -32), INT8_C(  86),
                           INT8_C(  -8), INT8_C(  57), INT8_C( -71), INT8_C( -16),
                           INT8_C(-124), INT8_C( -88), INT8_C(  49), INT8_C(  35)),
      UINT64_C(3535798313217705733) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmplt_epi8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask64(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmplt_epu8_mask(SIMDE_MUNIT_TEST_ARGS) {
  const struct {
    simde__m512i a;
    simde__m512i b;
    simde__mmask64 r;
  } test_vec[8] = {
    { simde_x_mm512_set_epu8(UINT8_C(200), UINT8_C( 64), UINT8_C(228), UINT8_C(187),
                             UINT8_C( 53), UINT8_C(115), UINT8_C(212), UINT8_C(224),
                             UINT8_C(234), UINT8_C( 45), UINT8_C(183), UINT8_C(185),
                             UINT8_C(117), UINT8_C(137), UINT8_C(224), UINT8_C( 48),
                             UINT8_C(225), UINT8_C(229), UINT8_C(194), UINT8_C(201),
                             UINT8_C(105), UINT8_C(193), UINT8_C(219), UINT8_C(144),
                             UINT8_C( 87), UINT8_C(205), UINT8_C( 38), UINT8_C(200),
                             UINT8_C( 89), UINT8_C(  3), UINT8_C(155), UINT8_C(245),
                             UINT8_C( 35), UINT8_C(246), UINT8_C( 15), UINT8_C(254),
                             UINT8_C(226), UINT8_C(163), UINT8_C( 22), UINT8_C(135),
                             UINT8_C(105), UINT8_C(246), UINT8_C(210), UINT8_C(152),
                             UINT8_C(131), UINT8_C(226), UINT8_C(111), UINT8_C(207),
                             UINT8_C( 48), UINT8_C(166), UINT8_C( 61), UINT8_C( 72),
                             UINT8_C(115), UINT8_C( 10), UINT8_C(124), UINT8_C( 60),
                             UINT8_C(127), UINT8_C( 50), UINT8_C( 32), UINT8_C( 65),
                             UINT8_C(138), UINT8_C(206), UINT8_C( 67), UINT8_C( 10)),
      simde_x_mm512_set_epu8(UINT8_C(101), UINT8_C(156), UINT8_C(229), UINT8_C( 20),
                             UINT8_C(123), UINT8_C(204), UINT8_C(216), UINT8_C( 73),
                             UINT8_C(103), UINT8_C(232), UINT8_C(253), UINT8_C(122),
                             UINT8_C( 63), UINT8_C(129), UINT8_C(179), UINT8_C(165),
                             UINT8_C(219), UINT8_C( 23), UINT8_C( 44), UINT8_C(209),
                             UINT8_C( 74), UINT8_C(150), UINT8_C(180), UINT8_C(217),
                             UINT8_C( 86), UINT8_C(119), UINT8_C( 26), UINT8_C( 59),
                             UINT8_C(214), UINT8_C( 93), UINT8_C( 27), UINT8_C( 37),
                             UINT8_C( 61), UINT8_C( 47), UINT8_C(126), UINT8_C(138),
                             UINT8_C(246), UINT8_C( 88), UINT8_C(146), UINT8_C(144),
                             UINT8_C(216), UINT8_C( 36), UINT8_C(167), UINT8_C(247),
                             UINT8_C(118), UINT8_C( 82), UINT8_C( 16), UINT8_C(237),
                             UINT8_C(182), UINT8_C(219), UINT8_C( 49), UINT8_C( 46),
                             UINT8_C(225), UINT8_C( 22), UINT8_C(189), UINT8_C( 65),
                             UINT8_C(101), UINT8_C(226), UINT8_C( 23), UINT8_C(220),
                             UINT8_C( 28), UINT8_C( 93), UINT8_C(158), UINT8_C(  8)),
      UINT64_C(7953657163028746066) },
    { simde_x_mm512_set_epu8(UINT8_C( 72), UINT8_C( 33), UINT8_C(154), UINT8_C(122),
                             UINT8_C( 74), UINT8_C(178), UINT8_C( 50), UINT8_C(213),
                             UINT8_C( 98), UINT8_C(217), UINT8_C( 79), UINT8_C(232),
                             UINT8_C(132), UINT8_C(243), UINT8_C(145), UINT8_C(149),
                             UINT8_C( 59), UINT8_C(222), UINT8_C(125), UINT8_C(147),
                             UINT8_C(164), UINT8_C(104), UINT8_C(229), UINT8_C(111),
                             UINT8_C( 98), UINT8_C(138), UINT8_C(193), UINT8_C(124),
                             UINT8_C( 63), UINT8_C(242), UINT8_C(  1), UINT8_C( 40),
                             UINT8_C(135), UINT8_C(187), UINT8_C(113), UINT8_C(230),
                             UINT8_C(208), UINT8_C(113), UINT8_C(106), UINT8_C( 33),
                             UINT8_C(173), UINT8_C( 82), UINT8_C( 93), UINT8_C(149),
                             UINT8_C(  4), UINT8_C(122), UINT8_C( 61), UINT8_C( 54),
                             UINT8_C(106), UINT8_C(212), UINT8_C( 67), UINT8_C(253),
                             UINT8_C(216), UINT8_C(134), UINT8_C(207), UINT8_C( 61),
                             UINT8_C(208), UINT8_C( 81), UINT8_C(150), UINT8_C(127),
                             UINT8_C( 37), UINT8_C(137), UINT8_C(225), UINT8_C( 78)),
      simde_x_mm512_set_epu8(UINT8_C( 96), UINT8_C(106), UINT8_C(154), UINT8_C(  0),
                             UINT8_C(  1), UINT8_C(122), UINT8_C(193), UINT8_C( 25),
                             UINT8_C(239), UINT8_C(152), UINT8_C( 87), UINT8_C( 80),
                             UINT8_C( 31), UINT8_C(133), UINT8_C(251), UINT8_C( 23),
                             UINT8_C(140), UINT8_C(137), UINT8_C(157), UINT8_C(114),
                             UINT8_C( 93), UINT8_C(199), UINT8_C( 63), UINT8_C( 63),
                             UINT8_C(  7), UINT8_C(151), UINT8_C( 52), UINT8_C( 78),
                             UINT8_C(106), UINT8_C( 19), UINT8_C( 61), UINT8_C( 80),
                             UINT8_C(227), UINT8_C( 61), UINT8_C(244), UINT8_C( 16),
                             UINT8_C(153), UINT8_C(241), UINT8_C(118), UINT8_C(250),
                             UINT8_C(216), UINT8_C( 38), UINT8_C(  9), UINT8_C(176),
                             UINT8_C( 88), UINT8_C(222), UINT8_C( 84), UINT8_C(243),
                             UINT8_C(  6), UINT8_C( 75), UINT8_C(  1), UINT8_C(141),
                             UINT8_C(140), UINT8_C( 75), UINT8_C(187), UINT8_C(128),
                             UINT8_C(101), UINT8_C(169), UINT8_C(202), UINT8_C(205),
                             UINT8_C(101), UINT8_C( 13), UINT8_C(249), UINT8_C(158)),
      UINT64_C(14024952834426863995) },
    { simde_x_mm512_set_epu8(UINT8_C(118), UINT8_C(178), UINT8_C(224), UINT8_C( 82),
                             UINT8_C( 86), UINT8_C(103), UINT8_C( 51), UINT8_C( 73),
                             UINT8_C(131), UINT8_C(150), UINT8_C( 58), UINT8_C(120),
                             UINT8_C( 23), UINT8_C(173), UINT8_C( 81), UINT8_C(210),
                             UINT8_C(130), UINT8_C( 18), UINT8_C(188), UINT8_C( 71),
                             UINT8_C( 31), UINT8_C(136), UINT8_C(151), UINT8_C(116),
                             UINT8_C(141), UINT8_C( 84), UINT8_C( 91), UINT8_C( 42),
                             UINT8_C( 78), UINT8_C(105), UINT8_C( 68), UINT8_C(247),
                             UINT8_C(246), UINT8_C( 98), UINT8_C(236), UINT8_C(254),
                             UINT8_C( 34), UINT8_C( 84), UINT8_C(115), UINT8_C(219),
                             UINT8_C( 18), UINT8_C(  7), UINT8_C( 63), UINT8_C(118),
                             UINT8_C( 52), UINT8_C( 47), UINT8_C(109), UINT8_C( 86),
                             UINT8_C( 94), UINT8_C( 32), UINT8_C( 34), UINT8_C(216),
                             UINT8_C(187), UINT8_C(179), UINT8_C( 76), UINT8_C(176),
                             UINT8_C(254), UINT8_C(105), UINT8_C( 86), UINT8_C(220),
                             UINT8_C(  7), UINT8_C( 77), UINT8_C(  8), UINT8_C(213)),
      simde_x_mm512_set_epu8(UINT8_C(139), UINT8_C( 33), UINT8_C( 28), UINT8_C(170),
                             UINT8_C( 51), UINT8_C(116), UINT8_C(243), UINT8_C( 67),
                             UINT8_C(171), UINT8_C( 22), UINT8_C( 12), UINT8_C( 38),
                             UINT8_C(216), UINT8_C(230), UINT8_C(112), UINT8_C( 69),
                             UINT8_C(229), UINT8_C(115), UINT8_C(110), UINT8_C(236),
                             UINT8_C( 84), UINT8_C(115), UINT8_C(237), UINT8_C(235),
                             UINT8_C( 57), UINT8_C(112), UINT8_C( 59), UINT8_C(169),
                             UINT8_C(188), UINT8_C( 43), UINT8_C( 43), UINT8_C(171),
                             UINT8_C(177), UINT8_C( 79), UINT8_C(216), UINT8_C( 10),
                             UINT8_C(218), UINT8_C(219), UINT8_C(205), UINT8_C( 15),
                             UINT8_C(248), UINT8_C( 98), UINT8_C( 68), UINT8_C( 51),
                             UINT8_C(  2), UINT8_C( 76), UINT8_C(147), UINT8_C(206),
                             UINT8_C(115), UINT8_C(128), UINT8_C(102), UINT8_C(116),
                             UINT8_C( 28), UINT8_C(  5), UINT8_C( 73), UINT8_C(210),
                             UINT8_C(179), UINT8_C(184), UINT8_C( 57), UINT8_C( 24),
                             UINT8_C( 10), UINT8_C( 26), UINT8_C(  0), UINT8_C( 23)),
      UINT64_C(10848849723635786056) },
    { simde_x_mm512_set_epu8(UINT8_C( 59), UINT8_C(122), UINT8_C( 87), UINT8_C(211),
                             UINT8_C(197), UINT8_C(251), UINT8_C( 70), UINT8_C(103),
                             UINT8_C( 31), UINT8_C(245), UINT8_C(135), UINT8_C( 65),
                             UINT8_C(214), UINT8_C(158), UINT8_C(167), UINT8_C(  6),
                             UINT8_C(130), UINT8_C( 46), UINT8_C( 33), UINT8_C( 54),
                             UINT8_C( 11), UINT8_C(245), UINT8_C( 84), UINT8_C(244),
                             UINT8_C(176), UINT8_C( 82), UINT8_C(238), UINT8_C(130),
                             UINT8_C(209), UINT8_C(204), UINT8_C(248), UINT8_C(  0),
                             UINT8_C(157), UINT8_C(108), UINT8_C(156), UINT8_C(156),
                             UINT8_C(237), UINT8_C( 39), UINT8_C(113), UINT8_C(164),
                             UINT8_C( 74), UINT8_C( 17), UINT8_C(157), UINT8_C(212),
                             UINT8_C( 94), UINT8_C(225), UINT8_C(154), UINT8_C(241),
                             UINT8_C(234), UINT8_C( 71), UINT8_C( 97), UINT8_C( 49),
                             UINT8_C(235), UINT8_C( 52), UINT8_C(222), UINT8_C( 20),
                             UINT8_C(  5), UINT8_C(231), UINT8_C(123), UINT8_C( 11),
                             UINT8_C( 62), UINT8_C(215), UINT8_C(218), UINT8_C( 46)),
      simde_x_mm512_set_epu8(UINT8_C(124), UINT8_C(178), UINT8_C(245), UINT8_C(131),
                             UINT8_C( 34), UINT8_C(224), UINT8_C( 87), UINT8_C(197),
                             UINT8_C(182), UINT8_C(209), UINT8_C(166), UINT8_C(  5),
                             UINT8_C(234), UINT8_C(185), UINT8_C(158), UINT8_C(144),
                             UINT8_C( 14), UINT8_C(107), UINT8_C(220), UINT8_C( 70),
                             UINT8_C(119), UINT8_C(160), UINT8_C( 31), UINT8_C(191),
                             UINT8_C(230), UINT8_C(198), UINT8_C(152), UINT8_C( 33),
                             UINT8_C( 22), UINT8_C( 95), UINT8_C(212), UINT8_C(255),
                             UINT8_C(113), UINT8_C(254), UINT8_C(  2), UINT8_C(210),
                             UINT8_C(195), UINT8_C(115), UINT8_C(106), UINT8_C(226),
                             UINT8_C( 64), UINT8_C(138), UINT8_C( 67), UINT8_C( 75),
                             UINT8_C( 11), UINT8_C(130), UINT8_C(117), UINT8_C( 51),
                             UINT8_C(106), UINT8_C(104), UINT8_C( 34), UINT8_C(112),
                             UINT8_C( 78), UINT8_C( 85), UINT8_C(189), UINT8_C( 13),
                             UINT8_C(140), UINT8_C( 10), UINT8_C( 60), UINT8_C( 18),
                             UINT8_C(  8), UINT8_C(179), UINT8_C( 57), UINT8_C(196)),
      UINT64_C(16405901789334885521) },
    { simde_x_mm512_set_epu8(UINT8_C(133), UINT8_C( 51), UINT8_C(153), UINT8_C( 32),
                             UINT8_C( 25), UINT8_C(207), UINT8_C(  4), UINT8_C( 40),
                             UINT8_C( 26), UINT8_C( 76), UINT8_C( 93), UINT8_C(  5),
                             UINT8_C(177), UINT8_C(180), UINT8_C(109), UINT8_C(128),
                             UINT8_C(101), UINT8_C( 26), UINT8_C(223), UINT8_C( 68),
                             UINT8_C( 88), UINT8_C(  3), UINT8_C(  1), UINT8_C(148),
                             UINT8_C(  0), UINT8_C(113), UINT8_C( 62), UINT8_C(107),
                             UINT8_C(163), UINT8_C(164), UINT8_C(165), UINT8_C(185),
                             UINT8_C(198), UINT8_C(  6), UINT8_C(199), UINT8_C(198),
                             UINT8_C(207), UINT8_C(139), UINT8_C(  4), UINT8_C( 52),
                             UINT8_C( 26), UINT8_C(160), UINT8_C(162), UINT8_C(224),
                             UINT8_C( 24), UINT8_C(137), UINT8_C(101), UINT8_C( 24),
                             UINT8_C(115), UINT8_C(224), UINT8_C(208), UINT8_C( 54),
                             UINT8_C(102), UINT8_C( 97), UINT8_C(207), UINT8_C( 72),
                             UINT8_C( 87), UINT8_C( 19), UINT8_C(168), UINT8_C(205),
                             UINT8_C( 92), UINT8_C( 79), UINT8_C( 86), UINT8_C(144)),
      simde_x_mm512_set_epu8(UINT8_C( 76), UINT8_C(120), UINT8_C(206), UINT8_C( 35),
                             UINT8_C( 84), UINT8_C(143), UINT8_C(212), UINT8_C( 97),
                             UINT8_C(238), UINT8_C(159), UINT8_C(181), UINT8_C(100),
                             UINT8_C(208), UINT8_C(157), UINT8_C( 32), UINT8_C(247),
                             UINT8_C( 15), UINT8_C(143), UINT8_C(  2), UINT8_C(229),
                             UINT8_C( 17), UINT8_C( 50), UINT8_C(  1), UINT8_C(241),
                             UINT8_C( 90), UINT8_C(132), UINT8_C( 93), UINT8_C( 20),
                             UINT8_C( 46), UINT8_C(183), UINT8_C(154), UINT8_C(255),
                             UINT8_C(118), UINT8_C(135), UINT8_C(  8), UINT8_C(254),
                             UINT8_C(139), UINT8_C(221), UINT8_C(207), UINT8_C(230),
                             UINT8_C(231), UINT8_C( 92), UINT8_C(100), UINT8_C(108),
                             UINT8_C(158), UINT8_C(233), UINT8_C(  8), UINT8_C(234),
                             UINT8_C(189), UINT8_C(236), UINT8_C( 58), UINT8_C(205),
                             UINT8_C(125), UINT8_C(116), UINT8_C(230), UINT8_C(218),
                             UINT8_C(185), UINT8_C(225), UINT8_C( 61), UINT8_C(183),
                             UINT8_C(233), UINT8_C(244), UINT8_C(138), UINT8_C(204)),
      UINT64_C(8933265779370876879) },
    { simde_x_mm512_set_epu8(UINT8_C( 74), UINT8_C(  8), UINT8_C( 71), UINT8_C( 14),
                             UINT8_C(239), UINT8_C(140), UINT8_C( 39), UINT8_C( 68),
                             UINT8_C( 18), UINT8_C(182), UINT8_C(128), UINT8_C(142),
                             UINT8_C( 75), UINT8_C(196), UINT8_C(121), UINT8_C(239),
                             UINT8_C( 67), UINT8_C(139), UINT8_C( 89), UINT8_C( 42),
                             UINT8_C(150), UINT8_C(200), UINT8_C( 22), UINT8_C( 70),
                             UINT8_C( 92), UINT8_C(114), UINT8_C(  0), UINT8_C(232),
                             UINT8_C(121), UINT8_C(124), UINT8_C(100), UINT8_C(100),
                             UINT8_C(142), UINT8_C( 19), UINT8_C(218), UINT8_C(104),
                             UINT8_C(159), UINT8_C(120), UINT8_C(122), UINT8_C( 55),
                             UINT8_C(213), UINT8_C(170), UINT8_C(221), UINT8_C(149),
                             UINT8_C(230), UINT8_C(250), UINT8_C(104), UINT8_C( 36),
                             UINT8_C( 99), UINT8_C( 18), UINT8_C(124), UINT8_C(175),
                             UINT8_C(103), UINT8_C(186), UINT8_C(205), UINT8_C( 43),
                             UINT8_C(141), UINT8_C(148), UINT8_C(140), UINT8_C( 44),
                             UINT8_C(237), UINT8_C(120), UINT8_C(114), UINT8_C(100)),
      simde_x_mm512_set_epu8(UINT8_C(124), UINT8_C(149), UINT8_C( 71), UINT8_C(212),
                             UINT8_C(137), UINT8_C(252), UINT8_C(249), UINT8_C( 42),
                             UINT8_C(167), UINT8_C(191), UINT8_C(236), UINT8_C(252),
                             UINT8_C( 26), UINT8_C( 50), UINT8_C( 98), UINT8_C(162),
                             UINT8_C( 91), UINT8_C(215), UINT8_C( 44), UINT8_C( 48),
                             UINT8_C( 41), UINT8_C(167), UINT8_C( 25), UINT8_C( 39),
                             UINT8_C(183), UINT8_C(181), UINT8_C(250), UINT8_C( 47),
                             UINT8_C(  5), UINT8_C(113), UINT8_C( 48), UINT8_C(195),
                             UINT8_C(111), UINT8_C( 46), UINT8_C( 74), UINT8_C( 84),
                             UINT8_C(145), UINT8_C( 27), UINT8_C(231), UINT8_C(119),
                             UINT8_C( 33), UINT8_C(230), UINT8_C( 22), UINT8_C( 69),
                             UINT8_C( 48), UINT8_C(  7), UINT8_C( 45), UINT8_C(104),
                             UINT8_C( 71), UINT8_C( 82), UINT8_C(107), UINT8_C( 14),
                             UINT8_C( 73), UINT8_C(202), UINT8_C( 78), UINT8_C(132),
                             UINT8_C( 67), UINT8_C( 79), UINT8_C(233), UINT8_C(140),
                             UINT8_C(133), UINT8_C( 99), UINT8_C(202), UINT8_C( 75)),
      UINT64_C(15488110983464961330) },
    { simde_x_mm512_set_epu8(UINT8_C( 78), UINT8_C( 83), UINT8_C(217), UINT8_C( 23),
                             UINT8_C(204), UINT8_C( 27), UINT8_C( 84), UINT8_C( 42),
                             UINT8_C(170), UINT8_C( 43), UINT8_C(212), UINT8_C(144),
                             UINT8_C( 56), UINT8_C(177), UINT8_C(191), UINT8_C(215),
                             UINT8_C( 39), UINT8_C( 30), UINT8_C(  2), UINT8_C(234),
                             UINT8_C( 49), UINT8_C(151), UINT8_C(136), UINT8_C(175),
                             UINT8_C(252), UINT8_C(162), UINT8_C(152), UINT8_C(153),
                             UINT8_C(239), UINT8_C(231), UINT8_C(133), UINT8_C(178),
                             UINT8_C(148), UINT8_C( 35), UINT8_C(158), UINT8_C(129),
                             UINT8_C( 19), UINT8_C(213), UINT8_C( 89), UINT8_C(159),
                             UINT8_C(156), UINT8_C( 31), UINT8_C(228), UINT8_C(142),
                             UINT8_C( 99), UINT8_C( 45), UINT8_C(244), UINT8_C(239),
                             UINT8_C( 20), UINT8_C( 92), UINT8_C(183), UINT8_C( 74),
                             UINT8_C(105), UINT8_C(182), UINT8_C(238), UINT8_C( 27),
                             UINT8_C(161), UINT8_C(150), UINT8_C(240), UINT8_C( 67),
                             UINT8_C( 60), UINT8_C(157), UINT8_C( 26), UINT8_C( 30)),
      simde_x_mm512_set_epu8(UINT8_C(112), UINT8_C(252), UINT8_C(254), UINT8_C(234),
                             UINT8_C(115), UINT8_C(252), UINT8_C(144), UINT8_C(157),
                             UINT8_C(106), UINT8_C(131), UINT8_C(237), UINT8_C( 28),
                             UINT8_C( 29), UINT8_C( 85), UINT8_C(  8), UINT8_C(128),
                             UINT8_C(244), UINT8_C(127), UINT8_C(116), UINT8_C( 60),
                             UINT8_C( 88), UINT8_C(104), UINT8_C(162), UINT8_C(203),
                             UINT8_C(144), UINT8_C( 38), UINT8_C(193), UINT8_C(181),
                             UINT8_C(155), UINT8_C( 59), UINT8_C( 61), UINT8_C(  4),
                             UINT8_C( 63), UINT8_C(240), UINT8_C( 88), UINT8_C( 14),
                             UINT8_C( 73), UINT8_C(125), UINT8_C(224), UINT8_C(117),
                             UINT8_C(118), UINT8_C(109), UINT8_C( 68), UINT8_C( 42),
                             UINT8_C(150), UINT8_C( 79), UINT8_C(167), UINT8_C( 25),
                             UINT8_C( 58), UINT8_C(250), UINT8_C(130), UINT8_C(160),
                             UINT8_C( 75), UINT8_C(145), UINT8_C(152), UINT8_C(149),
                             UINT8_C(134), UINT8_C(252), UINT8_C( 13), UINT8_C(165),
                             UINT8_C(218), UINT8_C( 88), UINT8_C( 59), UINT8_C(228)),
      UINT64_C(17825505917769929051) },
    { simde_x_mm512_set_epu8(UINT8_C( 80), UINT8_C(151), UINT8_C(216), UINT8_C(130),
                             UINT8_C(149), UINT8_C(124), UINT8_C( 37), UINT8_C( 84),
                             UINT8_C(103), UINT8_C( 99), UINT8_C(115), UINT8_C(151),
                             UINT8_C(233), UINT8_C(197), UINT8_C(132), UINT8_C(158),
                             UINT8_C( 23), UINT8_C( 54), UINT8_C(164), UINT8_C(107),
                             UINT8_C(233), UINT8_C(122), UINT8_C( 62), UINT8_C( 22),
                             UINT8_C(179), UINT8_C( 56), UINT8_C(117), UINT8_C(196),
                             UINT8_C(102), UINT8_C( 82), UINT8_C(  6), UINT8_C(242),
                             UINT8_C(100), UINT8_C(238), UINT8_C(103), UINT8_C( 83),
                             UINT8_C(139), UINT8_C(142), UINT8_C(174), UINT8_C(130),
                             UINT8_C(118), UINT8_C( 29), UINT8_C(246), UINT8_C(127),
                             UINT8_C(235), UINT8_C( 33), UINT8_C(253), UINT8_C(147),
                             UINT8_C( 41), UINT8_C( 14), UINT8_C(193), UINT8_C(126),
                             UINT8_C(220), UINT8_C(114), UINT8_C( 22), UINT8_C( 77),
                             UINT8_C( 40), UINT8_C(150), UINT8_C(218), UINT8_C(187),
                             UINT8_C(209), UINT8_C(123), UINT8_C( 46), UINT8_C(156)),
      simde_x_mm512_set_epu8(UINT8_C(176), UINT8_C( 45), UINT8_C(210), UINT8_C(149),
                             UINT8_C(149), UINT8_C(249), UINT8_C( 13), UINT8_C(137),
                             UINT8_C(118), UINT8_C(232), UINT8_C(127), UINT8_C( 30),
                             UINT8_C(175), UINT8_C(210), UINT8_C(248), UINT8_C(191),
                             UINT8_C( 96), UINT8_C( 79), UINT8_C(110), UINT8_C(154),
                             UINT8_C(119), UINT8_C(253), UINT8_C(133), UINT8_C( 16),
                             UINT8_C(243), UINT8_C(  4), UINT8_C(  4), UINT8_C(112),
                             UINT8_C(245), UINT8_C(173), UINT8_C( 10), UINT8_C(196),
                             UINT8_C(208), UINT8_C( 87), UINT8_C( 86), UINT8_C(157),
                             UINT8_C(215), UINT8_C( 65), UINT8_C(145), UINT8_C(212),
                             UINT8_C( 76), UINT8_C(163), UINT8_C( 24), UINT8_C(147),
                             UINT8_C( 61), UINT8_C(161), UINT8_C( 63), UINT8_C( 34),
                             UINT8_C(236), UINT8_C( 70), UINT8_C(243), UINT8_C(236),
                             UINT8_C( 49), UINT8_C( 99), UINT8_C(157), UINT8_C( 87),
                             UINT8_C(  4), UINT8_C( 86), UINT8_C(157), UINT8_C( 37),
                             UINT8_C( 44), UINT8_C( 59), UINT8_C(149), UINT8_C( 14)),
      UINT64_C(10801838139217605378) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])); i++) {
    simde__mmask64 r = simde_mm512_cmplt_epu8_mask(test_vec[i].a, test_vec[i].b);
    simde_assert_equal_mmask64(r, test_vec[i].r);
  }

  return 0;
}

#if !defined(SIMDE_BUG_GCC_96174)
static int
test_simde_mm512_cmplt_ps_mask (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde_float32 a[16];
    const simde_float32 b[16];
    const simde__mmask16 r;
  } test_vec[] = {
    { { SIMDE_FLOAT32_C(  -679.30), SIMDE_FLOAT32_C(   966.54), SIMDE_FLOAT32_C(    -8.95), SIMDE_FLOAT32_C(   958.36),
        SIMDE_FLOAT32_C(  -725.44), SIMDE_FLOAT32_C(  -760.28), SIMDE_FLOAT32_C(   751.05), SIMDE_FLOAT32_C(   763.86),
        SIMDE_FLOAT32_C(  -137.17), SIMDE_FLOAT32_C(  -526.42), SIMDE_FLOAT32_C(  -580.26), SIMDE_FLOAT32_C(    72.73),
        SIMDE_FLOAT32_C(   848.96), SIMDE_FLOAT32_C(  -167.99), SIMDE_FLOAT32_C(    95.30), SIMDE_FLOAT32_C(   277.78) },
      { SIMDE_FLOAT32_C(   425.87), SIMDE_FLOAT32_C(  -693.81), SIMDE_FLOAT32_C(   225.64), SIMDE_FLOAT32_C(  -374.81),
        SIMDE_FLOAT32_C(  -490.07), SIMDE_FLOAT32_C(    62.38), SIMDE_FLOAT32_C(   630.88), SIMDE_FLOAT32_C(   308.80),
        SIMDE_FLOAT32_C(  -539.84), SIMDE_FLOAT32_C(  -683.39), SIMDE_FLOAT32_C(  -735.32), SIMDE_FLOAT32_C(  -999.26),
        SIMDE_FLOAT32_C(   848.96), SIMDE_FLOAT32_C(   579.92), SIMDE_FLOAT32_C(   118.33), SIMDE_FLOAT32_C(  -830.34) },
      UINT16_C(24629) },
    { { SIMDE_FLOAT32_C(  -833.10), SIMDE_FLOAT32_C(   667.53), SIMDE_FLOAT32_C(  -768.58), SIMDE_FLOAT32_C(    27.81),
        SIMDE_FLOAT32_C(   969.40), SIMDE_FLOAT32_C(  -884.80), SIMDE_FLOAT32_C(  -758.63), SIMDE_FLOAT32_C(  -724.10),
        SIMDE_FLOAT32_C(  -716.35), SIMDE_FLOAT32_C(  -476.71), SIMDE_FLOAT32_C(   419.04), SIMDE_FLOAT32_C(   832.05),
        SIMDE_FLOAT32_C(   151.35), SIMDE_FLOAT32_C(  -175.30), SIMDE_FLOAT32_C(    66.61), SIMDE_FLOAT32_C(   351.20) },
      { SIMDE_FLOAT32_C(   118.05), SIMDE_FLOAT32_C(  -502.75), SIMDE_FLOAT32_C(  -814.79), SIMDE_FLOAT32_C(   929.98),
        SIMDE_FLOAT32_C(   432.78), SIMDE_FLOAT32_C(  -886.46), SIMDE_FLOAT32_C(   577.10), SIMDE_FLOAT32_C(  -862.12),
        SIMDE_FLOAT32_C(   136.94), SIMDE_FLOAT32_C(   908.37), SIMDE_FLOAT32_C(  -807.53), SIMDE_FLOAT32_C(  -626.26),
        SIMDE_FLOAT32_C(    93.44), SIMDE_FLOAT32_C(   143.01), SIMDE_FLOAT32_C(   933.29), SIMDE_FLOAT32_C(   260.34) },
      UINT16_C(25417) },
    { { SIMDE_FLOAT32_C(   397.82), SIMDE_FLOAT32_C(    82.73), SIMDE_FLOAT32_C(  -728.93), SIMDE_FLOAT32_C(  -716.45),
        SIMDE_FLOAT32_C(   278.34), SIMDE_FLOAT32_C(  -422.65), SIMDE_FLOAT32_C(  -540.28), SIMDE_FLOAT32_C(   265.15),
        SIMDE_FLOAT32_C(   279.24), SIMDE_FLOAT32_C(  -171.08), SIMDE_FLOAT32_C(  -468.61), SIMDE_FLOAT32_C(   443.34),
        SIMDE_FLOAT32_C(   751.73), SIMDE_FLOAT32_C(  -744.43), SIMDE_FLOAT32_C(   566.91), SIMDE_FLOAT32_C(  -904.35) },
      { SIMDE_FLOAT32_C(  -692.80), SIMDE_FLOAT32_C(    82.73), SIMDE_FLOAT32_C(   507.25), SIMDE_FLOAT32_C(  -716.45),
        SIMDE_FLOAT32_C(  -871.32), SIMDE_FLOAT32_C(   909.91), SIMDE_FLOAT32_C(  -907.02), SIMDE_FLOAT32_C(  -102.77),
        SIMDE_FLOAT32_C(   677.37), SIMDE_FLOAT32_C(  -171.08), SIMDE_FLOAT32_C(  -468.61), SIMDE_FLOAT32_C(  -257.08),
        SIMDE_FLOAT32_C(   751.73), SIMDE_FLOAT32_C(   841.70), SIMDE_FLOAT32_C(   271.27), SIMDE_FLOAT32_C(   149.55) },
      UINT16_C(41252) },
    { { SIMDE_FLOAT32_C(  -351.59), SIMDE_FLOAT32_C(  -757.31), SIMDE_FLOAT32_C(  -739.49), SIMDE_FLOAT32_C(   354.82),
        SIMDE_FLOAT32_C(   779.77), SIMDE_FLOAT32_C(   796.84), SIMDE_FLOAT32_C(   253.65), SIMDE_FLOAT32_C(  -980.02),
        SIMDE_FLOAT32_C(  -824.56), SIMDE_FLOAT32_C(  -806.24), SIMDE_FLOAT32_C(   218.91), SIMDE_FLOAT32_C(   807.03),
        SIMDE_FLOAT32_C(  -499.44), SIMDE_FLOAT32_C(   683.75), SIMDE_FLOAT32_C(   242.90), SIMDE_FLOAT32_C(   681.31) },
      { SIMDE_FLOAT32_C(   698.06), SIMDE_FLOAT32_C(   143.17), SIMDE_FLOAT32_C(   645.90), SIMDE_FLOAT32_C(   354.82),
        SIMDE_FLOAT32_C(   561.25), SIMDE_FLOAT32_C(  -928.28), SIMDE_FLOAT32_C(   482.94), SIMDE_FLOAT32_C(    28.55),
        SIMDE_FLOAT32_C(   701.67), SIMDE_FLOAT32_C(   834.16), SIMDE_FLOAT32_C(   386.75), SIMDE_FLOAT32_C(   807.03),
        SIMDE_FLOAT32_C(   558.03), SIMDE_FLOAT32_C(  -756.03), SIMDE_FLOAT32_C(   930.12), SIMDE_FLOAT32_C(  -793.56) },
      UINT16_C(22471) },
    { { SIMDE_FLOAT32_C(   434.87), SIMDE_FLOAT32_C(  -355.05), SIMDE_FLOAT32_C(  -653.48), SIMDE_FLOAT32_C(   594.11),
        SIMDE_FLOAT32_C(   799.49), SIMDE_FLOAT32_C(   264.31), SIMDE_FLOAT32_C(    -8.19), SIMDE_FLOAT32_C(  -922.96),
        SIMDE_FLOAT32_C(   308.23), SIMDE_FLOAT32_C(  -871.48), SIMDE_FLOAT32_C(   543.66), SIMDE_FLOAT32_C(   721.18),
        SIMDE_FLOAT32_C(  -314.45), SIMDE_FLOAT32_C(   897.43), SIMDE_FLOAT32_C(   646.34), SIMDE_FLOAT32_C(  -691.19) },
      { SIMDE_FLOAT32_C(  -506.84), SIMDE_FLOAT32_C(  -355.05), SIMDE_FLOAT32_C(    70.02), SIMDE_FLOAT32_C(  -186.22),
        SIMDE_FLOAT32_C(   745.56), SIMDE_FLOAT32_C(  -329.15), SIMDE_FLOAT32_C(  -306.53), SIMDE_FLOAT32_C(  -665.08),
        SIMDE_FLOAT32_C(   -81.67), SIMDE_FLOAT32_C(   690.25), SIMDE_FLOAT32_C(  -343.01), SIMDE_FLOAT32_C(   742.59),
        SIMDE_FLOAT32_C(  -989.44), SIMDE_FLOAT32_C(   198.45), SIMDE_FLOAT32_C(   334.24), SIMDE_FLOAT32_C(   445.42) },
      UINT16_C(35460) },
    { { SIMDE_FLOAT32_C(    72.70), SIMDE_FLOAT32_C(  -926.98), SIMDE_FLOAT32_C(   386.60), SIMDE_FLOAT32_C(  -166.44),
        SIMDE_FLOAT32_C(  -372.12), SIMDE_FLOAT32_C(   156.01), SIMDE_FLOAT32_C(  -432.45), SIMDE_FLOAT32_C(  -171.34),
        SIMDE_FLOAT32_C(  -100.09), SIMDE_FLOAT32_C(   220.75), SIMDE_FLOAT32_C(  -427.23), SIMDE_FLOAT32_C(  -735.37),
        SIMDE_FLOAT32_C(   440.82), SIMDE_FLOAT32_C(  -646.62), SIMDE_FLOAT32_C(   895.12), SIMDE_FLOAT32_C(   585.45) },
      { SIMDE_FLOAT32_C(   -15.73), SIMDE_FLOAT32_C(   536.94), SIMDE_FLOAT32_C(  -374.81), SIMDE_FLOAT32_C(   158.91),
        SIMDE_FLOAT32_C(   525.00), SIMDE_FLOAT32_C(   478.37), SIMDE_FLOAT32_C(  -432.45), SIMDE_FLOAT32_C(  -483.69),
        SIMDE_FLOAT32_C(   887.57), SIMDE_FLOAT32_C(   220.75), SIMDE_FLOAT32_C(   709.30), SIMDE_FLOAT32_C(   187.04),
        SIMDE_FLOAT32_C(  -436.07), SIMDE_FLOAT32_C(   329.70), SIMDE_FLOAT32_C(    57.53), SIMDE_FLOAT32_C(   636.63) },
      UINT16_C(44346) },
    { { SIMDE_FLOAT32_C(  -715.67), SIMDE_FLOAT32_C(  -253.10), SIMDE_FLOAT32_C(   805.99), SIMDE_FLOAT32_C(   896.48),
        SIMDE_FLOAT32_C(  -683.44), SIMDE_FLOAT32_C(  -642.77), SIMDE_FLOAT32_C(  -746.45), SIMDE_FLOAT32_C(   318.24),
        SIMDE_FLOAT32_C(  -949.63), SIMDE_FLOAT32_C(  -203.63), SIMDE_FLOAT32_C(  -894.66), SIMDE_FLOAT32_C(   648.89),
        SIMDE_FLOAT32_C(   110.40), SIMDE_FLOAT32_C(   662.12), SIMDE_FLOAT32_C(   821.38), SIMDE_FLOAT32_C(   820.81) },
      { SIMDE_FLOAT32_C(   147.48), SIMDE_FLOAT32_C(   715.61), SIMDE_FLOAT32_C(  -594.01), SIMDE_FLOAT32_C(   128.99),
        SIMDE_FLOAT32_C(   847.91), SIMDE_FLOAT32_C(  -246.50), SIMDE_FLOAT32_C(  -172.62), SIMDE_FLOAT32_C(   927.56),
        SIMDE_FLOAT32_C(  -949.63), SIMDE_FLOAT32_C(  -193.40), SIMDE_FLOAT32_C(   284.28), SIMDE_FLOAT32_C(   354.14),
        SIMDE_FLOAT32_C(  -296.72), SIMDE_FLOAT32_C(   320.79), SIMDE_FLOAT32_C(   108.95), SIMDE_FLOAT32_C(   -12.38) },
      UINT16_C( 1779) },
    { { SIMDE_FLOAT32_C(   372.34), SIMDE_FLOAT32_C(   943.17), SIMDE_FLOAT32_C(  -546.38), SIMDE_FLOAT32_C(  -534.61),
        SIMDE_FLOAT32_C(  -390.69), SIMDE_FLOAT32_C(   249.11), SIMDE_FLOAT32_C(   492.46), SIMDE_FLOAT32_C(    83.28),
        SIMDE_FLOAT32_C(   -13.87), SIMDE_FLOAT32_C(   563.95), SIMDE_FLOAT32_C(    27.19), SIMDE_FLOAT32_C(    69.48),
        SIMDE_FLOAT32_C(  -499.31), SIMDE_FLOAT32_C(   588.53), SIMDE_FLOAT32_C(   881.11), SIMDE_FLOAT32_C(  -291.35) },
      { SIMDE_FLOAT32_C(   896.28), SIMDE_FLOAT32_C(  -328.16), SIMDE_FLOAT32_C(   -58.67), SIMDE_FLOAT32_C(  -222.16),
        SIMDE_FLOAT32_C(   369.25), SIMDE_FLOAT32_C(   249.11), SIMDE_FLOAT32_C(    39.79), SIMDE_FLOAT32_C(   257.60),
        SIMDE_FLOAT32_C(   -13.87), SIMDE_FLOAT32_C(   385.43), SIMDE_FLOAT32_C(   657.69), SIMDE_FLOAT32_C(   261.33),
        SIMDE_FLOAT32_C(  -197.63), SIMDE_FLOAT32_C(  -362.80), SIMDE_FLOAT32_C(   -10.34), SIMDE_FLOAT32_C(  -825.29) },
      UINT16_C( 7325) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512 a = simde_mm512_loadu_ps(test_vec[i].a);
    simde__m512 b = simde_mm512_loadu_ps(test_vec[i].b);
    simde__mmask16 r = simde_mm512_cmplt_ps_mask(a, b);
    simde_assert_equal_mmask16(r, test_vec[i].r);
  }

  return 0;
}

static int
test_simde_mm512_cmplt_pd_mask (SIMDE_MUNIT_TEST_ARGS) {
  static const struct {
    const simde_float64 a[8];
    const simde_float64 b[8];
    const simde__mmask8 r;
  } test_vec[] = {
    { { SIMDE_FLOAT64_C(   159.59), SIMDE_FLOAT64_C(   210.36), SIMDE_FLOAT64_C(  -469.27), SIMDE_FLOAT64_C(  -961.30),
        SIMDE_FLOAT64_C(  -565.87), SIMDE_FLOAT64_C(  -556.86), SIMDE_FLOAT64_C(   785.14), SIMDE_FLOAT64_C(   -76.60) },
      { SIMDE_FLOAT64_C(   549.87), SIMDE_FLOAT64_C(  -373.87), SIMDE_FLOAT64_C(   375.69), SIMDE_FLOAT64_C(   255.43),
        SIMDE_FLOAT64_C(  -924.84), SIMDE_FLOAT64_C(   236.64), SIMDE_FLOAT64_C(  -838.91), SIMDE_FLOAT64_C(   432.31) },
      UINT8_C(173) },
    { { SIMDE_FLOAT64_C(   -86.33), SIMDE_FLOAT64_C(   998.88), SIMDE_FLOAT64_C(   169.13), SIMDE_FLOAT64_C(   558.70),
        SIMDE_FLOAT64_C(   146.37), SIMDE_FLOAT64_C(    90.58), SIMDE_FLOAT64_C(   405.41), SIMDE_FLOAT64_C(  -319.04) },
      { SIMDE_FLOAT64_C(  -110.18), SIMDE_FLOAT64_C(   182.04), SIMDE_FLOAT64_C(  -496.16), SIMDE_FLOAT64_C(  -883.07),
        SIMDE_FLOAT64_C(   321.39), SIMDE_FLOAT64_C(  -344.51), SIMDE_FLOAT64_C(   -99.97), SIMDE_FLOAT64_C(  -263.70) },
      UINT8_C(144) },
    { { SIMDE_FLOAT64_C(    29.15), SIMDE_FLOAT64_C(   -41.18), SIMDE_FLOAT64_C(  -110.04), SIMDE_FLOAT64_C(   548.12),
        SIMDE_FLOAT64_C(   271.03), SIMDE_FLOAT64_C(  -770.85), SIMDE_FLOAT64_C(   346.58), SIMDE_FLOAT64_C(   912.24) },
      { SIMDE_FLOAT64_C(    79.16), SIMDE_FLOAT64_C(   358.77), SIMDE_FLOAT64_C(  -231.91), SIMDE_FLOAT64_C(   206.83),
        SIMDE_FLOAT64_C(   115.65), SIMDE_FLOAT64_C(  -336.81), SIMDE_FLOAT64_C(  -732.53), SIMDE_FLOAT64_C(   334.52) },
      UINT8_C( 35) },
    { { SIMDE_FLOAT64_C(   256.18), SIMDE_FLOAT64_C(  -459.33), SIMDE_FLOAT64_C(   101.00), SIMDE_FLOAT64_C(  -417.14),
        SIMDE_FLOAT64_C(  -900.86), SIMDE_FLOAT64_C(  -806.81), SIMDE_FLOAT64_C(    -5.42), SIMDE_FLOAT64_C(   857.96) },
      { SIMDE_FLOAT64_C(  -232.59), SIMDE_FLOAT64_C(   931.14), SIMDE_FLOAT64_C(  -321.87), SIMDE_FLOAT64_C(   407.35),
        SIMDE_FLOAT64_C(   262.90), SIMDE_FLOAT64_C(   592.56), SIMDE_FLOAT64_C(  -812.34), SIMDE_FLOAT64_C(   950.75) },
      UINT8_C(186) },
    { { SIMDE_FLOAT64_C(  -662.53), SIMDE_FLOAT64_C(   872.08), SIMDE_FLOAT64_C(  -996.83), SIMDE_FLOAT64_C(   245.09),
        SIMDE_FLOAT64_C(  -755.15), SIMDE_FLOAT64_C(   154.86), SIMDE_FLOAT64_C(   690.61), SIMDE_FLOAT64_C(  -850.32) },
      { SIMDE_FLOAT64_C(   718.59), SIMDE_FLOAT64_C(  -644.78), SIMDE_FLOAT64_C(  -744.92), SIMDE_FLOAT64_C(   162.05),
        SIMDE_FLOAT64_C(  -429.20), SIMDE_FLOAT64_C(   382.77), SIMDE_FLOAT64_C(  -712.41), SIMDE_FLOAT64_C(   553.41) },
      UINT8_C(181) },
    { { SIMDE_FLOAT64_C(  -767.88), SIMDE_FLOAT64_C(   220.93), SIMDE_FLOAT64_C(  -852.88), SIMDE_FLOAT64_C(  -422.20),
        SIMDE_FLOAT64_C(    24.06), SIMDE_FLOAT64_C(   396.29), SIMDE_FLOAT64_C(   393.46), SIMDE_FLOAT64_C(   825.11) },
      { SIMDE_FLOAT64_C(  -326.63), SIMDE_FLOAT64_C(   260.49), SIMDE_FLOAT64_C(    21.96), SIMDE_FLOAT64_C(  -870.80),
        SIMDE_FLOAT64_C(   390.98), SIMDE_FLOAT64_C(  -810.50), SIMDE_FLOAT64_C(   -47.31), SIMDE_FLOAT64_C(   928.47) },
      UINT8_C(151) },
    { { SIMDE_FLOAT64_C(   764.04), SIMDE_FLOAT64_C(  -755.85), SIMDE_FLOAT64_C(   350.20), SIMDE_FLOAT64_C(  -122.92),
        SIMDE_FLOAT64_C(    41.32), SIMDE_FLOAT64_C(   468.91), SIMDE_FLOAT64_C(   941.23), SIMDE_FLOAT64_C(  -826.92) },
      { SIMDE_FLOAT64_C(   -79.39), SIMDE_FLOAT64_C(  -301.22), SIMDE_FLOAT64_C(  -613.48), SIMDE_FLOAT64_C(  -831.83),
        SIMDE_FLOAT64_C(  -533.10), SIMDE_FLOAT64_C(   168.63), SIMDE_FLOAT64_C(   232.01), SIMDE_FLOAT64_C(  -589.49) },
      UINT8_C(130) },
    { { SIMDE_FLOAT64_C(   431.35), SIMDE_FLOAT64_C(  -312.15), SIMDE_FLOAT64_C(  -300.41), SIMDE_FLOAT64_C(  -919.37),
        SIMDE_FLOAT64_C(    97.60), SIMDE_FLOAT64_C(   323.36), SIMDE_FLOAT64_C(   650.47), SIMDE_FLOAT64_C(   378.00) },
      { SIMDE_FLOAT64_C(  -942.80), SIMDE_FLOAT64_C(   278.12), SIMDE_FLOAT64_C(   437.54), SIMDE_FLOAT64_C(  -207.26),
        SIMDE_FLOAT64_C(   628.37), SIMDE_FLOAT64_C(  -977.34), SIMDE_FLOAT64_C(   -73.78), SIMDE_FLOAT64_C(   -44.83) },
      UINT8_C( 30) }
  };

  for (size_t i = 0 ; i < (sizeof(test_vec) / sizeof(test_vec[0])) ; i++) {
    simde__m512d a = simde_mm512_loadu_pd(test_vec[i].a);
    simde__m512d b = simde_mm512_loadu_pd(test_vec[i].b);
    simde__mmask8 r = simde_mm512_cmplt_pd_mask(a, b);
    simde_assert_equal_mmask8(r, test_vec[i].r);
  }

  return 0;
}

#endif /* !defined(SIMDE_BUG_GCC_96174) */

SIMDE_TEST_FUNC_LIST_BEGIN
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmplt_epi8_mask)
  SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmplt_epu8_mask)
  #if !defined(SIMDE_BUG_GCC_96174)
    SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmplt_ps_mask)
    SIMDE_TEST_FUNC_LIST_ENTRY(mm512_cmplt_pd_mask)
  #endif
SIMDE_TEST_FUNC_LIST_END

#include <test/x86/avx512/test-avx512-footer.h>
