/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "RipOffTrackList.h"

RipOffTrackList ripoff_track_list_new()
{
	RipOffTrackList new = g_new(struct RipOffTrackList_, 1);
	new->beginning = NULL;
	new->end = NULL;
	new->current = NULL;
	new->size = 0;

	return new;
}

RipOffTrack ripoff_track_list_start(RipOffTrackList list)
{
	list->current = list-> beginning;
	
	if(list->current != NULL)
	{
		return list->current->track;
	}
	else
	{
		return NULL;
	}
}

RipOffTrack ripoff_track_list_next_track(RipOffTrackList list)
{
	/* Checks that the list is not current empty. If it is returns NULL. Then moves the
	   pointer to thhe next node in the list. Then if that node is not empty, returns
	   the track in the list, otherwise returns NULL */

	if(list->current != NULL)
	{
		if(list->current->next != NULL)
		{
			list->current = list->current->next;
			return list->current->track;
		}

		else
			return NULL;
	}

	return NULL;
}

void ripoff_track_list_add_track(RipOffTrackList list, RipOffTrack track)
{
	RipOffTrackListNode node = g_new(struct RipOffTrackListNode_, 1);
	node->track = track;
	node->next = NULL;
	++list->size;

	/* Checks whether or not the list is empty when the track is added and handles each
	   case accordingly */
	if(list->beginning == NULL)
	{
		list->beginning = node;
		list->end = list->beginning;
	}

	else
	{
		list->end->next = node;
		list->end = list->end->next;
	}
}	

void ripoff_track_list_destroy(RipOffTrackList list)
{
	RipOffTrackListNode current = list->beginning;
	RipOffTrackListNode next;
	list->size = 0;

	/* checks that the list isn't empty */
	if(current != NULL)
	{
		next = current->next;

		/* traverses list freeing each RipOffTrack and freeing each RipOffTrackList */
		while(current != NULL)
		{
			ripoff_track_destroy(current->track);
			g_free(current);
			current = current->next;
		}
	}
}

gint ripoff_track_list_get_size(RipOffTrackList list)
{
	return list->size;
}

gboolean ripoff_track_list_is_empty(RipOffTrackList list)
{
	
	if(list->beginning == NULL)
		return TRUE;
	else
		return FALSE;
}
