#include "rheolef.h"
using namespace rheolef;
using namespace std;
int main (int argc, char **argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  size_t n_max = (argc > 2) ? atoi(argv[2]) : 100;
  Float delta_t = 0.5/n_max;
  space Xh (omega, "P1");
  Xh.block ("boundary");
  trial u (Xh); test v (Xh);
  form a = integrate (u*v + delta_t*dot(grad(u),grad(v)));
  solver sa = ldlt (a.uu());
  field uh (Xh, 0);
  branch event ("t","u");
  dout << event (0, uh);
  for (size_t n = 1; n <= n_max; n++) {
    field rhs = uh + delta_t;
    field lh = integrate (rhs*v);
    uh.set_u() = sa.solve (lh.u() - a.ub()*uh.b());
    dout << event (n*delta_t, uh);
  }
}
