///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_diag_manip.h"
using namespace rheolef;
using namespace std;
namespace rheolef { 

form_diag_manip::form_diag_manip()
 : _verbose(true),
   _nform(0), 
   _nbloc(0), 
   _a(0)
{
}
form_diag_manip::size_type
form_diag_manip::nform() const
{
    return _nform;
}
form_diag_manip::size_type
form_diag_manip::nbloc() const
{
    return _nbloc;
}
form_diag&
form_diag_manip::bloc(size_type i)
{
    return _a[i];
}
const form_diag&
form_diag_manip::bloc(size_type i) const
{
    return _a[i];
}
form_diag_manip&
form_diag_manip::operator << (const form_diag& a)
{ 
    _a.insert(_a.end(),a) ; 
    _nform++ ; 
    return *this ;
}
form_diag_manip&
form_diag_manip::operator >> (form_diag& a) 
{
    assert_macro(_nform == _nbloc,
	_nform << " blocs, " << _nbloc << " expected");
    a.uu = bloc(0).uu;
    a.bb = bloc(0).bb; 
    for (size_type i = 1; i < _nbloc; i++) {
	a.uu = dcat(a.uu,bloc(i).uu) ; 
        a.bb = dcat(a.bb,bloc(i).bb) ;
    }  
    return *this ;
}
form_diag_manip&
form_diag_manip::operator << (form_diag_manip& (*pf)(form_diag_manip&))
{ 
    return (*pf)(*this);
}  
form_diag_manip&
verbose (form_diag_manip &fm) 
{ 
    fm._verbose = true;
    return fm; 
}
form_diag_manip&
noverbose (form_diag_manip &fm) 
{ 
    fm._verbose = false;
    return fm ; 
}
//
// class sized:
//
sized::sized(size_type nbloc1)
  : _nbloc(nbloc1)
{
}
form_diag_manip&
operator << (form_diag_manip &fm, const sized& s) 
{ 
    fm._nbloc = s._nbloc ;
    return fm ;
}
}// namespace rheolef
