# ifndef _RHEO_ENVIRONMENT_H
# define _RHEO_ENVIRONMENT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
// boost::mpi::environment-like interface,
// but with  MPI_Init_thread() instead of MPI_Init() call
// => support Scotch when compiled with threads
// note: this file is directly included by distributed.h

#include "rheolef/distributed.h"
#include <boost/optional.hpp>

namespace rheolef {
#ifndef _RHEOLEF_HAVE_MPI
struct environment { // as the boost::mpi::environment main interface, for portability
  environment (int& argc, char**& argv) {}
};
#else
class environment {
public:
  explicit environment (int& argc, char**& argv);
  ~environment();
  static bool initialized();
  static bool finalized();
  static void abort(int errcode);
  static int max_tag();
  static int collectives_tag();
  static boost::optional<int> host_rank();
  static boost::optional<int> io_rank();
  static std::string processor_name();
private:
  bool _has_init;
  static const int _num_reserved_tags = 1;
};
#endif // _RHEOLEF_HAVE_MPI
} // namespace rheolef
#endif // _RHEO_ENVIRONMENT_H
