<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:marc="http://www.loc.gov/MARC21/slim" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>

	<xsl:template match="/">
		<html>
			<xsl:apply-templates/>
		</html>
	</xsl:template>

	<xsl:template match="marc:leader">
		<p>LEADER</p>
		<xsl:variable name="leader" select="text()"/>
		<xsl:variable name="leader5" select="substring($leader,6,1)"/>
		<xsl:variable name="leader6" select="substring($leader,7,1)"/>
		<xsl:variable name="leader7" select="substring($leader,8,1)"/>
		<xsl:variable name="leader8" select="substring($leader,9,1)"/>
		<xsl:variable name="leader9" select="substring($leader,10,1)"/>
		<xsl:variable name="leader17" select="substring($leader,18,1)"/>
		<xsl:variable name="leader18" select="substring($leader,19,1)"/>
		<xsl:variable name="leader19" select="substring($leader,20,1)"/>
		<ul>
			<li>Record Status (Leader 5):
			<xsl:value-of select="$leader5"/>
			</li>
			<li>Type of record (Leader 6):
			<xsl:value-of select="$leader6"/>
			</li>
			<li>Bibliographic level (Leader 7):
			<xsl:value-of select="$leader7"/>
			</li>
			<li>Type of control (Leader 8):
			<xsl:value-of select="$leader8"/>
			</li>
			<li>Character Encoding (Leader 9):
			<xsl:value-of select="$leader9"/>
			</li>
			<li>Encoding level (Leader 17):
			<xsl:value-of select="$leader17"/>
			</li>
			<li>Descriptive cataloging form (Leader 18):
			<xsl:value-of select="$leader18"/>
			</li>
			<li>Linked record requirement (Leader 19):
			<xsl:value-of select="$leader19"/>
			</li>
		</ul>
	</xsl:template>
	
	<xsl:template match="marc:datafield[@tag=010]">
		<p>LIBRARY OF CONGRESS CONTROL NUMBER (010)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>LC control number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>NUCMC control number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid LC control number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=011]">
		<p>LINKING LIBRARY OF CONGRESS CONTROL NUMBER (011)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Linking LC control number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=013]">
		<p>PATENT CONTROL INFORMATION (013)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Country (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Type of number (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Status (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Party to document (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=014]">
		<p>LINKAGE NUMBER (014)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Linkage number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source of number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid linkage number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=015]">
		<p>NATIONAL BIBLIOGRAPHY NUMBER (015)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>National bibliography number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=016]">
		<p>NATIONAL BIBLIOGRAPHIC AGENCY CONTROL NUMBER (016)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Record control number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Canceled/invalid control number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=017]">
		<p>COPYRIGHT REGISTRATION NUMBER (017)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Copyright registration number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (agency assigning number) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=018]">
		<p>COPYRIGHT ARTICLE-FEE CODE (018)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Copyright article-fee code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=020]">
		<p>INTERNATIONAL STANDARD BOOK NUMBER (020)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>International Standard Book Number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Binding information (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Terms of availability (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid ISBN (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=022]">
		<p>INTERNATIONAL STANDARD SERIAL NUMBER (022)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>International Standard Serial Number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Incorrect ISSN (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled ISSN (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=024]">
		<p>OTHER STANDARD IDENTIFIER (024)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Standard recording code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Terms of availability (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Additional codes following the standard number or code (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid standard code (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of code or number (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=025]">
		<p>OVERSEAS ACQUISITION NUMBER (025)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Overseas acquisition number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=027]">
		<p>STANDARD TECHNICAL REPORT NUMBER (027)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Standard Technical Report Number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid STRN (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=028]">
		<p>PUBLISHER NUMBER FOR MUSIC (028)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Publisher number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=030]">
		<p>CODEN DESIGNATION (030)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>CODEN (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid CODEN (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=032]">
		<p>POSTAL REGISTRATION NUMBER (032)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Postal registration number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (agency assigning number) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=033]">
		<p>DATE/TIME AND PLACE OF AN EVENT (033)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Formatted date/time (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic classification area code (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Geographic classification subarea code (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=034]">
		<p>CODED CARTOGRAPHIC MATHEMATICAL DATA (034)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Category of scale (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Constant ratio linear horizontal scale (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Constant ratio linear vertical scale (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Coordinates--westernmost longitude (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Coordinates--easternmost longitude (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Coordinates--northernmost latitude (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Coordinates--southernmost latitude (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Angular scale (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Declination--northern limit (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Declination--southern limit (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Right ascension--eastern limit (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Right ascension--western limit (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Equinox (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>G-ring latitude (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>G-ring longitude (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=035]">
		<p>SYSTEM CONTROL NUMBER (035)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>System control number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid system control number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=036]">
		<p>ORIGINAL STUDY NUMBER FOR COMPUTER DATA FILES (036)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Original study number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (agency assigning number) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=037]">
		<p>SOURCE OF ACQUISITION (037)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Stock number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source of stock number/acquisition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Terms of availability (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Form of issue (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Additional format characteristics (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=039]">
		<p>LEVEL OF BIBLIOGRAPHIC CONTROL AND CODING DETAIL (039)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Level of rules in bibliographic description (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Level of effort used to assign nonsubject heading access points (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Level of effort used to assign subject headings (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Level of effort used to assign classification (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Number of fixed field character positions coded (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=040]">
		<p>CATALOGING SOURCE (040)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Original cataloging agency (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Language of cataloging (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Transcribing agency (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Modifying agency (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Description conventions (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=041]">
		<p>LANGUAGE CODE (041)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Language code of text/sound track or separate title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Language code of summary or abstract/overprinted title or subtitle (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Language code of sung or spoken text (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Language code of librettos (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Language code of table of contents (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Language code of accompanying material other than librettos (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Language code of original and/or intermediate translations of text (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=042]">
		<p>AUTHENTICATION CODE (042)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Authentication code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=043]">
		<p>GEOGRAPHIC AREA CODE (043)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic area code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Local GAC code (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of local code (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=044]">
		<p>COUNTRY OF PUBLISHING/PRODUCING ENTITY CODE (044)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country of publishing/producing entity code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Local subentity code (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>ISO subentity code (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of local subentity data (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=045]">
		<p>TIME PERIOD OF CONTENT (045)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Time period code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Formatted 9999 B.C. through A.D. time period (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Formatted pre-9999 B.C. time period (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=046]">
		<p>SPECIAL CODED DATES (046)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of date code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Date 1 (B.C. date) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Date 1 (A.D. date) (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date 2 (B.C. date) (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Date 2 (A.D. date) (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=047]">
		<p>FORM OF MUSICAL COMPOSITION CODE (047)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Form of musical composition code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=048]">
		<p>NUMBER OF MUSICAL INSTRUMENTS OR VOICES CODE (048)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Performer or ensemble (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Soloist (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=050]">
		<p>LIBRARY OF CONGRESS CALL NUMBER (050)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field link and number sequence (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Supplementary class number (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=051]">
		<p>LIBRARY OF CONGRESS COPY, ISSUE, OFFPRINT STATEMENT (051)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Copy information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=052]">
		<p>GEOGRAPHIC CLASSIFICATION (052)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic classification area code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic classification subarea code (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Subject (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Populated place name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Code source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=055]">
		<p>CALL NUMBERS/CLASS NUMBERS ASSIGNED IN CANADA (055) 
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of call/class number (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=058]">
		<p>OTHER GEOGRAPHIC CLASSIFICATION CODE (058)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic classification area code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic classification subarea code (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Code source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=060]">
		<p>NATIONAL LIBRARY OF MEDICINE CALL NUMBER (060)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=061]">
		<p>NATIONAL LIBRARY OF MEDICINE COPY STATEMENT (061)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Copy information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=066]">
		<p>CHARACTER SETS PRESENT (066)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Non-ASCII G0 default character set designation (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Non-ANSEL G1 default character set designation (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Alternate graphic character set identification (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=070]">
		<p>NATIONAL AGRICULTURAL LIBRARY CALL NUMBER (070)
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=071]">
		<p>NATIONAL AGRICULTURAL LIBRARY COPY STATEMENT 071
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Copy information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=072]">
		<p>SUBJECT CATEGORY CODE 072
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Subject category code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Subject category code subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Code source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=073]">
		<p>TYPE OF PROGRAM OR ORGANIZATION CODE 073
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of program or organization code (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Code source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=074]">
		<p>GPO ITEM NUMBER 074
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>GPO item number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid GPO item number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=080]">
		<p>UNIVERSAL DECIMAL CLASSIFICATION NUMBER 080
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Universal Decimal Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Common auxiliary subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Edition identifier (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=082]">
		<p>DEWEY DECIMAL CALL NUMBER 082
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>DDC number--abridged NST version (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Edition number (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=084]">
		<p>OTHER CLASSIFICATION NUMBER 084
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of number (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=086]">
		<p>GOVERNMENT DOCUMENT CLASSIFICATION NUMBER 086
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Classification number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid classification number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Number source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=088]">088
		<p>REPORT NUMBER 
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Report number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Cancelled/invalid report number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=090]">
		<p>LOCAL CALL NUMBER 090
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Local class number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Local Cutter number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=091]">
		<p>MICROFILM SHELF LOCATION 091
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Microfilm shelf location (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=100]">
		<p>MAIN ENTRY--PERSONAL NAME 100
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=110]">
		<p>MAIN ENTRY--CORPORATE NAME 110
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=111]">
		<p>MAIN ENTRY--MEETING NAME 111
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=130]">
		<p>MAIN ENTRY--UNIFORM TITLE 130
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=210]">
		<p>ABBREVIATED TITLE 210
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Abbreviated title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Qualifying information (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=211]">
		<p>ACRONYM OR SHORTENED TITLE 211
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Acronym or shortened title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=212]">
		<p>VARIANT ACCESS TITLE 212
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Variant access title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=214]">
		<p>AUGMENTED TITLE 214
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Augmented title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=222]">
		<p>KEY TITLE 222
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Key title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Qualifying information (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=240]">
		<p>UNIFORM TITLE 240
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=241]">
		<p>ROMANIZED TITLE 241
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Romanized title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=242]">
		<p>TRANSLATION OF TITLE BY CATALOGING AGENCY 242
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Remainder of title page transcription /statement of responsibility (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (BK AM MP MU VM SE) (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Language code of translated title (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=243]">
		<p>COLLECTIVE UNIFORM TITLE 243
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=245]">
		<p>TITLE STATEMENT 245
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Remainder of title page transcription/statement of responsibility (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE) (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Inclusive dates (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Bulk dates (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=246]">
		<p>VARYING FORM OF TITLE  246
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title proper/short title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE) (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Designation of volume and issue number and/or date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=247]">
		<p>FORMER TITLE OR TITLE VARIATIONS 247
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title proper/short title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of title (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Designation of section (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Name of part/section (SE) (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Designation of volume and issue number and/or date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=250]">
		<p>EDITION STATEMENT 250
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Edition statement (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of edition statement (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=254]">
		<p>MUSICAL PRESENTATION STATEMENT 254
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Musical presentation statement (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=255]">
		<p>CARTOGRAPHIC MATHEMATICAL DATA 255
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Statement of scale (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Statement of projection (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Statement of coordinates (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Statement of zone (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Statement of equinox (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Outer G-ring coordinate pairs (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Exclusion G-ring coordinate pairs (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=256]">
		<p>COMPUTER FILE CHARACTERISTICS 256
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Computer file characteristics (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=257]">
		<p>COUNTRY OF PRODUCING ENTITY FOR ARCHIVAL FILMS 257
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country of producing entity for archival films (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=260]">
		<p>PUBLICATION, DISTRIBUTION, ETC. (IMPRINT) 260
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Place of publication, distribution, etc. (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Name of publisher, distributor, etc. (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Date of publication, distribution, etc. (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Place of manufacture (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Manufacturer (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Date of manufacture (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=263]">
		<p>PROJECTED PUBLICATION DATE 263
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Projected publication date (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=265]">
		<p>SOURCE FOR ACQUISITION/SUBSCRIPTION ADDRESS 265
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Source for acquisition/subscription address (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=270]">
		<p>ADDRESS 270
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Address (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>270-b = City (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>State or province (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Country (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Postal code (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Title preceding attention name (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Attention name (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Title following attention name (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Type of address (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Specialized telephone number (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Telephone number (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fax number (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Electronic mail address (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>TDD or TTY number (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Contact person (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Title of contact person (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Hours (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=300]">
		<p>PHYSICAL DESCRIPTION 300
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Extent (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Other physical details (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Dimensions (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Accompanying material (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Type of unit (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Size of unit (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=301]">
		<p>PHYSICAL DESCRIPTION FOR FILMS (PRE-AACR 2) 301
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Extent of item (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Sound characteristics (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Color characteristics (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dimensions (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Accompanying material (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Speed (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=302]">
		<p>PAGE OR ITEM COUNT 302
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Page count (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=303]">
		<p>SUBORDINATE ENTITIES 303
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name or description (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Schedule (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Contact person (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=304]">
		<p>LINEAR FOOTAGE 304
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Linear footage (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=305]">
		<p>PHYSICAL DESCRIPTION FOR SOUND RECORDINGS (Pre-AACR 2) 305
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Extent (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Other physical details (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Dimensions (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Microgroove or standard (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Stereophonic, monaural (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Number of tracks (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Serial identification (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Matrix and/or take number (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=306]">
		<p>PLAYING TIME 306
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Playing time (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=307]">
		<p>HOURS, ETC. 307
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Hours (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Additional information (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=308]">
		<p>PHYSICAL DESCRIPTION FOR FILMS (ARCHIVAL) 308
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Number of reels (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Footage (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Sound characteristics (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Color characteristics (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Width (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Presentation format (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=310]">
		<p>CURRENT PUBLICATION FREQUENCY 310
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Current publication frequency (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Date of current publication frequency (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=311]">
		<p>MEETING ROOMS AND FACILITIES AVAILABLE 311
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>General description of facilities (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Name and location (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Physical description (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Capacity (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Equipment available (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Rental fee (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Special restrictions (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Accommodations for the disabled (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Miscellaneous information (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Contact person (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=312]">
		<p>EQUIPMENT AVAILABLE 312
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of equipment (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Brand name (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Physical description (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Rental fee (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Special restrictions (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Accommodations for the disabled (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Miscellaneous information (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Contact person (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=315]">
		<p>FREQUENCY 315
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Frequency (a)
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Dates of frequency (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=321]">
		<p>FORMER PUBLICATION FREQUENCY 321
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Former publication frequency (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Dates of former publication frequency (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=340]">
		<p>PHYSICAL MEDIUM 340
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Material base and configuration (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Dimensions (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Materials applied to surface (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Information recording technique (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Support (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Production rate/ratio (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Location within medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Technical specifications of medium (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=342]">
		<p>GEOSPATIAL REFERENCE DATA 342
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Coordinate or distance units (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Latitude resolution (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Longitude resolution (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Standard parallel or oblique line latitude (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Oblique line longitude (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Longitude of central meridian or projection center (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Latitude of projection origin or projection center (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>False easting (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>False northing (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Scale factor (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Height of perspective point above surface (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Azimuthal angle (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Azimuth measure point longitude or straight vertical longitude from pole (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Landsat number and path number (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Zone identifier (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Ellipsoid name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Semi-major axis (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Denominator of flattening ratio (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Vertical resolution (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Vertical encoding method (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Local planar, local, or other projection or grid description (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Local planar or local georeference information (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Reference method used (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=343]">
		<p>PLANAR COORDINATE DATA 343
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Planar coordinate encoding method (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Planar distance units (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Abscissa resolution (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Ordinate resolution (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Distance resolution (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Bearing resolution (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Bearing units (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Bearing reference direction (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Bearing reference meridian (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='=']">
				<li>ICE (=):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
<!-- 
	
	<xsl:for-each select="marc:subfield[@code='a']">
				<li>Price (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Form of issue:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each> -->
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=351]">
		<p>ORGANIZATION AND ARRANGEMENT OF MATERIALS 351
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Organization (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Arrangement (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Hierarchical level (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=352]">
		<p>DIGITAL GRAPHIC REPRESENTATION 352
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Direct reference method (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Object type (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Object count (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Row count (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Column count (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Vertical count (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Indirect reference description (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=355]">
		<p>SECURITY CLASSIFICATION CONTROL 355
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Security classification (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Handling instructions (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>External dissemination information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Downgrading or declassification event (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Classification system (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Country of origin code (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Downgrading date (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Declassification date (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Authorization (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=357]">
		<p>ORIGINATOR DISSEMINATION CONTROL 357
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Originator control term (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Originating agency (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Authorized recipients of material (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Other restrictions (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=359]">
		<p>RENTAL PRICE 359
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Rental price (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=362]">
		<p>DATES OF PUBLICATION AND/OR SEQUENTIAL DESIGNATION 362
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Dates of publication and/or sequential designation (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=440]">
		<p>SERIES STATEMENT/ADDED ENTRY--TITLE 440
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=490]">
		<p>SERIES STATEMENT 490
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Series statement (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Library of Congress call number (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=500]">
		<p>GENERAL NOTE 500
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>General note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Library of Congress call number (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=501]">
		<p>WITH NOTE 501
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>With note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=502]">
		<p>DISSERTATION NOTE 502
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Dissertation note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=503]">
		<p>BIBLIOGRAPHIC HISTORY NOTE 503 
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Bibliographic history note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=504]">
		<p>BIBLIOGRAPHY, ETC. NOTE 504
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Bibliography, etc. note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number of references (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=505]">
		<p>FORMATTED CONTENTS NOTE 505
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Formatted contents note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Statement of responsibility (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=506]">
		<p>RESTRICTIONS ON ACCESS NOTE 506
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Terms governing access (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Jurisdiction (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Physical access provisions (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Authorized users (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Authorization (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=507]">
		<p>SCALE NOTE FOR GRAPHIC MATERIAL 507
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Representative fraction of scale note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Remainder of scale note (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=508]">
		<p>CREATION/PRODUCTION CREDITS NOTE 508
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Creation/production credits note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=510]">
		<p>CITATION/REFERENCES NOTE 510
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name of source (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Dates of coverage of source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location within source (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=511]">
		<p>PARTICIPANT OR PERFORMER NOTE 511
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Participant or performer note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=512]">
		<p>EARLIER OR LATER VOLUMES SEPARATELY CATALOGED NOTE 512
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Earlier or later volumes separately cataloged note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=513]">
		<p>TYPE OF REPORT AND PERIOD COVERED NOTE 513
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of report (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Period covered (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=514]">
		<p>DATA QUALITY NOTE 514
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Attribute accuracy report (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Attribute accuracy value (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Attribute accuracy explanation (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Logical consistency report (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Completeness report (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Horizontal position accuracy report (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Horizontal position accuracy value (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Horizontal position accuracy explanation (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Vertical positional accuracy report (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Vertical positional accuracy value (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Vertical positional accuracy explanation (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Cloud cover (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Display note (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=515]">
		<p>NUMBERING PECULIARITIES NOTE 515
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Numbering peculiarities note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=516]">
		<p>TYPE OF COMPUTER FILE OR DATA NOTE 516
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of computer file or data note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=517]">
		<p>CATEGORIES OF FILMS NOTE (ARCHIVAL) 517
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Different formats (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Content descriptors (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Additional animation techniques (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=518]">
		<p>DATE/TIME AND PLACE OF AN EVENT NOTE 518
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Date/time and place of an event note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=520]">
		<p>SUMMARY, ETC. 520
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Summary, etc. (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Expansion of summary note (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=521]">
		<p>TARGET AUDIENCE NOTE 521
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Target audience note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=522]">
		<p>GEOGRAPHIC COVERAGE NOTE 522
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic coverage note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=523]">
		<p>TIME PERIOD OF CONTENT NOTE 523
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Time period of content note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Dates of data collection note (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=524]">
		<p>PREFERRED CITATION OF DESCRIBED MATERIALS NOTE 524
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Preferred citation of described materials note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of schema used (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=525]">
		<p>SUPPLEMENT NOTE 525
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Supplement note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=526]">
		<p>STUDY PROGRAM INFORMATION NOTE 526
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Program name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Interest level (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Reading level (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Title point value (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=527]">
		<p>CENSORSHIP NOTE 527
</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Censorship note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=530]">
		<p>ADDITIONAL PHYSICAL FORM AVAILABLE NOTE 530
</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Additional physical form available note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Availability source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Availability conditions (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Order number (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=531]">
		<p>ELIGIBILITY, FEES, PROCEDURES NOTE 531
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Eligibility (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Fee (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Admission procedures (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Documents required (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Waiting list (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Waiting period (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=533]">
		<p>REPRODUCTION NOTE 533
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of reproduction (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Place of reproduction (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Agency responsible for reproduction (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of reproduction (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description of reproduction (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of reproduction (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Dates of publication and/or sequential designation of issues reproduced (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about reproduction (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Fixed-length data elements of reproduction (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=534]">
		<p>ORIGINAL VERSION NOTE 534
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry of original (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition statement of original (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Publication, distribution, etc. of original (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description, etc. of original (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of original (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Key title of original (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Location of original (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about original (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Introductory phrase (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title statement of original (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=535]">
		<p>LOCATION OF ORIGINALS/DUPLICATES NOTE 535
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Custodian (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Postal address (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Country (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Telecommunications address (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Repository location code (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=536]">
		<p>FUNDING INFORMATION NOTE 536
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Text of note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Contract number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Grant number (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Undifferentiated number (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Program element number (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Project number (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Task number (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Work unit number (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=537]">
		<p>SOURCE OF DATA NOTE 537
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Source of data note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=538]">
		<p>SYSTEM DETAILS NOTE 538
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>System details note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=540]">
		<p>TERMS GOVERNING USE AND REPRODUCTION NOTE 540
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Terms governing use and reproduction (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Jurisdiction (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Authorization (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Authorized users (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=541]">
		<p>IMMEDIATE SOURCE OF ACQUISITION NOTE 541
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Source of acquisition (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Address (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Method of acquisition (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of acquisition (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Accession number (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Owner (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Purchase price (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Extent (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of unit (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=543]">
		<p>SOLICITATION INFORMATION NOTE 543
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Solicitation information note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=544]">
		<p>LOCATION OF OTHER ARCHIVAL MATERIALS NOTE 544
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Custodian (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Address (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Country (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Title (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Provenance (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=545]">
		<p>BIOGRAPHICAL OR HISTORICAL DATA 545
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Biographical or historical data (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Expansion (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=546]">
		<p>LANGUAGE NOTE 546
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Language note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Information code or alphabet (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=547]">
		<p>FORMER TITLE COMPLEXITY NOTE 547
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Former title complexity note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=550]">
		<p>ISSUING BODY NOTE 550
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Issuing body note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=552]">
		<p>ENTITY AND ATTRIBUTE INFORMATION NOTE 552
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Entity type label (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Entity type definition and source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Attribute label (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Attribute definition and source (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Enumerated domain value (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Enumerated domain value definition and source (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Range domain minimum and maximum (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Codeset name and source (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Unrepresentable domain (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribute units of measurement and resolution (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Beginning date and ending date of attribute values (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Attribute value accuracy (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Attribute value accuracy explanation (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Attribute measurement frequency (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Entity and attribute overview (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Entity and attribute detail citation (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Display note (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=555]">
		<p>CUMULATIVE INDEX/FINDING AIDS NOTE 555
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Cumulative index/finding aids note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Availability source (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Degree of control (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Bibliographic reference (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=556]">
		<p>INFORMATION ABOUT DOCUMENTATION NOTE 556
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Information about documentation note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=561]">
		<p>OWNERSHIP AND CUSTODIAL HISTORY 561
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>History (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Time of collation (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=562]">
		<p>COPY AND VERSION IDENTIFICATION NOTE 562
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Identifying markings (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Copy identification (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Version identification (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Presentation format (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Number of copies (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=565]">
		<p>CASE FILE CHARACTERISTICS NOTE 565
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Number of cases/variables (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Name of variable (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Unit of analysis (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Universe of data (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Filing scheme or code (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=567]">
		<p>METHODOLOGY NOTE 567
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Methodology note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=570]">
		<p>EDITOR NOTE 570
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Editor note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=571]">
		<p>VOLUNTEERS NOTE 571
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Volunteers note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Special requirements (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=572]">
		<p>AFFILIATION AND OTHER RELATIONSHIPS NOTE 572
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Affiliation and other relationships note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=573]">
		<p>CREDENTIALS NOTE 573
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Credentials note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=574]">
		<p>TRANSPORTATION AND DIRECTIONS NOTE 574
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Transportation and directions note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=575]">
		<p>ACCOMMODATIONS FOR THE DISABLED NOTE 575
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Accommodations for the disabled note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=576]">
		<p>SERVICES AVAILABLE NOTE 576
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Services available note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=580]">
		<p>LINKING ENTRY COMPLEXITY NOTE 580
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Linking entry complexity note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Source of note information (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=581]">
		<p>PUBLICATIONS ABOUT DESCRIBED MATERIALS NOTE 581
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Publications about described materials note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=582]">
		<p>RELATED COMPUTER FILES NOTE 582
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Related computer files note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=583]">
		<p>ACTION NOTE 583
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Action (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Action identification (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Time of action (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Action interval (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Contingency for action (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Authorization (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Jurisdiction (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Method of action (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Site of action (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Action agent (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Status (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Extent (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of unit (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of item (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=584]">
		<p>ACCUMULATION AND FREQUENCY OF USE NOTE 584
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Accumulation (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Frequency of use (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=585]">
		<p>EXHIBITIONS NOTE 585
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Exhibitions note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=586]">
		<p>AWARDS NOTE 586
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Awards note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=587]">
		<p>OTHER INFORMATION AVAILABLE NOTE 587
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Other information available note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=590]">
		<p>LOCAL NOTE 590
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Local note (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Provenance (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Condition of individual reels (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=600]">
		<p>SUBJECT ADDED ENTRY--PERSONAL NAME 600
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=610]">
		<p>SUBJECT ADDED ENTRY--CORPORATE NAME 610
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=611]">
		<p>SUBJECT ADDED ENTRY--MEETING NAME 611
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=630]">
		<p>SUBJECT ADDED ENTRY--UNIFORM TITLE 630
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=650]">
		<p>SUBJECT ADDED ENTRY--TOPICAL TERM 650
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Topical term or geographic name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Topical term following geographic name as entry element (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of event (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Active dates (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=651]">
		<p>SUBJECT ADDED ENTRY--GEOGRAPHIC NAME 651
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Geographic name following place entry element (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=652]">
		<p>SUBJECT ADDED ENTRY--REVERSED GEOGRAPHIC 652
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Geographic name of place element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=653]">
		<p>INDEX TERM--UNCONTROLLED 653
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uncontrolled term (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=654]">
		<p>SUBJECT ADDED ENTRY--FACETED TOPICAL TERMS 654
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Focus term (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Non-focus term (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Facet/hierarchy designation (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of heading or term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Material specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=655]">
		<p>INDEX TERM--GENRE/FORM/PHYSICAL CHARACTERISTICS 655
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Genre/form/physical characteristics (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Non-focus term (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Facet/hierarchy designation (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=656]">
		<p>INDEX TERM--OCCUPATION 656
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Occupation (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=657]">
		<p>INDEX TERM--FUNCTION 657
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Function (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Form subdivision (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=658]">
		<p>INDEX TERM--CURRICULUM OBJECTIVE 658
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main curriculum objective (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate curriculum objective (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Curriculum code (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Correlation factor (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=700]">
		<p>ADDED ENTRY--PERSONAL NAME 700
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=705]">
		<p>ADDED ENTRY--PERSONAL NAME (PERFORMER) 705
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=710]">
		<p>ADDED ENTRY--CORPORATE NAME 710
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=711]">
		<p>ADDED ENTRY--MEETING NAME 711
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=715]">
		<p>ADDED ENTRY--CORPORATE NAME-PERFORMING GROUP 715
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Nonprinting information (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=720]">
		<p>ADDED ENTRY--UNCONTROLLED NAME 720
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=730]">
		<p>ADDED ENTRY--UNIFORM TITLE 730
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=740]">
		<p>ADDED ENTRY--UNCONTROLLED RELATED/ANALYTICAL TITLE 740
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uncontrolled related/analytical title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Institution to which field applies (5):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=752]">
		<p>ADDED ENTRY--HIERARCHICAL PLACE NAME 752
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Country (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>State, province, territory (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>County, region, islands area (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>City (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=753]">
		<p>SYSTEM DETAILS ACCESS TO COMPUTER FILES 753
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Make and model of machine (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Programming language (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Operating system (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=754]">
		<p>ADDED ENTRY--TAXONOMIC IDENTIFICATION 754
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Taxonomic name/taxonomic hierarchical category (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of taxonomic identification (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=755]">
		<p>ADDED ENTRY--PHYSICAL CHARACTERISTICS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Access term (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>General subdivision (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Chronological subdivision (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Geographic subdivision (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of term (2):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=760]">
		<p>MAIN SERIES ENTRY 760
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text(i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=762]">
		<p>SUBSERIES ENTRY 762
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=765]">
		<p>ORIGINAL LANGUAGE ENTRY 765
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=767]">
		<p>TRANSLATION ENTRY 767
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=770]">
		<p>SUPPLEMENT/SPECIAL ISSUE ENTRY 770
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text (i):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number (w):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation (y):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number (z):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield (7):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	
	<!-- to here -->
	
	<xsl:template match="marc:datafield[@tag=772]">
		<p>PARENT RECORD ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=773]">
		<p>HOST ITEM ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Abbreviated title (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=774]">
		<p>CONSTITUENT UNIT ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=775]">
		<p>OTHER EDITION ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Language code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Country code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=776]">
		<p>ADDITIONAL PHYSICAL FORM ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=777]">
		<p>ISSUED WITH ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=780]">
		<p>PRECEDING ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=785]">
		<p>SUCCEEDING ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=786]">
		<p>ISSUED WITH ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Period of content:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Abbreviated title (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Source contribution:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=787]">
		<p>NONSPECIFIC RELATIONSHIP ENTRY
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Main entry heading:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Edition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Qualifying information (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Place, publisher, and date of publication:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Relationship information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Physical description of source:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Display text:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Series data for related item:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Material-specific details:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Other item identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Parallel title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Report number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Uniform title (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Standard Technical Report Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>International Standard Serial Number (x):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>CODEN designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>International Standard Book Number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Control subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=800]">
		<p>SERIES ADDED ENTRY--PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Attribution qualifier (j):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=810]">
		<p>SERIES ADDED ENTRY--CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=811]">
		<p>SERIES ADDED ENTRY--MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=830]">
		<p>SERIES ADDED ENTRY--UNIFORM TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume number/sequential designation (v):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=840]">
		<p>SERIES ADDED ENTRY--TITLE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Volume or number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=841]">
		<p>HOLDINGS CODED DATA VALUES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of record:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Fixed-length data elements:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Encoding level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=842]">
		<p>TEXTUAL PHYSICAL FORM DESIGNATOR
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual physical form designator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=843]">
		<p>REPRODUCTION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Type of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Place of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Agency responsible for reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Physical description of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Series statement of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Dates of publication and/or sequential designation of issues reproduced:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Note about reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Fixed-length data elements of reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=844]">
		<p>NAME OF UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name of unit:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=845]">
		<p>TERMS GOVERNING USE AND REPRODUCTION NOTE
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Terms governing use and reproduction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Jurisdiction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Authorization:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Authorized users:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=850]">
		<p>HOLDING INSTITUTION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Holding institution:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Holdings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Inclusive dates (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Retention statement:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=851]">
		<p>LOCATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Name (custodian or owner):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Institutional division:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Street address:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Country:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Location of units:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Item number (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Repository location code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=852]">
		<p>LOCATION/CALL NUMBER
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Sublocation or collection:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Shelving location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Address:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Coded location qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Qualifier type:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Number of units 1-9:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>= Unit type:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Non-coded location qualifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Classification part:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Item part:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Shelving control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Call number prefix:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Shelving form of title:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Call number suffix:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Country code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of classification or shelving scheme:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=853]">
		<p>CAPTIONS AND PATTERN--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=854]">
		<p>CAPTIONS AND PATTERN--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of supplementary material:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=855]">
		<p>CAPTIONS AND PATTERN--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Type of index:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Bibliographic units per next higher level:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Numbering continuity:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Frequency:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Calendar change:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Regularity pattern:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=856]">
		<p>ELECTRONIC LOCATION AND ACCESS
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Field Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Host name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Access number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Compression information:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Path:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Electronic name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Uniform resource name:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Processor of request:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Instruction:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Bits per second:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Password:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Logon:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Contact for access assistance:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Name of location of host in subfield $a:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Operating system:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Port:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Electronic format type :
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Settings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>File size:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Terminal emulation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Uniform Resource Identifier:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Hours access method available:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Record control number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Link text :
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Access method:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=863]">
		<p>ENUMERATION AND CHRONOLOGY--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=864]">
		<p>ENUMERATION AND CHRONOLOGY--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Title of supplementary material:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=865]">
		<p>ENUMERATION AND CHRONOLOGY--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>First level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Third level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Fourth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Fifth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Sixth level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Alternative numbering scheme, first level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Alternative numbering scheme, second level of enumeration:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>First level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Second level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Third level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Fourth level of chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Alternative numbering scheme, chronology:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Converted Gregorian year:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Title of index:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Piece physical condition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Copyright article-fee code:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Break indicator:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=866]">
		<p>TEXTUAL HOLDINGS--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual string:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=867]">
		<p>TEXTUAL HOLDINGS--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual holdings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=868]">
		<p>TEXTUAL HOLDINGS--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Textual holdings:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=870]">
		<p>VARIANT PERSONAL NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Personal name (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Numeration (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Titles and other words associated with a name (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Dates associated with a name (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 870 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Fuller form of name (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=871]">
		<p>VARIANT CORPORATE NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Corporate name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Subordinate unit (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting or treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Relator term (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 871 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=872]">
		<p>VARIANT CONFERENCE OR MEETING NAME
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Meeting name or jurisdiction name as entry element (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Number (BK CF MP MU SE VM MX) (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Location of meeting (c):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of meeting (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Subordinate unit (e):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 872 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section/meeting (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Name of meeting following jurisdiction name entry element (q):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Affiliation (u):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Relator code (4):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=873]">
		<p>VARIANT UNIFORM TITLE HEADING
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Uniform title (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date of treaty signing (d):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Date of a work (f):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Miscellaneous information (g):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Medium (h):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Tag and sequence number of the field for which 873 is a variant(R):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Form subheading (k):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Language of a work (l):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Medium of performance for music (m):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Number of part/section of a work (n):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Arranged statement for music (o):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Name of part/section of a work (p):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Key for music (r):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Version (s):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Title of a work (t):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=876]">
		<p>ITEM INFORMATION--BASIC BIBLIOGRAPHIC UNIT
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number (a):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number (b):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=877]">
		<p>ITEM INFORMATION--SUPPLEMENTARY MATERIAL
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=878]">
		<p>ITEM INFORMATION--INDEXES
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Invalid or cancelled internal item number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Cost:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Date acquired:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Source of acquisition:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Use restrictions:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Item status:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Temporary location:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Invalid or cancelled piece designation:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Copy number:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Nonpublic note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Public note:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Materials specified (3):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Link and sequence number (8):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=880]">
		<p>ALTERNATE GRAPHIC REPRESENTATION
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Linkage (6):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='0']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='1']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Same as associated field:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='9']">
				<li>Undefined; each contains blank (#):
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	<xsl:template match="marc:datafield[@tag=886]">
		<p>FOREIGN MARC INFORMATION FIELD
		</p>
		<ul>
			<xsl:for-each select="marc:subfield[@code='a']">
				<li>Tag of the foreign MARC field/Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='b']">
				<li>Content of the foreign MARC field/Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='2']">
				<li>Source of data:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='c']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='d']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='e']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='f']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='g']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='h']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='i']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='j']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='k']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='l']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='m']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='n']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='o']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='p']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='q']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='r']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='s']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='t']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='u']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='v']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='w']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='x']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='y']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='z']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='0']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='1']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='3']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='4']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='5']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='6']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='7']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='8']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
			<xsl:for-each select="marc:subfield[@code='9']">
				<li>Foreign MARC subfield:
				<xsl:value-of select="text()"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
</xsl:stylesheet>
<!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios ><scenario default="no" name="Ray Charles" userelativepaths="yes" externalpreview="no" url="..\xml\MARC21slim\raycharles.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/><scenario default="yes" name="s7" userelativepaths="yes" externalpreview="no" url="..\ifla\sally7.xml" htmlbaseurl="" processortype="internal" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""/></scenarios><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
</metaInformation>
-->