/*
 *	recite - english text speech synthesizer
 *	Copyright (C) 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to provide consistent -Help behaviour
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <arglex.h>
#include <error.h>
#include <help.h>
#include <patchlevel.h>


int isatty _((int));


static char *cr[] =
{
	"%s version %v",
	"Copyright (C) 1993 Peter Miller.",
	"All rights reserved.",
	"",
	"The %s program comes with ABSOLUTELY NO WARRANTY;",
	"for details use the '%s -VERSion Warranty' command.",
	"The %s program is free software, and you are welcome to",
	"redistribute it under certain conditions;",
	"for details use the '%s -VERSion Redistribution' command.",
};

static char *au[] =
{
	"Peter Miller   UUCP      uunet!munnari!bmr.gov.au!pmiller",
	"/\\/\\*          Internet  pmiller@bmr.gov.au",
};


static void interpret _((FILE *, char **, int, char *));

static void
interpret(fp, text, text_len, prefix)
	FILE	*fp;
	char	**text;
	int	text_len;
	char	*prefix;
{
	int	j;

	for (j = 0; j < text_len; ++j)
	{
		char	indent[10];
		char	*ip1;
		char	*ip2;
		char	*s;

		s = text[j];
		strcpy(indent, prefix);
		ip2 = indent + strlen(indent);
		ip1 = s;
		while (isspace(*ip1))
			*ip2++ = *ip1++;
		*ip2 = 0;
		if (ip1[0] == '%' && isupper(ip1[1]) && !ip1[2])
		{
			switch (ip1[1])
			{
			default:
				assert(0);
				break;

			case 'C':
				interpret(fp, cr, SIZEOF(cr), indent);
				break;

			case 'A':
				interpret(fp, au, SIZEOF(au), indent);
				break;
			}
			continue;
		}
		if (*prefix)
			fputs(prefix, fp);
		while (*s)
		{
			if (*s != '%')
				putc(*s, fp);
			else
			{
				switch (*++s)
				{
				default:
					assert(0);
					break;

				case '%':
					putc(*s, fp);
					break;

				case 's':
					fputs(progname, fp);
					break;

				case 'v':
					fputs(version_stamp(), fp);
					break;
				}
			}
			++s;
		}
		fputc('\n', fp);
	}
}


void
help(text, text_len, usage)
	char	**text;
	int	text_len;
	void	(*usage)_((void));
{
	FILE	*fp;
	char	*pager;

	/*
	 * collect the rest of thge command line,
	 * if necessary
	 */
	if (usage && arglex() != arglex_token_eoln)
		usage();

	/*
	 * if output is to the terminal,
	 * send the output through a paginator
	 */
	if (isatty(0))
	{
		pager = getenv("PAGER");
		if (!pager)
			pager = "more";
	}
	else
		pager = 0;

	/*
	 * open the paginator
	 */
	if (pager)
	{
		fp = popen(pager, "w");
		if (!fp)
		{
			nerror("%s", pager);
			pager = 0;
			fp = stdout;
		}
	}
	else
		fp = stdout;

	/*
	 * do what they asked
	 */
	interpret(fp, text, text_len, "");

	/*
	 * close the paginator
	 */
	if (pager)
		pclose(fp);
}


char *
version_stamp()
{
	return PATCHLEVEL;
}
