#' Sample events with PSI data
#'
#' Contains sample PSI and quality score data as produced by \code{vast-tools
#' combine}.
#'
#' @docType data
#' @name psi
#' @usage psi
#' @format A 5 x 22 data frame
#' @keywords datasets
NULL

#' Sample psiplot configuration settings for datasets \code{psi} and \code{crpkm}
#'
#' Example of how a psiplot configuration file should be formatted. This can be
#' passed to \code{\link{plot_event}}, \code{\link{plot_multievent}} or
#' \code{\link{plot_expr}} using the \code{config} argument.
#'
#' @docType data
#' @name config
#' @usage config
#' @format A 8 x 5 data frame
#' @keywords datasets
NULL

#' Sample genes with cRPKM data
#'
#' Contains sample cRPKM data as produced by \code{vast-tools combine}.
#'
#' @docType data
#' @name crpkm
#' @usage crpkm
#' @format A 6 x 10 data frame
#' @keywords datasets
NULL

#' Sample genes with cRPKM and counts data
#'
#' Contains sample cRPKM data and raw read counts
#'
#' @docType data
#' @name crpkm_counts
#' @usage crpkm_counts
#' @format A 6 x 18 data frame
#' @keywords datasets
NULL
