\name{dwpt.boot}
\alias{dwpt.boot}
\title{Bootstrap Time Series Using the DWPT}
\description{
  An adaptive orthonormal basis is selected in order to perform the
  naive bootstrap within nodes of the wavelet packet tree.  A bootstrap
  realization of the time series is produce by applying the inverse
  DWPT.
}
\usage{dwpt.boot(y, wf, J=log(length(y),2)-1, p=1e-04, frac=1)
}
\arguments{
  \item{y}{Not necessarily dyadic length time series.}
  \item{wf}{Name of the wavelet filter to use in the decomposition.  See
    \code{\link{wave.filter}} for those wavelet filters available.}
  \item{J}{Depth of the discrete wavelet packet transform.}
  \item{p}{Level of significance for the white noise testing procedure.}
  \item{frac}{Fraction of the time series that should be used in
    constructing the likelihood function.}
}
\value{
  Time series of length $N$, where $N$ is the length of \code{y}.
}
\details{
  A subroutines is used to select an adaptive orthonormal basis for the
  piecewise-constant approximation to the underlying spectral density
  function (SDF).  Once selected, sampling with replacement is performed
  within each wavelet packet coefficient vector and the new collection
  of wavelet packet coefficients are reconstructed into a bootstrap
  realization of the original time series.
}
\references{
  Percival, D.B., S. Sardy, A. Davision (2000)
  Wavestrapping Time Series: Adaptive Wavelet-Based Bootstrapping,
  in B.J. Fitzgerald, R.L. Smith, A.T. Walden, P.C. Young (Eds.)
  \emph{Nonlinear and Nonstationary Signal Processing}, pp. 442-471.

  Whitcher, B. (2001)
  Simulating Gaussian Stationary Time Series with Unbounded Spectra,
  \emph{Journal of Computational and Graphical Statistics}, \bold{10},
  No. 1, 112-134.
  
  Whitcher, B. (2004)
  Wavelet-Based Estimation for Seasonal Long-Memory Processes,
  \emph{Technometrics}, \bold{46}, No. 2, 225-238.
}
\seealso{
  \code{\link{dwpt.sim}}, \code{\link{spp.mle}}
}
%\examples{}
\author{B. Whitcher}
\keyword{ts}
