% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sftime.R
\name{is_sortable}
\alias{is_sortable}
\title{Checks whether a vector or list is sortable}
\usage{
is_sortable(x)
}
\arguments{
\item{x}{The object to check.}
}
\value{
\code{TRUE} if \code{x} passes the check, else \code{FALSE}.
}
\description{
Checks whether a vector or list is sortable. This is the condition for a 
vector to be usable as time column in a \code{sftime} object.
}
\details{
Checks whether the provided object can be handled by 
\code{\link{order}}. A couple of basic types are whitelisted. However, custom 
types can be defined when they provide a dedicated generic to \link{xtfrm}. 
Note that a \code{list} can only be sorted with \link{atomic} values. See the 
examples below for a template.
}
\examples{
x <- Sys.time() + 5:1 * 3600 * 24
sort(x)
is_sortable(x)

}
\keyword{internal}
