% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ngonGrob.r
\name{ngonGrob}
\alias{ellipseGrob}
\alias{grid.ellipse}
\alias{grid.ngon}
\alias{ngonGrob}
\alias{polygon_regular}
\title{Regular polygon grob}
\usage{
ngonGrob(x, y, n = 5, size = 5, phase = pi/2, angle = 0, rho = 1,
  gp = gpar(colour = "black", fill = NA, linejoin = "mitre"), ...,
  position.units = "npc", size.units = "mm")

grid.ngon(...)

ellipseGrob(x, y, size = 5, angle = pi/4, rho = 1, n = 50,
  gp = gpar(colour = "black", fill = NA, linejoin = "mitre"), ...,
  position.units = "npc", size.units = "mm")

grid.ellipse(...)

polygon_regular(n = 5, phase = 0)
}
\arguments{
\item{x}{x unit}

\item{y}{y unit}

\item{n}{number of vertices}

\item{size}{radius of circumscribing circle}

\item{phase}{angle in radians of first point relative to x axis}

\item{angle}{angle of polygon in radians}

\item{rho}{aspect ratio}

\item{gp}{gpar}

\item{...}{further parameters passed to polygonGrob}

\item{position.units}{default units for the positions}

\item{size.units}{grid units for the sizes}
}
\value{
grob
}
\description{
Regular polygons with optional rotation, stretching, and aesthetic attributes
}
\section{Functions}{
\itemize{
\item \code{ngonGrob}: return a polygon grob

\item \code{grid.ngon}: draw a polygon grob on the current device

\item \code{ellipseGrob}: return an ellipse grob

\item \code{grid.ellipse}: draw an ellipse grob

\item \code{polygon_regular}: return the x,y coordinates of a regular polygon inscribed in the unit circle
}}
\examples{
library(grid)
N <- 5
xy <- polygon_regular(N)*2

# draw multiple polygons
g <- ngonGrob(unit(xy[,1],"cm") + unit(0.5,"npc"),
              unit(xy[,2],"cm") + unit(0.5,"npc"),
              n = seq_len(N) + 2, gp=gpar(fill=1:N))

grid.newpage()
grid.draw(g)

# rotated and stretched
g2 <- ngonGrob(unit(xy[,1],"cm") + unit(0.5,"npc"),
              unit(xy[,2],"cm") + unit(0.5,"npc"),
              n = seq_len(N) + 2, rho = seq_len(N),
              phase = 0, angle=pi/(seq_len(N)+2),
              size=1:N+5)

grid.newpage()
grid.draw(g2)

# ellipse
g3 <- ellipseGrob(unit(xy[,1],"cm") + unit(0.5,"npc"),
                  unit(xy[,2],"cm") + unit(0.5,"npc"),
                  angle=-2*seq(0,N-1)*pi/5+pi/2,
                  size=5, rho=1/3)

grid.newpage()
grid.draw(g3)
}

