% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/escape.R
\name{escape}
\alias{escape}
\alias{escape_ansi}
\alias{sql_vector}
\title{Escape/quote a string.}
\usage{
escape(x, parens = NA, collapse = " ", con = NULL)

escape_ansi(x, parens = NA, collapse = "")

sql_vector(x, parens = NA, collapse = " ", con = NULL)
}
\arguments{
\item{x}{An object to escape. Existing sql vectors will be left as is,
character vectors are escaped with single quotes, numeric vectors have
trailing \code{.0} added if they're whole numbers, identifiers are
escaped with double quotes.}

\item{parens, collapse}{Controls behaviour when multiple values are supplied.
\code{parens} should be a logical flag, or if \code{NA}, will wrap in
parens if length > 1.

Default behaviour: lists are always wrapped in parens and separated by
commas, identifiers are separated by commas and never wrapped,
atomic vectors are separated by spaces and wrapped in parens if needed.}

\item{con}{Database connection.}
}
\description{
\code{escape()} requires you to provide a database connection to control the
details of escaping. \code{escape_ansi()} uses the SQL 92 ANSI standard.
}
\examples{
# Doubles vs. integers
escape_ansi(1:5)
escape_ansi(c(1, 5.4))

# String vs known sql vs. sql identifier
escape_ansi("X")
escape_ansi(sql("X"))
escape_ansi(ident("X"))

# Escaping is idempotent
escape_ansi("X")
escape_ansi(escape_ansi("X"))
escape_ansi(escape_ansi(escape_ansi("X")))
}
