% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAVisualize_volcano}
\alias{TCGAVisualize_volcano}
\title{Creates a volcano plot for DNA methylation or gene expression}
\usage{
TCGAVisualize_volcano(
  x,
  y,
  filename = "volcano.pdf",
  ylab = expression(paste(-Log[10], " (FDR corrected P-values)")),
  xlab = NULL,
  title = "Volcano plot",
  legend = NULL,
  label = NULL,
  xlim = NULL,
  ylim = NULL,
  color = c("black", "red", "green"),
  names = NULL,
  names.fill = TRUE,
  show.names = "significant",
  x.cut = 0,
  y.cut = 0.01,
  height = 5,
  width = 10,
  highlight = NULL,
  highlight.color = "orange",
  names.size = 4,
  dpi = 300
)
}
\arguments{
\item{x}{x-axis data (i.e. Diff mean beta-values or Log2FC).}

\item{y}{FDR adjusted p-value (q-value). This data will be transformed to -log10 values.}

\item{filename}{File name: volcano.pdf, volcano.svg, volcano.png. If NULL returns
the ggplot object.}

\item{ylab}{y axis text. Default: -Log10 FDR corrected P-values}

\item{xlab}{x axis text. Default: No text. Examples of input:
expression(paste(Log[2], "FoldChange"))}

\item{title}{main title. If not specified it will be
"Volcano plot (group1 vs group2)}

\item{legend}{Legend title}

\item{label}{vector of labels to be used in the figure.
Example: c("Not Significant","Hypermethylated in group1",
"Hypomethylated in group1"))#'}

\item{xlim}{x limits to cut image (i.e. c(-4,4))}

\item{ylim}{y limits to cut image (i.e. c(-1,10))}

\item{color}{vector of colors to be used in graph}

\item{names}{Names to be plotted if significant.
Should be the same size of x and y}

\item{names.fill}{Names should be filled in a color box?  Default: TRUE}

\item{show.names}{What names will be showed? Possibilities: "both", "significant", "highlighted"}

\item{x.cut}{x-axis threshold. Default: 0.0 If you give only one number (e.g. 0.2) the cut-offs will be
-0.2 and 0.2. Or you can give different cut-offs as a vector (e.g. c(-0.3,0.4))}

\item{y.cut}{q-values threshold (i.e. 0.01, 10^-10)}

\item{height}{Figure height}

\item{width}{Figure width}

\item{highlight}{List of genes/probes to be highlighted. It should be in the names argument.}

\item{highlight.color}{Color of the points highlighted}

\item{names.size}{Size of the names text}

\item{dpi}{Figure dpi}
}
\value{
Saves the volcano plot in the current folder
}
\description{
Creates a volcano plot from the
gene expression and DNA methylation analysis.
}
\details{
Creates a volcano plot from the gene expression and DNA methylation analysis.
   Please see the vignette for more information
}
\examples{
log2_foldchange <- runif(200, -2, 2)
fdr <- runif(200, 0.01, 1)
TCGAVisualize_volcano(
    x = log2_foldchange,
    y = fdr,
    x.cut = 1.5,
    y.cut = 0.01,
    title = "Title example",
    xlab = expression(paste(Log[2], "FoldChange"))
)
\dontrun{
beta_diff <- runif(200, -1, 1)
fdr <- runif(200, 0.01, 1)
TCGAVisualize_volcano(
    x = beta_diff,
    y = fdr,
    x.cut = 1.5,
    y.cut = 0.01,
    title = "Title example",
    xlab = expression(paste("DNA Methylation difference (", beta, "-values)"))
)
TCGAVisualize_volcano(
  x,
  y,
  filename = NULL,
  y.cut = 10000000,
  x.cut=0.8,
   names = rep("AAAA",length(x)),
   legend = "Status",
   names.fill = FALSE
)

TCGAVisualize_volcano(
  x,
  y,
  filename = NULL,
  y.cut = 10000000,
  x.cut = 0.8,
   names = as.character(1:length(x)),
   legend = "Status",
   names.fill = TRUE, highlight = c("1","2"),
   show = "both"
)
TCGAVisualize_volcano(
  x,
  y,
  filename = NULL,
  y.cut = 10000000,
  x.cut = c(-0.3,0.8),
  names = as.character(1:length(x)),
  legend = "Status",
  names.fill = TRUE,
  highlight = c("1","2"),
  show = "both"
)
}
while (!(is.null(dev.list()["RStudioGD"]))){dev.off()}
}
