#include "hybridcrypt.h"
#include <QDebug>
#include "configparams.h"
#include "QResource"



hybridCrypt::hybridCrypt()
{
  const uchar *d;
  QResource qrc(":/icons/mgc.raw");
  d=qrc.data();
  key1=d[32]-0x36;
  key2=d[33]-0x72;
  key3=d[34]-0xd8;
  key4=d[35]-0xFE;
}


bool hybridCrypt::deCrypt(QByteArray *ba, QString &result)
{
  int baSize;
  bool ok;
  int charCount=0;
  QString tempStr="0x00";
  short int bufI, bufI2, divzr, num1, num2, num3, num4, res1, res2, res3, res4;
  QString bufS, hexa, hexa1, hexa2;
  unsigned char r1,r2;
  result="";
  res1=res2=res3=res4=0;
  divzr=key1*key4;
  bufI2=key3*key2;
  divzr-=bufI2;
  if(divzr==0) return FALSE;
  baSize=ba->size()-2; //drop /r/n
  if(baSize<20)
    {
      hcFtpRemoteHost=hybridFtpRemoteHost;
      hcFtpLogin=hybridFtpLogin;
      hcFtpPassword=hybridFtpPassword;
      hcFtpRemoteDirectory=hybridFtpRemoteDirectory2;
      return TRUE;
    }
  do
    {
      for(bufI=0;bufI<4;bufI++,charCount+=2)
        {
          r1=ba->at(charCount);
          r2=ba->at(charCount+1);
          if(r1==0xFF)
            {
              r1=r2=0;
            }
          if(r1==0xFE)
            {
              r1=0;
            }
          if(r1==0xFD)
            {
              r1=r2;
              r2=0;
            }
          switch(bufI)
            {
            case 0: res1=r1*256+r2; break;
            case 1: res2=r1*256+r2; break;
            case 2: res3=r1*256+r2; break;
            case 3: res4=r1*256+r2; break;
            }
        }

      bufI= res1 * key4;
      bufI2= res2 * key3;
      num1= bufI - bufI2;
      num1= num1 / divzr;
      bufI= res2 * key1;
      bufI2= res1 * key2;
      num2= bufI - bufI2;
      num2 = num2 / divzr;
      bufI= res3 * key4;
      bufI2= res4 * key3;
      num3= bufI - bufI2;
      num3= num3 / divzr;
      bufI= res4 * key1;
      bufI2= res3 * key2;
      num4= bufI - bufI2;
      num4= num4 / divzr;
      tempStr[2]=QChar(num1);
      tempStr[3]=QChar(num2);
      result.append(QChar(tempStr.toInt(&ok,16)));
      tempStr[2]=QChar(num3);
      tempStr[3]=QChar(num4);
      result.append(QChar(tempStr.toInt(&ok,16)));
    }
  while(charCount<baSize);
  reverseString(result);
  getParam(result);
  return TRUE;
}


void hybridCrypt::reverseString(QString & s)
{
  int i,j;
  QString t;
  for (i=0,j=s.length()-1;i<s.length();i++,j--)
    {
      t[j]=s[i];
    }
  s=t;
}

bool hybridCrypt::getParam(QString result)
{
  int a,b,c,d,e;
  a=result.indexOf(QChar(63));
  b=result.indexOf(QChar(34),a+1);
  c=result.indexOf(QChar(60),b+1);
  d=result.indexOf(QChar(62),c+1);
  e=result.indexOf(QChar(58),d+1);
  hcFtpRemoteHost=result.mid(a+1,b-a-1);
  hcFtpLogin=result.mid(b+1,c-b-1);
  hcFtpPassword=result.mid(c+1,d-c-1);
  hcFtpRemoteDirectory=result.mid(d+1,e-d-1);
  if(hcFtpRemoteDirectory.isEmpty())
    {
      hcFtpRemoteDirectory="HybridFiles";
    }
  return TRUE;
}





