# Licensed under a 3-clause BSD style license, see LICENSE.

# Convenient access to the version number
from typing import List

from . import constants, units
from ._version import version as __version__
from .constants.constants import (
    Avogadro,
    c_light,
    c_light_sq,
    e_sq,
    eminus,
    h_Planck,
    half_pi,
    hbar,
    hbar_Planck,
    hbarc,
    hbarc_sq,
    k_Boltzmann,
    pi,
    pi_sq,
    two_pi,
)
from .units.prefixes import (
    atto,
    centi,
    deca,
    deci,
    exa,
    exbi,
    femto,
    gibi,
    giga,
    googol,
    hecto,
    kibi,
    kilo,
    mebi,
    mega,
    micro,
    milli,
    nano,
    pebi,
    peta,
    pico,
    tebi,
    tera,
    yobi,
    yocto,
    yotta,
    zebi,
    zepto,
    zetta,
)
from .units.units import (
    GW,
    MW,
    A,
    Bq,
    Ci,
    EeV,
    GBq,
    GeV,
    GHz,
    Gy,
    H,
    Hz,
    J,
    K,
    MBq,
    MeV,
    MGy,
    MHz,
    N,
    Pa,
    PeV,
    Sv,
    TeV,
    THz,
    W,
    Wb,
    ZeV,
    ab,
    ampere,
    angstrom,
    atmosphere,
    attobarn,
    attosecond,
    bar,
    barn,
    becquerel,
    candela,
    cd,
    centimeter,
    centimeter2,
    centimeter3,
    cm,
    cm2,
    cm3,
    coulomb,
    curie,
    d,
    day,
    deg,
    degree,
    dyne,
    e_SI,
    electronvolt,
    eplus,
    erg,
    eV,
    exaelectronvolt,
    farad,
    fb,
    femtobarn,
    femtometer,
    femtosecond,
    fermi,
    fm,
    fm2,
    fm3,
    fs,
    g,
    gauss,
    gigabecquerel,
    gigaelectronvolt,
    gigahertz,
    gram,
    gray,
    h,
    henry,
    hertz,
    hour,
    invab,
    invfb,
    invmb,
    invnb,
    invpb,
    invub,
    joule,
    kBq,
    kelvin,
    keV,
    kg,
    kGy,
    kHz,
    kilobecquerel,
    kiloelectronvolt,
    kilogauss,
    kilogram,
    kilogray,
    kilohertz,
    kilometer,
    kilometer2,
    kilometer3,
    kilovolt,
    km,
    km2,
    km3,
    kW,
    lumen,
    lux,
    m,
    m2,
    m3,
    mb,
    mCi,
    megabecquerel,
    megaelectronvolt,
    megagray,
    megahertz,
    megavolt,
    meter,
    meter2,
    meter3,
    mg,
    mGy,
    microampere,
    microbarn,
    microcurie,
    microfarad,
    microgray,
    micrometer,
    micron,
    microsecond,
    microweber,
    milliampere,
    millibarn,
    millicurie,
    millifarad,
    milligram,
    milligray,
    millimeter,
    millimeter2,
    millimeter3,
    milliradian,
    millisecond,
    milliweber,
    minute,
    mm,
    mm2,
    mm3,
    mol,
    mole,
    mrad,
    ms,
    mWb,
    nanoampere,
    nanobarn,
    nanocurie,
    nanofarad,
    nanometer,
    nanosecond,
    nanoweber,
    nb,
    nCi,
    newton,
    ns,
    nWb,
    ohm,
    pascal,
    pb,
    petaelectronvolt,
    picobarn,
    picofarad,
    picosecond,
    ps,
    rad,
    radian,
    s,
    second,
    sievert,
    sr,
    steradian,
    teraelectronvolt,
    terahertz,
    tesla,
    ub,
    uCi,
    uGy,
    us,
    uWb,
    volt,
    watt,
    weber,
    y,
    year,
    yoctosecond,
    ys,
    zeptosecond,
    zettaelectronvolt,
    zs,
)

# Units and constants directly available


__all__ = (
    "GW",
    "MW",
    "A",
    "Avogadro",
    "Bq",
    "Ci",
    "EeV",
    "GBq",
    "GHz",
    "GeV",
    "Gy",
    "H",
    "Hz",
    "J",
    "K",
    "MBq",
    "MGy",
    "MHz",
    "MeV",
    "N",
    "Pa",
    "PeV",
    "Sv",
    "THz",
    "TeV",
    "W",
    "Wb",
    "ZeV",
    "__version__",
    "ab",
    "ampere",
    "angstrom",
    "atmosphere",
    "atto",
    "attobarn",
    "attosecond",
    "bar",
    "barn",
    "becquerel",
    "c_light",
    "c_light_sq",
    "candela",
    "cd",
    "centi",
    "centimeter",
    "centimeter2",
    "centimeter3",
    "cm",
    "cm2",
    "cm3",
    "constants",
    "coulomb",
    "curie",
    "d",
    "day",
    "deca",
    "deci",
    "deg",
    "degree",
    "dyne",
    "eV",
    "e_SI",
    "e_sq",
    "electronvolt",
    "eminus",
    "eplus",
    "eplus",
    "erg",
    "exa",
    "exaelectronvolt",
    "exbi",
    "farad",
    "fb",
    "femto",
    "femtobarn",
    "femtometer",
    "femtosecond",
    "fermi",
    "fm",
    "fm2",
    "fm3",
    "fs",
    "g",
    "gauss",
    "gibi",
    "giga",
    "gigabecquerel",
    "gigaelectronvolt",
    "gigahertz",
    "googol",
    "gram",
    "gray",
    "h",
    "h_Planck",
    "half_pi",
    "hbar",
    "hbar_Planck",
    "hbarc",
    "hbarc_sq",
    "hecto",
    "henry",
    "hertz",
    "hour",
    "invab",
    "invfb",
    "invmb",
    "invnb",
    "invpb",
    "invub",
    "joule",
    "joule",
    "kBq",
    "kGy",
    "kHz",
    "kW",
    "k_Boltzmann",
    "keV",
    "kelvin",
    "kelvin",
    "kg",
    "kibi",
    "kilo",
    "kilobecquerel",
    "kiloelectronvolt",
    "kilogauss",
    "kilogram",
    "kilogray",
    "kilohertz",
    "kilometer",
    "kilometer2",
    "kilometer3",
    "kilovolt",
    "km",
    "km2",
    "km3",
    "lumen",
    "lux",
    "m",
    "m",
    "m2",
    "m3",
    "mCi",
    "mGy",
    "mWb",
    "mb",
    "mebi",
    "mega",
    "megabecquerel",
    "megaelectronvolt",
    "megagray",
    "megahertz",
    "megavolt",
    "meter",
    "meter2",
    "meter3",
    "mg",
    "micro",
    "microampere",
    "microbarn",
    "microcurie",
    "microfarad",
    "microgray",
    "micrometer",
    "micron",
    "microsecond",
    "microweber",
    "milli",
    "milliampere",
    "millibarn",
    "millicurie",
    "millifarad",
    "milligram",
    "milligray",
    "millimeter",
    "millimeter2",
    "millimeter3",
    "milliradian",
    "millisecond",
    "milliweber",
    "minute",
    "mm",
    "mm2",
    "mm3",
    "mol",
    "mole",
    "mole",
    "mrad",
    "ms",
    "nCi",
    "nWb",
    "nano",
    "nanoampere",
    "nanobarn",
    "nanocurie",
    "nanofarad",
    "nanometer",
    "nanosecond",
    "nanoweber",
    "nb",
    "newton",
    "ns",
    "ohm",
    "pascal",
    "pb",
    "pebi",
    "peta",
    "petaelectronvolt",
    "pi",
    "pi_sq",
    "pico",
    "picobarn",
    "picofarad",
    "picosecond",
    "ps",
    "rad",
    "radian",
    "s",
    "s",
    "second",
    "sievert",
    "sr",
    "steradian",
    "tebi",
    "tera",
    "teraelectronvolt",
    "terahertz",
    "tesla",
    "two_pi",
    "uCi",
    "uGy",
    "uWb",
    "ub",
    "units",
    "us",
    "volt",
    "watt",
    "weber",
    "y",
    "year",
    "yobi",
    "yocto",
    "yoctosecond",
    "yotta",
    "ys",
    "zebi",
    "zepto",
    "zeptosecond",
    "zetta",
    "zettaelectronvolt",
    "zs",
)


def __dir__() -> List[str]:
    return list(__all__)
