#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a program for learn to use the mouse
# Copyright (C) 2005-2007 Vincent DEROO (vincent.pysycache@free.fr) 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software 
# Foundation, Inc. : 
# 51 Franklin Street, Fifth Floor, Boston, MA02110-1301, USA
#***********************************************************************



#*******************************************************************************
# Importation des modules
#*******************************************************************************
import sys
import getopt, string
import random
import time
import locale

import random
import os.path
import pygame
from pygame.locals import *

import datas
from pysyclasses import MouseOfActivity
from pysymove import ApplicationMove
from pysyclick import ApplicationClick
from pysybuttons import ApplicationButtons
from pysydblclick import ApplicationDblClick
from pysypuzzle import ApplicationPuzzle

from pysyclasses import BtnOfMenu


import const
import pysymove
import pysyclick
import pysybuttons
import pysydblclick
import pysypuzzle
import pysypreferences
import pysyscores
import pysycredits







#*******************************************************************************
# Event detection                                                              #
#*******************************************************************************
def DetectEvent():
	""" Traitement des evenements """
	for event in pygame.event.get():
		if event.type == QUIT:
			return 0
		elif event.type == KEYUP:
			if event.key == K_ESCAPE:
				return 0
		elif event.type == pygame.MOUSEMOTION:
			#*************** evenement deplacement de la souris ***************
			event0 = event.pos[0] 
			event1 = event.pos[1] 

			screen = pygame.display.get_surface()

			#redessin de la souris a sa position actuelle
			const.GMaSourisCurrentPositionX = event0 
			const.GMaSourisCurrentPositionY = event1 
			for o in const.GLstSouris.sprites():
				o.move(const.Gbackground_image)

			ShowTheHelpOnActivty()

			const.GLstSouris.draw(screen)
			pygame.display.update()
			
			return 1
		elif event.type == MOUSEBUTTONUP:
			#---------------------- on relache la souris -----------------------
			ok = 0
			event0 = event.pos[0] 
			event1 = event.pos[1] 
			screen = pygame.display.get_surface()  

			#recherche du bouton concerne
			for btn in TabBtnMenu :
				if ( event0 >= btn.left ) & ( event0 <= btn.left + btn.largeur ) & ( event1 >= btn.top  ) & ( event1 <= btn.top + btn.hauteur ) :
					ok = 1
					#----------- show the correct window -----------------
					#mise a jour de la zone d'aide
					const.Gbackground_image.blit(Background_Restore, (300, 300), (300, 300, 370, 200))

					if const.GWithSound == 1 :
						if not pygame.mixer.get_init():
							print "Cannot load sound : pygame error : ", pygame.get_error()
						else:
							if pygame.mixer.music.get_busy :
								pygame.mixer.music.stop()

					if ( btn.id == 1 ) :						#activite move
						const.AppMove.Execute()
					elif ( btn.id == 2) :						#activite click
						const.AppClick.Execute()
					elif ( btn.id == 3) :						#activite boutons
						const.AppButtons.Execute()
					elif ( btn.id == 4) :						#Quitter
						return 0
					elif ( btn.id == 7) :						#activite double-click
						const.AppDblClick.Execute()
					elif ( btn.id == 8) :						#preferences
						pysypreferences.ShowWindow(0)
					elif ( btn.id == 9) :						#meilleurs scores
						pysyscores.ShowWindow(0, 0, 0, 0)
					elif ( btn.id == 10): 						#activite puzzle
						const.AppPuzzle.Execute()
					elif ( btn.id == 11): 						#activite menu
						pysycredits.ShowWindow(0, 0, 0, 0)

					break

			if ok == 1:
				const.Gbackground_image.blit(Background_Restore, (0,0))
				for btn in TabBtnMenu:
					btn.visible = 1
					btn.LoadNormalPicture(Background_Restore)
				screen.blit(const.Gbackground_image, (0,0))

				const.GLstSouris.empty()
				const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
				for o in const.GLstSouris.sprites():
					o.move(const.Gbackground_image)
				const.GLstSouris.draw(screen)
				pygame.display.update()

	return 1


#*******************************************************************************
# 
#*******************************************************************************
def ShowTheHelpOnActivty():
	#recherche du bouton menu concerne par un survol
	#pour afficher l'aide sur l'activite
	inarea = 999
	screen = pygame.display.get_surface()
	for btn in TabBtnMenu:
		if ( const.GMaSourisCurrentPositionX >= btn.left ) & ( const.GMaSourisCurrentPositionX <= btn.left + btn.largeur ) & ( const.GMaSourisCurrentPositionY >= btn.top  ) & ( const.GMaSourisCurrentPositionY <= btn.top + btn.hauteur ) :
			#on est au dessus d'un bouton menu
			inarea = btn.id

			#peut on afficher l'image floutee ?
			if const.GBtnMenu != inarea:
				#on est actuellement en image normale et on passe en image floue
				#effacer l'ancien 
				for btnold in TabBtnMenu:
					if btnold.id == const.GBtnMenu :
						#mise a jour de l'image
						btnold.LoadNormalPicture(Background_Restore)
						break

				const.GBtnMenu = btn.id

				#afficher les effets visuels et sonores d'un survol pour l'aide
				btn.LoadSecondPicture(Background_Restore)

				#mise a jour de la zone d'aide (effacement)
				const.Gbackground_image.blit(Background_Restore, (171, 361), (171, 361, 400, 180))
				screen.blit(Background_Restore, (171, 361), (171, 361, 400, 180) )
				datas.ShowHelpOfBoutonMenu(btn.id, const.Gbackground_image)
			else:
				#on est deja en image floue : on ne fait rien
				pass
			break

	if inarea == 999:
		#on est pas au dessus d'un bouton menu
		#il faut remettre le bouton menu en normal
		if const.GBtnMenu == 999:
			#on est deja en bouton normal
			pass
		else:
			#on est en bouton flou : on passe a normal
			for btn in TabBtnMenu:
				if btn.id == const.GBtnMenu:
					#mise a jour de l'image du bouton
					btn.LoadNormalPicture(Background_Restore)

					#mise a jour de la zone d'aide (effacement)
					const.Gbackground_image.blit(Background_Restore, (171, 361), (171, 361, 400, 180))
					screen.blit(Background_Restore, (171, 361), (171, 361, 400, 180) )

					break
			const.GBtnMenu = 999





#*******************************************************************************
# Main of the program                                                          #
# parameters    typfull = 0 : in window                                        #
#                       = 1 : fullscreen                                       #
#*******************************************************************************
def ShowWindow(typfull):
	global TabBtnMenu 			#tableau des boutons de l'application
	TabBtnMenu = []
	global Background_Restore

	#lecture du fichier de configuration de l'utilisateur
	if const.GPysyUserMode == 0:
		#un joueur par utilisateur machine
		filenameuser = os.path.join(const.GRepPersoUser, "pysycacherc")
		#lecture du fichier de config
		const.GPrefUserInit.ReadConfigOfUser(filenameuser)
	else:
		#la lecture du fichier de config est faite en amont
		pass

	datas.InitializePreferences()

	#-------------------------  Initialise son ---------------------------------
	if const.GWithSound == 1:
		try:
			pygame.mixer.pre_init(44100, -16, 2, 2048)
		except  Exception, err:
			const.GWithSound = 0
			const.GSoundError = 1
			print ""
			print ""
			print "*************************************************************"
			print "*"
			print '*           Error in sound initialization : ', err
			print "*"
			print "*************************************************************"

	#-------------------------  Initialise screen ------------------------------
	if const.GPysyUserMode == 0:
		try:
			(nbtry, nbfail) = pygame.init()
			if nbfail != 0:
				const.GWithSound = 0
				const.GSoundError = 1
				datas.DebugMessage("Some errors occurs in pygame.init() : all sounds will be desactivated ")
			
		except  Exception, err:
			print ""
			print ""
			print "*************************************************************"
			print "*"
			print '*           Error in initialization : ', err
			print "*"
			print "*************************************************************"
			


	datas.DebugMessage("")
	datas.DebugMessage("Information on display")
	if const.GDebug == 1 :
		print pygame.display.Info()

	#whe hide the mouse for all the game
	pygame.mouse.set_visible(const.CACHE)

	#------------ recuperation de la valeur de la langue -----------------------
	datas.InitializeLang()

	#chargement du dictionnaire
	datas.LoadDicoLang()

	if const.GPysyUserMode == 0:
		if const.GWithFullScreen == 0:
			#mode fenetre
			screen = pygame.display.set_mode((800, 600))
			imgicone, img_rect = datas.Load_image("images", "pysycache-32x32.png")
			pygame.display.set_icon(imgicone)
		else:
			#mode plein ecran
			screen = pygame.display.set_mode((800, 600), FULLSCREEN)
	else:
		screen = pygame.display.get_surface()
		datas.DebugMessage("")
		datas.DebugMessage("Information on display")
		if const.GDebug == 1:
			print pygame.display.Info()
		pygame.display.set_caption('PySyCache')

	const.AppMove.InitializeApp(unicode("themes-move"), "move")
	const.AppClick.InitializeApp(unicode("themes-click"), "click")
	const.AppButtons.InitializeApp(unicode("themes-buttons"), "buttons")
	const.AppDblClick.InitializeApp(unicode("themes-dblclick"), "dblclick")
	const.AppPuzzle.InitializeApp(unicode("themes-puzzle"), "puzzle")

	#-------------------------- image vide de fond -----------------------------
	if const.GPysyUserMode == 0:
		background_image, background_rect = datas.Load_image("images", "fond1.png")
		screen.blit(background_image, (0,0))
		pygame.display.update()

		#attende de 1/2 seconde
		pygame.time.delay(500)

		#musique de fond
		datas.Load_sound("sounds", "startup.ogg")

		#------------------ transition vers le titre du jeu ------------------------
		datas.ShowTransitionOfTheme(const.GDureeTransition, "fond2.png", 0)
		pygame.time.delay(1000)

	#----------------------- transition vers le menu ---------------------------
	const.Gbackground_image, background_rect = datas.Load_image("images", "fond-menu.png")
	Background_Restore, background_rect = datas.Load_image("images", "fond-menu.png")
	datas.ShowTransitionOfTheme(const.GDureeTransition, "fond-menu.png", 0)

	#----------------------------- liste des boutons ---------------------------
	const.GBtnMenu = 999
	TabBtnMenu[:]=[]
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 1, 'menu-move1.png', 'menu-move.png', 19, 390) )				#menu vers activite move
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 2, 'menu-click1.png', 'menu-click.png', 98, 217) )				#menu vers activite clic
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 3, 'menu-button1.png', 'menu-button.png', 258, 161) )			#menu vers activite boutons
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 7, 'menu-dblclick1.png', 'menu-dblclick.png', 418, 115) )		#menu double click
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 8, 'btn-pref1.png', 'btn-pref.png', 612, 435) )				#menu preferences
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 9, 'btn-scores1.png', 'btn-scores.png', 602, 37) )				#menu scores
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 10, 'menu-puzzle1.png', 'menu-puzzle.png', 547, 260)) 			#menu puzzle
	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 11, 'menu-credits1.png', 'menu-credits.png', 55, 40)) 		#menu credits

	TabBtnMenu.append(BtnOfMenu("fond-menu.png", 4, 'btn-quitter1.png', 'btn-quitter.png', 690, 545) )			#menu quitter
	for btn in TabBtnMenu:
		btn.visible = 1
		btn.LoadNormalPicture(Background_Restore)

	screen.blit(const.Gbackground_image, (0, 0))

	#------------------- changer la souris en main -------------------------
	const.GLstSouris.empty()
	const.GLstSouris.add(MouseOfActivity(400, 300, "souris.png") )
	for o in const.GLstSouris.sprites():
		o.move(const.Gbackground_image)
	const.GLstSouris.draw(screen)
	
	pygame.display.update()
	pygame.event.clear()

	const.GTypeSouris = const.EVENT_JEU0

	#---------------------- entree dans la boucle principale -------------------
	running = 1
	while running:
		datas.Temporisation()

		#----------------- recherche des evt -----------------------------------
		running = DetectEvent()

		datas.ShowFPS()
