#! /usr/bin/perl -w

use strict;
use warnings;

use CGI;

use DBI;

use Classes::Filter;
use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/FilterList.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our $cgi = '';	# CGI data

LoadConfig();

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

  # Open the DB connection :
our $dbh = DB_Open();

  # Import CGI parameters :
$cgi = CGI->new();

our $PageTitle = ' - Filters List';
ParseComponent( 'CommonHeader' );
ParseComponent( 'Links' );

if ( $cgi->param( 'del' ) ) { DeleteFilterFile( $cgi->param( 'del' ) );};

print "<a href=\"Filters$conf{'extension'}?mode=edit\">Hand made filter</a><br><br>\n";

print "<b>Filters available :</b><br><br>\n";
print "<table class=\"bordered\" width=\"90%\" align=\"center\" border=\"1\">\n";

local *DIRECTORY;
opendir( DIRECTORY, 'generated/Filters/' );
foreach my $DirEntry ( sort readdir( DIRECTORY ) )
{
	if ( $DirEntry =~ m/^(.*)\.flt$/ )
	{
		my $FilterName = $1;

		my $Filter = Filter->new();
		$Filter->load( 'generated/Filters/'.$FilterName.'.flt' );

		my $TotalResultNb = $Filter->count();

		my $Bad = 0;
		if ( ! defined( $TotalResultNb ) ) { $Bad = 1; };

		print "  <tr>";

		print "<td valign=top><a href=\"FilterList$conf{'extension'}?del=".url_encode( $FilterName )."\">del</a></td>";
		print "<td valign=top><a href=\"Filters$conf{'extension'}?mode=edit&load=".url_encode( $FilterName )."\">edit</a></td>";

		print "<td valign=top align=right>".( $Bad?'<font color=red>bad</font>':$TotalResultNb ).'</td>';
		print "<td valign=top>";
		if ( ! $Bad )
		{
			print "<a href=\"Filters$conf{'extension'}?load=".url_encode( $FilterName )."\">";
		}
		print $FilterName;
		if ( ! $Bad ) {print '</a>';};
		print '</td>';

		print '<td>'.( $Filter->comment() || '&nbsp;' ).'</td>';
		print "  </tr>\n";
	}
}
closedir( DIRECTORY );

print "</table>\n";

ParseComponent( 'CommonFooter' );
