#!/bin/sh
#
# Copyright (C) 2005-2006 Joshua D. Abraham (jabra@ccs.neu.edu)
#
# This program is released under the terms of the GNU General Public License
# (GPL), which is distributed with this software in the the file "COPYING".
# The GPL specifies the terms under which users may copy and use this software.
#
# pbnj
# (P)orts (B)anners N' (J)unk
#
# Author:   Joshua D. Abraham
# Date:     March 15, 2005
# Updated:  July 19, 2006
# Version:  2.0
#
# This program is a simple install script for for PBNJ 2.0
#


install(){
    echo  "Building Makefile [ perl Makefile.PL ] ..."
    perl Makefile.PL
    if test $? -ne 0 ; then
        echo "Makefile error"
        error
    else
        echo "ok"
    fi

    echo  "Preparing PBNJ for Install [ make ] ..."
    make
    if test $? -ne 0 ; then
        echo "make didn't pass"
        error
    else
        echo "ok"
    fi

    echo  "Testing PBNJ for Install [ make test ] ..."
    make test
    if test $? -ne 0 ; then
        echo "All the tests didn't pass"
        error
    else
        echo "ok"
    fi

    echo  "Installing PBNJ [ sudo make install ] ..."
    sudo make install
    if test $? -ne 0 ; then
        echo "Install Failed"
        error
    else
        echo "ok"
        echo "PBNJ installed"
        echo "Run man pbnj for details";
    fi

    echo  "Cleaning up dir [ make realclean ]..."
    make realclean
    if test $? -ne 0 ; then
        echo "Cleanup  Failed"
        error
    else
        echo "ok"
        echo "Installation is now Complete"
    fi
}

ubuntuInstall() {
    if test `uname -s` == "Linux" -a -e /etc/lsb-release; then
	    source /etc/lsb-release
	    if test "$DISTRIB_ID" == "Ubuntu" ; then
		    echo "Installing the modules needed for PBNJ 2.0"
		    sudo apt-get install libdbi-perl \
		    libdbd-sqlite3-perl libyaml-perl libxml-twig-perl \
            libfile-which-perl libtext-csv-perl
            if test $? -ne 0 ; then 
                echo "Couldn't find one of the module packages in apt"
                nonUbuntuInstall
            fi
            echo "Here are the modules that are not provided by APT:"
            echo " - Nmap::Parser"
            echo " - File::HomeDir"
            echo "Do you have all the modules installed? [y/n]"
            read MOD
            if test "$MOD" == "y" -o "$MOD" == "yes" ; then
                install
            else
                echo "Use the directions in the INSTALL file."
            fi
        else
            nonUbuntuInstall
        fi
    elif test `uname -s` == "FreeBSD"; then
        echo "Here are the modules required for PBNJ"
        echo " - YAML           /usr/ports/databases/p5-DBI/ "
        echo " - DBI            /usr/ports/textproc/p5-YAML/ "
        echo " - DBD::SQLite    /usr/ports/databases/p5-DBD-SQLite"
        echo " - XML::Twig      /usr/ports/textproc/p5-XML-Twig/"
        echo " - Text-CSV_XS    /usr/ports/textproc/p5-Text-CSV_XS "
        echo " - Nmap::Parser   /usr/ports/security/p5-Nmap-Parser"
        echo " - File::Which    /usr/ports/sysutils/p5-File-Which"
        echo " - File::HomeDir  /usr/port/devel/p5-File-HomeDir"
        echo " "
        echo "Do you have all the modules installed? [y/n]"
        read MOD
        if test "$MOD" == "y" -o "$MOD" == "yes" ; then
            install
        else 
            echo "Use the directions in the INSTALL file."
        fi
    fi
}

nonUbuntuInstall(){ 
    echo "Here are the modules required for PBNJ"
    echo " - YAML"
    echo " - DBI"
    echo " - DBD::SQLite"
    echo " - XML::Twig"
    echo " - Nmap::Parser"
    echo " - File::Which"
    echo " - File::HomeDir"
    echo "Do you have all the modules installed? [y/n]"
    read MOD
    if test "$MOD" == "y" -o "$MOD" == "yes" ; then
        install
    elif test "$MOD" == "n" -o "$MOD" == "no" ; then
        echo "Use the directions in the INSTALL file."
    fi
}

# start with Ubuntu Install
echo "Install script for PBNJ 2.0"
ubuntuInstall
