###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_winamp_mult_bof_vuln.nasl 898 2009-01-27 20:15:29Z jan $
#
# Winamp AIFF File Multiple Buffer Overflow Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900197);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0263");
  script_bugtraq_id(33226);
  script_name("Winamp AIFF File Multiple Buffer Overflow Vulnerabilities");
  desc = "

  Overview: This host is installed with Winamp and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  Application fails to play a large Common Chunk (COMM) header value in an AIFF
  file and a large invalid value in an MP3 file.

  Impact:
  Attackers may leverage this issue by executing arbitrary codes in the context
  of the affected application and can execute denial of service attacks on the
  application.

  Impact Level: Application

  Affected Software/OS:
  Winamp version 5.541 and prior on Windows

  Fix: Upgrade to Winamp version 5.57 or later,
  For updates refer, http://www.winamp.com

  References:
  http://milw0rm.com/exploits/7742
  http://secunia.com/advisories/33478

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Winamp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_winamp_detect.nasl");
  script_require_keys("Winamp/Version");
  exit(0);
}


include("version_func.inc");

winampVer = get_kb_item("Winamp/Version");
if(!winampVer){
  exit(0);
}

#Check for version 5.541 (5.5.4.2165) and prior
if(version_is_less_equal(version:winampVer, test_version:"5.5.4.2165")){
  security_hole(0);
}
