# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory MDVSA-2009:045 (php)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63426);
 script_cve_id("CVE-2008-5557", "CVE-2008-5658", "CVE-2008-5624", "CVE-2008-5625");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Mandrake Security Advisory MDVSA-2009:045 (php)";
 script_name(name);

 desc = "The remote host is missing an update to php
announced via advisory MDVSA-2009:045.

A number of vulnerabilities have been found and corrected in PHP:

improve mbfl_filt_conv_html_dec_flush() error handling
in ext/mbstring/libmbfl/filters/mbfilter_htmlent.c
(CVE-2008-5557). Additionally on Mandriva Linux 2009.0 and up the
php-mbstring module is linked against a separate shared libmbfl
library that also have been patched to address CVE-2008-5557.

Directory traversal vulnerability in the ZipArchive::extractTo function
in PHP 5.2.6 and earlier allows context-dependent attackers to write
arbitrary files via a ZIP file with a file whose name contains .. (dot
dot) sequences. (CVE-2008-5658)

make sure the page_uid and page_gid get initialized properly in
ext/standard/basic_functions.c. Also, init server_context before
processing config variables in sapi/apache/mod_php5.c (CVE-2008-5624).

enforce restrictions when merging in dir entry in
sapi/apache/mod_php5.c and sapi/apache2handler/apache_config.c
(CVE-2008-5625).

On 2008.1, 2009.0 and cooker (2009.1) seen on x86_64 and with the
latest phpmyadmin 3.1.2 software made apache+php segfault (#26274,
#45864). This problem has been addressed by using -O0 for compiler
optimization and by using -fno-strict-aliasing. Either the bug is
in php and/or in gcc 4.3.2. Preferable just make it work as expected
for now.

In addition, the updated packages provide a number of bug fixes.

The updated packages have been patched to correct these issues.

Affected: 2008.0, 2008.1, 2009.0, Corporate 4.0

Solution:
To upgrade automatically use MandrakeUpdate or urpmi.  The verification
of md5 checksums and GPG signatures is performed automatically for you.

https://secure1.securityspace.com/smysecure/catid.html?in=MDVSA-2009:045

Risk factor : High";

 script_description(desc);

 summary = "Mandrake Security Advisory MDVSA-2009:045 (php)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Mandrake Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"apache-mod_php", rpm:"apache-mod_php~5.2.4~2.1mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bcmath", rpm:"php-bcmath~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bz2", rpm:"php-bz2~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-calendar", rpm:"php-calendar~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ctype", rpm:"php-ctype~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-curl", rpm:"php-curl~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dba", rpm:"php-dba~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dbase", rpm:"php-dbase~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dom", rpm:"php-dom~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-exif", rpm:"php-exif~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-filter", rpm:"php-filter~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ftp", rpm:"php-ftp~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gettext", rpm:"php-gettext~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gmp", rpm:"php-gmp~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-hash", rpm:"php-hash~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-iconv", rpm:"php-iconv~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-json", rpm:"php-json~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ldap", rpm:"php-ldap~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mcrypt", rpm:"php-mcrypt~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mhash", rpm:"php-mhash~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mime_magic", rpm:"php-mime_magic~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ming", rpm:"php-ming~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mssql", rpm:"php-mssql~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysql", rpm:"php-mysql~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysqli", rpm:"php-mysqli~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ncurses", rpm:"php-ncurses~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-odbc", rpm:"php-odbc~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pcntl", rpm:"php-pcntl~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo", rpm:"php-pdo~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_dblib", rpm:"php-pdo_dblib~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_mysql", rpm:"php-pdo_mysql~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_odbc", rpm:"php-pdo_odbc~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_pgsql", rpm:"php-pdo_pgsql~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_sqlite", rpm:"php-pdo_sqlite~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pgsql", rpm:"php-pgsql~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-posix", rpm:"php-posix~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pspell", rpm:"php-pspell~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-readline", rpm:"php-readline~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-recode", rpm:"php-recode~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-session", rpm:"php-session~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-shmop", rpm:"php-shmop~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-simplexml", rpm:"php-simplexml~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-snmp", rpm:"php-snmp~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sockets", rpm:"php-sockets~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sqlite", rpm:"php-sqlite~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvmsg", rpm:"php-sysvmsg~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvsem", rpm:"php-sysvsem~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvshm", rpm:"php-sysvshm~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tidy", rpm:"php-tidy~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tokenizer", rpm:"php-tokenizer~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-wddx", rpm:"php-wddx~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xml", rpm:"php-xml~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlreader", rpm:"php-xmlreader~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlwriter", rpm:"php-xmlwriter~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xsl", rpm:"php-xsl~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.4~3.4mdv2008.0", rls:"MNDK_2008.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_php", rpm:"apache-mod_php~5.2.5~5.1mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bcmath", rpm:"php-bcmath~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bz2", rpm:"php-bz2~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-calendar", rpm:"php-calendar~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ctype", rpm:"php-ctype~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-curl", rpm:"php-curl~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dba", rpm:"php-dba~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dbase", rpm:"php-dbase~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dom", rpm:"php-dom~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-exif", rpm:"php-exif~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-filter", rpm:"php-filter~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ftp", rpm:"php-ftp~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gettext", rpm:"php-gettext~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gmp", rpm:"php-gmp~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-hash", rpm:"php-hash~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-iconv", rpm:"php-iconv~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-json", rpm:"php-json~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ldap", rpm:"php-ldap~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mcrypt", rpm:"php-mcrypt~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mhash", rpm:"php-mhash~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mime_magic", rpm:"php-mime_magic~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ming", rpm:"php-ming~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mssql", rpm:"php-mssql~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysql", rpm:"php-mysql~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysqli", rpm:"php-mysqli~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ncurses", rpm:"php-ncurses~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-odbc", rpm:"php-odbc~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pcntl", rpm:"php-pcntl~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo", rpm:"php-pdo~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_dblib", rpm:"php-pdo_dblib~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_mysql", rpm:"php-pdo_mysql~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_odbc", rpm:"php-pdo_odbc~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_pgsql", rpm:"php-pdo_pgsql~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_sqlite", rpm:"php-pdo_sqlite~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pgsql", rpm:"php-pgsql~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-posix", rpm:"php-posix~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pspell", rpm:"php-pspell~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-readline", rpm:"php-readline~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-recode", rpm:"php-recode~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-session", rpm:"php-session~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-shmop", rpm:"php-shmop~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-snmp", rpm:"php-snmp~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sockets", rpm:"php-sockets~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sqlite", rpm:"php-sqlite~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvmsg", rpm:"php-sysvmsg~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvsem", rpm:"php-sysvsem~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvshm", rpm:"php-sysvshm~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tidy", rpm:"php-tidy~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tokenizer", rpm:"php-tokenizer~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-wddx", rpm:"php-wddx~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xml", rpm:"php-xml~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlreader", rpm:"php-xmlreader~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlwriter", rpm:"php-xmlwriter~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xsl", rpm:"php-xsl~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.5~14.3mdv2008.1", rls:"MNDK_2008.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_php", rpm:"apache-mod_php~5.2.6~3.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmbfl1", rpm:"libmbfl1~1.0.2~3.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libmbfl-devel", rpm:"libmbfl-devel~1.0.2~3.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bcmath", rpm:"php-bcmath~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-bz2", rpm:"php-bz2~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-calendar", rpm:"php-calendar~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ctype", rpm:"php-ctype~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-curl", rpm:"php-curl~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dba", rpm:"php-dba~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dbase", rpm:"php-dbase~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-dom", rpm:"php-dom~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-exif", rpm:"php-exif~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-filter", rpm:"php-filter~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ftp", rpm:"php-ftp~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gd", rpm:"php-gd~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gettext", rpm:"php-gettext~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-gmp", rpm:"php-gmp~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-hash", rpm:"php-hash~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-iconv", rpm:"php-iconv~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-imap", rpm:"php-imap~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-json", rpm:"php-json~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ldap", rpm:"php-ldap~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mcrypt", rpm:"php-mcrypt~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mhash", rpm:"php-mhash~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mime_magic", rpm:"php-mime_magic~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ming", rpm:"php-ming~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mssql", rpm:"php-mssql~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysql", rpm:"php-mysql~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mysqli", rpm:"php-mysqli~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-ncurses", rpm:"php-ncurses~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-odbc", rpm:"php-odbc~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-openssl", rpm:"php-openssl~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pcntl", rpm:"php-pcntl~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo", rpm:"php-pdo~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_dblib", rpm:"php-pdo_dblib~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_mysql", rpm:"php-pdo_mysql~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_odbc", rpm:"php-pdo_odbc~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_pgsql", rpm:"php-pdo_pgsql~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pdo_sqlite", rpm:"php-pdo_sqlite~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pgsql", rpm:"php-pgsql~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-posix", rpm:"php-posix~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-pspell", rpm:"php-pspell~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-readline", rpm:"php-readline~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-recode", rpm:"php-recode~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-session", rpm:"php-session~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-shmop", rpm:"php-shmop~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-snmp", rpm:"php-snmp~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-soap", rpm:"php-soap~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sockets", rpm:"php-sockets~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sqlite", rpm:"php-sqlite~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sybase", rpm:"php-sybase~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvmsg", rpm:"php-sysvmsg~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvsem", rpm:"php-sysvsem~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-sysvshm", rpm:"php-sysvshm~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tidy", rpm:"php-tidy~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-tokenizer", rpm:"php-tokenizer~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-wddx", rpm:"php-wddx~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xml", rpm:"php-xml~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlreader", rpm:"php-xmlreader~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlrpc", rpm:"php-xmlrpc~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xmlwriter", rpm:"php-xmlwriter~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-xsl", rpm:"php-xsl~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-zlib", rpm:"php-zlib~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mbfl1", rpm:"lib64mbfl1~1.0.2~3.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64mbfl-devel", rpm:"lib64mbfl-devel~1.0.2~3.1mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.2.6~18.2mdv2009.0", rls:"MNDK_2009.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"apache-mod_php", rpm:"apache-mod_php~5.1.6~1.1.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libphp5_common5", rpm:"libphp5_common5~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cgi", rpm:"php-cgi~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-cli", rpm:"php-cli~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-devel", rpm:"php-devel~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-fcgi", rpm:"php-fcgi~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"php-mbstring", rpm:"php-mbstring~5.1.6~1.2.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lib64php5_common5", rpm:"lib64php5_common5~5.1.6~1.11.20060mlcs4", rls:"MNDK_4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
