###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_win_live_messenger_info_dis_vuln.nasl 814 2009-01-06 13:16:24Z jan $
#
# Microsoft Windows Live Messenger Information Disclosure Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800332);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2008-5828");
  script_bugtraq_id(33125);
  script_name("Microsoft Windows Live Messenger Information Disclosure Vulnerability");
  desc = "

  Overview: This host has Windows Live Messenger Client installed and is prone
  to Information Disclosure vulnerability.

  Vulnerability Insight:
  The vulnerability is caused due to field error in IPv4InternalAddrsAndPorts,
  IPv4Internal-Addrs and IPv4Internal-Port headers, which allow to discover
  IP address and port numbers via MSNP15 protocol used over a NAT session.

  Impact:
  Successful exploitation could lead to unauthorized information disclosure.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft, Windows Live Messenger Client version 8.5.1302.1018 and prior.

  Fix: No solution or patch is available as on 07th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://get.live.com/messenger/overview

  References:
  http://securityreason.com/securityalert/4862
  http://www.securityfocus.com/archive/1/archive/1/499624/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 4.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of Windows Live Messenger");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_ms_win_live_messenger_detect.nasl");
  script_require_keys("MS/LiveMessenger/Ver");
  exit(0);
}


include("version_func.inc");

lmVer = get_kb_item("MS/LiveMessenger/Ver");
if(!lmVer){
  exit(0);
}

# Grep for the version 8.5.1302.1018 and prior
if(version_is_less_equal(version:lmVer, test_version:"8.5.1302.1018")){
  security_warning(0);
}
