###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_gd_graphics_library_detect_lin.nasl 5387 2009-10-23 13:44:24Z oct $
#
# GD Graphics Library Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801121);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("GD Graphics Library Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of GD Graphics Library
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set KB for the version of GD Graphics Library");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

gd_sock = ssh_login_or_reuse_connection();
if(!gd_sock){
  exit(0);
}

gdName = find_bin(prog_name:"gdlib-config", sock:gd_sock);

foreach binName (gdName)
{
  gdVer = get_bin_version(full_prog_name:chomp(binName), sock:gd_sock,
                          version_argv:"--version",
                          ver_pattern:"([0-9.]+.?(RC[0-9])?)");
  if(!isnull(gdVer[1]))
  {
    set_kb_item(name:"GD-Graphics-Lib/Lin/Ver", value:gdVer[1]);
    security_note(data:"GD Graphics Library version " + gdVer[1] + 
                       " was detected on the host");
  }
}
ssh_close_connection();
