# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1572-1 (php5)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61024);
 script_cve_id("CVE-2007-3806", "CVE-2008-1384", "CVE-2008-2050", "CVE-2008-2051");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1572-1 (php5)";
 script_name(name);

 desc = "The remote host is missing an update to php5
announced via advisory DSA 1572-1.

Several vulnerabilities have been discovered in PHP, a server-side,
HTML-embedded scripting language. The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2007-3806

The glob function allows context-dependent attackers to cause
a denial of service and possibly execute arbitrary code via
an invalid value of the flags parameter.

CVE-2008-1384

Integer overflow allows context-dependent attackers to cause
a denial of service and possibly have other impact via a
printf format parameter with a large width specifier.

CVE-2008-2050

Stack-based buffer overflow in the FastCGI SAPI.

CVE-2008-2051

The escapeshellcmd API function could be attacked via
incomplete multibyte chars.

This update als includes a fix which was pending for the next Debian
4.0 `etch' stable update, for crashes in php5-recode (Debian bug 459020).

For the stable distribution (etch), these problems have been fixed in
version 5.2.0-8+etch11.

For the unstable distribution (sid), these problems have been fixed in
version 5.2.6-1.

We recommend that you upgrade your php5 package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201572-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1572-1 (php5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-imap", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php5", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mcrypt", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-interbase", ver:"5.2.0-8+etch11", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
