# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 023-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53786);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 023-1 (inn2)";
 script_name(name);

 desc = "The remote host is missing an update to inn2
announced via advisory DSA 023-1.

1. People at WireX have found several potential insecure uses of
temporary files in programs provided by INN2.  Some of them only
lead to a vulnerability to symlink attacks if the temporary
directory was set to /tmp or /var/tmp, which is the case in many
installations, at least in Debian packages.  An attacker could
overwrite any file owned by the news system administrator,
i.e. owned by news.news.

2. Michal Zalewski found an exploitable buffer overflow with regard
to cancel messages and their verification.  This bug did only show
up if 'verifycancels' was enabled in inn.conf which is not the
default and has been disrecommended by upstream.

3. Andi Kleen found a bug in INN2 that makes innd crash for two byte
headers.  There is a chance this can only be exploited with uucp.

We recommend you upgrade your inn2 packages immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20023-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 023-1 (inn2)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"inn2-dev", ver:"2.2.2.2000.01.31-4.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"inn2-inews", ver:"2.2.2.2000.01.31-4.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"inn2", ver:"2.2.2.2000.01.31-4.1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"task-news-server", ver:"2.2.2.2000.01.31-4.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
