/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHSETTINGDATA_H_
#define OPENDRIM_SSHSETTINGDATA_H_

#include <Instance.h>

const static char* OpenDRIM_SSHSettingData_classnames[] = {"OpenDRIM_SSHSettingData"};
static string OpenDRIM_SSHSettingData_NAMESPACE = _NAMESPACE;

class OpenDRIM_SSHSettingData {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	unsigned long long Generation;
	bool Generation_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string ConfigurationName;
	bool ConfigurationName_isNULL;
	
	unsigned short ChangeableType;
	bool ChangeableType_isNULL;
	
	vector<unsigned short> EnabledSSHVersions;
	bool EnabledSSHVersions_isNULL;
	
	string OtherEnabledSSHVersion;
	bool OtherEnabledSSHVersion_isNULL;
	
	unsigned short SSHVersion;
	bool SSHVersion_isNULL;
	
	vector<string> OtherSSHVersion;
	bool OtherSSHVersion_isNULL;
	
	vector<unsigned short> EnabledEncryptionAlgorithms;
	bool EnabledEncryptionAlgorithms_isNULL;
	
	vector<string> OtherEnabledEncryptionAlgorithm;
	bool OtherEnabledEncryptionAlgorithm_isNULL;
	
	unsigned short EncryptionAlgorithm;
	bool EncryptionAlgorithm_isNULL;
	
	string OtherEncryptionAlgorithm;
	bool OtherEncryptionAlgorithm_isNULL;
	
	unsigned int IdleTimeout;
	bool IdleTimeout_isNULL;
	
	bool KeepAlive;
	bool KeepAlive_isNULL;
	
	bool ForwardX11;
	bool ForwardX11_isNULL;
	
	bool Compression;
	bool Compression_isNULL;
	
	OpenDRIM_SSHSettingData() {
		Caption_isNULL = true;
		Description_isNULL = true;
		Generation_isNULL = true;
		InstanceID_isNULL = true;
		ElementName_isNULL = true;
		ConfigurationName_isNULL = true;
		ChangeableType_isNULL = true;
		EnabledSSHVersions_isNULL = true;
		OtherEnabledSSHVersion_isNULL = true;
		SSHVersion_isNULL = true;
		OtherSSHVersion_isNULL = true;
		EnabledEncryptionAlgorithms_isNULL = true;
		OtherEnabledEncryptionAlgorithm_isNULL = true;
		EncryptionAlgorithm_isNULL = true;
		OtherEncryptionAlgorithm_isNULL = true;
		IdleTimeout_isNULL = true;
		KeepAlive_isNULL = true;
		ForwardX11_isNULL = true;
		Compression_isNULL = true;
	}
	
	~OpenDRIM_SSHSettingData() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getGeneration(unsigned long long& value) const {
		if (Generation_isNULL==true)
			return NOT_FOUND;
		value = Generation;
		return OK;
	}
	
	int setGeneration(const unsigned long long& newValue) {
		Generation = newValue;
		Generation_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getConfigurationName(string& value) const {
		if (ConfigurationName_isNULL==true)
			return NOT_FOUND;
		value = ConfigurationName;
		return OK;
	}
	
	int setConfigurationName(const string& newValue) {
		ConfigurationName = newValue;
		ConfigurationName_isNULL = false;
		return OK;
	}

	int getChangeableType(unsigned short& value) const {
		if (ChangeableType_isNULL==true)
			return NOT_FOUND;
		value = ChangeableType;
		return OK;
	}
	
	int setChangeableType(const unsigned short& newValue) {
		ChangeableType = newValue;
		ChangeableType_isNULL = false;
		return OK;
	}

	int getEnabledSSHVersions(vector<unsigned short>& value) const {
		if (EnabledSSHVersions_isNULL==true)
			return NOT_FOUND;
		value = EnabledSSHVersions;
		return OK;
	}
	
	int setEnabledSSHVersions(const vector<unsigned short>& newValue) {
		EnabledSSHVersions = newValue;
		EnabledSSHVersions_isNULL = false;
		return OK;
	}

	int getOtherEnabledSSHVersion(string& value) const {
		if (OtherEnabledSSHVersion_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledSSHVersion;
		return OK;
	}
	
	int setOtherEnabledSSHVersion(const string& newValue) {
		OtherEnabledSSHVersion = newValue;
		OtherEnabledSSHVersion_isNULL = false;
		return OK;
	}

	int getSSHVersion(unsigned short& value) const {
		if (SSHVersion_isNULL==true)
			return NOT_FOUND;
		value = SSHVersion;
		return OK;
	}
	
	int setSSHVersion(const unsigned short& newValue) {
		SSHVersion = newValue;
		SSHVersion_isNULL = false;
		return OK;
	}

	int getOtherSSHVersion(vector<string>& value) const {
		if (OtherSSHVersion_isNULL==true)
			return NOT_FOUND;
		value = OtherSSHVersion;
		return OK;
	}
	
	int setOtherSSHVersion(const vector<string>& newValue) {
		OtherSSHVersion = newValue;
		OtherSSHVersion_isNULL = false;
		return OK;
	}

	int getEnabledEncryptionAlgorithms(vector<unsigned short>& value) const {
		if (EnabledEncryptionAlgorithms_isNULL==true)
			return NOT_FOUND;
		value = EnabledEncryptionAlgorithms;
		return OK;
	}
	
	int setEnabledEncryptionAlgorithms(const vector<unsigned short>& newValue) {
		EnabledEncryptionAlgorithms = newValue;
		EnabledEncryptionAlgorithms_isNULL = false;
		return OK;
	}

	int getOtherEnabledEncryptionAlgorithm(vector<string>& value) const {
		if (OtherEnabledEncryptionAlgorithm_isNULL==true)
			return NOT_FOUND;
		value = OtherEnabledEncryptionAlgorithm;
		return OK;
	}
	
	int setOtherEnabledEncryptionAlgorithm(const vector<string>& newValue) {
		OtherEnabledEncryptionAlgorithm = newValue;
		OtherEnabledEncryptionAlgorithm_isNULL = false;
		return OK;
	}

	int getEncryptionAlgorithm(unsigned short& value) const {
		if (EncryptionAlgorithm_isNULL==true)
			return NOT_FOUND;
		value = EncryptionAlgorithm;
		return OK;
	}
	
	int setEncryptionAlgorithm(const unsigned short& newValue) {
		EncryptionAlgorithm = newValue;
		EncryptionAlgorithm_isNULL = false;
		return OK;
	}

	int getOtherEncryptionAlgorithm(string& value) const {
		if (OtherEncryptionAlgorithm_isNULL==true)
			return NOT_FOUND;
		value = OtherEncryptionAlgorithm;
		return OK;
	}
	
	int setOtherEncryptionAlgorithm(const string& newValue) {
		OtherEncryptionAlgorithm = newValue;
		OtherEncryptionAlgorithm_isNULL = false;
		return OK;
	}

	int getIdleTimeout(unsigned int& value) const {
		if (IdleTimeout_isNULL==true)
			return NOT_FOUND;
		value = IdleTimeout;
		return OK;
	}
	
	int setIdleTimeout(const unsigned int& newValue) {
		IdleTimeout = newValue;
		IdleTimeout_isNULL = false;
		return OK;
	}

	int getKeepAlive(bool& value) const {
		if (KeepAlive_isNULL==true)
			return NOT_FOUND;
		value = KeepAlive;
		return OK;
	}
	
	int setKeepAlive(const bool& newValue) {
		KeepAlive = newValue;
		KeepAlive_isNULL = false;
		return OK;
	}

	int getForwardX11(bool& value) const {
		if (ForwardX11_isNULL==true)
			return NOT_FOUND;
		value = ForwardX11;
		return OK;
	}
	
	int setForwardX11(const bool& newValue) {
		ForwardX11 = newValue;
		ForwardX11_isNULL = false;
		return OK;
	}

	int getCompression(bool& value) const {
		if (Compression_isNULL==true)
			return NOT_FOUND;
		value = Compression;
		return OK;
	}
	
	int setCompression(const bool& newValue) {
		Compression = newValue;
		Compression_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_SSHSETTINGDATA_H_*/
