# -*- Python -*-

# The cxx compiler doesn't include the dirspec on an object library so fix it

class UnexpectedFormat(Exception):
    def __init__(self,reason):
        self.reason=reason
    def __str__(self):
        return '''Unexpected dependency file format: %s''' % self.reason

import sys,string
dfilename=sys.argv[1]

# get default directory from CL argument 'cause python's os.getcwd() will
# return it in unix format.

dfaultdir=sys.argv[2]

# Having to use string.split for compatability with python 1.5.2 in
# case of overworked system managers that don't have time to upgrade...
devdir=string.split(dfaultdir,':')
dfaultdevice=devdir[0]+":"
dfaultdirectory=devdir[1]
dfaultdirnodes=string.split(dfaultdirectory[1:-1],'.')

dfile=open(dfilename,'r')
dlines=dfile.readlines()
dfile.close()

objname=''
sources={}
byinx={}
inx=0
for line in dlines:
    parsed=string.split(line)
    if len(parsed)==3:
        if objname and objname!=parsed[0]:
            raise UnexpectedFormat("Object file name not homogeneous: %s vs %s"
                                   % (objname,parsed[0]))
        if not objname:
            objname=parsed[0]
        if parsed[1]!=':':
            raise UnexpectedFormat("Expected colon: %s"
                                   % parsed[1])
        source=parsed[2]
        if source[:len(dfaultdir)]==dfaultdir:
            # full path names are evil
            source=source[len(dfaultdir):]
        elif source[:len(dfaultdevice)]==dfaultdevice:
            source=source[len(dfaultdevice):]
            pos=string.find(source,']')+1
            sourcedir=source[:pos]
            sourcename=source[pos:]
            sourcenodes=string.split(sourcedir[1:-1],'.')
            nodes=dfaultdirnodes[:]
            while len(nodes)>0 and len(sourcenodes)>0:
                if nodes[0] != sourcenodes[0]:
                    break
                del nodes[0]
                del sourcenodes[0]
            if len(nodes) > 0 and len(sourcenodes)>0:
                source="[%s.%s]%s" % ((len(nodes)*'-'),
                                      string.join(sourcenodes,'.'),
                                      sourcename)
            elif len(nodes) > 0:
                source="[%s]%s" % ((len(nodes)*'-'),sourcename)
            else:
                # can't happen.  should've matched dfault...
                source=sourcename
        if not sources.has_key(source):
            sources[source]=inx
            byinx[inx]=source
            # Python 1.5.2 doesn't have:
            # inx+=1
            inx=inx+1

import os
os.remove(dfilename)
dfile=open(dfilename,"w")
objname=sys.argv[3]
devname=string.split(objname,':')
if len(devname)==2:
    device,objname=devname
else:
    device=''

if objname[0]=='[' and string.find(objname,']')!=-1:
    directory=objname[:string.find(objname,']')+1]
    objname=objname[string.find(objname,']')+1:]
else:
    directory=''

objdir=device+directory
if string.lower(objdir)=='[.release]' or string.lower(objdir)=='[.debug]':
    objdir="$(CONFIG_DIR_V)"
if objname[:len(objdir)] != objdir:
    objname=objdir+objname
fmt=objname+" : %s\\\n"
indexes=byinx.keys()
indexes.sort()
for inx in indexes[:-1]:
    source=byinx[inx]
    dfile.write(fmt % source)
    fmt="\t%s\\\n"

fmt=fmt[:-2]+"\n"
source=byinx[indexes[-1]]
dfile.write(fmt % source)
