/**
 * Original work: Copyright (c) 2014 Sergey Skoblikov
 * Modified work: Copyright (c) 2015-2020 Dmitry Ivanov
 *
 * This file is a part of QEverCloud project and is distributed under the terms
 * of MIT license:
 * https://opensource.org/licenses/MIT
 *
 * This file was generated from Evernote Thrift API
 */

#ifndef QEVERCLOUD_GENERATED_CONSTANTS_H
#define QEVERCLOUD_GENERATED_CONSTANTS_H

#include "../Export.h"

namespace qevercloud {

////////////////////////////////////////////////////////////////////////////////

// Limits.thrift
/**
 * Minimum length of any string-based attribute, in Unicode chars
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_ATTRIBUTE_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of any string-based attribute, in Unicode chars
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_ATTRIBUTE_LEN_MAX;

// Limits.thrift
/**
 * Any string-based attribute must match the provided regular expression.
 * This excludes all Unicode line endings and control characters.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_ATTRIBUTE_REGEX;

// Limits.thrift
/**
 * The maximum number of values that can be stored in a list-based attribute
 * (e.g. see UserAttributes.recentMailedAddresses)
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_ATTRIBUTE_LIST_MAX;

// Limits.thrift
/**
 * The maximum number of entries that can be stored in a map-based attribute
 * such as applicationData fields in Resources and Notes.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_ATTRIBUTE_MAP_MAX;

// Limits.thrift
/**
 * The minimum length of a GUID generated by the Evernote service
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_GUID_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a GUID generated by the Evernote service
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_GUID_LEN_MAX;

// Limits.thrift
/**
 * GUIDs generated by the Evernote service will match the provided pattern
 */
QEVERCLOUD_EXPORT extern const QString EDAM_GUID_REGEX;

// Limits.thrift
/**
 * The minimum length of any email address
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_EMAIL_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of any email address
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_EMAIL_LEN_MAX;

// Limits.thrift
/**
 * A regular expression that matches the part of an email address before
 * the '@' symbol.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_EMAIL_LOCAL_REGEX;

// Limits.thrift
/**
 * A regular expression that matches the part of an email address after
 * the '@' symbol.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_EMAIL_DOMAIN_REGEX;

// Limits.thrift
/**
 * A regular expression that must match any email address given to Evernote.
 * Email addresses must comply with RFC 2821 and 2822.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_EMAIL_REGEX;

// Limits.thrift
/**
 * A regular expression that must match any VAT ID given to Evernote.
 * ref http://en.wikipedia.org/wiki/VAT_identification_number
 * ref http://my.safaribooksonline.com/book/programming/regular-expressions/9780596802837/4dot-validation-and-formatting/id2995136
 */
QEVERCLOUD_EXPORT extern const QString EDAM_VAT_REGEX;

// Limits.thrift
/**
 * The minimum length of a timezone specification string
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_TIMEZONE_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a timezone specification string
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_TIMEZONE_LEN_MAX;

// Limits.thrift
/**
 * Any timezone string given to Evernote must match the provided pattern.
 * This permits either a locale-based standard timezone or a GMT offset.
 * E.g.:<ul>
 *    <li>America/Los_Angeles</li>
 *    <li>GMT+08:00</li>
 * </ul>
 */
QEVERCLOUD_EXPORT extern const QString EDAM_TIMEZONE_REGEX;

// Limits.thrift
/**
 * The minimum length of any MIME type string given to Evernote
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MIME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of any MIME type string given to Evernote
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MIME_LEN_MAX;

// Limits.thrift
/**
 * Any MIME type string given to Evernote must match the provided pattern.
 * E.g.:  image/gif
 */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_REGEX;

// Limits.thrift
/** Canonical MIME type string for GIF image resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_GIF;

// Limits.thrift
/** Canonical MIME type string for JPEG image resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_JPEG;

// Limits.thrift
/** Canonical MIME type string for PNG image resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_PNG;

// Limits.thrift
/** Canonical MIME type string for TIFF image resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_TIFF;

// Limits.thrift
/** Canonical MIME type string for BMP image resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_BMP;

// Limits.thrift
/** Canonical MIME type string for WAV audio resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_WAV;

// Limits.thrift
/** Canonical MIME type string for MP3 audio resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_MP3;

// Limits.thrift
/** Canonical MIME type string for AMR audio resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_AMR;

// Limits.thrift
/** Canonical MIME type string for AAC audio resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_AAC;

// Limits.thrift
/** Canonical MIME type string for MP4 audio resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_M4A;

// Limits.thrift
/** Canonical MIME type string for MP4 video resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_MP4_VIDEO;

// Limits.thrift
/** Canonical MIME type string for Evernote Ink resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_INK;

// Limits.thrift
/** Canonical MIME type string for PDF resources */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_PDF;

// Limits.thrift
/** MIME type used for attachments of an unspecified type */
QEVERCLOUD_EXPORT extern const QString EDAM_MIME_TYPE_DEFAULT;

// Limits.thrift
/**
 * The set of resource MIME types that are expected to be handled
 * correctly by all of the major Evernote client applications.
 */
QEVERCLOUD_EXPORT extern const QSet<QString> EDAM_MIME_TYPES;

// Limits.thrift
/**
 * The set of MIME types that Evernote will parse and index for
 * searching. With exception of images, PDFs and plain text files,
 * which are handled in a different way.
 */
QEVERCLOUD_EXPORT extern const QSet<QString> EDAM_INDEXABLE_RESOURCE_MIME_TYPES;

// Limits.thrift
/**
 * The set of plain text MIME types that Evernote will parse and index
 * for searching. The MIME types which start with "text/" will be handled
 * separately by each client (i.e. hard-coded in each client).
 */
QEVERCLOUD_EXPORT extern const QSet<QString> EDAM_INDEXABLE_PLAINTEXT_MIME_TYPES;

// Limits.thrift
/**
 * The minimum length of a user search query string in Unicode chars
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SEARCH_QUERY_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a user search query string in Unicode chars
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SEARCH_QUERY_LEN_MAX;

// Limits.thrift
/**
 * Search queries must match the provided pattern.  This is used for
 * both ad-hoc queries and SavedSearch.query fields.
 * This excludes all control characters and line/paragraph separators.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SEARCH_QUERY_REGEX;

// Limits.thrift
/**
 * The exact length of a MD5 hash checksum, in binary bytes.
 * This is the exact length that must be matched for any binary hash
 * value.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_HASH_LEN;

// Limits.thrift
/**
 * The minimum length of an Evernote username
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_USERNAME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of an Evernote username
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_USERNAME_LEN_MAX;

// Limits.thrift
/**
 * Any Evernote User.username field must match this pattern.  This
 * restricts usernames to a format that could permit use as a domain
 * name component.  E.g. "username.whatever.evernote.com"
 */
QEVERCLOUD_EXPORT extern const QString EDAM_USER_USERNAME_REGEX;

// Limits.thrift
/**
 * Minimum length of the User.name field
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_NAME_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of the User.name field
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_NAME_LEN_MAX;

// Limits.thrift
/**
 * The User.name field must match this pattern, which excludes line
 * endings and control characters.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_USER_NAME_REGEX;

// Limits.thrift
/**
 * The minimum length of a Tag.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_TAG_NAME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Tag.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_TAG_NAME_LEN_MAX;

// Limits.thrift
/**
 * All Tag.name fields must match this pattern.
 * This excludes control chars, commas or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_TAG_NAME_REGEX;

// Limits.thrift
/**
 * The minimum length of a Note.title, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Note.title, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_LEN_MAX;

// Limits.thrift
/**
 * All Note.title fields must match this pattern.
 * This excludes control chars or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_TITLE_REGEX;

// Limits.thrift
/**
 * Minimum length of a Note.content field.
 * Note.content fields must comply with the ENML DTD.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_CONTENT_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of a Note.content field
 * Note.content fields must comply with the ENML DTD.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_CONTENT_LEN_MAX;

// Limits.thrift
/**
 * Minimum length of an application name, which is the key in an
 * applicationData LazyMap found in entities such as Resources and
 * Notes.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_APPLICATIONDATA_NAME_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of an application name, which is the key in an
 * applicationData LazyMap found in entities such as Resources and
 * Notes.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_APPLICATIONDATA_NAME_LEN_MAX;

// Limits.thrift
/**
 * Minimum length of an applicationData value in a LazyMap, found
 * in entities such as Resources and Notes.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_APPLICATIONDATA_VALUE_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of an applicationData value in a LazyMap, found
 * in entities such as Resources and Notes.  Note, however, that
 * the sum of the size of hte key and value is constrained by
 * EDAM_APPLICATIONDATA_ENTRY_LEN_MAX, so the maximum length, in
 * practice, depends upon the key value being used.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_APPLICATIONDATA_VALUE_LEN_MAX;

// Limits.thrift
/**
 * The total length of an entry in an applicationData LazyMap, which
 * is the sum of the length of the key and the value for the entry.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_APPLICATIONDATA_ENTRY_LEN_MAX;

// Limits.thrift
/**
 * An application name must match this regex.  An application
 * name is the key portion of an entry in an applicationData
 * map as found in entities such as Resources and Notes.
 * Note that even if both the name and value regexes match,
 * it is still necessary to check the sum of the lengths
 * against EDAM_APPLICATIONDATA_ENTRY_LEN_MAX.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_APPLICATIONDATA_NAME_REGEX;

// Limits.thrift
/**
 * An applicationData map value must match this regex.
 * Note that even if both the name and value regexes match,
 * it is still necessary to check the sum of the lengths
 * against EDAM_APPLICATIONDATA_ENTRY_LEN_MAX.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_APPLICATIONDATA_VALUE_REGEX;

// Limits.thrift
/**
 * The minimum length of a Notebook.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_NAME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Notebook.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_NAME_LEN_MAX;

// Limits.thrift
/**
 * All Notebook.name fields must match this pattern.
 * This excludes control chars or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTEBOOK_NAME_REGEX;

// Limits.thrift
/**
 * The minimum length of a Notebook.stack, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_STACK_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Notebook.stack, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_STACK_LEN_MAX;

// Limits.thrift
/**
 * All Notebook.stack fields must match this pattern.
 * This excludes control chars or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTEBOOK_STACK_REGEX;

// Limits.thrift
/**
 * The minimum length of a Workspace.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_WORKSPACE_NAME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Workspace.name, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_WORKSPACE_NAME_LEN_MAX;

// Limits.thrift
/**
 * The maximum length of a Workspace.description, in Unicode characters
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_WORKSPACE_DESCRIPTION_LEN_MAX;

// Limits.thrift
/**
 * All Workspace.name fields must match this pattern.
 * This excludes control chars or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_WORKSPACE_NAME_REGEX;

// Limits.thrift
/**
 * The minimum length of a public notebook URI component
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PUBLISHING_URI_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a public notebook URI component
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PUBLISHING_URI_LEN_MAX;

// Limits.thrift
/**
 * A public notebook URI component must match the provided pattern
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PUBLISHING_URI_REGEX;

// Limits.thrift
/**
 * The set of strings that may not be used as a publishing URI
 */
QEVERCLOUD_EXPORT extern const QSet<QString> EDAM_PUBLISHING_URI_PROHIBITED;

// Limits.thrift
/**
 * The minimum length of a Publishing.publicDescription field.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PUBLISHING_DESCRIPTION_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a Publishing.publicDescription field.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PUBLISHING_DESCRIPTION_LEN_MAX;

// Limits.thrift
/**
 * Any public notebook's Publishing.publicDescription field must match
 * this pattern.
 * No control chars or line/paragraph separators, and can't start or
 * end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PUBLISHING_DESCRIPTION_REGEX;

// Limits.thrift
/**
 * The minimum length of a SavedSearch.name field
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SAVED_SEARCH_NAME_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of a SavedSearch.name field
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SAVED_SEARCH_NAME_LEN_MAX;

// Limits.thrift
/**
 * SavedSearch.name fields must match this pattern.
 * No control chars or line/paragraph separators, and can't start or
 * end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SAVED_SEARCH_NAME_REGEX;

// Limits.thrift
/**
 * The minimum length of an Evernote user password
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_PASSWORD_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of an Evernote user password
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_PASSWORD_LEN_MAX;

// Limits.thrift
/**
 * Evernote user passwords must match this regular expression
 */
QEVERCLOUD_EXPORT extern const QString EDAM_USER_PASSWORD_REGEX;

// Limits.thrift
/**
 * The maximum length of an Evernote Business URI
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_URI_LEN_MAX;

// Limits.thrift
/**
 * Valid Evernote Business marketing code / affiliate code format.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_BUSINESS_MARKETING_CODE_REGEX_PATTERN;

// Limits.thrift
/**
 * The maximum number of Tags per Note
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TAGS_MAX;

// Limits.thrift
/**
 * The maximum number of Resources per Note
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_RESOURCES_MAX;

// Limits.thrift
/**
 * Maximum number of Tags per account
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_TAGS_MAX;

// Limits.thrift
/**
 * Maximum number of Tags per business account.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_TAGS_MAX;

// Limits.thrift
/**
 * Maximum number of SavedSearches per account
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_SAVED_SEARCHES_MAX;

// Limits.thrift
/**
 * Maximum number of Notes per user
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_NOTES_MAX;

// Limits.thrift
/**
 * Maximum number of Notes per business account
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_NOTES_MAX;

// Limits.thrift
/**
 * Maximum number of Notebooks per user
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_NOTEBOOKS_MAX;

// Limits.thrift
/**
 * Maximum number of Workspaces per user
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_WORKSPACES_MAX;

// Limits.thrift
/**
 * Maximum number of Notebooks in a business account
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_NOTEBOOKS_MAX;

// Limits.thrift
/**
 * Maximum number of Workspaces in a business account
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_WORKSPACES_MAX;

// Limits.thrift
/**
 * Maximum number of recent email addresses that are maintained
 * (see UserAttributes.recentMailedAddresses)
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_RECENT_MAILED_ADDRESSES_MAX;

// Limits.thrift
/**
 * The number of emails of any type that can be sent by a user with a Free
 * account from the service per day.  If an email is sent to two different
 * recipients, this counts as two emails.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_MAIL_LIMIT_DAILY_FREE;

// Limits.thrift
/**
 * The number of emails of any type that can be sent by a user with a Premium
 * account from the service per day.  If an email is sent to two different
 * recipients, this counts as two emails.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_MAIL_LIMIT_DAILY_PREMIUM;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to a Free user's
 * account each month.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_FREE;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to a Premium user's
 * account each month.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_PREMIUM;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to new business
 * account during the first month. 50GB.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_BUSINESS_FIRST_MONTH;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to a business
 * account for the next month. 20GB.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_BUSINESS_NEXT_MONTH;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded each month to an account at
 * a Plus service level.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_PLUS;

// Limits.thrift
/**
 * The number of bytes of new data uploaded in a monthly quota cycle at which point
 * users should be prompted with a survey to gather information on how they are using
 * Evernote.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_SURVEY_THRESHOLD;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to a Business user's
 * personal account each month. Note that content uploaded into the Business
 * notebooks by the user does not count against this limit.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_BUSINESS;

// Limits.thrift
/**
 * The number of bytes of new data that may be uploaded to a Business for each
 * member of the business per month. The total bytes available can be determined
 * by multiplying this with the number of business users.
 */
QEVERCLOUD_EXPORT extern const qint64 EDAM_USER_UPLOAD_LIMIT_BUSINESS_PER_USER;

// Limits.thrift
/**
 * Maximum total size of a Note that can be added to a Free account.
 * The size of a note is calculated as:
 * ENML content length (in Unicode characters) plus the sum of all resource
 * sizes (in bytes).
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_SIZE_MAX_FREE;

// Limits.thrift
/**
 * Maximum total size of a Note that can be added to a Premium account.
 * The size of a note is calculated as:
 * ENML content length (in Unicode characters) plus the sum of all resource
 * sizes (in bytes).
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_SIZE_MAX_PREMIUM;

// Limits.thrift
/**
 * Maximum size of a resource, in bytes, for Free accounts
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RESOURCE_SIZE_MAX_FREE;

// Limits.thrift
/**
 * Maximum size of a resource, in bytes, for Premium accounts
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RESOURCE_SIZE_MAX_PREMIUM;

// Limits.thrift
/**
 * Maximum number of linked notebooks per account, for a free
 * account.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_LINKED_NOTEBOOK_MAX;

// Limits.thrift
/**
 * Maximum number of linked notebooks per account, for a premium
 * account.  Users who are part of an active business are also
 * covered under "premium".
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_LINKED_NOTEBOOK_MAX_PREMIUM;

// Limits.thrift
/**
 * Maximum number of shared notebooks per business notebook
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_BUSINESS_SHARED_NOTEBOOK_MAX;

// Limits.thrift
/**
 * Maximum number of shared notebooks per personal notebook
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTEBOOK_PERSONAL_SHARED_NOTEBOOK_MAX;

// Limits.thrift
/**
 * Maximum number of SharedNote records per business note
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_BUSINESS_SHARED_NOTE_MAX;

// Limits.thrift
/**
 * Maximum number of SharedNote records per personal note
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_PERSONAL_SHARED_NOTE_MAX;

// Limits.thrift
/**
 * The minimum length of the content class attribute of a note.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_CONTENT_CLASS_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of the content class attribute of a note.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_CONTENT_CLASS_LEN_MAX;

// Limits.thrift
/**
 * The regular expression that the content class of a note must match
 * to be valid.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_CONTENT_CLASS_REGEX;

// Limits.thrift
/**
 * The content class prefix used for all notes created by Evernote Hello.
 * This prefix can be used to assemble individual content class strings,
 * or can be used to create a wildcard search to get all notes created by
 * Hello. When performing a wildcard search via filtered sync chunks or
 * search strings, the * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_HELLO_APP_CONTENT_CLASS_PREFIX;

// Limits.thrift
/**
 * The content class prefix used for all notes created by Evernote Food.
 * This prefix can be used to assemble individual content class strings,
 * or can be used to create a wildcard search to get all notes created by
 * Food. When performing a wildcard search via filtered sync chunks or
 * search strings, the * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_FOOD_APP_CONTENT_CLASS_PREFIX;

// Limits.thrift
/**
 * The content class prefix used for structured notes created by Evernote
 * Hello that represents an encounter with a person. When performing a
 * wildcard search via filtered sync chunks or search strings, the *
 * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_HELLO_ENCOUNTER;

// Limits.thrift
/**
 * The content class prefix used for structured notes created by Evernote
 * Hello that represents the user's profile. When performing a
 * wildcard search via filtered sync chunks or search strings, the *
 * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_HELLO_PROFILE;

// Limits.thrift
/**
 * The content class prefix used for structured notes created by
 * Evernote Food that captures the experience of a particular meal.
 * When performing a wildcard search via filtered sync chunks or search
 * strings, the * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_FOOD_MEAL;

// Limits.thrift
/**
 * The content class prefix used for structured notes created by Evernote
 * Skitch. When performing a wildcard search via filtered sync chunks
 * or search strings, the * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_SKITCH_PREFIX;

// Limits.thrift
/**
 * The content class value used for structured image notes created by Evernote
 * Skitch.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_SKITCH;

// Limits.thrift
/**
 * The content class value used for structured PDF notes created by Evernote
 * Skitch.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_SKITCH_PDF;

// Limits.thrift
/**
 * The content class prefix used for structured notes created by Evernote
 * Penultimate. When performing a wildcard search via filtered sync chunks
 * or search strings, the * character must be appended to this constant.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_PENULTIMATE_PREFIX;

// Limits.thrift
/**
 * The content class value used for structured notes created by Evernote
 * Penultimate that represents a Penultimate notebook.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_CONTENT_CLASS_PENULTIMATE_NOTEBOOK;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured by the Post-it
 * camera.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_POSTIT;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured by the Moleskine
 * page camera.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_MOLESKINE;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured by
 * PFU ScanSnap Evernote Edition.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_EN_SCANSNAP;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured with the Embedded
 * Web Clipper.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_EWC;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured with the Android
 * share extension.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_ANDROID_SHARE_EXTENSION;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured with the iOS share
 * extension.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_IOS_SHARE_EXTENSION;

// Limits.thrift
/**
 * The NoteAttributes.sourceApplication value used for notes captured with the Evernote
 * Web Clipper.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_APPLICATION_WEB_CLIPPER;

// Limits.thrift
/**
 * The NoteAttributes.source value used for notes captured by the Microsoft Outlook clipper.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_SOURCE_OUTLOOK_CLIPPER;

// Limits.thrift
/**
 * A NoteAttributes.noteTitleQuality value indicating that a note has no meaningful title,
 * only a placeholder value such as "Untitled Note".
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_QUALITY_UNTITLED;

// Limits.thrift
/**
 * A NoteAttributes.noteTitleQuality value indicating that the quality of an automatically
 * generated note title is low. Examples of low quality titles include those based on a
 * note's type and location, such as "Snapshot from 123 Sesame Street in New York".
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_QUALITY_LOW;

// Limits.thrift
/**
 * A NoteAttributes.noteTitleQuality value indicating that the quality of an automatically
 * generated note title is medium. Examples of medium quality titles include those based on a
 * calendar entry, such as "Note from Weekly Staff Meeting".
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_QUALITY_MEDIUM;

// Limits.thrift
/**
 * A NoteAttributes.noteTitleQuality value indicating that the quality of an automatically
 * generated note title is high. Examples of high quality titles include those based on a
 * scanned business card, such as "John Doe - Scanned Business Card".
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_TITLE_QUALITY_HIGH;

// Limits.thrift
/**
 * The minimum length of the plain text in a findRelated query, assuming that
 * plaintext is being provided.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_PLAINTEXT_LEN_MIN;

// Limits.thrift
/**
 * The maximum length of the plain text in a findRelated query, assuming that
 * plaintext is being provided.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_PLAINTEXT_LEN_MAX;

// Limits.thrift
/**
 * The maximum number of notes that will be returned from a findRelated()
 * query.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_MAX_NOTES;

// Limits.thrift
/**
 * The maximum number of notebooks that will be returned from a findRelated()
 * query.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_MAX_NOTEBOOKS;

// Limits.thrift
/**
 * The maximum number of tags that will be returned from a findRelated() query.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_MAX_TAGS;

// Limits.thrift
/**
 * The maximum number of experts that will be returned from a findRelated() query
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_MAX_EXPERTS;

// Limits.thrift
/**
 * The maximum number of related content snippets that will be returned from a
 * findRelated() query.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_RELATED_MAX_RELATED_CONTENT;

// Limits.thrift
/**
 * The minimum length, in Unicode characters, of a description for a business
 * notebook.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MIN;

// Limits.thrift
/**
 * The maximum length, in Unicode characters, of a description for a business
 * notebook.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_LEN_MAX;

// Limits.thrift
/**
 * All business notebook descriptions must match this pattern.
 * This excludes control chars or line/paragraph separators.
 * The string may not begin or end with whitespace.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_BUSINESS_NOTEBOOK_DESCRIPTION_REGEX;

// Limits.thrift
/**
 * The maximum length of a business phone number.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_BUSINESS_PHONE_NUMBER_LEN_MAX;

// Limits.thrift
/**
 * Minimum length of a preference name
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_NAME_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of a preference name
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_NAME_LEN_MAX;

// Limits.thrift
/**
 * Minimum length of a preference value
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_VALUE_LEN_MIN;

// Limits.thrift
/**
 * Maximum length of a preference value
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_VALUE_LEN_MAX;

// Limits.thrift
/**
 * Maximum number of name/value pairs allowed
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MAX_PREFERENCES;

// Limits.thrift
/**
 * Maximum number of values per preference name when using
 * values of size no greater than EDAM_PREFERENCE_VALUE_LEN_MAX.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MAX_VALUES_PER_PREFERENCE;

// Limits.thrift
/**
 * The maximum length of a preference value if you only use one value
 * per preference rather than up to EDAM_MAX_VALUES_PER_PREFERENCE.
 * This option is useful if you want a single string that is larger
 * than EDAM_PREFERENCE_VALUE_LEN_MAX and would otherwise need to
 * split the string into multiple pieces to store it.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_ONLY_ONE_VALUE_LEN_MAX;

// Limits.thrift
/**
 * A preference name must match this regex.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_NAME_REGEX;

// Limits.thrift
/**
 * A preference value must match this regex if you are using more
 * than a single value for a preference.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_VALUE_REGEX;

// Limits.thrift
/**
 * A preference value must match this regex if you are using a single
 * value for a preference.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_ONLY_ONE_VALUE_REGEX;

// Limits.thrift
/**
 * The name of the preferences entry that contains shortcuts.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_SHORTCUTS;

// Limits.thrift
/**
 * The name of the preferences entry that contains the notebook GUID (not the linked notebook) of
 * the default business notebook. It must be in the format EDAM_GUID_REGEX.
 * If a default business notebook is not set and the user is a business user
 * the user should be prompted to set the default business notebook.
 * The default business notebook must be a read/write notebook.
 * Whenever the default business notebook guid is used, it must be revalidiated as a writable
 * notebook. If it is not valid, the user should be re-prompted to set the value.
 * This value is used by clients only.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_BUSINESS_DEFAULT_NOTEBOOK;

// Limits.thrift
/**
 * The name of the preferences entry that contains a boolean indicating that default
 * quicknotes should go into a business notebook. The EDAM_PREFERENCE_BUSINESS_DEFAULT_NOTEBOOK
 * must be set correctly for this preference to be honored.
 * The quicknote preferences should only be set to "true", if quicknote should use a business
 * notebook.
 * Any value other than "true" (or the omission of a value) should be treated as "false".
 * In this case, quicknotes should be created in in the user's personal default notebook.
 * The interface should not allow users to set quicknote to a business notebook
 * without a valid default business notebook selected, however, clients should handle the edge
 * case of an invalid business notebook guid.  If a user stops being a business user or
 * does not have write access to any business notebooks the quicknote preference should be
 * ignored.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PREFERENCE_BUSINESS_QUICKNOTE;

// Limits.thrift
/**
 * The maximum number of shortcuts that a user may have.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PREFERENCE_SHORTCUTS_MAX_VALUES;

// Limits.thrift
/**
 * Maximum length of the device identifier string associated with long sessions.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_DEVICE_ID_LEN_MAX;

// Limits.thrift
/**
 * Regular expression for device identifier strings associated with long sessions.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_DEVICE_ID_REGEX;

// Limits.thrift
/**
 * Maximum length of the device description string associated with long sessions.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_DEVICE_DESCRIPTION_LEN_MAX;

// Limits.thrift
/**
 * Regular expression for device description strings associated with long sessions.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_DEVICE_DESCRIPTION_REGEX;

// Limits.thrift
/**
 * Maximum number of search suggestions that can be returned
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SEARCH_SUGGESTIONS_MAX;

// Limits.thrift
/**
 * Maximum length of the search suggestion prefix
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SEARCH_SUGGESTIONS_PREFIX_LEN_MAX;

// Limits.thrift
/**
 * Minimum length of the search suggestion prefix
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SEARCH_SUGGESTIONS_PREFIX_LEN_MIN;

// Limits.thrift
/**
 * Default maximum number of results the service will return for findContact
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_FIND_CONTACT_DEFAULT_MAX_RESULTS;

// Limits.thrift
/**
 * Absolute maximum number of results the service will return for findContact
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_FIND_CONTACT_MAX_RESULTS;

// Limits.thrift
/**
 * The maximum number of separate notes that may be queried in a single call to
 * NoteStore.getViewersForNotes.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_NOTE_LOCK_VIEWERS_NOTES_MAX;

// Limits.thrift
/**
 * Absolute maximum number of results the servce will return for PersistentInternalMarket.getOrders()
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_GET_ORDERS_MAX_RESULTS;

// Limits.thrift
/**
 * The maximum length of a message body in unicode characters.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MESSAGE_BODY_LEN_MAX;

// Limits.thrift
/**
 * The regex to validate message.body against
 */
QEVERCLOUD_EXPORT extern const QString EDAM_MESSAGE_BODY_REGEX;

// Limits.thrift
/**
 * The maximum number of recipients on a MessageThread.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MESSAGE_RECIPIENTS_MAX;

// Limits.thrift
/**
 * The maximum number of attachments a Message can have.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MESSAGE_ATTACHMENTS_MAX;

// Limits.thrift
/**
 * The maximum length of a message attachment title in unicode characters.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MESSAGE_ATTACHMENT_TITLE_LEN_MAX;

// Limits.thrift
/**
 * The regex to validate message attachment titles against
 */
QEVERCLOUD_EXPORT extern const QString EDAM_MESSAGE_ATTACHMENT_TITLE_REGEX;

// Limits.thrift
/**
 * The maximum length of a message attachment snippet in unicode characters.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_MESSAGE_ATTACHMENT_SNIPPET_LEN_MAX;

// Limits.thrift
/**
 * The regex to validate message attachment snippets against
 */
QEVERCLOUD_EXPORT extern const QString EDAM_MESSAGE_ATTACHMENT_SNIPPET_REGEX;

// Limits.thrift
/**
 * Maximum user profile photo size, in bytes, that clients may send to the service.
 * Photos may be resized before being stored on the service.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_USER_PROFILE_PHOTO_MAX_BYTES;

// Limits.thrift
/**
 * The maximum length of a promotion ID in unicode characters.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_PROMOTION_ID_LEN_MAX;

// Limits.thrift
/**
 * The regex to validate promotion IDs against.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_PROMOTION_ID_REGEX;

// Limits.thrift
/** App Feedback Rating range */
QEVERCLOUD_EXPORT extern const qint16 EDAM_APP_RATING_MIN;

// Limits.thrift
QEVERCLOUD_EXPORT extern const qint16 EDAM_APP_RATING_MAX;

// Limits.thrift
/**
 * The maximium number of note snippets you can retrieve in a single request
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_SNIPPETS_NOTES_MAX;

// Limits.thrift
/**
 * The maximum number of connected identities a client can request.
 */
QEVERCLOUD_EXPORT extern const qint32 EDAM_CONNECTED_IDENTITY_REQUEST_MAX;

// Limits.thrift
/**
   *  Maximum length for OpenID token. There is no official enforced limit. The length of the Token ID depends
   *  on the provider. 1000 seems to be the safest value at this time.
   */
QEVERCLOUD_EXPORT extern const qint32 EDAM_OPEN_ID_ACCESS_TOKEN_MAX;

// Types.thrift
/**
 * A value for the "recipe" key in the "classifications" map in NoteAttributes
 * that indicates the user has classified a note as being a non-recipe.
 */
QEVERCLOUD_EXPORT extern const QString CLASSIFICATION_RECIPE_USER_NON_RECIPE;

// Types.thrift
/**
 * A value for the "recipe" key in the "classifications" map in NoteAttributes
 * that indicates the user has classified a note as being a recipe.
 */
QEVERCLOUD_EXPORT extern const QString CLASSIFICATION_RECIPE_USER_RECIPE;

// Types.thrift
/**
 * A value for the "recipe" key in the "classifications" map in NoteAttributes
 * that indicates the Evernote service has classified a note as being a recipe.
 */
QEVERCLOUD_EXPORT extern const QString CLASSIFICATION_RECIPE_SERVICE_RECIPE;

// Types.thrift
/**
 * Standardized value for the 'source' NoteAttribute for notes that
 * were clipped from the web in some manner.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_SOURCE_WEB_CLIP;

// Types.thrift
/**
 * Standardized value for the 'source' NoteAttribute for notes that
 * were clipped using the "simplified article" function of the clipper.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_SOURCE_WEB_CLIP_SIMPLIFIED;

// Types.thrift
/**
 * Standardized value for the 'source' NoteAttribute for notes that
 * were clipped from an email message.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_SOURCE_MAIL_CLIP;

// Types.thrift
/**
 * Standardized value for the 'source' NoteAttribute for notes that
 * were created via email sent to Evernote's email interface.
 */
QEVERCLOUD_EXPORT extern const QString EDAM_NOTE_SOURCE_MAIL_SMTP_GATEWAY;

// UserStore.thrift
/**
 * The major version number for the current revision of the EDAM protocol.
 * Clients pass this to the service using UserStore.checkVersion at the
 * beginning of a session to confirm that they are not out of date.
 */
QEVERCLOUD_EXPORT extern const qint16 EDAM_VERSION_MAJOR;

// UserStore.thrift
/**
 * The minor version number for the current revision of the EDAM protocol.
 * Clients pass this to the service using UserStore.checkVersion at the
 * beginning of a session to confirm that they are not out of date.
 */
QEVERCLOUD_EXPORT extern const qint16 EDAM_VERSION_MINOR;

} // namespace qevercloud

#endif // QEVERCLOUD_GENERATED_CONSTANTS_H
