//---------------------------------------------------------
// Copyright 2015 Ontario Institute for Cancer Research
// Written by Jared Simpson (jared.simpson@oicr.on.ca)
//---------------------------------------------------------
//
// nanopolish_iupac -- handle iupac ambiguity codes
//
#include <assert.h>
#include "nanopolish_iupac.h"

// IUPAC alphabet
bool IUPAC::isUnambiguous(char c)
{
    switch(c)
    {
        case 'A':
        case 'C':
        case 'G':
        case 'T':
            return true;
        default:
            return false;
    }
}

// Returns true if c is a valid ambiguity code
bool IUPAC::isAmbiguous(char c)
{
    switch(c)
    {
        case 'M':
        case 'R':
        case 'W':
        case 'S':
        case 'Y':
        case 'K':
        case 'V':
        case 'H':
        case 'D':
        case 'B':
        case 'N':
            return true;
        default:
            return false;
    }
}

// Returns true if c is a valid symbol in this alphabet
bool IUPAC::isValid(char c)
{
    return isUnambiguous(c) || isAmbiguous(c);
}

//
std::string IUPAC::getPossibleSymbols(char c)
{
    switch(c)
    {
        case 'A':
            return "A";
        case 'C':
            return "C";
        case 'G':
            return "G";
        case 'T':
            return "T";
        case 'M':
            return "AC";
        case 'R':
            return "AG";
        case 'W':
            return "AT";
        case 'S':
            return "CG";
        case 'Y':
            return "CT";
        case 'K':
            return "GT";
        case 'V':
            return "ACG";
        case 'H':
            return "ACT";
        case 'D':
            return "AGT";
        case 'B':
            return "CGT";
        case 'N':
            return "ACGT";
        default:
            return "";
    }
}
