#@ __global__
||

#@<OUT> classicresult
NAME
      ClassicResult - Allows browsing through the result information after
                      performing an operation on the database through the MySQL
                      Protocol.

DESCRIPTION
      This class allows access to the result set from the classic MySQL data
      model to be retrieved from Dev API queries.

PROPERTIES
      affected_items_count
            Same as get_affected_items_count

      affected_row_count
            Same as get_affected_row_count

            ATTENTION: This property will be removed in a future release, use
                       the affected_items_count property instead.

      auto_increment_value
            Returns the last insert id auto generated (from an insert
            operation).

      column_count
            Retrieves the number of columns on the current result.

      column_names
            Gets the columns on the current result.

      columns
            Gets the column metadata for the columns on the active result.

      execution_time
            Retrieves a string value indicating the execution time of the
            executed operation.

      info
            Retrieves a string providing information about the most recently
            executed statement.

      warning_count
            Same as get_warning_count

            ATTENTION: This property will be removed in a future release, use
                       the warnings_count property instead.

      warnings
            Retrieves the warnings generated by the executed operation.

      warnings_count
            Same as get_warnings_count

FUNCTIONS
      fetch_all()
            Returns a list of Row objects which contains an element for every
            record left on the result.

      fetch_one()
            Retrieves the next Row on the ClassicResult.

      fetch_one_object()
            Retrieves the next Row on the result and returns it as an object.

      get_affected_items_count()
            The the number of affected items for the last operation.

      get_affected_row_count()
            The number of affected rows for the last operation.

            ATTENTION: This function will be removed in a future release, use
                       the get_affected_items_count function instead.

      get_auto_increment_value()
            Returns the last insert id auto generated (from an insert
            operation).

      get_column_count()
            Retrieves the number of columns on the current result.

      get_column_names()
            Gets the columns on the current result.

      get_columns()
            Gets the column metadata for the columns on the active result.

      get_execution_time()
            Retrieves a string value indicating the execution time of the
            executed operation.

      get_info()
            Retrieves a string providing information about the most recently
            executed statement.

      get_warning_count()
            The number of warnings produced by the last statement execution.

            ATTENTION: This function will be removed in a future release, use
                       the get_warnings_count function instead.

      get_warnings()
            Retrieves the warnings generated by the executed operation.

      get_warnings_count()
            The number of warnings produced by the last statement execution.

      has_data()
            Returns true if the last statement execution has a result set.

      help([member])
            Provides help about this class and it's members

      next_data_set()
            Prepares the SqlResult to start reading data from the next Result
            (if many results were returned).

            ATTENTION: This function will be removed in a future release, use
                       the next_result function instead.

      next_result()
            Prepares the SqlResult to start reading data from the next Result
            (if many results were returned).

#@<OUT> classicresult.affected_items_count
NAME
      affected_items_count - Same as get_affected_items_count

SYNTAX
      <ClassicResult>.affected_items_count

#@<OUT> classicresult.affected_row_count
NAME
      affected_row_count - Same as get_affected_row_count

SYNTAX
      <ClassicResult>.affected_row_count

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 affected_items_count property instead.

#@<OUT> classicresult.auto_increment_value
NAME
      auto_increment_value - Returns the last insert id auto generated (from an
                             insert operation).

SYNTAX
      <ClassicResult>.auto_increment_value

#@<OUT> classicresult.column_count
NAME
      column_count - Retrieves the number of columns on the current result.

SYNTAX
      <ClassicResult>.column_count

#@<OUT> classicresult.column_names
NAME
      column_names - Gets the columns on the current result.

SYNTAX
      <ClassicResult>.column_names

#@<OUT> classicresult.columns
NAME
      columns - Gets the column metadata for the columns on the active result.

SYNTAX
      <ClassicResult>.columns

#@<OUT> classicresult.execution_time
NAME
      execution_time - Retrieves a string value indicating the execution time
                       of the executed operation.

SYNTAX
      <ClassicResult>.execution_time

#@<OUT> classicresult.fetch_all
NAME
      fetch_all - Returns a list of Row objects which contains an element for
                  every record left on the result.

SYNTAX
      <ClassicResult>.fetch_all()

RETURNS
      A List of Row objects.

DESCRIPTION
      If this function is called right after executing a query, it will return
      a Row for every record on the resultset.

      If fetchOne is called before this function, when this function is called
      it will return a Row for each of the remaining records on the resultset.

#@<OUT> classicresult.fetch_one
NAME
      fetch_one - Retrieves the next Row on the ClassicResult.

SYNTAX
      <ClassicResult>.fetch_one()

RETURNS
      A Row object representing the next record in the result.

#@<OUT> classicresult.fetch_one_object
NAME
      fetch_one_object - Retrieves the next Row on the result and returns it as
                         an object.

SYNTAX
      <ClassicResult>.fetch_one_object()

RETURNS
      A dictionary containing the row information.

DESCRIPTION
      The column names will be used as keys in the returned dictionary and the
      column data will be used as the key values.

      If a column is a valid identifier it will be accessible as an object
      attribute as <dict>.<column>.

      If a column is not a valid identifier, it will be accessible as a
      dictionary key as <dict>[<column>].

#@<OUT> classicresult.get_affected_items_count
NAME
      get_affected_items_count - The the number of affected items for the last
                                 operation.

SYNTAX
      <ClassicResult>.get_affected_items_count()

RETURNS
      the number of affected items.

#@<OUT> classicresult.get_affected_row_count
NAME
      get_affected_row_count - The number of affected rows for the last
                               operation.

SYNTAX
      <ClassicResult>.get_affected_row_count()

RETURNS
      the number of affected rows.

DESCRIPTION
      ATTENTION: This function will be removed in a future release, use the
                 get_affected_items_count function instead.

      This is the value of the C API mysql_affected_rows(), see
      https://dev.mysql.com/doc/refman/en/mysql-affected-rows.html

#@<OUT> classicresult.get_auto_increment_value
NAME
      get_auto_increment_value - Returns the last insert id auto generated
                                 (from an insert operation).

SYNTAX
      <ClassicResult>.get_auto_increment_value()

RETURNS
      the integer representing the last insert id.

#@<OUT> classicresult.get_column_count
NAME
      get_column_count - Retrieves the number of columns on the current result.

SYNTAX
      <ClassicResult>.get_column_count()

RETURNS
      the number of columns on the current result.

#@<OUT> classicresult.get_column_names
NAME
      get_column_names - Gets the columns on the current result.

SYNTAX
      <ClassicResult>.get_column_names()

RETURNS
      A list with the names of the columns returned on the active result.

#@<OUT> classicresult.get_columns
NAME
      get_columns - Gets the column metadata for the columns on the active
                    result.

SYNTAX
      <ClassicResult>.get_columns()

RETURNS
      a list of column metadata objects containing information about the
      columns included on the active result.

#@<OUT> classicresult.get_execution_time
NAME
      get_execution_time - Retrieves a string value indicating the execution
                           time of the executed operation.

SYNTAX
      <ClassicResult>.get_execution_time()

#@<OUT> classicresult.get_info
NAME
      get_info - Retrieves a string providing information about the most
                 recently executed statement.

SYNTAX
      <ClassicResult>.get_info()

RETURNS
      a string with the execution information.

#@<OUT> classicresult.get_warning_count
NAME
      get_warning_count - The number of warnings produced by the last statement
                          execution.

SYNTAX
      <ClassicResult>.get_warning_count()

RETURNS
      the number of warnings.

DESCRIPTION
      ATTENTION: This function will be removed in a future release, use the
                 get_warnings_count function instead.

      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See get_warnings() for more details.

#@<OUT> classicresult.get_warnings_count
NAME
      get_warnings_count - The number of warnings produced by the last
                           statement execution.

SYNTAX
      <ClassicResult>.get_warnings_count()

RETURNS
      the number of warnings.

DESCRIPTION
      This is the same value than C API mysql_warning_count, see
      https://dev.mysql.com/doc/refman/en/mysql-warning-count.html

      See get_warnings() for more details.

#@<OUT> classicresult.get_warnings
NAME
      get_warnings - Retrieves the warnings generated by the executed
                     operation.

SYNTAX
      <ClassicResult>.get_warnings()

RETURNS
      a list containing a warning object for each generated warning.

DESCRIPTION
      Each warning object contains a key/value pair describing the information
      related to a specific warning.

      This information includes: level, code and message.

#@<OUT> classicresult.has_data
NAME
      has_data - Returns true if the last statement execution has a result set.

SYNTAX
      <ClassicResult>.has_data()

#@<OUT> classicresult.help
NAME
      help - Provides help about this class and it's members

SYNTAX
      <ClassicResult>.help([member])

WHERE
      member: If specified, provides detailed information on the given member.

#@<OUT> classicresult.info
NAME
      info - Retrieves a string providing information about the most recently
             executed statement.

SYNTAX
      <ClassicResult>.info

#@<OUT> classicresult.next_data_set
NAME
      next_data_set - Prepares the SqlResult to start reading data from the
                      next Result (if many results were returned).

SYNTAX
      <ClassicResult>.next_data_set()

RETURNS
      A boolean value indicating whether there is another result or not.

DESCRIPTION
      ATTENTION: This function will be removed in a future release, use the
                 next_result function instead.

#@<OUT> classicresult.next_result
NAME
      next_result - Prepares the SqlResult to start reading data from the next
                    Result (if many results were returned).

SYNTAX
      <ClassicResult>.next_result()

RETURNS
      A boolean value indicating whether there is another esult or not.

#@<OUT> classicresult.warning_count
NAME
      warning_count - Same as get_warning_count

SYNTAX
      <ClassicResult>.warning_count

DESCRIPTION
      ATTENTION: This property will be removed in a future release, use the
                 warnings_count property instead.

#@<OUT> classicresult.warnings_count
NAME
      warnings_count - Same as get_warnings_count

SYNTAX
      <ClassicResult>.warnings_count

#@<OUT> classicresult.warnings
NAME
      warnings - Retrieves the warnings generated by the executed operation.

SYNTAX
      <ClassicResult>.warnings

