# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class SurfaceNets2D(PolyDataAlgorithm):
    r"""
    SurfaceNets2D - generate smoothed constours from segmented 2D
    image data (i.e., "label maps")
    
    Superclass: PolyDataAlgorithm
    
    SurfaceNets2D creates boundary/isocontour lines from a label map
    (e.g., a segmented image) using a threaded, 2D version of the
    multiple regions/labels surface nets algorithm. The input is a 2D
    image where each pixel is labeled (integer labels are preferred to
    real values), and the output data is polygonal data separating
    labeled regions via line segments. (Note that on output each region
    [corresponding to a different segmented object] will share
    points/edges on a common boundary, i.e., two objects next to each
    other will share the boundary that separates them.)
    
    While this filter is similar to a contouring operation, classic
    contouring methods assume a continuous scalar field. In comparision,
    label maps are not continuous in scalar function value, meaning that
    usual data interpolation (e.g., along edges) is not possible.
    Instead, when the edge endpoint pixels are labeled in differing
    regions, the edge is split and transected by a line segment that
    connects the center points of the squares on either side of the edge.
    Later, using a energy minimization smoothing process, these split
    edges will be adjusted to produce a smoother result. (Constraints on
    smoothing displacements may be specified to prevent excessive
    shrinkage and/or object distortion.)
    
    The smoothing process is controlled by setting a convergence measure,
    the number of smoothing iterations, the step size, and the allowed
    (constraint) distance that points may move.  These can be adjusted to
    provide the desired result. This class provides a method to access an
    internal instance of ConstrainedSmoothingFilter, through which
    these smoothing parameters may be specified, and which actually
    performs the smoothing operation. (Note: it is possible to skip the
    smoothing process altogether by disabling smoothing (e.g., invoking
    smoothing_off()) or setting the number of smoothing iterations to
    zero. This can be useful when using a different smoothing filter like
    WindowedSincPolyDataFilter; or if an unsmoothed, aliased output is
    desired. The reason the smoothing is built in to this filter is to
    remain faithful to the published literature describing the surface
    nets algorithm.)
    
    The surface_nets algorithm was first proposed by Sarah Frisken.  Two
    important papers include the description of surface nets for binary
    objects (i.e., extracting just one segmented object from a volume)
    and multi-label (multiple object extraction).
    
    S. Frisken (Gibson), “Constrained Elastic surface_nets: Generating
    Smooth Surfaces from Binary Segmented Data”, Proc. MICCAI, 1998,
    pp. 888-898.
    
    S. Frisken, “surface_nets for Multi-Label Segmentations with
    Preservation of Sharp Boundaries”, J. Computer Graphics Techniques,
    2022.
    
    Note that one nice feature of this filter is that algorithm execution
    occurs only once no matter the number of object labels / contour
    values. In many contouring-like algorithms, each separate contour
    value requires an additional algorithm execution with a new contour
    value. So in this filter large numbers of contour values do not
    significantly affect overall speed. The user can specify which
    objects (i.e., labels) are to be output to the filter. (Unspecified
    labels are treated as background and not output.)
    
    The filter can optionally output a two-component, cell data array
    indicating the labels/regions on either side of the line segments
    composing the output PolyData. This can be used for advanced
    operations like extracting shared/contacting boundaries between two
    objects. The name of this cell data array is "boundary_labels".
    
    Implementation note: For performance reasons, this filter is
    internally implemented quite differently than described in the
    literature.  The main difference is that concepts from the Flying
    Edges parallel isocontouring algorithm are used. Namely, parallel,
    edge-by-edge processing is used to define cell cases, generate
    smoothing stencils, and produce points and output lines. The
    smoothing process is also threaded using a double-buffering approach.
    
    @warning
    This filter is specialized to 2D images.
    
    @warning
    Subtle differences in the output may result when the number of
    objects / labels changes. This is because the smoothing operation
    operates on all of the boundaries simultaneously. If the boundaries
    change due to a difference in the number of regions / labels, then
    the smoothing operation can produce different results.
    
    @warning
    The filters DiscreteMarchingCubes, DiscreteFlyingEdges2D,
    DiscreteFlyingEdges3D, and DiscreteFlyingEdgesClipper2D also
    perform isocontour extraction. However these filters produce output
    that may not share common boundary cells, and may produce "gaps"
    between segmented regions. For example, DiscreteMarchingCubes will
    share points between adjacent regions, but not triangle cells (which
    will be conincident). Also, no center point is inserted into voxels,
    meaning that intermittent gaps may form between regions.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    SurfaceNets3D DiscreteFlyingEdges2D
    DiscreteFlyingEdgesClipper2D ConstrainedSmoothingFilter
    FlyingEdges2D FlyingEdges3D WindowedSincPolyDataFilter
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkSurfaceNets2D, obj, update, **traits)
    
    compute_scalars = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable/disable an option to generate cell scalars in the output.
        The cell scalars are a two-tuple that indicates which labels
        (i.e., segmented regions) are on either side of each (line) cell
        (l0,l1) with l0<l1.  If an object is one-sided (meaning the
        background is on one side of the line) then l1=(outside_label).
        The name of the output cell scalars is "boundary_labels". By
        default this flag is on.
        """
    )

    def _compute_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetComputeScalars,
                        self.compute_scalars_)

    data_caching = tvtk_base.true_bool_trait(desc=\
        r"""
        Enable caching of intermediate data. A common workflow using this
        filter requires extracting object boundaries, and then repeatedly
        rerunning the smoothing process with different parameters. To
        improve performance by avoiding repeated extraction of the
        boundary, the filter can cache intermediate data prior to the
        smoothing process. In this way, the boundary is only extracted
        once, and as long as only the internal constrained smoothing
        filter is modified, then boundary extraction will not be
        reexecuted. By default this is enabled.
        """
    )

    def _data_caching_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetDataCaching,
                        self.data_caching_)

    smoothing = tvtk_base.true_bool_trait(desc=\
        r"""
        Indicate whether smoothing should be enabled. By default, after
        the isoline is extracted, smoothing occurs using the built-in
        smoother. To disable smoothing, invoke smoothing_off().
        """
    )

    def _smoothing_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSmoothing,
                        self.smoothing_)

    array_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get which component of a input multi-component scalar array
        to contour with; defaults to component 0.
        """
    )

    def _array_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayComponent,
                        self.array_component)

    background_label = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        If computing cell scalars, specify the label to use when
        referencing a labeled region outside any of the specified regions
        (i.e., when referencing the background region). By default this
        value is zero. Be very careful of the value being used here, it
        should not overlap an extracted label value, and because it is
        the same type as the input image scalars, make sure the value can
        be properly represented (i.e., if the input scalars are an
        unsigned type, then background_label should not be negative).
        """
    )

    def _background_label_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetBackgroundLabel,
                        self.background_label)

    def get_label(self, *args):
        """
        get_label(self, i:int) -> float
        C++: double get_label(int i)"""
        ret = self._wrap_call(self._vtk_obj.GetLabel, *args)
        return ret

    def set_label(self, *args):
        """
        set_label(self, i:int, value:float) -> None
        C++: void set_label(int i, double value)"""
        ret = self._wrap_call(self._vtk_obj.SetLabel, *args)
        return ret

    number_of_contours = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _number_of_contours_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfContours,
                        self.number_of_contours)

    number_of_labels = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Set the number of labels to place into the list. You only really
        need to use this method to reduce list size. The method
        set_value() will automatically increase list size as needed. Note
        that for consistency with other isocountoring-related algorithms,
        some methods use "Labels" and "Contours" interchangeably.
        """
    )

    def _number_of_labels_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfLabels,
                        self.number_of_labels)

    def get_value(self, *args):
        """
        get_value(self, i:int) -> float
        C++: double get_value(int i)
        Get the ith label value.
        """
        ret = self._wrap_call(self._vtk_obj.GetValue, *args)
        return ret

    def set_value(self, *args):
        """
        set_value(self, i:int, value:float) -> None
        C++: void set_value(int i, double value)
        Set a particular label value at label number i. The index i
        ranges between 0 <= i <number_of_labels. (Note: while labels values
        are expressed as doubles, the underlying scalar data may be a
        different type. During execution the label values are cast to the
        type of the scalar data.) Note the use of "Value" and "Label"
        when specifying regions to extract. The use of "Value" is
        continuous with other VTK continuous-scalar field isocontouring
        algorithms; however the term "Label" is more consistent with
        label maps.
        """
        ret = self._wrap_call(self._vtk_obj.SetValue, *args)
        return ret

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_labels(self):
        return self._vtk_obj.GetLabels()
    labels = traits.Property(_get_labels, desc=\
        r"""
        
        """
    )

    def get_labels(self, *args):
        """
        get_labels(self) -> Pointer
        C++: double *get_labels()
        get_labels(self, contourValues:[float, ...]) -> None
        C++: void get_labels(double *contourValues)"""
        ret = self._wrap_call(self._vtk_obj.GetLabels, *args)
        return ret

    def _get_smoother(self):
        return wrap_vtk(self._vtk_obj.GetSmoother())
    smoother = traits.Property(_get_smoother, desc=\
        r"""
        Get the instance of ConstrainedSmoothingFilter used to smooth
        the extracted surface net. To control smoothing, access this
        instance and specify its parameters such as number of smoothing
        iterations and constraint distance. If you wish to disable
        smoothing, set smoothing_off().
        """
    )

    def _get_values(self):
        return self._vtk_obj.GetValues()
    values = traits.Property(_get_values, desc=\
        r"""
        Get a pointer to an array of labels. There will be
        get_number_of_labels() values in the list.
        """
    )

    def get_values(self, *args):
        """
        get_values(self) -> Pointer
        C++: double *get_values()
        get_values(self, contourValues:[float, ...]) -> None
        C++: void get_values(double *contourValues)
        Get a pointer to an array of labels. There will be
        get_number_of_labels() values in the list.
        """
        ret = self._wrap_call(self._vtk_obj.GetValues, *args)
        return ret

    def generate_labels(self, *args):
        """
        generate_labels(self, numLabels:int, range:[float, float]) -> None
        C++: void generate_labels(int numLabels, double range[2])
        generate_labels(self, numLabels:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_labels(int numLabels, double rangeStart,
            double rangeEnd)
        Generate numLabels equally spaced labels between the specified
        range. The labels will include the min/max range values.
        """
        ret = self._wrap_call(self._vtk_obj.GenerateLabels, *args)
        return ret

    def generate_values(self, *args):
        """
        generate_values(self, numContours:int, range:[float, float])
            -> None
        C++: void generate_values(int numContours, double range[2])
        generate_values(self, numContours:int, rangeStart:float,
            rangeEnd:float) -> None
        C++: void generate_values(int numContours, double rangeStart,
            double rangeEnd)"""
        ret = self._wrap_call(self._vtk_obj.GenerateValues, *args)
        return ret

    _updateable_traits_ = \
    (('compute_scalars', 'GetComputeScalars'), ('data_caching',
    'GetDataCaching'), ('smoothing', 'GetSmoothing'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('array_component', 'GetArrayComponent'),
    ('background_label', 'GetBackgroundLabel'), ('number_of_contours',
    'GetNumberOfContours'), ('number_of_labels', 'GetNumberOfLabels'),
    ('progress_text', 'GetProgressText'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'compute_scalars', 'data_caching', 'debug',
    'global_warning_display', 'release_data_flag', 'smoothing',
    'array_component', 'background_label', 'number_of_contours',
    'number_of_labels', 'object_name', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(SurfaceNets2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit SurfaceNets2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['compute_scalars', 'data_caching', 'smoothing'], [],
            ['array_component', 'background_label', 'number_of_contours',
            'number_of_labels', 'object_name']),
            title='Edit SurfaceNets2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit SurfaceNets2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

