#if   !defined(__OBJECTMODEL_HPP)
#define __OBJECTMODEL_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__FACADE_HPP)
#include <Facade.hpp>
#endif

#if   !defined(__OBJECT_HPP)
#include <Object.hpp>
#endif

#include <iostream>

using namespace std;

DECLARE_CLASS( Dictionary );
DECLARE_CLASS( Modeler );

DECLARE_TYPE( CORELINUX(Exception), NameExistException );
DECLARE_TYPE( CORELINUX(Exception), NameNotExistException );

/**
ObjectModel is the concentrator, or Facade for the underlying
subsystems for managing object creation, the name dictionary, and
hierarchical relationships.
*/

DECLARE_CLASS( ObjectModel );

class ObjectModel : public CORELINUX(Facade)
{
public:

   //
   // Constructors and destructor
   //

                           /**
                           Default constructor requires a 
                           name for the Model instance
                           @param string const reference
                           */

                           ObjectModel( const string & );

                           /// Virtual destructor

   virtual                 ~ObjectModel( void );

   //
   // Operator overloads
   //

            /**
            Equality operator
            @param ObjectModel const reference
            @return bool - true if same instance
            */

            bool  operator==( ObjectModelCref ) const;

   //
   // Accessors
   //

            /**
            Retrieves the ObjectModel instance name
            @return string const reference
            */

            const string & getName( void ) const;

   //
   // Mutators
   //

   //
   // Service calls
   //

            /**
            Create object adds a object to the model,
            making "Root" the default parent
            @param string const reference to object name
            @exception NameExistsException if the name
            being asked to create already exists
            */

   virtual  void  createObject( const string & ) 
                     throw (NameExistException);

            /**
            Destroy an existing object.
            @param string const reference to object name
            @exception NameNotExistException if the name
            being asked to destroy does not exists
            */

   virtual  void  destroyObject( const string & ) 
                     throw (NameNotExistException);

            /**
            Change the name of an object
            @param string const reference to old name
            @param string const reference to new name
            @exception NameNotExistException if the old name
            does not exists
            @exception NameExistsException if the new name
            already exists
            */

   virtual  void  changeName( const string &, const string & )
                     throw( NameExistException, NameNotExistException );

            /**
            Add parent to an object
            @param string const reference to child name
            @param string const reference to parent name
            @exception NameNotExistException if the either name
            does not exists
            */
            
   virtual  void  addParent( const string &, const string & )
                     throw (NameNotExistException);

            /**
            Remove a parent from an object
            @param string const reference to child name
            @param string const reference to parent name
            @exception NameNotExistException if the either name
            does not exists
            */

   virtual  void  removeParent( const string &, const string & )
                     throw (NameNotExistException);

            /**
            Displays information on a particular object.
            @param string const reference to object name
            @param ostream reference to output stream
            @exception NameNotExistException if the name
            does not exists
            */

   virtual  void  display( const string &, ostream & ) 
                     throw (NameNotExistException);

            /**
            Displays information on the entire model
            @param ostream reference to output stream
            */

   virtual  void  display( ostream & );

protected:

                        /// Default constructor 

                        ObjectModel( void );

                        /// Copy constructor

                        ObjectModel( ObjectModelCref );

            /// Assignment operator

            ObjectModelRef operator=( ObjectModelCref );

   
private:

            ObjectCref     theRoot;          /// The root object of the model
            string         theName;          /// The ObjectModel name
            DictionaryPtr  theDictionary;    /// The Object name dictionary
            ModelerPtr     theModeler;       /// The object relationships

};


#endif // if   !defined(__OBJECTMODEL_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/02/10 14:32:21 $
   $Locker:  $
*/

