// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W32 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 -show-encoding %s | FileCheck --check-prefixes=GFX11,W64 %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=+wavefrontsize32,-wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W32-ERR --implicit-check-not=error: %s
// RUN: not llvm-mc -arch=amdgcn -mcpu=gfx1100 -mattr=-wavefrontsize32,+wavefrontsize64 %s 2>&1 | FileCheck --check-prefix=W64-ERR --implicit-check-not=error: %s

v_add3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_add3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_add3_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_add3_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_add3_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x55,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_add3_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x55,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_mirror
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_half_mirror
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:1
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:15
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:1
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:15
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_ror:1
// W32: [0x05,0x06,0x20,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s105, v1, v2, s105 row_ror:15
// W32: [0x05,0x69,0x20,0xd5,0xfa,0x04,0xa6,0x01,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, vcc_lo, v1, v2, vcc_hi row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x20,0xd5,0xfa,0x04,0xae,0x01,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, vcc_hi, v1, v2, vcc_lo row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x20,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, ttmp15, v1, v2, ttmp15 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x20,0xd5,0xfa,0x04,0xee,0x01,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_mirror
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_half_mirror
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:1
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:15
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:1
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:15
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:1
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:15
// W64: [0x05,0x0c,0x20,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, s[104:105], v1, v2, s[104:105] row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x20,0xd5,0xfa,0x04,0xa2,0x01,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, vcc, v1, v2, vcc row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x20,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v5, ttmp[14:15], v1, v2, ttmp[14:15] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x20,0xd5,0xfa,0x04,0xea,0x01,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_ci_u32_e64_dpp v255, null, v255, v255, null clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x20,0xd5,0xfa,0xfe,0xf3,0x01,0xff,0x6f,0x0d,0x30]

v_add_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_mirror
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_half_mirror
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_shl:1
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_shl:15
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_shr:1
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_shr:15
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s6, v1, v2 row_ror:1
// W32: [0x05,0x06,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s105, v1, v2 row_ror:15
// W32: [0x05,0x69,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_mirror
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_half_mirror
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:1
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:15
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:1
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:15
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:1
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:15
// W64: [0x05,0x0c,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v5, ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x00,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_add_co_u32_e64_dpp v255, null, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x00,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x32,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x32,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_add_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x32,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_add_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x32,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_add_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x03,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x03,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_add_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x03,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_add_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x03,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_add_lshl_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_add_lshl_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_add_lshl_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x47,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_add_lshl_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x47,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_add_nc_i16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_i16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_add_nc_i16_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x0d,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_nc_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x26,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_add_nc_i32_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x26,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_nc_u16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_u16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_add_nc_u16_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x03,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_nc_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x25,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_add_nc_u32_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x25,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_alignbit_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_alignbit_b32_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_alignbit_b32_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x16,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_alignbit_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x16,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_alignbyte_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_alignbyte_b32_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_alignbyte_b32_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x17,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_alignbyte_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x17,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_and_b16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_and_b16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_and_b16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_and_b16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x62,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_and_b16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x62,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_and_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_and_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_and_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_and_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_and_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1b,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_and_or_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_and_or_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_and_or_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x57,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_and_or_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x57,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_ashrrev_i16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_ashrrev_i16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x3a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_ashrrev_i16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x3a,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_ashrrev_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_ashrrev_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_ashrrev_i32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1a,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_bcnt_u32_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_bcnt_u32_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1e,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_bfe_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_bfe_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_bfe_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x11,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_bfe_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x11,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_bfe_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_bfe_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_bfe_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x10,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_bfe_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x10,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_bfi_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_bfi_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_bfi_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x12,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_bfi_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x12,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_bfm_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_bfm_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_bfm_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_bfm_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1d,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_bfrev_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_bfrev_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_ceil_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdc,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa2,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_cls_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cls_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cls_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_clz_i32_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_clz_i32_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x7d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f16_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x01,0x7d,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x0d,0x30]

v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x7e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_class_f32_e64_dpp null, -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x01,0x7e,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x0d,0x30]

v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x02,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x02,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x02,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x02,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x02,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x02,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x12,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x12,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x12,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x12,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x12,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x12,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x32,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x32,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x42,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x42,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x3a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x3a,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_eq_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4a,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_f_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x00,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x00,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x00,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x00,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x00,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x00,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_f_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x10,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x10,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x10,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x10,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x10,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x10,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_f_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x40,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x40,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_f_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x48,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_f_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x48,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x06,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x06,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x06,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x06,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x06,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x06,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x16,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x16,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x16,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x16,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x16,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x16,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x36,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x36,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x46,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x46,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x3e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x3e,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ge_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4e,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x04,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x04,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x04,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x04,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x04,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x04,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x14,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x14,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x14,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x14,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x14,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x14,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x34,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x34,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x44,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x44,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x3c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x3c,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_gt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4c,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x03,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x03,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x03,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x03,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x03,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x03,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x13,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x13,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x13,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x13,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x13,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x13,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x33,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x33,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x43,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x43,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x3b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x3b,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_le_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4b,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x05,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x05,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x05,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x05,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x05,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x05,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x15,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x15,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x15,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x15,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x15,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x15,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x01,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x01,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x01,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x01,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x01,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x01,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x11,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x11,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x11,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x11,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x11,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x11,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x31,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x31,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x41,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x41,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x39,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x39,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x49,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_lt_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x49,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x35,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x35,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x45,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x45,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x3d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u16_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x3d,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ne_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4d,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_neq_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x09,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x09,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x09,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x09,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x09,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x09,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x19,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x19,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x19,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x19,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x19,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nge_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x19,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_ngt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nle_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlg_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_nlt_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x07,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x07,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x07,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x07,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x07,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x07,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x17,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x17,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x17,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x17,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x17,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_o_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x17,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_t_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_t_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_t_i32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x47,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_i32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x47,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_t_u32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x00,0x4f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_t_u32_e64_dpp null, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x00,0x4f,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmp_tru_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x0f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x0f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x0f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x0f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x0f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x0f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_tru_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x1f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x1f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x1f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x1f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x1f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_tru_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x1f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x08,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x08,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x08,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x08,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x08,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f16_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x08,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_mirror
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_half_mirror
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:1
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shl:15
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:1
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_shr:15
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s5, v1, v2 row_ror:1
// W32: [0x05,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s105, v1, v2 row_ror:15
// W32: [0x69,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x6a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc_hi, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x6b,0x01,0x18,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp ttmp15, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x7b,0x02,0x18,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_mirror
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_half_mirror
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:1
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shl:15
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:1
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_shr:15
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:1
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[10:11], v1, v2 row_ror:15
// W64: [0x0a,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x68,0x00,0x18,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp vcc, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x6a,0x01,0x18,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp ttmp[14:15], -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x7a,0x02,0x18,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cmp_u_f32_e64_dpp null, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7c,0x83,0x18,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_class_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_class_f16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_class_f16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_class_f16_e64_dpp -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x01,0xfd,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x0d,0x30]

v_cmpx_class_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_class_f32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_class_f32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xfe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_class_f32_e64_dpp -|v255|, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x01,0xfe,0xd4,0xfa,0xfe,0x03,0x20,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x82,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_eq_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x82,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_eq_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x82,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x92,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x92,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_eq_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x92,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_eq_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x92,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_eq_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_eq_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb2,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_eq_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_eq_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc2,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_eq_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_eq_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xba,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_eq_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_eq_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_eq_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_eq_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xca,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_f_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_f_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x80,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_f_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x80,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_f_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x80,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_f_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x80,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_f_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_f_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x90,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_f_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x90,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_f_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x90,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_f_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x90,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_f_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_f_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_f_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_f_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc0,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_f_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_f_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_f_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_f_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc8,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x86,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_ge_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x86,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_ge_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x86,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x96,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x96,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_ge_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x96,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_ge_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x96,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ge_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ge_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb6,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ge_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ge_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc6,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ge_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ge_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xbe,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ge_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ge_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ge_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ge_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xce,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x84,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_gt_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x84,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_gt_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x84,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x94,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x94,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_gt_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x94,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_gt_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x94,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_gt_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_gt_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb4,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_gt_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_gt_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc4,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_gt_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_gt_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xbc,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_gt_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_gt_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_gt_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_gt_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xcc,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_le_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x83,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_le_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x83,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_le_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x83,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_le_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x93,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x93,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_le_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x93,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_le_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x93,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_le_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_le_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_le_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb3,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_le_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_le_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_le_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc3,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_le_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_le_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_le_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xbb,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_le_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_le_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_le_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_le_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xcb,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_lg_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lg_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lg_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x85,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_lg_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x85,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_lg_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x85,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_lg_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lg_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x95,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lg_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x95,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_lg_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x95,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_lg_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x95,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x81,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_lt_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x81,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_lt_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x81,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x91,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x91,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_lt_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x91,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_lt_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x91,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_lt_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_lt_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb1,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_lt_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_lt_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc1,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_lt_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_lt_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb9,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_lt_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_lt_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_lt_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_lt_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc9,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ne_i16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ne_i16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ne_i16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ne_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xb5,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ne_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ne_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ne_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ne_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc5,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ne_u16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ne_u16_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ne_u16_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ne_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xbd,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_ne_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ne_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_ne_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_ne_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xcd,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_neq_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_neq_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_neq_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_neq_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_neq_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_neq_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_neq_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9d,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_neq_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9d,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_neq_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9d,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_neq_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9d,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nge_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nge_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nge_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x89,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nge_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x89,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nge_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x89,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nge_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nge_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x99,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nge_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x99,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nge_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x99,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nge_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x99,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_ngt_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ngt_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_ngt_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_ngt_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_ngt_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9b,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_ngt_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9b,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_ngt_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9b,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_ngt_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9b,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nle_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nle_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nle_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nle_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nle_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nle_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nle_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9c,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nle_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9c,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nle_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9c,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nle_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9c,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nlg_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nlg_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nlg_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nlg_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nlg_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9a,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nlg_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9a,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nlg_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9a,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nlg_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9a,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nlt_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nlt_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nlt_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nlt_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_nlt_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9e,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_nlt_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9e,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_nlt_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9e,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_nlt_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9e,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_o_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_o_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_o_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x87,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_o_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x87,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_o_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x87,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_o_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_o_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x97,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_o_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x97,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_o_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x97,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_o_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x97,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_t_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_t_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_t_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_t_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_t_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_t_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_t_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_t_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_t_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_t_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_t_i32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_t_i32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_t_i32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_t_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xc7,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_t_u32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_t_u32_e64_dpp v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cmpx_t_u32_e64_dpp v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cmpx_t_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x00,0xcf,0xd4,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cmpx_tru_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_tru_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x8f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_tru_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x8f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_tru_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x8f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_tru_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x8f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_tru_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_tru_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x9f,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_tru_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x9f,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_tru_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x9f,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_tru_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x9f,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_u_f16_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_u_f16_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_u_f16_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x88,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_u_f16_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x88,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_u_f16_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x88,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cmpx_u_f32_e64_dpp v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_mirror
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_half_mirror
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_shl:1
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_shl:15
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_shr:1
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_shr:15
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_ror:1
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_ror:15
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cmpx_u_f32_e64_dpp v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x7e,0x00,0x98,0xd4,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cmpx_u_f32_e64_dpp |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x7e,0x01,0x98,0xd4,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cmpx_u_f32_e64_dpp -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x7e,0x02,0x98,0xd4,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cmpx_u_f32_e64_dpp -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0x7e,0x83,0x98,0xd4,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cndmask_b16_e64_dpp v5, v1, v2, s3 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_mirror
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_half_mirror
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_shl:1
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_shl:15
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_shr:1
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_shr:15
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s3 row_ror:1
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x0e,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s105 row_ror:15
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, vcc_hi row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0xae,0x01,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, |v1|, -v2, vcc_lo row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x01,0x5d,0xd6,0xfa,0x04,0xaa,0x41,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, -v1, |v2|, ttmp15 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x02,0x5d,0xd6,0xfa,0x04,0xee,0x21,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] quad_perm:[3,2,1,0]
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] quad_perm:[0,1,2,3]
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_mirror
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_half_mirror
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_shl:1
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_shl:15
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_shr:1
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_shr:15
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_ror:1
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[6:7] row_ror:15
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0x1a,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, v1, v2, s[104:105] row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x00,0x5d,0xd6,0xfa,0x04,0xa2,0x01,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, |v1|, -v2, vcc row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x01,0x5d,0xd6,0xfa,0x04,0xaa,0x41,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v5, -v1, |v2|, ttmp[14:15] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x02,0x5d,0xd6,0xfa,0x04,0xea,0x21,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b16_e64_dpp v255, -|v255|, -|v255|, null row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x5d,0xd6,0xfa,0xfe,0xf3,0x61,0xff,0x6f,0x0d,0x30]

v_cndmask_b32_e64_dpp v5, v1, v2, s3 quad_perm:[3,2,1,0]
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 quad_perm:[0,1,2,3]
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_mirror
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_half_mirror
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_shl:1
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_shl:15
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_shr:1
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_shr:15
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s3 row_ror:1
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s105 row_ror:15
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0xa6,0x01,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, vcc_hi row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x00,0x01,0xd5,0xfa,0x04,0xae,0x01,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, |v1|, -v2, vcc_lo row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x01,0x01,0xd5,0xfa,0x04,0xaa,0x41,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, -v1, |v2|, ttmp15 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x02,0x01,0xd5,0xfa,0x04,0xee,0x21,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] quad_perm:[3,2,1,0]
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] quad_perm:[0,1,2,3]
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_mirror
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_half_mirror
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_shl:1
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_shl:15
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_shr:1
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_shr:15
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_ror:1
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[6:7] row_ror:15
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, v1, v2, s[104:105] row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x00,0x01,0xd5,0xfa,0x04,0xa2,0x01,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, |v1|, -v2, vcc row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x01,0x01,0xd5,0xfa,0x04,0xaa,0x41,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v5, -v1, |v2|, ttmp[14:15] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x02,0x01,0xd5,0xfa,0x04,0xea,0x21,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_cndmask_b32_e64_dpp v255, -|v255|, -|v255|, null row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x01,0xd5,0xfa,0xfe,0xf3,0x61,0xff,0x6f,0x0d,0x30]

v_cos_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xe1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_cos_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ctz_i32_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ctz_i32_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_cubeid_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_cubeid_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0c,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_cubeid_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x0c,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_cubeid_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x0c,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_cubeid_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x0c,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_cubeid_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x0c,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_cubeid_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x0c,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_cubeid_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x0c,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_cubeid_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x0c,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_cubema_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_cubema_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0f,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_cubema_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x0f,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_cubema_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x0f,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_cubema_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x0f,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_cubema_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x0f,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_cubema_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x0f,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_cubema_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x0f,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_cubema_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x0f,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_cubesc_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_cubesc_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0d,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_cubesc_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x0d,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_cubesc_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x0d,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_cubesc_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x0d,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_cubesc_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x0d,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_cubesc_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x0d,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_cubesc_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x0d,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_cubesc_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x0d,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_cubetc_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_cubetc_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0e,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_cubetc_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x0e,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_cubetc_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x0e,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_cubetc_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x0e,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_cubetc_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x0e,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_cubetc_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x0e,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_cubetc_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x0e,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_cubetc_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x0e,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_cvt_f16_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x8a,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_cvt_f16_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_i16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_i16_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0xd1,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f16_u16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_u16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_u16_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0xd0,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x8b,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_i32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_i32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x85,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_u32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_u32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x86,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte0_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x91,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte1_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x92,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte2_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x93,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte3_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x94,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_floor_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_flr_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i16_f16_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x88,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_i32_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_nearest_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_norm_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_i16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xe3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_norm_u16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_u16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_u16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xe4,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_off_f32_i4_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x8e,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x0d,0x30]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x06,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_i16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x06,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pk_i16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x06,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pk_i16_f32_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x06,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cvt_pk_i16_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x24,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cvt_pk_i16_i32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x24,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_norm_i16_f16_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x12,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pk_norm_i16_f16_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x12,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pk_norm_i16_f16_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x12,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_norm_u16_f16_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x13,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pk_norm_u16_f16_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x13,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pk_norm_u16_f16_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x13,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x2f,0xd5,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pk_rtz_f16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x2f,0xd5,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pk_rtz_f16_f32_e64_dpp v255, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x2f,0xd5,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x07,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_u16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x07,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pk_u16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x07,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pk_u16_f32_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x07,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_cvt_pk_u16_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x23,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_cvt_pk_u16_u32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x23,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_cvt_pk_u8_f32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x26,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_cvt_pk_u8_f32_e64_dpp v255, -|v255|, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x26,0xd6,0xfa,0xfe,0xf7,0x23,0xff,0x6f,0x0d,0x30]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x12,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pknorm_i16_f16_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x12,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pknorm_i16_f16_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x12,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pknorm_i16_f16_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x12,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x21,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pknorm_i16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x21,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pknorm_i16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x21,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pknorm_i16_f32_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x21,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x13,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pknorm_u16_f16_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x13,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pknorm_u16_f16_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x13,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pknorm_u16_f16_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x13,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x22,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pknorm_u16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x22,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pknorm_u16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x22,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pknorm_u16_f32_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x22,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x2f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_cvt_pkrtz_f16_f32_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x2f,0xd5,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_cvt_pkrtz_f16_f32_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x2f,0xd5,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_cvt_pkrtz_f16_f32_e64_dpp v255, -|v255|, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x2f,0xd5,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_rpi_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_u16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u16_f16_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd2,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x87,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_cvt_u32_u16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_u16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_u16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_div_fixup_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x54,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x54,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x54,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x54,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x54,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, -|v1|, v2, -|-1| row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x54,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_div_fixup_f16_e64_dpp v5, v1, -|v2|, -|0.5| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x54,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x09,0x13]

v_div_fixup_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x54,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_exp_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd8,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_exp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbl_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbl_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_floor_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdb,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_floor_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_fma_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_fma_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_fma_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_fma_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_fma_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_fma_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_fma_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x48,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_fma_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x48,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_fma_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x48,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_fma_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x48,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_fma_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x48,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_fma_f16_e64_dpp v5, -|v1|, v2, -|-1| row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x48,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_fma_f16_e64_dpp v5, v1, -|v2|, -|0.5| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x48,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x09,0x13]

v_fma_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x48,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_fma_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_fma_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_fma_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_fma_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_fma_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_fma_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_fma_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x13,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_fma_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x13,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_fma_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x13,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_fma_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x13,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_fma_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x13,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_fma_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x13,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_fma_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x13,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_fma_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x13,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_fract_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdf,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_fract_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_frexp_exp_i16_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i16_f16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i16_f16_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xda,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x01,0xbf,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x0d,0x30]

v_frexp_mant_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd9,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xc0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_ldexp_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_ldexp_f16_e64_dpp v5, v1, v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x08,0x01,0x5f,0x01,0x01]

v_ldexp_f16_e64_dpp v5, v1, v2 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x3b,0xd5,0xfa,0x04,0x02,0x10,0x01,0x60,0x09,0x13]

v_ldexp_f16_e64_dpp v255, -|v255|, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x3b,0xd5,0xfa,0xfe,0x03,0x38,0xff,0x6f,0x0d,0x30]

v_ldexp_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_ldexp_f32_e64_dpp v5, v1, v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x08,0x01,0x5f,0x01,0x01]

v_ldexp_f32_e64_dpp v5, v1, v2 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1c,0xd7,0xfa,0x04,0x02,0x10,0x01,0x60,0x09,0x13]

v_ldexp_f32_e64_dpp v255, -|v255|, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0x1c,0xd7,0xfa,0xfe,0x03,0x38,0xff,0x6f,0x0d,0x30]

v_lerp_u8_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_lerp_u8_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_lerp_u8_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x15,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_lerp_u8_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x15,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_log_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_log_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_lshl_add_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_lshl_add_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_lshl_add_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x46,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_lshl_add_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x46,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_lshl_or_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_lshl_or_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_lshl_or_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x56,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_lshl_or_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x56,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_lshlrev_b16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_lshlrev_b16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x38,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_lshlrev_b16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x38,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_lshlrev_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_lshlrev_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x18,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_lshlrev_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x18,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_lshrrev_b16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_lshrrev_b16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x39,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_lshrrev_b16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x39,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_lshrrev_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_lshrrev_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x19,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_lshrrev_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x19,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mad_i16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_i16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_i16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_mad_i16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x53,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_mad_i16_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x53,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_i32_i16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_mad_i32_i16_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_mad_i32_i16_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x5a,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_mad_i32_i16_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x5a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_i32_i24_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_mad_i32_i24_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_mad_i32_i24_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0a,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_mad_i32_i24_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x0a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_mad_u16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x41,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_mad_u16_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x41,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_u32_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_mad_u32_u16_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_mad_u32_u16_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x59,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_mad_u32_u16_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x59,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_u32_u24_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_mad_u32_u24_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_mad_u32_u24_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0b,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_mad_u32_u24_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x0b,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_max3_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_max3_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_max3_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x4c,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_max3_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x4c,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_max3_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x4c,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_max3_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x4c,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_max3_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x4c,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_max3_f16_e64_dpp v5, -|v1|, v2, -|-1| row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x4c,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_max3_f16_e64_dpp v5, v1, -|v2|, -|0.5| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x4c,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x09,0x13]

v_max3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x4c,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_max3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_max3_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_max3_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_max3_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1c,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_max3_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x1c,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_max3_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x1c,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_max3_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x1c,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_max3_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x1c,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_max3_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x1c,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_max3_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x1c,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_max3_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x1c,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_max3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_i16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_max3_i16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x4d,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_max3_i16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x4d,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_max3_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_max3_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1d,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_max3_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1d,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_max3_u16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x4e,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_max3_u16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x4e,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_max3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_max3_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_max3_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_max3_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1e,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_max3_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1e,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x39,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x39,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_max_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x39,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_max_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x39,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_max_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x10,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x10,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_max_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x10,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_max_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x10,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_max_i16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_i16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_i16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_max_i16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0a,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_max_i16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x0a,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_max_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_max_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x12,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_max_i32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x12,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_max_u16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_u16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_u16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_max_u16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x09,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_max_u16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x09,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_max_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_max_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_max_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_max_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x14,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_max_u32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x14,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_maxmin_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_maxmin_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x60,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_maxmin_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x60,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_maxmin_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x60,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_maxmin_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x60,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_maxmin_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x60,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_maxmin_f16_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x60,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_maxmin_f16_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x60,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_maxmin_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x60,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_maxmin_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_maxmin_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x5e,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_maxmin_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x5e,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_maxmin_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x5e,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_maxmin_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x5e,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_maxmin_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x5e,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_maxmin_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x5e,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_maxmin_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x5e,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_maxmin_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x5e,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_maxmin_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_maxmin_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_maxmin_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x64,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_maxmin_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x64,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_maxmin_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_maxmin_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_maxmin_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x62,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_maxmin_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x62,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mbcnt_hi_u32_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x20,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mbcnt_hi_u32_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x20,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mbcnt_lo_u32_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1f,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mbcnt_lo_u32_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1f,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_med3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_med3_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_med3_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_med3_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x4f,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_med3_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x4f,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_med3_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x4f,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_med3_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x4f,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_med3_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x4f,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_med3_f16_e64_dpp v5, -|v1|, v2, -|-1| row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x4f,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_med3_f16_e64_dpp v5, v1, -|v2|, -|0.5| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x4f,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x09,0x13]

v_med3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x4f,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_med3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_med3_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_med3_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_med3_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1f,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_med3_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x1f,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_med3_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x1f,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_med3_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x1f,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_med3_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x1f,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_med3_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x1f,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_med3_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x1f,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_med3_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x1f,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_med3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_i16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_med3_i16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x50,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_med3_i16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x50,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_med3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_med3_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_med3_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x20,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_med3_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x20,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_med3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_med3_u16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x51,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_med3_u16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x51,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_med3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_med3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_med3_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_med3_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_med3_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x21,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_med3_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x21,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_min3_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_min3_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_min3_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x49,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_min3_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x49,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_min3_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x49,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_min3_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x49,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_min3_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x49,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_min3_f16_e64_dpp v5, -|v1|, v2, -|-1| row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x49,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_min3_f16_e64_dpp v5, v1, -|v2|, -|0.5| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x49,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x09,0x13]

v_min3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x49,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_min3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_min3_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_min3_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_min3_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x19,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_min3_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x19,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_min3_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x19,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_min3_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x19,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_min3_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x19,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_min3_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x19,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_min3_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x19,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_min3_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x19,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_min3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_i16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_i16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_min3_i16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x4a,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_min3_i16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x4a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_min3_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_min3_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1a,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_min3_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, v3 row_half_mirror
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x41,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, v255 row_shl:1
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x01,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, s105 row_shl:15
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x0f,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, vcc_hi row_shr:1
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xae,0x01,0x01,0x11,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:15
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x1f,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, ttmp15 row_ror:1
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xee,0x01,0x01,0x21,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, exec_hi row_ror:15
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, exec_lo row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, null row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_min3_u16_e64_dpp v5, v1, v2, -1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x4b,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x09,0x13]

v_min3_u16_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x4b,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_min3_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_min3_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_min3_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_min3_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1b,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_min3_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1b,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x3a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x3a,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_min_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x3a,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_min_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x3a,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_min_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0f,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x0f,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_min_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x0f,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_min_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x0f,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_min_i16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_i16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_i16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_min_i16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0c,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_min_i16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x0c,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_min_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_min_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x11,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_min_i32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x11,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_min_u16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_u16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_u16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_min_u16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0b,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_min_u16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x0b,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_min_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_min_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_min_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_min_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x13,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_min_u32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x13,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_minmax_f16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_minmax_f16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x61,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_minmax_f16_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x61,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_minmax_f16_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x61,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_minmax_f16_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x61,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_minmax_f16_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x61,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_minmax_f16_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x61,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_minmax_f16_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x61,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_minmax_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x61,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_minmax_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_minmax_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x5f,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_minmax_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x5f,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_minmax_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x5f,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_minmax_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x5f,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_minmax_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x5f,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_minmax_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x5f,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_minmax_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x5f,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_minmax_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x5f,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_minmax_i32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_minmax_i32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_minmax_i32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x65,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_minmax_i32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x65,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_minmax_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_minmax_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_minmax_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x63,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_minmax_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x63,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mov_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_mov_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_mov_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movrels_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movrels_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_msad_u8_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_msad_u8_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_msad_u8_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_msad_u8_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_msad_u8_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x39,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_msad_u8_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x39,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_dx9_zero_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x07,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_mul_dx9_zero_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x07,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_mul_dx9_zero_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x07,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_mul_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x35,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x35,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_mul_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x35,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_mul_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x35,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_mul_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x08,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x08,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_mul_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x08,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_mul_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x08,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mul_hi_i32_i24_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0a,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mul_hi_i32_i24_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x0a,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mul_hi_u32_u24_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mul_hi_u32_u24_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x0c,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mul_i32_i24_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mul_i32_i24_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x09,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mul_i32_i24_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x09,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mul_legacy_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x07,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_legacy_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x07,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_mul_legacy_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x07,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_mul_legacy_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x07,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_mul_lo_u16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mul_lo_u16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x05,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mul_lo_u16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x05,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mul_u32_u24_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_mul_u32_u24_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0b,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_mul_u32_u24_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x0b,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_mullit_f32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_mullit_f32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x18,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_mullit_f32_e64_dpp v5, |v1|, v2, -ttmp15 row_shr:15
// GFX11: [0x05,0x01,0x18,0xd6,0xfa,0x04,0xee,0x81,0x01,0x1f,0x01,0xff]

v_mullit_f32_e64_dpp v5, v1, -|v2|, exec_hi row_ror:1
// GFX11: [0x05,0x02,0x18,0xd6,0xfa,0x04,0xfe,0x41,0x01,0x21,0x01,0xff]

v_mullit_f32_e64_dpp v5, -v1, v2, |exec_lo| row_ror:15
// GFX11: [0x05,0x04,0x18,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_mullit_f32_e64_dpp v5, -|v1|, -|v2|, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x03,0x18,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_mullit_f32_e64_dpp v5, -|v1|, v2, -|-1| mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x05,0x18,0xd6,0xfa,0x04,0x06,0xab,0x01,0x5f,0x01,0x01]

v_mullit_f32_e64_dpp v5, v1, -|v2|, -|0.5| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x06,0x18,0xd6,0xfa,0x04,0xc2,0xd3,0x01,0x60,0x09,0x13]

v_mullit_f32_e64_dpp v255, -|v255|, -|v255|, -|src_scc| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x87,0x18,0xd6,0xfa,0xfe,0xf7,0xfb,0xff,0x6f,0x0d,0x30]

v_not_b16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_not_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_or3_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_or3_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_or3_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_or3_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_or3_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x58,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_or3_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x58,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_or_b16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_or_b16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_or_b16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_or_b16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x63,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_or_b16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x63,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_or_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_or_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_or_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_or_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1c,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_or_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1c,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_pack_b32_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x11,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_pack_b32_f16_e64_dpp v5, |v1|, -v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x11,0xd7,0xfa,0x04,0x02,0x40,0x01,0x5f,0x01,0x01]

v_pack_b32_f16_e64_dpp v5, -v1, |v2| row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x11,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x09,0x13]

v_pack_b32_f16_e64_dpp v255, -|v255|, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x03,0x11,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_perm_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_perm_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_perm_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_perm_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_perm_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x44,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_perm_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x44,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_rcp_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xaa,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_iflag_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xab,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rndne_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xde,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rsq_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xae,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_sad_hi_u8_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_sad_hi_u8_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_sad_hi_u8_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x23,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_sad_hi_u8_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x23,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_sad_u16_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_sad_u16_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_sad_u16_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_sad_u16_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_sad_u16_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x24,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_sad_u16_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x24,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_sad_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_sad_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_sad_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_sad_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_sad_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x25,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_sad_u32_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x25,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_sad_u8_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_sad_u8_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_sad_u8_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_sad_u8_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_sad_u8_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x22,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_sad_u8_e64_dpp v255, v255, v255, src_scc clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x22,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_sat_pk_u8_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x0d,0x30]

v_sin_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xe0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_sin_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_sqrt_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xd5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xb3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_mirror
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_half_mirror
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:1
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:15
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:1
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:15
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_ror:1
// W32: [0x05,0x06,0x21,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s105, v1, v2, s105 row_ror:15
// W32: [0x05,0x69,0x21,0xd5,0xfa,0x04,0xa6,0x01,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, vcc_lo, v1, v2, vcc_hi row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x21,0xd5,0xfa,0x04,0xae,0x01,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, vcc_hi, v1, v2, vcc_lo row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x21,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, ttmp15, v1, v2, ttmp15 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x21,0xd5,0xfa,0x04,0xee,0x01,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_mirror
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_half_mirror
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:1
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:15
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:1
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:15
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:1
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:15
// W64: [0x05,0x0c,0x21,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, s[104:105], v1, v2, s[104:105] row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x21,0xd5,0xfa,0x04,0xa2,0x01,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, vcc, v1, v2, vcc row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x21,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v5, ttmp[14:15], v1, v2, ttmp[14:15] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x21,0xd5,0xfa,0x04,0xea,0x01,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_ci_u32_e64_dpp v255, null, v255, v255, null clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x21,0xd5,0xfa,0xfe,0xf3,0x01,0xff,0x6f,0x0d,0x30]

v_sub_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_mirror
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_half_mirror
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_shl:1
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_shl:15
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_shr:1
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_shr:15
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s6, v1, v2 row_ror:1
// W32: [0x05,0x06,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s105, v1, v2 row_ror:15
// W32: [0x05,0x69,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_mirror
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_half_mirror
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:1
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:15
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:1
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:15
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:1
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:15
// W64: [0x05,0x0c,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v5, ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x01,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_sub_co_u32_e64_dpp v255, null, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x01,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_sub_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x33,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x33,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_sub_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x33,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_sub_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x33,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_sub_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x04,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x04,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_sub_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x04,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_sub_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x04,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_sub_nc_i16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_i16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_sub_nc_i16_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x0e,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_sub_nc_i32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_i32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x25,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_sub_nc_i32_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x25,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_sub_nc_u16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_u16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_sub_nc_u16_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x04,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_sub_nc_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x26,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_sub_nc_u32_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x26,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_mirror
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_half_mirror
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:1
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shl:15
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:1
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_shr:15
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s6, v1, v2, s3 row_ror:1
// W32: [0x05,0x06,0x22,0xd5,0xfa,0x04,0x0e,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s105, v1, v2, s105 row_ror:15
// W32: [0x05,0x69,0x22,0xd5,0xfa,0x04,0xa6,0x01,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, vcc_lo, v1, v2, vcc_hi row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x22,0xd5,0xfa,0x04,0xae,0x01,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, vcc_hi, v1, v2, vcc_lo row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x22,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, ttmp15, v1, v2, ttmp15 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x22,0xd5,0xfa,0x04,0xee,0x01,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_mirror
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_half_mirror
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:1
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shl:15
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:1
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_shr:15
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:1
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[12:13], v1, v2, s[6:7] row_ror:15
// W64: [0x05,0x0c,0x22,0xd5,0xfa,0x04,0x1a,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, s[104:105], v1, v2, s[104:105] row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x22,0xd5,0xfa,0x04,0xa2,0x01,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, vcc, v1, v2, vcc row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x22,0xd5,0xfa,0x04,0xaa,0x01,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v5, ttmp[14:15], v1, v2, ttmp[14:15] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x22,0xd5,0xfa,0x04,0xea,0x01,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_ci_u32_e64_dpp v255, null, v255, v255, null clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x22,0xd5,0xfa,0xfe,0xf3,0x01,0xff,0x6f,0x0d,0x30]

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[3,2,1,0]
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 quad_perm:[0,1,2,3]
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_mirror
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_half_mirror
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_shl:1
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_shl:15
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_shr:1
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_shr:15
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s6, v1, v2 row_ror:1
// W32: [0x05,0x06,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s105, v1, v2 row_ror:15
// W32: [0x05,0x69,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, vcc_lo, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W32: [0x05,0x6a,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, vcc_hi, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W32: [0x05,0x6b,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, ttmp15, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W32: [0x05,0x7b,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W64-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[3,2,1,0]
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 quad_perm:[0,1,2,3]
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_mirror
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_half_mirror
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:1
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shl:15
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:1
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_shr:15
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:1
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[12:13], v1, v2 row_ror:15
// W64: [0x05,0x0c,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, s[104:105], v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// W64: [0x05,0x68,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, vcc, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// W64: [0x05,0x6a,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v5, ttmp[14:15], v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// W64: [0x05,0x7a,0x02,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]
// W32-ERR: :[[@LINE-2]]:{{[0-9]+}}: error: invalid operand for instruction

v_subrev_co_u32_e64_dpp v255, null, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0xfc,0x02,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_subrev_f16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_subrev_f16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x34,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_subrev_f16_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x34,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_subrev_f16_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x34,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_subrev_f16_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x34,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_subrev_f32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_subrev_f32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x05,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_subrev_f32_e64_dpp v5, |v1|, -v2 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x01,0x05,0xd5,0xfa,0x04,0x02,0x48,0x01,0x5f,0x01,0x01]

v_subrev_f32_e64_dpp v5, -v1, |v2| mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x02,0x05,0xd5,0xfa,0x04,0x02,0x30,0x01,0x60,0x09,0x13]

v_subrev_f32_e64_dpp v255, -|v255|, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x83,0x05,0xd5,0xfa,0xfe,0x03,0x78,0xff,0x6f,0x0d,0x30]

v_subrev_nc_u32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_subrev_nc_u32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x27,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_subrev_nc_u32_e64_dpp v255, v255, v255 clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x80,0x27,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_trunc_f16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f16_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f16_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f16_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f16_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xdd,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 row_mirror
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_half_mirror
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:15
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x81,0xa1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x0d,0x30]

v_xad_u32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_xad_u32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_xad_u32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_xad_u32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_xad_u32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x45,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_xad_u32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x45,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_xnor_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_xnor_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_xnor_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1e,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_xnor_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1e,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_xor3_b32_e64_dpp v5, v1, v2, v3 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x1b,0x00,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, v3 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0x0e,0x04,0x01,0xe4,0x00,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, v3 row_mirror
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0x0e,0x04,0x01,0x40,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, v255 row_half_mirror
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xfe,0x07,0x01,0x41,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, s105 row_shl:1
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xa6,0x01,0x01,0x01,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, vcc_hi row_shl:15
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xae,0x01,0x01,0x0f,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, vcc_lo row_shr:1
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xaa,0x01,0x01,0x11,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, ttmp15 row_shr:15
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xee,0x01,0x01,0x1f,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, exec_hi row_ror:1
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x21,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, exec_lo row_ror:15
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x2f,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, null row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x50,0x01,0xff]

v_xor3_b32_e64_dpp v5, v1, v2, -1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0x06,0x03,0x01,0x5f,0x01,0x01]

v_xor3_b32_e64_dpp v5, v1, v2, 0.5 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x40,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x09,0x13]

v_xor3_b32_e64_dpp v255, v255, v255, src_scc row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x40,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_xor_b16_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_xor_b16_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_xor_b16_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_xor_b16_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x64,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_xor_b16_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x64,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_xor_b32_e64_dpp v5, v1, v2 quad_perm:[3,2,1,0]
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1b,0x00,0xff]

v_xor_b32_e64_dpp v5, v1, v2 quad_perm:[0,1,2,3]
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0xe4,0x00,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_mirror
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x40,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_half_mirror
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x41,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_shl:1
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x01,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_shl:15
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x0f,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_shr:1
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x11,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_shr:15
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x1f,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_ror:1
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x21,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_ror:15
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x2f,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_xor_b32_e64_dpp v5, v1, v2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_xor_b32_e64_dpp v5, v1, v2 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX11: [0x05,0x00,0x1d,0xd5,0xfa,0x04,0x02,0x00,0x01,0x60,0x09,0x13]

v_xor_b32_e64_dpp v255, v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX11: [0xff,0x00,0x1d,0xd5,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_nc_i16_e64_dpp v5, v1, v2 op_sel:[1,1,1] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x58,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_i16_e64_dpp v5, v1, v2 op_sel:[1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x08,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_i16_e64_dpp v5, v1, v2 op_sel:[0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x10,0x0d,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x01,0x13]

v_add_nc_i16_e64_dpp v255, v255, v255 op_sel:[0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x0d,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_add_nc_u16_e64_dpp v5, v1, v2 op_sel:[1,1,1] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x58,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_add_nc_u16_e64_dpp v5, v1, v2 op_sel:[1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x08,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_add_nc_u16_e64_dpp v5, v1, v2 op_sel:[0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x10,0x03,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x01,0x13]

v_add_nc_u16_e64_dpp v255, v255, v255 op_sel:[0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x03,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_cvt_pk_norm_i16_f16_e64_dpp v5, -v1, |v2| op_sel:[1,0,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x0a,0x12,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x01,0x13]

v_cvt_pk_norm_i16_f16_e64_dpp v255, -|v255|, -|v255| op_sel:[0,1,0] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x13,0x12,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_cvt_pk_norm_u16_f16_e64_dpp v5, -v1, |v2| op_sel:[1,0,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x0a,0x13,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x01,0x13]

v_cvt_pk_norm_u16_f16_e64_dpp v255, -|v255|, -|v255| op_sel:[0,1,0] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x13,0x13,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_div_fixup_f16_e64_dpp v5, -v1, v2, |exec_lo| op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x7c,0x54,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, -|v1|, -|v2|, null op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x0b,0x54,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_div_fixup_f16_e64_dpp v5, -|v1|, v2, -|-1| op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x15,0x54,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_div_fixup_f16_e64_dpp v5, v1, -|v2|, -|0.5| op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x26,0x54,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x01,0x13]

v_div_fixup_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc7,0x54,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_fma_f16_e64_dpp v5, -v1, v2, |exec_lo| op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x7c,0x48,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_fma_f16_e64_dpp v5, -|v1|, -|v2|, null op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x0b,0x48,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_fma_f16_e64_dpp v5, -|v1|, v2, -|-1| op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x15,0x48,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_fma_f16_e64_dpp v5, v1, -|v2|, -|0.5| op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x26,0x48,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x01,0x13]

v_fma_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc7,0x48,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_mad_i16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x53,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x53,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_mad_i16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x53,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_mad_i16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x53,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_mad_i16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x53,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_i32_i16_e64_dpp v5, v1, v2, 0.5 op_sel:[1,0,0,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x08,0x5a,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x01,0x13]

v_mad_i32_i16_e64_dpp v255, v255, v255, src_scc op_sel:[0,1,0,0] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x90,0x5a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_u16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x41,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x41,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_mad_u16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x41,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_mad_u16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x41,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_mad_u16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x41,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_mad_u32_u16_e64_dpp v5, v1, v2, 0.5 op_sel:[1,0,0,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x08,0x59,0xd6,0xfa,0x04,0xc2,0x03,0x01,0x60,0x01,0x13]

v_mad_u32_u16_e64_dpp v255, v255, v255, src_scc op_sel:[0,1,0,0] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x90,0x59,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_f16_e64_dpp v5, -v1, v2, |exec_lo| op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x7c,0x4c,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_max3_f16_e64_dpp v5, -|v1|, -|v2|, null op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x0b,0x4c,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_max3_f16_e64_dpp v5, -|v1|, v2, -|-1| op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x15,0x4c,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_max3_f16_e64_dpp v5, v1, -|v2|, -|0.5| op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x26,0x4c,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x01,0x13]

v_max3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc7,0x4c,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_max3_i16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x4d,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x4d,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_max3_i16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x4d,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_max3_i16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x4d,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_max3_i16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x4d,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_max3_u16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x4e,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x4e,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_max3_u16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x4e,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_max3_u16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x4e,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_max3_u16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x4e,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_med3_f16_e64_dpp v5, -v1, v2, |exec_lo| op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x7c,0x4f,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_med3_f16_e64_dpp v5, -|v1|, -|v2|, null op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x0b,0x4f,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_med3_f16_e64_dpp v5, -|v1|, v2, -|-1| op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x15,0x4f,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_med3_f16_e64_dpp v5, v1, -|v2|, -|0.5| op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x26,0x4f,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x01,0x13]

v_med3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc7,0x4f,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_med3_i16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x50,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x50,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_med3_i16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x50,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_med3_i16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x50,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_med3_i16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x50,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_med3_u16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x51,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x51,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_med3_u16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x51,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_med3_u16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x51,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_med3_u16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x51,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_f16_e64_dpp v5, -v1, v2, |exec_lo| op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x7c,0x49,0xd6,0xfa,0x04,0xfa,0x21,0x01,0x2f,0x01,0xff]

v_min3_f16_e64_dpp v5, -|v1|, -|v2|, null op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x0b,0x49,0xd6,0xfa,0x04,0xf2,0x61,0x01,0x50,0x01,0xff]

v_min3_f16_e64_dpp v5, -|v1|, v2, -|-1| op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x15,0x49,0xd6,0xfa,0x04,0x06,0xa3,0x01,0x5f,0x01,0x01]

v_min3_f16_e64_dpp v5, v1, -|v2|, -|0.5| op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x26,0x49,0xd6,0xfa,0x04,0xc2,0xc3,0x01,0x60,0x01,0x13]

v_min3_f16_e64_dpp v255, -|v255|, -|v255|, -|src_scc| op_sel:[0,0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc7,0x49,0xd6,0xfa,0xfe,0xf7,0xe3,0xff,0x6f,0x0d,0x30]

v_min3_i16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x4a,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x4a,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_min3_i16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x4a,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_min3_i16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x4a,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_min3_i16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x4a,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_min3_u16_e64_dpp v5, v1, v2, exec_hi op_sel:[1,1,1,1] row_ror:15 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x78,0x4b,0xd6,0xfa,0x04,0xfe,0x01,0x01,0x2f,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, exec_lo op_sel:[1,0,0,0] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x08,0x4b,0xd6,0xfa,0x04,0xfa,0x01,0x01,0x50,0x01,0xff]

v_min3_u16_e64_dpp v5, v1, v2, null op_sel:[0,1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x10,0x4b,0xd6,0xfa,0x04,0xf2,0x01,0x01,0x5f,0x01,0x01]

v_min3_u16_e64_dpp v5, v1, v2, -1 op_sel:[0,0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x20,0x4b,0xd6,0xfa,0x04,0x06,0x03,0x01,0x60,0x01,0x13]

v_min3_u16_e64_dpp v255, v255, v255, src_scc op_sel:[0,0,0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x40,0x4b,0xd6,0xfa,0xfe,0xf7,0x03,0xff,0x6f,0x0d,0x30]

v_pack_b32_f16_e64_dpp v5, -v1, |v2| op_sel:[1,0,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x0a,0x11,0xd7,0xfa,0x04,0x02,0x20,0x01,0x60,0x01,0x13]

v_pack_b32_f16_e64_dpp v255, -|v255|, -|v255| op_sel:[0,1,0] row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0x13,0x11,0xd7,0xfa,0xfe,0x03,0x60,0xff,0x6f,0x0d,0x30]

v_sub_nc_i16_e64_dpp v5, v1, v2 op_sel:[1,1,1] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x58,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_i16_e64_dpp v5, v1, v2 op_sel:[1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x08,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_i16_e64_dpp v5, v1, v2 op_sel:[0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x10,0x0e,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x01,0x13]

v_sub_nc_i16_e64_dpp v255, v255, v255 op_sel:[0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x0e,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]

v_sub_nc_u16_e64_dpp v5, v1, v2 op_sel:[1,1,1] row_share:0 row_mask:0xf bank_mask:0xf
// GFX11: [0x05,0x58,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x50,0x01,0xff]

v_sub_nc_u16_e64_dpp v5, v1, v2 op_sel:[1,0,0] row_share:15 row_mask:0x0 bank_mask:0x1
// GFX11: [0x05,0x08,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x5f,0x01,0x01]

v_sub_nc_u16_e64_dpp v5, v1, v2 op_sel:[0,1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3
// GFX11: [0x05,0x10,0x04,0xd7,0xfa,0x04,0x02,0x00,0x01,0x60,0x01,0x13]

v_sub_nc_u16_e64_dpp v255, v255, v255 op_sel:[0,0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:1 fi:1
// GFX11: [0xff,0xc0,0x04,0xd7,0xfa,0xfe,0x03,0x00,0xff,0x6f,0x0d,0x30]
