/*
  Copyright (c) 2013-2015 Montel Laurent <montel@kde.org>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef NOTESAGENTALARMDIALOG_H
#define NOTESAGENTALARMDIALOG_H
#include <KDialog>
#include <Akonadi/Item>
class QListWidget;
class QLabel;
class QListWidgetItem;
namespace NoteShared {
class NoteListWidget;
}
class KJob;
class NotesAgentAlarmDialog : public KDialog
{
    Q_OBJECT
public:
    explicit NotesAgentAlarmDialog(QWidget *parent=0);
    ~NotesAgentAlarmDialog();

    void addListAlarm(const Akonadi::Item::List &lstAlarm);
    void removeAlarm(const Akonadi::Item &note);

private slots:
    void slotItemDoubleClicked(QListWidgetItem *item);
    void slotCustomContextMenuRequested(const QPoint &pos);
    void slotShowNote();
    void slotRemoveAlarm();
    void slotFetchItem(KJob *job);
    void slotModifyItem(KJob *job);
    void slotModifyAlarm();
    void slotFetchAlarmItem(KJob *job);

private:
    void readConfig();
    void writeConfig();
    NoteShared::NoteListWidget *mListWidget;
    QLabel *mCurrentDateTime;
};

#endif // NOTESAGENTALARMDIALOG_H
