# Tutorials

_Tutorials_ provide step-by-step lessons to help you achieve a specific goal. They should be a good place to start learning about JupyterHub and how it works.

## Installation

This section covers how to get up-and-running with JupyterHub. It covers
some basics of the tools needed to deploy JupyterHub as well as how to get it
running on your own infrastructure.

```{toctree}
:maxdepth: 1

quickstart
installation-basics
quickstart-docker
```

## Getting Started

This section covers how to configure and customize JupyterHub for your
needs. It contains information about authentication, networking, security, and
other topics that are relevant to individuals or organizations deploying their
own JupyterHub.

```{toctree}
:maxdepth: 1

getting-started/config-basics
getting-started/networking-basics
getting-started/security-basics
getting-started/authenticators-users-basics
getting-started/services-basics
getting-started/spawners-basics
```

## Working with the JupyterHub API

JupyterHub's functionalities can be accessed using its API. In this section, we cover how to use the JupyterHub API to achieve specific goals, for example, starting servers.

```{toctree}
:maxdepth: 1

server-api
```

## Configuration

Further tutorials of configuring JupyterHub for specific tasks

```{toctree}
:maxdepth: 1

sharing
collaboration-users
```
