["timing","start",Sys.time()];;

(* ----- tactics *)

let def n d = X_CHOOSE_TAC n(MESON [] (mk_exists (n, mk_eq (n, d))));;

let notetac t tac = SUBGOAL_THEN t MP_TAC THENL
[tac;
  ALL_TAC] THEN
DISCH_THEN(fun th -> ASSUME_TAC th);;

let note t why = notetac t(ASM_MESON_TAC why);;

let choosevar n p why = note(mk_exists (n, p)) why THEN
X_CHOOSE_TAC n(UNDISCH (TAUT (mk_imp (mk_exists (n, p), mk_exists (n, p)))));;

let num_linear t = ASSUME_TAC(UNDISCH_ALL (REWRITE_RULE [IMP_CONJ] (ARITH_RULE t)));;

let int_linear t = ASSUME_TAC(UNDISCH_ALL (REWRITE_RULE [IMP_CONJ] (INT_ARITH t)));;

let real_linear t = ASSUME_TAC(UNDISCH_ALL (REWRITE_RULE [IMP_CONJ] (REAL_ARITH t)));;

let real_cancel t = ASSUME_TAC(UNDISCH_ALL (REWRITE_RULE [IMP_CONJ] (REAL_FIELD t)));;

let specialize v th = ASSUME_TAC(UNDISCH_ALL (REWRITE_RULE [IMP_CONJ] (ISPECL v th)));;

let twocases c why = note c why THEN
DISJ_CASES_TAC(UNDISCH(ITAUT(mk_imp(c,c))));;

(* ----- miscellany *)

let int_neg_as_minusnum1 = prove(`
  !i:int. i < &0 ==> ?m. i = -- &(m + 1)
  `,
  REPEAT STRIP_TAC THEN
  DISJ_CASES_TAC(SPEC `i:int` INT_IMAGE) THENL [
    ASM_MESON_TAC[
      INT_ARITH `~(&n < &0:int)`
    ];
    choosevar `n:num` `i:int = -- &n` [] THEN
    note `~(n = 0)` [INT_ARITH `~(-- &0 < &0:int)`] THEN
    choosevar `m:num` `n = SUC m` [num_CASES] THEN
    ASM_MESON_TAC[
      ARITH_RULE `SUC m = m + 1`
    ]
  ]
);;

let real_lt_ldiv = prove(`
  !x y z. &0:real < x /\ y < z * x ==> y / x < z
  `,
  REPEAT STRIP_TAC THEN
  note `&0 < inv x` [REAL_LT_INV] THEN
  note `y * inv x < (z * x) * inv x` [REAL_LT_RMUL] THEN
  real_linear `y * inv x < (z * x) * inv x ==> y / x < z * (x * inv x)` THEN
  real_linear `&0:real < x ==> ~(x = &0)` THEN
  note `x * inv x = &1` [REAL_MUL_RINV] THEN
  ASM_MESON_TAC[REAL_ARITH `z * &1:real = z`]
);;

let real_lt_rdiv_one_extra = prove(`
  !a b c:real.
  &0 < a /\ &1 <= b /\ c * (a * b) < a ==> c < &1
  `,
  REPEAT STRIP_TAC THEN
  note `&0 < inv a` [REAL_LT_INV] THEN
  note `(c * (a * b)) * inv a < a * inv a` [REAL_LT_RMUL] THEN
  real_linear `(c * (a * b)) * inv a < a * inv a ==> c * b * (a * inv a) < a * inv a` THEN
  real_linear `&0 < a ==> ~(a = &0:real)` THEN
  note `a * inv a = &1` [REAL_MUL_RINV] THEN
  real_linear `c * b * &1 = c * b:real` THEN
  note `c * b < &1:real` [] THEN
  ASM_CASES_TAC `&1 <= c:real` THENL [
    real_linear `&0 <= &1:real` THEN
    note `&1 * &1 <= c*b:real` [REAL_LE_MUL2] THEN
    real_linear `&1 * &1 <= c*b:real ==> ~(c * b < &1)`
  ;
    real_linear `~(&1 <= c:real) ==> c < &1`
  ] THEN
  ASM_MESON_TAC[]
);;

let real_lt_extra2 = prove(`
  !a b c d:real.
  a < b * c * d /\ &0 < a /\ &0 < d /\ d < &1 ==> a < b * c
  `,
  REPEAT STRIP_TAC THEN
  real_linear `&0 < d ==> ~(d = &0:real)` THEN
  note `d * inv d = &1` [REAL_MUL_RINV] THEN
  note `&0 < inv d` [REAL_LT_INV] THEN
  note `a * inv d < (b * c * d) * inv d` [REAL_LT_RMUL] THEN
  real_linear `a * inv d < (b * c * d) * inv d ==> a / d < b * c * (d * inv d)` THEN
  note `a / d < b * c * &1` [] THEN
  real_linear `b * c * &1:real = b * c` THEN
  note `a / d < b * c` [] THEN
  note `&0 < a / d` [REAL_LT_DIV] THEN
  note `d * (a / d) < &1 * (a / d)` [REAL_LT_RMUL] THEN
  real_cancel `&0 < d ==> d * (a / d) = a` THEN
  real_linear `&1 * (a / d) = a / d` THEN
  note `a < a / d` [] THEN
  ASM_MESON_TAC[REAL_LT_TRANS]
);;

(* ----- how to manipulate edge inequalities *)

let generic_1_Ppos = prove(`
  !D a b c d e f M00 M01 M10 M11 M P Q x y:real.
  &0 < D ==>
  &0 <= M ==>
  &0 < P ==>
  &0 < Q ==>
  M*a*D = Q*(d*M00+e*M10) ==>
  M*b*D = Q*(d*M01+e*M11) ==>
  M*c+P = Q*f ==>
  a*x+b*y <= c ==>
  d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D <= f
  `,
  REPEAT STRIP_TAC THEN
  real_cancel `&0:real < D ==> (M*a*D)/D = M*a` THEN
  real_cancel `&0:real < D ==> (M*b*D)/D = M*b` THEN
  note `M*a:real = (Q*(d*M00+e*M10))/D` [] THEN
  note `M*b:real = (Q*(d*M01+e*M11))/D` [] THEN
  note `M*(a*x+b*y) <= M*c:real` [REAL_LE_LMUL] THEN
  real_linear `&0 < P ==> M*c <= M*c+P` THEN
  note `M*(a*x+b*y) <= M*c+P:real` [REAL_LE_TRANS] THEN
  real_linear `M*(a*x+b*y) = (M*a)*x+(M*b)*y:real` THEN
  note `((Q*(d*M00+e*M10))/D)*x+((Q*(d*M01+e*M11))/D)*y <= Q*f:real` [] THEN
  real_cancel `&0:real < D ==> ((Q*(d*M00+e*M10))/D)*x+((Q*(d*M01+e*M11))/D)*y = Q*(d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D)` THEN
  note `Q*(d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D) <= Q*f:real` [] THEN
  ASM_MESON_TAC[REAL_LE_LMUL_EQ]
);;

let generic_1_P0 = prove(`
  !D a b c d e f M00 M01 M10 M11 M Q x y:real.
  &0 < D ==>
  &0 <= M ==>
  &0 < Q ==>
  M*a*D = Q*(d*M00+e*M10) ==>
  M*b*D = Q*(d*M01+e*M11) ==>
  M*c = Q*f ==>
  a*x+b*y <= c ==>
  d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D <= f
  `,
  REPEAT STRIP_TAC THEN
  real_cancel `&0:real < D ==> (M*a*D)/D = M*a` THEN
  real_cancel `&0:real < D ==> (M*b*D)/D = M*b` THEN
  note `M*a:real = (Q*(d*M00+e*M10))/D` [] THEN
  note `M*b:real = (Q*(d*M01+e*M11))/D` [] THEN
  note `M*(a*x+b*y) <= M*c:real` [REAL_LE_LMUL] THEN
  real_linear `M*(a*x+b*y) = (M*a)*x+(M*b)*y:real` THEN
  note `((Q*(d*M00+e*M10))/D)*x+((Q*(d*M01+e*M11))/D)*y <= Q*f:real` [] THEN
  real_cancel `&0:real < D ==> ((Q*(d*M00+e*M10))/D)*x+((Q*(d*M01+e*M11))/D)*y = Q*(d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D)` THEN
  note `Q*(d*(M00*x+M01*y)/D+e*(M10*x+M11*y)/D) <= Q*f:real` [] THEN
  ASM_MESON_TAC[REAL_LE_LMUL_EQ]
);;

let generic_2 = prove(`
  !D a b c d e f g h i M00 M01 M10 M11 M N P Q x y:real.
  &0 < D ==>
  &0 <= M ==>
  &0 <= N ==>
  &0 <= P ==>
  &0 < Q ==>
  (M*a+N*d)*D = Q*(g*M00+h*M10) ==>
  (M*b+N*e)*D = Q*(g*M01+h*M11) ==>
  M*c+N*f+P = Q*i ==>
  a*x+b*y <= c ==>
  d*x+e*y <= f ==>
  g*(M00*x+M01*y)/D+h*(M10*x+M11*y)/D <= i
  `,
  REPEAT STRIP_TAC THEN
  real_cancel `&0:real < D ==> ((M*a+N*d)*D)/D = M*a+N*d` THEN
  real_cancel `&0:real < D ==> ((M*b+N*e)*D)/D = M*b+N*e` THEN
  note `M*a+N*d:real = (Q*(g*M00+h*M10))/D` [] THEN
  note `M*b+N*e:real = (Q*(g*M01+h*M11))/D` [] THEN
  note `M*(a*x+b*y) <= M*c:real` [REAL_LE_LMUL] THEN
  note `N*(d*x+e*y) <= N*f:real` [REAL_LE_LMUL] THEN
  note `M*(a*x+b*y)+N*(d*x+e*y) <= M*c+N*f:real` [REAL_LE_ADD2] THEN
  real_linear `&0 <= P ==> M*c+N*f <= M*c+N*f+P` THEN
  note `M*(a*x+b*y)+N*(d*x+e*y) <= M*c+N*f+P:real` [REAL_LE_TRANS] THEN
  real_linear `M*(a*x+b*y)+N*(d*x+e*y) = (M*a+N*d)*x+(M*b+N*e)*y:real` THEN
  note `(M*a+N*d)*x+(M*b+N*e)*y <= M*c+N*f+P:real` [] THEN
  note `((Q*(g*M00+h*M10))/D)*x+((Q*(g*M01+h*M11))/D)*y <= Q*i:real` [] THEN
  real_cancel `&0:real < D ==> ((Q*(g*M00+h*M10))/D)*x+((Q*(g*M01+h*M11))/D)*y = Q*(g*(M00*x+M01*y)/D+h*(M10*x+M11*y)/D)` THEN
  note `Q*(g*(M00*x+M01*y)/D+h*(M10*x+M11*y)/D) <= Q*i:real` [] THEN
  ASM_MESON_TAC[REAL_LE_LMUL_EQ]
);;

["timing","topmatter",Sys.time()];;

(* ----- s *)

let divsteps_s_definition = new_definition `
  divsteps_s = &30902639 / &41749730
`;;

let divsteps_s = prove(`
  divsteps_s = &30902639 / &41749730 /\
  &0 < divsteps_s
`,
  REWRITE_TAC[divsteps_s_definition] THEN
  REAL_ARITH_TAC
);;

(* one piece copied from Library/analysis.ml *)
let REAL_LE_RDIV = prove(
  `!x y z. &0 < x /\ (y * x) <= z ==> y <= (z / x)`,
  REPEAT GEN_TAC THEN DISCH_THEN(CONJUNCTS_THEN2 ASSUME_TAC MP_TAC) THEN
  MATCH_MP_TAC EQ_IMP THEN
  SUBGOAL_THEN `z = (z / x) * x` MP_TAC THENL
   [CONV_TAC SYM_CONV THEN MATCH_MP_TAC REAL_DIV_RMUL THEN
    CONV_TAC(RAND_CONV SYM_CONV) THEN
    MATCH_MP_TAC REAL_LT_IMP_NE THEN POP_ASSUM ACCEPT_TAC;
    DISCH_THEN(fun t -> GEN_REWRITE_TAC (LAND_CONV o RAND_CONV) [t])
    THEN MATCH_MP_TAC REAL_LE_RMUL_EQ THEN POP_ASSUM ACCEPT_TAC]);;

["timing","qsbasics",Sys.time()];;

["timing","proveinterval",Sys.time()];;

["timing","positive",Sys.time()];;

(* ----- initial hulls *)

let divsteps_hinit_0_1 = new_definition `
  divsteps_hinit_0_1 (x:real) (y:real) <=>
  (&0)*(x)+(-- &1)*(y) <= &0 /\
  (&1)*(x)+(&0)*(y) <= &1 /\
  (-- &1)*(x)+(&1)*(y) <= &0
`;;

["timing","initialhulls",Sys.time()];;

(* ----- stable hull *)

let divsteps_H0 = new_definition `
  divsteps_H0 (x:real) (y:real) <=>
  (-- &413007872)*(x)+(-- &32178176)*(y) <= &275907781 /\
  (-- &32309248)*(x)+(-- &6881280)*(y) <= &21583161 /\
  (-- &137199616)*(x)+(-- &37961728)*(y) <= &91847345 /\
  (-- &27099136)*(x)+(-- &7733248)*(y) <= &18176645 /\
  (-- &68321280)*(x)+(-- &23134208)*(y) <= &46464197 /\
  (-- &26869760)*(x)+(-- &10027008)*(y) <= &18466107 /\
  (-- &52412416)*(x)+(-- &19972096)*(y) <= &36108393 /\
  (-- &7979008)*(x)+(-- &3162112)*(y) <= &5552625 /\
  (-- &121733120)*(x)+(-- &53051392)*(y) <= &86950107 /\
  (-- &124731392)*(x)+(-- &66289664)*(y) <= &95315653 /\
  (-- &165806080)*(x)+(-- &105447424)*(y) <= &137755571 /\
  (-- &22740992)*(x)+(-- &15466496)*(y) <= &19572823 /\
  (-- &3604480)*(x)+(-- &2555904)*(y) <= &3177943 /\
  (-- &5537792)*(x)+(-- &5177344)*(y) <= &5799491 /\
  (-- &289406976)*(x)+(-- &340459520)*(y) <= &355053887 /\
  (-- &2048000)*(x)+(-- &2605056)*(y) <= &2671329 /\
  (-- &26116096)*(x)+(-- &42532864)*(y) <= &41635449 /\
  (-- &66748416)*(x)+(-- &154992640)*(y) <= &144601685 /\
  (-- &3899392)*(x)+(-- &17530880)*(y) <= &15704445 /\
  (-- &65536)*(x)+(-- &91619328)*(y) <= &79611463 /\
  (&9371648)*(x)+(-- &118292480)*(y) <= &101844089 /\
  (&753664)*(x)+(-- &5898240)*(y) <= &5057377 /\
  (&129499136)*(x)+(-- &923729920)*(y) <= &791274703 /\
  (&1130496)*(x)+(-- &7061504)*(y) <= &6069771 /\
  (&481280)*(x)+(-- &1114112)*(y) <= &1004531 /\
  (&44220416)*(x)+(-- &66781184)*(y) <= &62719715 /\
  (&75169792)*(x)+(-- &86212608)*(y) <= &85043005 /\
  (&113278976)*(x)+(-- &111640576)*(y) <= &116276001 /\
  (&11419648)*(x)+(-- &10895360)*(y) <= &11507295 /\
  (&4050944)*(x)+(-- &3178496)*(y) <= &3679349 /\
  (&13631488)*(x)+(-- &9502720)*(y) <= &11699263 /\
  (&540934144)*(x)+(-- &365101056)*(y) <= &457442411 /\
  (&8454144)*(x)+(-- &5439488)*(y) <= &7031327 /\
  (&34471936)*(x)+(-- &19202048)*(y) <= &27364823 /\
  (&20946944)*(x)+(-- &9748480)*(y) <= &15848215 /\
  (&24879104)*(x)+(-- &8986624)*(y) <= &18073405 /\
  (&131072)*(x)+(-- &32768)*(y) <= &92351 /\
  (&191823872)*(x)+(-- &40435712)*(y) <= &133937273 /\
  (&9568256)*(x)+(-- &1769472)*(y) <= &6651805 /\
  (&5767168)*(x)+(-- &196608)*(y) <= &3914969 /\
  (&413007872)*(x)+(&32178176)*(y) <= &275907781 /\
  (&32309248)*(x)+(&6881280)*(y) <= &21583161 /\
  (&137199616)*(x)+(&37961728)*(y) <= &91847345 /\
  (&27099136)*(x)+(&7733248)*(y) <= &18176645 /\
  (&68321280)*(x)+(&23134208)*(y) <= &46464197 /\
  (&26869760)*(x)+(&10027008)*(y) <= &18466107 /\
  (&52412416)*(x)+(&19972096)*(y) <= &36108393 /\
  (&7979008)*(x)+(&3162112)*(y) <= &5552625 /\
  (&121733120)*(x)+(&53051392)*(y) <= &86950107 /\
  (&124731392)*(x)+(&66289664)*(y) <= &95315653 /\
  (&165806080)*(x)+(&105447424)*(y) <= &137755571 /\
  (&22740992)*(x)+(&15466496)*(y) <= &19572823 /\
  (&3604480)*(x)+(&2555904)*(y) <= &3177943 /\
  (&5537792)*(x)+(&5177344)*(y) <= &5799491 /\
  (&289406976)*(x)+(&340459520)*(y) <= &355053887 /\
  (&2048000)*(x)+(&2605056)*(y) <= &2671329 /\
  (&26116096)*(x)+(&42532864)*(y) <= &41635449 /\
  (&66748416)*(x)+(&154992640)*(y) <= &144601685 /\
  (&3899392)*(x)+(&17530880)*(y) <= &15704445 /\
  (&65536)*(x)+(&91619328)*(y) <= &79611463 /\
  (-- &9371648)*(x)+(&118292480)*(y) <= &101844089 /\
  (-- &753664)*(x)+(&5898240)*(y) <= &5057377 /\
  (-- &129499136)*(x)+(&923729920)*(y) <= &791274703 /\
  (-- &1130496)*(x)+(&7061504)*(y) <= &6069771 /\
  (-- &481280)*(x)+(&1114112)*(y) <= &1004531 /\
  (-- &44220416)*(x)+(&66781184)*(y) <= &62719715 /\
  (-- &75169792)*(x)+(&86212608)*(y) <= &85043005 /\
  (-- &113278976)*(x)+(&111640576)*(y) <= &116276001 /\
  (-- &11419648)*(x)+(&10895360)*(y) <= &11507295 /\
  (-- &4050944)*(x)+(&3178496)*(y) <= &3679349 /\
  (-- &13631488)*(x)+(&9502720)*(y) <= &11699263 /\
  (-- &540934144)*(x)+(&365101056)*(y) <= &457442411 /\
  (-- &8454144)*(x)+(&5439488)*(y) <= &7031327 /\
  (-- &34471936)*(x)+(&19202048)*(y) <= &27364823 /\
  (-- &20946944)*(x)+(&9748480)*(y) <= &15848215 /\
  (-- &24879104)*(x)+(&8986624)*(y) <= &18073405 /\
  (-- &131072)*(x)+(&32768)*(y) <= &92351 /\
  (-- &191823872)*(x)+(&40435712)*(y) <= &133937273 /\
  (-- &9568256)*(x)+(&1769472)*(y) <= &6651805 /\
  (-- &5767168)*(x)+(&196608)*(y) <= &3914969
`;;

let divsteps_H1 = new_definition `
  divsteps_H1 (x:real) (y:real) <=>
  (-- &5865472)*(x)+(-- &950272)*(y) <= &6035371 /\
  (-- &439386112)*(x)+(-- &185892864)*(y) <= &480443643 /\
  (-- &49741824)*(x)+(-- &27000832)*(y) <= &57079641 /\
  (-- &33521664)*(x)+(-- &25640960)*(y) <= &41914863 /\
  (-- &1867776)*(x)+(-- &1490944)*(y) <= &2368161 /\
  (-- &7634944)*(x)+(-- &7815168)*(y) <= &10605687 /\
  (-- &950272)*(x)+(-- &1130496)*(y) <= &1407123 /\
  (-- &438239232)*(x)+(-- &539754496)*(y) <= &659132513 /\
  (-- &13041664)*(x)+(-- &17039360)*(y) <= &20256657 /\
  (-- &7733248)*(x)+(-- &11943936)*(y) <= &13225515 /\
  (-- &897024)*(x)+(-- &2035712)*(y) <= &1977153 /\
  (-- &1275904)*(x)+(-- &4450304)*(y) <= &3928715 /\
  (-- &2211840)*(x)+(-- &9404416)*(y) <= &8039969 /\
  (-- &7733248)*(x)+(-- &38076416)*(y) <= &31944087 /\
  (-- &1966080)*(x)+(-- &55902208)*(y) <= &42311631 /\
  (&11730944)*(x)+(-- &156696576)*(y) <= &110400449 /\
  (&22740992)*(x)+(-- &117506048)*(y) <= &77682557 /\
  (&166330368)*(x)+(-- &684523520)*(y) <= &441063407 /\
  (&33882112)*(x)+(-- &135659520)*(y) <= &87245513 /\
  (&50659328)*(x)+(-- &175046656)*(y) <= &111549985 /\
  (&11010048)*(x)+(-- &34930688)*(y) <= &22163375 /\
  (&145883136)*(x)+(-- &455802880)*(y) <= &288985723 /\
  (&3457024)*(x)+(-- &10452992)*(y) <= &6651805 /\
  (&58130432)*(x)+(-- &162430976)*(y) <= &104374325 /\
  (&290521088)*(x)+(-- &691929088)*(y) <= &457690221 /\
  (&14442496)*(x)+(-- &29925376)*(y) <= &20669487 /\
  (&19062784)*(x)+(-- &37560320)*(y) <= &26430931 /\
  (&15433728)*(x)+(-- &29458432)*(y) <= &21015329 /\
  (&5660672)*(x)+(-- &8896512)*(y) <= &6951751 /\
  (&373096448)*(x)+(-- &503644160)*(y) <= &426281637 /\
  (&5701632)*(x)+(-- &7340032)*(y) <= &6407825 /\
  (&46596096)*(x)+(-- &51871744)*(y) <= &49963991 /\
  (&84901888)*(x)+(-- &79036416)*(y) <= &86789633 /\
  (&134447104)*(x)+(-- &97124352)*(y) <= &131957561 /\
  (&100401152)*(x)+(-- &50266112)*(y) <= &95584823 /\
  (&64782336)*(x)+(-- &27295744)*(y) <= &61112343 /\
  (&12943360)*(x)+(-- &4784128)*(y) <= &12157023 /\
  (&1012072448)*(x)+(-- &364183552)*(y) <= &949861697 /\
  (&3866624)*(x)+(-- &1310720)*(y) <= &3642043 /\
  (&39124992)*(x)+(-- &2621440)*(y) <= &38657149 /\
  (&5865472)*(x)+(&950272)*(y) <= &6035371 /\
  (&439386112)*(x)+(&185892864)*(y) <= &480443643 /\
  (&49741824)*(x)+(&27000832)*(y) <= &57079641 /\
  (&33521664)*(x)+(&25640960)*(y) <= &41914863 /\
  (&1867776)*(x)+(&1490944)*(y) <= &2368161 /\
  (&7634944)*(x)+(&7815168)*(y) <= &10605687 /\
  (&950272)*(x)+(&1130496)*(y) <= &1407123 /\
  (&438239232)*(x)+(&539754496)*(y) <= &659132513 /\
  (&13041664)*(x)+(&17039360)*(y) <= &20256657 /\
  (&7733248)*(x)+(&11943936)*(y) <= &13225515 /\
  (&897024)*(x)+(&2035712)*(y) <= &1977153 /\
  (&1275904)*(x)+(&4450304)*(y) <= &3928715 /\
  (&2211840)*(x)+(&9404416)*(y) <= &8039969 /\
  (&7733248)*(x)+(&38076416)*(y) <= &31944087 /\
  (&1966080)*(x)+(&55902208)*(y) <= &42311631 /\
  (-- &11730944)*(x)+(&156696576)*(y) <= &110400449 /\
  (-- &22740992)*(x)+(&117506048)*(y) <= &77682557 /\
  (-- &166330368)*(x)+(&684523520)*(y) <= &441063407 /\
  (-- &33882112)*(x)+(&135659520)*(y) <= &87245513 /\
  (-- &50659328)*(x)+(&175046656)*(y) <= &111549985 /\
  (-- &11010048)*(x)+(&34930688)*(y) <= &22163375 /\
  (-- &145883136)*(x)+(&455802880)*(y) <= &288985723 /\
  (-- &3457024)*(x)+(&10452992)*(y) <= &6651805 /\
  (-- &58130432)*(x)+(&162430976)*(y) <= &104374325 /\
  (-- &290521088)*(x)+(&691929088)*(y) <= &457690221 /\
  (-- &14442496)*(x)+(&29925376)*(y) <= &20669487 /\
  (-- &19062784)*(x)+(&37560320)*(y) <= &26430931 /\
  (-- &15433728)*(x)+(&29458432)*(y) <= &21015329 /\
  (-- &5660672)*(x)+(&8896512)*(y) <= &6951751 /\
  (-- &373096448)*(x)+(&503644160)*(y) <= &426281637 /\
  (-- &5701632)*(x)+(&7340032)*(y) <= &6407825 /\
  (-- &46596096)*(x)+(&51871744)*(y) <= &49963991 /\
  (-- &84901888)*(x)+(&79036416)*(y) <= &86789633 /\
  (-- &134447104)*(x)+(&97124352)*(y) <= &131957561 /\
  (-- &100401152)*(x)+(&50266112)*(y) <= &95584823 /\
  (-- &64782336)*(x)+(&27295744)*(y) <= &61112343 /\
  (-- &12943360)*(x)+(&4784128)*(y) <= &12157023 /\
  (-- &1012072448)*(x)+(&364183552)*(y) <= &949861697 /\
  (-- &3866624)*(x)+(&1310720)*(y) <= &3642043 /\
  (-- &39124992)*(x)+(&2621440)*(y) <= &38657149
`;;

["timing","stablehull",Sys.time()];;

let init2stable = let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &3942296` in
let npos = REAL_ARITH `!s:real. &0:real < &4580992` in
let ppos = REAL_ARITH `!s:real. &0:real < &6035371` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&3942296)*(-- &1)+(&4580992)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5865472) * &2753 / &4096 + (-- &950272) * &0)) /\
  ((&3942296)*(&1)+(&4580992)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5865472) * &0 + (-- &950272) * &2753 / &4096)) /\
  (&3942296)*(&0)+(&4580992)*(&0)+(&6035371) = (&1)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &5865472) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &950272) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3942296` [mpos] THEN
  note `&0:real < &4580992` [npos] THEN
  note `&0:real < &6035371` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&3942296)*(-- &1)+(&4580992)*(&0))*s pow 0 = (&1)*((-- &5865472) * &2753 / &4096 + (-- &950272) * &0) /\ ((&3942296)*(&1)+(&4580992)*(-- &1))*s pow 0 = (&1)*((-- &5865472) * &0 + (-- &950272) * &2753 / &4096) /\ (&3942296)*(&0)+(&4580992)*(&0)+(&6035371) = (&1)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &295319816` in
let npos = REAL_ARITH `!s:real. &0:real < &420261968` in
let ppos = REAL_ARITH `!s:real. &0:real < &480443643` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&295319816)*(-- &1)+(&420261968)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &439386112) * &2753 / &4096 + (-- &185892864) * &0)) /\
  ((&295319816)*(&1)+(&420261968)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &439386112) * &0 + (-- &185892864) * &2753 / &4096)) /\
  (&295319816)*(&0)+(&420261968)*(&0)+(&480443643) = (&1)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &439386112) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &185892864) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &295319816` [mpos] THEN
  note `&0:real < &420261968` [npos] THEN
  note `&0:real < &480443643` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&295319816)*(-- &1)+(&420261968)*(&0))*s pow 0 = (&1)*((-- &439386112) * &2753 / &4096 + (-- &185892864) * &0) /\ ((&295319816)*(&1)+(&420261968)*(-- &1))*s pow 0 = (&1)*((-- &439386112) * &0 + (-- &185892864) * &2753 / &4096) /\ (&295319816)*(&0)+(&420261968)*(&0)+(&480443643) = (&1)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &33432432` in
let npos = REAL_ARITH `!s:real. &0:real < &51580208` in
let ppos = REAL_ARITH `!s:real. &0:real < &57079641` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&33432432)*(-- &1)+(&51580208)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &49741824) * &2753 / &4096 + (-- &27000832) * &0)) /\
  ((&33432432)*(&1)+(&51580208)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &49741824) * &0 + (-- &27000832) * &2753 / &4096)) /\
  (&33432432)*(&0)+(&51580208)*(&0)+(&57079641) = (&1)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &49741824) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &27000832) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &33432432` [mpos] THEN
  note `&0:real < &51580208` [npos] THEN
  note `&0:real < &57079641` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&33432432)*(-- &1)+(&51580208)*(&0))*s pow 0 = (&1)*((-- &49741824) * &2753 / &4096 + (-- &27000832) * &0) /\ ((&33432432)*(&1)+(&51580208)*(-- &1))*s pow 0 = (&1)*((-- &49741824) * &0 + (-- &27000832) * &2753 / &4096) /\ (&33432432)*(&0)+(&51580208)*(&0)+(&57079641) = (&1)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &22530552` in
let npos = REAL_ARITH `!s:real. &0:real < &39764332` in
let ppos = REAL_ARITH `!s:real. &0:real < &41914863` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&22530552)*(-- &1)+(&39764332)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &33521664) * &2753 / &4096 + (-- &25640960) * &0)) /\
  ((&22530552)*(&1)+(&39764332)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &33521664) * &0 + (-- &25640960) * &2753 / &4096)) /\
  (&22530552)*(&0)+(&39764332)*(&0)+(&41914863) = (&1)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &33521664) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &25640960) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22530552` [mpos] THEN
  note `&0:real < &39764332` [npos] THEN
  note `&0:real < &41914863` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&22530552)*(-- &1)+(&39764332)*(&0))*s pow 0 = (&1)*((-- &33521664) * &2753 / &4096 + (-- &25640960) * &0) /\ ((&22530552)*(&1)+(&39764332)*(-- &1))*s pow 0 = (&1)*((-- &33521664) * &0 + (-- &25640960) * &2753 / &4096) /\ (&22530552)*(&0)+(&39764332)*(&0)+(&41914863) = (&1)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &1255368` in
let npos = REAL_ARITH `!s:real. &0:real < &2257460` in
let ppos = REAL_ARITH `!s:real. &0:real < &2368161` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1255368)*(-- &1)+(&2257460)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1867776) * &2753 / &4096 + (-- &1490944) * &0)) /\
  ((&1255368)*(&1)+(&2257460)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1867776) * &0 + (-- &1490944) * &2753 / &4096)) /\
  (&1255368)*(&0)+(&2257460)*(&0)+(&2368161) = (&1)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &1867776) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &1490944) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1255368` [mpos] THEN
  note `&0:real < &2257460` [npos] THEN
  note `&0:real < &2368161` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1255368)*(-- &1)+(&2257460)*(&0))*s pow 0 = (&1)*((-- &1867776) * &2753 / &4096 + (-- &1490944) * &0) /\ ((&1255368)*(&1)+(&2257460)*(-- &1))*s pow 0 = (&1)*((-- &1867776) * &0 + (-- &1490944) * &2753 / &4096) /\ (&1255368)*(&0)+(&2257460)*(&0)+(&2368161) = (&1)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &5131592` in
let npos = REAL_ARITH `!s:real. &0:real < &10384316` in
let ppos = REAL_ARITH `!s:real. &0:real < &10605687` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&5131592)*(-- &1)+(&10384316)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7634944) * &2753 / &4096 + (-- &7815168) * &0)) /\
  ((&5131592)*(&1)+(&10384316)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7634944) * &0 + (-- &7815168) * &2753 / &4096)) /\
  (&5131592)*(&0)+(&10384316)*(&0)+(&10605687) = (&1)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &7634944) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &7815168) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5131592` [mpos] THEN
  note `&0:real < &10384316` [npos] THEN
  note `&0:real < &10605687` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&5131592)*(-- &1)+(&10384316)*(&0))*s pow 0 = (&1)*((-- &7634944) * &2753 / &4096 + (-- &7815168) * &0) /\ ((&5131592)*(&1)+(&10384316)*(-- &1))*s pow 0 = (&1)*((-- &7634944) * &0 + (-- &7815168) * &2753 / &4096) /\ (&5131592)*(&0)+(&10384316)*(&0)+(&10605687) = (&1)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &638696` in
let npos = REAL_ARITH `!s:real. &0:real < &1398524` in
let ppos = REAL_ARITH `!s:real. &0:real < &1407123` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&638696)*(-- &1)+(&1398524)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &950272) * &2753 / &4096 + (-- &1130496) * &0)) /\
  ((&638696)*(&1)+(&1398524)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &950272) * &0 + (-- &1130496) * &2753 / &4096)) /\
  (&638696)*(&0)+(&1398524)*(&0)+(&1407123) = (&1)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &950272) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &1130496) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &638696` [mpos] THEN
  note `&0:real < &1398524` [npos] THEN
  note `&0:real < &1407123` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&638696)*(-- &1)+(&1398524)*(&0))*s pow 0 = (&1)*((-- &950272) * &2753 / &4096 + (-- &1130496) * &0) /\ ((&638696)*(&1)+(&1398524)*(-- &1))*s pow 0 = (&1)*((-- &950272) * &0 + (-- &1130496) * &2753 / &4096) /\ (&638696)*(&0)+(&1398524)*(&0)+(&1407123) = (&1)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &294548976` in
let npos = REAL_ARITH `!s:real. &0:real < &657328304` in
let ppos = REAL_ARITH `!s:real. &0:real < &659132513` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&294548976)*(-- &1)+(&657328304)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &438239232) * &2753 / &4096 + (-- &539754496) * &0)) /\
  ((&294548976)*(&1)+(&657328304)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &438239232) * &0 + (-- &539754496) * &2753 / &4096)) /\
  (&294548976)*(&0)+(&657328304)*(&0)+(&659132513) = (&1)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &438239232) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &539754496) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &294548976` [mpos] THEN
  note `&0:real < &657328304` [npos] THEN
  note `&0:real < &659132513` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&294548976)*(-- &1)+(&657328304)*(&0))*s pow 0 = (&1)*((-- &438239232) * &2753 / &4096 + (-- &539754496) * &0) /\ ((&294548976)*(&1)+(&657328304)*(-- &1))*s pow 0 = (&1)*((-- &438239232) * &0 + (-- &539754496) * &2753 / &4096) /\ (&294548976)*(&0)+(&657328304)*(&0)+(&659132513) = (&1)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &8765552` in
let npos = REAL_ARITH `!s:real. &0:real < &20218032` in
let ppos = REAL_ARITH `!s:real. &0:real < &20256657` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&8765552)*(-- &1)+(&20218032)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &13041664) * &2753 / &4096 + (-- &17039360) * &0)) /\
  ((&8765552)*(&1)+(&20218032)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &13041664) * &0 + (-- &17039360) * &2753 / &4096)) /\
  (&8765552)*(&0)+(&20218032)*(&0)+(&20256657) = (&1)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &13041664) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &17039360) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8765552` [mpos] THEN
  note `&0:real < &20218032` [npos] THEN
  note `&0:real < &20256657` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&8765552)*(-- &1)+(&20218032)*(&0))*s pow 0 = (&1)*((-- &13041664) * &2753 / &4096 + (-- &17039360) * &0) /\ ((&8765552)*(&1)+(&20218032)*(-- &1))*s pow 0 = (&1)*((-- &13041664) * &0 + (-- &17039360) * &2753 / &4096) /\ (&8765552)*(&0)+(&20218032)*(&0)+(&20256657) = (&1)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &5197664` in
let npos = REAL_ARITH `!s:real. &0:real < &13225412` in
let ppos = REAL_ARITH `!s:real. &0:real < &13225515` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&5197664)*(-- &1)+(&13225412)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7733248) * &2753 / &4096 + (-- &11943936) * &0)) /\
  ((&5197664)*(&1)+(&13225412)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7733248) * &0 + (-- &11943936) * &2753 / &4096)) /\
  (&5197664)*(&0)+(&13225412)*(&0)+(&13225515) = (&1)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &7733248) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &11943936) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5197664` [mpos] THEN
  note `&0:real < &13225412` [npos] THEN
  note `&0:real < &13225515` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&5197664)*(-- &1)+(&13225412)*(&0))*s pow 0 = (&1)*((-- &7733248) * &2753 / &4096 + (-- &11943936) * &0) /\ ((&5197664)*(&1)+(&13225412)*(-- &1))*s pow 0 = (&1)*((-- &7733248) * &0 + (-- &11943936) * &2753 / &4096) /\ (&5197664)*(&0)+(&13225412)*(&0)+(&13225515) = (&1)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &602907` in
let npos = REAL_ARITH `!s:real. &0:real < &1971148` in
let ppos = REAL_ARITH `!s:real. &0:real < &1977153` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&602907)*(-- &1)+(&1971148)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &897024) * &2753 / &4096 + (-- &2035712) * &0)) /\
  ((&602907)*(&1)+(&1971148)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &897024) * &0 + (-- &2035712) * &2753 / &4096)) /\
  (&602907)*(&0)+(&1971148)*(&0)+(&1977153) = (&1)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &897024) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &2035712) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &602907` [mpos] THEN
  note `&0:real < &1971148` [npos] THEN
  note `&0:real < &1977153` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&602907)*(-- &1)+(&1971148)*(&0))*s pow 0 = (&1)*((-- &897024) * &2753 / &4096 + (-- &2035712) * &0) /\ ((&602907)*(&1)+(&1971148)*(-- &1))*s pow 0 = (&1)*((-- &897024) * &0 + (-- &2035712) * &2753 / &4096) /\ (&602907)*(&0)+(&1971148)*(&0)+(&1977153) = (&1)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &1715119` in
let npos = REAL_ARITH `!s:real. &0:real < &7697388` in
let ppos = REAL_ARITH `!s:real. &0:real < &7857430` in
let qpos = REAL_ARITH `!s:real. &0:real < &2` in
let mqrel = REAL_ARITH `
  ((&1715119)*(-- &1)+(&7697388)*(&0))*(&30902639 / &41749730) pow 0 = (&2)*(((-- &1275904) * &2753 / &4096 + (-- &4450304) * &0)) /\
  ((&1715119)*(&1)+(&7697388)*(-- &1))*(&30902639 / &41749730) pow 0 = (&2)*(((-- &1275904) * &0 + (-- &4450304) * &2753 / &4096)) /\
  (&1715119)*(&0)+(&7697388)*(&0)+(&7857430) = (&2)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &1275904) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &4450304) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1715119` [mpos] THEN
  note `&0:real < &7697388` [npos] THEN
  note `&0:real < &7857430` [ppos] THEN
  note `&0:real < &2` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1715119)*(-- &1)+(&7697388)*(&0))*s pow 0 = (&2)*((-- &1275904) * &2753 / &4096 + (-- &4450304) * &0) /\ ((&1715119)*(&1)+(&7697388)*(-- &1))*s pow 0 = (&2)*((-- &1275904) * &0 + (-- &4450304) * &2753 / &4096) /\ (&1715119)*(&0)+(&7697388)*(&0)+(&7857430) = (&2)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &1486620` in
let npos = REAL_ARITH `!s:real. &0:real < &7807508` in
let ppos = REAL_ARITH `!s:real. &0:real < &8039969` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1486620)*(-- &1)+(&7807508)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &2211840) * &2753 / &4096 + (-- &9404416) * &0)) /\
  ((&1486620)*(&1)+(&7807508)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &2211840) * &0 + (-- &9404416) * &2753 / &4096)) /\
  (&1486620)*(&0)+(&7807508)*(&0)+(&8039969) = (&1)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &2211840) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &9404416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1486620` [mpos] THEN
  note `&0:real < &7807508` [npos] THEN
  note `&0:real < &8039969` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1486620)*(-- &1)+(&7807508)*(&0))*s pow 0 = (&1)*((-- &2211840) * &2753 / &4096 + (-- &9404416) * &0) /\ ((&1486620)*(&1)+(&7807508)*(-- &1))*s pow 0 = (&1)*((-- &2211840) * &0 + (-- &9404416) * &2753 / &4096) /\ (&1486620)*(&0)+(&7807508)*(&0)+(&8039969) = (&1)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &5197664` in
let npos = REAL_ARITH `!s:real. &0:real < &30789552` in
let ppos = REAL_ARITH `!s:real. &0:real < &31944087` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&5197664)*(-- &1)+(&30789552)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7733248) * &2753 / &4096 + (-- &38076416) * &0)) /\
  ((&5197664)*(&1)+(&30789552)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &7733248) * &0 + (-- &38076416) * &2753 / &4096)) /\
  (&5197664)*(&0)+(&30789552)*(&0)+(&31944087) = (&1)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &7733248) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &38076416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5197664` [mpos] THEN
  note `&0:real < &30789552` [npos] THEN
  note `&0:real < &31944087` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&5197664)*(-- &1)+(&30789552)*(&0))*s pow 0 = (&1)*((-- &7733248) * &2753 / &4096 + (-- &38076416) * &0) /\ ((&5197664)*(&1)+(&30789552)*(-- &1))*s pow 0 = (&1)*((-- &7733248) * &0 + (-- &38076416) * &2753 / &4096) /\ (&5197664)*(&0)+(&30789552)*(&0)+(&31944087) = (&1)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &1321440` in
let npos = REAL_ARITH `!s:real. &0:real < &38894384` in
let ppos = REAL_ARITH `!s:real. &0:real < &42311631` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1321440)*(-- &1)+(&38894384)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1966080) * &2753 / &4096 + (-- &55902208) * &0)) /\
  ((&1321440)*(&1)+(&38894384)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1966080) * &0 + (-- &55902208) * &2753 / &4096)) /\
  (&1321440)*(&0)+(&38894384)*(&0)+(&42311631) = (&1)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &1966080) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &55902208) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1321440` [mpos] THEN
  note `&0:real < &38894384` [npos] THEN
  note `&0:real < &42311631` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1321440)*(-- &1)+(&38894384)*(&0))*s pow 0 = (&1)*((-- &1966080) * &2753 / &4096 + (-- &55902208) * &0) /\ ((&1321440)*(&1)+(&38894384)*(-- &1))*s pow 0 = (&1)*((-- &1966080) * &0 + (-- &55902208) * &2753 / &4096) /\ (&1321440)*(&0)+(&38894384)*(&0)+(&42311631) = (&1)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &105318768` in
let npos = REAL_ARITH `!s:real. &0:real < &7884592` in
let ppos = REAL_ARITH `!s:real. &0:real < &102515857` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&105318768)*(&0)+(&7884592)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&11730944) * &2753 / &4096 + (-- &156696576) * &0)) /\
  ((&105318768)*(-- &1)+(&7884592)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&11730944) * &0 + (-- &156696576) * &2753 / &4096)) /\
  (&105318768)*(&0)+(&7884592)*(&1)+(&102515857) = (&1)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&11730944) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &156696576) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &105318768` [mpos] THEN
  note `&0:real < &7884592` [npos] THEN
  note `&0:real < &102515857` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&105318768)*(&0)+(&7884592)*(&1))*s pow 0 = (&1)*((&11730944) * &2753 / &4096 + (-- &156696576) * &0) /\ ((&105318768)*(-- &1)+(&7884592)*(&0))*s pow 0 = (&1)*((&11730944) * &0 + (-- &156696576) * &2753 / &4096) /\ (&105318768)*(&0)+(&7884592)*(&1)+(&102515857) = (&1)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &78978064` in
let npos = REAL_ARITH `!s:real. &0:real < &15284656` in
let ppos = REAL_ARITH `!s:real. &0:real < &62397901` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&78978064)*(&0)+(&15284656)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&22740992) * &2753 / &4096 + (-- &117506048) * &0)) /\
  ((&78978064)*(-- &1)+(&15284656)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&22740992) * &0 + (-- &117506048) * &2753 / &4096)) /\
  (&78978064)*(&0)+(&15284656)*(&1)+(&62397901) = (&1)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&22740992) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &117506048) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &78978064` [mpos] THEN
  note `&0:real < &15284656` [npos] THEN
  note `&0:real < &62397901` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&78978064)*(&0)+(&15284656)*(&1))*s pow 0 = (&1)*((&22740992) * &2753 / &4096 + (-- &117506048) * &0) /\ ((&78978064)*(-- &1)+(&15284656)*(&0))*s pow 0 = (&1)*((&22740992) * &0 + (-- &117506048) * &2753 / &4096) /\ (&78978064)*(&0)+(&15284656)*(&1)+(&62397901) = (&1)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &460081360` in
let npos = REAL_ARITH `!s:real. &0:real < &111793824` in
let ppos = REAL_ARITH `!s:real. &0:real < &329269583` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&460081360)*(&0)+(&111793824)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&166330368) * &2753 / &4096 + (-- &684523520) * &0)) /\
  ((&460081360)*(-- &1)+(&111793824)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&166330368) * &0 + (-- &684523520) * &2753 / &4096)) /\
  (&460081360)*(&0)+(&111793824)*(&1)+(&329269583) = (&1)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&166330368) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &684523520) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &460081360` [mpos] THEN
  note `&0:real < &111793824` [npos] THEN
  note `&0:real < &329269583` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&460081360)*(&0)+(&111793824)*(&1))*s pow 0 = (&1)*((&166330368) * &2753 / &4096 + (-- &684523520) * &0) /\ ((&460081360)*(-- &1)+(&111793824)*(&0))*s pow 0 = (&1)*((&166330368) * &0 + (-- &684523520) * &2753 / &4096) /\ (&460081360)*(&0)+(&111793824)*(&1)+(&329269583) = (&1)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &91179360` in
let npos = REAL_ARITH `!s:real. &0:real < &22772816` in
let ppos = REAL_ARITH `!s:real. &0:real < &64472697` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&91179360)*(&0)+(&22772816)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&33882112) * &2753 / &4096 + (-- &135659520) * &0)) /\
  ((&91179360)*(-- &1)+(&22772816)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&33882112) * &0 + (-- &135659520) * &2753 / &4096)) /\
  (&91179360)*(&0)+(&22772816)*(&1)+(&64472697) = (&1)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&33882112) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &135659520) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &91179360` [mpos] THEN
  note `&0:real < &22772816` [npos] THEN
  note `&0:real < &64472697` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&91179360)*(&0)+(&22772816)*(&1))*s pow 0 = (&1)*((&33882112) * &2753 / &4096 + (-- &135659520) * &0) /\ ((&91179360)*(-- &1)+(&22772816)*(&0))*s pow 0 = (&1)*((&33882112) * &0 + (-- &135659520) * &2753 / &4096) /\ (&91179360)*(&0)+(&22772816)*(&1)+(&64472697) = (&1)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &117652208` in
let npos = REAL_ARITH `!s:real. &0:real < &34049104` in
let ppos = REAL_ARITH `!s:real. &0:real < &77500881` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&117652208)*(&0)+(&34049104)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&50659328) * &2753 / &4096 + (-- &175046656) * &0)) /\
  ((&117652208)*(-- &1)+(&34049104)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&50659328) * &0 + (-- &175046656) * &2753 / &4096)) /\
  (&117652208)*(&0)+(&34049104)*(&1)+(&77500881) = (&1)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&50659328) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &175046656) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &117652208` [mpos] THEN
  note `&0:real < &34049104` [npos] THEN
  note `&0:real < &77500881` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&117652208)*(&0)+(&34049104)*(&1))*s pow 0 = (&1)*((&50659328) * &2753 / &4096 + (-- &175046656) * &0) /\ ((&117652208)*(-- &1)+(&34049104)*(&0))*s pow 0 = (&1)*((&50659328) * &0 + (-- &175046656) * &2753 / &4096) /\ (&117652208)*(&0)+(&34049104)*(&1)+(&77500881) = (&1)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &23477584` in
let npos = REAL_ARITH `!s:real. &0:real < &7400064` in
let ppos = REAL_ARITH `!s:real. &0:real < &14763311` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&23477584)*(&0)+(&7400064)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&11010048) * &2753 / &4096 + (-- &34930688) * &0)) /\
  ((&23477584)*(-- &1)+(&7400064)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&11010048) * &0 + (-- &34930688) * &2753 / &4096)) /\
  (&23477584)*(&0)+(&7400064)*(&1)+(&14763311) = (&1)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&11010048) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &34930688) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &23477584` [mpos] THEN
  note `&0:real < &7400064` [npos] THEN
  note `&0:real < &14763311` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&23477584)*(&0)+(&7400064)*(&1))*s pow 0 = (&1)*((&11010048) * &2753 / &4096 + (-- &34930688) * &0) /\ ((&23477584)*(-- &1)+(&7400064)*(&0))*s pow 0 = (&1)*((&11010048) * &0 + (-- &34930688) * &2753 / &4096) /\ (&23477584)*(&0)+(&7400064)*(&1)+(&14763311) = (&1)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &306353840` in
let npos = REAL_ARITH `!s:real. &0:real < &98050848` in
let ppos = REAL_ARITH `!s:real. &0:real < &190934875` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&306353840)*(&0)+(&98050848)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&145883136) * &2753 / &4096 + (-- &455802880) * &0)) /\
  ((&306353840)*(-- &1)+(&98050848)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&145883136) * &0 + (-- &455802880) * &2753 / &4096)) /\
  (&306353840)*(&0)+(&98050848)*(&1)+(&190934875) = (&1)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&145883136) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &455802880) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &306353840` [mpos] THEN
  note `&0:real < &98050848` [npos] THEN
  note `&0:real < &190934875` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&306353840)*(&0)+(&98050848)*(&1))*s pow 0 = (&1)*((&145883136) * &2753 / &4096 + (-- &455802880) * &0) /\ ((&306353840)*(-- &1)+(&98050848)*(&0))*s pow 0 = (&1)*((&145883136) * &0 + (-- &455802880) * &2753 / &4096) /\ (&306353840)*(&0)+(&98050848)*(&1)+(&190934875) = (&1)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &7025656` in
let npos = REAL_ARITH `!s:real. &0:real < &2323532` in
let ppos = REAL_ARITH `!s:real. &0:real < &4328273` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&7025656)*(&0)+(&2323532)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&3457024) * &2753 / &4096 + (-- &10452992) * &0)) /\
  ((&7025656)*(-- &1)+(&2323532)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&3457024) * &0 + (-- &10452992) * &2753 / &4096)) /\
  (&7025656)*(&0)+(&2323532)*(&1)+(&4328273) = (&1)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&3457024) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &10452992) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7025656` [mpos] THEN
  note `&0:real < &2323532` [npos] THEN
  note `&0:real < &4328273` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&7025656)*(&0)+(&2323532)*(&1))*s pow 0 = (&1)*((&3457024) * &2753 / &4096 + (-- &10452992) * &0) /\ ((&7025656)*(-- &1)+(&2323532)*(&0))*s pow 0 = (&1)*((&3457024) * &0 + (-- &10452992) * &2753 / &4096) /\ (&7025656)*(&0)+(&2323532)*(&1)+(&4328273) = (&1)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &109172968` in
let npos = REAL_ARITH `!s:real. &0:real < &39070576` in
let ppos = REAL_ARITH `!s:real. &0:real < &65303749` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&109172968)*(&0)+(&39070576)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&58130432) * &2753 / &4096 + (-- &162430976) * &0)) /\
  ((&109172968)*(-- &1)+(&39070576)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&58130432) * &0 + (-- &162430976) * &2753 / &4096)) /\
  (&109172968)*(&0)+(&39070576)*(&1)+(&65303749) = (&1)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&58130432) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &162430976) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &109172968` [mpos] THEN
  note `&0:real < &39070576` [npos] THEN
  note `&0:real < &65303749` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&109172968)*(&0)+(&39070576)*(&1))*s pow 0 = (&1)*((&58130432) * &2753 / &4096 + (-- &162430976) * &0) /\ ((&109172968)*(-- &1)+(&39070576)*(&0))*s pow 0 = (&1)*((&58130432) * &0 + (-- &162430976) * &2753 / &4096) /\ (&109172968)*(&0)+(&39070576)*(&1)+(&65303749) = (&1)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &465058784` in
let npos = REAL_ARITH `!s:real. &0:real < &195264784` in
let ppos = REAL_ARITH `!s:real. &0:real < &262425437` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&465058784)*(&0)+(&195264784)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&290521088) * &2753 / &4096 + (-- &691929088) * &0)) /\
  ((&465058784)*(-- &1)+(&195264784)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&290521088) * &0 + (-- &691929088) * &2753 / &4096)) /\
  (&465058784)*(&0)+(&195264784)*(&1)+(&262425437) = (&1)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&290521088) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &691929088) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &465058784` [mpos] THEN
  note `&0:real < &195264784` [npos] THEN
  note `&0:real < &262425437` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&465058784)*(&0)+(&195264784)*(&1))*s pow 0 = (&1)*((&290521088) * &2753 / &4096 + (-- &691929088) * &0) /\ ((&465058784)*(-- &1)+(&195264784)*(&0))*s pow 0 = (&1)*((&290521088) * &0 + (-- &691929088) * &2753 / &4096) /\ (&465058784)*(&0)+(&195264784)*(&1)+(&262425437) = (&1)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &20113418` in
let npos = REAL_ARITH `!s:real. &0:real < &9707078` in
let ppos = REAL_ARITH `!s:real. &0:real < &10962409` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&20113418)*(&0)+(&9707078)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&14442496) * &2753 / &4096 + (-- &29925376) * &0)) /\
  ((&20113418)*(-- &1)+(&9707078)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&14442496) * &0 + (-- &29925376) * &2753 / &4096)) /\
  (&20113418)*(&0)+(&9707078)*(&1)+(&10962409) = (&1)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&14442496) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &29925376) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20113418` [mpos] THEN
  note `&0:real < &9707078` [npos] THEN
  note `&0:real < &10962409` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&20113418)*(&0)+(&9707078)*(&1))*s pow 0 = (&1)*((&14442496) * &2753 / &4096 + (-- &29925376) * &0) /\ ((&20113418)*(-- &1)+(&9707078)*(&0))*s pow 0 = (&1)*((&14442496) * &0 + (-- &29925376) * &2753 / &4096) /\ (&20113418)*(&0)+(&9707078)*(&1)+(&10962409) = (&1)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &25245010` in
let npos = REAL_ARITH `!s:real. &0:real < &12812462` in
let ppos = REAL_ARITH `!s:real. &0:real < &13618469` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&25245010)*(&0)+(&12812462)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&19062784) * &2753 / &4096 + (-- &37560320) * &0)) /\
  ((&25245010)*(-- &1)+(&12812462)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&19062784) * &0 + (-- &37560320) * &2753 / &4096)) /\
  (&25245010)*(&0)+(&12812462)*(&1)+(&13618469) = (&1)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&19062784) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &37560320) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &25245010` [mpos] THEN
  note `&0:real < &12812462` [npos] THEN
  note `&0:real < &13618469` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&25245010)*(&0)+(&12812462)*(&1))*s pow 0 = (&1)*((&19062784) * &2753 / &4096 + (-- &37560320) * &0) /\ ((&25245010)*(-- &1)+(&12812462)*(&0))*s pow 0 = (&1)*((&19062784) * &0 + (-- &37560320) * &2753 / &4096) /\ (&25245010)*(&0)+(&12812462)*(&1)+(&13618469) = (&1)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &19799576` in
let npos = REAL_ARITH `!s:real. &0:real < &10373304` in
let ppos = REAL_ARITH `!s:real. &0:real < &10642025` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&19799576)*(&0)+(&10373304)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&15433728) * &2753 / &4096 + (-- &29458432) * &0)) /\
  ((&19799576)*(-- &1)+(&10373304)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&15433728) * &0 + (-- &29458432) * &2753 / &4096)) /\
  (&19799576)*(&0)+(&10373304)*(&1)+(&10642025) = (&1)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&15433728) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &29458432) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &19799576` [mpos] THEN
  note `&0:real < &10373304` [npos] THEN
  note `&0:real < &10642025` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&19799576)*(&0)+(&10373304)*(&1))*s pow 0 = (&1)*((&15433728) * &2753 / &4096 + (-- &29458432) * &0) /\ ((&19799576)*(-- &1)+(&10373304)*(&0))*s pow 0 = (&1)*((&15433728) * &0 + (-- &29458432) * &2753 / &4096) /\ (&19799576)*(&0)+(&10373304)*(&1)+(&10642025) = (&1)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &5979516` in
let npos = REAL_ARITH `!s:real. &0:real < &3804646` in
let ppos = REAL_ARITH `!s:real. &0:real < &3147105` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&5979516)*(&0)+(&3804646)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&5660672) * &2753 / &4096 + (-- &8896512) * &0)) /\
  ((&5979516)*(-- &1)+(&3804646)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&5660672) * &0 + (-- &8896512) * &2753 / &4096)) /\
  (&5979516)*(&0)+(&3804646)*(&1)+(&3147105) = (&1)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&5660672) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &8896512) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5979516` [mpos] THEN
  note `&0:real < &3804646` [npos] THEN
  note `&0:real < &3147105` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&5979516)*(&0)+(&3804646)*(&1))*s pow 0 = (&1)*((&5660672) * &2753 / &4096 + (-- &8896512) * &0) /\ ((&5979516)*(-- &1)+(&3804646)*(&0))*s pow 0 = (&1)*((&5660672) * &0 + (-- &8896512) * &2753 / &4096) /\ (&5979516)*(&0)+(&3804646)*(&1)+(&3147105) = (&1)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &338508880` in
let npos = REAL_ARITH `!s:real. &0:real < &250765264` in
let ppos = REAL_ARITH `!s:real. &0:real < &175516373` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&338508880)*(&0)+(&250765264)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&373096448) * &2753 / &4096 + (-- &503644160) * &0)) /\
  ((&338508880)*(-- &1)+(&250765264)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&373096448) * &0 + (-- &503644160) * &2753 / &4096)) /\
  (&338508880)*(&0)+(&250765264)*(&1)+(&175516373) = (&1)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&373096448) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &503644160) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &338508880` [mpos] THEN
  note `&0:real < &250765264` [npos] THEN
  note `&0:real < &175516373` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&338508880)*(&0)+(&250765264)*(&1))*s pow 0 = (&1)*((&373096448) * &2753 / &4096 + (-- &503644160) * &0) /\ ((&338508880)*(-- &1)+(&250765264)*(&0))*s pow 0 = (&1)*((&373096448) * &0 + (-- &503644160) * &2753 / &4096) /\ (&338508880)*(&0)+(&250765264)*(&1)+(&175516373) = (&1)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &4933376` in
let npos = REAL_ARITH `!s:real. &0:real < &3832176` in
let ppos = REAL_ARITH `!s:real. &0:real < &2575649` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&4933376)*(&0)+(&3832176)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&5701632) * &2753 / &4096 + (-- &7340032) * &0)) /\
  ((&4933376)*(-- &1)+(&3832176)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&5701632) * &0 + (-- &7340032) * &2753 / &4096)) /\
  (&4933376)*(&0)+(&3832176)*(&1)+(&2575649) = (&1)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&5701632) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &7340032) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4933376` [mpos] THEN
  note `&0:real < &3832176` [npos] THEN
  note `&0:real < &2575649` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&4933376)*(&0)+(&3832176)*(&1))*s pow 0 = (&1)*((&5701632) * &2753 / &4096 + (-- &7340032) * &0) /\ ((&4933376)*(-- &1)+(&3832176)*(&0))*s pow 0 = (&1)*((&5701632) * &0 + (-- &7340032) * &2753 / &4096) /\ (&4933376)*(&0)+(&3832176)*(&1)+(&2575649) = (&1)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &34863992` in
let npos = REAL_ARITH `!s:real. &0:real < &31318128` in
let ppos = REAL_ARITH `!s:real. &0:real < &18645863` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&34863992)*(&0)+(&31318128)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&46596096) * &2753 / &4096 + (-- &51871744) * &0)) /\
  ((&34863992)*(-- &1)+(&31318128)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&46596096) * &0 + (-- &51871744) * &2753 / &4096)) /\
  (&34863992)*(&0)+(&31318128)*(&1)+(&18645863) = (&1)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&46596096) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &51871744) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &34863992` [mpos] THEN
  note `&0:real < &31318128` [npos] THEN
  note `&0:real < &18645863` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&34863992)*(&0)+(&31318128)*(&1))*s pow 0 = (&1)*((&46596096) * &2753 / &4096 + (-- &51871744) * &0) /\ ((&34863992)*(-- &1)+(&31318128)*(&0))*s pow 0 = (&1)*((&46596096) * &0 + (-- &51871744) * &2753 / &4096) /\ (&34863992)*(&0)+(&31318128)*(&1)+(&18645863) = (&1)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &53121888` in
let npos = REAL_ARITH `!s:real. &0:real < &57064184` in
let ppos = REAL_ARITH `!s:real. &0:real < &29725449` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&53121888)*(&0)+(&57064184)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&84901888) * &2753 / &4096 + (-- &79036416) * &0)) /\
  ((&53121888)*(-- &1)+(&57064184)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&84901888) * &0 + (-- &79036416) * &2753 / &4096)) /\
  (&53121888)*(&0)+(&57064184)*(&1)+(&29725449) = (&1)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&84901888) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &79036416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &53121888` [mpos] THEN
  note `&0:real < &57064184` [npos] THEN
  note `&0:real < &29725449` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&53121888)*(&0)+(&57064184)*(&1))*s pow 0 = (&1)*((&84901888) * &2753 / &4096 + (-- &79036416) * &0) /\ ((&53121888)*(-- &1)+(&57064184)*(&0))*s pow 0 = (&1)*((&84901888) * &0 + (-- &79036416) * &2753 / &4096) /\ (&53121888)*(&0)+(&57064184)*(&1)+(&29725449) = (&1)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &65279136` in
let npos = REAL_ARITH `!s:real. &0:real < &90364472` in
let ppos = REAL_ARITH `!s:real. &0:real < &41593089` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&65279136)*(&0)+(&90364472)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&134447104) * &2753 / &4096 + (-- &97124352) * &0)) /\
  ((&65279136)*(-- &1)+(&90364472)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&134447104) * &0 + (-- &97124352) * &2753 / &4096)) /\
  (&65279136)*(&0)+(&90364472)*(&1)+(&41593089) = (&1)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&134447104) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &97124352) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &65279136` [mpos] THEN
  note `&0:real < &90364472` [npos] THEN
  note `&0:real < &41593089` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&65279136)*(&0)+(&90364472)*(&1))*s pow 0 = (&1)*((&134447104) * &2753 / &4096 + (-- &97124352) * &0) /\ ((&65279136)*(-- &1)+(&90364472)*(&0))*s pow 0 = (&1)*((&134447104) * &0 + (-- &97124352) * &2753 / &4096) /\ (&65279136)*(&0)+(&90364472)*(&1)+(&41593089) = (&1)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &33784816` in
let npos = REAL_ARITH `!s:real. &0:real < &67481536` in
let ppos = REAL_ARITH `!s:real. &0:real < &28103287` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&33784816)*(&0)+(&67481536)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&100401152) * &2753 / &4096 + (-- &50266112) * &0)) /\
  ((&33784816)*(-- &1)+(&67481536)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&100401152) * &0 + (-- &50266112) * &2753 / &4096)) /\
  (&33784816)*(&0)+(&67481536)*(&1)+(&28103287) = (&1)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&100401152) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &50266112) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &33784816` [mpos] THEN
  note `&0:real < &67481536` [npos] THEN
  note `&0:real < &28103287` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&33784816)*(&0)+(&67481536)*(&1))*s pow 0 = (&1)*((&100401152) * &2753 / &4096 + (-- &50266112) * &0) /\ ((&33784816)*(-- &1)+(&67481536)*(&0))*s pow 0 = (&1)*((&100401152) * &0 + (-- &50266112) * &2753 / &4096) /\ (&33784816)*(&0)+(&67481536)*(&1)+(&28103287) = (&1)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &18345992` in
let npos = REAL_ARITH `!s:real. &0:real < &43541448` in
let ppos = REAL_ARITH `!s:real. &0:real < &17570895` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&18345992)*(&0)+(&43541448)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&64782336) * &2753 / &4096 + (-- &27295744) * &0)) /\
  ((&18345992)*(-- &1)+(&43541448)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&64782336) * &0 + (-- &27295744) * &2753 / &4096)) /\
  (&18345992)*(&0)+(&43541448)*(&1)+(&17570895) = (&1)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&64782336) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &27295744) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &18345992` [mpos] THEN
  note `&0:real < &43541448` [npos] THEN
  note `&0:real < &17570895` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&18345992)*(&0)+(&43541448)*(&1))*s pow 0 = (&1)*((&64782336) * &2753 / &4096 + (-- &27295744) * &0) /\ ((&18345992)*(-- &1)+(&43541448)*(&0))*s pow 0 = (&1)*((&64782336) * &0 + (-- &27295744) * &2753 / &4096) /\ (&18345992)*(&0)+(&43541448)*(&1)+(&17570895) = (&1)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &3215504` in
let npos = REAL_ARITH `!s:real. &0:real < &8699480` in
let ppos = REAL_ARITH `!s:real. &0:real < &3457543` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&3215504)*(&0)+(&8699480)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&12943360) * &2753 / &4096 + (-- &4784128) * &0)) /\
  ((&3215504)*(-- &1)+(&8699480)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&12943360) * &0 + (-- &4784128) * &2753 / &4096)) /\
  (&3215504)*(&0)+(&8699480)*(&1)+(&3457543) = (&1)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&12943360) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &4784128) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3215504` [mpos] THEN
  note `&0:real < &8699480` [npos] THEN
  note `&0:real < &3457543` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&3215504)*(&0)+(&8699480)*(&1))*s pow 0 = (&1)*((&12943360) * &2753 / &4096 + (-- &4784128) * &0) /\ ((&3215504)*(-- &1)+(&8699480)*(&0))*s pow 0 = (&1)*((&12943360) * &0 + (-- &4784128) * &2753 / &4096) /\ (&3215504)*(&0)+(&8699480)*(&1)+(&3457543) = (&1)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &244774736` in
let npos = REAL_ARITH `!s:real. &0:real < &680233264` in
let ppos = REAL_ARITH `!s:real. &0:real < &269628433` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&244774736)*(&0)+(&680233264)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&1012072448) * &2753 / &4096 + (-- &364183552) * &0)) /\
  ((&244774736)*(-- &1)+(&680233264)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&1012072448) * &0 + (-- &364183552) * &2753 / &4096)) /\
  (&244774736)*(&0)+(&680233264)*(&1)+(&269628433) = (&1)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&1012072448) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &364183552) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &244774736` [mpos] THEN
  note `&0:real < &680233264` [npos] THEN
  note `&0:real < &269628433` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&244774736)*(&0)+(&680233264)*(&1))*s pow 0 = (&1)*((&1012072448) * &2753 / &4096 + (-- &364183552) * &0) /\ ((&244774736)*(-- &1)+(&680233264)*(&0))*s pow 0 = (&1)*((&1012072448) * &0 + (-- &364183552) * &2753 / &4096) /\ (&244774736)*(&0)+(&680233264)*(&1)+(&269628433) = (&1)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &880960` in
let npos = REAL_ARITH `!s:real. &0:real < &2598832` in
let ppos = REAL_ARITH `!s:real. &0:real < &1043211` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&880960)*(&0)+(&2598832)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&3866624) * &2753 / &4096 + (-- &1310720) * &0)) /\
  ((&880960)*(-- &1)+(&2598832)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&3866624) * &0 + (-- &1310720) * &2753 / &4096)) /\
  (&880960)*(&0)+(&2598832)*(&1)+(&1043211) = (&1)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&3866624) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &1310720) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &880960` [mpos] THEN
  note `&0:real < &2598832` [npos] THEN
  note `&0:real < &1043211` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&880960)*(&0)+(&2598832)*(&1))*s pow 0 = (&1)*((&3866624) * &2753 / &4096 + (-- &1310720) * &0) /\ ((&880960)*(-- &1)+(&2598832)*(&0))*s pow 0 = (&1)*((&3866624) * &0 + (-- &1310720) * &2753 / &4096) /\ (&880960)*(&0)+(&2598832)*(&1)+(&1043211) = (&1)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &1761920` in
let npos = REAL_ARITH `!s:real. &0:real < &26296656` in
let ppos = REAL_ARITH `!s:real. &0:real < &12360493` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1761920)*(&0)+(&26296656)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&39124992) * &2753 / &4096 + (-- &2621440) * &0)) /\
  ((&1761920)*(-- &1)+(&26296656)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((&39124992) * &0 + (-- &2621440) * &2753 / &4096)) /\
  (&1761920)*(&0)+(&26296656)*(&1)+(&12360493) = (&1)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (&1) * x + (&0) * y <= &1 ==>
  (&39124992) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (-- &2621440) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1761920` [mpos] THEN
  note `&0:real < &26296656` [npos] THEN
  note `&0:real < &12360493` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1761920)*(&0)+(&26296656)*(&1))*s pow 0 = (&1)*((&39124992) * &2753 / &4096 + (-- &2621440) * &0) /\ ((&1761920)*(-- &1)+(&26296656)*(&0))*s pow 0 = (&1)*((&39124992) * &0 + (-- &2621440) * &2753 / &4096) /\ (&1761920)*(&0)+(&26296656)*(&1)+(&12360493) = (&1)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &4580992` in
let npos = REAL_ARITH `!s:real. &0:real < &638696` in
let ppos = REAL_ARITH `!s:real. &0:real < &1454379` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&4580992)*(&1)+(&638696)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&5865472) * &2753 / &4096 + (&950272) * &0)) /\
  ((&4580992)*(&0)+(&638696)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&5865472) * &0 + (&950272) * &2753 / &4096)) /\
  (&4580992)*(&1)+(&638696)*(&0)+(&1454379) = (&1)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&5865472) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&950272) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4580992` [mpos] THEN
  note `&0:real < &638696` [npos] THEN
  note `&0:real < &1454379` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&4580992)*(&1)+(&638696)*(-- &1))*s pow 0 = (&1)*((&5865472) * &2753 / &4096 + (&950272) * &0) /\ ((&4580992)*(&0)+(&638696)*(&1))*s pow 0 = (&1)*((&5865472) * &0 + (&950272) * &2753 / &4096) /\ (&4580992)*(&1)+(&638696)*(&0)+(&1454379) = (&1)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &420261968` in
let npos = REAL_ARITH `!s:real. &0:real < &124942152` in
let ppos = REAL_ARITH `!s:real. &0:real < &60181675` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&420261968)*(&1)+(&124942152)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&439386112) * &2753 / &4096 + (&185892864) * &0)) /\
  ((&420261968)*(&0)+(&124942152)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&439386112) * &0 + (&185892864) * &2753 / &4096)) /\
  (&420261968)*(&1)+(&124942152)*(&0)+(&60181675) = (&1)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&439386112) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&185892864) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &420261968` [mpos] THEN
  note `&0:real < &124942152` [npos] THEN
  note `&0:real < &60181675` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&420261968)*(&1)+(&124942152)*(-- &1))*s pow 0 = (&1)*((&439386112) * &2753 / &4096 + (&185892864) * &0) /\ ((&420261968)*(&0)+(&124942152)*(&1))*s pow 0 = (&1)*((&439386112) * &0 + (&185892864) * &2753 / &4096) /\ (&420261968)*(&1)+(&124942152)*(&0)+(&60181675) = (&1)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &51580208` in
let npos = REAL_ARITH `!s:real. &0:real < &18147776` in
let ppos = REAL_ARITH `!s:real. &0:real < &5499433` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&51580208)*(&1)+(&18147776)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&49741824) * &2753 / &4096 + (&27000832) * &0)) /\
  ((&51580208)*(&0)+(&18147776)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&49741824) * &0 + (&27000832) * &2753 / &4096)) /\
  (&51580208)*(&1)+(&18147776)*(&0)+(&5499433) = (&1)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&49741824) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&27000832) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &51580208` [mpos] THEN
  note `&0:real < &18147776` [npos] THEN
  note `&0:real < &5499433` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&51580208)*(&1)+(&18147776)*(-- &1))*s pow 0 = (&1)*((&49741824) * &2753 / &4096 + (&27000832) * &0) /\ ((&51580208)*(&0)+(&18147776)*(&1))*s pow 0 = (&1)*((&49741824) * &0 + (&27000832) * &2753 / &4096) /\ (&51580208)*(&1)+(&18147776)*(&0)+(&5499433) = (&1)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &39764332` in
let npos = REAL_ARITH `!s:real. &0:real < &17233780` in
let ppos = REAL_ARITH `!s:real. &0:real < &2150531` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&39764332)*(&1)+(&17233780)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&33521664) * &2753 / &4096 + (&25640960) * &0)) /\
  ((&39764332)*(&0)+(&17233780)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&33521664) * &0 + (&25640960) * &2753 / &4096)) /\
  (&39764332)*(&1)+(&17233780)*(&0)+(&2150531) = (&1)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&33521664) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&25640960) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &39764332` [mpos] THEN
  note `&0:real < &17233780` [npos] THEN
  note `&0:real < &2150531` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&39764332)*(&1)+(&17233780)*(-- &1))*s pow 0 = (&1)*((&33521664) * &2753 / &4096 + (&25640960) * &0) /\ ((&39764332)*(&0)+(&17233780)*(&1))*s pow 0 = (&1)*((&33521664) * &0 + (&25640960) * &2753 / &4096) /\ (&39764332)*(&1)+(&17233780)*(&0)+(&2150531) = (&1)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &2257460` in
let npos = REAL_ARITH `!s:real. &0:real < &1002092` in
let ppos = REAL_ARITH `!s:real. &0:real < &110701` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&2257460)*(&1)+(&1002092)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&1867776) * &2753 / &4096 + (&1490944) * &0)) /\
  ((&2257460)*(&0)+(&1002092)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&1867776) * &0 + (&1490944) * &2753 / &4096)) /\
  (&2257460)*(&1)+(&1002092)*(&0)+(&110701) = (&1)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&1867776) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&1490944) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2257460` [mpos] THEN
  note `&0:real < &1002092` [npos] THEN
  note `&0:real < &110701` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&2257460)*(&1)+(&1002092)*(-- &1))*s pow 0 = (&1)*((&1867776) * &2753 / &4096 + (&1490944) * &0) /\ ((&2257460)*(&0)+(&1002092)*(&1))*s pow 0 = (&1)*((&1867776) * &0 + (&1490944) * &2753 / &4096) /\ (&2257460)*(&1)+(&1002092)*(&0)+(&110701) = (&1)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &10384316` in
let npos = REAL_ARITH `!s:real. &0:real < &5252724` in
let ppos = REAL_ARITH `!s:real. &0:real < &221371` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&10384316)*(&1)+(&5252724)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7634944) * &2753 / &4096 + (&7815168) * &0)) /\
  ((&10384316)*(&0)+(&5252724)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7634944) * &0 + (&7815168) * &2753 / &4096)) /\
  (&10384316)*(&1)+(&5252724)*(&0)+(&221371) = (&1)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&7634944) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&7815168) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &10384316` [mpos] THEN
  note `&0:real < &5252724` [npos] THEN
  note `&0:real < &221371` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&10384316)*(&1)+(&5252724)*(-- &1))*s pow 0 = (&1)*((&7634944) * &2753 / &4096 + (&7815168) * &0) /\ ((&10384316)*(&0)+(&5252724)*(&1))*s pow 0 = (&1)*((&7634944) * &0 + (&7815168) * &2753 / &4096) /\ (&10384316)*(&1)+(&5252724)*(&0)+(&221371) = (&1)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &1398524` in
let npos = REAL_ARITH `!s:real. &0:real < &759828` in
let ppos = REAL_ARITH `!s:real. &0:real < &8599` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1398524)*(&1)+(&759828)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&950272) * &2753 / &4096 + (&1130496) * &0)) /\
  ((&1398524)*(&0)+(&759828)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&950272) * &0 + (&1130496) * &2753 / &4096)) /\
  (&1398524)*(&1)+(&759828)*(&0)+(&8599) = (&1)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&950272) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&1130496) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1398524` [mpos] THEN
  note `&0:real < &759828` [npos] THEN
  note `&0:real < &8599` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1398524)*(&1)+(&759828)*(-- &1))*s pow 0 = (&1)*((&950272) * &2753 / &4096 + (&1130496) * &0) /\ ((&1398524)*(&0)+(&759828)*(&1))*s pow 0 = (&1)*((&950272) * &0 + (&1130496) * &2753 / &4096) /\ (&1398524)*(&1)+(&759828)*(&0)+(&8599) = (&1)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &657328304` in
let npos = REAL_ARITH `!s:real. &0:real < &362779328` in
let ppos = REAL_ARITH `!s:real. &0:real < &1804209` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&657328304)*(&1)+(&362779328)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&438239232) * &2753 / &4096 + (&539754496) * &0)) /\
  ((&657328304)*(&0)+(&362779328)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&438239232) * &0 + (&539754496) * &2753 / &4096)) /\
  (&657328304)*(&1)+(&362779328)*(&0)+(&1804209) = (&1)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&438239232) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&539754496) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &657328304` [mpos] THEN
  note `&0:real < &362779328` [npos] THEN
  note `&0:real < &1804209` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&657328304)*(&1)+(&362779328)*(-- &1))*s pow 0 = (&1)*((&438239232) * &2753 / &4096 + (&539754496) * &0) /\ ((&657328304)*(&0)+(&362779328)*(&1))*s pow 0 = (&1)*((&438239232) * &0 + (&539754496) * &2753 / &4096) /\ (&657328304)*(&1)+(&362779328)*(&0)+(&1804209) = (&1)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &20218032` in
let npos = REAL_ARITH `!s:real. &0:real < &11452480` in
let ppos = REAL_ARITH `!s:real. &0:real < &38625` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&20218032)*(&1)+(&11452480)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&13041664) * &2753 / &4096 + (&17039360) * &0)) /\
  ((&20218032)*(&0)+(&11452480)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&13041664) * &0 + (&17039360) * &2753 / &4096)) /\
  (&20218032)*(&1)+(&11452480)*(&0)+(&38625) = (&1)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&13041664) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&17039360) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20218032` [mpos] THEN
  note `&0:real < &11452480` [npos] THEN
  note `&0:real < &38625` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&20218032)*(&1)+(&11452480)*(-- &1))*s pow 0 = (&1)*((&13041664) * &2753 / &4096 + (&17039360) * &0) /\ ((&20218032)*(&0)+(&11452480)*(&1))*s pow 0 = (&1)*((&13041664) * &0 + (&17039360) * &2753 / &4096) /\ (&20218032)*(&1)+(&11452480)*(&0)+(&38625) = (&1)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &13225412` in
let npos = REAL_ARITH `!s:real. &0:real < &8027748` in
let ppos = REAL_ARITH `!s:real. &0:real < &103` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&13225412)*(&1)+(&8027748)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7733248) * &2753 / &4096 + (&11943936) * &0)) /\
  ((&13225412)*(&0)+(&8027748)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7733248) * &0 + (&11943936) * &2753 / &4096)) /\
  (&13225412)*(&1)+(&8027748)*(&0)+(&103) = (&1)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&7733248) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&11943936) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &13225412` [mpos] THEN
  note `&0:real < &8027748` [npos] THEN
  note `&0:real < &103` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&13225412)*(&1)+(&8027748)*(-- &1))*s pow 0 = (&1)*((&7733248) * &2753 / &4096 + (&11943936) * &0) /\ ((&13225412)*(&0)+(&8027748)*(&1))*s pow 0 = (&1)*((&7733248) * &0 + (&11943936) * &2753 / &4096) /\ (&13225412)*(&1)+(&8027748)*(&0)+(&103) = (&1)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &1971148` in
let npos = REAL_ARITH `!s:real. &0:real < &1368241` in
let ppos = REAL_ARITH `!s:real. &0:real < &6005` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1971148)*(&1)+(&1368241)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&897024) * &2753 / &4096 + (&2035712) * &0)) /\
  ((&1971148)*(&0)+(&1368241)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&897024) * &0 + (&2035712) * &2753 / &4096)) /\
  (&1971148)*(&1)+(&1368241)*(&0)+(&6005) = (&1)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&897024) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&2035712) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1971148` [mpos] THEN
  note `&0:real < &1368241` [npos] THEN
  note `&0:real < &6005` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1971148)*(&1)+(&1368241)*(-- &1))*s pow 0 = (&1)*((&897024) * &2753 / &4096 + (&2035712) * &0) /\ ((&1971148)*(&0)+(&1368241)*(&1))*s pow 0 = (&1)*((&897024) * &0 + (&2035712) * &2753 / &4096) /\ (&1971148)*(&1)+(&1368241)*(&0)+(&6005) = (&1)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &7697388` in
let npos = REAL_ARITH `!s:real. &0:real < &5982269` in
let ppos = REAL_ARITH `!s:real. &0:real < &160042` in
let qpos = REAL_ARITH `!s:real. &0:real < &2` in
let mqrel = REAL_ARITH `
  ((&7697388)*(&1)+(&5982269)*(-- &1))*(&30902639 / &41749730) pow 0 = (&2)*(((&1275904) * &2753 / &4096 + (&4450304) * &0)) /\
  ((&7697388)*(&0)+(&5982269)*(&1))*(&30902639 / &41749730) pow 0 = (&2)*(((&1275904) * &0 + (&4450304) * &2753 / &4096)) /\
  (&7697388)*(&1)+(&5982269)*(&0)+(&160042) = (&2)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&1275904) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&4450304) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7697388` [mpos] THEN
  note `&0:real < &5982269` [npos] THEN
  note `&0:real < &160042` [ppos] THEN
  note `&0:real < &2` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&7697388)*(&1)+(&5982269)*(-- &1))*s pow 0 = (&2)*((&1275904) * &2753 / &4096 + (&4450304) * &0) /\ ((&7697388)*(&0)+(&5982269)*(&1))*s pow 0 = (&2)*((&1275904) * &0 + (&4450304) * &2753 / &4096) /\ (&7697388)*(&1)+(&5982269)*(&0)+(&160042) = (&2)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &7807508` in
let npos = REAL_ARITH `!s:real. &0:real < &6320888` in
let ppos = REAL_ARITH `!s:real. &0:real < &232461` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&7807508)*(&1)+(&6320888)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&2211840) * &2753 / &4096 + (&9404416) * &0)) /\
  ((&7807508)*(&0)+(&6320888)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&2211840) * &0 + (&9404416) * &2753 / &4096)) /\
  (&7807508)*(&1)+(&6320888)*(&0)+(&232461) = (&1)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&2211840) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&9404416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7807508` [mpos] THEN
  note `&0:real < &6320888` [npos] THEN
  note `&0:real < &232461` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&7807508)*(&1)+(&6320888)*(-- &1))*s pow 0 = (&1)*((&2211840) * &2753 / &4096 + (&9404416) * &0) /\ ((&7807508)*(&0)+(&6320888)*(&1))*s pow 0 = (&1)*((&2211840) * &0 + (&9404416) * &2753 / &4096) /\ (&7807508)*(&1)+(&6320888)*(&0)+(&232461) = (&1)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &30789552` in
let npos = REAL_ARITH `!s:real. &0:real < &25591888` in
let ppos = REAL_ARITH `!s:real. &0:real < &1154535` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&30789552)*(&1)+(&25591888)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7733248) * &2753 / &4096 + (&38076416) * &0)) /\
  ((&30789552)*(&0)+(&25591888)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&7733248) * &0 + (&38076416) * &2753 / &4096)) /\
  (&30789552)*(&1)+(&25591888)*(&0)+(&1154535) = (&1)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&7733248) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&38076416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &30789552` [mpos] THEN
  note `&0:real < &25591888` [npos] THEN
  note `&0:real < &1154535` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&30789552)*(&1)+(&25591888)*(-- &1))*s pow 0 = (&1)*((&7733248) * &2753 / &4096 + (&38076416) * &0) /\ ((&30789552)*(&0)+(&25591888)*(&1))*s pow 0 = (&1)*((&7733248) * &0 + (&38076416) * &2753 / &4096) /\ (&30789552)*(&1)+(&25591888)*(&0)+(&1154535) = (&1)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &38894384` in
let npos = REAL_ARITH `!s:real. &0:real < &37572944` in
let ppos = REAL_ARITH `!s:real. &0:real < &3417247` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&38894384)*(&1)+(&37572944)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((&1966080) * &2753 / &4096 + (&55902208) * &0)) /\
  ((&38894384)*(&0)+(&37572944)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((&1966080) * &0 + (&55902208) * &2753 / &4096)) /\
  (&38894384)*(&1)+(&37572944)*(&0)+(&3417247) = (&1)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&1966080) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&55902208) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &38894384` [mpos] THEN
  note `&0:real < &37572944` [npos] THEN
  note `&0:real < &3417247` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&38894384)*(&1)+(&37572944)*(-- &1))*s pow 0 = (&1)*((&1966080) * &2753 / &4096 + (&55902208) * &0) /\ ((&38894384)*(&0)+(&37572944)*(&1))*s pow 0 = (&1)*((&1966080) * &0 + (&55902208) * &2753 / &4096) /\ (&38894384)*(&1)+(&37572944)*(&0)+(&3417247) = (&1)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &97434176` in
let npos = REAL_ARITH `!s:real. &0:real < &105318768` in
let ppos = REAL_ARITH `!s:real. &0:real < &12966273` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&97434176)*(&1)+(&105318768)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &11730944) * &2753 / &4096 + (&156696576) * &0)) /\
  ((&97434176)*(&0)+(&105318768)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &11730944) * &0 + (&156696576) * &2753 / &4096)) /\
  (&97434176)*(&1)+(&105318768)*(&0)+(&12966273) = (&1)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &11730944) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&156696576) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &97434176` [mpos] THEN
  note `&0:real < &105318768` [npos] THEN
  note `&0:real < &12966273` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&97434176)*(&1)+(&105318768)*(-- &1))*s pow 0 = (&1)*((-- &11730944) * &2753 / &4096 + (&156696576) * &0) /\ ((&97434176)*(&0)+(&105318768)*(&1))*s pow 0 = (&1)*((-- &11730944) * &0 + (&156696576) * &2753 / &4096) /\ (&97434176)*(&1)+(&105318768)*(&0)+(&12966273) = (&1)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &63693408` in
let npos = REAL_ARITH `!s:real. &0:real < &78978064` in
let ppos = REAL_ARITH `!s:real. &0:real < &13989149` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&63693408)*(&1)+(&78978064)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &22740992) * &2753 / &4096 + (&117506048) * &0)) /\
  ((&63693408)*(&0)+(&78978064)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &22740992) * &0 + (&117506048) * &2753 / &4096)) /\
  (&63693408)*(&1)+(&78978064)*(&0)+(&13989149) = (&1)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &22740992) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&117506048) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &63693408` [mpos] THEN
  note `&0:real < &78978064` [npos] THEN
  note `&0:real < &13989149` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&63693408)*(&1)+(&78978064)*(-- &1))*s pow 0 = (&1)*((-- &22740992) * &2753 / &4096 + (&117506048) * &0) /\ ((&63693408)*(&0)+(&78978064)*(&1))*s pow 0 = (&1)*((-- &22740992) * &0 + (&117506048) * &2753 / &4096) /\ (&63693408)*(&1)+(&78978064)*(&0)+(&13989149) = (&1)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &348287536` in
let npos = REAL_ARITH `!s:real. &0:real < &460081360` in
let ppos = REAL_ARITH `!s:real. &0:real < &92775871` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&348287536)*(&1)+(&460081360)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &166330368) * &2753 / &4096 + (&684523520) * &0)) /\
  ((&348287536)*(&0)+(&460081360)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &166330368) * &0 + (&684523520) * &2753 / &4096)) /\
  (&348287536)*(&1)+(&460081360)*(&0)+(&92775871) = (&1)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &166330368) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&684523520) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &348287536` [mpos] THEN
  note `&0:real < &460081360` [npos] THEN
  note `&0:real < &92775871` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&348287536)*(&1)+(&460081360)*(-- &1))*s pow 0 = (&1)*((-- &166330368) * &2753 / &4096 + (&684523520) * &0) /\ ((&348287536)*(&0)+(&460081360)*(&1))*s pow 0 = (&1)*((-- &166330368) * &0 + (&684523520) * &2753 / &4096) /\ (&348287536)*(&1)+(&460081360)*(&0)+(&92775871) = (&1)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &68406544` in
let npos = REAL_ARITH `!s:real. &0:real < &91179360` in
let ppos = REAL_ARITH `!s:real. &0:real < &18838969` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&68406544)*(&1)+(&91179360)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &33882112) * &2753 / &4096 + (&135659520) * &0)) /\
  ((&68406544)*(&0)+(&91179360)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &33882112) * &0 + (&135659520) * &2753 / &4096)) /\
  (&68406544)*(&1)+(&91179360)*(&0)+(&18838969) = (&1)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &33882112) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&135659520) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &68406544` [mpos] THEN
  note `&0:real < &91179360` [npos] THEN
  note `&0:real < &18838969` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&68406544)*(&1)+(&91179360)*(-- &1))*s pow 0 = (&1)*((-- &33882112) * &2753 / &4096 + (&135659520) * &0) /\ ((&68406544)*(&0)+(&91179360)*(&1))*s pow 0 = (&1)*((-- &33882112) * &0 + (&135659520) * &2753 / &4096) /\ (&68406544)*(&1)+(&91179360)*(&0)+(&18838969) = (&1)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &83603104` in
let npos = REAL_ARITH `!s:real. &0:real < &117652208` in
let ppos = REAL_ARITH `!s:real. &0:real < &27946881` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&83603104)*(&1)+(&117652208)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &50659328) * &2753 / &4096 + (&175046656) * &0)) /\
  ((&83603104)*(&0)+(&117652208)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &50659328) * &0 + (&175046656) * &2753 / &4096)) /\
  (&83603104)*(&1)+(&117652208)*(&0)+(&27946881) = (&1)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &50659328) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&175046656) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &83603104` [mpos] THEN
  note `&0:real < &117652208` [npos] THEN
  note `&0:real < &27946881` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&83603104)*(&1)+(&117652208)*(-- &1))*s pow 0 = (&1)*((-- &50659328) * &2753 / &4096 + (&175046656) * &0) /\ ((&83603104)*(&0)+(&117652208)*(&1))*s pow 0 = (&1)*((-- &50659328) * &0 + (&175046656) * &2753 / &4096) /\ (&83603104)*(&1)+(&117652208)*(&0)+(&27946881) = (&1)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &16077520` in
let npos = REAL_ARITH `!s:real. &0:real < &23477584` in
let ppos = REAL_ARITH `!s:real. &0:real < &6085855` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&16077520)*(&1)+(&23477584)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &11010048) * &2753 / &4096 + (&34930688) * &0)) /\
  ((&16077520)*(&0)+(&23477584)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &11010048) * &0 + (&34930688) * &2753 / &4096)) /\
  (&16077520)*(&1)+(&23477584)*(&0)+(&6085855) = (&1)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &11010048) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&34930688) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16077520` [mpos] THEN
  note `&0:real < &23477584` [npos] THEN
  note `&0:real < &6085855` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&16077520)*(&1)+(&23477584)*(-- &1))*s pow 0 = (&1)*((-- &11010048) * &2753 / &4096 + (&34930688) * &0) /\ ((&16077520)*(&0)+(&23477584)*(&1))*s pow 0 = (&1)*((-- &11010048) * &0 + (&34930688) * &2753 / &4096) /\ (&16077520)*(&1)+(&23477584)*(&0)+(&6085855) = (&1)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &208302992` in
let npos = REAL_ARITH `!s:real. &0:real < &306353840` in
let ppos = REAL_ARITH `!s:real. &0:real < &80682731` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&208302992)*(&1)+(&306353840)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &145883136) * &2753 / &4096 + (&455802880) * &0)) /\
  ((&208302992)*(&0)+(&306353840)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &145883136) * &0 + (&455802880) * &2753 / &4096)) /\
  (&208302992)*(&1)+(&306353840)*(&0)+(&80682731) = (&1)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &145883136) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&455802880) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &208302992` [mpos] THEN
  note `&0:real < &306353840` [npos] THEN
  note `&0:real < &80682731` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&208302992)*(&1)+(&306353840)*(-- &1))*s pow 0 = (&1)*((-- &145883136) * &2753 / &4096 + (&455802880) * &0) /\ ((&208302992)*(&0)+(&306353840)*(&1))*s pow 0 = (&1)*((-- &145883136) * &0 + (&455802880) * &2753 / &4096) /\ (&208302992)*(&1)+(&306353840)*(&0)+(&80682731) = (&1)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &4702124` in
let npos = REAL_ARITH `!s:real. &0:real < &7025656` in
let ppos = REAL_ARITH `!s:real. &0:real < &1949681` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&4702124)*(&1)+(&7025656)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &3457024) * &2753 / &4096 + (&10452992) * &0)) /\
  ((&4702124)*(&0)+(&7025656)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &3457024) * &0 + (&10452992) * &2753 / &4096)) /\
  (&4702124)*(&1)+(&7025656)*(&0)+(&1949681) = (&1)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &3457024) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&10452992) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4702124` [mpos] THEN
  note `&0:real < &7025656` [npos] THEN
  note `&0:real < &1949681` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&4702124)*(&1)+(&7025656)*(-- &1))*s pow 0 = (&1)*((-- &3457024) * &2753 / &4096 + (&10452992) * &0) /\ ((&4702124)*(&0)+(&7025656)*(&1))*s pow 0 = (&1)*((-- &3457024) * &0 + (&10452992) * &2753 / &4096) /\ (&4702124)*(&1)+(&7025656)*(&0)+(&1949681) = (&1)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &70102392` in
let npos = REAL_ARITH `!s:real. &0:real < &109172968` in
let ppos = REAL_ARITH `!s:real. &0:real < &34271933` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&70102392)*(&1)+(&109172968)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &58130432) * &2753 / &4096 + (&162430976) * &0)) /\
  ((&70102392)*(&0)+(&109172968)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &58130432) * &0 + (&162430976) * &2753 / &4096)) /\
  (&70102392)*(&1)+(&109172968)*(&0)+(&34271933) = (&1)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &58130432) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&162430976) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &70102392` [mpos] THEN
  note `&0:real < &109172968` [npos] THEN
  note `&0:real < &34271933` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&70102392)*(&1)+(&109172968)*(-- &1))*s pow 0 = (&1)*((-- &58130432) * &2753 / &4096 + (&162430976) * &0) /\ ((&70102392)*(&0)+(&109172968)*(&1))*s pow 0 = (&1)*((-- &58130432) * &0 + (&162430976) * &2753 / &4096) /\ (&70102392)*(&1)+(&109172968)*(&0)+(&34271933) = (&1)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &269794000` in
let npos = REAL_ARITH `!s:real. &0:real < &465058784` in
let ppos = REAL_ARITH `!s:real. &0:real < &187896221` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&269794000)*(&1)+(&465058784)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &290521088) * &2753 / &4096 + (&691929088) * &0)) /\
  ((&269794000)*(&0)+(&465058784)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &290521088) * &0 + (&691929088) * &2753 / &4096)) /\
  (&269794000)*(&1)+(&465058784)*(&0)+(&187896221) = (&1)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &290521088) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&691929088) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &269794000` [mpos] THEN
  note `&0:real < &465058784` [npos] THEN
  note `&0:real < &187896221` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&269794000)*(&1)+(&465058784)*(-- &1))*s pow 0 = (&1)*((-- &290521088) * &2753 / &4096 + (&691929088) * &0) /\ ((&269794000)*(&0)+(&465058784)*(&1))*s pow 0 = (&1)*((-- &290521088) * &0 + (&691929088) * &2753 / &4096) /\ (&269794000)*(&1)+(&465058784)*(&0)+(&187896221) = (&1)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &10406340` in
let npos = REAL_ARITH `!s:real. &0:real < &20113418` in
let ppos = REAL_ARITH `!s:real. &0:real < &10263147` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&10406340)*(&1)+(&20113418)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &14442496) * &2753 / &4096 + (&29925376) * &0)) /\
  ((&10406340)*(&0)+(&20113418)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &14442496) * &0 + (&29925376) * &2753 / &4096)) /\
  (&10406340)*(&1)+(&20113418)*(&0)+(&10263147) = (&1)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &14442496) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&29925376) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &10406340` [mpos] THEN
  note `&0:real < &20113418` [npos] THEN
  note `&0:real < &10263147` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&10406340)*(&1)+(&20113418)*(-- &1))*s pow 0 = (&1)*((-- &14442496) * &2753 / &4096 + (&29925376) * &0) /\ ((&10406340)*(&0)+(&20113418)*(&1))*s pow 0 = (&1)*((-- &14442496) * &0 + (&29925376) * &2753 / &4096) /\ (&10406340)*(&1)+(&20113418)*(&0)+(&10263147) = (&1)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &12432548` in
let npos = REAL_ARITH `!s:real. &0:real < &25245010` in
let ppos = REAL_ARITH `!s:real. &0:real < &13998383` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&12432548)*(&1)+(&25245010)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &19062784) * &2753 / &4096 + (&37560320) * &0)) /\
  ((&12432548)*(&0)+(&25245010)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &19062784) * &0 + (&37560320) * &2753 / &4096)) /\
  (&12432548)*(&1)+(&25245010)*(&0)+(&13998383) = (&1)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &19062784) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&37560320) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12432548` [mpos] THEN
  note `&0:real < &25245010` [npos] THEN
  note `&0:real < &13998383` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&12432548)*(&1)+(&25245010)*(-- &1))*s pow 0 = (&1)*((-- &19062784) * &2753 / &4096 + (&37560320) * &0) /\ ((&12432548)*(&0)+(&25245010)*(&1))*s pow 0 = (&1)*((-- &19062784) * &0 + (&37560320) * &2753 / &4096) /\ (&12432548)*(&1)+(&25245010)*(&0)+(&13998383) = (&1)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &9426272` in
let npos = REAL_ARITH `!s:real. &0:real < &19799576` in
let ppos = REAL_ARITH `!s:real. &0:real < &11589057` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&9426272)*(&1)+(&19799576)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &15433728) * &2753 / &4096 + (&29458432) * &0)) /\
  ((&9426272)*(&0)+(&19799576)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &15433728) * &0 + (&29458432) * &2753 / &4096)) /\
  (&9426272)*(&1)+(&19799576)*(&0)+(&11589057) = (&1)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &15433728) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&29458432) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9426272` [mpos] THEN
  note `&0:real < &19799576` [npos] THEN
  note `&0:real < &11589057` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&9426272)*(&1)+(&19799576)*(-- &1))*s pow 0 = (&1)*((-- &15433728) * &2753 / &4096 + (&29458432) * &0) /\ ((&9426272)*(&0)+(&19799576)*(&1))*s pow 0 = (&1)*((-- &15433728) * &0 + (&29458432) * &2753 / &4096) /\ (&9426272)*(&1)+(&19799576)*(&0)+(&11589057) = (&1)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &2174870` in
let npos = REAL_ARITH `!s:real. &0:real < &5979516` in
let ppos = REAL_ARITH `!s:real. &0:real < &4776881` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&2174870)*(&1)+(&5979516)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5660672) * &2753 / &4096 + (&8896512) * &0)) /\
  ((&2174870)*(&0)+(&5979516)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5660672) * &0 + (&8896512) * &2753 / &4096)) /\
  (&2174870)*(&1)+(&5979516)*(&0)+(&4776881) = (&1)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &5660672) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&8896512) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2174870` [mpos] THEN
  note `&0:real < &5979516` [npos] THEN
  note `&0:real < &4776881` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&2174870)*(&1)+(&5979516)*(-- &1))*s pow 0 = (&1)*((-- &5660672) * &2753 / &4096 + (&8896512) * &0) /\ ((&2174870)*(&0)+(&5979516)*(&1))*s pow 0 = (&1)*((-- &5660672) * &0 + (&8896512) * &2753 / &4096) /\ (&2174870)*(&1)+(&5979516)*(&0)+(&4776881) = (&1)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &87743616` in
let npos = REAL_ARITH `!s:real. &0:real < &338508880` in
let ppos = REAL_ARITH `!s:real. &0:real < &338538021` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&87743616)*(&1)+(&338508880)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &373096448) * &2753 / &4096 + (&503644160) * &0)) /\
  ((&87743616)*(&0)+(&338508880)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &373096448) * &0 + (&503644160) * &2753 / &4096)) /\
  (&87743616)*(&1)+(&338508880)*(&0)+(&338538021) = (&1)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &373096448) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&503644160) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &87743616` [mpos] THEN
  note `&0:real < &338508880` [npos] THEN
  note `&0:real < &338538021` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&87743616)*(&1)+(&338508880)*(-- &1))*s pow 0 = (&1)*((-- &373096448) * &2753 / &4096 + (&503644160) * &0) /\ ((&87743616)*(&0)+(&338508880)*(&1))*s pow 0 = (&1)*((-- &373096448) * &0 + (&503644160) * &2753 / &4096) /\ (&87743616)*(&1)+(&338508880)*(&0)+(&338538021) = (&1)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &1101200` in
let npos = REAL_ARITH `!s:real. &0:real < &4933376` in
let ppos = REAL_ARITH `!s:real. &0:real < &5306625` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&1101200)*(&1)+(&4933376)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5701632) * &2753 / &4096 + (&7340032) * &0)) /\
  ((&1101200)*(&0)+(&4933376)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &5701632) * &0 + (&7340032) * &2753 / &4096)) /\
  (&1101200)*(&1)+(&4933376)*(&0)+(&5306625) = (&1)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &5701632) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&7340032) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1101200` [mpos] THEN
  note `&0:real < &4933376` [npos] THEN
  note `&0:real < &5306625` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&1101200)*(&1)+(&4933376)*(-- &1))*s pow 0 = (&1)*((-- &5701632) * &2753 / &4096 + (&7340032) * &0) /\ ((&1101200)*(&0)+(&4933376)*(&1))*s pow 0 = (&1)*((-- &5701632) * &0 + (&7340032) * &2753 / &4096) /\ (&1101200)*(&1)+(&4933376)*(&0)+(&5306625) = (&1)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &3545864` in
let npos = REAL_ARITH `!s:real. &0:real < &34863992` in
let ppos = REAL_ARITH `!s:real. &0:real < &46418127` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&3545864)*(&1)+(&34863992)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &46596096) * &2753 / &4096 + (&51871744) * &0)) /\
  ((&3545864)*(&0)+(&34863992)*(&1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &46596096) * &0 + (&51871744) * &2753 / &4096)) /\
  (&3545864)*(&1)+(&34863992)*(&0)+(&46418127) = (&1)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1) * x + (&0) * y <= &1 ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (-- &46596096) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&51871744) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3545864` [mpos] THEN
  note `&0:real < &34863992` [npos] THEN
  note `&0:real < &46418127` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&3545864)*(&1)+(&34863992)*(-- &1))*s pow 0 = (&1)*((-- &46596096) * &2753 / &4096 + (&51871744) * &0) /\ ((&3545864)*(&0)+(&34863992)*(&1))*s pow 0 = (&1)*((-- &46596096) * &0 + (&51871744) * &2753 / &4096) /\ (&3545864)*(&1)+(&34863992)*(&0)+(&46418127) = (&1)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &57064184` in
let npos = REAL_ARITH `!s:real. &0:real < &3942296` in
let ppos = REAL_ARITH `!s:real. &0:real < &86789633` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&57064184)*(-- &1)+(&3942296)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &84901888) * &2753 / &4096 + (&79036416) * &0)) /\
  ((&57064184)*(&1)+(&3942296)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &84901888) * &0 + (&79036416) * &2753 / &4096)) /\
  (&57064184)*(&0)+(&3942296)*(&0)+(&86789633) = (&1)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &84901888) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&79036416) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &57064184` [mpos] THEN
  note `&0:real < &3942296` [npos] THEN
  note `&0:real < &86789633` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&57064184)*(-- &1)+(&3942296)*(&0))*s pow 0 = (&1)*((-- &84901888) * &2753 / &4096 + (&79036416) * &0) /\ ((&57064184)*(&1)+(&3942296)*(-- &1))*s pow 0 = (&1)*((-- &84901888) * &0 + (&79036416) * &2753 / &4096) /\ (&57064184)*(&0)+(&3942296)*(&0)+(&86789633) = (&1)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &90364472` in
let npos = REAL_ARITH `!s:real. &0:real < &25085336` in
let ppos = REAL_ARITH `!s:real. &0:real < &131957561` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&90364472)*(-- &1)+(&25085336)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &134447104) * &2753 / &4096 + (&97124352) * &0)) /\
  ((&90364472)*(&1)+(&25085336)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &134447104) * &0 + (&97124352) * &2753 / &4096)) /\
  (&90364472)*(&0)+(&25085336)*(&0)+(&131957561) = (&1)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &134447104) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&97124352) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &90364472` [mpos] THEN
  note `&0:real < &25085336` [npos] THEN
  note `&0:real < &131957561` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&90364472)*(-- &1)+(&25085336)*(&0))*s pow 0 = (&1)*((-- &134447104) * &2753 / &4096 + (&97124352) * &0) /\ ((&90364472)*(&1)+(&25085336)*(-- &1))*s pow 0 = (&1)*((-- &134447104) * &0 + (&97124352) * &2753 / &4096) /\ (&90364472)*(&0)+(&25085336)*(&0)+(&131957561) = (&1)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &67481536` in
let npos = REAL_ARITH `!s:real. &0:real < &33696720` in
let ppos = REAL_ARITH `!s:real. &0:real < &95584823` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&67481536)*(-- &1)+(&33696720)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &100401152) * &2753 / &4096 + (&50266112) * &0)) /\
  ((&67481536)*(&1)+(&33696720)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &100401152) * &0 + (&50266112) * &2753 / &4096)) /\
  (&67481536)*(&0)+(&33696720)*(&0)+(&95584823) = (&1)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &100401152) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&50266112) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &67481536` [mpos] THEN
  note `&0:real < &33696720` [npos] THEN
  note `&0:real < &95584823` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&67481536)*(-- &1)+(&33696720)*(&0))*s pow 0 = (&1)*((-- &100401152) * &2753 / &4096 + (&50266112) * &0) /\ ((&67481536)*(&1)+(&33696720)*(-- &1))*s pow 0 = (&1)*((-- &100401152) * &0 + (&50266112) * &2753 / &4096) /\ (&67481536)*(&0)+(&33696720)*(&0)+(&95584823) = (&1)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &43541448` in
let npos = REAL_ARITH `!s:real. &0:real < &25195456` in
let ppos = REAL_ARITH `!s:real. &0:real < &61112343` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&43541448)*(-- &1)+(&25195456)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &64782336) * &2753 / &4096 + (&27295744) * &0)) /\
  ((&43541448)*(&1)+(&25195456)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &64782336) * &0 + (&27295744) * &2753 / &4096)) /\
  (&43541448)*(&0)+(&25195456)*(&0)+(&61112343) = (&1)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &64782336) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&27295744) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &43541448` [mpos] THEN
  note `&0:real < &25195456` [npos] THEN
  note `&0:real < &61112343` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&43541448)*(-- &1)+(&25195456)*(&0))*s pow 0 = (&1)*((-- &64782336) * &2753 / &4096 + (&27295744) * &0) /\ ((&43541448)*(&1)+(&25195456)*(-- &1))*s pow 0 = (&1)*((-- &64782336) * &0 + (&27295744) * &2753 / &4096) /\ (&43541448)*(&0)+(&25195456)*(&0)+(&61112343) = (&1)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &8699480` in
let npos = REAL_ARITH `!s:real. &0:real < &5483976` in
let ppos = REAL_ARITH `!s:real. &0:real < &12157023` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&8699480)*(-- &1)+(&5483976)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &12943360) * &2753 / &4096 + (&4784128) * &0)) /\
  ((&8699480)*(&1)+(&5483976)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &12943360) * &0 + (&4784128) * &2753 / &4096)) /\
  (&8699480)*(&0)+(&5483976)*(&0)+(&12157023) = (&1)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &12943360) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&4784128) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8699480` [mpos] THEN
  note `&0:real < &5483976` [npos] THEN
  note `&0:real < &12157023` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&8699480)*(-- &1)+(&5483976)*(&0))*s pow 0 = (&1)*((-- &12943360) * &2753 / &4096 + (&4784128) * &0) /\ ((&8699480)*(&1)+(&5483976)*(-- &1))*s pow 0 = (&1)*((-- &12943360) * &0 + (&4784128) * &2753 / &4096) /\ (&8699480)*(&0)+(&5483976)*(&0)+(&12157023) = (&1)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &680233264` in
let npos = REAL_ARITH `!s:real. &0:real < &435458528` in
let ppos = REAL_ARITH `!s:real. &0:real < &949861697` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&680233264)*(-- &1)+(&435458528)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1012072448) * &2753 / &4096 + (&364183552) * &0)) /\
  ((&680233264)*(&1)+(&435458528)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &1012072448) * &0 + (&364183552) * &2753 / &4096)) /\
  (&680233264)*(&0)+(&435458528)*(&0)+(&949861697) = (&1)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &1012072448) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&364183552) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &680233264` [mpos] THEN
  note `&0:real < &435458528` [npos] THEN
  note `&0:real < &949861697` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&680233264)*(-- &1)+(&435458528)*(&0))*s pow 0 = (&1)*((-- &1012072448) * &2753 / &4096 + (&364183552) * &0) /\ ((&680233264)*(&1)+(&435458528)*(-- &1))*s pow 0 = (&1)*((-- &1012072448) * &0 + (&364183552) * &2753 / &4096) /\ (&680233264)*(&0)+(&435458528)*(&0)+(&949861697) = (&1)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &2598832` in
let npos = REAL_ARITH `!s:real. &0:real < &1717872` in
let ppos = REAL_ARITH `!s:real. &0:real < &3642043` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&2598832)*(-- &1)+(&1717872)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &3866624) * &2753 / &4096 + (&1310720) * &0)) /\
  ((&2598832)*(&1)+(&1717872)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &3866624) * &0 + (&1310720) * &2753 / &4096)) /\
  (&2598832)*(&0)+(&1717872)*(&0)+(&3642043) = (&1)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &3866624) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&1310720) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2598832` [mpos] THEN
  note `&0:real < &1717872` [npos] THEN
  note `&0:real < &3642043` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&2598832)*(-- &1)+(&1717872)*(&0))*s pow 0 = (&1)*((-- &3866624) * &2753 / &4096 + (&1310720) * &0) /\ ((&2598832)*(&1)+(&1717872)*(-- &1))*s pow 0 = (&1)*((-- &3866624) * &0 + (&1310720) * &2753 / &4096) /\ (&2598832)*(&0)+(&1717872)*(&0)+(&3642043) = (&1)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &26296656` in
let npos = REAL_ARITH `!s:real. &0:real < &24534736` in
let ppos = REAL_ARITH `!s:real. &0:real < &38657149` in
let qpos = REAL_ARITH `!s:real. &0:real < &1` in
let mqrel = REAL_ARITH `
  ((&26296656)*(-- &1)+(&24534736)*(&0))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &39124992) * &2753 / &4096 + (&2621440) * &0)) /\
  ((&26296656)*(&1)+(&24534736)*(-- &1))*(&30902639 / &41749730) pow 0 = (&1)*(((-- &39124992) * &0 + (&2621440) * &2753 / &4096)) /\
  (&26296656)*(&0)+(&24534736)*(&0)+(&38657149) = (&1)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1) * x + (&1) * y <= &0 ==>
  (&0) * x + (-- &1) * y <= &0 ==>
  (-- &39124992) * ((&2753 / &4096) * x + (&0) * y) / s pow 0 + (&2621440) * ((&0) * x + (&2753 / &4096) * y) / s pow 0 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26296656` [mpos] THEN
  note `&0:real < &24534736` [npos] THEN
  note `&0:real < &38657149` [ppos] THEN
  note `&0:real < &1` [qpos] THEN
  note `&0:real < s pow 0` [REAL_POW_LT] THEN
  note `((&26296656)*(-- &1)+(&24534736)*(&0))*s pow 0 = (&1)*((-- &39124992) * &2753 / &4096 + (&2621440) * &0) /\ ((&26296656)*(&1)+(&24534736)*(-- &1))*s pow 0 = (&1)*((-- &39124992) * &0 + (&2621440) * &2753 / &4096) /\ (&26296656)*(&0)+(&24534736)*(&0)+(&38657149) = (&1)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_hinit_0_1 x y ==>
  divsteps_H1 (((&2753 / &4096) * x + (&0) * y) / divsteps_s pow 0) (((&0) * x + (&2753 / &4096) * y) / divsteps_s pow 0)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_hinit_0_1] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H1] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

let init2stable_simple = prove(`
  !x:real y:real.
  divsteps_hinit_0_1 x y ==>
  divsteps_H1 ((&2753 / &4096)*x) ((&2753 / &4096)*y)
  `,
  REPEAT STRIP_TAC THEN
  note `divsteps_H1 (((&2753 / &4096) * x + (&0) * y) / divsteps_s pow 0) (((&0) * x + (&2753 / &4096) * y) / divsteps_s pow 0)` [init2stable] THEN
  real_linear `(((&2753 / &4096) * x + (&0) * y) / divsteps_s pow 0) = (&2753 / &4096) * x` THEN
  real_linear `(((&0) * x + (&2753 / &4096) * y) / divsteps_s pow 0) = (&2753 / &4096) * y` THEN
  ASM_MESON_TAC[]
);;

(* skipping Gc for approx *)
["timing","init2stable",Sys.time()];;

(* ----- stable-hull transitions *)

let h1_contains0 = prove(`
  divsteps_H1 (&0) (&0)
  `,
  REWRITE_TAC[divsteps_H1] THEN
  REWRITE_TAC[REAL_ARITH `c * &0 = &0:real`] THEN
  REWRITE_TAC[REAL_ARITH `&0 + &0 = &0:real`] THEN
  REPEAT STRIP_TAC THENL [
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6035371`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &480443643`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &57079641`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &41914863`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &2368161`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &10605687`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &1407123`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &659132513`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &20256657`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &13225515`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &1977153`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &3928715`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &8039969`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &31944087`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &42311631`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &110400449`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &77682557`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &441063407`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &87245513`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &111549985`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &22163375`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &288985723`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6651805`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &104374325`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &457690221`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &20669487`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &26430931`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &21015329`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6951751`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &426281637`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6407825`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &49963991`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &86789633`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &131957561`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &95584823`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &61112343`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &12157023`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &949861697`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &3642043`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &38657149`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6035371`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &480443643`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &57079641`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &41914863`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &2368161`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &10605687`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &1407123`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &659132513`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &20256657`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &13225515`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &1977153`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &3928715`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &8039969`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &31944087`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &42311631`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &110400449`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &77682557`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &441063407`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &87245513`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &111549985`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &22163375`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &288985723`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6651805`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &104374325`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &457690221`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &20669487`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &26430931`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &21015329`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6951751`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &426281637`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &6407825`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &49963991`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &86789633`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &131957561`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &95584823`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &61112343`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &12157023`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &949861697`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &3642043`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
    specialize[`divsteps_s`](REAL_ARITH `!s:real. &0:real < &38657149`) THEN ASM_MESON_TAC[REAL_LT_IMP_LE];
  ]);;

(* skipping Gc for approx *)

let theorem0 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &486238230445` in
let npos = REAL_ARITH `!s:real. &0:real < &145706557700` in
let ppos = REAL_ARITH `!s:real. &0:real < &19234074074758165041` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&486238230445)*(-- &413007872)+(&145706557700)*(-- &32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &5865472) * &1 + (-- &950272) * &0)) /\
  ((&486238230445)*(-- &32178176)+(&145706557700)*(-- &6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &5865472) * &0 + (-- &950272) * &1 / &2)) /\
  (&486238230445)*(&275907781)+(&145706557700)*(&21583161)+(&19234074074758165041) = (&25936399496866)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &413007872) * x + (-- &32178176) * y <= &275907781 ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &5865472) * ((&1) * x + (&0) * y) / s pow 1 + (-- &950272) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &486238230445` [mpos] THEN
  note `&0:real < &145706557700` [npos] THEN
  note `&0:real < &19234074074758165041` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&486238230445)*(-- &413007872)+(&145706557700)*(-- &32309248))*s pow 1 = (&25936399496866)*((-- &5865472) * &1 + (-- &950272) * &0) /\ ((&486238230445)*(-- &32178176)+(&145706557700)*(-- &6881280))*s pow 1 = (&25936399496866)*((-- &5865472) * &0 + (-- &950272) * &1 / &2) /\ (&486238230445)*(&275907781)+(&145706557700)*(&21583161)+(&19234074074758165041) = (&25936399496866)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &398730796365` in
let npos = REAL_ARITH `!s:real. &0:real < &471429768212920` in
let ppos = REAL_ARITH `!s:real. &0:real < &2176020743804103466653` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&398730796365)*(-- &413007872)+(&471429768212920)*(-- &32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &439386112) * &1 + (-- &185892864) * &0)) /\
  ((&398730796365)*(-- &32178176)+(&471429768212920)*(-- &6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &439386112) * &0 + (-- &185892864) * &1 / &2)) /\
  (&398730796365)*(&275907781)+(&471429768212920)*(&21583161)+(&2176020743804103466653) = (&25936399496866)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &413007872) * x + (-- &32178176) * y <= &275907781 ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &439386112) * ((&1) * x + (&0) * y) / s pow 1 + (-- &185892864) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &398730796365` [mpos] THEN
  note `&0:real < &471429768212920` [npos] THEN
  note `&0:real < &2176020743804103466653` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&398730796365)*(-- &413007872)+(&471429768212920)*(-- &32309248))*s pow 1 = (&25936399496866)*((-- &439386112) * &1 + (-- &185892864) * &0) /\ ((&398730796365)*(-- &32178176)+(&471429768212920)*(-- &6881280))*s pow 1 = (&25936399496866)*((-- &439386112) * &0 + (-- &185892864) * &1 / &2) /\ (&398730796365)*(&275907781)+(&471429768212920)*(&21583161)+(&2176020743804103466653) = (&25936399496866)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &1401079189070` in
let npos = REAL_ARITH `!s:real. &0:real < &3651097387960` in
let ppos = REAL_ARITH `!s:real. &0:real < &98344818934026119119` in
let qpos = REAL_ARITH `!s:real. &0:real < &8127733986029` in
let mqrel = REAL_ARITH `
  ((&1401079189070)*(-- &32309248)+(&3651097387960)*(-- &137199616))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((-- &49741824) * &1 + (-- &27000832) * &0)) /\
  ((&1401079189070)*(-- &6881280)+(&3651097387960)*(-- &37961728))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((-- &49741824) * &0 + (-- &27000832) * &1 / &2)) /\
  (&1401079189070)*(&21583161)+(&3651097387960)*(&91847345)+(&98344818934026119119) = (&8127733986029)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &137199616) * x + (-- &37961728) * y <= &91847345 ==>
  (-- &49741824) * ((&1) * x + (&0) * y) / s pow 1 + (-- &27000832) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1401079189070` [mpos] THEN
  note `&0:real < &3651097387960` [npos] THEN
  note `&0:real < &98344818934026119119` [ppos] THEN
  note `&0:real < &8127733986029` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1401079189070)*(-- &32309248)+(&3651097387960)*(-- &137199616))*s pow 1 = (&8127733986029)*((-- &49741824) * &1 + (-- &27000832) * &0) /\ ((&1401079189070)*(-- &6881280)+(&3651097387960)*(-- &37961728))*s pow 1 = (&8127733986029)*((-- &49741824) * &0 + (-- &27000832) * &1 / &2) /\ (&1401079189070)*(&21583161)+(&3651097387960)*(&91847345)+(&98344818934026119119) = (&8127733986029)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &576167148865` in
let npos = REAL_ARITH `!s:real. &0:real < &381738656255` in
let ppos = REAL_ARITH `!s:real. &0:real < &7843956818982354258` in
let qpos = REAL_ARITH `!s:real. &0:real < &734061286806` in
let mqrel = REAL_ARITH `
  ((&576167148865)*(-- &52412416)+(&381738656255)*(-- &7979008))*(&30902639 / &41749730) pow 1 = (&734061286806)*(((-- &33521664) * &1 + (-- &25640960) * &0)) /\
  ((&576167148865)*(-- &19972096)+(&381738656255)*(-- &3162112))*(&30902639 / &41749730) pow 1 = (&734061286806)*(((-- &33521664) * &0 + (-- &25640960) * &1 / &2)) /\
  (&576167148865)*(&36108393)+(&381738656255)*(&5552625)+(&7843956818982354258) = (&734061286806)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &52412416) * x + (-- &19972096) * y <= &36108393 ==>
  (-- &7979008) * x + (-- &3162112) * y <= &5552625 ==>
  (-- &33521664) * ((&1) * x + (&0) * y) / s pow 1 + (-- &25640960) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &576167148865` [mpos] THEN
  note `&0:real < &381738656255` [npos] THEN
  note `&0:real < &7843956818982354258` [ppos] THEN
  note `&0:real < &734061286806` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&576167148865)*(-- &52412416)+(&381738656255)*(-- &7979008))*s pow 1 = (&734061286806)*((-- &33521664) * &1 + (-- &25640960) * &0) /\ ((&576167148865)*(-- &19972096)+(&381738656255)*(-- &3162112))*s pow 1 = (&734061286806)*((-- &33521664) * &0 + (-- &25640960) * &1 / &2) /\ (&576167148865)*(&36108393)+(&381738656255)*(&5552625)+(&7843956818982354258) = (&734061286806)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &1297038861910` in
let npos = REAL_ARITH `!s:real. &0:real < &6533832745` in
let ppos = REAL_ARITH `!s:real. &0:real < &2688851509626771699` in
let qpos = REAL_ARITH `!s:real. &0:real < &4416481555324` in
let mqrel = REAL_ARITH `
  ((&1297038861910)*(-- &7979008)+(&6533832745)*(-- &121733120))*(&30902639 / &41749730) pow 1 = (&4416481555324)*(((-- &1867776) * &1 + (-- &1490944) * &0)) /\
  ((&1297038861910)*(-- &3162112)+(&6533832745)*(-- &53051392))*(&30902639 / &41749730) pow 1 = (&4416481555324)*(((-- &1867776) * &0 + (-- &1490944) * &1 / &2)) /\
  (&1297038861910)*(&5552625)+(&6533832745)*(&86950107)+(&2688851509626771699) = (&4416481555324)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7979008) * x + (-- &3162112) * y <= &5552625 ==>
  (-- &121733120) * x + (-- &53051392) * y <= &86950107 ==>
  (-- &1867776) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1490944) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1297038861910` [mpos] THEN
  note `&0:real < &6533832745` [npos] THEN
  note `&0:real < &2688851509626771699` [ppos] THEN
  note `&0:real < &4416481555324` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1297038861910)*(-- &7979008)+(&6533832745)*(-- &121733120))*s pow 1 = (&4416481555324)*((-- &1867776) * &1 + (-- &1490944) * &0) /\ ((&1297038861910)*(-- &3162112)+(&6533832745)*(-- &53051392))*s pow 1 = (&4416481555324)*((-- &1867776) * &0 + (-- &1490944) * &1 / &2) /\ (&1297038861910)*(&5552625)+(&6533832745)*(&86950107)+(&2688851509626771699) = (&4416481555324)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &2911438296415` in
let npos = REAL_ARITH `!s:real. &0:real < &10986316200310` in
let ppos = REAL_ARITH `!s:real. &0:real < &473066114229036992963` in
let qpos = REAL_ARITH `!s:real. &0:real < &167210656728154` in
let mqrel = REAL_ARITH `
  ((&2911438296415)*(-- &121733120)+(&10986316200310)*(-- &124731392))*(&30902639 / &41749730) pow 1 = (&167210656728154)*(((-- &7634944) * &1 + (-- &7815168) * &0)) /\
  ((&2911438296415)*(-- &53051392)+(&10986316200310)*(-- &66289664))*(&30902639 / &41749730) pow 1 = (&167210656728154)*(((-- &7634944) * &0 + (-- &7815168) * &1 / &2)) /\
  (&2911438296415)*(&86950107)+(&10986316200310)*(&95315653)+(&473066114229036992963) = (&167210656728154)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &121733120) * x + (-- &53051392) * y <= &86950107 ==>
  (-- &124731392) * x + (-- &66289664) * y <= &95315653 ==>
  (-- &7634944) * ((&1) * x + (&0) * y) / s pow 1 + (-- &7815168) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2911438296415` [mpos] THEN
  note `&0:real < &10986316200310` [npos] THEN
  note `&0:real < &473066114229036992963` [ppos] THEN
  note `&0:real < &167210656728154` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2911438296415)*(-- &121733120)+(&10986316200310)*(-- &124731392))*s pow 1 = (&167210656728154)*((-- &7634944) * &1 + (-- &7815168) * &0) /\ ((&2911438296415)*(-- &53051392)+(&10986316200310)*(-- &66289664))*s pow 1 = (&167210656728154)*((-- &7634944) * &0 + (-- &7815168) * &1 / &2) /\ (&2911438296415)*(&86950107)+(&10986316200310)*(&95315653)+(&473066114229036992963) = (&167210656728154)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &1008172480040` in
let npos = REAL_ARITH `!s:real. &0:real < &1168178320265` in
let ppos = REAL_ARITH `!s:real. &0:real < &93103023383130437121` in
let qpos = REAL_ARITH `!s:real. &0:real < &248820261762972` in
let mqrel = REAL_ARITH `
  ((&1008172480040)*(-- &124731392)+(&1168178320265)*(-- &165806080))*(&30902639 / &41749730) pow 1 = (&248820261762972)*(((-- &950272) * &1 + (-- &1130496) * &0)) /\
  ((&1008172480040)*(-- &66289664)+(&1168178320265)*(-- &105447424))*(&30902639 / &41749730) pow 1 = (&248820261762972)*(((-- &950272) * &0 + (-- &1130496) * &1 / &2)) /\
  (&1008172480040)*(&95315653)+(&1168178320265)*(&137755571)+(&93103023383130437121) = (&248820261762972)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &124731392) * x + (-- &66289664) * y <= &95315653 ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &950272) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1130496) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1008172480040` [mpos] THEN
  note `&0:real < &1168178320265` [npos] THEN
  note `&0:real < &93103023383130437121` [ppos] THEN
  note `&0:real < &248820261762972` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1008172480040)*(-- &124731392)+(&1168178320265)*(-- &165806080))*s pow 1 = (&248820261762972)*((-- &950272) * &1 + (-- &1130496) * &0) /\ ((&1008172480040)*(-- &66289664)+(&1168178320265)*(-- &105447424))*s pow 1 = (&248820261762972)*((-- &950272) * &0 + (-- &1130496) * &1 / &2) /\ (&1008172480040)*(&95315653)+(&1168178320265)*(&137755571)+(&93103023383130437121) = (&248820261762972)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &56920412889560` in
let npos = REAL_ARITH `!s:real. &0:real < &179303901422360` in
let ppos = REAL_ARITH `!s:real. &0:real < &10875863458723443926919` in
let qpos = REAL_ARITH `!s:real. &0:real < &62205065440743` in
let mqrel = REAL_ARITH `
  ((&56920412889560)*(-- &124731392)+(&179303901422360)*(-- &165806080))*(&30902639 / &41749730) pow 1 = (&62205065440743)*(((-- &438239232) * &1 + (-- &539754496) * &0)) /\
  ((&56920412889560)*(-- &66289664)+(&179303901422360)*(-- &105447424))*(&30902639 / &41749730) pow 1 = (&62205065440743)*(((-- &438239232) * &0 + (-- &539754496) * &1 / &2)) /\
  (&56920412889560)*(&95315653)+(&179303901422360)*(&137755571)+(&10875863458723443926919) = (&62205065440743)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &124731392) * x + (-- &66289664) * y <= &95315653 ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &438239232) * ((&1) * x + (&0) * y) / s pow 1 + (-- &539754496) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &56920412889560` [mpos] THEN
  note `&0:real < &179303901422360` [npos] THEN
  note `&0:real < &10875863458723443926919` [ppos] THEN
  note `&0:real < &62205065440743` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&56920412889560)*(-- &124731392)+(&179303901422360)*(-- &165806080))*s pow 1 = (&62205065440743)*((-- &438239232) * &1 + (-- &539754496) * &0) /\ ((&56920412889560)*(-- &66289664)+(&179303901422360)*(-- &105447424))*s pow 1 = (&62205065440743)*((-- &438239232) * &0 + (-- &539754496) * &1 / &2) /\ (&56920412889560)*(&95315653)+(&179303901422360)*(&137755571)+(&10875863458723443926919) = (&62205065440743)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &25801333140` in
let npos = REAL_ARITH `!s:real. &0:real < &121199466190` in
let ppos = REAL_ARITH `!s:real. &0:real < &2160596266490378027` in
let qpos = REAL_ARITH `!s:real. &0:real < &399231193241` in
let mqrel = REAL_ARITH `
  ((&25801333140)*(-- &165806080)+(&121199466190)*(-- &22740992))*(&30902639 / &41749730) pow 1 = (&399231193241)*(((-- &13041664) * &1 + (-- &17039360) * &0)) /\
  ((&25801333140)*(-- &105447424)+(&121199466190)*(-- &15466496))*(&30902639 / &41749730) pow 1 = (&399231193241)*(((-- &13041664) * &0 + (-- &17039360) * &1 / &2)) /\
  (&25801333140)*(&137755571)+(&121199466190)*(&19572823)+(&2160596266490378027) = (&399231193241)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &22740992) * x + (-- &15466496) * y <= &19572823 ==>
  (-- &13041664) * ((&1) * x + (&0) * y) / s pow 1 + (-- &17039360) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &25801333140` [mpos] THEN
  note `&0:real < &121199466190` [npos] THEN
  note `&0:real < &2160596266490378027` [ppos] THEN
  note `&0:real < &399231193241` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&25801333140)*(-- &165806080)+(&121199466190)*(-- &22740992))*s pow 1 = (&399231193241)*((-- &13041664) * &1 + (-- &17039360) * &0) /\ ((&25801333140)*(-- &105447424)+(&121199466190)*(-- &15466496))*s pow 1 = (&399231193241)*((-- &13041664) * &0 + (-- &17039360) * &1 / &2) /\ (&25801333140)*(&137755571)+(&121199466190)*(&19572823)+(&2160596266490378027) = (&399231193241)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &541723621615` in
let npos = REAL_ARITH `!s:real. &0:real < &136897364670` in
let ppos = REAL_ARITH `!s:real. &0:real < &915971212490356745` in
let qpos = REAL_ARITH `!s:real. &0:real < &259458557044` in
let mqrel = REAL_ARITH `
  ((&541723621615)*(-- &3604480)+(&136897364670)*(-- &5537792))*(&30902639 / &41749730) pow 1 = (&259458557044)*(((-- &7733248) * &1 + (-- &11943936) * &0)) /\
  ((&541723621615)*(-- &2555904)+(&136897364670)*(-- &5177344))*(&30902639 / &41749730) pow 1 = (&259458557044)*(((-- &7733248) * &0 + (-- &11943936) * &1 / &2)) /\
  (&541723621615)*(&3177943)+(&136897364670)*(&5799491)+(&915971212490356745) = (&259458557044)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3604480) * x + (-- &2555904) * y <= &3177943 ==>
  (-- &5537792) * x + (-- &5177344) * y <= &5799491 ==>
  (-- &7733248) * ((&1) * x + (&0) * y) / s pow 1 + (-- &11943936) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &541723621615` [mpos] THEN
  note `&0:real < &136897364670` [npos] THEN
  note `&0:real < &915971212490356745` [ppos] THEN
  note `&0:real < &259458557044` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&541723621615)*(-- &3604480)+(&136897364670)*(-- &5537792))*s pow 1 = (&259458557044)*((-- &7733248) * &1 + (-- &11943936) * &0) /\ ((&541723621615)*(-- &2555904)+(&136897364670)*(-- &5177344))*s pow 1 = (&259458557044)*((-- &7733248) * &0 + (-- &11943936) * &1 / &2) /\ (&541723621615)*(&3177943)+(&136897364670)*(&5799491)+(&915971212490356745) = (&259458557044)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &3367449722340` in
let npos = REAL_ARITH `!s:real. &0:real < &308718378485` in
let ppos = REAL_ARITH `!s:real. &0:real < &47046584603706587609` in
let qpos = REAL_ARITH `!s:real. &0:real < &89111838704848` in
let mqrel = REAL_ARITH `
  ((&3367449722340)*(-- &5537792)+(&308718378485)*(-- &289406976))*(&30902639 / &41749730) pow 1 = (&89111838704848)*(((-- &897024) * &1 + (-- &2035712) * &0)) /\
  ((&3367449722340)*(-- &5177344)+(&308718378485)*(-- &340459520))*(&30902639 / &41749730) pow 1 = (&89111838704848)*(((-- &897024) * &0 + (-- &2035712) * &1 / &2)) /\
  (&3367449722340)*(&5799491)+(&308718378485)*(&355053887)+(&47046584603706587609) = (&89111838704848)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5537792) * x + (-- &5177344) * y <= &5799491 ==>
  (-- &289406976) * x + (-- &340459520) * y <= &355053887 ==>
  (-- &897024) * ((&1) * x + (&0) * y) / s pow 1 + (-- &2035712) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3367449722340` [mpos] THEN
  note `&0:real < &308718378485` [npos] THEN
  note `&0:real < &47046584603706587609` [ppos] THEN
  note `&0:real < &89111838704848` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3367449722340)*(-- &5537792)+(&308718378485)*(-- &289406976))*s pow 1 = (&89111838704848)*((-- &897024) * &1 + (-- &2035712) * &0) /\ ((&3367449722340)*(-- &5177344)+(&308718378485)*(-- &340459520))*s pow 1 = (&89111838704848)*((-- &897024) * &0 + (-- &2035712) * &1 / &2) /\ (&3367449722340)*(&5799491)+(&308718378485)*(&355053887)+(&47046584603706587609) = (&89111838704848)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &2784287595985` in
let npos = REAL_ARITH `!s:real. &0:real < &217426900695` in
let ppos = REAL_ARITH `!s:real. &0:real < &51440170729778959700` in
let qpos = REAL_ARITH `!s:real. &0:real < &50603194973056` in
let mqrel = REAL_ARITH `
  ((&2784287595985)*(-- &26116096)+(&217426900695)*(-- &66748416))*(&30902639 / &41749730) pow 1 = (&50603194973056)*(((-- &1275904) * &1 + (-- &4450304) * &0)) /\
  ((&2784287595985)*(-- &42532864)+(&217426900695)*(-- &154992640))*(&30902639 / &41749730) pow 1 = (&50603194973056)*(((-- &1275904) * &0 + (-- &4450304) * &1 / &2)) /\
  (&2784287595985)*(&41635449)+(&217426900695)*(&144601685)+(&51440170729778959700) = (&50603194973056)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &26116096) * x + (-- &42532864) * y <= &41635449 ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &1275904) * ((&1) * x + (&0) * y) / s pow 1 + (-- &4450304) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2784287595985` [mpos] THEN
  note `&0:real < &217426900695` [npos] THEN
  note `&0:real < &51440170729778959700` [ppos] THEN
  note `&0:real < &50603194973056` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2784287595985)*(-- &26116096)+(&217426900695)*(-- &66748416))*s pow 1 = (&50603194973056)*((-- &1275904) * &1 + (-- &4450304) * &0) /\ ((&2784287595985)*(-- &42532864)+(&217426900695)*(-- &154992640))*s pow 1 = (&50603194973056)*((-- &1275904) * &0 + (-- &4450304) * &1 / &2) /\ (&2784287595985)*(&41635449)+(&217426900695)*(&144601685)+(&51440170729778959700) = (&50603194973056)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &102345667665` in
let npos = REAL_ARITH `!s:real. &0:real < &101544831935` in
let ppos = REAL_ARITH `!s:real. &0:real < &6483245802990512644` in
let qpos = REAL_ARITH `!s:real. &0:real < &3162699685816` in
let mqrel = REAL_ARITH `
  ((&102345667665)*(-- &26116096)+(&101544831935)*(-- &66748416))*(&30902639 / &41749730) pow 1 = (&3162699685816)*(((-- &2211840) * &1 + (-- &9404416) * &0)) /\
  ((&102345667665)*(-- &42532864)+(&101544831935)*(-- &154992640))*(&30902639 / &41749730) pow 1 = (&3162699685816)*(((-- &2211840) * &0 + (-- &9404416) * &1 / &2)) /\
  (&102345667665)*(&41635449)+(&101544831935)*(&144601685)+(&6483245802990512644) = (&3162699685816)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &26116096) * x + (-- &42532864) * y <= &41635449 ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &2211840) * ((&1) * x + (&0) * y) / s pow 1 + (-- &9404416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &102345667665` [mpos] THEN
  note `&0:real < &101544831935` [npos] THEN
  note `&0:real < &6483245802990512644` [ppos] THEN
  note `&0:real < &3162699685816` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&102345667665)*(-- &26116096)+(&101544831935)*(-- &66748416))*s pow 1 = (&3162699685816)*((-- &2211840) * &1 + (-- &9404416) * &0) /\ ((&102345667665)*(-- &42532864)+(&101544831935)*(-- &154992640))*s pow 1 = (&3162699685816)*((-- &2211840) * &0 + (-- &9404416) * &1 / &2) /\ (&102345667665)*(&41635449)+(&101544831935)*(&144601685)+(&6483245802990512644) = (&3162699685816)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &476957265466` in
let npos = REAL_ARITH `!s:real. &0:real < &561258320282` in
let ppos = REAL_ARITH `!s:real. &0:real < &26248422423917354605` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&476957265466)*(-- &66748416)+(&561258320282)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &7733248) * &1 + (-- &38076416) * &0)) /\
  ((&476957265466)*(-- &154992640)+(&561258320282)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &7733248) * &0 + (-- &38076416) * &1 / &2)) /\
  (&476957265466)*(&144601685)+(&561258320282)*(&15704445)+(&26248422423917354605) = (&3256674611015)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (-- &7733248) * ((&1) * x + (&0) * y) / s pow 1 + (-- &38076416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &476957265466` [mpos] THEN
  note `&0:real < &561258320282` [npos] THEN
  note `&0:real < &26248422423917354605` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&476957265466)*(-- &66748416)+(&561258320282)*(-- &3899392))*s pow 1 = (&3256674611015)*((-- &7733248) * &1 + (-- &38076416) * &0) /\ ((&476957265466)*(-- &154992640)+(&561258320282)*(-- &17530880))*s pow 1 = (&3256674611015)*((-- &7733248) * &0 + (-- &38076416) * &1 / &2) /\ (&476957265466)*(&144601685)+(&561258320282)*(&15704445)+(&26248422423917354605) = (&3256674611015)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &3466354832710` in
let npos = REAL_ARITH `!s:real. &0:real < &1448861755055` in
let ppos = REAL_ARITH `!s:real. &0:real < &47042428248299204428` in
let qpos = REAL_ARITH `!s:real. &0:real < &5124491917453` in
let mqrel = REAL_ARITH `
  ((&3466354832710)*(-- &3899392)+(&1448861755055)*(-- &65536))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((-- &1966080) * &1 + (-- &55902208) * &0)) /\
  ((&3466354832710)*(-- &17530880)+(&1448861755055)*(-- &91619328))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((-- &1966080) * &0 + (-- &55902208) * &1 / &2)) /\
  (&3466354832710)*(&15704445)+(&1448861755055)*(&79611463)+(&47042428248299204428) = (&5124491917453)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (-- &65536) * x + (-- &91619328) * y <= &79611463 ==>
  (-- &1966080) * ((&1) * x + (&0) * y) / s pow 1 + (-- &55902208) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3466354832710` [mpos] THEN
  note `&0:real < &1448861755055` [npos] THEN
  note `&0:real < &47042428248299204428` [ppos] THEN
  note `&0:real < &5124491917453` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3466354832710)*(-- &3899392)+(&1448861755055)*(-- &65536))*s pow 1 = (&5124491917453)*((-- &1966080) * &1 + (-- &55902208) * &0) /\ ((&3466354832710)*(-- &17530880)+(&1448861755055)*(-- &91619328))*s pow 1 = (&5124491917453)*((-- &1966080) * &0 + (-- &55902208) * &1 / &2) /\ (&3466354832710)*(&15704445)+(&1448861755055)*(&79611463)+(&47042428248299204428) = (&5124491917453)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &222964433065` in
let npos = REAL_ARITH `!s:real. &0:real < &26836225447240` in
let ppos = REAL_ARITH `!s:real. &0:real < &73151055017574218254` in
let qpos = REAL_ARITH `!s:real. &0:real < &3736098152461` in
let mqrel = REAL_ARITH `
  ((&222964433065)*(&129499136)+(&26836225447240)*(&1130496))*(&30902639 / &41749730) pow 1 = (&3736098152461)*(((&11730944) * &1 + (-- &156696576) * &0)) /\
  ((&222964433065)*(-- &923729920)+(&26836225447240)*(-- &7061504))*(&30902639 / &41749730) pow 1 = (&3736098152461)*(((&11730944) * &0 + (-- &156696576) * &1 / &2)) /\
  (&222964433065)*(&791274703)+(&26836225447240)*(&6069771)+(&73151055017574218254) = (&3736098152461)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&129499136) * x + (-- &923729920) * y <= &791274703 ==>
  (&1130496) * x + (-- &7061504) * y <= &6069771 ==>
  (&11730944) * ((&1) * x + (&0) * y) / s pow 1 + (-- &156696576) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &222964433065` [mpos] THEN
  note `&0:real < &26836225447240` [npos] THEN
  note `&0:real < &73151055017574218254` [ppos] THEN
  note `&0:real < &3736098152461` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&222964433065)*(&129499136)+(&26836225447240)*(&1130496))*s pow 1 = (&3736098152461)*((&11730944) * &1 + (-- &156696576) * &0) /\ ((&222964433065)*(-- &923729920)+(&26836225447240)*(-- &7061504))*s pow 1 = (&3736098152461)*((&11730944) * &0 + (-- &156696576) * &1 / &2) /\ (&222964433065)*(&791274703)+(&26836225447240)*(&6069771)+(&73151055017574218254) = (&3736098152461)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &3658862837740` in
let npos = REAL_ARITH `!s:real. &0:real < &117164438284960` in
let ppos = REAL_ARITH `!s:real. &0:real < &13131825496118412027` in
let qpos = REAL_ARITH `!s:real. &0:real < &1970012333611` in
let mqrel = REAL_ARITH `
  ((&3658862837740)*(&1130496)+(&117164438284960)*(&481280))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((&22740992) * &1 + (-- &117506048) * &0)) /\
  ((&3658862837740)*(-- &7061504)+(&117164438284960)*(-- &1114112))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((&22740992) * &0 + (-- &117506048) * &1 / &2)) /\
  (&3658862837740)*(&6069771)+(&117164438284960)*(&1004531)+(&13131825496118412027) = (&1970012333611)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1130496) * x + (-- &7061504) * y <= &6069771 ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&22740992) * ((&1) * x + (&0) * y) / s pow 1 + (-- &117506048) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3658862837740` [mpos] THEN
  note `&0:real < &117164438284960` [npos] THEN
  note `&0:real < &13131825496118412027` [ppos] THEN
  note `&0:real < &1970012333611` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3658862837740)*(&1130496)+(&117164438284960)*(&481280))*s pow 1 = (&1970012333611)*((&22740992) * &1 + (-- &117506048) * &0) /\ ((&3658862837740)*(-- &7061504)+(&117164438284960)*(-- &1114112))*s pow 1 = (&1970012333611)*((&22740992) * &0 + (-- &117506048) * &1 / &2) /\ (&3658862837740)*(&6069771)+(&117164438284960)*(&1004531)+(&13131825496118412027) = (&1970012333611)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &1252705491618680` in
let npos = REAL_ARITH `!s:real. &0:real < &6403761461185` in
let ppos = REAL_ARITH `!s:real. &0:real < &79153741761771282372` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&1252705491618680)*(&481280)+(&6403761461185)*(&44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&166330368) * &1 + (-- &684523520) * &0)) /\
  ((&1252705491618680)*(-- &1114112)+(&6403761461185)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&166330368) * &0 + (-- &684523520) * &1 / &2)) /\
  (&1252705491618680)*(&1004531)+(&6403761461185)*(&62719715)+(&79153741761771282372) = (&3943145833761)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&166330368) * ((&1) * x + (&0) * y) / s pow 1 + (-- &684523520) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1252705491618680` [mpos] THEN
  note `&0:real < &6403761461185` [npos] THEN
  note `&0:real < &79153741761771282372` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1252705491618680)*(&481280)+(&6403761461185)*(&44220416))*s pow 1 = (&3943145833761)*((&166330368) * &1 + (-- &684523520) * &0) /\ ((&1252705491618680)*(-- &1114112)+(&6403761461185)*(-- &66781184))*s pow 1 = (&3943145833761)*((&166330368) * &0 + (-- &684523520) * &1 / &2) /\ (&1252705491618680)*(&1004531)+(&6403761461185)*(&62719715)+(&79153741761771282372) = (&3943145833761)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &229180299866320` in
let npos = REAL_ARITH `!s:real. &0:real < &1587449983790` in
let ppos = REAL_ARITH `!s:real. &0:real < &14238654735213448623` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&229180299866320)*(&481280)+(&1587449983790)*(&44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&33882112) * &1 + (-- &135659520) * &0)) /\
  ((&229180299866320)*(-- &1114112)+(&1587449983790)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&33882112) * &0 + (-- &135659520) * &1 / &2)) /\
  (&229180299866320)*(&1004531)+(&1587449983790)*(&62719715)+(&14238654735213448623) = (&3943145833761)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&33882112) * ((&1) * x + (&0) * y) / s pow 1 + (-- &135659520) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &229180299866320` [mpos] THEN
  note `&0:real < &1587449983790` [npos] THEN
  note `&0:real < &14238654735213448623` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&229180299866320)*(&481280)+(&1587449983790)*(&44220416))*s pow 1 = (&3943145833761)*((&33882112) * &1 + (-- &135659520) * &0) /\ ((&229180299866320)*(-- &1114112)+(&1587449983790)*(-- &66781184))*s pow 1 = (&3943145833761)*((&33882112) * &0 + (-- &135659520) * &1 / &2) /\ (&229180299866320)*(&1004531)+(&1587449983790)*(&62719715)+(&14238654735213448623) = (&3943145833761)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &50519010288120` in
let npos = REAL_ARITH `!s:real. &0:real < &1484474274745` in
let ppos = REAL_ARITH `!s:real. &0:real < &2765570842377111800` in
let qpos = REAL_ARITH `!s:real. &0:real < &1314381944587` in
let mqrel = REAL_ARITH `
  ((&50519010288120)*(&481280)+(&1484474274745)*(&44220416))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((&50659328) * &1 + (-- &175046656) * &0)) /\
  ((&50519010288120)*(-- &1114112)+(&1484474274745)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((&50659328) * &0 + (-- &175046656) * &1 / &2)) /\
  (&50519010288120)*(&1004531)+(&1484474274745)*(&62719715)+(&2765570842377111800) = (&1314381944587)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&50659328) * ((&1) * x + (&0) * y) / s pow 1 + (-- &175046656) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &50519010288120` [mpos] THEN
  note `&0:real < &1484474274745` [npos] THEN
  note `&0:real < &2765570842377111800` [ppos] THEN
  note `&0:real < &1314381944587` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&50519010288120)*(&481280)+(&1484474274745)*(&44220416))*s pow 1 = (&1314381944587)*((&50659328) * &1 + (-- &175046656) * &0) /\ ((&50519010288120)*(-- &1114112)+(&1484474274745)*(-- &66781184))*s pow 1 = (&1314381944587)*((&50659328) * &0 + (-- &175046656) * &1 / &2) /\ (&50519010288120)*(&1004531)+(&1484474274745)*(&62719715)+(&2765570842377111800) = (&1314381944587)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &11528102446520` in
let npos = REAL_ARITH `!s:real. &0:real < &1200910108585` in
let ppos = REAL_ARITH `!s:real. &0:real < &492343763557267980` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&11528102446520)*(&481280)+(&1200910108585)*(&44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&11010048) * &1 + (-- &34930688) * &0)) /\
  ((&11528102446520)*(-- &1114112)+(&1200910108585)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&11010048) * &0 + (-- &34930688) * &1 / &2)) /\
  (&11528102446520)*(&1004531)+(&1200910108585)*(&62719715)+(&492343763557267980) = (&3943145833761)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&11010048) * ((&1) * x + (&0) * y) / s pow 1 + (-- &34930688) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11528102446520` [mpos] THEN
  note `&0:real < &1200910108585` [npos] THEN
  note `&0:real < &492343763557267980` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&11528102446520)*(&481280)+(&1200910108585)*(&44220416))*s pow 1 = (&3943145833761)*((&11010048) * &1 + (-- &34930688) * &0) /\ ((&11528102446520)*(-- &1114112)+(&1200910108585)*(-- &66781184))*s pow 1 = (&3943145833761)*((&11010048) * &0 + (-- &34930688) * &1 / &2) /\ (&11528102446520)*(&1004531)+(&1200910108585)*(&62719715)+(&492343763557267980) = (&3943145833761)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &104406555791560` in
let npos = REAL_ARITH `!s:real. &0:real < &16438183817495` in
let ppos = REAL_ARITH `!s:real. &0:real < &3635023617110421918` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&104406555791560)*(&481280)+(&16438183817495)*(&44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&145883136) * &1 + (-- &455802880) * &0)) /\
  ((&104406555791560)*(-- &1114112)+(&16438183817495)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&145883136) * &0 + (-- &455802880) * &1 / &2)) /\
  (&104406555791560)*(&1004531)+(&16438183817495)*(&62719715)+(&3635023617110421918) = (&3943145833761)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&145883136) * ((&1) * x + (&0) * y) / s pow 1 + (-- &455802880) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &104406555791560` [mpos] THEN
  note `&0:real < &16438183817495` [npos] THEN
  note `&0:real < &3635023617110421918` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&104406555791560)*(&481280)+(&16438183817495)*(&44220416))*s pow 1 = (&3943145833761)*((&145883136) * &1 + (-- &455802880) * &0) /\ ((&104406555791560)*(-- &1114112)+(&16438183817495)*(-- &66781184))*s pow 1 = (&3943145833761)*((&145883136) * &0 + (-- &455802880) * &1 / &2) /\ (&104406555791560)*(&1004531)+(&16438183817495)*(&62719715)+(&3635023617110421918) = (&3943145833761)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &52604659800` in
let npos = REAL_ARITH `!s:real. &0:real < &277072083145` in
let ppos = REAL_ARITH `!s:real. &0:real < &55299681002801595` in
let qpos = REAL_ARITH `!s:real. &0:real < &2628763889174` in
let mqrel = REAL_ARITH `
  ((&52604659800)*(&481280)+(&277072083145)*(&44220416))*(&30902639 / &41749730) pow 1 = (&2628763889174)*(((&3457024) * &1 + (-- &10452992) * &0)) /\
  ((&52604659800)*(-- &1114112)+(&277072083145)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&2628763889174)*(((&3457024) * &0 + (-- &10452992) * &1 / &2)) /\
  (&52604659800)*(&1004531)+(&277072083145)*(&62719715)+(&55299681002801595) = (&2628763889174)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&3457024) * ((&1) * x + (&0) * y) / s pow 1 + (-- &10452992) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &52604659800` [mpos] THEN
  note `&0:real < &277072083145` [npos] THEN
  note `&0:real < &55299681002801595` [ppos] THEN
  note `&0:real < &2628763889174` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&52604659800)*(&481280)+(&277072083145)*(&44220416))*s pow 1 = (&2628763889174)*((&3457024) * &1 + (-- &10452992) * &0) /\ ((&52604659800)*(-- &1114112)+(&277072083145)*(-- &66781184))*s pow 1 = (&2628763889174)*((&3457024) * &0 + (-- &10452992) * &1 / &2) /\ (&52604659800)*(&1004531)+(&277072083145)*(&62719715)+(&55299681002801595) = (&2628763889174)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &3401049905044` in
let npos = REAL_ARITH `!s:real. &0:real < &904052828393` in
let qpos = REAL_ARITH `!s:real. &0:real < &2780341333469` in
let mqrel = REAL_ARITH `
  ((&3401049905044)*(&44220416)+(&904052828393)*(&75169792))*(&30902639 / &41749730) pow 1 = (&2780341333469)*(((&58130432) * &1 + (-- &162430976) * &0)) /\
  ((&3401049905044)*(-- &66781184)+(&904052828393)*(-- &86212608))*(&30902639 / &41749730) pow 1 = (&2780341333469)*(((&58130432) * &0 + (-- &162430976) * &1 / &2)) /\
  (&3401049905044)*(&62719715)+(&904052828393)*(&85043005)+(&0) = (&2780341333469)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&75169792) * x + (-- &86212608) * y <= &85043005 ==>
  (&58130432) * ((&1) * x + (&0) * y) / s pow 1 + (-- &162430976) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3401049905044` [mpos] THEN
  note `&0:real < &904052828393` [npos] THEN
  real_linear `&0:real <= &0` THEN
  note `&0:real < &2780341333469` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3401049905044)*(&44220416)+(&904052828393)*(&75169792))*s pow 1 = (&2780341333469)*((&58130432) * &1 + (-- &162430976) * &0) /\ ((&3401049905044)*(-- &66781184)+(&904052828393)*(-- &86212608))*s pow 1 = (&2780341333469)*((&58130432) * &0 + (-- &162430976) * &1 / &2) /\ (&3401049905044)*(&62719715)+(&904052828393)*(&85043005)+(&0) = (&2780341333469)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &2131874812936` in
let npos = REAL_ARITH `!s:real. &0:real < &9115485749172` in
let ppos = REAL_ARITH `!s:real. &0:real < &34718723327843935` in
let qpos = REAL_ARITH `!s:real. &0:real < &1985958095335` in
let mqrel = REAL_ARITH `
  ((&2131874812936)*(&44220416)+(&9115485749172)*(&75169792))*(&30902639 / &41749730) pow 1 = (&1985958095335)*(((&290521088) * &1 + (-- &691929088) * &0)) /\
  ((&2131874812936)*(-- &66781184)+(&9115485749172)*(-- &86212608))*(&30902639 / &41749730) pow 1 = (&1985958095335)*(((&290521088) * &0 + (-- &691929088) * &1 / &2)) /\
  (&2131874812936)*(&62719715)+(&9115485749172)*(&85043005)+(&34718723327843935) = (&1985958095335)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&75169792) * x + (-- &86212608) * y <= &85043005 ==>
  (&290521088) * ((&1) * x + (&0) * y) / s pow 1 + (-- &691929088) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2131874812936` [mpos] THEN
  note `&0:real < &9115485749172` [npos] THEN
  note `&0:real < &34718723327843935` [ppos] THEN
  note `&0:real < &1985958095335` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2131874812936)*(&44220416)+(&9115485749172)*(&75169792))*s pow 1 = (&1985958095335)*((&290521088) * &1 + (-- &691929088) * &0) /\ ((&2131874812936)*(-- &66781184)+(&9115485749172)*(-- &86212608))*s pow 1 = (&1985958095335)*((&290521088) * &0 + (-- &691929088) * &1 / &2) /\ (&2131874812936)*(&62719715)+(&9115485749172)*(&85043005)+(&34718723327843935) = (&1985958095335)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &12845118554235` in
let npos = REAL_ARITH `!s:real. &0:real < &18723167415260` in
let ppos = REAL_ARITH `!s:real. &0:real < &171468923700419913` in
let qpos = REAL_ARITH `!s:real. &0:real < &158185541008204` in
let mqrel = REAL_ARITH `
  ((&12845118554235)*(&75169792)+(&18723167415260)*(&113278976))*(&30902639 / &41749730) pow 1 = (&158185541008204)*(((&14442496) * &1 + (-- &29925376) * &0)) /\
  ((&12845118554235)*(-- &86212608)+(&18723167415260)*(-- &111640576))*(&30902639 / &41749730) pow 1 = (&158185541008204)*(((&14442496) * &0 + (-- &29925376) * &1 / &2)) /\
  (&12845118554235)*(&85043005)+(&18723167415260)*(&116276001)+(&171468923700419913) = (&158185541008204)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&75169792) * x + (-- &86212608) * y <= &85043005 ==>
  (&113278976) * x + (-- &111640576) * y <= &116276001 ==>
  (&14442496) * ((&1) * x + (&0) * y) / s pow 1 + (-- &29925376) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12845118554235` [mpos] THEN
  note `&0:real < &18723167415260` [npos] THEN
  note `&0:real < &171468923700419913` [ppos] THEN
  note `&0:real < &158185541008204` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12845118554235)*(&75169792)+(&18723167415260)*(&113278976))*s pow 1 = (&158185541008204)*((&14442496) * &1 + (-- &29925376) * &0) /\ ((&12845118554235)*(-- &86212608)+(&18723167415260)*(-- &111640576))*s pow 1 = (&158185541008204)*((&14442496) * &0 + (-- &29925376) * &1 / &2) /\ (&12845118554235)*(&85043005)+(&18723167415260)*(&116276001)+(&171468923700419913) = (&158185541008204)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &2104917012275` in
let npos = REAL_ARITH `!s:real. &0:real < &243526175090` in
let ppos = REAL_ARITH `!s:real. &0:real < &10763544102416439` in
let qpos = REAL_ARITH `!s:real. &0:real < &9366466270344` in
let mqrel = REAL_ARITH `
  ((&2104917012275)*(&113278976)+(&243526175090)*(&11419648))*(&30902639 / &41749730) pow 1 = (&9366466270344)*(((&19062784) * &1 + (-- &37560320) * &0)) /\
  ((&2104917012275)*(-- &111640576)+(&243526175090)*(-- &10895360))*(&30902639 / &41749730) pow 1 = (&9366466270344)*(((&19062784) * &0 + (-- &37560320) * &1 / &2)) /\
  (&2104917012275)*(&116276001)+(&243526175090)*(&11507295)+(&10763544102416439) = (&9366466270344)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&113278976) * x + (-- &111640576) * y <= &116276001 ==>
  (&11419648) * x + (-- &10895360) * y <= &11507295 ==>
  (&19062784) * ((&1) * x + (&0) * y) / s pow 1 + (-- &37560320) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2104917012275` [mpos] THEN
  note `&0:real < &243526175090` [npos] THEN
  note `&0:real < &10763544102416439` [ppos] THEN
  note `&0:real < &9366466270344` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2104917012275)*(&113278976)+(&243526175090)*(&11419648))*s pow 1 = (&9366466270344)*((&19062784) * &1 + (-- &37560320) * &0) /\ ((&2104917012275)*(-- &111640576)+(&243526175090)*(-- &10895360))*s pow 1 = (&9366466270344)*((&19062784) * &0 + (-- &37560320) * &1 / &2) /\ (&2104917012275)*(&116276001)+(&243526175090)*(&11507295)+(&10763544102416439) = (&9366466270344)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &20874865` in
let npos = REAL_ARITH `!s:real. &0:real < &24507091510` in
let ppos = REAL_ARITH `!s:real. &0:real < &12379571134863` in
let qpos = REAL_ARITH `!s:real. &0:real < &13535355882` in
let mqrel = REAL_ARITH `
  ((&20874865)*(&113278976)+(&24507091510)*(&11419648))*(&30902639 / &41749730) pow 1 = (&13535355882)*(((&15433728) * &1 + (-- &29458432) * &0)) /\
  ((&20874865)*(-- &111640576)+(&24507091510)*(-- &10895360))*(&30902639 / &41749730) pow 1 = (&13535355882)*(((&15433728) * &0 + (-- &29458432) * &1 / &2)) /\
  (&20874865)*(&116276001)+(&24507091510)*(&11507295)+(&12379571134863) = (&13535355882)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&113278976) * x + (-- &111640576) * y <= &116276001 ==>
  (&11419648) * x + (-- &10895360) * y <= &11507295 ==>
  (&15433728) * ((&1) * x + (&0) * y) / s pow 1 + (-- &29458432) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20874865` [mpos] THEN
  note `&0:real < &24507091510` [npos] THEN
  note `&0:real < &12379571134863` [ppos] THEN
  note `&0:real < &13535355882` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&20874865)*(&113278976)+(&24507091510)*(&11419648))*s pow 1 = (&13535355882)*((&15433728) * &1 + (-- &29458432) * &0) /\ ((&20874865)*(-- &111640576)+(&24507091510)*(-- &10895360))*s pow 1 = (&13535355882)*((&15433728) * &0 + (-- &29458432) * &1 / &2) /\ (&20874865)*(&116276001)+(&24507091510)*(&11507295)+(&12379571134863) = (&13535355882)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &16929515515` in
let npos = REAL_ARITH `!s:real. &0:real < &6767130236240` in
let ppos = REAL_ARITH `!s:real. &0:real < &1192303532667072` in
let qpos = REAL_ARITH `!s:real. &0:real < &3609829969507` in
let mqrel = REAL_ARITH `
  ((&16929515515)*(&11419648)+(&6767130236240)*(&4050944))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((&5660672) * &1 + (-- &8896512) * &0)) /\
  ((&16929515515)*(-- &10895360)+(&6767130236240)*(-- &3178496))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((&5660672) * &0 + (-- &8896512) * &1 / &2)) /\
  (&16929515515)*(&11507295)+(&6767130236240)*(&3679349)+(&1192303532667072) = (&3609829969507)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11419648) * x + (-- &10895360) * y <= &11507295 ==>
  (&4050944) * x + (-- &3178496) * y <= &3679349 ==>
  (&5660672) * ((&1) * x + (&0) * y) / s pow 1 + (-- &8896512) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16929515515` [mpos] THEN
  note `&0:real < &6767130236240` [npos] THEN
  note `&0:real < &1192303532667072` [ppos] THEN
  note `&0:real < &3609829969507` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&16929515515)*(&11419648)+(&6767130236240)*(&4050944))*s pow 1 = (&3609829969507)*((&5660672) * &1 + (-- &8896512) * &0) /\ ((&16929515515)*(-- &10895360)+(&6767130236240)*(-- &3178496))*s pow 1 = (&3609829969507)*((&5660672) * &0 + (-- &8896512) * &1 / &2) /\ (&16929515515)*(&11507295)+(&6767130236240)*(&3679349)+(&1192303532667072) = (&3609829969507)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &6095460580` in
let npos = REAL_ARITH `!s:real. &0:real < &547860831925` in
let ppos = REAL_ARITH `!s:real. &0:real < &13601079348234618` in
let qpos = REAL_ARITH `!s:real. &0:real < &588108122809` in
let mqrel = REAL_ARITH `
  ((&6095460580)*(&13631488)+(&547860831925)*(&540934144))*(&30902639 / &41749730) pow 1 = (&588108122809)*(((&373096448) * &1 + (-- &503644160) * &0)) /\
  ((&6095460580)*(-- &9502720)+(&547860831925)*(-- &365101056))*(&30902639 / &41749730) pow 1 = (&588108122809)*(((&373096448) * &0 + (-- &503644160) * &1 / &2)) /\
  (&6095460580)*(&11699263)+(&547860831925)*(&457442411)+(&13601079348234618) = (&588108122809)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&13631488) * x + (-- &9502720) * y <= &11699263 ==>
  (&540934144) * x + (-- &365101056) * y <= &457442411 ==>
  (&373096448) * ((&1) * x + (&0) * y) / s pow 1 + (-- &503644160) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6095460580` [mpos] THEN
  note `&0:real < &547860831925` [npos] THEN
  note `&0:real < &13601079348234618` [ppos] THEN
  note `&0:real < &588108122809` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6095460580)*(&13631488)+(&547860831925)*(&540934144))*s pow 1 = (&588108122809)*((&373096448) * &1 + (-- &503644160) * &0) /\ ((&6095460580)*(-- &9502720)+(&547860831925)*(-- &365101056))*s pow 1 = (&588108122809)*((&373096448) * &0 + (-- &503644160) * &1 / &2) /\ (&6095460580)*(&11699263)+(&547860831925)*(&457442411)+(&13601079348234618) = (&588108122809)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &125249190` in
let npos = REAL_ARITH `!s:real. &0:real < &937406687690` in
let ppos = REAL_ARITH `!s:real. &0:real < &366737657964255` in
let qpos = REAL_ARITH `!s:real. &0:real < &1037617909703` in
let mqrel = REAL_ARITH `
  ((&125249190)*(&540934144)+(&937406687690)*(&8454144))*(&30902639 / &41749730) pow 1 = (&1037617909703)*(((&5701632) * &1 + (-- &7340032) * &0)) /\
  ((&125249190)*(-- &365101056)+(&937406687690)*(-- &5439488))*(&30902639 / &41749730) pow 1 = (&1037617909703)*(((&5701632) * &0 + (-- &7340032) * &1 / &2)) /\
  (&125249190)*(&457442411)+(&937406687690)*(&7031327)+(&366737657964255) = (&1037617909703)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&540934144) * x + (-- &365101056) * y <= &457442411 ==>
  (&8454144) * x + (-- &5439488) * y <= &7031327 ==>
  (&5701632) * ((&1) * x + (&0) * y) / s pow 1 + (-- &7340032) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &125249190` [mpos] THEN
  note `&0:real < &937406687690` [npos] THEN
  note `&0:real < &366737657964255` [ppos] THEN
  note `&0:real < &1037617909703` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&125249190)*(&540934144)+(&937406687690)*(&8454144))*s pow 1 = (&1037617909703)*((&5701632) * &1 + (-- &7340032) * &0) /\ ((&125249190)*(-- &365101056)+(&937406687690)*(-- &5439488))*s pow 1 = (&1037617909703)*((&5701632) * &0 + (-- &7340032) * &1 / &2) /\ (&125249190)*(&457442411)+(&937406687690)*(&7031327)+(&366737657964255) = (&1037617909703)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &13847780069915` in
let npos = REAL_ARITH `!s:real. &0:real < &105877315280` in
let ppos = REAL_ARITH `!s:real. &0:real < &14678508568742733` in
let qpos = REAL_ARITH `!s:real. &0:real < &7618180371558` in
let mqrel = REAL_ARITH `
  ((&13847780069915)*(&34471936)+(&105877315280)*(&20946944))*(&30902639 / &41749730) pow 1 = (&7618180371558)*(((&46596096) * &1 + (-- &51871744) * &0)) /\
  ((&13847780069915)*(-- &19202048)+(&105877315280)*(-- &9748480))*(&30902639 / &41749730) pow 1 = (&7618180371558)*(((&46596096) * &0 + (-- &51871744) * &1 / &2)) /\
  (&13847780069915)*(&27364823)+(&105877315280)*(&15848215)+(&14678508568742733) = (&7618180371558)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&34471936) * x + (-- &19202048) * y <= &27364823 ==>
  (&20946944) * x + (-- &9748480) * y <= &15848215 ==>
  (&46596096) * ((&1) * x + (&0) * y) / s pow 1 + (-- &51871744) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &13847780069915` [mpos] THEN
  note `&0:real < &105877315280` [npos] THEN
  note `&0:real < &14678508568742733` [ppos] THEN
  note `&0:real < &7618180371558` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&13847780069915)*(&34471936)+(&105877315280)*(&20946944))*s pow 1 = (&7618180371558)*((&46596096) * &1 + (-- &51871744) * &0) /\ ((&13847780069915)*(-- &19202048)+(&105877315280)*(-- &9748480))*s pow 1 = (&7618180371558)*((&46596096) * &0 + (-- &51871744) * &1 / &2) /\ (&13847780069915)*(&27364823)+(&105877315280)*(&15848215)+(&14678508568742733) = (&7618180371558)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &9435438980` in
let npos = REAL_ARITH `!s:real. &0:real < &20842634208440` in
let ppos = REAL_ARITH `!s:real. &0:real < &12792068334293967` in
let qpos = REAL_ARITH `!s:real. &0:real < &3809090185779` in
let mqrel = REAL_ARITH `
  ((&9435438980)*(&34471936)+(&20842634208440)*(&20946944))*(&30902639 / &41749730) pow 1 = (&3809090185779)*(((&84901888) * &1 + (-- &79036416) * &0)) /\
  ((&9435438980)*(-- &19202048)+(&20842634208440)*(-- &9748480))*(&30902639 / &41749730) pow 1 = (&3809090185779)*(((&84901888) * &0 + (-- &79036416) * &1 / &2)) /\
  (&9435438980)*(&27364823)+(&20842634208440)*(&15848215)+(&12792068334293967) = (&3809090185779)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&34471936) * x + (-- &19202048) * y <= &27364823 ==>
  (&20946944) * x + (-- &9748480) * y <= &15848215 ==>
  (&84901888) * ((&1) * x + (&0) * y) / s pow 1 + (-- &79036416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9435438980` [mpos] THEN
  note `&0:real < &20842634208440` [npos] THEN
  note `&0:real < &12792068334293967` [ppos] THEN
  note `&0:real < &3809090185779` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&9435438980)*(&34471936)+(&20842634208440)*(&20946944))*s pow 1 = (&3809090185779)*((&84901888) * &1 + (-- &79036416) * &0) /\ ((&9435438980)*(-- &19202048)+(&20842634208440)*(-- &9748480))*s pow 1 = (&3809090185779)*((&84901888) * &0 + (-- &79036416) * &1 / &2) /\ (&9435438980)*(&27364823)+(&20842634208440)*(&15848215)+(&12792068334293967) = (&3809090185779)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &304773029000` in
let npos = REAL_ARITH `!s:real. &0:real < &6554707610` in
let ppos = REAL_ARITH `!s:real. &0:real < &265892594364019` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&304773029000)*(&24879104)+(&6554707610)*(&131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&134447104) * &1 + (-- &97124352) * &0)) /\
  ((&304773029000)*(-- &8986624)+(&6554707610)*(-- &32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&134447104) * &0 + (-- &97124352) * &1 / &2)) /\
  (&304773029000)*(&18073405)+(&6554707610)*(&92351)+(&265892594364019) = (&41749465289)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&24879104) * x + (-- &8986624) * y <= &18073405 ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&134447104) * ((&1) * x + (&0) * y) / s pow 1 + (-- &97124352) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &304773029000` [mpos] THEN
  note `&0:real < &6554707610` [npos] THEN
  note `&0:real < &265892594364019` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&304773029000)*(&24879104)+(&6554707610)*(&131072))*s pow 1 = (&41749465289)*((&134447104) * &1 + (-- &97124352) * &0) /\ ((&304773029000)*(-- &8986624)+(&6554707610)*(-- &32768))*s pow 1 = (&41749465289)*((&134447104) * &0 + (-- &97124352) * &1 / &2) /\ (&304773029000)*(&18073405)+(&6554707610)*(&92351)+(&265892594364019) = (&41749465289)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &667995680` in
let npos = REAL_ARITH `!s:real. &0:real < &43078582156170` in
let ppos = REAL_ARITH `!s:real. &0:real < &192152826362777` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&667995680)*(&24879104)+(&43078582156170)*(&131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&100401152) * &1 + (-- &50266112) * &0)) /\
  ((&667995680)*(-- &8986624)+(&43078582156170)*(-- &32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&100401152) * &0 + (-- &50266112) * &1 / &2)) /\
  (&667995680)*(&18073405)+(&43078582156170)*(&92351)+(&192152826362777) = (&41749465289)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&24879104) * x + (-- &8986624) * y <= &18073405 ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&100401152) * ((&1) * x + (&0) * y) / s pow 1 + (-- &50266112) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &667995680` [mpos] THEN
  note `&0:real < &43078582156170` [npos] THEN
  note `&0:real < &192152826362777` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&667995680)*(&24879104)+(&43078582156170)*(&131072))*s pow 1 = (&41749465289)*((&100401152) * &1 + (-- &50266112) * &0) /\ ((&667995680)*(-- &8986624)+(&43078582156170)*(-- &32768))*s pow 1 = (&41749465289)*((&100401152) * &0 + (-- &50266112) * &1 / &2) /\ (&667995680)*(&18073405)+(&43078582156170)*(&92351)+(&192152826362777) = (&41749465289)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &310200493900` in
let npos = REAL_ARITH `!s:real. &0:real < &29788432355` in
let ppos = REAL_ARITH `!s:real. &0:real < &2348215771965287` in
let qpos = REAL_ARITH `!s:real. &0:real < &683133737734` in
let mqrel = REAL_ARITH `
  ((&310200493900)*(&191823872)+(&29788432355)*(&9568256))*(&30902639 / &41749730) pow 1 = (&683133737734)*(((&64782336) * &1 + (-- &27295744) * &0)) /\
  ((&310200493900)*(-- &40435712)+(&29788432355)*(-- &1769472))*(&30902639 / &41749730) pow 1 = (&683133737734)*(((&64782336) * &0 + (-- &27295744) * &1 / &2)) /\
  (&310200493900)*(&133937273)+(&29788432355)*(&6651805)+(&2348215771965287) = (&683133737734)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&191823872) * x + (-- &40435712) * y <= &133937273 ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&64782336) * ((&1) * x + (&0) * y) / s pow 1 + (-- &27295744) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &310200493900` [mpos] THEN
  note `&0:real < &29788432355` [npos] THEN
  note `&0:real < &2348215771965287` [ppos] THEN
  note `&0:real < &683133737734` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&310200493900)*(&191823872)+(&29788432355)*(&9568256))*s pow 1 = (&683133737734)*((&64782336) * &1 + (-- &27295744) * &0) /\ ((&310200493900)*(-- &40435712)+(&29788432355)*(-- &1769472))*s pow 1 = (&683133737734)*((&64782336) * &0 + (-- &27295744) * &1 / &2) /\ (&310200493900)*(&133937273)+(&29788432355)*(&6651805)+(&2348215771965287) = (&683133737734)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &109363417735` in
let npos = REAL_ARITH `!s:real. &0:real < &146124055` in
let ppos = REAL_ARITH `!s:real. &0:real < &39572343963816` in
let qpos = REAL_ARITH `!s:real. &0:real < &59889314382` in
let mqrel = REAL_ARITH `
  ((&109363417735)*(&9568256)+(&146124055)*(&5767168))*(&30902639 / &41749730) pow 1 = (&59889314382)*(((&12943360) * &1 + (-- &4784128) * &0)) /\
  ((&109363417735)*(-- &1769472)+(&146124055)*(-- &196608))*(&30902639 / &41749730) pow 1 = (&59889314382)*(((&12943360) * &0 + (-- &4784128) * &1 / &2)) /\
  (&109363417735)*(&6651805)+(&146124055)*(&3914969)+(&39572343963816) = (&59889314382)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&12943360) * ((&1) * x + (&0) * y) / s pow 1 + (-- &4784128) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &109363417735` [mpos] THEN
  note `&0:real < &146124055` [npos] THEN
  note `&0:real < &39572343963816` [ppos] THEN
  note `&0:real < &59889314382` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&109363417735)*(&9568256)+(&146124055)*(&5767168))*s pow 1 = (&59889314382)*((&12943360) * &1 + (-- &4784128) * &0) /\ ((&109363417735)*(-- &1769472)+(&146124055)*(-- &196608))*s pow 1 = (&59889314382)*((&12943360) * &0 + (-- &4784128) * &1 / &2) /\ (&109363417735)*(&6651805)+(&146124055)*(&3914969)+(&39572343963816) = (&59889314382)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &4136959870835` in
let npos = REAL_ARITH `!s:real. &0:real < &235885974500` in
let ppos = REAL_ARITH `!s:real. &0:real < &1546264204615452` in
let qpos = REAL_ARITH `!s:real. &0:real < &29944657191` in
let mqrel = REAL_ARITH `
  ((&4136959870835)*(&9568256)+(&235885974500)*(&5767168))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((&1012072448) * &1 + (-- &364183552) * &0)) /\
  ((&4136959870835)*(-- &1769472)+(&235885974500)*(-- &196608))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((&1012072448) * &0 + (-- &364183552) * &1 / &2)) /\
  (&4136959870835)*(&6651805)+(&235885974500)*(&3914969)+(&1546264204615452) = (&29944657191)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&1012072448) * ((&1) * x + (&0) * y) / s pow 1 + (-- &364183552) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4136959870835` [mpos] THEN
  note `&0:real < &235885974500` [npos] THEN
  note `&0:real < &1546264204615452` [ppos] THEN
  note `&0:real < &29944657191` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4136959870835)*(&9568256)+(&235885974500)*(&5767168))*s pow 1 = (&29944657191)*((&1012072448) * &1 + (-- &364183552) * &0) /\ ((&4136959870835)*(-- &1769472)+(&235885974500)*(-- &196608))*s pow 1 = (&29944657191)*((&1012072448) * &0 + (-- &364183552) * &1 / &2) /\ (&4136959870835)*(&6651805)+(&235885974500)*(&3914969)+(&1546264204615452) = (&29944657191)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &772370005` in
let npos = REAL_ARITH `!s:real. &0:real < &146124055` in
let ppos = REAL_ARITH `!s:real. &0:real < &30259936037007` in
let qpos = REAL_ARITH `!s:real. &0:real < &1576034589` in
let mqrel = REAL_ARITH `
  ((&772370005)*(&9568256)+(&146124055)*(&5767168))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((&3866624) * &1 + (-- &1310720) * &0)) /\
  ((&772370005)*(-- &1769472)+(&146124055)*(-- &196608))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((&3866624) * &0 + (-- &1310720) * &1 / &2)) /\
  (&772370005)*(&6651805)+(&146124055)*(&3914969)+(&30259936037007) = (&1576034589)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&3866624) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1310720) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &772370005` [mpos] THEN
  note `&0:real < &146124055` [npos] THEN
  note `&0:real < &30259936037007` [ppos] THEN
  note `&0:real < &1576034589` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&772370005)*(&9568256)+(&146124055)*(&5767168))*s pow 1 = (&1576034589)*((&3866624) * &1 + (-- &1310720) * &0) /\ ((&772370005)*(-- &1769472)+(&146124055)*(-- &196608))*s pow 1 = (&1576034589)*((&3866624) * &0 + (-- &1310720) * &1 / &2) /\ (&772370005)*(&6651805)+(&146124055)*(&3914969)+(&30259936037007) = (&1576034589)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &8750054537455` in
let npos = REAL_ARITH `!s:real. &0:real < &647120815` in
let ppos = REAL_ARITH `!s:real. &0:real < &2666200250709339617` in
let qpos = REAL_ARITH `!s:real. &0:real < &959743259423` in
let mqrel = REAL_ARITH `
  ((&8750054537455)*(&5767168)+(&647120815)*(&413007872))*(&30902639 / &41749730) pow 1 = (&959743259423)*(((&39124992) * &1 + (-- &2621440) * &0)) /\
  ((&8750054537455)*(-- &196608)+(&647120815)*(&32178176))*(&30902639 / &41749730) pow 1 = (&959743259423)*(((&39124992) * &0 + (-- &2621440) * &1 / &2)) /\
  (&8750054537455)*(&3914969)+(&647120815)*(&275907781)+(&2666200250709339617) = (&959743259423)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&413007872) * x + (&32178176) * y <= &275907781 ==>
  (&39124992) * ((&1) * x + (&0) * y) / s pow 1 + (-- &2621440) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8750054537455` [mpos] THEN
  note `&0:real < &647120815` [npos] THEN
  note `&0:real < &2666200250709339617` [ppos] THEN
  note `&0:real < &959743259423` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&8750054537455)*(&5767168)+(&647120815)*(&413007872))*s pow 1 = (&959743259423)*((&39124992) * &1 + (-- &2621440) * &0) /\ ((&8750054537455)*(-- &196608)+(&647120815)*(&32178176))*s pow 1 = (&959743259423)*((&39124992) * &0 + (-- &2621440) * &1 / &2) /\ (&8750054537455)*(&3914969)+(&647120815)*(&275907781)+(&2666200250709339617) = (&959743259423)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &486238230445` in
let npos = REAL_ARITH `!s:real. &0:real < &145706557700` in
let ppos = REAL_ARITH `!s:real. &0:real < &19234074074758165041` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&486238230445)*(&413007872)+(&145706557700)*(&32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&5865472) * &1 + (&950272) * &0)) /\
  ((&486238230445)*(&32178176)+(&145706557700)*(&6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&5865472) * &0 + (&950272) * &1 / &2)) /\
  (&486238230445)*(&275907781)+(&145706557700)*(&21583161)+(&19234074074758165041) = (&25936399496866)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&413007872) * x + (&32178176) * y <= &275907781 ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&5865472) * ((&1) * x + (&0) * y) / s pow 1 + (&950272) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &486238230445` [mpos] THEN
  note `&0:real < &145706557700` [npos] THEN
  note `&0:real < &19234074074758165041` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&486238230445)*(&413007872)+(&145706557700)*(&32309248))*s pow 1 = (&25936399496866)*((&5865472) * &1 + (&950272) * &0) /\ ((&486238230445)*(&32178176)+(&145706557700)*(&6881280))*s pow 1 = (&25936399496866)*((&5865472) * &0 + (&950272) * &1 / &2) /\ (&486238230445)*(&275907781)+(&145706557700)*(&21583161)+(&19234074074758165041) = (&25936399496866)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &398730796365` in
let npos = REAL_ARITH `!s:real. &0:real < &471429768212920` in
let ppos = REAL_ARITH `!s:real. &0:real < &2176020743804103466653` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&398730796365)*(&413007872)+(&471429768212920)*(&32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&439386112) * &1 + (&185892864) * &0)) /\
  ((&398730796365)*(&32178176)+(&471429768212920)*(&6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&439386112) * &0 + (&185892864) * &1 / &2)) /\
  (&398730796365)*(&275907781)+(&471429768212920)*(&21583161)+(&2176020743804103466653) = (&25936399496866)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&413007872) * x + (&32178176) * y <= &275907781 ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&439386112) * ((&1) * x + (&0) * y) / s pow 1 + (&185892864) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &398730796365` [mpos] THEN
  note `&0:real < &471429768212920` [npos] THEN
  note `&0:real < &2176020743804103466653` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&398730796365)*(&413007872)+(&471429768212920)*(&32309248))*s pow 1 = (&25936399496866)*((&439386112) * &1 + (&185892864) * &0) /\ ((&398730796365)*(&32178176)+(&471429768212920)*(&6881280))*s pow 1 = (&25936399496866)*((&439386112) * &0 + (&185892864) * &1 / &2) /\ (&398730796365)*(&275907781)+(&471429768212920)*(&21583161)+(&2176020743804103466653) = (&25936399496866)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &1401079189070` in
let npos = REAL_ARITH `!s:real. &0:real < &3651097387960` in
let ppos = REAL_ARITH `!s:real. &0:real < &98344818934026119119` in
let qpos = REAL_ARITH `!s:real. &0:real < &8127733986029` in
let mqrel = REAL_ARITH `
  ((&1401079189070)*(&32309248)+(&3651097387960)*(&137199616))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((&49741824) * &1 + (&27000832) * &0)) /\
  ((&1401079189070)*(&6881280)+(&3651097387960)*(&37961728))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((&49741824) * &0 + (&27000832) * &1 / &2)) /\
  (&1401079189070)*(&21583161)+(&3651097387960)*(&91847345)+(&98344818934026119119) = (&8127733986029)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&137199616) * x + (&37961728) * y <= &91847345 ==>
  (&49741824) * ((&1) * x + (&0) * y) / s pow 1 + (&27000832) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1401079189070` [mpos] THEN
  note `&0:real < &3651097387960` [npos] THEN
  note `&0:real < &98344818934026119119` [ppos] THEN
  note `&0:real < &8127733986029` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1401079189070)*(&32309248)+(&3651097387960)*(&137199616))*s pow 1 = (&8127733986029)*((&49741824) * &1 + (&27000832) * &0) /\ ((&1401079189070)*(&6881280)+(&3651097387960)*(&37961728))*s pow 1 = (&8127733986029)*((&49741824) * &0 + (&27000832) * &1 / &2) /\ (&1401079189070)*(&21583161)+(&3651097387960)*(&91847345)+(&98344818934026119119) = (&8127733986029)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &576167148865` in
let npos = REAL_ARITH `!s:real. &0:real < &381738656255` in
let ppos = REAL_ARITH `!s:real. &0:real < &7843956818982354258` in
let qpos = REAL_ARITH `!s:real. &0:real < &734061286806` in
let mqrel = REAL_ARITH `
  ((&576167148865)*(&52412416)+(&381738656255)*(&7979008))*(&30902639 / &41749730) pow 1 = (&734061286806)*(((&33521664) * &1 + (&25640960) * &0)) /\
  ((&576167148865)*(&19972096)+(&381738656255)*(&3162112))*(&30902639 / &41749730) pow 1 = (&734061286806)*(((&33521664) * &0 + (&25640960) * &1 / &2)) /\
  (&576167148865)*(&36108393)+(&381738656255)*(&5552625)+(&7843956818982354258) = (&734061286806)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&52412416) * x + (&19972096) * y <= &36108393 ==>
  (&7979008) * x + (&3162112) * y <= &5552625 ==>
  (&33521664) * ((&1) * x + (&0) * y) / s pow 1 + (&25640960) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &576167148865` [mpos] THEN
  note `&0:real < &381738656255` [npos] THEN
  note `&0:real < &7843956818982354258` [ppos] THEN
  note `&0:real < &734061286806` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&576167148865)*(&52412416)+(&381738656255)*(&7979008))*s pow 1 = (&734061286806)*((&33521664) * &1 + (&25640960) * &0) /\ ((&576167148865)*(&19972096)+(&381738656255)*(&3162112))*s pow 1 = (&734061286806)*((&33521664) * &0 + (&25640960) * &1 / &2) /\ (&576167148865)*(&36108393)+(&381738656255)*(&5552625)+(&7843956818982354258) = (&734061286806)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &1297038861910` in
let npos = REAL_ARITH `!s:real. &0:real < &6533832745` in
let ppos = REAL_ARITH `!s:real. &0:real < &2688851509626771699` in
let qpos = REAL_ARITH `!s:real. &0:real < &4416481555324` in
let mqrel = REAL_ARITH `
  ((&1297038861910)*(&7979008)+(&6533832745)*(&121733120))*(&30902639 / &41749730) pow 1 = (&4416481555324)*(((&1867776) * &1 + (&1490944) * &0)) /\
  ((&1297038861910)*(&3162112)+(&6533832745)*(&53051392))*(&30902639 / &41749730) pow 1 = (&4416481555324)*(((&1867776) * &0 + (&1490944) * &1 / &2)) /\
  (&1297038861910)*(&5552625)+(&6533832745)*(&86950107)+(&2688851509626771699) = (&4416481555324)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7979008) * x + (&3162112) * y <= &5552625 ==>
  (&121733120) * x + (&53051392) * y <= &86950107 ==>
  (&1867776) * ((&1) * x + (&0) * y) / s pow 1 + (&1490944) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1297038861910` [mpos] THEN
  note `&0:real < &6533832745` [npos] THEN
  note `&0:real < &2688851509626771699` [ppos] THEN
  note `&0:real < &4416481555324` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1297038861910)*(&7979008)+(&6533832745)*(&121733120))*s pow 1 = (&4416481555324)*((&1867776) * &1 + (&1490944) * &0) /\ ((&1297038861910)*(&3162112)+(&6533832745)*(&53051392))*s pow 1 = (&4416481555324)*((&1867776) * &0 + (&1490944) * &1 / &2) /\ (&1297038861910)*(&5552625)+(&6533832745)*(&86950107)+(&2688851509626771699) = (&4416481555324)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &2911438296415` in
let npos = REAL_ARITH `!s:real. &0:real < &10986316200310` in
let ppos = REAL_ARITH `!s:real. &0:real < &473066114229036992963` in
let qpos = REAL_ARITH `!s:real. &0:real < &167210656728154` in
let mqrel = REAL_ARITH `
  ((&2911438296415)*(&121733120)+(&10986316200310)*(&124731392))*(&30902639 / &41749730) pow 1 = (&167210656728154)*(((&7634944) * &1 + (&7815168) * &0)) /\
  ((&2911438296415)*(&53051392)+(&10986316200310)*(&66289664))*(&30902639 / &41749730) pow 1 = (&167210656728154)*(((&7634944) * &0 + (&7815168) * &1 / &2)) /\
  (&2911438296415)*(&86950107)+(&10986316200310)*(&95315653)+(&473066114229036992963) = (&167210656728154)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&121733120) * x + (&53051392) * y <= &86950107 ==>
  (&124731392) * x + (&66289664) * y <= &95315653 ==>
  (&7634944) * ((&1) * x + (&0) * y) / s pow 1 + (&7815168) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2911438296415` [mpos] THEN
  note `&0:real < &10986316200310` [npos] THEN
  note `&0:real < &473066114229036992963` [ppos] THEN
  note `&0:real < &167210656728154` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2911438296415)*(&121733120)+(&10986316200310)*(&124731392))*s pow 1 = (&167210656728154)*((&7634944) * &1 + (&7815168) * &0) /\ ((&2911438296415)*(&53051392)+(&10986316200310)*(&66289664))*s pow 1 = (&167210656728154)*((&7634944) * &0 + (&7815168) * &1 / &2) /\ (&2911438296415)*(&86950107)+(&10986316200310)*(&95315653)+(&473066114229036992963) = (&167210656728154)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &1008172480040` in
let npos = REAL_ARITH `!s:real. &0:real < &1168178320265` in
let ppos = REAL_ARITH `!s:real. &0:real < &93103023383130437121` in
let qpos = REAL_ARITH `!s:real. &0:real < &248820261762972` in
let mqrel = REAL_ARITH `
  ((&1008172480040)*(&124731392)+(&1168178320265)*(&165806080))*(&30902639 / &41749730) pow 1 = (&248820261762972)*(((&950272) * &1 + (&1130496) * &0)) /\
  ((&1008172480040)*(&66289664)+(&1168178320265)*(&105447424))*(&30902639 / &41749730) pow 1 = (&248820261762972)*(((&950272) * &0 + (&1130496) * &1 / &2)) /\
  (&1008172480040)*(&95315653)+(&1168178320265)*(&137755571)+(&93103023383130437121) = (&248820261762972)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&124731392) * x + (&66289664) * y <= &95315653 ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&950272) * ((&1) * x + (&0) * y) / s pow 1 + (&1130496) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1008172480040` [mpos] THEN
  note `&0:real < &1168178320265` [npos] THEN
  note `&0:real < &93103023383130437121` [ppos] THEN
  note `&0:real < &248820261762972` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1008172480040)*(&124731392)+(&1168178320265)*(&165806080))*s pow 1 = (&248820261762972)*((&950272) * &1 + (&1130496) * &0) /\ ((&1008172480040)*(&66289664)+(&1168178320265)*(&105447424))*s pow 1 = (&248820261762972)*((&950272) * &0 + (&1130496) * &1 / &2) /\ (&1008172480040)*(&95315653)+(&1168178320265)*(&137755571)+(&93103023383130437121) = (&248820261762972)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &56920412889560` in
let npos = REAL_ARITH `!s:real. &0:real < &179303901422360` in
let ppos = REAL_ARITH `!s:real. &0:real < &10875863458723443926919` in
let qpos = REAL_ARITH `!s:real. &0:real < &62205065440743` in
let mqrel = REAL_ARITH `
  ((&56920412889560)*(&124731392)+(&179303901422360)*(&165806080))*(&30902639 / &41749730) pow 1 = (&62205065440743)*(((&438239232) * &1 + (&539754496) * &0)) /\
  ((&56920412889560)*(&66289664)+(&179303901422360)*(&105447424))*(&30902639 / &41749730) pow 1 = (&62205065440743)*(((&438239232) * &0 + (&539754496) * &1 / &2)) /\
  (&56920412889560)*(&95315653)+(&179303901422360)*(&137755571)+(&10875863458723443926919) = (&62205065440743)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&124731392) * x + (&66289664) * y <= &95315653 ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&438239232) * ((&1) * x + (&0) * y) / s pow 1 + (&539754496) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &56920412889560` [mpos] THEN
  note `&0:real < &179303901422360` [npos] THEN
  note `&0:real < &10875863458723443926919` [ppos] THEN
  note `&0:real < &62205065440743` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&56920412889560)*(&124731392)+(&179303901422360)*(&165806080))*s pow 1 = (&62205065440743)*((&438239232) * &1 + (&539754496) * &0) /\ ((&56920412889560)*(&66289664)+(&179303901422360)*(&105447424))*s pow 1 = (&62205065440743)*((&438239232) * &0 + (&539754496) * &1 / &2) /\ (&56920412889560)*(&95315653)+(&179303901422360)*(&137755571)+(&10875863458723443926919) = (&62205065440743)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &25801333140` in
let npos = REAL_ARITH `!s:real. &0:real < &121199466190` in
let ppos = REAL_ARITH `!s:real. &0:real < &2160596266490378027` in
let qpos = REAL_ARITH `!s:real. &0:real < &399231193241` in
let mqrel = REAL_ARITH `
  ((&25801333140)*(&165806080)+(&121199466190)*(&22740992))*(&30902639 / &41749730) pow 1 = (&399231193241)*(((&13041664) * &1 + (&17039360) * &0)) /\
  ((&25801333140)*(&105447424)+(&121199466190)*(&15466496))*(&30902639 / &41749730) pow 1 = (&399231193241)*(((&13041664) * &0 + (&17039360) * &1 / &2)) /\
  (&25801333140)*(&137755571)+(&121199466190)*(&19572823)+(&2160596266490378027) = (&399231193241)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&22740992) * x + (&15466496) * y <= &19572823 ==>
  (&13041664) * ((&1) * x + (&0) * y) / s pow 1 + (&17039360) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &25801333140` [mpos] THEN
  note `&0:real < &121199466190` [npos] THEN
  note `&0:real < &2160596266490378027` [ppos] THEN
  note `&0:real < &399231193241` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&25801333140)*(&165806080)+(&121199466190)*(&22740992))*s pow 1 = (&399231193241)*((&13041664) * &1 + (&17039360) * &0) /\ ((&25801333140)*(&105447424)+(&121199466190)*(&15466496))*s pow 1 = (&399231193241)*((&13041664) * &0 + (&17039360) * &1 / &2) /\ (&25801333140)*(&137755571)+(&121199466190)*(&19572823)+(&2160596266490378027) = (&399231193241)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &541723621615` in
let npos = REAL_ARITH `!s:real. &0:real < &136897364670` in
let ppos = REAL_ARITH `!s:real. &0:real < &915971212490356745` in
let qpos = REAL_ARITH `!s:real. &0:real < &259458557044` in
let mqrel = REAL_ARITH `
  ((&541723621615)*(&3604480)+(&136897364670)*(&5537792))*(&30902639 / &41749730) pow 1 = (&259458557044)*(((&7733248) * &1 + (&11943936) * &0)) /\
  ((&541723621615)*(&2555904)+(&136897364670)*(&5177344))*(&30902639 / &41749730) pow 1 = (&259458557044)*(((&7733248) * &0 + (&11943936) * &1 / &2)) /\
  (&541723621615)*(&3177943)+(&136897364670)*(&5799491)+(&915971212490356745) = (&259458557044)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3604480) * x + (&2555904) * y <= &3177943 ==>
  (&5537792) * x + (&5177344) * y <= &5799491 ==>
  (&7733248) * ((&1) * x + (&0) * y) / s pow 1 + (&11943936) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &541723621615` [mpos] THEN
  note `&0:real < &136897364670` [npos] THEN
  note `&0:real < &915971212490356745` [ppos] THEN
  note `&0:real < &259458557044` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&541723621615)*(&3604480)+(&136897364670)*(&5537792))*s pow 1 = (&259458557044)*((&7733248) * &1 + (&11943936) * &0) /\ ((&541723621615)*(&2555904)+(&136897364670)*(&5177344))*s pow 1 = (&259458557044)*((&7733248) * &0 + (&11943936) * &1 / &2) /\ (&541723621615)*(&3177943)+(&136897364670)*(&5799491)+(&915971212490356745) = (&259458557044)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &3367449722340` in
let npos = REAL_ARITH `!s:real. &0:real < &308718378485` in
let ppos = REAL_ARITH `!s:real. &0:real < &47046584603706587609` in
let qpos = REAL_ARITH `!s:real. &0:real < &89111838704848` in
let mqrel = REAL_ARITH `
  ((&3367449722340)*(&5537792)+(&308718378485)*(&289406976))*(&30902639 / &41749730) pow 1 = (&89111838704848)*(((&897024) * &1 + (&2035712) * &0)) /\
  ((&3367449722340)*(&5177344)+(&308718378485)*(&340459520))*(&30902639 / &41749730) pow 1 = (&89111838704848)*(((&897024) * &0 + (&2035712) * &1 / &2)) /\
  (&3367449722340)*(&5799491)+(&308718378485)*(&355053887)+(&47046584603706587609) = (&89111838704848)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5537792) * x + (&5177344) * y <= &5799491 ==>
  (&289406976) * x + (&340459520) * y <= &355053887 ==>
  (&897024) * ((&1) * x + (&0) * y) / s pow 1 + (&2035712) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3367449722340` [mpos] THEN
  note `&0:real < &308718378485` [npos] THEN
  note `&0:real < &47046584603706587609` [ppos] THEN
  note `&0:real < &89111838704848` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3367449722340)*(&5537792)+(&308718378485)*(&289406976))*s pow 1 = (&89111838704848)*((&897024) * &1 + (&2035712) * &0) /\ ((&3367449722340)*(&5177344)+(&308718378485)*(&340459520))*s pow 1 = (&89111838704848)*((&897024) * &0 + (&2035712) * &1 / &2) /\ (&3367449722340)*(&5799491)+(&308718378485)*(&355053887)+(&47046584603706587609) = (&89111838704848)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &2784287595985` in
let npos = REAL_ARITH `!s:real. &0:real < &217426900695` in
let ppos = REAL_ARITH `!s:real. &0:real < &51440170729778959700` in
let qpos = REAL_ARITH `!s:real. &0:real < &50603194973056` in
let mqrel = REAL_ARITH `
  ((&2784287595985)*(&26116096)+(&217426900695)*(&66748416))*(&30902639 / &41749730) pow 1 = (&50603194973056)*(((&1275904) * &1 + (&4450304) * &0)) /\
  ((&2784287595985)*(&42532864)+(&217426900695)*(&154992640))*(&30902639 / &41749730) pow 1 = (&50603194973056)*(((&1275904) * &0 + (&4450304) * &1 / &2)) /\
  (&2784287595985)*(&41635449)+(&217426900695)*(&144601685)+(&51440170729778959700) = (&50603194973056)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&26116096) * x + (&42532864) * y <= &41635449 ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&1275904) * ((&1) * x + (&0) * y) / s pow 1 + (&4450304) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2784287595985` [mpos] THEN
  note `&0:real < &217426900695` [npos] THEN
  note `&0:real < &51440170729778959700` [ppos] THEN
  note `&0:real < &50603194973056` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2784287595985)*(&26116096)+(&217426900695)*(&66748416))*s pow 1 = (&50603194973056)*((&1275904) * &1 + (&4450304) * &0) /\ ((&2784287595985)*(&42532864)+(&217426900695)*(&154992640))*s pow 1 = (&50603194973056)*((&1275904) * &0 + (&4450304) * &1 / &2) /\ (&2784287595985)*(&41635449)+(&217426900695)*(&144601685)+(&51440170729778959700) = (&50603194973056)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &102345667665` in
let npos = REAL_ARITH `!s:real. &0:real < &101544831935` in
let ppos = REAL_ARITH `!s:real. &0:real < &6483245802990512644` in
let qpos = REAL_ARITH `!s:real. &0:real < &3162699685816` in
let mqrel = REAL_ARITH `
  ((&102345667665)*(&26116096)+(&101544831935)*(&66748416))*(&30902639 / &41749730) pow 1 = (&3162699685816)*(((&2211840) * &1 + (&9404416) * &0)) /\
  ((&102345667665)*(&42532864)+(&101544831935)*(&154992640))*(&30902639 / &41749730) pow 1 = (&3162699685816)*(((&2211840) * &0 + (&9404416) * &1 / &2)) /\
  (&102345667665)*(&41635449)+(&101544831935)*(&144601685)+(&6483245802990512644) = (&3162699685816)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&26116096) * x + (&42532864) * y <= &41635449 ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&2211840) * ((&1) * x + (&0) * y) / s pow 1 + (&9404416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &102345667665` [mpos] THEN
  note `&0:real < &101544831935` [npos] THEN
  note `&0:real < &6483245802990512644` [ppos] THEN
  note `&0:real < &3162699685816` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&102345667665)*(&26116096)+(&101544831935)*(&66748416))*s pow 1 = (&3162699685816)*((&2211840) * &1 + (&9404416) * &0) /\ ((&102345667665)*(&42532864)+(&101544831935)*(&154992640))*s pow 1 = (&3162699685816)*((&2211840) * &0 + (&9404416) * &1 / &2) /\ (&102345667665)*(&41635449)+(&101544831935)*(&144601685)+(&6483245802990512644) = (&3162699685816)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &476957265466` in
let npos = REAL_ARITH `!s:real. &0:real < &561258320282` in
let ppos = REAL_ARITH `!s:real. &0:real < &26248422423917354605` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&476957265466)*(&66748416)+(&561258320282)*(&3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&7733248) * &1 + (&38076416) * &0)) /\
  ((&476957265466)*(&154992640)+(&561258320282)*(&17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&7733248) * &0 + (&38076416) * &1 / &2)) /\
  (&476957265466)*(&144601685)+(&561258320282)*(&15704445)+(&26248422423917354605) = (&3256674611015)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (&7733248) * ((&1) * x + (&0) * y) / s pow 1 + (&38076416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &476957265466` [mpos] THEN
  note `&0:real < &561258320282` [npos] THEN
  note `&0:real < &26248422423917354605` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&476957265466)*(&66748416)+(&561258320282)*(&3899392))*s pow 1 = (&3256674611015)*((&7733248) * &1 + (&38076416) * &0) /\ ((&476957265466)*(&154992640)+(&561258320282)*(&17530880))*s pow 1 = (&3256674611015)*((&7733248) * &0 + (&38076416) * &1 / &2) /\ (&476957265466)*(&144601685)+(&561258320282)*(&15704445)+(&26248422423917354605) = (&3256674611015)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &3466354832710` in
let npos = REAL_ARITH `!s:real. &0:real < &1448861755055` in
let ppos = REAL_ARITH `!s:real. &0:real < &47042428248299204428` in
let qpos = REAL_ARITH `!s:real. &0:real < &5124491917453` in
let mqrel = REAL_ARITH `
  ((&3466354832710)*(&3899392)+(&1448861755055)*(&65536))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((&1966080) * &1 + (&55902208) * &0)) /\
  ((&3466354832710)*(&17530880)+(&1448861755055)*(&91619328))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((&1966080) * &0 + (&55902208) * &1 / &2)) /\
  (&3466354832710)*(&15704445)+(&1448861755055)*(&79611463)+(&47042428248299204428) = (&5124491917453)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (&65536) * x + (&91619328) * y <= &79611463 ==>
  (&1966080) * ((&1) * x + (&0) * y) / s pow 1 + (&55902208) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3466354832710` [mpos] THEN
  note `&0:real < &1448861755055` [npos] THEN
  note `&0:real < &47042428248299204428` [ppos] THEN
  note `&0:real < &5124491917453` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3466354832710)*(&3899392)+(&1448861755055)*(&65536))*s pow 1 = (&5124491917453)*((&1966080) * &1 + (&55902208) * &0) /\ ((&3466354832710)*(&17530880)+(&1448861755055)*(&91619328))*s pow 1 = (&5124491917453)*((&1966080) * &0 + (&55902208) * &1 / &2) /\ (&3466354832710)*(&15704445)+(&1448861755055)*(&79611463)+(&47042428248299204428) = (&5124491917453)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &222964433065` in
let npos = REAL_ARITH `!s:real. &0:real < &26836225447240` in
let ppos = REAL_ARITH `!s:real. &0:real < &73151055017574218254` in
let qpos = REAL_ARITH `!s:real. &0:real < &3736098152461` in
let mqrel = REAL_ARITH `
  ((&222964433065)*(-- &129499136)+(&26836225447240)*(-- &1130496))*(&30902639 / &41749730) pow 1 = (&3736098152461)*(((-- &11730944) * &1 + (&156696576) * &0)) /\
  ((&222964433065)*(&923729920)+(&26836225447240)*(&7061504))*(&30902639 / &41749730) pow 1 = (&3736098152461)*(((-- &11730944) * &0 + (&156696576) * &1 / &2)) /\
  (&222964433065)*(&791274703)+(&26836225447240)*(&6069771)+(&73151055017574218254) = (&3736098152461)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &129499136) * x + (&923729920) * y <= &791274703 ==>
  (-- &1130496) * x + (&7061504) * y <= &6069771 ==>
  (-- &11730944) * ((&1) * x + (&0) * y) / s pow 1 + (&156696576) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &222964433065` [mpos] THEN
  note `&0:real < &26836225447240` [npos] THEN
  note `&0:real < &73151055017574218254` [ppos] THEN
  note `&0:real < &3736098152461` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&222964433065)*(-- &129499136)+(&26836225447240)*(-- &1130496))*s pow 1 = (&3736098152461)*((-- &11730944) * &1 + (&156696576) * &0) /\ ((&222964433065)*(&923729920)+(&26836225447240)*(&7061504))*s pow 1 = (&3736098152461)*((-- &11730944) * &0 + (&156696576) * &1 / &2) /\ (&222964433065)*(&791274703)+(&26836225447240)*(&6069771)+(&73151055017574218254) = (&3736098152461)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &3658862837740` in
let npos = REAL_ARITH `!s:real. &0:real < &117164438284960` in
let ppos = REAL_ARITH `!s:real. &0:real < &13131825496118412027` in
let qpos = REAL_ARITH `!s:real. &0:real < &1970012333611` in
let mqrel = REAL_ARITH `
  ((&3658862837740)*(-- &1130496)+(&117164438284960)*(-- &481280))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((-- &22740992) * &1 + (&117506048) * &0)) /\
  ((&3658862837740)*(&7061504)+(&117164438284960)*(&1114112))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((-- &22740992) * &0 + (&117506048) * &1 / &2)) /\
  (&3658862837740)*(&6069771)+(&117164438284960)*(&1004531)+(&13131825496118412027) = (&1970012333611)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1130496) * x + (&7061504) * y <= &6069771 ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &22740992) * ((&1) * x + (&0) * y) / s pow 1 + (&117506048) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3658862837740` [mpos] THEN
  note `&0:real < &117164438284960` [npos] THEN
  note `&0:real < &13131825496118412027` [ppos] THEN
  note `&0:real < &1970012333611` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3658862837740)*(-- &1130496)+(&117164438284960)*(-- &481280))*s pow 1 = (&1970012333611)*((-- &22740992) * &1 + (&117506048) * &0) /\ ((&3658862837740)*(&7061504)+(&117164438284960)*(&1114112))*s pow 1 = (&1970012333611)*((-- &22740992) * &0 + (&117506048) * &1 / &2) /\ (&3658862837740)*(&6069771)+(&117164438284960)*(&1004531)+(&13131825496118412027) = (&1970012333611)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &1252705491618680` in
let npos = REAL_ARITH `!s:real. &0:real < &6403761461185` in
let ppos = REAL_ARITH `!s:real. &0:real < &79153741761771282372` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&1252705491618680)*(-- &481280)+(&6403761461185)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &166330368) * &1 + (&684523520) * &0)) /\
  ((&1252705491618680)*(&1114112)+(&6403761461185)*(&66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &166330368) * &0 + (&684523520) * &1 / &2)) /\
  (&1252705491618680)*(&1004531)+(&6403761461185)*(&62719715)+(&79153741761771282372) = (&3943145833761)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &166330368) * ((&1) * x + (&0) * y) / s pow 1 + (&684523520) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1252705491618680` [mpos] THEN
  note `&0:real < &6403761461185` [npos] THEN
  note `&0:real < &79153741761771282372` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1252705491618680)*(-- &481280)+(&6403761461185)*(-- &44220416))*s pow 1 = (&3943145833761)*((-- &166330368) * &1 + (&684523520) * &0) /\ ((&1252705491618680)*(&1114112)+(&6403761461185)*(&66781184))*s pow 1 = (&3943145833761)*((-- &166330368) * &0 + (&684523520) * &1 / &2) /\ (&1252705491618680)*(&1004531)+(&6403761461185)*(&62719715)+(&79153741761771282372) = (&3943145833761)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &229180299866320` in
let npos = REAL_ARITH `!s:real. &0:real < &1587449983790` in
let ppos = REAL_ARITH `!s:real. &0:real < &14238654735213448623` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&229180299866320)*(-- &481280)+(&1587449983790)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &33882112) * &1 + (&135659520) * &0)) /\
  ((&229180299866320)*(&1114112)+(&1587449983790)*(&66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &33882112) * &0 + (&135659520) * &1 / &2)) /\
  (&229180299866320)*(&1004531)+(&1587449983790)*(&62719715)+(&14238654735213448623) = (&3943145833761)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &33882112) * ((&1) * x + (&0) * y) / s pow 1 + (&135659520) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &229180299866320` [mpos] THEN
  note `&0:real < &1587449983790` [npos] THEN
  note `&0:real < &14238654735213448623` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&229180299866320)*(-- &481280)+(&1587449983790)*(-- &44220416))*s pow 1 = (&3943145833761)*((-- &33882112) * &1 + (&135659520) * &0) /\ ((&229180299866320)*(&1114112)+(&1587449983790)*(&66781184))*s pow 1 = (&3943145833761)*((-- &33882112) * &0 + (&135659520) * &1 / &2) /\ (&229180299866320)*(&1004531)+(&1587449983790)*(&62719715)+(&14238654735213448623) = (&3943145833761)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &50519010288120` in
let npos = REAL_ARITH `!s:real. &0:real < &1484474274745` in
let ppos = REAL_ARITH `!s:real. &0:real < &2765570842377111800` in
let qpos = REAL_ARITH `!s:real. &0:real < &1314381944587` in
let mqrel = REAL_ARITH `
  ((&50519010288120)*(-- &481280)+(&1484474274745)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((-- &50659328) * &1 + (&175046656) * &0)) /\
  ((&50519010288120)*(&1114112)+(&1484474274745)*(&66781184))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((-- &50659328) * &0 + (&175046656) * &1 / &2)) /\
  (&50519010288120)*(&1004531)+(&1484474274745)*(&62719715)+(&2765570842377111800) = (&1314381944587)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &50659328) * ((&1) * x + (&0) * y) / s pow 1 + (&175046656) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &50519010288120` [mpos] THEN
  note `&0:real < &1484474274745` [npos] THEN
  note `&0:real < &2765570842377111800` [ppos] THEN
  note `&0:real < &1314381944587` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&50519010288120)*(-- &481280)+(&1484474274745)*(-- &44220416))*s pow 1 = (&1314381944587)*((-- &50659328) * &1 + (&175046656) * &0) /\ ((&50519010288120)*(&1114112)+(&1484474274745)*(&66781184))*s pow 1 = (&1314381944587)*((-- &50659328) * &0 + (&175046656) * &1 / &2) /\ (&50519010288120)*(&1004531)+(&1484474274745)*(&62719715)+(&2765570842377111800) = (&1314381944587)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &11528102446520` in
let npos = REAL_ARITH `!s:real. &0:real < &1200910108585` in
let ppos = REAL_ARITH `!s:real. &0:real < &492343763557267980` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&11528102446520)*(-- &481280)+(&1200910108585)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &11010048) * &1 + (&34930688) * &0)) /\
  ((&11528102446520)*(&1114112)+(&1200910108585)*(&66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &11010048) * &0 + (&34930688) * &1 / &2)) /\
  (&11528102446520)*(&1004531)+(&1200910108585)*(&62719715)+(&492343763557267980) = (&3943145833761)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &11010048) * ((&1) * x + (&0) * y) / s pow 1 + (&34930688) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11528102446520` [mpos] THEN
  note `&0:real < &1200910108585` [npos] THEN
  note `&0:real < &492343763557267980` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&11528102446520)*(-- &481280)+(&1200910108585)*(-- &44220416))*s pow 1 = (&3943145833761)*((-- &11010048) * &1 + (&34930688) * &0) /\ ((&11528102446520)*(&1114112)+(&1200910108585)*(&66781184))*s pow 1 = (&3943145833761)*((-- &11010048) * &0 + (&34930688) * &1 / &2) /\ (&11528102446520)*(&1004531)+(&1200910108585)*(&62719715)+(&492343763557267980) = (&3943145833761)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &104406555791560` in
let npos = REAL_ARITH `!s:real. &0:real < &16438183817495` in
let ppos = REAL_ARITH `!s:real. &0:real < &3635023617110421918` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&104406555791560)*(-- &481280)+(&16438183817495)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &145883136) * &1 + (&455802880) * &0)) /\
  ((&104406555791560)*(&1114112)+(&16438183817495)*(&66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &145883136) * &0 + (&455802880) * &1 / &2)) /\
  (&104406555791560)*(&1004531)+(&16438183817495)*(&62719715)+(&3635023617110421918) = (&3943145833761)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &145883136) * ((&1) * x + (&0) * y) / s pow 1 + (&455802880) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &104406555791560` [mpos] THEN
  note `&0:real < &16438183817495` [npos] THEN
  note `&0:real < &3635023617110421918` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&104406555791560)*(-- &481280)+(&16438183817495)*(-- &44220416))*s pow 1 = (&3943145833761)*((-- &145883136) * &1 + (&455802880) * &0) /\ ((&104406555791560)*(&1114112)+(&16438183817495)*(&66781184))*s pow 1 = (&3943145833761)*((-- &145883136) * &0 + (&455802880) * &1 / &2) /\ (&104406555791560)*(&1004531)+(&16438183817495)*(&62719715)+(&3635023617110421918) = (&3943145833761)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &52604659800` in
let npos = REAL_ARITH `!s:real. &0:real < &277072083145` in
let ppos = REAL_ARITH `!s:real. &0:real < &55299681002801595` in
let qpos = REAL_ARITH `!s:real. &0:real < &2628763889174` in
let mqrel = REAL_ARITH `
  ((&52604659800)*(-- &481280)+(&277072083145)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&2628763889174)*(((-- &3457024) * &1 + (&10452992) * &0)) /\
  ((&52604659800)*(&1114112)+(&277072083145)*(&66781184))*(&30902639 / &41749730) pow 1 = (&2628763889174)*(((-- &3457024) * &0 + (&10452992) * &1 / &2)) /\
  (&52604659800)*(&1004531)+(&277072083145)*(&62719715)+(&55299681002801595) = (&2628763889174)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &3457024) * ((&1) * x + (&0) * y) / s pow 1 + (&10452992) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &52604659800` [mpos] THEN
  note `&0:real < &277072083145` [npos] THEN
  note `&0:real < &55299681002801595` [ppos] THEN
  note `&0:real < &2628763889174` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&52604659800)*(-- &481280)+(&277072083145)*(-- &44220416))*s pow 1 = (&2628763889174)*((-- &3457024) * &1 + (&10452992) * &0) /\ ((&52604659800)*(&1114112)+(&277072083145)*(&66781184))*s pow 1 = (&2628763889174)*((-- &3457024) * &0 + (&10452992) * &1 / &2) /\ (&52604659800)*(&1004531)+(&277072083145)*(&62719715)+(&55299681002801595) = (&2628763889174)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &3401049905044` in
let npos = REAL_ARITH `!s:real. &0:real < &904052828393` in
let qpos = REAL_ARITH `!s:real. &0:real < &2780341333469` in
let mqrel = REAL_ARITH `
  ((&3401049905044)*(-- &44220416)+(&904052828393)*(-- &75169792))*(&30902639 / &41749730) pow 1 = (&2780341333469)*(((-- &58130432) * &1 + (&162430976) * &0)) /\
  ((&3401049905044)*(&66781184)+(&904052828393)*(&86212608))*(&30902639 / &41749730) pow 1 = (&2780341333469)*(((-- &58130432) * &0 + (&162430976) * &1 / &2)) /\
  (&3401049905044)*(&62719715)+(&904052828393)*(&85043005)+(&0) = (&2780341333469)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &75169792) * x + (&86212608) * y <= &85043005 ==>
  (-- &58130432) * ((&1) * x + (&0) * y) / s pow 1 + (&162430976) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3401049905044` [mpos] THEN
  note `&0:real < &904052828393` [npos] THEN
  real_linear `&0:real <= &0` THEN
  note `&0:real < &2780341333469` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3401049905044)*(-- &44220416)+(&904052828393)*(-- &75169792))*s pow 1 = (&2780341333469)*((-- &58130432) * &1 + (&162430976) * &0) /\ ((&3401049905044)*(&66781184)+(&904052828393)*(&86212608))*s pow 1 = (&2780341333469)*((-- &58130432) * &0 + (&162430976) * &1 / &2) /\ (&3401049905044)*(&62719715)+(&904052828393)*(&85043005)+(&0) = (&2780341333469)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &2131874812936` in
let npos = REAL_ARITH `!s:real. &0:real < &9115485749172` in
let ppos = REAL_ARITH `!s:real. &0:real < &34718723327843935` in
let qpos = REAL_ARITH `!s:real. &0:real < &1985958095335` in
let mqrel = REAL_ARITH `
  ((&2131874812936)*(-- &44220416)+(&9115485749172)*(-- &75169792))*(&30902639 / &41749730) pow 1 = (&1985958095335)*(((-- &290521088) * &1 + (&691929088) * &0)) /\
  ((&2131874812936)*(&66781184)+(&9115485749172)*(&86212608))*(&30902639 / &41749730) pow 1 = (&1985958095335)*(((-- &290521088) * &0 + (&691929088) * &1 / &2)) /\
  (&2131874812936)*(&62719715)+(&9115485749172)*(&85043005)+(&34718723327843935) = (&1985958095335)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &75169792) * x + (&86212608) * y <= &85043005 ==>
  (-- &290521088) * ((&1) * x + (&0) * y) / s pow 1 + (&691929088) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2131874812936` [mpos] THEN
  note `&0:real < &9115485749172` [npos] THEN
  note `&0:real < &34718723327843935` [ppos] THEN
  note `&0:real < &1985958095335` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2131874812936)*(-- &44220416)+(&9115485749172)*(-- &75169792))*s pow 1 = (&1985958095335)*((-- &290521088) * &1 + (&691929088) * &0) /\ ((&2131874812936)*(&66781184)+(&9115485749172)*(&86212608))*s pow 1 = (&1985958095335)*((-- &290521088) * &0 + (&691929088) * &1 / &2) /\ (&2131874812936)*(&62719715)+(&9115485749172)*(&85043005)+(&34718723327843935) = (&1985958095335)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &12845118554235` in
let npos = REAL_ARITH `!s:real. &0:real < &18723167415260` in
let ppos = REAL_ARITH `!s:real. &0:real < &171468923700419913` in
let qpos = REAL_ARITH `!s:real. &0:real < &158185541008204` in
let mqrel = REAL_ARITH `
  ((&12845118554235)*(-- &75169792)+(&18723167415260)*(-- &113278976))*(&30902639 / &41749730) pow 1 = (&158185541008204)*(((-- &14442496) * &1 + (&29925376) * &0)) /\
  ((&12845118554235)*(&86212608)+(&18723167415260)*(&111640576))*(&30902639 / &41749730) pow 1 = (&158185541008204)*(((-- &14442496) * &0 + (&29925376) * &1 / &2)) /\
  (&12845118554235)*(&85043005)+(&18723167415260)*(&116276001)+(&171468923700419913) = (&158185541008204)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &75169792) * x + (&86212608) * y <= &85043005 ==>
  (-- &113278976) * x + (&111640576) * y <= &116276001 ==>
  (-- &14442496) * ((&1) * x + (&0) * y) / s pow 1 + (&29925376) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12845118554235` [mpos] THEN
  note `&0:real < &18723167415260` [npos] THEN
  note `&0:real < &171468923700419913` [ppos] THEN
  note `&0:real < &158185541008204` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12845118554235)*(-- &75169792)+(&18723167415260)*(-- &113278976))*s pow 1 = (&158185541008204)*((-- &14442496) * &1 + (&29925376) * &0) /\ ((&12845118554235)*(&86212608)+(&18723167415260)*(&111640576))*s pow 1 = (&158185541008204)*((-- &14442496) * &0 + (&29925376) * &1 / &2) /\ (&12845118554235)*(&85043005)+(&18723167415260)*(&116276001)+(&171468923700419913) = (&158185541008204)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &2104917012275` in
let npos = REAL_ARITH `!s:real. &0:real < &243526175090` in
let ppos = REAL_ARITH `!s:real. &0:real < &10763544102416439` in
let qpos = REAL_ARITH `!s:real. &0:real < &9366466270344` in
let mqrel = REAL_ARITH `
  ((&2104917012275)*(-- &113278976)+(&243526175090)*(-- &11419648))*(&30902639 / &41749730) pow 1 = (&9366466270344)*(((-- &19062784) * &1 + (&37560320) * &0)) /\
  ((&2104917012275)*(&111640576)+(&243526175090)*(&10895360))*(&30902639 / &41749730) pow 1 = (&9366466270344)*(((-- &19062784) * &0 + (&37560320) * &1 / &2)) /\
  (&2104917012275)*(&116276001)+(&243526175090)*(&11507295)+(&10763544102416439) = (&9366466270344)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &113278976) * x + (&111640576) * y <= &116276001 ==>
  (-- &11419648) * x + (&10895360) * y <= &11507295 ==>
  (-- &19062784) * ((&1) * x + (&0) * y) / s pow 1 + (&37560320) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2104917012275` [mpos] THEN
  note `&0:real < &243526175090` [npos] THEN
  note `&0:real < &10763544102416439` [ppos] THEN
  note `&0:real < &9366466270344` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2104917012275)*(-- &113278976)+(&243526175090)*(-- &11419648))*s pow 1 = (&9366466270344)*((-- &19062784) * &1 + (&37560320) * &0) /\ ((&2104917012275)*(&111640576)+(&243526175090)*(&10895360))*s pow 1 = (&9366466270344)*((-- &19062784) * &0 + (&37560320) * &1 / &2) /\ (&2104917012275)*(&116276001)+(&243526175090)*(&11507295)+(&10763544102416439) = (&9366466270344)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &20874865` in
let npos = REAL_ARITH `!s:real. &0:real < &24507091510` in
let ppos = REAL_ARITH `!s:real. &0:real < &12379571134863` in
let qpos = REAL_ARITH `!s:real. &0:real < &13535355882` in
let mqrel = REAL_ARITH `
  ((&20874865)*(-- &113278976)+(&24507091510)*(-- &11419648))*(&30902639 / &41749730) pow 1 = (&13535355882)*(((-- &15433728) * &1 + (&29458432) * &0)) /\
  ((&20874865)*(&111640576)+(&24507091510)*(&10895360))*(&30902639 / &41749730) pow 1 = (&13535355882)*(((-- &15433728) * &0 + (&29458432) * &1 / &2)) /\
  (&20874865)*(&116276001)+(&24507091510)*(&11507295)+(&12379571134863) = (&13535355882)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &113278976) * x + (&111640576) * y <= &116276001 ==>
  (-- &11419648) * x + (&10895360) * y <= &11507295 ==>
  (-- &15433728) * ((&1) * x + (&0) * y) / s pow 1 + (&29458432) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20874865` [mpos] THEN
  note `&0:real < &24507091510` [npos] THEN
  note `&0:real < &12379571134863` [ppos] THEN
  note `&0:real < &13535355882` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&20874865)*(-- &113278976)+(&24507091510)*(-- &11419648))*s pow 1 = (&13535355882)*((-- &15433728) * &1 + (&29458432) * &0) /\ ((&20874865)*(&111640576)+(&24507091510)*(&10895360))*s pow 1 = (&13535355882)*((-- &15433728) * &0 + (&29458432) * &1 / &2) /\ (&20874865)*(&116276001)+(&24507091510)*(&11507295)+(&12379571134863) = (&13535355882)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &16929515515` in
let npos = REAL_ARITH `!s:real. &0:real < &6767130236240` in
let ppos = REAL_ARITH `!s:real. &0:real < &1192303532667072` in
let qpos = REAL_ARITH `!s:real. &0:real < &3609829969507` in
let mqrel = REAL_ARITH `
  ((&16929515515)*(-- &11419648)+(&6767130236240)*(-- &4050944))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((-- &5660672) * &1 + (&8896512) * &0)) /\
  ((&16929515515)*(&10895360)+(&6767130236240)*(&3178496))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((-- &5660672) * &0 + (&8896512) * &1 / &2)) /\
  (&16929515515)*(&11507295)+(&6767130236240)*(&3679349)+(&1192303532667072) = (&3609829969507)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11419648) * x + (&10895360) * y <= &11507295 ==>
  (-- &4050944) * x + (&3178496) * y <= &3679349 ==>
  (-- &5660672) * ((&1) * x + (&0) * y) / s pow 1 + (&8896512) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16929515515` [mpos] THEN
  note `&0:real < &6767130236240` [npos] THEN
  note `&0:real < &1192303532667072` [ppos] THEN
  note `&0:real < &3609829969507` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&16929515515)*(-- &11419648)+(&6767130236240)*(-- &4050944))*s pow 1 = (&3609829969507)*((-- &5660672) * &1 + (&8896512) * &0) /\ ((&16929515515)*(&10895360)+(&6767130236240)*(&3178496))*s pow 1 = (&3609829969507)*((-- &5660672) * &0 + (&8896512) * &1 / &2) /\ (&16929515515)*(&11507295)+(&6767130236240)*(&3679349)+(&1192303532667072) = (&3609829969507)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &6095460580` in
let npos = REAL_ARITH `!s:real. &0:real < &547860831925` in
let ppos = REAL_ARITH `!s:real. &0:real < &13601079348234618` in
let qpos = REAL_ARITH `!s:real. &0:real < &588108122809` in
let mqrel = REAL_ARITH `
  ((&6095460580)*(-- &13631488)+(&547860831925)*(-- &540934144))*(&30902639 / &41749730) pow 1 = (&588108122809)*(((-- &373096448) * &1 + (&503644160) * &0)) /\
  ((&6095460580)*(&9502720)+(&547860831925)*(&365101056))*(&30902639 / &41749730) pow 1 = (&588108122809)*(((-- &373096448) * &0 + (&503644160) * &1 / &2)) /\
  (&6095460580)*(&11699263)+(&547860831925)*(&457442411)+(&13601079348234618) = (&588108122809)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &13631488) * x + (&9502720) * y <= &11699263 ==>
  (-- &540934144) * x + (&365101056) * y <= &457442411 ==>
  (-- &373096448) * ((&1) * x + (&0) * y) / s pow 1 + (&503644160) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6095460580` [mpos] THEN
  note `&0:real < &547860831925` [npos] THEN
  note `&0:real < &13601079348234618` [ppos] THEN
  note `&0:real < &588108122809` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6095460580)*(-- &13631488)+(&547860831925)*(-- &540934144))*s pow 1 = (&588108122809)*((-- &373096448) * &1 + (&503644160) * &0) /\ ((&6095460580)*(&9502720)+(&547860831925)*(&365101056))*s pow 1 = (&588108122809)*((-- &373096448) * &0 + (&503644160) * &1 / &2) /\ (&6095460580)*(&11699263)+(&547860831925)*(&457442411)+(&13601079348234618) = (&588108122809)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &125249190` in
let npos = REAL_ARITH `!s:real. &0:real < &937406687690` in
let ppos = REAL_ARITH `!s:real. &0:real < &366737657964255` in
let qpos = REAL_ARITH `!s:real. &0:real < &1037617909703` in
let mqrel = REAL_ARITH `
  ((&125249190)*(-- &540934144)+(&937406687690)*(-- &8454144))*(&30902639 / &41749730) pow 1 = (&1037617909703)*(((-- &5701632) * &1 + (&7340032) * &0)) /\
  ((&125249190)*(&365101056)+(&937406687690)*(&5439488))*(&30902639 / &41749730) pow 1 = (&1037617909703)*(((-- &5701632) * &0 + (&7340032) * &1 / &2)) /\
  (&125249190)*(&457442411)+(&937406687690)*(&7031327)+(&366737657964255) = (&1037617909703)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &540934144) * x + (&365101056) * y <= &457442411 ==>
  (-- &8454144) * x + (&5439488) * y <= &7031327 ==>
  (-- &5701632) * ((&1) * x + (&0) * y) / s pow 1 + (&7340032) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &125249190` [mpos] THEN
  note `&0:real < &937406687690` [npos] THEN
  note `&0:real < &366737657964255` [ppos] THEN
  note `&0:real < &1037617909703` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&125249190)*(-- &540934144)+(&937406687690)*(-- &8454144))*s pow 1 = (&1037617909703)*((-- &5701632) * &1 + (&7340032) * &0) /\ ((&125249190)*(&365101056)+(&937406687690)*(&5439488))*s pow 1 = (&1037617909703)*((-- &5701632) * &0 + (&7340032) * &1 / &2) /\ (&125249190)*(&457442411)+(&937406687690)*(&7031327)+(&366737657964255) = (&1037617909703)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &13847780069915` in
let npos = REAL_ARITH `!s:real. &0:real < &105877315280` in
let ppos = REAL_ARITH `!s:real. &0:real < &14678508568742733` in
let qpos = REAL_ARITH `!s:real. &0:real < &7618180371558` in
let mqrel = REAL_ARITH `
  ((&13847780069915)*(-- &34471936)+(&105877315280)*(-- &20946944))*(&30902639 / &41749730) pow 1 = (&7618180371558)*(((-- &46596096) * &1 + (&51871744) * &0)) /\
  ((&13847780069915)*(&19202048)+(&105877315280)*(&9748480))*(&30902639 / &41749730) pow 1 = (&7618180371558)*(((-- &46596096) * &0 + (&51871744) * &1 / &2)) /\
  (&13847780069915)*(&27364823)+(&105877315280)*(&15848215)+(&14678508568742733) = (&7618180371558)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &34471936) * x + (&19202048) * y <= &27364823 ==>
  (-- &20946944) * x + (&9748480) * y <= &15848215 ==>
  (-- &46596096) * ((&1) * x + (&0) * y) / s pow 1 + (&51871744) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &13847780069915` [mpos] THEN
  note `&0:real < &105877315280` [npos] THEN
  note `&0:real < &14678508568742733` [ppos] THEN
  note `&0:real < &7618180371558` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&13847780069915)*(-- &34471936)+(&105877315280)*(-- &20946944))*s pow 1 = (&7618180371558)*((-- &46596096) * &1 + (&51871744) * &0) /\ ((&13847780069915)*(&19202048)+(&105877315280)*(&9748480))*s pow 1 = (&7618180371558)*((-- &46596096) * &0 + (&51871744) * &1 / &2) /\ (&13847780069915)*(&27364823)+(&105877315280)*(&15848215)+(&14678508568742733) = (&7618180371558)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &9435438980` in
let npos = REAL_ARITH `!s:real. &0:real < &20842634208440` in
let ppos = REAL_ARITH `!s:real. &0:real < &12792068334293967` in
let qpos = REAL_ARITH `!s:real. &0:real < &3809090185779` in
let mqrel = REAL_ARITH `
  ((&9435438980)*(-- &34471936)+(&20842634208440)*(-- &20946944))*(&30902639 / &41749730) pow 1 = (&3809090185779)*(((-- &84901888) * &1 + (&79036416) * &0)) /\
  ((&9435438980)*(&19202048)+(&20842634208440)*(&9748480))*(&30902639 / &41749730) pow 1 = (&3809090185779)*(((-- &84901888) * &0 + (&79036416) * &1 / &2)) /\
  (&9435438980)*(&27364823)+(&20842634208440)*(&15848215)+(&12792068334293967) = (&3809090185779)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &34471936) * x + (&19202048) * y <= &27364823 ==>
  (-- &20946944) * x + (&9748480) * y <= &15848215 ==>
  (-- &84901888) * ((&1) * x + (&0) * y) / s pow 1 + (&79036416) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9435438980` [mpos] THEN
  note `&0:real < &20842634208440` [npos] THEN
  note `&0:real < &12792068334293967` [ppos] THEN
  note `&0:real < &3809090185779` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&9435438980)*(-- &34471936)+(&20842634208440)*(-- &20946944))*s pow 1 = (&3809090185779)*((-- &84901888) * &1 + (&79036416) * &0) /\ ((&9435438980)*(&19202048)+(&20842634208440)*(&9748480))*s pow 1 = (&3809090185779)*((-- &84901888) * &0 + (&79036416) * &1 / &2) /\ (&9435438980)*(&27364823)+(&20842634208440)*(&15848215)+(&12792068334293967) = (&3809090185779)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &304773029000` in
let npos = REAL_ARITH `!s:real. &0:real < &6554707610` in
let ppos = REAL_ARITH `!s:real. &0:real < &265892594364019` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&304773029000)*(-- &24879104)+(&6554707610)*(-- &131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &134447104) * &1 + (&97124352) * &0)) /\
  ((&304773029000)*(&8986624)+(&6554707610)*(&32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &134447104) * &0 + (&97124352) * &1 / &2)) /\
  (&304773029000)*(&18073405)+(&6554707610)*(&92351)+(&265892594364019) = (&41749465289)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &24879104) * x + (&8986624) * y <= &18073405 ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &134447104) * ((&1) * x + (&0) * y) / s pow 1 + (&97124352) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &304773029000` [mpos] THEN
  note `&0:real < &6554707610` [npos] THEN
  note `&0:real < &265892594364019` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&304773029000)*(-- &24879104)+(&6554707610)*(-- &131072))*s pow 1 = (&41749465289)*((-- &134447104) * &1 + (&97124352) * &0) /\ ((&304773029000)*(&8986624)+(&6554707610)*(&32768))*s pow 1 = (&41749465289)*((-- &134447104) * &0 + (&97124352) * &1 / &2) /\ (&304773029000)*(&18073405)+(&6554707610)*(&92351)+(&265892594364019) = (&41749465289)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &667995680` in
let npos = REAL_ARITH `!s:real. &0:real < &43078582156170` in
let ppos = REAL_ARITH `!s:real. &0:real < &192152826362777` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&667995680)*(-- &24879104)+(&43078582156170)*(-- &131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &100401152) * &1 + (&50266112) * &0)) /\
  ((&667995680)*(&8986624)+(&43078582156170)*(&32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &100401152) * &0 + (&50266112) * &1 / &2)) /\
  (&667995680)*(&18073405)+(&43078582156170)*(&92351)+(&192152826362777) = (&41749465289)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &24879104) * x + (&8986624) * y <= &18073405 ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &100401152) * ((&1) * x + (&0) * y) / s pow 1 + (&50266112) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &667995680` [mpos] THEN
  note `&0:real < &43078582156170` [npos] THEN
  note `&0:real < &192152826362777` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&667995680)*(-- &24879104)+(&43078582156170)*(-- &131072))*s pow 1 = (&41749465289)*((-- &100401152) * &1 + (&50266112) * &0) /\ ((&667995680)*(&8986624)+(&43078582156170)*(&32768))*s pow 1 = (&41749465289)*((-- &100401152) * &0 + (&50266112) * &1 / &2) /\ (&667995680)*(&18073405)+(&43078582156170)*(&92351)+(&192152826362777) = (&41749465289)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &310200493900` in
let npos = REAL_ARITH `!s:real. &0:real < &29788432355` in
let ppos = REAL_ARITH `!s:real. &0:real < &2348215771965287` in
let qpos = REAL_ARITH `!s:real. &0:real < &683133737734` in
let mqrel = REAL_ARITH `
  ((&310200493900)*(-- &191823872)+(&29788432355)*(-- &9568256))*(&30902639 / &41749730) pow 1 = (&683133737734)*(((-- &64782336) * &1 + (&27295744) * &0)) /\
  ((&310200493900)*(&40435712)+(&29788432355)*(&1769472))*(&30902639 / &41749730) pow 1 = (&683133737734)*(((-- &64782336) * &0 + (&27295744) * &1 / &2)) /\
  (&310200493900)*(&133937273)+(&29788432355)*(&6651805)+(&2348215771965287) = (&683133737734)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &191823872) * x + (&40435712) * y <= &133937273 ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &64782336) * ((&1) * x + (&0) * y) / s pow 1 + (&27295744) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &310200493900` [mpos] THEN
  note `&0:real < &29788432355` [npos] THEN
  note `&0:real < &2348215771965287` [ppos] THEN
  note `&0:real < &683133737734` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&310200493900)*(-- &191823872)+(&29788432355)*(-- &9568256))*s pow 1 = (&683133737734)*((-- &64782336) * &1 + (&27295744) * &0) /\ ((&310200493900)*(&40435712)+(&29788432355)*(&1769472))*s pow 1 = (&683133737734)*((-- &64782336) * &0 + (&27295744) * &1 / &2) /\ (&310200493900)*(&133937273)+(&29788432355)*(&6651805)+(&2348215771965287) = (&683133737734)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &109363417735` in
let npos = REAL_ARITH `!s:real. &0:real < &146124055` in
let ppos = REAL_ARITH `!s:real. &0:real < &39572343963816` in
let qpos = REAL_ARITH `!s:real. &0:real < &59889314382` in
let mqrel = REAL_ARITH `
  ((&109363417735)*(-- &9568256)+(&146124055)*(-- &5767168))*(&30902639 / &41749730) pow 1 = (&59889314382)*(((-- &12943360) * &1 + (&4784128) * &0)) /\
  ((&109363417735)*(&1769472)+(&146124055)*(&196608))*(&30902639 / &41749730) pow 1 = (&59889314382)*(((-- &12943360) * &0 + (&4784128) * &1 / &2)) /\
  (&109363417735)*(&6651805)+(&146124055)*(&3914969)+(&39572343963816) = (&59889314382)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &12943360) * ((&1) * x + (&0) * y) / s pow 1 + (&4784128) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &109363417735` [mpos] THEN
  note `&0:real < &146124055` [npos] THEN
  note `&0:real < &39572343963816` [ppos] THEN
  note `&0:real < &59889314382` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&109363417735)*(-- &9568256)+(&146124055)*(-- &5767168))*s pow 1 = (&59889314382)*((-- &12943360) * &1 + (&4784128) * &0) /\ ((&109363417735)*(&1769472)+(&146124055)*(&196608))*s pow 1 = (&59889314382)*((-- &12943360) * &0 + (&4784128) * &1 / &2) /\ (&109363417735)*(&6651805)+(&146124055)*(&3914969)+(&39572343963816) = (&59889314382)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &4136959870835` in
let npos = REAL_ARITH `!s:real. &0:real < &235885974500` in
let ppos = REAL_ARITH `!s:real. &0:real < &1546264204615452` in
let qpos = REAL_ARITH `!s:real. &0:real < &29944657191` in
let mqrel = REAL_ARITH `
  ((&4136959870835)*(-- &9568256)+(&235885974500)*(-- &5767168))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((-- &1012072448) * &1 + (&364183552) * &0)) /\
  ((&4136959870835)*(&1769472)+(&235885974500)*(&196608))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((-- &1012072448) * &0 + (&364183552) * &1 / &2)) /\
  (&4136959870835)*(&6651805)+(&235885974500)*(&3914969)+(&1546264204615452) = (&29944657191)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &1012072448) * ((&1) * x + (&0) * y) / s pow 1 + (&364183552) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4136959870835` [mpos] THEN
  note `&0:real < &235885974500` [npos] THEN
  note `&0:real < &1546264204615452` [ppos] THEN
  note `&0:real < &29944657191` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4136959870835)*(-- &9568256)+(&235885974500)*(-- &5767168))*s pow 1 = (&29944657191)*((-- &1012072448) * &1 + (&364183552) * &0) /\ ((&4136959870835)*(&1769472)+(&235885974500)*(&196608))*s pow 1 = (&29944657191)*((-- &1012072448) * &0 + (&364183552) * &1 / &2) /\ (&4136959870835)*(&6651805)+(&235885974500)*(&3914969)+(&1546264204615452) = (&29944657191)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &772370005` in
let npos = REAL_ARITH `!s:real. &0:real < &146124055` in
let ppos = REAL_ARITH `!s:real. &0:real < &30259936037007` in
let qpos = REAL_ARITH `!s:real. &0:real < &1576034589` in
let mqrel = REAL_ARITH `
  ((&772370005)*(-- &9568256)+(&146124055)*(-- &5767168))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((-- &3866624) * &1 + (&1310720) * &0)) /\
  ((&772370005)*(&1769472)+(&146124055)*(&196608))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((-- &3866624) * &0 + (&1310720) * &1 / &2)) /\
  (&772370005)*(&6651805)+(&146124055)*(&3914969)+(&30259936037007) = (&1576034589)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &3866624) * ((&1) * x + (&0) * y) / s pow 1 + (&1310720) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &772370005` [mpos] THEN
  note `&0:real < &146124055` [npos] THEN
  note `&0:real < &30259936037007` [ppos] THEN
  note `&0:real < &1576034589` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&772370005)*(-- &9568256)+(&146124055)*(-- &5767168))*s pow 1 = (&1576034589)*((-- &3866624) * &1 + (&1310720) * &0) /\ ((&772370005)*(&1769472)+(&146124055)*(&196608))*s pow 1 = (&1576034589)*((-- &3866624) * &0 + (&1310720) * &1 / &2) /\ (&772370005)*(&6651805)+(&146124055)*(&3914969)+(&30259936037007) = (&1576034589)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &8750054537455` in
let npos = REAL_ARITH `!s:real. &0:real < &647120815` in
let ppos = REAL_ARITH `!s:real. &0:real < &2666200250709339617` in
let qpos = REAL_ARITH `!s:real. &0:real < &959743259423` in
let mqrel = REAL_ARITH `
  ((&8750054537455)*(-- &5767168)+(&647120815)*(-- &413007872))*(&30902639 / &41749730) pow 1 = (&959743259423)*(((-- &39124992) * &1 + (&2621440) * &0)) /\
  ((&8750054537455)*(&196608)+(&647120815)*(-- &32178176))*(&30902639 / &41749730) pow 1 = (&959743259423)*(((-- &39124992) * &0 + (&2621440) * &1 / &2)) /\
  (&8750054537455)*(&3914969)+(&647120815)*(&275907781)+(&2666200250709339617) = (&959743259423)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &413007872) * x + (-- &32178176) * y <= &275907781 ==>
  (-- &39124992) * ((&1) * x + (&0) * y) / s pow 1 + (&2621440) * ((&0) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8750054537455` [mpos] THEN
  note `&0:real < &647120815` [npos] THEN
  note `&0:real < &2666200250709339617` [ppos] THEN
  note `&0:real < &959743259423` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&8750054537455)*(-- &5767168)+(&647120815)*(-- &413007872))*s pow 1 = (&959743259423)*((-- &39124992) * &1 + (&2621440) * &0) /\ ((&8750054537455)*(&196608)+(&647120815)*(-- &32178176))*s pow 1 = (&959743259423)*((-- &39124992) * &0 + (&2621440) * &1 / &2) /\ (&8750054537455)*(&3914969)+(&647120815)*(&275907781)+(&2666200250709339617) = (&959743259423)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_H0 x y ==>
  divsteps_H1 (((&1) * x + (&0) * y) / divsteps_s pow 1) (((&0) * x + (&1 / &2) * y) / divsteps_s pow 1)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_H0] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H1] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

(* skipping Gc for approx *)

let theorem1 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &151530645035` in
let npos = REAL_ARITH `!s:real. &0:real < &77508373745` in
let ppos = REAL_ARITH `!s:real. &0:real < &1191225354704564972` in
let qpos = REAL_ARITH `!s:real. &0:real < &3838973037692` in
let mqrel = REAL_ARITH `
  ((&151530645035)*(-- &5767168)+(&77508373745)*(-- &413007872))*(&30902639 / &41749730) pow 1 = (&3838973037692)*(((-- &5865472) * &1 + (-- &950272) * &1 / &2)) /\
  ((&151530645035)*(&196608)+(&77508373745)*(-- &32178176))*(&30902639 / &41749730) pow 1 = (&3838973037692)*(((-- &5865472) * &0 + (-- &950272) * &1 / &2)) /\
  (&151530645035)*(&3914969)+(&77508373745)*(&275907781)+(&1191225354704564972) = (&3838973037692)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &413007872) * x + (-- &32178176) * y <= &275907781 ==>
  (-- &5865472) * ((&1) * x + (&0) * y) / s pow 1 + (-- &950272) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &151530645035` [mpos] THEN
  note `&0:real < &77508373745` [npos] THEN
  note `&0:real < &1191225354704564972` [ppos] THEN
  note `&0:real < &3838973037692` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&151530645035)*(-- &5767168)+(&77508373745)*(-- &413007872))*s pow 1 = (&3838973037692)*((-- &5865472) * &1 + (-- &950272) * &1 / &2) /\ ((&151530645035)*(&196608)+(&77508373745)*(-- &32178176))*s pow 1 = (&3838973037692)*((-- &5865472) * &0 + (-- &950272) * &1 / &2) /\ (&151530645035)*(&3914969)+(&77508373745)*(&275907781)+(&1191225354704564972) = (&3838973037692)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &12833157256590` in
let npos = REAL_ARITH `!s:real. &0:real < &413284021622725` in
let ppos = REAL_ARITH `!s:real. &0:real < &234741277118662323` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&12833157256590)*(-- &413007872)+(&413284021622725)*(-- &32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &439386112) * &1 + (-- &185892864) * &1 / &2)) /\
  ((&12833157256590)*(-- &32178176)+(&413284021622725)*(-- &6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((-- &439386112) * &0 + (-- &185892864) * &1 / &2)) /\
  (&12833157256590)*(&275907781)+(&413284021622725)*(&21583161)+(&234741277118662323) = (&25936399496866)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &413007872) * x + (-- &32178176) * y <= &275907781 ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &439386112) * ((&1) * x + (&0) * y) / s pow 1 + (-- &185892864) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12833157256590` [mpos] THEN
  note `&0:real < &413284021622725` [npos] THEN
  note `&0:real < &234741277118662323` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12833157256590)*(-- &413007872)+(&413284021622725)*(-- &32309248))*s pow 1 = (&25936399496866)*((-- &439386112) * &1 + (-- &185892864) * &1 / &2) /\ ((&12833157256590)*(-- &32178176)+(&413284021622725)*(-- &6881280))*s pow 1 = (&25936399496866)*((-- &439386112) * &0 + (-- &185892864) * &1 / &2) /\ (&12833157256590)*(&275907781)+(&413284021622725)*(&21583161)+(&234741277118662323) = (&25936399496866)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &21328308817530` in
let npos = REAL_ARITH `!s:real. &0:real < &38910748360` in
let ppos = REAL_ARITH `!s:real. &0:real < &21966070735619059` in
let qpos = REAL_ARITH `!s:real. &0:real < &8127733986029` in
let mqrel = REAL_ARITH `
  ((&21328308817530)*(-- &32309248)+(&38910748360)*(-- &137199616))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((-- &49741824) * &1 + (-- &27000832) * &1 / &2)) /\
  ((&21328308817530)*(-- &6881280)+(&38910748360)*(-- &37961728))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((-- &49741824) * &0 + (-- &27000832) * &1 / &2)) /\
  (&21328308817530)*(&21583161)+(&38910748360)*(&91847345)+(&21966070735619059) = (&8127733986029)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &137199616) * x + (-- &37961728) * y <= &91847345 ==>
  (-- &49741824) * ((&1) * x + (&0) * y) / s pow 1 + (-- &27000832) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &21328308817530` [mpos] THEN
  note `&0:real < &38910748360` [npos] THEN
  note `&0:real < &21966070735619059` [ppos] THEN
  note `&0:real < &8127733986029` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&21328308817530)*(-- &32309248)+(&38910748360)*(-- &137199616))*s pow 1 = (&8127733986029)*((-- &49741824) * &1 + (-- &27000832) * &1 / &2) /\ ((&21328308817530)*(-- &6881280)+(&38910748360)*(-- &37961728))*s pow 1 = (&8127733986029)*((-- &49741824) * &0 + (-- &27000832) * &1 / &2) /\ (&21328308817530)*(&21583161)+(&38910748360)*(&91847345)+(&21966070735619059) = (&8127733986029)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &40893860535` in
let npos = REAL_ARITH `!s:real. &0:real < &14826164117600` in
let ppos = REAL_ARITH `!s:real. &0:real < &64996587731572973` in
let qpos = REAL_ARITH `!s:real. &0:real < &32510935944116` in
let mqrel = REAL_ARITH `
  ((&40893860535)*(-- &32309248)+(&14826164117600)*(-- &137199616))*(&30902639 / &41749730) pow 1 = (&32510935944116)*(((-- &33521664) * &1 + (-- &25640960) * &1 / &2)) /\
  ((&40893860535)*(-- &6881280)+(&14826164117600)*(-- &37961728))*(&30902639 / &41749730) pow 1 = (&32510935944116)*(((-- &33521664) * &0 + (-- &25640960) * &1 / &2)) /\
  (&40893860535)*(&21583161)+(&14826164117600)*(&91847345)+(&64996587731572973) = (&32510935944116)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &32309248) * x + (-- &6881280) * y <= &21583161 ==>
  (-- &137199616) * x + (-- &37961728) * y <= &91847345 ==>
  (-- &33521664) * ((&1) * x + (&0) * y) / s pow 1 + (-- &25640960) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &40893860535` [mpos] THEN
  note `&0:real < &14826164117600` [npos] THEN
  note `&0:real < &64996587731572973` [ppos] THEN
  note `&0:real < &32510935944116` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&40893860535)*(-- &32309248)+(&14826164117600)*(-- &137199616))*s pow 1 = (&32510935944116)*((-- &33521664) * &1 + (-- &25640960) * &1 / &2) /\ ((&40893860535)*(-- &6881280)+(&14826164117600)*(-- &37961728))*s pow 1 = (&32510935944116)*((-- &33521664) * &0 + (-- &25640960) * &1 / &2) /\ (&40893860535)*(&21583161)+(&14826164117600)*(&91847345)+(&64996587731572973) = (&32510935944116)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &75149514` in
let npos = REAL_ARITH `!s:real. &0:real < &31884268801` in
let ppos = REAL_ARITH `!s:real. &0:real < &32631338415331` in
let qpos = REAL_ARITH `!s:real. &0:real < &247653748946` in
let mqrel = REAL_ARITH `
  ((&75149514)*(-- &137199616)+(&31884268801)*(-- &27099136))*(&30902639 / &41749730) pow 1 = (&247653748946)*(((-- &1867776) * &1 + (-- &1490944) * &1 / &2)) /\
  ((&75149514)*(-- &37961728)+(&31884268801)*(-- &7733248))*(&30902639 / &41749730) pow 1 = (&247653748946)*(((-- &1867776) * &0 + (-- &1490944) * &1 / &2)) /\
  (&75149514)*(&91847345)+(&31884268801)*(&18176645)+(&32631338415331) = (&247653748946)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &137199616) * x + (-- &37961728) * y <= &91847345 ==>
  (-- &27099136) * x + (-- &7733248) * y <= &18176645 ==>
  (-- &1867776) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1490944) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &75149514` [mpos] THEN
  note `&0:real < &31884268801` [npos] THEN
  note `&0:real < &32631338415331` [ppos] THEN
  note `&0:real < &247653748946` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&75149514)*(-- &137199616)+(&31884268801)*(-- &27099136))*s pow 1 = (&247653748946)*((-- &1867776) * &1 + (-- &1490944) * &1 / &2) /\ ((&75149514)*(-- &37961728)+(&31884268801)*(-- &7733248))*s pow 1 = (&247653748946)*((-- &1867776) * &0 + (-- &1490944) * &1 / &2) /\ (&75149514)*(&91847345)+(&31884268801)*(&18176645)+(&32631338415331) = (&247653748946)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &4362846785` in
let npos = REAL_ARITH `!s:real. &0:real < &1293302261075` in
let ppos = REAL_ARITH `!s:real. &0:real < &3504406119778672` in
let qpos = REAL_ARITH `!s:real. &0:real < &5673848130956` in
let mqrel = REAL_ARITH `
  ((&4362846785)*(-- &27099136)+(&1293302261075)*(-- &68321280))*(&30902639 / &41749730) pow 1 = (&5673848130956)*(((-- &7634944) * &1 + (-- &7815168) * &1 / &2)) /\
  ((&4362846785)*(-- &7733248)+(&1293302261075)*(-- &23134208))*(&30902639 / &41749730) pow 1 = (&5673848130956)*(((-- &7634944) * &0 + (-- &7815168) * &1 / &2)) /\
  (&4362846785)*(&18176645)+(&1293302261075)*(&46464197)+(&3504406119778672) = (&5673848130956)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &27099136) * x + (-- &7733248) * y <= &18176645 ==>
  (-- &68321280) * x + (-- &23134208) * y <= &46464197 ==>
  (-- &7634944) * ((&1) * x + (&0) * y) / s pow 1 + (-- &7815168) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4362846785` [mpos] THEN
  note `&0:real < &1293302261075` [npos] THEN
  note `&0:real < &3504406119778672` [ppos] THEN
  note `&0:real < &5673848130956` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4362846785)*(-- &27099136)+(&1293302261075)*(-- &68321280))*s pow 1 = (&5673848130956)*((-- &7634944) * &1 + (-- &7815168) * &1 / &2) /\ ((&4362846785)*(-- &7733248)+(&1293302261075)*(-- &23134208))*s pow 1 = (&5673848130956)*((-- &7634944) * &0 + (-- &7815168) * &1 / &2) /\ (&4362846785)*(&18176645)+(&1293302261075)*(&46464197)+(&3504406119778672) = (&5673848130956)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &125249190` in
let npos = REAL_ARITH `!s:real. &0:real < &55339267115` in
let ppos = REAL_ARITH `!s:real. &0:real < &62999125380957` in
let qpos = REAL_ARITH `!s:real. &0:real < &730414775404` in
let mqrel = REAL_ARITH `
  ((&125249190)*(-- &68321280)+(&55339267115)*(-- &26869760))*(&30902639 / &41749730) pow 1 = (&730414775404)*(((-- &950272) * &1 + (-- &1130496) * &1 / &2)) /\
  ((&125249190)*(-- &23134208)+(&55339267115)*(-- &10027008))*(&30902639 / &41749730) pow 1 = (&730414775404)*(((-- &950272) * &0 + (-- &1130496) * &1 / &2)) /\
  (&125249190)*(&46464197)+(&55339267115)*(&18466107)+(&62999125380957) = (&730414775404)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &68321280) * x + (-- &23134208) * y <= &46464197 ==>
  (-- &26869760) * x + (-- &10027008) * y <= &18466107 ==>
  (-- &950272) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1130496) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &125249190` [mpos] THEN
  note `&0:real < &55339267115` [npos] THEN
  note `&0:real < &62999125380957` [ppos] THEN
  note `&0:real < &730414775404` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&125249190)*(-- &68321280)+(&55339267115)*(-- &26869760))*s pow 1 = (&730414775404)*((-- &950272) * &1 + (-- &1130496) * &1 / &2) /\ ((&125249190)*(-- &23134208)+(&55339267115)*(-- &10027008))*s pow 1 = (&730414775404)*((-- &950272) * &0 + (-- &1130496) * &1 / &2) /\ (&125249190)*(&46464197)+(&55339267115)*(&18466107)+(&62999125380957) = (&730414775404)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &2223841118180` in
let npos = REAL_ARITH `!s:real. &0:real < &60871106340` in
let ppos = REAL_ARITH `!s:real. &0:real < &3286619764726673` in
let qpos = REAL_ARITH `!s:real. &0:real < &122343547801` in
let mqrel = REAL_ARITH `
  ((&2223841118180)*(-- &52412416)+(&60871106340)*(-- &7979008))*(&30902639 / &41749730) pow 1 = (&122343547801)*(((-- &438239232) * &1 + (-- &539754496) * &1 / &2)) /\
  ((&2223841118180)*(-- &19972096)+(&60871106340)*(-- &3162112))*(&30902639 / &41749730) pow 1 = (&122343547801)*(((-- &438239232) * &0 + (-- &539754496) * &1 / &2)) /\
  (&2223841118180)*(&36108393)+(&60871106340)*(&5552625)+(&3286619764726673) = (&122343547801)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &52412416) * x + (-- &19972096) * y <= &36108393 ==>
  (-- &7979008) * x + (-- &3162112) * y <= &5552625 ==>
  (-- &438239232) * ((&1) * x + (&0) * y) / s pow 1 + (-- &539754496) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2223841118180` [mpos] THEN
  note `&0:real < &60871106340` [npos] THEN
  note `&0:real < &3286619764726673` [ppos] THEN
  note `&0:real < &122343547801` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2223841118180)*(-- &52412416)+(&60871106340)*(-- &7979008))*s pow 1 = (&122343547801)*((-- &438239232) * &1 + (-- &539754496) * &1 / &2) /\ ((&2223841118180)*(-- &19972096)+(&60871106340)*(-- &3162112))*s pow 1 = (&122343547801)*((-- &438239232) * &0 + (-- &539754496) * &1 / &2) /\ (&2223841118180)*(&36108393)+(&60871106340)*(&5552625)+(&3286619764726673) = (&122343547801)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &15614399020` in
let npos = REAL_ARITH `!s:real. &0:real < &1237378497740` in
let ppos = REAL_ARITH `!s:real. &0:real < &304214617341411` in
let qpos = REAL_ARITH `!s:real. &0:real < &367030643403` in
let mqrel = REAL_ARITH `
  ((&15614399020)*(-- &52412416)+(&1237378497740)*(-- &7979008))*(&30902639 / &41749730) pow 1 = (&367030643403)*(((-- &13041664) * &1 + (-- &17039360) * &1 / &2)) /\
  ((&15614399020)*(-- &19972096)+(&1237378497740)*(-- &3162112))*(&30902639 / &41749730) pow 1 = (&367030643403)*(((-- &13041664) * &0 + (-- &17039360) * &1 / &2)) /\
  (&15614399020)*(&36108393)+(&1237378497740)*(&5552625)+(&304214617341411) = (&367030643403)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &52412416) * x + (-- &19972096) * y <= &36108393 ==>
  (-- &7979008) * x + (-- &3162112) * y <= &5552625 ==>
  (-- &13041664) * ((&1) * x + (&0) * y) / s pow 1 + (-- &17039360) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &15614399020` [mpos] THEN
  note `&0:real < &1237378497740` [npos] THEN
  note `&0:real < &304214617341411` [ppos] THEN
  note `&0:real < &367030643403` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&15614399020)*(-- &52412416)+(&1237378497740)*(-- &7979008))*s pow 1 = (&367030643403)*((-- &13041664) * &1 + (-- &17039360) * &1 / &2) /\ ((&15614399020)*(-- &19972096)+(&1237378497740)*(-- &3162112))*s pow 1 = (&367030643403)*((-- &13041664) * &0 + (-- &17039360) * &1 / &2) /\ (&15614399020)*(&36108393)+(&1237378497740)*(&5552625)+(&304214617341411) = (&367030643403)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &7347952480` in
let npos = REAL_ARITH `!s:real. &0:real < &335396455955` in
let ppos = REAL_ARITH `!s:real. &0:real < &1563371233148745` in
let qpos = REAL_ARITH `!s:real. &0:real < &2208240777662` in
let mqrel = REAL_ARITH `
  ((&7347952480)*(-- &7979008)+(&335396455955)*(-- &121733120))*(&30902639 / &41749730) pow 1 = (&2208240777662)*(((-- &7733248) * &1 + (-- &11943936) * &1 / &2)) /\
  ((&7347952480)*(-- &3162112)+(&335396455955)*(-- &53051392))*(&30902639 / &41749730) pow 1 = (&2208240777662)*(((-- &7733248) * &0 + (-- &11943936) * &1 / &2)) /\
  (&7347952480)*(&5552625)+(&335396455955)*(&86950107)+(&1563371233148745) = (&2208240777662)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7979008) * x + (-- &3162112) * y <= &5552625 ==>
  (-- &121733120) * x + (-- &53051392) * y <= &86950107 ==>
  (-- &7733248) * ((&1) * x + (&0) * y) / s pow 1 + (-- &11943936) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7347952480` [mpos] THEN
  note `&0:real < &335396455955` [npos] THEN
  note `&0:real < &1563371233148745` [ppos] THEN
  note `&0:real < &2208240777662` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7347952480)*(-- &7979008)+(&335396455955)*(-- &121733120))*s pow 1 = (&2208240777662)*((-- &7733248) * &1 + (-- &11943936) * &1 / &2) /\ ((&7347952480)*(-- &3162112)+(&335396455955)*(-- &53051392))*s pow 1 = (&2208240777662)*((-- &7733248) * &0 + (-- &11943936) * &1 / &2) /\ (&7347952480)*(&5552625)+(&335396455955)*(&86950107)+(&1563371233148745) = (&2208240777662)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &6874928039100` in
let npos = REAL_ARITH `!s:real. &0:real < &4529845705` in
let ppos = REAL_ARITH `!s:real. &0:real < &28702484133633433` in
let qpos = REAL_ARITH `!s:real. &0:real < &331760349017296` in
let mqrel = REAL_ARITH `
  ((&6874928039100)*(-- &124731392)+(&4529845705)*(-- &165806080))*(&30902639 / &41749730) pow 1 = (&331760349017296)*(((-- &897024) * &1 + (-- &2035712) * &1 / &2)) /\
  ((&6874928039100)*(-- &66289664)+(&4529845705)*(-- &105447424))*(&30902639 / &41749730) pow 1 = (&331760349017296)*(((-- &897024) * &0 + (-- &2035712) * &1 / &2)) /\
  (&6874928039100)*(&95315653)+(&4529845705)*(&137755571)+(&28702484133633433) = (&331760349017296)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &124731392) * x + (-- &66289664) * y <= &95315653 ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &897024) * ((&1) * x + (&0) * y) / s pow 1 + (-- &2035712) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6874928039100` [mpos] THEN
  note `&0:real < &4529845705` [npos] THEN
  note `&0:real < &28702484133633433` [ppos] THEN
  note `&0:real < &331760349017296` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6874928039100)*(-- &124731392)+(&4529845705)*(-- &165806080))*s pow 1 = (&331760349017296)*((-- &897024) * &1 + (-- &2035712) * &1 / &2) /\ ((&6874928039100)*(-- &66289664)+(&4529845705)*(-- &105447424))*s pow 1 = (&331760349017296)*((-- &897024) * &0 + (-- &2035712) * &1 / &2) /\ (&6874928039100)*(&95315653)+(&4529845705)*(&137755571)+(&28702484133633433) = (&331760349017296)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &290661620260` in
let npos = REAL_ARITH `!s:real. &0:real < &56566187305375` in
let ppos = REAL_ARITH `!s:real. &0:real < &339123854911903935` in
let qpos = REAL_ARITH `!s:real. &0:real < &1990562094103776` in
let mqrel = REAL_ARITH `
  ((&290661620260)*(-- &124731392)+(&56566187305375)*(-- &165806080))*(&30902639 / &41749730) pow 1 = (&1990562094103776)*(((-- &1275904) * &1 + (-- &4450304) * &1 / &2)) /\
  ((&290661620260)*(-- &66289664)+(&56566187305375)*(-- &105447424))*(&30902639 / &41749730) pow 1 = (&1990562094103776)*(((-- &1275904) * &0 + (-- &4450304) * &1 / &2)) /\
  (&290661620260)*(&95315653)+(&56566187305375)*(&137755571)+(&339123854911903935) = (&1990562094103776)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &124731392) * x + (-- &66289664) * y <= &95315653 ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &1275904) * ((&1) * x + (&0) * y) / s pow 1 + (-- &4450304) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &290661620260` [mpos] THEN
  note `&0:real < &56566187305375` [npos] THEN
  note `&0:real < &339123854911903935` [ppos] THEN
  note `&0:real < &1990562094103776` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&290661620260)*(-- &124731392)+(&56566187305375)*(-- &165806080))*s pow 1 = (&1990562094103776)*((-- &1275904) * &1 + (-- &4450304) * &1 / &2) /\ ((&290661620260)*(-- &66289664)+(&56566187305375)*(-- &105447424))*s pow 1 = (&1990562094103776)*((-- &1275904) * &0 + (-- &4450304) * &1 / &2) /\ (&290661620260)*(&95315653)+(&56566187305375)*(&137755571)+(&339123854911903935) = (&1990562094103776)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &20874865` in
let npos = REAL_ARITH `!s:real. &0:real < &327818879960` in
let ppos = REAL_ARITH `!s:real. &0:real < &396292518349063` in
let qpos = REAL_ARITH `!s:real. &0:real < &798462386482` in
let mqrel = REAL_ARITH `
  ((&20874865)*(-- &165806080)+(&327818879960)*(-- &22740992))*(&30902639 / &41749730) pow 1 = (&798462386482)*(((-- &2211840) * &1 + (-- &9404416) * &1 / &2)) /\
  ((&20874865)*(-- &105447424)+(&327818879960)*(-- &15466496))*(&30902639 / &41749730) pow 1 = (&798462386482)*(((-- &2211840) * &0 + (-- &9404416) * &1 / &2)) /\
  (&20874865)*(&137755571)+(&327818879960)*(&19572823)+(&396292518349063) = (&798462386482)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &165806080) * x + (-- &105447424) * y <= &137755571 ==>
  (-- &22740992) * x + (-- &15466496) * y <= &19572823 ==>
  (-- &2211840) * ((&1) * x + (&0) * y) / s pow 1 + (-- &9404416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20874865` [mpos] THEN
  note `&0:real < &327818879960` [npos] THEN
  note `&0:real < &396292518349063` [ppos] THEN
  note `&0:real < &798462386482` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&20874865)*(-- &165806080)+(&327818879960)*(-- &22740992))*s pow 1 = (&798462386482)*((-- &2211840) * &1 + (-- &9404416) * &1 / &2) /\ ((&20874865)*(-- &105447424)+(&327818879960)*(-- &15466496))*s pow 1 = (&798462386482)*((-- &2211840) * &0 + (-- &9404416) * &1 / &2) /\ (&20874865)*(&137755571)+(&327818879960)*(&19572823)+(&396292518349063) = (&798462386482)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &644970703905` in
let npos = REAL_ARITH `!s:real. &0:real < &3840975160` in
let ppos = REAL_ARITH `!s:real. &0:real < &85845225388732` in
let qpos = REAL_ARITH `!s:real. &0:real < &64864639261` in
let mqrel = REAL_ARITH `
  ((&644970703905)*(-- &3604480)+(&3840975160)*(-- &5537792))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((-- &7733248) * &1 + (-- &38076416) * &1 / &2)) /\
  ((&644970703905)*(-- &2555904)+(&3840975160)*(-- &5177344))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((-- &7733248) * &0 + (-- &38076416) * &1 / &2)) /\
  (&644970703905)*(&3177943)+(&3840975160)*(&5799491)+(&85845225388732) = (&64864639261)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3604480) * x + (-- &2555904) * y <= &3177943 ==>
  (-- &5537792) * x + (-- &5177344) * y <= &5799491 ==>
  (-- &7733248) * ((&1) * x + (&0) * y) / s pow 1 + (-- &38076416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &644970703905` [mpos] THEN
  note `&0:real < &3840975160` [npos] THEN
  note `&0:real < &85845225388732` [ppos] THEN
  note `&0:real < &64864639261` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&644970703905)*(-- &3604480)+(&3840975160)*(-- &5537792))*s pow 1 = (&64864639261)*((-- &7733248) * &1 + (-- &38076416) * &1 / &2) /\ ((&644970703905)*(-- &2555904)+(&3840975160)*(-- &5177344))*s pow 1 = (&64864639261)*((-- &7733248) * &0 + (-- &38076416) * &1 / &2) /\ (&644970703905)*(&3177943)+(&3840975160)*(&5799491)+(&85845225388732) = (&64864639261)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &2024861905` in
let npos = REAL_ARITH `!s:real. &0:real < &472105946840` in
let ppos = REAL_ARITH `!s:real. &0:real < &119595897524836` in
let qpos = REAL_ARITH `!s:real. &0:real < &64864639261` in
let mqrel = REAL_ARITH `
  ((&2024861905)*(-- &3604480)+(&472105946840)*(-- &5537792))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((-- &1966080) * &1 + (-- &55902208) * &1 / &2)) /\
  ((&2024861905)*(-- &2555904)+(&472105946840)*(-- &5177344))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((-- &1966080) * &0 + (-- &55902208) * &1 / &2)) /\
  (&2024861905)*(&3177943)+(&472105946840)*(&5799491)+(&119595897524836) = (&64864639261)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3604480) * x + (-- &2555904) * y <= &3177943 ==>
  (-- &5537792) * x + (-- &5177344) * y <= &5799491 ==>
  (-- &1966080) * ((&1) * x + (&0) * y) / s pow 1 + (-- &55902208) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2024861905` [mpos] THEN
  note `&0:real < &472105946840` [npos] THEN
  note `&0:real < &119595897524836` [ppos] THEN
  note `&0:real < &64864639261` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2024861905)*(-- &3604480)+(&472105946840)*(-- &5537792))*s pow 1 = (&64864639261)*((-- &1966080) * &1 + (-- &55902208) * &1 / &2) /\ ((&2024861905)*(-- &2555904)+(&472105946840)*(-- &5177344))*s pow 1 = (&64864639261)*((-- &1966080) * &0 + (-- &55902208) * &1 / &2) /\ (&2024861905)*(&3177943)+(&472105946840)*(&5799491)+(&119595897524836) = (&64864639261)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &116022499670` in
let npos = REAL_ARITH `!s:real. &0:real < &1729795688225` in
let ppos = REAL_ARITH `!s:real. &0:real < &30633501664806252` in
let qpos = REAL_ARITH `!s:real. &0:real < &5569489919053` in
let mqrel = REAL_ARITH `
  ((&116022499670)*(-- &5537792)+(&1729795688225)*(-- &289406976))*(&30902639 / &41749730) pow 1 = (&5569489919053)*(((&11730944) * &1 + (-- &156696576) * &1 / &2)) /\
  ((&116022499670)*(-- &5177344)+(&1729795688225)*(-- &340459520))*(&30902639 / &41749730) pow 1 = (&5569489919053)*(((&11730944) * &0 + (-- &156696576) * &1 / &2)) /\
  (&116022499670)*(&5799491)+(&1729795688225)*(&355053887)+(&30633501664806252) = (&5569489919053)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5537792) * x + (-- &5177344) * y <= &5799491 ==>
  (-- &289406976) * x + (-- &340459520) * y <= &355053887 ==>
  (&11730944) * ((&1) * x + (&0) * y) / s pow 1 + (-- &156696576) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &116022499670` [mpos] THEN
  note `&0:real < &1729795688225` [npos] THEN
  note `&0:real < &30633501664806252` [ppos] THEN
  note `&0:real < &5569489919053` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&116022499670)*(-- &5537792)+(&1729795688225)*(-- &289406976))*s pow 1 = (&5569489919053)*((&11730944) * &1 + (-- &156696576) * &1 / &2) /\ ((&116022499670)*(-- &5177344)+(&1729795688225)*(-- &340459520))*s pow 1 = (&5569489919053)*((&11730944) * &0 + (-- &156696576) * &1 / &2) /\ (&116022499670)*(&5799491)+(&1729795688225)*(&355053887)+(&30633501664806252) = (&5569489919053)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &266702968385` in
let npos = REAL_ARITH `!s:real. &0:real < &434576735` in
let ppos = REAL_ARITH `!s:real. &0:real < &434297936899456` in
let qpos = REAL_ARITH `!s:real. &0:real < &143759076628` in
let mqrel = REAL_ARITH `
  ((&266702968385)*(-- &26116096)+(&434576735)*(-- &66748416))*(&30902639 / &41749730) pow 1 = (&143759076628)*(((&22740992) * &1 + (-- &117506048) * &1 / &2)) /\
  ((&266702968385)*(-- &42532864)+(&434576735)*(-- &154992640))*(&30902639 / &41749730) pow 1 = (&143759076628)*(((&22740992) * &0 + (-- &117506048) * &1 / &2)) /\
  (&266702968385)*(&41635449)+(&434576735)*(&144601685)+(&434297936899456) = (&143759076628)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &26116096) * x + (-- &42532864) * y <= &41635449 ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (&22740992) * ((&1) * x + (&0) * y) / s pow 1 + (-- &117506048) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &266702968385` [mpos] THEN
  note `&0:real < &434576735` [npos] THEN
  note `&0:real < &434297936899456` [ppos] THEN
  note `&0:real < &143759076628` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&266702968385)*(-- &26116096)+(&434576735)*(-- &66748416))*s pow 1 = (&143759076628)*((&22740992) * &1 + (-- &117506048) * &1 / &2) /\ ((&266702968385)*(-- &42532864)+(&434576735)*(-- &154992640))*s pow 1 = (&143759076628)*((&22740992) * &0 + (-- &117506048) * &1 / &2) /\ (&266702968385)*(&41635449)+(&434576735)*(&144601685)+(&434297936899456) = (&143759076628)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &7816507802075` in
let npos = REAL_ARITH `!s:real. &0:real < &2572737918645` in
let ppos = REAL_ARITH `!s:real. &0:real < &9499321061594056` in
let qpos = REAL_ARITH `!s:real. &0:real < &1581349842908` in
let mqrel = REAL_ARITH `
  ((&7816507802075)*(-- &26116096)+(&2572737918645)*(-- &66748416))*(&30902639 / &41749730) pow 1 = (&1581349842908)*(((&166330368) * &1 + (-- &684523520) * &1 / &2)) /\
  ((&7816507802075)*(-- &42532864)+(&2572737918645)*(-- &154992640))*(&30902639 / &41749730) pow 1 = (&1581349842908)*(((&166330368) * &0 + (-- &684523520) * &1 / &2)) /\
  (&7816507802075)*(&41635449)+(&2572737918645)*(&144601685)+(&9499321061594056) = (&1581349842908)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &26116096) * x + (-- &42532864) * y <= &41635449 ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (&166330368) * ((&1) * x + (&0) * y) / s pow 1 + (-- &684523520) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7816507802075` [mpos] THEN
  note `&0:real < &2572737918645` [npos] THEN
  note `&0:real < &9499321061594056` [ppos] THEN
  note `&0:real < &1581349842908` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7816507802075)*(-- &26116096)+(&2572737918645)*(-- &66748416))*s pow 1 = (&1581349842908)*((&166330368) * &1 + (-- &684523520) * &1 / &2) /\ ((&7816507802075)*(-- &42532864)+(&2572737918645)*(-- &154992640))*s pow 1 = (&1581349842908)*((&166330368) * &0 + (-- &684523520) * &1 / &2) /\ (&7816507802075)*(&41635449)+(&2572737918645)*(&144601685)+(&9499321061594056) = (&1581349842908)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &648724384175` in
let npos = REAL_ARITH `!s:real. &0:real < &289460366665` in
let ppos = REAL_ARITH `!s:real. &0:real < &116451365637485802` in
let qpos = REAL_ARITH `!s:real. &0:real < &790674921454` in
let mqrel = REAL_ARITH `
  ((&648724384175)*(-- &26116096)+(&289460366665)*(-- &66748416))*(&30902639 / &41749730) pow 1 = (&790674921454)*(((&33882112) * &1 + (-- &135659520) * &1 / &2)) /\
  ((&648724384175)*(-- &42532864)+(&289460366665)*(-- &154992640))*(&30902639 / &41749730) pow 1 = (&790674921454)*(((&33882112) * &0 + (-- &135659520) * &1 / &2)) /\
  (&648724384175)*(&41635449)+(&289460366665)*(&144601685)+(&116451365637485802) = (&790674921454)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &26116096) * x + (-- &42532864) * y <= &41635449 ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (&33882112) * ((&1) * x + (&0) * y) / s pow 1 + (-- &135659520) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &648724384175` [mpos] THEN
  note `&0:real < &289460366665` [npos] THEN
  note `&0:real < &116451365637485802` [ppos] THEN
  note `&0:real < &790674921454` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&648724384175)*(-- &26116096)+(&289460366665)*(-- &66748416))*s pow 1 = (&790674921454)*((&33882112) * &1 + (-- &135659520) * &1 / &2) /\ ((&648724384175)*(-- &42532864)+(&289460366665)*(-- &154992640))*s pow 1 = (&790674921454)*((&33882112) * &0 + (-- &135659520) * &1 / &2) /\ (&648724384175)*(&41635449)+(&289460366665)*(&144601685)+(&116451365637485802) = (&790674921454)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &2371601762596` in
let npos = REAL_ARITH `!s:real. &0:real < &998461492842` in
let ppos = REAL_ARITH `!s:real. &0:real < &4664109389297427825` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&2371601762596)*(-- &66748416)+(&998461492842)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&50659328) * &1 + (-- &175046656) * &1 / &2)) /\
  ((&2371601762596)*(-- &154992640)+(&998461492842)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&50659328) * &0 + (-- &175046656) * &1 / &2)) /\
  (&2371601762596)*(&144601685)+(&998461492842)*(&15704445)+(&4664109389297427825) = (&3256674611015)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (&50659328) * ((&1) * x + (&0) * y) / s pow 1 + (-- &175046656) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2371601762596` [mpos] THEN
  note `&0:real < &998461492842` [npos] THEN
  note `&0:real < &4664109389297427825` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2371601762596)*(-- &66748416)+(&998461492842)*(-- &3899392))*s pow 1 = (&3256674611015)*((&50659328) * &1 + (-- &175046656) * &1 / &2) /\ ((&2371601762596)*(-- &154992640)+(&998461492842)*(-- &17530880))*s pow 1 = (&3256674611015)*((&50659328) * &0 + (-- &175046656) * &1 / &2) /\ (&2371601762596)*(&144601685)+(&998461492842)*(&15704445)+(&4664109389297427825) = (&3256674611015)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &350430533728` in
let npos = REAL_ARITH `!s:real. &0:real < &1285148538806` in
let ppos = REAL_ARITH `!s:real. &0:real < &1323510459877251275` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&350430533728)*(-- &66748416)+(&1285148538806)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&11010048) * &1 + (-- &34930688) * &1 / &2)) /\
  ((&350430533728)*(-- &154992640)+(&1285148538806)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&11010048) * &0 + (-- &34930688) * &1 / &2)) /\
  (&350430533728)*(&144601685)+(&1285148538806)*(&15704445)+(&1323510459877251275) = (&3256674611015)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (&11010048) * ((&1) * x + (&0) * y) / s pow 1 + (-- &34930688) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &350430533728` [mpos] THEN
  note `&0:real < &1285148538806` [npos] THEN
  note `&0:real < &1323510459877251275` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&350430533728)*(-- &66748416)+(&1285148538806)*(-- &3899392))*s pow 1 = (&3256674611015)*((&11010048) * &1 + (-- &34930688) * &1 / &2) /\ ((&350430533728)*(-- &154992640)+(&1285148538806)*(-- &17530880))*s pow 1 = (&3256674611015)*((&11010048) * &0 + (-- &34930688) * &1 / &2) /\ (&350430533728)*(&144601685)+(&1285148538806)*(&15704445)+(&1323510459877251275) = (&3256674611015)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &854132676232` in
let npos = REAL_ARITH `!s:real. &0:real < &3887977006034` in
let ppos = REAL_ARITH `!s:real. &0:real < &3658948158750435719` in
let qpos = REAL_ARITH `!s:real. &0:real < &651334922203` in
let mqrel = REAL_ARITH `
  ((&854132676232)*(-- &66748416)+(&3887977006034)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&651334922203)*(((&145883136) * &1 + (-- &455802880) * &1 / &2)) /\
  ((&854132676232)*(-- &154992640)+(&3887977006034)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&651334922203)*(((&145883136) * &0 + (-- &455802880) * &1 / &2)) /\
  (&854132676232)*(&144601685)+(&3887977006034)*(&15704445)+(&3658948158750435719) = (&651334922203)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (&145883136) * ((&1) * x + (&0) * y) / s pow 1 + (-- &455802880) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &854132676232` [mpos] THEN
  note `&0:real < &3887977006034` [npos] THEN
  note `&0:real < &3658948158750435719` [ppos] THEN
  note `&0:real < &651334922203` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&854132676232)*(-- &66748416)+(&3887977006034)*(-- &3899392))*s pow 1 = (&651334922203)*((&145883136) * &1 + (-- &455802880) * &1 / &2) /\ ((&854132676232)*(-- &154992640)+(&3887977006034)*(-- &17530880))*s pow 1 = (&651334922203)*((&145883136) * &0 + (-- &455802880) * &1 / &2) /\ (&854132676232)*(&144601685)+(&3887977006034)*(&15704445)+(&3658948158750435719) = (&651334922203)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &82743789887` in
let npos = REAL_ARITH `!s:real. &0:real < &580166772999` in
let ppos = REAL_ARITH `!s:real. &0:real < &586675842586191925` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&82743789887)*(-- &66748416)+(&580166772999)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&3457024) * &1 + (-- &10452992) * &1 / &2)) /\
  ((&82743789887)*(-- &154992640)+(&580166772999)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&3457024) * &0 + (-- &10452992) * &1 / &2)) /\
  (&82743789887)*(&144601685)+(&580166772999)*(&15704445)+(&586675842586191925) = (&3256674611015)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (&3457024) * ((&1) * x + (&0) * y) / s pow 1 + (-- &10452992) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &82743789887` [mpos] THEN
  note `&0:real < &580166772999` [npos] THEN
  note `&0:real < &586675842586191925` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&82743789887)*(-- &66748416)+(&580166772999)*(-- &3899392))*s pow 1 = (&3256674611015)*((&3457024) * &1 + (-- &10452992) * &1 / &2) /\ ((&82743789887)*(-- &154992640)+(&580166772999)*(-- &17530880))*s pow 1 = (&3256674611015)*((&3457024) * &0 + (-- &10452992) * &1 / &2) /\ (&82743789887)*(&144601685)+(&580166772999)*(&15704445)+(&586675842586191925) = (&3256674611015)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &684411673836` in
let npos = REAL_ARITH `!s:real. &0:real < &14332010138347` in
let ppos = REAL_ARITH `!s:real. &0:real < &15869868041859323800` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&684411673836)*(-- &66748416)+(&14332010138347)*(-- &3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&58130432) * &1 + (-- &162430976) * &1 / &2)) /\
  ((&684411673836)*(-- &154992640)+(&14332010138347)*(-- &17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((&58130432) * &0 + (-- &162430976) * &1 / &2)) /\
  (&684411673836)*(&144601685)+(&14332010138347)*(&15704445)+(&15869868041859323800) = (&3256674611015)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &66748416) * x + (-- &154992640) * y <= &144601685 ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (&58130432) * ((&1) * x + (&0) * y) / s pow 1 + (-- &162430976) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &684411673836` [mpos] THEN
  note `&0:real < &14332010138347` [npos] THEN
  note `&0:real < &15869868041859323800` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&684411673836)*(-- &66748416)+(&14332010138347)*(-- &3899392))*s pow 1 = (&3256674611015)*((&58130432) * &1 + (-- &162430976) * &1 / &2) /\ ((&684411673836)*(-- &154992640)+(&14332010138347)*(-- &17530880))*s pow 1 = (&3256674611015)*((&58130432) * &0 + (-- &162430976) * &1 / &2) /\ (&684411673836)*(&144601685)+(&14332010138347)*(&15704445)+(&15869868041859323800) = (&3256674611015)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &98314685688340` in
let npos = REAL_ARITH `!s:real. &0:real < &7330876840430` in
let ppos = REAL_ARITH `!s:real. &0:real < &217830433787504806723` in
let qpos = REAL_ARITH `!s:real. &0:real < &5124491917453` in
let mqrel = REAL_ARITH `
  ((&98314685688340)*(-- &3899392)+(&7330876840430)*(-- &65536))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((&290521088) * &1 + (-- &691929088) * &1 / &2)) /\
  ((&98314685688340)*(-- &17530880)+(&7330876840430)*(-- &91619328))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((&290521088) * &0 + (-- &691929088) * &1 / &2)) /\
  (&98314685688340)*(&15704445)+(&7330876840430)*(&79611463)+(&217830433787504806723) = (&5124491917453)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (-- &65536) * x + (-- &91619328) * y <= &79611463 ==>
  (&290521088) * ((&1) * x + (&0) * y) / s pow 1 + (-- &691929088) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &98314685688340` [mpos] THEN
  note `&0:real < &7330876840430` [npos] THEN
  note `&0:real < &217830433787504806723` [ppos] THEN
  note `&0:real < &5124491917453` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&98314685688340)*(-- &3899392)+(&7330876840430)*(-- &65536))*s pow 1 = (&5124491917453)*((&290521088) * &1 + (-- &691929088) * &1 / &2) /\ ((&98314685688340)*(-- &17530880)+(&7330876840430)*(-- &91619328))*s pow 1 = (&5124491917453)*((&290521088) * &0 + (-- &691929088) * &1 / &2) /\ (&98314685688340)*(&15704445)+(&7330876840430)*(&79611463)+(&217830433787504806723) = (&5124491917453)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &3629992899445` in
let npos = REAL_ARITH `!s:real. &0:real < &3828053618565` in
let ppos = REAL_ARITH `!s:real. &0:real < &61918503421471282824` in
let qpos = REAL_ARITH `!s:real. &0:real < &20497967669812` in
let mqrel = REAL_ARITH `
  ((&3629992899445)*(-- &3899392)+(&3828053618565)*(-- &65536))*(&30902639 / &41749730) pow 1 = (&20497967669812)*(((&14442496) * &1 + (-- &29925376) * &1 / &2)) /\
  ((&3629992899445)*(-- &17530880)+(&3828053618565)*(-- &91619328))*(&30902639 / &41749730) pow 1 = (&20497967669812)*(((&14442496) * &0 + (-- &29925376) * &1 / &2)) /\
  (&3629992899445)*(&15704445)+(&3828053618565)*(&79611463)+(&61918503421471282824) = (&20497967669812)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3899392) * x + (-- &17530880) * y <= &15704445 ==>
  (-- &65536) * x + (-- &91619328) * y <= &79611463 ==>
  (&14442496) * ((&1) * x + (&0) * y) / s pow 1 + (-- &29925376) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3629992899445` [mpos] THEN
  note `&0:real < &3828053618565` [npos] THEN
  note `&0:real < &61918503421471282824` [ppos] THEN
  note `&0:real < &20497967669812` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3629992899445)*(-- &3899392)+(&3828053618565)*(-- &65536))*s pow 1 = (&20497967669812)*((&14442496) * &1 + (-- &29925376) * &1 / &2) /\ ((&3629992899445)*(-- &17530880)+(&3828053618565)*(-- &91619328))*s pow 1 = (&20497967669812)*((&14442496) * &0 + (-- &29925376) * &1 / &2) /\ (&3629992899445)*(&15704445)+(&3828053618565)*(&79611463)+(&61918503421471282824) = (&20497967669812)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &11086849550150` in
let npos = REAL_ARITH `!s:real. &0:real < &2109342483655` in
let ppos = REAL_ARITH `!s:real. &0:real < &220624888676913417823` in
let qpos = REAL_ARITH `!s:real. &0:real < &49869195491528` in
let mqrel = REAL_ARITH `
  ((&11086849550150)*(-- &65536)+(&2109342483655)*(&9371648))*(&30902639 / &41749730) pow 1 = (&49869195491528)*(((&19062784) * &1 + (-- &37560320) * &1 / &2)) /\
  ((&11086849550150)*(-- &91619328)+(&2109342483655)*(-- &118292480))*(&30902639 / &41749730) pow 1 = (&49869195491528)*(((&19062784) * &0 + (-- &37560320) * &1 / &2)) /\
  (&11086849550150)*(&79611463)+(&2109342483655)*(&101844089)+(&220624888676913417823) = (&49869195491528)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &65536) * x + (-- &91619328) * y <= &79611463 ==>
  (&9371648) * x + (-- &118292480) * y <= &101844089 ==>
  (&19062784) * ((&1) * x + (&0) * y) / s pow 1 + (-- &37560320) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11086849550150` [mpos] THEN
  note `&0:real < &2109342483655` [npos] THEN
  note `&0:real < &220624888676913417823` [ppos] THEN
  note `&0:real < &49869195491528` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&11086849550150)*(-- &65536)+(&2109342483655)*(&9371648))*s pow 1 = (&49869195491528)*((&19062784) * &1 + (-- &37560320) * &1 / &2) /\ ((&11086849550150)*(-- &91619328)+(&2109342483655)*(-- &118292480))*s pow 1 = (&49869195491528)*((&19062784) * &0 + (-- &37560320) * &1 / &2) /\ (&11086849550150)*(&79611463)+(&2109342483655)*(&101844089)+(&220624888676913417823) = (&49869195491528)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &1063407372830` in
let npos = REAL_ARITH `!s:real. &0:real < &1273638138245` in
let ppos = REAL_ARITH `!s:real. &0:real < &47632454933743574083` in
let qpos = REAL_ARITH `!s:real. &0:real < &12467298872882` in
let mqrel = REAL_ARITH `
  ((&1063407372830)*(-- &65536)+(&1273638138245)*(&9371648))*(&30902639 / &41749730) pow 1 = (&12467298872882)*(((&15433728) * &1 + (-- &29458432) * &1 / &2)) /\
  ((&1063407372830)*(-- &91619328)+(&1273638138245)*(-- &118292480))*(&30902639 / &41749730) pow 1 = (&12467298872882)*(((&15433728) * &0 + (-- &29458432) * &1 / &2)) /\
  (&1063407372830)*(&79611463)+(&1273638138245)*(&101844089)+(&47632454933743574083) = (&12467298872882)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &65536) * x + (-- &91619328) * y <= &79611463 ==>
  (&9371648) * x + (-- &118292480) * y <= &101844089 ==>
  (&15433728) * ((&1) * x + (&0) * y) / s pow 1 + (-- &29458432) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1063407372830` [mpos] THEN
  note `&0:real < &1273638138245` [npos] THEN
  note `&0:real < &47632454933743574083` [ppos] THEN
  note `&0:real < &12467298872882` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1063407372830)*(-- &65536)+(&1273638138245)*(&9371648))*s pow 1 = (&12467298872882)*((&15433728) * &1 + (-- &29458432) * &1 / &2) /\ ((&1063407372830)*(-- &91619328)+(&1273638138245)*(-- &118292480))*s pow 1 = (&12467298872882)*((&15433728) * &0 + (-- &29458432) * &1 / &2) /\ (&1063407372830)*(&79611463)+(&1273638138245)*(&101844089)+(&47632454933743574083) = (&12467298872882)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &983060017445` in
let npos = REAL_ARITH `!s:real. &0:real < &4395578573320` in
let ppos = REAL_ARITH `!s:real. &0:real < &3312591085209734846` in
let qpos = REAL_ARITH `!s:real. &0:real < &1970012333611` in
let mqrel = REAL_ARITH `
  ((&983060017445)*(&1130496)+(&4395578573320)*(&481280))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((&5660672) * &1 + (-- &8896512) * &1 / &2)) /\
  ((&983060017445)*(-- &7061504)+(&4395578573320)*(-- &1114112))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((&5660672) * &0 + (-- &8896512) * &1 / &2)) /\
  (&983060017445)*(&6069771)+(&4395578573320)*(&1004531)+(&3312591085209734846) = (&1970012333611)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1130496) * x + (-- &7061504) * y <= &6069771 ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&5660672) * ((&1) * x + (&0) * y) / s pow 1 + (-- &8896512) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &983060017445` [mpos] THEN
  note `&0:real < &4395578573320` [npos] THEN
  note `&0:real < &3312591085209734846` [ppos] THEN
  note `&0:real < &1970012333611` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&983060017445)*(&1130496)+(&4395578573320)*(&481280))*s pow 1 = (&1970012333611)*((&5660672) * &1 + (-- &8896512) * &1 / &2) /\ ((&983060017445)*(-- &7061504)+(&4395578573320)*(-- &1114112))*s pow 1 = (&1970012333611)*((&5660672) * &0 + (-- &8896512) * &1 / &2) /\ (&983060017445)*(&6069771)+(&4395578573320)*(&1004531)+(&3312591085209734846) = (&1970012333611)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &314878634645960` in
let npos = REAL_ARITH `!s:real. &0:real < &1442933293395` in
let ppos = REAL_ARITH `!s:real. &0:real < &153491172316503021734` in
let qpos = REAL_ARITH `!s:real. &0:real < &1314381944587` in
let mqrel = REAL_ARITH `
  ((&314878634645960)*(&481280)+(&1442933293395)*(&44220416))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((&373096448) * &1 + (-- &503644160) * &1 / &2)) /\
  ((&314878634645960)*(-- &1114112)+(&1442933293395)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((&373096448) * &0 + (-- &503644160) * &1 / &2)) /\
  (&314878634645960)*(&1004531)+(&1442933293395)*(&62719715)+(&153491172316503021734) = (&1314381944587)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&373096448) * ((&1) * x + (&0) * y) / s pow 1 + (-- &503644160) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &314878634645960` [mpos] THEN
  note `&0:real < &1442933293395` [npos] THEN
  note `&0:real < &153491172316503021734` [ppos] THEN
  note `&0:real < &1314381944587` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&314878634645960)*(&481280)+(&1442933293395)*(&44220416))*s pow 1 = (&1314381944587)*((&373096448) * &1 + (-- &503644160) * &1 / &2) /\ ((&314878634645960)*(-- &1114112)+(&1442933293395)*(-- &66781184))*s pow 1 = (&1314381944587)*((&373096448) * &0 + (-- &503644160) * &1 / &2) /\ (&314878634645960)*(&1004531)+(&1442933293395)*(&62719715)+(&153491172316503021734) = (&1314381944587)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &8279138457920` in
let npos = REAL_ARITH `!s:real. &0:real < &154640999920` in
let ppos = REAL_ARITH `!s:real. &0:real < &7251297775649321505` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&8279138457920)*(&481280)+(&154640999920)*(&44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&5701632) * &1 + (-- &7340032) * &1 / &2)) /\
  ((&8279138457920)*(-- &1114112)+(&154640999920)*(-- &66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((&5701632) * &0 + (-- &7340032) * &1 / &2)) /\
  (&8279138457920)*(&1004531)+(&154640999920)*(&62719715)+(&7251297775649321505) = (&3943145833761)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&481280) * x + (-- &1114112) * y <= &1004531 ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&5701632) * ((&1) * x + (&0) * y) / s pow 1 + (-- &7340032) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8279138457920` [mpos] THEN
  note `&0:real < &154640999920` [npos] THEN
  note `&0:real < &7251297775649321505` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&8279138457920)*(&481280)+(&154640999920)*(&44220416))*s pow 1 = (&3943145833761)*((&5701632) * &1 + (-- &7340032) * &1 / &2) /\ ((&8279138457920)*(-- &1114112)+(&154640999920)*(-- &66781184))*s pow 1 = (&3943145833761)*((&5701632) * &0 + (-- &7340032) * &1 / &2) /\ (&8279138457920)*(&1004531)+(&154640999920)*(&62719715)+(&7251297775649321505) = (&3943145833761)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &2619469909606` in
let npos = REAL_ARITH `!s:real. &0:real < &3621033407387` in
let ppos = REAL_ARITH `!s:real. &0:real < &222348778460721813670` in
let qpos = REAL_ARITH `!s:real. &0:real < &13901706667345` in
let mqrel = REAL_ARITH `
  ((&2619469909606)*(&44220416)+(&3621033407387)*(&75169792))*(&30902639 / &41749730) pow 1 = (&13901706667345)*(((&46596096) * &1 + (-- &51871744) * &1 / &2)) /\
  ((&2619469909606)*(-- &66781184)+(&3621033407387)*(-- &86212608))*(&30902639 / &41749730) pow 1 = (&13901706667345)*(((&46596096) * &0 + (-- &51871744) * &1 / &2)) /\
  (&2619469909606)*(&62719715)+(&3621033407387)*(&85043005)+(&222348778460721813670) = (&13901706667345)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&44220416) * x + (-- &66781184) * y <= &62719715 ==>
  (&75169792) * x + (-- &86212608) * y <= &85043005 ==>
  (&46596096) * ((&1) * x + (&0) * y) / s pow 1 + (-- &51871744) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2619469909606` [mpos] THEN
  note `&0:real < &3621033407387` [npos] THEN
  note `&0:real < &222348778460721813670` [ppos] THEN
  note `&0:real < &13901706667345` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2619469909606)*(&44220416)+(&3621033407387)*(&75169792))*s pow 1 = (&13901706667345)*((&46596096) * &1 + (-- &51871744) * &1 / &2) /\ ((&2619469909606)*(-- &66781184)+(&3621033407387)*(-- &86212608))*s pow 1 = (&13901706667345)*((&46596096) * &0 + (-- &51871744) * &1 / &2) /\ (&2619469909606)*(&62719715)+(&3621033407387)*(&85043005)+(&222348778460721813670) = (&13901706667345)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &9850765294040` in
let npos = REAL_ARITH `!s:real. &0:real < &26867788243120` in
let ppos = REAL_ARITH `!s:real. &0:real < &101084186227098370251` in
let qpos = REAL_ARITH `!s:real. &0:real < &3609829969507` in
let mqrel = REAL_ARITH `
  ((&9850765294040)*(&11419648)+(&26867788243120)*(&4050944))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((&84901888) * &1 + (-- &79036416) * &1 / &2)) /\
  ((&9850765294040)*(-- &10895360)+(&26867788243120)*(-- &3178496))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((&84901888) * &0 + (-- &79036416) * &1 / &2)) /\
  (&9850765294040)*(&11507295)+(&26867788243120)*(&3679349)+(&101084186227098370251) = (&3609829969507)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11419648) * x + (-- &10895360) * y <= &11507295 ==>
  (&4050944) * x + (-- &3178496) * y <= &3679349 ==>
  (&84901888) * ((&1) * x + (&0) * y) / s pow 1 + (-- &79036416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9850765294040` [mpos] THEN
  note `&0:real < &26867788243120` [npos] THEN
  note `&0:real < &101084186227098370251` [ppos] THEN
  note `&0:real < &3609829969507` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&9850765294040)*(&11419648)+(&26867788243120)*(&4050944))*s pow 1 = (&3609829969507)*((&84901888) * &1 + (-- &79036416) * &1 / &2) /\ ((&9850765294040)*(-- &10895360)+(&26867788243120)*(-- &3178496))*s pow 1 = (&3609829969507)*((&84901888) * &0 + (-- &79036416) * &1 / &2) /\ (&9850765294040)*(&11507295)+(&26867788243120)*(&3679349)+(&101084186227098370251) = (&3609829969507)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &241710061835` in
let npos = REAL_ARITH `!s:real. &0:real < &550365815725` in
let ppos = REAL_ARITH `!s:real. &0:real < &7139996283847943699` in
let qpos = REAL_ARITH `!s:real. &0:real < &181120367179` in
let mqrel = REAL_ARITH `
  ((&241710061835)*(&8454144)+(&550365815725)*(&34471936))*(&30902639 / &41749730) pow 1 = (&181120367179)*(((&134447104) * &1 + (-- &97124352) * &1 / &2)) /\
  ((&241710061835)*(-- &5439488)+(&550365815725)*(-- &19202048))*(&30902639 / &41749730) pow 1 = (&181120367179)*(((&134447104) * &0 + (-- &97124352) * &1 / &2)) /\
  (&241710061835)*(&7031327)+(&550365815725)*(&27364823)+(&7139996283847943699) = (&181120367179)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&8454144) * x + (-- &5439488) * y <= &7031327 ==>
  (&34471936) * x + (-- &19202048) * y <= &27364823 ==>
  (&134447104) * ((&1) * x + (&0) * y) / s pow 1 + (-- &97124352) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &241710061835` [mpos] THEN
  note `&0:real < &550365815725` [npos] THEN
  note `&0:real < &7139996283847943699` [ppos] THEN
  note `&0:real < &181120367179` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&241710061835)*(&8454144)+(&550365815725)*(&34471936))*s pow 1 = (&181120367179)*((&134447104) * &1 + (-- &97124352) * &1 / &2) /\ ((&241710061835)*(-- &5439488)+(&550365815725)*(-- &19202048))*s pow 1 = (&181120367179)*((&134447104) * &0 + (-- &97124352) * &1 / &2) /\ (&241710061835)*(&7031327)+(&550365815725)*(&27364823)+(&7139996283847943699) = (&181120367179)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &128756167320` in
let npos = REAL_ARITH `!s:real. &0:real < &7950401083900` in
let ppos = REAL_ARITH `!s:real. &0:real < &929325401272335347` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&128756167320)*(&24879104)+(&7950401083900)*(&131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&100401152) * &1 + (-- &50266112) * &1 / &2)) /\
  ((&128756167320)*(-- &8986624)+(&7950401083900)*(-- &32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&100401152) * &0 + (-- &50266112) * &1 / &2)) /\
  (&128756167320)*(&18073405)+(&7950401083900)*(&92351)+(&929325401272335347) = (&41749465289)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&24879104) * x + (-- &8986624) * y <= &18073405 ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&100401152) * ((&1) * x + (&0) * y) / s pow 1 + (-- &50266112) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &128756167320` [mpos] THEN
  note `&0:real < &7950401083900` [npos] THEN
  note `&0:real < &929325401272335347` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&128756167320)*(&24879104)+(&7950401083900)*(&131072))*s pow 1 = (&41749465289)*((&100401152) * &1 + (-- &50266112) * &1 / &2) /\ ((&128756167320)*(-- &8986624)+(&7950401083900)*(-- &32768))*s pow 1 = (&41749465289)*((&100401152) * &0 + (-- &50266112) * &1 / &2) /\ (&128756167320)*(&18073405)+(&7950401083900)*(&92351)+(&929325401272335347) = (&41749465289)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &17618386060` in
let npos = REAL_ARITH `!s:real. &0:real < &18660375821340` in
let ppos = REAL_ARITH `!s:real. &0:real < &509679048622657487` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&17618386060)*(&24879104)+(&18660375821340)*(&131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&64782336) * &1 + (-- &27295744) * &1 / &2)) /\
  ((&17618386060)*(-- &8986624)+(&18660375821340)*(-- &32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((&64782336) * &0 + (-- &27295744) * &1 / &2)) /\
  (&17618386060)*(&18073405)+(&18660375821340)*(&92351)+(&509679048622657487) = (&41749465289)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&24879104) * x + (-- &8986624) * y <= &18073405 ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&64782336) * ((&1) * x + (&0) * y) / s pow 1 + (-- &27295744) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &17618386060` [mpos] THEN
  note `&0:real < &18660375821340` [npos] THEN
  note `&0:real < &509679048622657487` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&17618386060)*(&24879104)+(&18660375821340)*(&131072))*s pow 1 = (&41749465289)*((&64782336) * &1 + (-- &27295744) * &1 / &2) /\ ((&17618386060)*(-- &8986624)+(&18660375821340)*(-- &32768))*s pow 1 = (&41749465289)*((&64782336) * &0 + (-- &27295744) * &1 / &2) /\ (&17618386060)*(&18073405)+(&18660375821340)*(&92351)+(&509679048622657487) = (&41749465289)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &208706900270` in
let npos = REAL_ARITH `!s:real. &0:real < &208748650` in
let ppos = REAL_ARITH `!s:real. &0:real < &10246150371539421` in
let qpos = REAL_ARITH `!s:real. &0:real < &4728103767` in
let mqrel = REAL_ARITH `
  ((&208706900270)*(&131072)+(&208748650)*(&191823872))*(&30902639 / &41749730) pow 1 = (&4728103767)*(((&12943360) * &1 + (-- &4784128) * &1 / &2)) /\
  ((&208706900270)*(-- &32768)+(&208748650)*(-- &40435712))*(&30902639 / &41749730) pow 1 = (&4728103767)*(((&12943360) * &0 + (-- &4784128) * &1 / &2)) /\
  (&208706900270)*(&92351)+(&208748650)*(&133937273)+(&10246150371539421) = (&4728103767)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&191823872) * x + (-- &40435712) * y <= &133937273 ==>
  (&12943360) * ((&1) * x + (&0) * y) / s pow 1 + (-- &4784128) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &208706900270` [mpos] THEN
  note `&0:real < &208748650` [npos] THEN
  note `&0:real < &10246150371539421` [ppos] THEN
  note `&0:real < &4728103767` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&208706900270)*(&131072)+(&208748650)*(&191823872))*s pow 1 = (&4728103767)*((&12943360) * &1 + (-- &4784128) * &1 / &2) /\ ((&208706900270)*(-- &32768)+(&208748650)*(-- &40435712))*s pow 1 = (&4728103767)*((&12943360) * &0 + (-- &4784128) * &1 / &2) /\ (&208706900270)*(&92351)+(&208748650)*(&133937273)+(&10246150371539421) = (&4728103767)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &26609023416580` in
let npos = REAL_ARITH `!s:real. &0:real < &64732956365` in
let ppos = REAL_ARITH `!s:real. &0:real < &2345608432843465572` in
let qpos = REAL_ARITH `!s:real. &0:real < &14184311301` in
let mqrel = REAL_ARITH `
  ((&26609023416580)*(&131072)+(&64732956365)*(&191823872))*(&30902639 / &41749730) pow 1 = (&14184311301)*(((&1012072448) * &1 + (-- &364183552) * &1 / &2)) /\
  ((&26609023416580)*(-- &32768)+(&64732956365)*(-- &40435712))*(&30902639 / &41749730) pow 1 = (&14184311301)*(((&1012072448) * &0 + (-- &364183552) * &1 / &2)) /\
  (&26609023416580)*(&92351)+(&64732956365)*(&133937273)+(&2345608432843465572) = (&14184311301)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&131072) * x + (-- &32768) * y <= &92351 ==>
  (&191823872) * x + (-- &40435712) * y <= &133937273 ==>
  (&1012072448) * ((&1) * x + (&0) * y) / s pow 1 + (-- &364183552) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26609023416580` [mpos] THEN
  note `&0:real < &64732956365` [npos] THEN
  note `&0:real < &2345608432843465572` [ppos] THEN
  note `&0:real < &14184311301` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&26609023416580)*(&131072)+(&64732956365)*(&191823872))*s pow 1 = (&14184311301)*((&1012072448) * &1 + (-- &364183552) * &1 / &2) /\ ((&26609023416580)*(-- &32768)+(&64732956365)*(-- &40435712))*s pow 1 = (&14184311301)*((&1012072448) * &0 + (-- &364183552) * &1 / &2) /\ (&26609023416580)*(&92351)+(&64732956365)*(&133937273)+(&2345608432843465572) = (&14184311301)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &5719713010` in
let npos = REAL_ARITH `!s:real. &0:real < &40204989990` in
let ppos = REAL_ARITH `!s:real. &0:real < &210482707446521601` in
let qpos = REAL_ARITH `!s:real. &0:real < &341566868867` in
let mqrel = REAL_ARITH `
  ((&5719713010)*(&191823872)+(&40204989990)*(&9568256))*(&30902639 / &41749730) pow 1 = (&341566868867)*(((&3866624) * &1 + (-- &1310720) * &1 / &2)) /\
  ((&5719713010)*(-- &40435712)+(&40204989990)*(-- &1769472))*(&30902639 / &41749730) pow 1 = (&341566868867)*(((&3866624) * &0 + (-- &1310720) * &1 / &2)) /\
  (&5719713010)*(&133937273)+(&40204989990)*(&6651805)+(&210482707446521601) = (&341566868867)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&191823872) * x + (-- &40435712) * y <= &133937273 ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&3866624) * ((&1) * x + (&0) * y) / s pow 1 + (-- &1310720) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5719713010` [mpos] THEN
  note `&0:real < &40204989990` [npos] THEN
  note `&0:real < &210482707446521601` [ppos] THEN
  note `&0:real < &341566868867` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&5719713010)*(&191823872)+(&40204989990)*(&9568256))*s pow 1 = (&341566868867)*((&3866624) * &1 + (-- &1310720) * &1 / &2) /\ ((&5719713010)*(-- &40435712)+(&40204989990)*(-- &1769472))*s pow 1 = (&341566868867)*((&3866624) * &0 + (-- &1310720) * &1 / &2) /\ (&5719713010)*(&133937273)+(&40204989990)*(&6651805)+(&210482707446521601) = (&341566868867)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &605371085` in
let npos = REAL_ARITH `!s:real. &0:real < &264254916035` in
let ppos = REAL_ARITH `!s:real. &0:real < &118998460001722119` in
let qpos = REAL_ARITH `!s:real. &0:real < &29944657191` in
let mqrel = REAL_ARITH `
  ((&605371085)*(&9568256)+(&264254916035)*(&5767168))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((&39124992) * &1 + (-- &2621440) * &1 / &2)) /\
  ((&605371085)*(-- &1769472)+(&264254916035)*(-- &196608))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((&39124992) * &0 + (-- &2621440) * &1 / &2)) /\
  (&605371085)*(&6651805)+(&264254916035)*(&3914969)+(&118998460001722119) = (&29944657191)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&9568256) * x + (-- &1769472) * y <= &6651805 ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&39124992) * ((&1) * x + (&0) * y) / s pow 1 + (-- &2621440) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &605371085` [mpos] THEN
  note `&0:real < &264254916035` [npos] THEN
  note `&0:real < &118998460001722119` [ppos] THEN
  note `&0:real < &29944657191` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&605371085)*(&9568256)+(&264254916035)*(&5767168))*s pow 1 = (&29944657191)*((&39124992) * &1 + (-- &2621440) * &1 / &2) /\ ((&605371085)*(-- &1769472)+(&264254916035)*(-- &196608))*s pow 1 = (&29944657191)*((&39124992) * &0 + (-- &2621440) * &1 / &2) /\ (&605371085)*(&6651805)+(&264254916035)*(&3914969)+(&118998460001722119) = (&29944657191)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &151530645035` in
let npos = REAL_ARITH `!s:real. &0:real < &77508373745` in
let ppos = REAL_ARITH `!s:real. &0:real < &1191225354704564972` in
let qpos = REAL_ARITH `!s:real. &0:real < &3838973037692` in
let mqrel = REAL_ARITH `
  ((&151530645035)*(&5767168)+(&77508373745)*(&413007872))*(&30902639 / &41749730) pow 1 = (&3838973037692)*(((&5865472) * &1 + (&950272) * &1 / &2)) /\
  ((&151530645035)*(-- &196608)+(&77508373745)*(&32178176))*(&30902639 / &41749730) pow 1 = (&3838973037692)*(((&5865472) * &0 + (&950272) * &1 / &2)) /\
  (&151530645035)*(&3914969)+(&77508373745)*(&275907781)+(&1191225354704564972) = (&3838973037692)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5767168) * x + (-- &196608) * y <= &3914969 ==>
  (&413007872) * x + (&32178176) * y <= &275907781 ==>
  (&5865472) * ((&1) * x + (&0) * y) / s pow 1 + (&950272) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &151530645035` [mpos] THEN
  note `&0:real < &77508373745` [npos] THEN
  note `&0:real < &1191225354704564972` [ppos] THEN
  note `&0:real < &3838973037692` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&151530645035)*(&5767168)+(&77508373745)*(&413007872))*s pow 1 = (&3838973037692)*((&5865472) * &1 + (&950272) * &1 / &2) /\ ((&151530645035)*(-- &196608)+(&77508373745)*(&32178176))*s pow 1 = (&3838973037692)*((&5865472) * &0 + (&950272) * &1 / &2) /\ (&151530645035)*(&3914969)+(&77508373745)*(&275907781)+(&1191225354704564972) = (&3838973037692)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &12833157256590` in
let npos = REAL_ARITH `!s:real. &0:real < &413284021622725` in
let ppos = REAL_ARITH `!s:real. &0:real < &234741277118662323` in
let qpos = REAL_ARITH `!s:real. &0:real < &25936399496866` in
let mqrel = REAL_ARITH `
  ((&12833157256590)*(&413007872)+(&413284021622725)*(&32309248))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&439386112) * &1 + (&185892864) * &1 / &2)) /\
  ((&12833157256590)*(&32178176)+(&413284021622725)*(&6881280))*(&30902639 / &41749730) pow 1 = (&25936399496866)*(((&439386112) * &0 + (&185892864) * &1 / &2)) /\
  (&12833157256590)*(&275907781)+(&413284021622725)*(&21583161)+(&234741277118662323) = (&25936399496866)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&413007872) * x + (&32178176) * y <= &275907781 ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&439386112) * ((&1) * x + (&0) * y) / s pow 1 + (&185892864) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12833157256590` [mpos] THEN
  note `&0:real < &413284021622725` [npos] THEN
  note `&0:real < &234741277118662323` [ppos] THEN
  note `&0:real < &25936399496866` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12833157256590)*(&413007872)+(&413284021622725)*(&32309248))*s pow 1 = (&25936399496866)*((&439386112) * &1 + (&185892864) * &1 / &2) /\ ((&12833157256590)*(&32178176)+(&413284021622725)*(&6881280))*s pow 1 = (&25936399496866)*((&439386112) * &0 + (&185892864) * &1 / &2) /\ (&12833157256590)*(&275907781)+(&413284021622725)*(&21583161)+(&234741277118662323) = (&25936399496866)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &21328308817530` in
let npos = REAL_ARITH `!s:real. &0:real < &38910748360` in
let ppos = REAL_ARITH `!s:real. &0:real < &21966070735619059` in
let qpos = REAL_ARITH `!s:real. &0:real < &8127733986029` in
let mqrel = REAL_ARITH `
  ((&21328308817530)*(&32309248)+(&38910748360)*(&137199616))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((&49741824) * &1 + (&27000832) * &1 / &2)) /\
  ((&21328308817530)*(&6881280)+(&38910748360)*(&37961728))*(&30902639 / &41749730) pow 1 = (&8127733986029)*(((&49741824) * &0 + (&27000832) * &1 / &2)) /\
  (&21328308817530)*(&21583161)+(&38910748360)*(&91847345)+(&21966070735619059) = (&8127733986029)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&137199616) * x + (&37961728) * y <= &91847345 ==>
  (&49741824) * ((&1) * x + (&0) * y) / s pow 1 + (&27000832) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &21328308817530` [mpos] THEN
  note `&0:real < &38910748360` [npos] THEN
  note `&0:real < &21966070735619059` [ppos] THEN
  note `&0:real < &8127733986029` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&21328308817530)*(&32309248)+(&38910748360)*(&137199616))*s pow 1 = (&8127733986029)*((&49741824) * &1 + (&27000832) * &1 / &2) /\ ((&21328308817530)*(&6881280)+(&38910748360)*(&37961728))*s pow 1 = (&8127733986029)*((&49741824) * &0 + (&27000832) * &1 / &2) /\ (&21328308817530)*(&21583161)+(&38910748360)*(&91847345)+(&21966070735619059) = (&8127733986029)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &40893860535` in
let npos = REAL_ARITH `!s:real. &0:real < &14826164117600` in
let ppos = REAL_ARITH `!s:real. &0:real < &64996587731572973` in
let qpos = REAL_ARITH `!s:real. &0:real < &32510935944116` in
let mqrel = REAL_ARITH `
  ((&40893860535)*(&32309248)+(&14826164117600)*(&137199616))*(&30902639 / &41749730) pow 1 = (&32510935944116)*(((&33521664) * &1 + (&25640960) * &1 / &2)) /\
  ((&40893860535)*(&6881280)+(&14826164117600)*(&37961728))*(&30902639 / &41749730) pow 1 = (&32510935944116)*(((&33521664) * &0 + (&25640960) * &1 / &2)) /\
  (&40893860535)*(&21583161)+(&14826164117600)*(&91847345)+(&64996587731572973) = (&32510935944116)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&32309248) * x + (&6881280) * y <= &21583161 ==>
  (&137199616) * x + (&37961728) * y <= &91847345 ==>
  (&33521664) * ((&1) * x + (&0) * y) / s pow 1 + (&25640960) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &40893860535` [mpos] THEN
  note `&0:real < &14826164117600` [npos] THEN
  note `&0:real < &64996587731572973` [ppos] THEN
  note `&0:real < &32510935944116` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&40893860535)*(&32309248)+(&14826164117600)*(&137199616))*s pow 1 = (&32510935944116)*((&33521664) * &1 + (&25640960) * &1 / &2) /\ ((&40893860535)*(&6881280)+(&14826164117600)*(&37961728))*s pow 1 = (&32510935944116)*((&33521664) * &0 + (&25640960) * &1 / &2) /\ (&40893860535)*(&21583161)+(&14826164117600)*(&91847345)+(&64996587731572973) = (&32510935944116)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &75149514` in
let npos = REAL_ARITH `!s:real. &0:real < &31884268801` in
let ppos = REAL_ARITH `!s:real. &0:real < &32631338415331` in
let qpos = REAL_ARITH `!s:real. &0:real < &247653748946` in
let mqrel = REAL_ARITH `
  ((&75149514)*(&137199616)+(&31884268801)*(&27099136))*(&30902639 / &41749730) pow 1 = (&247653748946)*(((&1867776) * &1 + (&1490944) * &1 / &2)) /\
  ((&75149514)*(&37961728)+(&31884268801)*(&7733248))*(&30902639 / &41749730) pow 1 = (&247653748946)*(((&1867776) * &0 + (&1490944) * &1 / &2)) /\
  (&75149514)*(&91847345)+(&31884268801)*(&18176645)+(&32631338415331) = (&247653748946)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&137199616) * x + (&37961728) * y <= &91847345 ==>
  (&27099136) * x + (&7733248) * y <= &18176645 ==>
  (&1867776) * ((&1) * x + (&0) * y) / s pow 1 + (&1490944) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &75149514` [mpos] THEN
  note `&0:real < &31884268801` [npos] THEN
  note `&0:real < &32631338415331` [ppos] THEN
  note `&0:real < &247653748946` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&75149514)*(&137199616)+(&31884268801)*(&27099136))*s pow 1 = (&247653748946)*((&1867776) * &1 + (&1490944) * &1 / &2) /\ ((&75149514)*(&37961728)+(&31884268801)*(&7733248))*s pow 1 = (&247653748946)*((&1867776) * &0 + (&1490944) * &1 / &2) /\ (&75149514)*(&91847345)+(&31884268801)*(&18176645)+(&32631338415331) = (&247653748946)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &4362846785` in
let npos = REAL_ARITH `!s:real. &0:real < &1293302261075` in
let ppos = REAL_ARITH `!s:real. &0:real < &3504406119778672` in
let qpos = REAL_ARITH `!s:real. &0:real < &5673848130956` in
let mqrel = REAL_ARITH `
  ((&4362846785)*(&27099136)+(&1293302261075)*(&68321280))*(&30902639 / &41749730) pow 1 = (&5673848130956)*(((&7634944) * &1 + (&7815168) * &1 / &2)) /\
  ((&4362846785)*(&7733248)+(&1293302261075)*(&23134208))*(&30902639 / &41749730) pow 1 = (&5673848130956)*(((&7634944) * &0 + (&7815168) * &1 / &2)) /\
  (&4362846785)*(&18176645)+(&1293302261075)*(&46464197)+(&3504406119778672) = (&5673848130956)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&27099136) * x + (&7733248) * y <= &18176645 ==>
  (&68321280) * x + (&23134208) * y <= &46464197 ==>
  (&7634944) * ((&1) * x + (&0) * y) / s pow 1 + (&7815168) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4362846785` [mpos] THEN
  note `&0:real < &1293302261075` [npos] THEN
  note `&0:real < &3504406119778672` [ppos] THEN
  note `&0:real < &5673848130956` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4362846785)*(&27099136)+(&1293302261075)*(&68321280))*s pow 1 = (&5673848130956)*((&7634944) * &1 + (&7815168) * &1 / &2) /\ ((&4362846785)*(&7733248)+(&1293302261075)*(&23134208))*s pow 1 = (&5673848130956)*((&7634944) * &0 + (&7815168) * &1 / &2) /\ (&4362846785)*(&18176645)+(&1293302261075)*(&46464197)+(&3504406119778672) = (&5673848130956)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &125249190` in
let npos = REAL_ARITH `!s:real. &0:real < &55339267115` in
let ppos = REAL_ARITH `!s:real. &0:real < &62999125380957` in
let qpos = REAL_ARITH `!s:real. &0:real < &730414775404` in
let mqrel = REAL_ARITH `
  ((&125249190)*(&68321280)+(&55339267115)*(&26869760))*(&30902639 / &41749730) pow 1 = (&730414775404)*(((&950272) * &1 + (&1130496) * &1 / &2)) /\
  ((&125249190)*(&23134208)+(&55339267115)*(&10027008))*(&30902639 / &41749730) pow 1 = (&730414775404)*(((&950272) * &0 + (&1130496) * &1 / &2)) /\
  (&125249190)*(&46464197)+(&55339267115)*(&18466107)+(&62999125380957) = (&730414775404)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&68321280) * x + (&23134208) * y <= &46464197 ==>
  (&26869760) * x + (&10027008) * y <= &18466107 ==>
  (&950272) * ((&1) * x + (&0) * y) / s pow 1 + (&1130496) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &125249190` [mpos] THEN
  note `&0:real < &55339267115` [npos] THEN
  note `&0:real < &62999125380957` [ppos] THEN
  note `&0:real < &730414775404` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&125249190)*(&68321280)+(&55339267115)*(&26869760))*s pow 1 = (&730414775404)*((&950272) * &1 + (&1130496) * &1 / &2) /\ ((&125249190)*(&23134208)+(&55339267115)*(&10027008))*s pow 1 = (&730414775404)*((&950272) * &0 + (&1130496) * &1 / &2) /\ (&125249190)*(&46464197)+(&55339267115)*(&18466107)+(&62999125380957) = (&730414775404)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &2223841118180` in
let npos = REAL_ARITH `!s:real. &0:real < &60871106340` in
let ppos = REAL_ARITH `!s:real. &0:real < &3286619764726673` in
let qpos = REAL_ARITH `!s:real. &0:real < &122343547801` in
let mqrel = REAL_ARITH `
  ((&2223841118180)*(&52412416)+(&60871106340)*(&7979008))*(&30902639 / &41749730) pow 1 = (&122343547801)*(((&438239232) * &1 + (&539754496) * &1 / &2)) /\
  ((&2223841118180)*(&19972096)+(&60871106340)*(&3162112))*(&30902639 / &41749730) pow 1 = (&122343547801)*(((&438239232) * &0 + (&539754496) * &1 / &2)) /\
  (&2223841118180)*(&36108393)+(&60871106340)*(&5552625)+(&3286619764726673) = (&122343547801)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&52412416) * x + (&19972096) * y <= &36108393 ==>
  (&7979008) * x + (&3162112) * y <= &5552625 ==>
  (&438239232) * ((&1) * x + (&0) * y) / s pow 1 + (&539754496) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2223841118180` [mpos] THEN
  note `&0:real < &60871106340` [npos] THEN
  note `&0:real < &3286619764726673` [ppos] THEN
  note `&0:real < &122343547801` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2223841118180)*(&52412416)+(&60871106340)*(&7979008))*s pow 1 = (&122343547801)*((&438239232) * &1 + (&539754496) * &1 / &2) /\ ((&2223841118180)*(&19972096)+(&60871106340)*(&3162112))*s pow 1 = (&122343547801)*((&438239232) * &0 + (&539754496) * &1 / &2) /\ (&2223841118180)*(&36108393)+(&60871106340)*(&5552625)+(&3286619764726673) = (&122343547801)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &15614399020` in
let npos = REAL_ARITH `!s:real. &0:real < &1237378497740` in
let ppos = REAL_ARITH `!s:real. &0:real < &304214617341411` in
let qpos = REAL_ARITH `!s:real. &0:real < &367030643403` in
let mqrel = REAL_ARITH `
  ((&15614399020)*(&52412416)+(&1237378497740)*(&7979008))*(&30902639 / &41749730) pow 1 = (&367030643403)*(((&13041664) * &1 + (&17039360) * &1 / &2)) /\
  ((&15614399020)*(&19972096)+(&1237378497740)*(&3162112))*(&30902639 / &41749730) pow 1 = (&367030643403)*(((&13041664) * &0 + (&17039360) * &1 / &2)) /\
  (&15614399020)*(&36108393)+(&1237378497740)*(&5552625)+(&304214617341411) = (&367030643403)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&52412416) * x + (&19972096) * y <= &36108393 ==>
  (&7979008) * x + (&3162112) * y <= &5552625 ==>
  (&13041664) * ((&1) * x + (&0) * y) / s pow 1 + (&17039360) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &15614399020` [mpos] THEN
  note `&0:real < &1237378497740` [npos] THEN
  note `&0:real < &304214617341411` [ppos] THEN
  note `&0:real < &367030643403` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&15614399020)*(&52412416)+(&1237378497740)*(&7979008))*s pow 1 = (&367030643403)*((&13041664) * &1 + (&17039360) * &1 / &2) /\ ((&15614399020)*(&19972096)+(&1237378497740)*(&3162112))*s pow 1 = (&367030643403)*((&13041664) * &0 + (&17039360) * &1 / &2) /\ (&15614399020)*(&36108393)+(&1237378497740)*(&5552625)+(&304214617341411) = (&367030643403)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &7347952480` in
let npos = REAL_ARITH `!s:real. &0:real < &335396455955` in
let ppos = REAL_ARITH `!s:real. &0:real < &1563371233148745` in
let qpos = REAL_ARITH `!s:real. &0:real < &2208240777662` in
let mqrel = REAL_ARITH `
  ((&7347952480)*(&7979008)+(&335396455955)*(&121733120))*(&30902639 / &41749730) pow 1 = (&2208240777662)*(((&7733248) * &1 + (&11943936) * &1 / &2)) /\
  ((&7347952480)*(&3162112)+(&335396455955)*(&53051392))*(&30902639 / &41749730) pow 1 = (&2208240777662)*(((&7733248) * &0 + (&11943936) * &1 / &2)) /\
  (&7347952480)*(&5552625)+(&335396455955)*(&86950107)+(&1563371233148745) = (&2208240777662)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7979008) * x + (&3162112) * y <= &5552625 ==>
  (&121733120) * x + (&53051392) * y <= &86950107 ==>
  (&7733248) * ((&1) * x + (&0) * y) / s pow 1 + (&11943936) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7347952480` [mpos] THEN
  note `&0:real < &335396455955` [npos] THEN
  note `&0:real < &1563371233148745` [ppos] THEN
  note `&0:real < &2208240777662` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7347952480)*(&7979008)+(&335396455955)*(&121733120))*s pow 1 = (&2208240777662)*((&7733248) * &1 + (&11943936) * &1 / &2) /\ ((&7347952480)*(&3162112)+(&335396455955)*(&53051392))*s pow 1 = (&2208240777662)*((&7733248) * &0 + (&11943936) * &1 / &2) /\ (&7347952480)*(&5552625)+(&335396455955)*(&86950107)+(&1563371233148745) = (&2208240777662)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &6874928039100` in
let npos = REAL_ARITH `!s:real. &0:real < &4529845705` in
let ppos = REAL_ARITH `!s:real. &0:real < &28702484133633433` in
let qpos = REAL_ARITH `!s:real. &0:real < &331760349017296` in
let mqrel = REAL_ARITH `
  ((&6874928039100)*(&124731392)+(&4529845705)*(&165806080))*(&30902639 / &41749730) pow 1 = (&331760349017296)*(((&897024) * &1 + (&2035712) * &1 / &2)) /\
  ((&6874928039100)*(&66289664)+(&4529845705)*(&105447424))*(&30902639 / &41749730) pow 1 = (&331760349017296)*(((&897024) * &0 + (&2035712) * &1 / &2)) /\
  (&6874928039100)*(&95315653)+(&4529845705)*(&137755571)+(&28702484133633433) = (&331760349017296)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&124731392) * x + (&66289664) * y <= &95315653 ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&897024) * ((&1) * x + (&0) * y) / s pow 1 + (&2035712) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6874928039100` [mpos] THEN
  note `&0:real < &4529845705` [npos] THEN
  note `&0:real < &28702484133633433` [ppos] THEN
  note `&0:real < &331760349017296` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6874928039100)*(&124731392)+(&4529845705)*(&165806080))*s pow 1 = (&331760349017296)*((&897024) * &1 + (&2035712) * &1 / &2) /\ ((&6874928039100)*(&66289664)+(&4529845705)*(&105447424))*s pow 1 = (&331760349017296)*((&897024) * &0 + (&2035712) * &1 / &2) /\ (&6874928039100)*(&95315653)+(&4529845705)*(&137755571)+(&28702484133633433) = (&331760349017296)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &290661620260` in
let npos = REAL_ARITH `!s:real. &0:real < &56566187305375` in
let ppos = REAL_ARITH `!s:real. &0:real < &339123854911903935` in
let qpos = REAL_ARITH `!s:real. &0:real < &1990562094103776` in
let mqrel = REAL_ARITH `
  ((&290661620260)*(&124731392)+(&56566187305375)*(&165806080))*(&30902639 / &41749730) pow 1 = (&1990562094103776)*(((&1275904) * &1 + (&4450304) * &1 / &2)) /\
  ((&290661620260)*(&66289664)+(&56566187305375)*(&105447424))*(&30902639 / &41749730) pow 1 = (&1990562094103776)*(((&1275904) * &0 + (&4450304) * &1 / &2)) /\
  (&290661620260)*(&95315653)+(&56566187305375)*(&137755571)+(&339123854911903935) = (&1990562094103776)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&124731392) * x + (&66289664) * y <= &95315653 ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&1275904) * ((&1) * x + (&0) * y) / s pow 1 + (&4450304) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &290661620260` [mpos] THEN
  note `&0:real < &56566187305375` [npos] THEN
  note `&0:real < &339123854911903935` [ppos] THEN
  note `&0:real < &1990562094103776` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&290661620260)*(&124731392)+(&56566187305375)*(&165806080))*s pow 1 = (&1990562094103776)*((&1275904) * &1 + (&4450304) * &1 / &2) /\ ((&290661620260)*(&66289664)+(&56566187305375)*(&105447424))*s pow 1 = (&1990562094103776)*((&1275904) * &0 + (&4450304) * &1 / &2) /\ (&290661620260)*(&95315653)+(&56566187305375)*(&137755571)+(&339123854911903935) = (&1990562094103776)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &20874865` in
let npos = REAL_ARITH `!s:real. &0:real < &327818879960` in
let ppos = REAL_ARITH `!s:real. &0:real < &396292518349063` in
let qpos = REAL_ARITH `!s:real. &0:real < &798462386482` in
let mqrel = REAL_ARITH `
  ((&20874865)*(&165806080)+(&327818879960)*(&22740992))*(&30902639 / &41749730) pow 1 = (&798462386482)*(((&2211840) * &1 + (&9404416) * &1 / &2)) /\
  ((&20874865)*(&105447424)+(&327818879960)*(&15466496))*(&30902639 / &41749730) pow 1 = (&798462386482)*(((&2211840) * &0 + (&9404416) * &1 / &2)) /\
  (&20874865)*(&137755571)+(&327818879960)*(&19572823)+(&396292518349063) = (&798462386482)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&165806080) * x + (&105447424) * y <= &137755571 ==>
  (&22740992) * x + (&15466496) * y <= &19572823 ==>
  (&2211840) * ((&1) * x + (&0) * y) / s pow 1 + (&9404416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20874865` [mpos] THEN
  note `&0:real < &327818879960` [npos] THEN
  note `&0:real < &396292518349063` [ppos] THEN
  note `&0:real < &798462386482` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&20874865)*(&165806080)+(&327818879960)*(&22740992))*s pow 1 = (&798462386482)*((&2211840) * &1 + (&9404416) * &1 / &2) /\ ((&20874865)*(&105447424)+(&327818879960)*(&15466496))*s pow 1 = (&798462386482)*((&2211840) * &0 + (&9404416) * &1 / &2) /\ (&20874865)*(&137755571)+(&327818879960)*(&19572823)+(&396292518349063) = (&798462386482)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &644970703905` in
let npos = REAL_ARITH `!s:real. &0:real < &3840975160` in
let ppos = REAL_ARITH `!s:real. &0:real < &85845225388732` in
let qpos = REAL_ARITH `!s:real. &0:real < &64864639261` in
let mqrel = REAL_ARITH `
  ((&644970703905)*(&3604480)+(&3840975160)*(&5537792))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((&7733248) * &1 + (&38076416) * &1 / &2)) /\
  ((&644970703905)*(&2555904)+(&3840975160)*(&5177344))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((&7733248) * &0 + (&38076416) * &1 / &2)) /\
  (&644970703905)*(&3177943)+(&3840975160)*(&5799491)+(&85845225388732) = (&64864639261)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3604480) * x + (&2555904) * y <= &3177943 ==>
  (&5537792) * x + (&5177344) * y <= &5799491 ==>
  (&7733248) * ((&1) * x + (&0) * y) / s pow 1 + (&38076416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &644970703905` [mpos] THEN
  note `&0:real < &3840975160` [npos] THEN
  note `&0:real < &85845225388732` [ppos] THEN
  note `&0:real < &64864639261` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&644970703905)*(&3604480)+(&3840975160)*(&5537792))*s pow 1 = (&64864639261)*((&7733248) * &1 + (&38076416) * &1 / &2) /\ ((&644970703905)*(&2555904)+(&3840975160)*(&5177344))*s pow 1 = (&64864639261)*((&7733248) * &0 + (&38076416) * &1 / &2) /\ (&644970703905)*(&3177943)+(&3840975160)*(&5799491)+(&85845225388732) = (&64864639261)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &2024861905` in
let npos = REAL_ARITH `!s:real. &0:real < &472105946840` in
let ppos = REAL_ARITH `!s:real. &0:real < &119595897524836` in
let qpos = REAL_ARITH `!s:real. &0:real < &64864639261` in
let mqrel = REAL_ARITH `
  ((&2024861905)*(&3604480)+(&472105946840)*(&5537792))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((&1966080) * &1 + (&55902208) * &1 / &2)) /\
  ((&2024861905)*(&2555904)+(&472105946840)*(&5177344))*(&30902639 / &41749730) pow 1 = (&64864639261)*(((&1966080) * &0 + (&55902208) * &1 / &2)) /\
  (&2024861905)*(&3177943)+(&472105946840)*(&5799491)+(&119595897524836) = (&64864639261)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3604480) * x + (&2555904) * y <= &3177943 ==>
  (&5537792) * x + (&5177344) * y <= &5799491 ==>
  (&1966080) * ((&1) * x + (&0) * y) / s pow 1 + (&55902208) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2024861905` [mpos] THEN
  note `&0:real < &472105946840` [npos] THEN
  note `&0:real < &119595897524836` [ppos] THEN
  note `&0:real < &64864639261` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2024861905)*(&3604480)+(&472105946840)*(&5537792))*s pow 1 = (&64864639261)*((&1966080) * &1 + (&55902208) * &1 / &2) /\ ((&2024861905)*(&2555904)+(&472105946840)*(&5177344))*s pow 1 = (&64864639261)*((&1966080) * &0 + (&55902208) * &1 / &2) /\ (&2024861905)*(&3177943)+(&472105946840)*(&5799491)+(&119595897524836) = (&64864639261)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &116022499670` in
let npos = REAL_ARITH `!s:real. &0:real < &1729795688225` in
let ppos = REAL_ARITH `!s:real. &0:real < &30633501664806252` in
let qpos = REAL_ARITH `!s:real. &0:real < &5569489919053` in
let mqrel = REAL_ARITH `
  ((&116022499670)*(&5537792)+(&1729795688225)*(&289406976))*(&30902639 / &41749730) pow 1 = (&5569489919053)*(((-- &11730944) * &1 + (&156696576) * &1 / &2)) /\
  ((&116022499670)*(&5177344)+(&1729795688225)*(&340459520))*(&30902639 / &41749730) pow 1 = (&5569489919053)*(((-- &11730944) * &0 + (&156696576) * &1 / &2)) /\
  (&116022499670)*(&5799491)+(&1729795688225)*(&355053887)+(&30633501664806252) = (&5569489919053)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5537792) * x + (&5177344) * y <= &5799491 ==>
  (&289406976) * x + (&340459520) * y <= &355053887 ==>
  (-- &11730944) * ((&1) * x + (&0) * y) / s pow 1 + (&156696576) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &116022499670` [mpos] THEN
  note `&0:real < &1729795688225` [npos] THEN
  note `&0:real < &30633501664806252` [ppos] THEN
  note `&0:real < &5569489919053` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&116022499670)*(&5537792)+(&1729795688225)*(&289406976))*s pow 1 = (&5569489919053)*((-- &11730944) * &1 + (&156696576) * &1 / &2) /\ ((&116022499670)*(&5177344)+(&1729795688225)*(&340459520))*s pow 1 = (&5569489919053)*((-- &11730944) * &0 + (&156696576) * &1 / &2) /\ (&116022499670)*(&5799491)+(&1729795688225)*(&355053887)+(&30633501664806252) = (&5569489919053)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &266702968385` in
let npos = REAL_ARITH `!s:real. &0:real < &434576735` in
let ppos = REAL_ARITH `!s:real. &0:real < &434297936899456` in
let qpos = REAL_ARITH `!s:real. &0:real < &143759076628` in
let mqrel = REAL_ARITH `
  ((&266702968385)*(&26116096)+(&434576735)*(&66748416))*(&30902639 / &41749730) pow 1 = (&143759076628)*(((-- &22740992) * &1 + (&117506048) * &1 / &2)) /\
  ((&266702968385)*(&42532864)+(&434576735)*(&154992640))*(&30902639 / &41749730) pow 1 = (&143759076628)*(((-- &22740992) * &0 + (&117506048) * &1 / &2)) /\
  (&266702968385)*(&41635449)+(&434576735)*(&144601685)+(&434297936899456) = (&143759076628)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&26116096) * x + (&42532864) * y <= &41635449 ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (-- &22740992) * ((&1) * x + (&0) * y) / s pow 1 + (&117506048) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &266702968385` [mpos] THEN
  note `&0:real < &434576735` [npos] THEN
  note `&0:real < &434297936899456` [ppos] THEN
  note `&0:real < &143759076628` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&266702968385)*(&26116096)+(&434576735)*(&66748416))*s pow 1 = (&143759076628)*((-- &22740992) * &1 + (&117506048) * &1 / &2) /\ ((&266702968385)*(&42532864)+(&434576735)*(&154992640))*s pow 1 = (&143759076628)*((-- &22740992) * &0 + (&117506048) * &1 / &2) /\ (&266702968385)*(&41635449)+(&434576735)*(&144601685)+(&434297936899456) = (&143759076628)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &7816507802075` in
let npos = REAL_ARITH `!s:real. &0:real < &2572737918645` in
let ppos = REAL_ARITH `!s:real. &0:real < &9499321061594056` in
let qpos = REAL_ARITH `!s:real. &0:real < &1581349842908` in
let mqrel = REAL_ARITH `
  ((&7816507802075)*(&26116096)+(&2572737918645)*(&66748416))*(&30902639 / &41749730) pow 1 = (&1581349842908)*(((-- &166330368) * &1 + (&684523520) * &1 / &2)) /\
  ((&7816507802075)*(&42532864)+(&2572737918645)*(&154992640))*(&30902639 / &41749730) pow 1 = (&1581349842908)*(((-- &166330368) * &0 + (&684523520) * &1 / &2)) /\
  (&7816507802075)*(&41635449)+(&2572737918645)*(&144601685)+(&9499321061594056) = (&1581349842908)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&26116096) * x + (&42532864) * y <= &41635449 ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (-- &166330368) * ((&1) * x + (&0) * y) / s pow 1 + (&684523520) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7816507802075` [mpos] THEN
  note `&0:real < &2572737918645` [npos] THEN
  note `&0:real < &9499321061594056` [ppos] THEN
  note `&0:real < &1581349842908` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7816507802075)*(&26116096)+(&2572737918645)*(&66748416))*s pow 1 = (&1581349842908)*((-- &166330368) * &1 + (&684523520) * &1 / &2) /\ ((&7816507802075)*(&42532864)+(&2572737918645)*(&154992640))*s pow 1 = (&1581349842908)*((-- &166330368) * &0 + (&684523520) * &1 / &2) /\ (&7816507802075)*(&41635449)+(&2572737918645)*(&144601685)+(&9499321061594056) = (&1581349842908)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &648724384175` in
let npos = REAL_ARITH `!s:real. &0:real < &289460366665` in
let ppos = REAL_ARITH `!s:real. &0:real < &116451365637485802` in
let qpos = REAL_ARITH `!s:real. &0:real < &790674921454` in
let mqrel = REAL_ARITH `
  ((&648724384175)*(&26116096)+(&289460366665)*(&66748416))*(&30902639 / &41749730) pow 1 = (&790674921454)*(((-- &33882112) * &1 + (&135659520) * &1 / &2)) /\
  ((&648724384175)*(&42532864)+(&289460366665)*(&154992640))*(&30902639 / &41749730) pow 1 = (&790674921454)*(((-- &33882112) * &0 + (&135659520) * &1 / &2)) /\
  (&648724384175)*(&41635449)+(&289460366665)*(&144601685)+(&116451365637485802) = (&790674921454)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&26116096) * x + (&42532864) * y <= &41635449 ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (-- &33882112) * ((&1) * x + (&0) * y) / s pow 1 + (&135659520) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &648724384175` [mpos] THEN
  note `&0:real < &289460366665` [npos] THEN
  note `&0:real < &116451365637485802` [ppos] THEN
  note `&0:real < &790674921454` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&648724384175)*(&26116096)+(&289460366665)*(&66748416))*s pow 1 = (&790674921454)*((-- &33882112) * &1 + (&135659520) * &1 / &2) /\ ((&648724384175)*(&42532864)+(&289460366665)*(&154992640))*s pow 1 = (&790674921454)*((-- &33882112) * &0 + (&135659520) * &1 / &2) /\ (&648724384175)*(&41635449)+(&289460366665)*(&144601685)+(&116451365637485802) = (&790674921454)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &2371601762596` in
let npos = REAL_ARITH `!s:real. &0:real < &998461492842` in
let ppos = REAL_ARITH `!s:real. &0:real < &4664109389297427825` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&2371601762596)*(&66748416)+(&998461492842)*(&3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &50659328) * &1 + (&175046656) * &1 / &2)) /\
  ((&2371601762596)*(&154992640)+(&998461492842)*(&17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &50659328) * &0 + (&175046656) * &1 / &2)) /\
  (&2371601762596)*(&144601685)+(&998461492842)*(&15704445)+(&4664109389297427825) = (&3256674611015)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (-- &50659328) * ((&1) * x + (&0) * y) / s pow 1 + (&175046656) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2371601762596` [mpos] THEN
  note `&0:real < &998461492842` [npos] THEN
  note `&0:real < &4664109389297427825` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2371601762596)*(&66748416)+(&998461492842)*(&3899392))*s pow 1 = (&3256674611015)*((-- &50659328) * &1 + (&175046656) * &1 / &2) /\ ((&2371601762596)*(&154992640)+(&998461492842)*(&17530880))*s pow 1 = (&3256674611015)*((-- &50659328) * &0 + (&175046656) * &1 / &2) /\ (&2371601762596)*(&144601685)+(&998461492842)*(&15704445)+(&4664109389297427825) = (&3256674611015)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &350430533728` in
let npos = REAL_ARITH `!s:real. &0:real < &1285148538806` in
let ppos = REAL_ARITH `!s:real. &0:real < &1323510459877251275` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&350430533728)*(&66748416)+(&1285148538806)*(&3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &11010048) * &1 + (&34930688) * &1 / &2)) /\
  ((&350430533728)*(&154992640)+(&1285148538806)*(&17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &11010048) * &0 + (&34930688) * &1 / &2)) /\
  (&350430533728)*(&144601685)+(&1285148538806)*(&15704445)+(&1323510459877251275) = (&3256674611015)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (-- &11010048) * ((&1) * x + (&0) * y) / s pow 1 + (&34930688) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &350430533728` [mpos] THEN
  note `&0:real < &1285148538806` [npos] THEN
  note `&0:real < &1323510459877251275` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&350430533728)*(&66748416)+(&1285148538806)*(&3899392))*s pow 1 = (&3256674611015)*((-- &11010048) * &1 + (&34930688) * &1 / &2) /\ ((&350430533728)*(&154992640)+(&1285148538806)*(&17530880))*s pow 1 = (&3256674611015)*((-- &11010048) * &0 + (&34930688) * &1 / &2) /\ (&350430533728)*(&144601685)+(&1285148538806)*(&15704445)+(&1323510459877251275) = (&3256674611015)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &854132676232` in
let npos = REAL_ARITH `!s:real. &0:real < &3887977006034` in
let ppos = REAL_ARITH `!s:real. &0:real < &3658948158750435719` in
let qpos = REAL_ARITH `!s:real. &0:real < &651334922203` in
let mqrel = REAL_ARITH `
  ((&854132676232)*(&66748416)+(&3887977006034)*(&3899392))*(&30902639 / &41749730) pow 1 = (&651334922203)*(((-- &145883136) * &1 + (&455802880) * &1 / &2)) /\
  ((&854132676232)*(&154992640)+(&3887977006034)*(&17530880))*(&30902639 / &41749730) pow 1 = (&651334922203)*(((-- &145883136) * &0 + (&455802880) * &1 / &2)) /\
  (&854132676232)*(&144601685)+(&3887977006034)*(&15704445)+(&3658948158750435719) = (&651334922203)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (-- &145883136) * ((&1) * x + (&0) * y) / s pow 1 + (&455802880) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &854132676232` [mpos] THEN
  note `&0:real < &3887977006034` [npos] THEN
  note `&0:real < &3658948158750435719` [ppos] THEN
  note `&0:real < &651334922203` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&854132676232)*(&66748416)+(&3887977006034)*(&3899392))*s pow 1 = (&651334922203)*((-- &145883136) * &1 + (&455802880) * &1 / &2) /\ ((&854132676232)*(&154992640)+(&3887977006034)*(&17530880))*s pow 1 = (&651334922203)*((-- &145883136) * &0 + (&455802880) * &1 / &2) /\ (&854132676232)*(&144601685)+(&3887977006034)*(&15704445)+(&3658948158750435719) = (&651334922203)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &82743789887` in
let npos = REAL_ARITH `!s:real. &0:real < &580166772999` in
let ppos = REAL_ARITH `!s:real. &0:real < &586675842586191925` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&82743789887)*(&66748416)+(&580166772999)*(&3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &3457024) * &1 + (&10452992) * &1 / &2)) /\
  ((&82743789887)*(&154992640)+(&580166772999)*(&17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &3457024) * &0 + (&10452992) * &1 / &2)) /\
  (&82743789887)*(&144601685)+(&580166772999)*(&15704445)+(&586675842586191925) = (&3256674611015)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (-- &3457024) * ((&1) * x + (&0) * y) / s pow 1 + (&10452992) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &82743789887` [mpos] THEN
  note `&0:real < &580166772999` [npos] THEN
  note `&0:real < &586675842586191925` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&82743789887)*(&66748416)+(&580166772999)*(&3899392))*s pow 1 = (&3256674611015)*((-- &3457024) * &1 + (&10452992) * &1 / &2) /\ ((&82743789887)*(&154992640)+(&580166772999)*(&17530880))*s pow 1 = (&3256674611015)*((-- &3457024) * &0 + (&10452992) * &1 / &2) /\ (&82743789887)*(&144601685)+(&580166772999)*(&15704445)+(&586675842586191925) = (&3256674611015)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &684411673836` in
let npos = REAL_ARITH `!s:real. &0:real < &14332010138347` in
let ppos = REAL_ARITH `!s:real. &0:real < &15869868041859323800` in
let qpos = REAL_ARITH `!s:real. &0:real < &3256674611015` in
let mqrel = REAL_ARITH `
  ((&684411673836)*(&66748416)+(&14332010138347)*(&3899392))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &58130432) * &1 + (&162430976) * &1 / &2)) /\
  ((&684411673836)*(&154992640)+(&14332010138347)*(&17530880))*(&30902639 / &41749730) pow 1 = (&3256674611015)*(((-- &58130432) * &0 + (&162430976) * &1 / &2)) /\
  (&684411673836)*(&144601685)+(&14332010138347)*(&15704445)+(&15869868041859323800) = (&3256674611015)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&66748416) * x + (&154992640) * y <= &144601685 ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (-- &58130432) * ((&1) * x + (&0) * y) / s pow 1 + (&162430976) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &684411673836` [mpos] THEN
  note `&0:real < &14332010138347` [npos] THEN
  note `&0:real < &15869868041859323800` [ppos] THEN
  note `&0:real < &3256674611015` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&684411673836)*(&66748416)+(&14332010138347)*(&3899392))*s pow 1 = (&3256674611015)*((-- &58130432) * &1 + (&162430976) * &1 / &2) /\ ((&684411673836)*(&154992640)+(&14332010138347)*(&17530880))*s pow 1 = (&3256674611015)*((-- &58130432) * &0 + (&162430976) * &1 / &2) /\ (&684411673836)*(&144601685)+(&14332010138347)*(&15704445)+(&15869868041859323800) = (&3256674611015)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &98314685688340` in
let npos = REAL_ARITH `!s:real. &0:real < &7330876840430` in
let ppos = REAL_ARITH `!s:real. &0:real < &217830433787504806723` in
let qpos = REAL_ARITH `!s:real. &0:real < &5124491917453` in
let mqrel = REAL_ARITH `
  ((&98314685688340)*(&3899392)+(&7330876840430)*(&65536))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((-- &290521088) * &1 + (&691929088) * &1 / &2)) /\
  ((&98314685688340)*(&17530880)+(&7330876840430)*(&91619328))*(&30902639 / &41749730) pow 1 = (&5124491917453)*(((-- &290521088) * &0 + (&691929088) * &1 / &2)) /\
  (&98314685688340)*(&15704445)+(&7330876840430)*(&79611463)+(&217830433787504806723) = (&5124491917453)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (&65536) * x + (&91619328) * y <= &79611463 ==>
  (-- &290521088) * ((&1) * x + (&0) * y) / s pow 1 + (&691929088) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &98314685688340` [mpos] THEN
  note `&0:real < &7330876840430` [npos] THEN
  note `&0:real < &217830433787504806723` [ppos] THEN
  note `&0:real < &5124491917453` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&98314685688340)*(&3899392)+(&7330876840430)*(&65536))*s pow 1 = (&5124491917453)*((-- &290521088) * &1 + (&691929088) * &1 / &2) /\ ((&98314685688340)*(&17530880)+(&7330876840430)*(&91619328))*s pow 1 = (&5124491917453)*((-- &290521088) * &0 + (&691929088) * &1 / &2) /\ (&98314685688340)*(&15704445)+(&7330876840430)*(&79611463)+(&217830433787504806723) = (&5124491917453)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &3629992899445` in
let npos = REAL_ARITH `!s:real. &0:real < &3828053618565` in
let ppos = REAL_ARITH `!s:real. &0:real < &61918503421471282824` in
let qpos = REAL_ARITH `!s:real. &0:real < &20497967669812` in
let mqrel = REAL_ARITH `
  ((&3629992899445)*(&3899392)+(&3828053618565)*(&65536))*(&30902639 / &41749730) pow 1 = (&20497967669812)*(((-- &14442496) * &1 + (&29925376) * &1 / &2)) /\
  ((&3629992899445)*(&17530880)+(&3828053618565)*(&91619328))*(&30902639 / &41749730) pow 1 = (&20497967669812)*(((-- &14442496) * &0 + (&29925376) * &1 / &2)) /\
  (&3629992899445)*(&15704445)+(&3828053618565)*(&79611463)+(&61918503421471282824) = (&20497967669812)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3899392) * x + (&17530880) * y <= &15704445 ==>
  (&65536) * x + (&91619328) * y <= &79611463 ==>
  (-- &14442496) * ((&1) * x + (&0) * y) / s pow 1 + (&29925376) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3629992899445` [mpos] THEN
  note `&0:real < &3828053618565` [npos] THEN
  note `&0:real < &61918503421471282824` [ppos] THEN
  note `&0:real < &20497967669812` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3629992899445)*(&3899392)+(&3828053618565)*(&65536))*s pow 1 = (&20497967669812)*((-- &14442496) * &1 + (&29925376) * &1 / &2) /\ ((&3629992899445)*(&17530880)+(&3828053618565)*(&91619328))*s pow 1 = (&20497967669812)*((-- &14442496) * &0 + (&29925376) * &1 / &2) /\ (&3629992899445)*(&15704445)+(&3828053618565)*(&79611463)+(&61918503421471282824) = (&20497967669812)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &11086849550150` in
let npos = REAL_ARITH `!s:real. &0:real < &2109342483655` in
let ppos = REAL_ARITH `!s:real. &0:real < &220624888676913417823` in
let qpos = REAL_ARITH `!s:real. &0:real < &49869195491528` in
let mqrel = REAL_ARITH `
  ((&11086849550150)*(&65536)+(&2109342483655)*(-- &9371648))*(&30902639 / &41749730) pow 1 = (&49869195491528)*(((-- &19062784) * &1 + (&37560320) * &1 / &2)) /\
  ((&11086849550150)*(&91619328)+(&2109342483655)*(&118292480))*(&30902639 / &41749730) pow 1 = (&49869195491528)*(((-- &19062784) * &0 + (&37560320) * &1 / &2)) /\
  (&11086849550150)*(&79611463)+(&2109342483655)*(&101844089)+(&220624888676913417823) = (&49869195491528)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&65536) * x + (&91619328) * y <= &79611463 ==>
  (-- &9371648) * x + (&118292480) * y <= &101844089 ==>
  (-- &19062784) * ((&1) * x + (&0) * y) / s pow 1 + (&37560320) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11086849550150` [mpos] THEN
  note `&0:real < &2109342483655` [npos] THEN
  note `&0:real < &220624888676913417823` [ppos] THEN
  note `&0:real < &49869195491528` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&11086849550150)*(&65536)+(&2109342483655)*(-- &9371648))*s pow 1 = (&49869195491528)*((-- &19062784) * &1 + (&37560320) * &1 / &2) /\ ((&11086849550150)*(&91619328)+(&2109342483655)*(&118292480))*s pow 1 = (&49869195491528)*((-- &19062784) * &0 + (&37560320) * &1 / &2) /\ (&11086849550150)*(&79611463)+(&2109342483655)*(&101844089)+(&220624888676913417823) = (&49869195491528)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &1063407372830` in
let npos = REAL_ARITH `!s:real. &0:real < &1273638138245` in
let ppos = REAL_ARITH `!s:real. &0:real < &47632454933743574083` in
let qpos = REAL_ARITH `!s:real. &0:real < &12467298872882` in
let mqrel = REAL_ARITH `
  ((&1063407372830)*(&65536)+(&1273638138245)*(-- &9371648))*(&30902639 / &41749730) pow 1 = (&12467298872882)*(((-- &15433728) * &1 + (&29458432) * &1 / &2)) /\
  ((&1063407372830)*(&91619328)+(&1273638138245)*(&118292480))*(&30902639 / &41749730) pow 1 = (&12467298872882)*(((-- &15433728) * &0 + (&29458432) * &1 / &2)) /\
  (&1063407372830)*(&79611463)+(&1273638138245)*(&101844089)+(&47632454933743574083) = (&12467298872882)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&65536) * x + (&91619328) * y <= &79611463 ==>
  (-- &9371648) * x + (&118292480) * y <= &101844089 ==>
  (-- &15433728) * ((&1) * x + (&0) * y) / s pow 1 + (&29458432) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1063407372830` [mpos] THEN
  note `&0:real < &1273638138245` [npos] THEN
  note `&0:real < &47632454933743574083` [ppos] THEN
  note `&0:real < &12467298872882` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1063407372830)*(&65536)+(&1273638138245)*(-- &9371648))*s pow 1 = (&12467298872882)*((-- &15433728) * &1 + (&29458432) * &1 / &2) /\ ((&1063407372830)*(&91619328)+(&1273638138245)*(&118292480))*s pow 1 = (&12467298872882)*((-- &15433728) * &0 + (&29458432) * &1 / &2) /\ (&1063407372830)*(&79611463)+(&1273638138245)*(&101844089)+(&47632454933743574083) = (&12467298872882)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &983060017445` in
let npos = REAL_ARITH `!s:real. &0:real < &4395578573320` in
let ppos = REAL_ARITH `!s:real. &0:real < &3312591085209734846` in
let qpos = REAL_ARITH `!s:real. &0:real < &1970012333611` in
let mqrel = REAL_ARITH `
  ((&983060017445)*(-- &1130496)+(&4395578573320)*(-- &481280))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((-- &5660672) * &1 + (&8896512) * &1 / &2)) /\
  ((&983060017445)*(&7061504)+(&4395578573320)*(&1114112))*(&30902639 / &41749730) pow 1 = (&1970012333611)*(((-- &5660672) * &0 + (&8896512) * &1 / &2)) /\
  (&983060017445)*(&6069771)+(&4395578573320)*(&1004531)+(&3312591085209734846) = (&1970012333611)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1130496) * x + (&7061504) * y <= &6069771 ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &5660672) * ((&1) * x + (&0) * y) / s pow 1 + (&8896512) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &983060017445` [mpos] THEN
  note `&0:real < &4395578573320` [npos] THEN
  note `&0:real < &3312591085209734846` [ppos] THEN
  note `&0:real < &1970012333611` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&983060017445)*(-- &1130496)+(&4395578573320)*(-- &481280))*s pow 1 = (&1970012333611)*((-- &5660672) * &1 + (&8896512) * &1 / &2) /\ ((&983060017445)*(&7061504)+(&4395578573320)*(&1114112))*s pow 1 = (&1970012333611)*((-- &5660672) * &0 + (&8896512) * &1 / &2) /\ (&983060017445)*(&6069771)+(&4395578573320)*(&1004531)+(&3312591085209734846) = (&1970012333611)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &314878634645960` in
let npos = REAL_ARITH `!s:real. &0:real < &1442933293395` in
let ppos = REAL_ARITH `!s:real. &0:real < &153491172316503021734` in
let qpos = REAL_ARITH `!s:real. &0:real < &1314381944587` in
let mqrel = REAL_ARITH `
  ((&314878634645960)*(-- &481280)+(&1442933293395)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((-- &373096448) * &1 + (&503644160) * &1 / &2)) /\
  ((&314878634645960)*(&1114112)+(&1442933293395)*(&66781184))*(&30902639 / &41749730) pow 1 = (&1314381944587)*(((-- &373096448) * &0 + (&503644160) * &1 / &2)) /\
  (&314878634645960)*(&1004531)+(&1442933293395)*(&62719715)+(&153491172316503021734) = (&1314381944587)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &373096448) * ((&1) * x + (&0) * y) / s pow 1 + (&503644160) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &314878634645960` [mpos] THEN
  note `&0:real < &1442933293395` [npos] THEN
  note `&0:real < &153491172316503021734` [ppos] THEN
  note `&0:real < &1314381944587` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&314878634645960)*(-- &481280)+(&1442933293395)*(-- &44220416))*s pow 1 = (&1314381944587)*((-- &373096448) * &1 + (&503644160) * &1 / &2) /\ ((&314878634645960)*(&1114112)+(&1442933293395)*(&66781184))*s pow 1 = (&1314381944587)*((-- &373096448) * &0 + (&503644160) * &1 / &2) /\ (&314878634645960)*(&1004531)+(&1442933293395)*(&62719715)+(&153491172316503021734) = (&1314381944587)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &8279138457920` in
let npos = REAL_ARITH `!s:real. &0:real < &154640999920` in
let ppos = REAL_ARITH `!s:real. &0:real < &7251297775649321505` in
let qpos = REAL_ARITH `!s:real. &0:real < &3943145833761` in
let mqrel = REAL_ARITH `
  ((&8279138457920)*(-- &481280)+(&154640999920)*(-- &44220416))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &5701632) * &1 + (&7340032) * &1 / &2)) /\
  ((&8279138457920)*(&1114112)+(&154640999920)*(&66781184))*(&30902639 / &41749730) pow 1 = (&3943145833761)*(((-- &5701632) * &0 + (&7340032) * &1 / &2)) /\
  (&8279138457920)*(&1004531)+(&154640999920)*(&62719715)+(&7251297775649321505) = (&3943145833761)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &481280) * x + (&1114112) * y <= &1004531 ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &5701632) * ((&1) * x + (&0) * y) / s pow 1 + (&7340032) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8279138457920` [mpos] THEN
  note `&0:real < &154640999920` [npos] THEN
  note `&0:real < &7251297775649321505` [ppos] THEN
  note `&0:real < &3943145833761` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&8279138457920)*(-- &481280)+(&154640999920)*(-- &44220416))*s pow 1 = (&3943145833761)*((-- &5701632) * &1 + (&7340032) * &1 / &2) /\ ((&8279138457920)*(&1114112)+(&154640999920)*(&66781184))*s pow 1 = (&3943145833761)*((-- &5701632) * &0 + (&7340032) * &1 / &2) /\ (&8279138457920)*(&1004531)+(&154640999920)*(&62719715)+(&7251297775649321505) = (&3943145833761)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &2619469909606` in
let npos = REAL_ARITH `!s:real. &0:real < &3621033407387` in
let ppos = REAL_ARITH `!s:real. &0:real < &222348778460721813670` in
let qpos = REAL_ARITH `!s:real. &0:real < &13901706667345` in
let mqrel = REAL_ARITH `
  ((&2619469909606)*(-- &44220416)+(&3621033407387)*(-- &75169792))*(&30902639 / &41749730) pow 1 = (&13901706667345)*(((-- &46596096) * &1 + (&51871744) * &1 / &2)) /\
  ((&2619469909606)*(&66781184)+(&3621033407387)*(&86212608))*(&30902639 / &41749730) pow 1 = (&13901706667345)*(((-- &46596096) * &0 + (&51871744) * &1 / &2)) /\
  (&2619469909606)*(&62719715)+(&3621033407387)*(&85043005)+(&222348778460721813670) = (&13901706667345)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &44220416) * x + (&66781184) * y <= &62719715 ==>
  (-- &75169792) * x + (&86212608) * y <= &85043005 ==>
  (-- &46596096) * ((&1) * x + (&0) * y) / s pow 1 + (&51871744) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2619469909606` [mpos] THEN
  note `&0:real < &3621033407387` [npos] THEN
  note `&0:real < &222348778460721813670` [ppos] THEN
  note `&0:real < &13901706667345` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2619469909606)*(-- &44220416)+(&3621033407387)*(-- &75169792))*s pow 1 = (&13901706667345)*((-- &46596096) * &1 + (&51871744) * &1 / &2) /\ ((&2619469909606)*(&66781184)+(&3621033407387)*(&86212608))*s pow 1 = (&13901706667345)*((-- &46596096) * &0 + (&51871744) * &1 / &2) /\ (&2619469909606)*(&62719715)+(&3621033407387)*(&85043005)+(&222348778460721813670) = (&13901706667345)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &9850765294040` in
let npos = REAL_ARITH `!s:real. &0:real < &26867788243120` in
let ppos = REAL_ARITH `!s:real. &0:real < &101084186227098370251` in
let qpos = REAL_ARITH `!s:real. &0:real < &3609829969507` in
let mqrel = REAL_ARITH `
  ((&9850765294040)*(-- &11419648)+(&26867788243120)*(-- &4050944))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((-- &84901888) * &1 + (&79036416) * &1 / &2)) /\
  ((&9850765294040)*(&10895360)+(&26867788243120)*(&3178496))*(&30902639 / &41749730) pow 1 = (&3609829969507)*(((-- &84901888) * &0 + (&79036416) * &1 / &2)) /\
  (&9850765294040)*(&11507295)+(&26867788243120)*(&3679349)+(&101084186227098370251) = (&3609829969507)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11419648) * x + (&10895360) * y <= &11507295 ==>
  (-- &4050944) * x + (&3178496) * y <= &3679349 ==>
  (-- &84901888) * ((&1) * x + (&0) * y) / s pow 1 + (&79036416) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9850765294040` [mpos] THEN
  note `&0:real < &26867788243120` [npos] THEN
  note `&0:real < &101084186227098370251` [ppos] THEN
  note `&0:real < &3609829969507` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&9850765294040)*(-- &11419648)+(&26867788243120)*(-- &4050944))*s pow 1 = (&3609829969507)*((-- &84901888) * &1 + (&79036416) * &1 / &2) /\ ((&9850765294040)*(&10895360)+(&26867788243120)*(&3178496))*s pow 1 = (&3609829969507)*((-- &84901888) * &0 + (&79036416) * &1 / &2) /\ (&9850765294040)*(&11507295)+(&26867788243120)*(&3679349)+(&101084186227098370251) = (&3609829969507)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &241710061835` in
let npos = REAL_ARITH `!s:real. &0:real < &550365815725` in
let ppos = REAL_ARITH `!s:real. &0:real < &7139996283847943699` in
let qpos = REAL_ARITH `!s:real. &0:real < &181120367179` in
let mqrel = REAL_ARITH `
  ((&241710061835)*(-- &8454144)+(&550365815725)*(-- &34471936))*(&30902639 / &41749730) pow 1 = (&181120367179)*(((-- &134447104) * &1 + (&97124352) * &1 / &2)) /\
  ((&241710061835)*(&5439488)+(&550365815725)*(&19202048))*(&30902639 / &41749730) pow 1 = (&181120367179)*(((-- &134447104) * &0 + (&97124352) * &1 / &2)) /\
  (&241710061835)*(&7031327)+(&550365815725)*(&27364823)+(&7139996283847943699) = (&181120367179)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &8454144) * x + (&5439488) * y <= &7031327 ==>
  (-- &34471936) * x + (&19202048) * y <= &27364823 ==>
  (-- &134447104) * ((&1) * x + (&0) * y) / s pow 1 + (&97124352) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &241710061835` [mpos] THEN
  note `&0:real < &550365815725` [npos] THEN
  note `&0:real < &7139996283847943699` [ppos] THEN
  note `&0:real < &181120367179` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&241710061835)*(-- &8454144)+(&550365815725)*(-- &34471936))*s pow 1 = (&181120367179)*((-- &134447104) * &1 + (&97124352) * &1 / &2) /\ ((&241710061835)*(&5439488)+(&550365815725)*(&19202048))*s pow 1 = (&181120367179)*((-- &134447104) * &0 + (&97124352) * &1 / &2) /\ (&241710061835)*(&7031327)+(&550365815725)*(&27364823)+(&7139996283847943699) = (&181120367179)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &128756167320` in
let npos = REAL_ARITH `!s:real. &0:real < &7950401083900` in
let ppos = REAL_ARITH `!s:real. &0:real < &929325401272335347` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&128756167320)*(-- &24879104)+(&7950401083900)*(-- &131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &100401152) * &1 + (&50266112) * &1 / &2)) /\
  ((&128756167320)*(&8986624)+(&7950401083900)*(&32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &100401152) * &0 + (&50266112) * &1 / &2)) /\
  (&128756167320)*(&18073405)+(&7950401083900)*(&92351)+(&929325401272335347) = (&41749465289)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &24879104) * x + (&8986624) * y <= &18073405 ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &100401152) * ((&1) * x + (&0) * y) / s pow 1 + (&50266112) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &128756167320` [mpos] THEN
  note `&0:real < &7950401083900` [npos] THEN
  note `&0:real < &929325401272335347` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&128756167320)*(-- &24879104)+(&7950401083900)*(-- &131072))*s pow 1 = (&41749465289)*((-- &100401152) * &1 + (&50266112) * &1 / &2) /\ ((&128756167320)*(&8986624)+(&7950401083900)*(&32768))*s pow 1 = (&41749465289)*((-- &100401152) * &0 + (&50266112) * &1 / &2) /\ (&128756167320)*(&18073405)+(&7950401083900)*(&92351)+(&929325401272335347) = (&41749465289)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &17618386060` in
let npos = REAL_ARITH `!s:real. &0:real < &18660375821340` in
let ppos = REAL_ARITH `!s:real. &0:real < &509679048622657487` in
let qpos = REAL_ARITH `!s:real. &0:real < &41749465289` in
let mqrel = REAL_ARITH `
  ((&17618386060)*(-- &24879104)+(&18660375821340)*(-- &131072))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &64782336) * &1 + (&27295744) * &1 / &2)) /\
  ((&17618386060)*(&8986624)+(&18660375821340)*(&32768))*(&30902639 / &41749730) pow 1 = (&41749465289)*(((-- &64782336) * &0 + (&27295744) * &1 / &2)) /\
  (&17618386060)*(&18073405)+(&18660375821340)*(&92351)+(&509679048622657487) = (&41749465289)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &24879104) * x + (&8986624) * y <= &18073405 ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &64782336) * ((&1) * x + (&0) * y) / s pow 1 + (&27295744) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &17618386060` [mpos] THEN
  note `&0:real < &18660375821340` [npos] THEN
  note `&0:real < &509679048622657487` [ppos] THEN
  note `&0:real < &41749465289` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&17618386060)*(-- &24879104)+(&18660375821340)*(-- &131072))*s pow 1 = (&41749465289)*((-- &64782336) * &1 + (&27295744) * &1 / &2) /\ ((&17618386060)*(&8986624)+(&18660375821340)*(&32768))*s pow 1 = (&41749465289)*((-- &64782336) * &0 + (&27295744) * &1 / &2) /\ (&17618386060)*(&18073405)+(&18660375821340)*(&92351)+(&509679048622657487) = (&41749465289)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &208706900270` in
let npos = REAL_ARITH `!s:real. &0:real < &208748650` in
let ppos = REAL_ARITH `!s:real. &0:real < &10246150371539421` in
let qpos = REAL_ARITH `!s:real. &0:real < &4728103767` in
let mqrel = REAL_ARITH `
  ((&208706900270)*(-- &131072)+(&208748650)*(-- &191823872))*(&30902639 / &41749730) pow 1 = (&4728103767)*(((-- &12943360) * &1 + (&4784128) * &1 / &2)) /\
  ((&208706900270)*(&32768)+(&208748650)*(&40435712))*(&30902639 / &41749730) pow 1 = (&4728103767)*(((-- &12943360) * &0 + (&4784128) * &1 / &2)) /\
  (&208706900270)*(&92351)+(&208748650)*(&133937273)+(&10246150371539421) = (&4728103767)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &191823872) * x + (&40435712) * y <= &133937273 ==>
  (-- &12943360) * ((&1) * x + (&0) * y) / s pow 1 + (&4784128) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &208706900270` [mpos] THEN
  note `&0:real < &208748650` [npos] THEN
  note `&0:real < &10246150371539421` [ppos] THEN
  note `&0:real < &4728103767` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&208706900270)*(-- &131072)+(&208748650)*(-- &191823872))*s pow 1 = (&4728103767)*((-- &12943360) * &1 + (&4784128) * &1 / &2) /\ ((&208706900270)*(&32768)+(&208748650)*(&40435712))*s pow 1 = (&4728103767)*((-- &12943360) * &0 + (&4784128) * &1 / &2) /\ (&208706900270)*(&92351)+(&208748650)*(&133937273)+(&10246150371539421) = (&4728103767)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &26609023416580` in
let npos = REAL_ARITH `!s:real. &0:real < &64732956365` in
let ppos = REAL_ARITH `!s:real. &0:real < &2345608432843465572` in
let qpos = REAL_ARITH `!s:real. &0:real < &14184311301` in
let mqrel = REAL_ARITH `
  ((&26609023416580)*(-- &131072)+(&64732956365)*(-- &191823872))*(&30902639 / &41749730) pow 1 = (&14184311301)*(((-- &1012072448) * &1 + (&364183552) * &1 / &2)) /\
  ((&26609023416580)*(&32768)+(&64732956365)*(&40435712))*(&30902639 / &41749730) pow 1 = (&14184311301)*(((-- &1012072448) * &0 + (&364183552) * &1 / &2)) /\
  (&26609023416580)*(&92351)+(&64732956365)*(&133937273)+(&2345608432843465572) = (&14184311301)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &131072) * x + (&32768) * y <= &92351 ==>
  (-- &191823872) * x + (&40435712) * y <= &133937273 ==>
  (-- &1012072448) * ((&1) * x + (&0) * y) / s pow 1 + (&364183552) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26609023416580` [mpos] THEN
  note `&0:real < &64732956365` [npos] THEN
  note `&0:real < &2345608432843465572` [ppos] THEN
  note `&0:real < &14184311301` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&26609023416580)*(-- &131072)+(&64732956365)*(-- &191823872))*s pow 1 = (&14184311301)*((-- &1012072448) * &1 + (&364183552) * &1 / &2) /\ ((&26609023416580)*(&32768)+(&64732956365)*(&40435712))*s pow 1 = (&14184311301)*((-- &1012072448) * &0 + (&364183552) * &1 / &2) /\ (&26609023416580)*(&92351)+(&64732956365)*(&133937273)+(&2345608432843465572) = (&14184311301)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &5719713010` in
let npos = REAL_ARITH `!s:real. &0:real < &40204989990` in
let ppos = REAL_ARITH `!s:real. &0:real < &210482707446521601` in
let qpos = REAL_ARITH `!s:real. &0:real < &341566868867` in
let mqrel = REAL_ARITH `
  ((&5719713010)*(-- &191823872)+(&40204989990)*(-- &9568256))*(&30902639 / &41749730) pow 1 = (&341566868867)*(((-- &3866624) * &1 + (&1310720) * &1 / &2)) /\
  ((&5719713010)*(&40435712)+(&40204989990)*(&1769472))*(&30902639 / &41749730) pow 1 = (&341566868867)*(((-- &3866624) * &0 + (&1310720) * &1 / &2)) /\
  (&5719713010)*(&133937273)+(&40204989990)*(&6651805)+(&210482707446521601) = (&341566868867)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &191823872) * x + (&40435712) * y <= &133937273 ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &3866624) * ((&1) * x + (&0) * y) / s pow 1 + (&1310720) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5719713010` [mpos] THEN
  note `&0:real < &40204989990` [npos] THEN
  note `&0:real < &210482707446521601` [ppos] THEN
  note `&0:real < &341566868867` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&5719713010)*(-- &191823872)+(&40204989990)*(-- &9568256))*s pow 1 = (&341566868867)*((-- &3866624) * &1 + (&1310720) * &1 / &2) /\ ((&5719713010)*(&40435712)+(&40204989990)*(&1769472))*s pow 1 = (&341566868867)*((-- &3866624) * &0 + (&1310720) * &1 / &2) /\ (&5719713010)*(&133937273)+(&40204989990)*(&6651805)+(&210482707446521601) = (&341566868867)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &605371085` in
let npos = REAL_ARITH `!s:real. &0:real < &264254916035` in
let ppos = REAL_ARITH `!s:real. &0:real < &118998460001722119` in
let qpos = REAL_ARITH `!s:real. &0:real < &29944657191` in
let mqrel = REAL_ARITH `
  ((&605371085)*(-- &9568256)+(&264254916035)*(-- &5767168))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((-- &39124992) * &1 + (&2621440) * &1 / &2)) /\
  ((&605371085)*(&1769472)+(&264254916035)*(&196608))*(&30902639 / &41749730) pow 1 = (&29944657191)*(((-- &39124992) * &0 + (&2621440) * &1 / &2)) /\
  (&605371085)*(&6651805)+(&264254916035)*(&3914969)+(&118998460001722119) = (&29944657191)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &9568256) * x + (&1769472) * y <= &6651805 ==>
  (-- &5767168) * x + (&196608) * y <= &3914969 ==>
  (-- &39124992) * ((&1) * x + (&0) * y) / s pow 1 + (&2621440) * ((&1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &605371085` [mpos] THEN
  note `&0:real < &264254916035` [npos] THEN
  note `&0:real < &118998460001722119` [ppos] THEN
  note `&0:real < &29944657191` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&605371085)*(-- &9568256)+(&264254916035)*(-- &5767168))*s pow 1 = (&29944657191)*((-- &39124992) * &1 + (&2621440) * &1 / &2) /\ ((&605371085)*(&1769472)+(&264254916035)*(&196608))*s pow 1 = (&29944657191)*((-- &39124992) * &0 + (&2621440) * &1 / &2) /\ (&605371085)*(&6651805)+(&264254916035)*(&3914969)+(&118998460001722119) = (&29944657191)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_H0 x y ==>
  divsteps_H1 (((&1) * x + (&0) * y) / divsteps_s pow 1) (((&1 / &2) * x + (&1 / &2) * y) / divsteps_s pow 1)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_H0] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H1] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

(* skipping Gc for approx *)

let theorem3 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &171783439058` in
let npos = REAL_ARITH `!s:real. &0:real < &137774109` in
let ppos = REAL_ARITH `!s:real. &0:real < &862200676190719` in
let qpos = REAL_ARITH `!s:real. &0:real < &3144219907694` in
let mqrel = REAL_ARITH `
  ((&171783439058)*(&11730944)+(&137774109)*(&22740992))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((-- &5865472) * &0 + (-- &950272) * -- &1 / &2)) /\
  ((&171783439058)*(-- &156696576)+(&137774109)*(-- &117506048))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((-- &5865472) * &1 + (-- &950272) * &1 / &2)) /\
  (&171783439058)*(&110400449)+(&137774109)*(&77682557)+(&862200676190719) = (&3144219907694)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &5865472) * ((&0) * x + (&1) * y) / s pow 1 + (-- &950272) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &171783439058` [mpos] THEN
  note `&0:real < &137774109` [npos] THEN
  note `&0:real < &862200676190719` [ppos] THEN
  note `&0:real < &3144219907694` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&171783439058)*(&11730944)+(&137774109)*(&22740992))*s pow 1 = (&3144219907694)*((-- &5865472) * &0 + (-- &950272) * -- &1 / &2) /\ ((&171783439058)*(-- &156696576)+(&137774109)*(-- &117506048))*s pow 1 = (&3144219907694)*((-- &5865472) * &1 + (-- &950272) * &1 / &2) /\ (&171783439058)*(&110400449)+(&137774109)*(&77682557)+(&862200676190719) = (&3144219907694)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &2301846313712` in
let npos = REAL_ARITH `!s:real. &0:real < &16174375623571` in
let ppos = REAL_ARITH `!s:real. &0:real < &28743965364681507` in
let qpos = REAL_ARITH `!s:real. &0:real < &3144219907694` in
let mqrel = REAL_ARITH `
  ((&2301846313712)*(&11730944)+(&16174375623571)*(&22740992))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((-- &439386112) * &0 + (-- &185892864) * -- &1 / &2)) /\
  ((&2301846313712)*(-- &156696576)+(&16174375623571)*(-- &117506048))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((-- &439386112) * &1 + (-- &185892864) * &1 / &2)) /\
  (&2301846313712)*(&110400449)+(&16174375623571)*(&77682557)+(&28743965364681507) = (&3144219907694)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &439386112) * ((&0) * x + (&1) * y) / s pow 1 + (-- &185892864) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2301846313712` [mpos] THEN
  note `&0:real < &16174375623571` [npos] THEN
  note `&0:real < &28743965364681507` [ppos] THEN
  note `&0:real < &3144219907694` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2301846313712)*(&11730944)+(&16174375623571)*(&22740992))*s pow 1 = (&3144219907694)*((-- &439386112) * &0 + (-- &185892864) * -- &1 / &2) /\ ((&2301846313712)*(-- &156696576)+(&16174375623571)*(-- &117506048))*s pow 1 = (&3144219907694)*((-- &439386112) * &1 + (-- &185892864) * &1 / &2) /\ (&2301846313712)*(&110400449)+(&16174375623571)*(&77682557)+(&28743965364681507) = (&3144219907694)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &1774363525000` in
let npos = REAL_ARITH `!s:real. &0:real < &205784419170` in
let ppos = REAL_ARITH `!s:real. &0:real < &4794410551616344693` in
let qpos = REAL_ARITH `!s:real. &0:real < &4088944484563` in
let mqrel = REAL_ARITH `
  ((&1774363525000)*(&22740992)+(&205784419170)*(&166330368))*(&30902639 / &41749730) pow 1 = (&4088944484563)*(((-- &49741824) * &0 + (-- &27000832) * -- &1 / &2)) /\
  ((&1774363525000)*(-- &117506048)+(&205784419170)*(-- &684523520))*(&30902639 / &41749730) pow 1 = (&4088944484563)*(((-- &49741824) * &1 + (-- &27000832) * &1 / &2)) /\
  (&1774363525000)*(&77682557)+(&205784419170)*(&441063407)+(&4794410551616344693) = (&4088944484563)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (-- &49741824) * ((&0) * x + (&1) * y) / s pow 1 + (-- &27000832) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1774363525000` [mpos] THEN
  note `&0:real < &205784419170` [npos] THEN
  note `&0:real < &4794410551616344693` [ppos] THEN
  note `&0:real < &4088944484563` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1774363525000)*(&22740992)+(&205784419170)*(&166330368))*s pow 1 = (&4088944484563)*((-- &49741824) * &0 + (-- &27000832) * -- &1 / &2) /\ ((&1774363525000)*(-- &117506048)+(&205784419170)*(-- &684523520))*s pow 1 = (&4088944484563)*((-- &49741824) * &1 + (-- &27000832) * &1 / &2) /\ (&1774363525000)*(&77682557)+(&205784419170)*(&441063407)+(&4794410551616344693) = (&4088944484563)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &4023546729290` in
let npos = REAL_ARITH `!s:real. &0:real < &6573098366065` in
let ppos = REAL_ARITH `!s:real. &0:real < &51451519548673944289` in
let qpos = REAL_ARITH `!s:real. &0:real < &27095804706868` in
let mqrel = REAL_ARITH `
  ((&4023546729290)*(&33882112)+(&6573098366065)*(&50659328))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((-- &33521664) * &0 + (-- &25640960) * -- &1 / &2)) /\
  ((&4023546729290)*(-- &135659520)+(&6573098366065)*(-- &175046656))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((-- &33521664) * &1 + (-- &25640960) * &1 / &2)) /\
  (&4023546729290)*(&87245513)+(&6573098366065)*(&111549985)+(&51451519548673944289) = (&27095804706868)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (-- &33521664) * ((&0) * x + (&1) * y) / s pow 1 + (-- &25640960) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4023546729290` [mpos] THEN
  note `&0:real < &6573098366065` [npos] THEN
  note `&0:real < &51451519548673944289` [ppos] THEN
  note `&0:real < &27095804706868` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4023546729290)*(&33882112)+(&6573098366065)*(&50659328))*s pow 1 = (&27095804706868)*((-- &33521664) * &0 + (-- &25640960) * -- &1 / &2) /\ ((&4023546729290)*(-- &135659520)+(&6573098366065)*(-- &175046656))*s pow 1 = (&27095804706868)*((-- &33521664) * &1 + (-- &25640960) * &1 / &2) /\ (&4023546729290)*(&87245513)+(&6573098366065)*(&111549985)+(&51451519548673944289) = (&27095804706868)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &73604773990` in
let npos = REAL_ARITH `!s:real. &0:real < &489452959655` in
let ppos = REAL_ARITH `!s:real. &0:real < &3147071396693767703` in
let qpos = REAL_ARITH `!s:real. &0:real < &27095804706868` in
let mqrel = REAL_ARITH `
  ((&73604773990)*(&33882112)+(&489452959655)*(&50659328))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((-- &1867776) * &0 + (-- &1490944) * -- &1 / &2)) /\
  ((&73604773990)*(-- &135659520)+(&489452959655)*(-- &175046656))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((-- &1867776) * &1 + (-- &1490944) * &1 / &2)) /\
  (&73604773990)*(&87245513)+(&489452959655)*(&111549985)+(&3147071396693767703) = (&27095804706868)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (-- &1867776) * ((&0) * x + (&1) * y) / s pow 1 + (-- &1490944) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &73604773990` [mpos] THEN
  note `&0:real < &489452959655` [npos] THEN
  note `&0:real < &3147071396693767703` [ppos] THEN
  note `&0:real < &27095804706868` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&73604773990)*(&33882112)+(&489452959655)*(&50659328))*s pow 1 = (&27095804706868)*((-- &1867776) * &0 + (-- &1490944) * -- &1 / &2) /\ ((&73604773990)*(-- &135659520)+(&489452959655)*(-- &175046656))*s pow 1 = (&27095804706868)*((-- &1867776) * &1 + (-- &1490944) * &1 / &2) /\ (&73604773990)*(&87245513)+(&489452959655)*(&111549985)+(&3147071396693767703) = (&27095804706868)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &1127885655842` in
let npos = REAL_ARITH `!s:real. &0:real < &29337535271` in
let ppos = REAL_ARITH `!s:real. &0:real < &694746757753979637` in
let qpos = REAL_ARITH `!s:real. &0:real < &1061629260206` in
let mqrel = REAL_ARITH `
  ((&1127885655842)*(&3457024)+(&29337535271)*(&58130432))*(&30902639 / &41749730) pow 1 = (&1061629260206)*(((-- &7634944) * &0 + (-- &7815168) * -- &1 / &2)) /\
  ((&1127885655842)*(-- &10452992)+(&29337535271)*(-- &162430976))*(&30902639 / &41749730) pow 1 = (&1061629260206)*(((-- &7634944) * &1 + (-- &7815168) * &1 / &2)) /\
  (&1127885655842)*(&6651805)+(&29337535271)*(&104374325)+(&694746757753979637) = (&1061629260206)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (-- &7634944) * ((&0) * x + (&1) * y) / s pow 1 + (-- &7815168) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1127885655842` [mpos] THEN
  note `&0:real < &29337535271` [npos] THEN
  note `&0:real < &694746757753979637` [ppos] THEN
  note `&0:real < &1061629260206` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1127885655842)*(&3457024)+(&29337535271)*(&58130432))*s pow 1 = (&1061629260206)*((-- &7634944) * &0 + (-- &7815168) * -- &1 / &2) /\ ((&1127885655842)*(-- &10452992)+(&29337535271)*(-- &162430976))*s pow 1 = (&1061629260206)*((-- &7634944) * &1 + (-- &7815168) * &1 / &2) /\ (&1127885655842)*(&6651805)+(&29337535271)*(&104374325)+(&694746757753979637) = (&1061629260206)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &3824400517190` in
let npos = REAL_ARITH `!s:real. &0:real < &288970756195` in
let ppos = REAL_ARITH `!s:real. &0:real < &32902714294009755887` in
let qpos = REAL_ARITH `!s:real. &0:real < &401053089225884` in
let mqrel = REAL_ARITH `
  ((&3824400517190)*(&58130432)+(&288970756195)*(&290521088))*(&30902639 / &41749730) pow 1 = (&401053089225884)*(((-- &950272) * &0 + (-- &1130496) * -- &1 / &2)) /\
  ((&3824400517190)*(-- &162430976)+(&288970756195)*(-- &691929088))*(&30902639 / &41749730) pow 1 = (&401053089225884)*(((-- &950272) * &1 + (-- &1130496) * &1 / &2)) /\
  (&3824400517190)*(&104374325)+(&288970756195)*(&457690221)+(&32902714294009755887) = (&401053089225884)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &950272) * ((&0) * x + (&1) * y) / s pow 1 + (-- &1130496) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3824400517190` [mpos] THEN
  note `&0:real < &288970756195` [npos] THEN
  note `&0:real < &32902714294009755887` [ppos] THEN
  note `&0:real < &401053089225884` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3824400517190)*(&58130432)+(&288970756195)*(&290521088))*s pow 1 = (&401053089225884)*((-- &950272) * &0 + (-- &1130496) * -- &1 / &2) /\ ((&3824400517190)*(-- &162430976)+(&288970756195)*(-- &691929088))*s pow 1 = (&401053089225884)*((-- &950272) * &1 + (-- &1130496) * &1 / &2) /\ (&3824400517190)*(&104374325)+(&288970756195)*(&457690221)+(&32902714294009755887) = (&401053089225884)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &369127816310660` in
let npos = REAL_ARITH `!s:real. &0:real < &51972401888880` in
let ppos = REAL_ARITH `!s:real. &0:real < &3772055864396103944643` in
let qpos = REAL_ARITH `!s:real. &0:real < &100263272306471` in
let mqrel = REAL_ARITH `
  ((&369127816310660)*(&58130432)+(&51972401888880)*(&290521088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((-- &438239232) * &0 + (-- &539754496) * -- &1 / &2)) /\
  ((&369127816310660)*(-- &162430976)+(&51972401888880)*(-- &691929088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((-- &438239232) * &1 + (-- &539754496) * &1 / &2)) /\
  (&369127816310660)*(&104374325)+(&51972401888880)*(&457690221)+(&3772055864396103944643) = (&100263272306471)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &438239232) * ((&0) * x + (&1) * y) / s pow 1 + (-- &539754496) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &369127816310660` [mpos] THEN
  note `&0:real < &51972401888880` [npos] THEN
  note `&0:real < &3772055864396103944643` [ppos] THEN
  note `&0:real < &100263272306471` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&369127816310660)*(&58130432)+(&51972401888880)*(&290521088))*s pow 1 = (&100263272306471)*((-- &438239232) * &0 + (-- &539754496) * -- &1 / &2) /\ ((&369127816310660)*(-- &162430976)+(&51972401888880)*(-- &691929088))*s pow 1 = (&100263272306471)*((-- &438239232) * &1 + (-- &539754496) * &1 / &2) /\ (&369127816310660)*(&104374325)+(&51972401888880)*(&457690221)+(&3772055864396103944643) = (&100263272306471)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &7174023104820` in
let npos = REAL_ARITH `!s:real. &0:real < &2536880593720` in
let ppos = REAL_ARITH `!s:real. &0:real < &121109458119472168827` in
let qpos = REAL_ARITH `!s:real. &0:real < &100263272306471` in
let mqrel = REAL_ARITH `
  ((&7174023104820)*(&58130432)+(&2536880593720)*(&290521088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((-- &13041664) * &0 + (-- &17039360) * -- &1 / &2)) /\
  ((&7174023104820)*(-- &162430976)+(&2536880593720)*(-- &691929088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((-- &13041664) * &1 + (-- &17039360) * &1 / &2)) /\
  (&7174023104820)*(&104374325)+(&2536880593720)*(&457690221)+(&121109458119472168827) = (&100263272306471)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &13041664) * ((&0) * x + (&1) * y) / s pow 1 + (-- &17039360) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7174023104820` [mpos] THEN
  note `&0:real < &2536880593720` [npos] THEN
  note `&0:real < &121109458119472168827` [ppos] THEN
  note `&0:real < &100263272306471` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7174023104820)*(&58130432)+(&2536880593720)*(&290521088))*s pow 1 = (&100263272306471)*((-- &13041664) * &0 + (-- &17039360) * -- &1 / &2) /\ ((&7174023104820)*(-- &162430976)+(&2536880593720)*(-- &691929088))*s pow 1 = (&100263272306471)*((-- &13041664) * &1 + (-- &17039360) * &1 / &2) /\ (&7174023104820)*(&104374325)+(&2536880593720)*(&457690221)+(&121109458119472168827) = (&100263272306471)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &597985557763` in
let npos = REAL_ARITH `!s:real. &0:real < &4682198819716` in
let ppos = REAL_ARITH `!s:real. &0:real < &25154837217534606855` in
let qpos = REAL_ARITH `!s:real. &0:real < &29913816357278` in
let mqrel = REAL_ARITH `
  ((&597985557763)*(&290521088)+(&4682198819716)*(&14442496))*(&30902639 / &41749730) pow 1 = (&29913816357278)*(((-- &7733248) * &0 + (-- &11943936) * -- &1 / &2)) /\
  ((&597985557763)*(-- &691929088)+(&4682198819716)*(-- &29925376))*(&30902639 / &41749730) pow 1 = (&29913816357278)*(((-- &7733248) * &1 + (-- &11943936) * &1 / &2)) /\
  (&597985557763)*(&457690221)+(&4682198819716)*(&20669487)+(&25154837217534606855) = (&29913816357278)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &7733248) * ((&0) * x + (&1) * y) / s pow 1 + (-- &11943936) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &597985557763` [mpos] THEN
  note `&0:real < &4682198819716` [npos] THEN
  note `&0:real < &25154837217534606855` [ppos] THEN
  note `&0:real < &29913816357278` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&597985557763)*(&290521088)+(&4682198819716)*(&14442496))*s pow 1 = (&29913816357278)*((-- &7733248) * &0 + (-- &11943936) * -- &1 / &2) /\ ((&597985557763)*(-- &691929088)+(&4682198819716)*(-- &29925376))*s pow 1 = (&29913816357278)*((-- &7733248) * &1 + (-- &11943936) * &1 / &2) /\ (&597985557763)*(&457690221)+(&4682198819716)*(&20669487)+(&25154837217534606855) = (&29913816357278)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &201808706245` in
let npos = REAL_ARITH `!s:real. &0:real < &48718139480` in
let ppos = REAL_ARITH `!s:real. &0:real < &294989463882239243` in
let qpos = REAL_ARITH `!s:real. &0:real < &2465536149976` in
let mqrel = REAL_ARITH `
  ((&201808706245)*(&15433728)+(&48718139480)*(&5660672))*(&30902639 / &41749730) pow 1 = (&2465536149976)*(((-- &897024) * &0 + (-- &2035712) * -- &1 / &2)) /\
  ((&201808706245)*(-- &29458432)+(&48718139480)*(-- &8896512))*(&30902639 / &41749730) pow 1 = (&2465536149976)*(((-- &897024) * &1 + (-- &2035712) * &1 / &2)) /\
  (&201808706245)*(&21015329)+(&48718139480)*(&6951751)+(&294989463882239243) = (&2465536149976)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &897024) * ((&0) * x + (&1) * y) / s pow 1 + (-- &2035712) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &201808706245` [mpos] THEN
  note `&0:real < &48718139480` [npos] THEN
  note `&0:real < &294989463882239243` [ppos] THEN
  note `&0:real < &2465536149976` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&201808706245)*(&15433728)+(&48718139480)*(&5660672))*s pow 1 = (&2465536149976)*((-- &897024) * &0 + (-- &2035712) * -- &1 / &2) /\ ((&201808706245)*(-- &29458432)+(&48718139480)*(-- &8896512))*s pow 1 = (&2465536149976)*((-- &897024) * &1 + (-- &2035712) * &1 / &2) /\ (&201808706245)*(&21015329)+(&48718139480)*(&6951751)+(&294989463882239243) = (&2465536149976)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &5030842465` in
let npos = REAL_ARITH `!s:real. &0:real < &2605016153080` in
let ppos = REAL_ARITH `!s:real. &0:real < &1157629254166732615` in
let qpos = REAL_ARITH `!s:real. &0:real < &4931072299952` in
let mqrel = REAL_ARITH `
  ((&5030842465)*(&15433728)+(&2605016153080)*(&5660672))*(&30902639 / &41749730) pow 1 = (&4931072299952)*(((-- &1275904) * &0 + (-- &4450304) * -- &1 / &2)) /\
  ((&5030842465)*(-- &29458432)+(&2605016153080)*(-- &8896512))*(&30902639 / &41749730) pow 1 = (&4931072299952)*(((-- &1275904) * &1 + (-- &4450304) * &1 / &2)) /\
  (&5030842465)*(&21015329)+(&2605016153080)*(&6951751)+(&1157629254166732615) = (&4931072299952)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &1275904) * ((&0) * x + (&1) * y) / s pow 1 + (-- &4450304) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5030842465` [mpos] THEN
  note `&0:real < &2605016153080` [npos] THEN
  note `&0:real < &1157629254166732615` [ppos] THEN
  note `&0:real < &4931072299952` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&5030842465)*(&15433728)+(&2605016153080)*(&5660672))*s pow 1 = (&4931072299952)*((-- &1275904) * &0 + (-- &4450304) * -- &1 / &2) /\ ((&5030842465)*(-- &29458432)+(&2605016153080)*(-- &8896512))*s pow 1 = (&4931072299952)*((-- &1275904) * &1 + (-- &4450304) * &1 / &2) /\ (&5030842465)*(&21015329)+(&2605016153080)*(&6951751)+(&1157629254166732615) = (&4931072299952)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &16436952200460` in
let npos = REAL_ARITH `!s:real. &0:real < &209583644600` in
let ppos = REAL_ARITH `!s:real. &0:real < &13111944343437400573` in
let qpos = REAL_ARITH `!s:real. &0:real < &26955228602057` in
let mqrel = REAL_ARITH `
  ((&16436952200460)*(&5660672)+(&209583644600)*(&373096448))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((-- &2211840) * &0 + (-- &9404416) * -- &1 / &2)) /\
  ((&16436952200460)*(-- &8896512)+(&209583644600)*(-- &503644160))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((-- &2211840) * &1 + (-- &9404416) * &1 / &2)) /\
  (&16436952200460)*(&6951751)+(&209583644600)*(&426281637)+(&13111944343437400573) = (&26955228602057)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &2211840) * ((&0) * x + (&1) * y) / s pow 1 + (-- &9404416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16436952200460` [mpos] THEN
  note `&0:real < &209583644600` [npos] THEN
  note `&0:real < &13111944343437400573` [ppos] THEN
  note `&0:real < &26955228602057` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&16436952200460)*(&5660672)+(&209583644600)*(&373096448))*s pow 1 = (&26955228602057)*((-- &2211840) * &0 + (-- &9404416) * -- &1 / &2) /\ ((&16436952200460)*(-- &8896512)+(&209583644600)*(-- &503644160))*s pow 1 = (&26955228602057)*((-- &2211840) * &1 + (-- &9404416) * &1 / &2) /\ (&16436952200460)*(&6951751)+(&209583644600)*(&426281637)+(&13111944343437400573) = (&26955228602057)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &31094530908320` in
let npos = REAL_ARITH `!s:real. &0:real < &1386487658435` in
let ppos = REAL_ARITH `!s:real. &0:real < &53864502514584060544` in
let qpos = REAL_ARITH `!s:real. &0:real < &26955228602057` in
let mqrel = REAL_ARITH `
  ((&31094530908320)*(&5660672)+(&1386487658435)*(&373096448))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((-- &7733248) * &0 + (-- &38076416) * -- &1 / &2)) /\
  ((&31094530908320)*(-- &8896512)+(&1386487658435)*(-- &503644160))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((-- &7733248) * &1 + (-- &38076416) * &1 / &2)) /\
  (&31094530908320)*(&6951751)+(&1386487658435)*(&426281637)+(&53864502514584060544) = (&26955228602057)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &7733248) * ((&0) * x + (&1) * y) / s pow 1 + (-- &38076416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &31094530908320` [mpos] THEN
  note `&0:real < &1386487658435` [npos] THEN
  note `&0:real < &53864502514584060544` [ppos] THEN
  note `&0:real < &26955228602057` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&31094530908320)*(&5660672)+(&1386487658435)*(&373096448))*s pow 1 = (&26955228602057)*((-- &7733248) * &0 + (-- &38076416) * -- &1 / &2) /\ ((&31094530908320)*(-- &8896512)+(&1386487658435)*(-- &503644160))*s pow 1 = (&26955228602057)*((-- &7733248) * &1 + (-- &38076416) * &1 / &2) /\ (&31094530908320)*(&6951751)+(&1386487658435)*(&426281637)+(&53864502514584060544) = (&26955228602057)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &12865054050310` in
let npos = REAL_ARITH `!s:real. &0:real < &2171528706490` in
let ppos = REAL_ARITH `!s:real. &0:real < &47005321635144743621` in
let qpos = REAL_ARITH `!s:real. &0:real < &20756962687271` in
let mqrel = REAL_ARITH `
  ((&12865054050310)*(&46596096)+(&2171528706490)*(&84901888))*(&30902639 / &41749730) pow 1 = (&20756962687271)*(((-- &1966080) * &0 + (-- &55902208) * -- &1 / &2)) /\
  ((&12865054050310)*(-- &51871744)+(&2171528706490)*(-- &79036416))*(&30902639 / &41749730) pow 1 = (&20756962687271)*(((-- &1966080) * &1 + (-- &55902208) * &1 / &2)) /\
  (&12865054050310)*(&49963991)+(&2171528706490)*(&86789633)+(&47005321635144743621) = (&20756962687271)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (-- &1966080) * ((&0) * x + (&1) * y) / s pow 1 + (-- &55902208) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12865054050310` [mpos] THEN
  note `&0:real < &2171528706490` [npos] THEN
  note `&0:real < &47005321635144743621` [ppos] THEN
  note `&0:real < &20756962687271` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12865054050310)*(&46596096)+(&2171528706490)*(&84901888))*s pow 1 = (&20756962687271)*((-- &1966080) * &0 + (-- &55902208) * -- &1 / &2) /\ ((&12865054050310)*(-- &51871744)+(&2171528706490)*(-- &79036416))*s pow 1 = (&20756962687271)*((-- &1966080) * &1 + (-- &55902208) * &1 / &2) /\ (&12865054050310)*(&49963991)+(&2171528706490)*(&86789633)+(&47005321635144743621) = (&20756962687271)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &26186996270875` in
let npos = REAL_ARITH `!s:real. &0:real < &10428852930485` in
let ppos = REAL_ARITH `!s:real. &0:real < &132413825103003430356` in
let qpos = REAL_ARITH `!s:real. &0:real < &34251125351484` in
let mqrel = REAL_ARITH `
  ((&26186996270875)*(&84901888)+(&10428852930485)*(&134447104))*(&30902639 / &41749730) pow 1 = (&34251125351484)*(((&11730944) * &0 + (-- &156696576) * -- &1 / &2)) /\
  ((&26186996270875)*(-- &79036416)+(&10428852930485)*(-- &97124352))*(&30902639 / &41749730) pow 1 = (&34251125351484)*(((&11730944) * &1 + (-- &156696576) * &1 / &2)) /\
  (&26186996270875)*(&86789633)+(&10428852930485)*(&131957561)+(&132413825103003430356) = (&34251125351484)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&11730944) * ((&0) * x + (&1) * y) / s pow 1 + (-- &156696576) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26186996270875` [mpos] THEN
  note `&0:real < &10428852930485` [npos] THEN
  note `&0:real < &132413825103003430356` [ppos] THEN
  note `&0:real < &34251125351484` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&26186996270875)*(&84901888)+(&10428852930485)*(&134447104))*s pow 1 = (&34251125351484)*((&11730944) * &0 + (-- &156696576) * -- &1 / &2) /\ ((&26186996270875)*(-- &79036416)+(&10428852930485)*(-- &97124352))*s pow 1 = (&34251125351484)*((&11730944) * &1 + (-- &156696576) * &1 / &2) /\ (&26186996270875)*(&86789633)+(&10428852930485)*(&131957561)+(&132413825103003430356) = (&34251125351484)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &12877161472010` in
let npos = REAL_ARITH `!s:real. &0:real < &16809589415575` in
let ppos = REAL_ARITH `!s:real. &0:real < &40083105071283583946` in
let qpos = REAL_ARITH `!s:real. &0:real < &43073550662233` in
let mqrel = REAL_ARITH `
  ((&12877161472010)*(&134447104)+(&16809589415575)*(&100401152))*(&30902639 / &41749730) pow 1 = (&43073550662233)*(((&22740992) * &0 + (-- &117506048) * -- &1 / &2)) /\
  ((&12877161472010)*(-- &97124352)+(&16809589415575)*(-- &50266112))*(&30902639 / &41749730) pow 1 = (&43073550662233)*(((&22740992) * &1 + (-- &117506048) * &1 / &2)) /\
  (&12877161472010)*(&131957561)+(&16809589415575)*(&95584823)+(&40083105071283583946) = (&43073550662233)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&22740992) * ((&0) * x + (&1) * y) / s pow 1 + (-- &117506048) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12877161472010` [mpos] THEN
  note `&0:real < &16809589415575` [npos] THEN
  note `&0:real < &40083105071283583946` [ppos] THEN
  note `&0:real < &43073550662233` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12877161472010)*(&134447104)+(&16809589415575)*(&100401152))*s pow 1 = (&43073550662233)*((&22740992) * &0 + (-- &117506048) * -- &1 / &2) /\ ((&12877161472010)*(-- &97124352)+(&16809589415575)*(-- &50266112))*s pow 1 = (&43073550662233)*((&22740992) * &1 + (-- &117506048) * &1 / &2) /\ (&12877161472010)*(&131957561)+(&16809589415575)*(&95584823)+(&40083105071283583946) = (&43073550662233)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &687242305530` in
let npos = REAL_ARITH `!s:real. &0:real < &14339383140665` in
let ppos = REAL_ARITH `!s:real. &0:real < &83244168257276362` in
let qpos = REAL_ARITH `!s:real. &0:real < &3313350050941` in
let mqrel = REAL_ARITH `
  ((&687242305530)*(&134447104)+(&14339383140665)*(&100401152))*(&30902639 / &41749730) pow 1 = (&3313350050941)*(((&166330368) * &0 + (-- &684523520) * -- &1 / &2)) /\
  ((&687242305530)*(-- &97124352)+(&14339383140665)*(-- &50266112))*(&30902639 / &41749730) pow 1 = (&3313350050941)*(((&166330368) * &1 + (-- &684523520) * &1 / &2)) /\
  (&687242305530)*(&131957561)+(&14339383140665)*(&95584823)+(&83244168257276362) = (&3313350050941)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&166330368) * ((&0) * x + (&1) * y) / s pow 1 + (-- &684523520) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &687242305530` [mpos] THEN
  note `&0:real < &14339383140665` [npos] THEN
  note `&0:real < &83244168257276362` [ppos] THEN
  note `&0:real < &3313350050941` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&687242305530)*(&134447104)+(&14339383140665)*(&100401152))*s pow 1 = (&3313350050941)*((&166330368) * &0 + (-- &684523520) * -- &1 / &2) /\ ((&687242305530)*(-- &97124352)+(&14339383140665)*(-- &50266112))*s pow 1 = (&3313350050941)*((&166330368) * &1 + (-- &684523520) * &1 / &2) /\ (&687242305530)*(&131957561)+(&14339383140665)*(&95584823)+(&83244168257276362) = (&3313350050941)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &6760575528630` in
let npos = REAL_ARITH `!s:real. &0:real < &22461354740` in
let ppos = REAL_ARITH `!s:real. &0:real < &34212597067729511` in
let qpos = REAL_ARITH `!s:real. &0:real < &7422906595717` in
let mqrel = REAL_ARITH `
  ((&6760575528630)*(&100401152)+(&22461354740)*(&64782336))*(&30902639 / &41749730) pow 1 = (&7422906595717)*(((&33882112) * &0 + (-- &135659520) * -- &1 / &2)) /\
  ((&6760575528630)*(-- &50266112)+(&22461354740)*(-- &27295744))*(&30902639 / &41749730) pow 1 = (&7422906595717)*(((&33882112) * &1 + (-- &135659520) * &1 / &2)) /\
  (&6760575528630)*(&95584823)+(&22461354740)*(&61112343)+(&34212597067729511) = (&7422906595717)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&64782336) * x + (-- &27295744) * y <= &61112343 ==>
  (&33882112) * ((&0) * x + (&1) * y) / s pow 1 + (-- &135659520) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6760575528630` [mpos] THEN
  note `&0:real < &22461354740` [npos] THEN
  note `&0:real < &34212597067729511` [ppos] THEN
  note `&0:real < &7422906595717` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6760575528630)*(&100401152)+(&22461354740)*(&64782336))*s pow 1 = (&7422906595717)*((&33882112) * &0 + (-- &135659520) * -- &1 / &2) /\ ((&6760575528630)*(-- &50266112)+(&22461354740)*(-- &27295744))*s pow 1 = (&7422906595717)*((&33882112) * &1 + (-- &135659520) * &1 / &2) /\ (&6760575528630)*(&95584823)+(&22461354740)*(&61112343)+(&34212597067729511) = (&7422906595717)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &2271561059570` in
let npos = REAL_ARITH `!s:real. &0:real < &34151279140` in
let ppos = REAL_ARITH `!s:real. &0:real < &6705416892720365` in
let qpos = REAL_ARITH `!s:real. &0:real < &1248250297127` in
let mqrel = REAL_ARITH `
  ((&2271561059570)*(&64782336)+(&34151279140)*(&12943360))*(&30902639 / &41749730) pow 1 = (&1248250297127)*(((&50659328) * &0 + (-- &175046656) * -- &1 / &2)) /\
  ((&2271561059570)*(-- &27295744)+(&34151279140)*(-- &4784128))*(&30902639 / &41749730) pow 1 = (&1248250297127)*(((&50659328) * &1 + (-- &175046656) * &1 / &2)) /\
  (&2271561059570)*(&61112343)+(&34151279140)*(&12157023)+(&6705416892720365) = (&1248250297127)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&64782336) * x + (-- &27295744) * y <= &61112343 ==>
  (&12943360) * x + (-- &4784128) * y <= &12157023 ==>
  (&50659328) * ((&0) * x + (&1) * y) / s pow 1 + (-- &175046656) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2271561059570` [mpos] THEN
  note `&0:real < &34151279140` [npos] THEN
  note `&0:real < &6705416892720365` [ppos] THEN
  note `&0:real < &1248250297127` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2271561059570)*(&64782336)+(&34151279140)*(&12943360))*s pow 1 = (&1248250297127)*((&50659328) * &0 + (-- &175046656) * -- &1 / &2) /\ ((&2271561059570)*(-- &27295744)+(&34151279140)*(-- &4784128))*s pow 1 = (&1248250297127)*((&50659328) * &1 + (-- &175046656) * &1 / &2) /\ (&2271561059570)*(&61112343)+(&34151279140)*(&12157023)+(&6705416892720365) = (&1248250297127)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &3356260794700` in
let npos = REAL_ARITH `!s:real. &0:real < &62624595` in
let ppos = REAL_ARITH `!s:real. &0:real < &1968635820771560` in
let qpos = REAL_ARITH `!s:real. &0:real < &1843744150657` in
let mqrel = REAL_ARITH `
  ((&3356260794700)*(&12943360)+(&62624595)*(&1012072448))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((&11010048) * &0 + (-- &34930688) * -- &1 / &2)) /\
  ((&3356260794700)*(-- &4784128)+(&62624595)*(-- &364183552))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((&11010048) * &1 + (-- &34930688) * &1 / &2)) /\
  (&3356260794700)*(&12157023)+(&62624595)*(&949861697)+(&1968635820771560) = (&1843744150657)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&12943360) * x + (-- &4784128) * y <= &12157023 ==>
  (&1012072448) * x + (-- &364183552) * y <= &949861697 ==>
  (&11010048) * ((&0) * x + (&1) * y) / s pow 1 + (-- &34930688) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3356260794700` [mpos] THEN
  note `&0:real < &62624595` [npos] THEN
  note `&0:real < &1968635820771560` [ppos] THEN
  note `&0:real < &1843744150657` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3356260794700)*(&12943360)+(&62624595)*(&1012072448))*s pow 1 = (&1843744150657)*((&11010048) * &0 + (-- &34930688) * -- &1 / &2) /\ ((&3356260794700)*(-- &4784128)+(&62624595)*(-- &364183552))*s pow 1 = (&1843744150657)*((&11010048) * &1 + (-- &34930688) * &1 / &2) /\ (&3356260794700)*(&12157023)+(&62624595)*(&949861697)+(&1968635820771560) = (&1843744150657)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &204323178620` in
let npos = REAL_ARITH `!s:real. &0:real < &558298264425` in
let ppos = REAL_ARITH `!s:real. &0:real < &25637943832392526` in
let qpos = REAL_ARITH `!s:real. &0:real < &1843744150657` in
let mqrel = REAL_ARITH `
  ((&204323178620)*(&12943360)+(&558298264425)*(&1012072448))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((&145883136) * &0 + (-- &455802880) * -- &1 / &2)) /\
  ((&204323178620)*(-- &4784128)+(&558298264425)*(-- &364183552))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((&145883136) * &1 + (-- &455802880) * &1 / &2)) /\
  (&204323178620)*(&12157023)+(&558298264425)*(&949861697)+(&25637943832392526) = (&1843744150657)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&12943360) * x + (-- &4784128) * y <= &12157023 ==>
  (&1012072448) * x + (-- &364183552) * y <= &949861697 ==>
  (&145883136) * ((&0) * x + (&1) * y) / s pow 1 + (-- &455802880) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &204323178620` [mpos] THEN
  note `&0:real < &558298264425` [npos] THEN
  note `&0:real < &25637943832392526` [ppos] THEN
  note `&0:real < &1843744150657` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&204323178620)*(&12943360)+(&558298264425)*(&1012072448))*s pow 1 = (&1843744150657)*((&145883136) * &0 + (-- &455802880) * -- &1 / &2) /\ ((&204323178620)*(-- &4784128)+(&558298264425)*(-- &364183552))*s pow 1 = (&1843744150657)*((&145883136) * &1 + (-- &455802880) * &1 / &2) /\ (&204323178620)*(&12157023)+(&558298264425)*(&949861697)+(&25637943832392526) = (&1843744150657)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &53978225917` in
let npos = REAL_ARITH `!s:real. &0:real < &8349946` in
let ppos = REAL_ARITH `!s:real. &0:real < &11073851540025` in
let qpos = REAL_ARITH `!s:real. &0:real < &29604728162` in
let mqrel = REAL_ARITH `
  ((&53978225917)*(&3866624)+(&8349946)*(&39124992))*(&30902639 / &41749730) pow 1 = (&29604728162)*(((&3457024) * &0 + (-- &10452992) * -- &1 / &2)) /\
  ((&53978225917)*(-- &1310720)+(&8349946)*(-- &2621440))*(&30902639 / &41749730) pow 1 = (&29604728162)*(((&3457024) * &1 + (-- &10452992) * &1 / &2)) /\
  (&53978225917)*(&3642043)+(&8349946)*(&38657149)+(&11073851540025) = (&29604728162)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&3457024) * ((&0) * x + (&1) * y) / s pow 1 + (-- &10452992) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &53978225917` [mpos] THEN
  note `&0:real < &8349946` [npos] THEN
  note `&0:real < &11073851540025` [ppos] THEN
  note `&0:real < &29604728162` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&53978225917)*(&3866624)+(&8349946)*(&39124992))*s pow 1 = (&29604728162)*((&3457024) * &0 + (-- &10452992) * -- &1 / &2) /\ ((&53978225917)*(-- &1310720)+(&8349946)*(-- &2621440))*s pow 1 = (&29604728162)*((&3457024) * &1 + (-- &10452992) * &1 / &2) /\ (&53978225917)*(&3642043)+(&8349946)*(&38657149)+(&11073851540025) = (&29604728162)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &2684060916889` in
let npos = REAL_ARITH `!s:real. &0:real < &66837142757` in
let ppos = REAL_ARITH `!s:real. &0:real < &695414648178580` in
let qpos = REAL_ARITH `!s:real. &0:real < &118418912648` in
let mqrel = REAL_ARITH `
  ((&2684060916889)*(&3866624)+(&66837142757)*(&39124992))*(&30902639 / &41749730) pow 1 = (&118418912648)*(((&58130432) * &0 + (-- &162430976) * -- &1 / &2)) /\
  ((&2684060916889)*(-- &1310720)+(&66837142757)*(-- &2621440))*(&30902639 / &41749730) pow 1 = (&118418912648)*(((&58130432) * &1 + (-- &162430976) * &1 / &2)) /\
  (&2684060916889)*(&3642043)+(&66837142757)*(&38657149)+(&695414648178580) = (&118418912648)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&58130432) * ((&0) * x + (&1) * y) / s pow 1 + (-- &162430976) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2684060916889` [mpos] THEN
  note `&0:real < &66837142757` [npos] THEN
  note `&0:real < &695414648178580` [ppos] THEN
  note `&0:real < &118418912648` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2684060916889)*(&3866624)+(&66837142757)*(&39124992))*s pow 1 = (&118418912648)*((&58130432) * &0 + (-- &162430976) * -- &1 / &2) /\ ((&2684060916889)*(-- &1310720)+(&66837142757)*(-- &2621440))*s pow 1 = (&118418912648)*((&58130432) * &1 + (-- &162430976) * &1 / &2) /\ (&2684060916889)*(&3642043)+(&66837142757)*(&38657149)+(&695414648178580) = (&118418912648)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &613516457323` in
let npos = REAL_ARITH `!s:real. &0:real < &116202023509` in
let ppos = REAL_ARITH `!s:real. &0:real < &48405031888405171` in
let qpos = REAL_ARITH `!s:real. &0:real < &14802364081` in
let mqrel = REAL_ARITH `
  ((&613516457323)*(&3866624)+(&116202023509)*(&39124992))*(&30902639 / &41749730) pow 1 = (&14802364081)*(((&290521088) * &0 + (-- &691929088) * -- &1 / &2)) /\
  ((&613516457323)*(-- &1310720)+(&116202023509)*(-- &2621440))*(&30902639 / &41749730) pow 1 = (&14802364081)*(((&290521088) * &1 + (-- &691929088) * &1 / &2)) /\
  (&613516457323)*(&3642043)+(&116202023509)*(&38657149)+(&48405031888405171) = (&14802364081)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&290521088) * ((&0) * x + (&1) * y) / s pow 1 + (-- &691929088) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &613516457323` [mpos] THEN
  note `&0:real < &116202023509` [npos] THEN
  note `&0:real < &48405031888405171` [ppos] THEN
  note `&0:real < &14802364081` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&613516457323)*(&3866624)+(&116202023509)*(&39124992))*s pow 1 = (&14802364081)*((&290521088) * &0 + (-- &691929088) * -- &1 / &2) /\ ((&613516457323)*(-- &1310720)+(&116202023509)*(-- &2621440))*s pow 1 = (&14802364081)*((&290521088) * &1 + (-- &691929088) * &1 / &2) /\ (&613516457323)*(&3642043)+(&116202023509)*(&38657149)+(&48405031888405171) = (&14802364081)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &1342984439775` in
let npos = REAL_ARITH `!s:real. &0:real < &1467523884365` in
let ppos = REAL_ARITH `!s:real. &0:real < &1754701327831109266` in
let qpos = REAL_ARITH `!s:real. &0:real < &3025121136988` in
let mqrel = REAL_ARITH `
  ((&1342984439775)*(&39124992)+(&1467523884365)*(&5865472))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((&14442496) * &0 + (-- &29925376) * -- &1 / &2)) /\
  ((&1342984439775)*(-- &2621440)+(&1467523884365)*(&950272))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((&14442496) * &1 + (-- &29925376) * &1 / &2)) /\
  (&1342984439775)*(&38657149)+(&1467523884365)*(&6035371)+(&1754701327831109266) = (&3025121136988)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&14442496) * ((&0) * x + (&1) * y) / s pow 1 + (-- &29925376) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1342984439775` [mpos] THEN
  note `&0:real < &1467523884365` [npos] THEN
  note `&0:real < &1754701327831109266` [ppos] THEN
  note `&0:real < &3025121136988` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1342984439775)*(&39124992)+(&1467523884365)*(&5865472))*s pow 1 = (&3025121136988)*((&14442496) * &0 + (-- &29925376) * -- &1 / &2) /\ ((&1342984439775)*(-- &2621440)+(&1467523884365)*(&950272))*s pow 1 = (&3025121136988)*((&14442496) * &1 + (-- &29925376) * &1 / &2) /\ (&1342984439775)*(&38657149)+(&1467523884365)*(&6035371)+(&1754701327831109266) = (&3025121136988)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &1258900483555` in
let npos = REAL_ARITH `!s:real. &0:real < &4688348554945` in
let ppos = REAL_ARITH `!s:real. &0:real < &2995341563006731538` in
let qpos = REAL_ARITH `!s:real. &0:real < &3025121136988` in
let mqrel = REAL_ARITH `
  ((&1258900483555)*(&39124992)+(&4688348554945)*(&5865472))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((&19062784) * &0 + (-- &37560320) * -- &1 / &2)) /\
  ((&1258900483555)*(-- &2621440)+(&4688348554945)*(&950272))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((&19062784) * &1 + (-- &37560320) * &1 / &2)) /\
  (&1258900483555)*(&38657149)+(&4688348554945)*(&6035371)+(&2995341563006731538) = (&3025121136988)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&19062784) * ((&0) * x + (&1) * y) / s pow 1 + (-- &37560320) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1258900483555` [mpos] THEN
  note `&0:real < &4688348554945` [npos] THEN
  note `&0:real < &2995341563006731538` [ppos] THEN
  note `&0:real < &3025121136988` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1258900483555)*(&39124992)+(&4688348554945)*(&5865472))*s pow 1 = (&3025121136988)*((&19062784) * &0 + (-- &37560320) * -- &1 / &2) /\ ((&1258900483555)*(-- &2621440)+(&4688348554945)*(&950272))*s pow 1 = (&3025121136988)*((&19062784) * &1 + (-- &37560320) * &1 / &2) /\ (&1258900483555)*(&38657149)+(&4688348554945)*(&6035371)+(&2995341563006731538) = (&3025121136988)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &191777384755` in
let npos = REAL_ARITH `!s:real. &0:real < &1286538804815` in
let ppos = REAL_ARITH `!s:real. &0:real < &715173059404747403` in
let qpos = REAL_ARITH `!s:real. &0:real < &756280284247` in
let mqrel = REAL_ARITH `
  ((&191777384755)*(&39124992)+(&1286538804815)*(&5865472))*(&30902639 / &41749730) pow 1 = (&756280284247)*(((&15433728) * &0 + (-- &29458432) * -- &1 / &2)) /\
  ((&191777384755)*(-- &2621440)+(&1286538804815)*(&950272))*(&30902639 / &41749730) pow 1 = (&756280284247)*(((&15433728) * &1 + (-- &29458432) * &1 / &2)) /\
  (&191777384755)*(&38657149)+(&1286538804815)*(&6035371)+(&715173059404747403) = (&756280284247)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&15433728) * ((&0) * x + (&1) * y) / s pow 1 + (-- &29458432) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &191777384755` [mpos] THEN
  note `&0:real < &1286538804815` [npos] THEN
  note `&0:real < &715173059404747403` [ppos] THEN
  note `&0:real < &756280284247` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&191777384755)*(&39124992)+(&1286538804815)*(&5865472))*s pow 1 = (&756280284247)*((&15433728) * &0 + (-- &29458432) * -- &1 / &2) /\ ((&191777384755)*(-- &2621440)+(&1286538804815)*(&950272))*s pow 1 = (&756280284247)*((&15433728) * &1 + (-- &29458432) * &1 / &2) /\ (&191777384755)*(&38657149)+(&1286538804815)*(&6035371)+(&715173059404747403) = (&756280284247)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &22876910677555` in
let npos = REAL_ARITH `!s:real. &0:real < &224300424425` in
let ppos = REAL_ARITH `!s:real. &0:real < &23389983927957967288` in
let qpos = REAL_ARITH `!s:real. &0:real < &38727558026468` in
let mqrel = REAL_ARITH `
  ((&22876910677555)*(&5865472)+(&224300424425)*(&439386112))*(&30902639 / &41749730) pow 1 = (&38727558026468)*(((&5660672) * &0 + (-- &8896512) * -- &1 / &2)) /\
  ((&22876910677555)*(&950272)+(&224300424425)*(&185892864))*(&30902639 / &41749730) pow 1 = (&38727558026468)*(((&5660672) * &1 + (-- &8896512) * &1 / &2)) /\
  (&22876910677555)*(&6035371)+(&224300424425)*(&480443643)+(&23389983927957967288) = (&38727558026468)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&5660672) * ((&0) * x + (&1) * y) / s pow 1 + (-- &8896512) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22876910677555` [mpos] THEN
  note `&0:real < &224300424425` [npos] THEN
  note `&0:real < &23389983927957967288` [ppos] THEN
  note `&0:real < &38727558026468` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&22876910677555)*(&5865472)+(&224300424425)*(&439386112))*s pow 1 = (&38727558026468)*((&5660672) * &0 + (-- &8896512) * -- &1 / &2) /\ ((&22876910677555)*(&950272)+(&224300424425)*(&185892864))*s pow 1 = (&38727558026468)*((&5660672) * &1 + (-- &8896512) * &1 / &2) /\ (&22876910677555)*(&6035371)+(&224300424425)*(&480443643)+(&23389983927957967288) = (&38727558026468)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &1355579574230` in
let npos = REAL_ARITH `!s:real. &0:real < &11442659726360` in
let ppos = REAL_ARITH `!s:real. &0:real < &155052554158734747363` in
let qpos = REAL_ARITH `!s:real. &0:real < &3423734277449` in
let mqrel = REAL_ARITH `
  ((&1355579574230)*(&439386112)+(&11442659726360)*(&49741824))*(&30902639 / &41749730) pow 1 = (&3423734277449)*(((&373096448) * &0 + (-- &503644160) * -- &1 / &2)) /\
  ((&1355579574230)*(&185892864)+(&11442659726360)*(&27000832))*(&30902639 / &41749730) pow 1 = (&3423734277449)*(((&373096448) * &1 + (-- &503644160) * &1 / &2)) /\
  (&1355579574230)*(&480443643)+(&11442659726360)*(&57079641)+(&155052554158734747363) = (&3423734277449)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&373096448) * ((&0) * x + (&1) * y) / s pow 1 + (-- &503644160) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1355579574230` [mpos] THEN
  note `&0:real < &11442659726360` [npos] THEN
  note `&0:real < &155052554158734747363` [ppos] THEN
  note `&0:real < &3423734277449` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1355579574230)*(&439386112)+(&11442659726360)*(&49741824))*s pow 1 = (&3423734277449)*((&373096448) * &0 + (-- &503644160) * -- &1 / &2) /\ ((&1355579574230)*(&185892864)+(&11442659726360)*(&27000832))*s pow 1 = (&3423734277449)*((&373096448) * &1 + (-- &503644160) * &1 / &2) /\ (&1355579574230)*(&480443643)+(&11442659726360)*(&57079641)+(&155052554158734747363) = (&3423734277449)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &91902542020` in
let npos = REAL_ARITH `!s:real. &0:real < &6938046040` in
let ppos = REAL_ARITH `!s:real. &0:real < &671909032582929435` in
let qpos = REAL_ARITH `!s:real. &0:real < &968890440567` in
let mqrel = REAL_ARITH `
  ((&91902542020)*(&49741824)+(&6938046040)*(&33521664))*(&30902639 / &41749730) pow 1 = (&968890440567)*(((&5701632) * &0 + (-- &7340032) * -- &1 / &2)) /\
  ((&91902542020)*(&27000832)+(&6938046040)*(&25640960))*(&30902639 / &41749730) pow 1 = (&968890440567)*(((&5701632) * &1 + (-- &7340032) * &1 / &2)) /\
  (&91902542020)*(&57079641)+(&6938046040)*(&41914863)+(&671909032582929435) = (&968890440567)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&5701632) * ((&0) * x + (&1) * y) / s pow 1 + (-- &7340032) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &91902542020` [mpos] THEN
  note `&0:real < &6938046040` [npos] THEN
  note `&0:real < &671909032582929435` [ppos] THEN
  note `&0:real < &968890440567` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&91902542020)*(&49741824)+(&6938046040)*(&33521664))*s pow 1 = (&968890440567)*((&5701632) * &0 + (-- &7340032) * -- &1 / &2) /\ ((&91902542020)*(&27000832)+(&6938046040)*(&25640960))*s pow 1 = (&968890440567)*((&5701632) * &1 + (-- &7340032) * &1 / &2) /\ (&91902542020)*(&57079641)+(&6938046040)*(&41914863)+(&671909032582929435) = (&968890440567)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &6241584635` in
let npos = REAL_ARITH `!s:real. &0:real < &2141990772515` in
let ppos = REAL_ARITH `!s:real. &0:real < &668952384970479192` in
let qpos = REAL_ARITH `!s:real. &0:real < &120149460432` in
let mqrel = REAL_ARITH `
  ((&6241584635)*(&33521664)+(&2141990772515)*(&1867776))*(&30902639 / &41749730) pow 1 = (&120149460432)*(((&46596096) * &0 + (-- &51871744) * -- &1 / &2)) /\
  ((&6241584635)*(&25640960)+(&2141990772515)*(&1490944))*(&30902639 / &41749730) pow 1 = (&120149460432)*(((&46596096) * &1 + (-- &51871744) * &1 / &2)) /\
  (&6241584635)*(&41914863)+(&2141990772515)*(&2368161)+(&668952384970479192) = (&120149460432)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&1867776) * x + (&1490944) * y <= &2368161 ==>
  (&46596096) * ((&0) * x + (&1) * y) / s pow 1 + (-- &51871744) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6241584635` [mpos] THEN
  note `&0:real < &2141990772515` [npos] THEN
  note `&0:real < &668952384970479192` [ppos] THEN
  note `&0:real < &120149460432` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6241584635)*(&33521664)+(&2141990772515)*(&1867776))*s pow 1 = (&120149460432)*((&46596096) * &0 + (-- &51871744) * -- &1 / &2) /\ ((&6241584635)*(&25640960)+(&2141990772515)*(&1490944))*s pow 1 = (&120149460432)*((&46596096) * &1 + (-- &51871744) * &1 / &2) /\ (&6241584635)*(&41914863)+(&2141990772515)*(&2368161)+(&668952384970479192) = (&120149460432)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &2736505030` in
let npos = REAL_ARITH `!s:real. &0:real < &66560455910` in
let ppos = REAL_ARITH `!s:real. &0:real < &14102199351063297` in
let qpos = REAL_ARITH `!s:real. &0:real < &1576034589` in
let mqrel = REAL_ARITH `
  ((&2736505030)*(&7634944)+(&66560455910)*(&950272))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((&84901888) * &0 + (-- &79036416) * -- &1 / &2)) /\
  ((&2736505030)*(&7815168)+(&66560455910)*(&1130496))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((&84901888) * &1 + (-- &79036416) * &1 / &2)) /\
  (&2736505030)*(&10605687)+(&66560455910)*(&1407123)+(&14102199351063297) = (&1576034589)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&950272) * x + (&1130496) * y <= &1407123 ==>
  (&84901888) * ((&0) * x + (&1) * y) / s pow 1 + (-- &79036416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2736505030` [mpos] THEN
  note `&0:real < &66560455910` [npos] THEN
  note `&0:real < &14102199351063297` [ppos] THEN
  note `&0:real < &1576034589` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2736505030)*(&7634944)+(&66560455910)*(&950272))*s pow 1 = (&1576034589)*((&84901888) * &0 + (-- &79036416) * -- &1 / &2) /\ ((&2736505030)*(&7815168)+(&66560455910)*(&1130496))*s pow 1 = (&1576034589)*((&84901888) * &1 + (-- &79036416) * &1 / &2) /\ (&2736505030)*(&10605687)+(&66560455910)*(&1407123)+(&14102199351063297) = (&1576034589)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &13573254720300` in
let npos = REAL_ARITH `!s:real. &0:real < &52348817454560` in
let ppos = REAL_ARITH `!s:real. &0:real < &22549644868526269727` in
let qpos = REAL_ARITH `!s:real. &0:real < &2315627448187` in
let mqrel = REAL_ARITH `
  ((&13573254720300)*(&7733248)+(&52348817454560)*(&897024))*(&30902639 / &41749730) pow 1 = (&2315627448187)*(((&134447104) * &0 + (-- &97124352) * -- &1 / &2)) /\
  ((&13573254720300)*(&11943936)+(&52348817454560)*(&2035712))*(&30902639 / &41749730) pow 1 = (&2315627448187)*(((&134447104) * &1 + (-- &97124352) * &1 / &2)) /\
  (&13573254720300)*(&13225515)+(&52348817454560)*(&1977153)+(&22549644868526269727) = (&2315627448187)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&11943936) * y <= &13225515 ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&134447104) * ((&0) * x + (&1) * y) / s pow 1 + (-- &97124352) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &13573254720300` [mpos] THEN
  note `&0:real < &52348817454560` [npos] THEN
  note `&0:real < &22549644868526269727` [ppos] THEN
  note `&0:real < &2315627448187` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&13573254720300)*(&7733248)+(&52348817454560)*(&897024))*s pow 1 = (&2315627448187)*((&134447104) * &0 + (-- &97124352) * -- &1 / &2) /\ ((&13573254720300)*(&11943936)+(&52348817454560)*(&2035712))*s pow 1 = (&2315627448187)*((&134447104) * &1 + (-- &97124352) * &1 / &2) /\ (&13573254720300)*(&13225515)+(&52348817454560)*(&1977153)+(&22549644868526269727) = (&2315627448187)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &4919370685900` in
let npos = REAL_ARITH `!s:real. &0:real < &5086954102120` in
let ppos = REAL_ARITH `!s:real. &0:real < &981636297537079227` in
let qpos = REAL_ARITH `!s:real. &0:real < &321109321849` in
let mqrel = REAL_ARITH `
  ((&4919370685900)*(&897024)+(&5086954102120)*(&1275904))*(&30902639 / &41749730) pow 1 = (&321109321849)*(((&100401152) * &0 + (-- &50266112) * -- &1 / &2)) /\
  ((&4919370685900)*(&2035712)+(&5086954102120)*(&4450304))*(&30902639 / &41749730) pow 1 = (&321109321849)*(((&100401152) * &1 + (-- &50266112) * &1 / &2)) /\
  (&4919370685900)*(&1977153)+(&5086954102120)*(&3928715)+(&981636297537079227) = (&321109321849)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&100401152) * ((&0) * x + (&1) * y) / s pow 1 + (-- &50266112) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4919370685900` [mpos] THEN
  note `&0:real < &5086954102120` [npos] THEN
  note `&0:real < &981636297537079227` [ppos] THEN
  note `&0:real < &321109321849` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4919370685900)*(&897024)+(&5086954102120)*(&1275904))*s pow 1 = (&321109321849)*((&100401152) * &0 + (-- &50266112) * -- &1 / &2) /\ ((&4919370685900)*(&2035712)+(&5086954102120)*(&4450304))*s pow 1 = (&321109321849)*((&100401152) * &1 + (-- &50266112) * &1 / &2) /\ (&4919370685900)*(&1977153)+(&5086954102120)*(&3928715)+(&981636297537079227) = (&321109321849)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &18973415296880` in
let npos = REAL_ARITH `!s:real. &0:real < &5605903246020` in
let ppos = REAL_ARITH `!s:real. &0:real < &1720129124522020139` in
let qpos = REAL_ARITH `!s:real. &0:real < &1985401847833` in
let mqrel = REAL_ARITH `
  ((&18973415296880)*(&1275904)+(&5605903246020)*(&2211840))*(&30902639 / &41749730) pow 1 = (&1985401847833)*(((&64782336) * &0 + (-- &27295744) * -- &1 / &2)) /\
  ((&18973415296880)*(&4450304)+(&5605903246020)*(&9404416))*(&30902639 / &41749730) pow 1 = (&1985401847833)*(((&64782336) * &1 + (-- &27295744) * &1 / &2)) /\
  (&18973415296880)*(&3928715)+(&5605903246020)*(&8039969)+(&1720129124522020139) = (&1985401847833)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&64782336) * ((&0) * x + (&1) * y) / s pow 1 + (-- &27295744) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &18973415296880` [mpos] THEN
  note `&0:real < &5605903246020` [npos] THEN
  note `&0:real < &1720129124522020139` [ppos] THEN
  note `&0:real < &1985401847833` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&18973415296880)*(&1275904)+(&5605903246020)*(&2211840))*s pow 1 = (&1985401847833)*((&64782336) * &0 + (-- &27295744) * -- &1 / &2) /\ ((&18973415296880)*(&4450304)+(&5605903246020)*(&9404416))*s pow 1 = (&1985401847833)*((&64782336) * &1 + (-- &27295744) * &1 / &2) /\ (&18973415296880)*(&3928715)+(&5605903246020)*(&8039969)+(&1720129124522020139) = (&1985401847833)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &4789832660` in
let npos = REAL_ARITH `!s:real. &0:real < &425088160` in
let ppos = REAL_ARITH `!s:real. &0:real < &130929671336423` in
let qpos = REAL_ARITH `!s:real. &0:real < &4295466821` in
let mqrel = REAL_ARITH `
  ((&4789832660)*(&2211840)+(&425088160)*(&7733248))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((&12943360) * &0 + (-- &4784128) * -- &1 / &2)) /\
  ((&4789832660)*(&9404416)+(&425088160)*(&38076416))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((&12943360) * &1 + (-- &4784128) * &1 / &2)) /\
  (&4789832660)*(&8039969)+(&425088160)*(&31944087)+(&130929671336423) = (&4295466821)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&12943360) * ((&0) * x + (&1) * y) / s pow 1 + (-- &4784128) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4789832660` [mpos] THEN
  note `&0:real < &425088160` [npos] THEN
  note `&0:real < &130929671336423` [ppos] THEN
  note `&0:real < &4295466821` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4789832660)*(&2211840)+(&425088160)*(&7733248))*s pow 1 = (&4295466821)*((&12943360) * &0 + (-- &4784128) * -- &1 / &2) /\ ((&4789832660)*(&9404416)+(&425088160)*(&38076416))*s pow 1 = (&4295466821)*((&12943360) * &1 + (-- &4784128) * &1 / &2) /\ (&4789832660)*(&8039969)+(&425088160)*(&31944087)+(&130929671336423) = (&4295466821)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &1820250273700` in
let npos = REAL_ARITH `!s:real. &0:real < &435899442355` in
let ppos = REAL_ARITH `!s:real. &0:real < &1530345386666474` in
let qpos = REAL_ARITH `!s:real. &0:real < &30068267747` in
let mqrel = REAL_ARITH `
  ((&1820250273700)*(&2211840)+(&435899442355)*(&7733248))*(&30902639 / &41749730) pow 1 = (&30068267747)*(((&1012072448) * &0 + (-- &364183552) * -- &1 / &2)) /\
  ((&1820250273700)*(&9404416)+(&435899442355)*(&38076416))*(&30902639 / &41749730) pow 1 = (&30068267747)*(((&1012072448) * &1 + (-- &364183552) * &1 / &2)) /\
  (&1820250273700)*(&8039969)+(&435899442355)*(&31944087)+(&1530345386666474) = (&30068267747)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&1012072448) * ((&0) * x + (&1) * y) / s pow 1 + (-- &364183552) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1820250273700` [mpos] THEN
  note `&0:real < &435899442355` [npos] THEN
  note `&0:real < &1530345386666474` [ppos] THEN
  note `&0:real < &30068267747` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1820250273700)*(&2211840)+(&435899442355)*(&7733248))*s pow 1 = (&30068267747)*((&1012072448) * &0 + (-- &364183552) * -- &1 / &2) /\ ((&1820250273700)*(&9404416)+(&435899442355)*(&38076416))*s pow 1 = (&30068267747)*((&1012072448) * &1 + (-- &364183552) * &1 / &2) /\ (&1820250273700)*(&8039969)+(&435899442355)*(&31944087)+(&1530345386666474) = (&30068267747)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &60726880` in
let npos = REAL_ARITH `!s:real. &0:real < &474428750` in
let ppos = REAL_ARITH `!s:real. &0:real < &839369187333` in
let qpos = REAL_ARITH `!s:real. &0:real < &4295466821` in
let mqrel = REAL_ARITH `
  ((&60726880)*(&2211840)+(&474428750)*(&7733248))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((&3866624) * &0 + (-- &1310720) * -- &1 / &2)) /\
  ((&60726880)*(&9404416)+(&474428750)*(&38076416))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((&3866624) * &1 + (-- &1310720) * &1 / &2)) /\
  (&60726880)*(&8039969)+(&474428750)*(&31944087)+(&839369187333) = (&4295466821)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&3866624) * ((&0) * x + (&1) * y) / s pow 1 + (-- &1310720) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &60726880` [mpos] THEN
  note `&0:real < &474428750` [npos] THEN
  note `&0:real < &839369187333` [ppos] THEN
  note `&0:real < &4295466821` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&60726880)*(&2211840)+(&474428750)*(&7733248))*s pow 1 = (&4295466821)*((&3866624) * &0 + (-- &1310720) * -- &1 / &2) /\ ((&60726880)*(&9404416)+(&474428750)*(&38076416))*s pow 1 = (&4295466821)*((&3866624) * &1 + (-- &1310720) * &1 / &2) /\ (&60726880)*(&8039969)+(&474428750)*(&31944087)+(&839369187333) = (&4295466821)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &6308509452190` in
let npos = REAL_ARITH `!s:real. &0:real < &10437432500` in
let ppos = REAL_ARITH `!s:real. &0:real < &14704318120509597` in
let qpos = REAL_ARITH `!s:real. &0:real < &6935077536463` in
let mqrel = REAL_ARITH `
  ((&6308509452190)*(&1966080)+(&10437432500)*(-- &11730944))*(&30902639 / &41749730) pow 1 = (&6935077536463)*(((&39124992) * &0 + (-- &2621440) * -- &1 / &2)) /\
  ((&6308509452190)*(&55902208)+(&10437432500)*(&156696576))*(&30902639 / &41749730) pow 1 = (&6935077536463)*(((&39124992) * &1 + (-- &2621440) * &1 / &2)) /\
  (&6308509452190)*(&42311631)+(&10437432500)*(&110400449)+(&14704318120509597) = (&6935077536463)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1966080) * x + (&55902208) * y <= &42311631 ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (&39124992) * ((&0) * x + (&1) * y) / s pow 1 + (-- &2621440) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6308509452190` [mpos] THEN
  note `&0:real < &10437432500` [npos] THEN
  note `&0:real < &14704318120509597` [ppos] THEN
  note `&0:real < &6935077536463` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6308509452190)*(&1966080)+(&10437432500)*(-- &11730944))*s pow 1 = (&6935077536463)*((&39124992) * &0 + (-- &2621440) * -- &1 / &2) /\ ((&6308509452190)*(&55902208)+(&10437432500)*(&156696576))*s pow 1 = (&6935077536463)*((&39124992) * &1 + (-- &2621440) * &1 / &2) /\ (&6308509452190)*(&42311631)+(&10437432500)*(&110400449)+(&14704318120509597) = (&6935077536463)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &171783439058` in
let npos = REAL_ARITH `!s:real. &0:real < &137774109` in
let ppos = REAL_ARITH `!s:real. &0:real < &862200676190719` in
let qpos = REAL_ARITH `!s:real. &0:real < &3144219907694` in
let mqrel = REAL_ARITH `
  ((&171783439058)*(-- &11730944)+(&137774109)*(-- &22740992))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((&5865472) * &0 + (&950272) * -- &1 / &2)) /\
  ((&171783439058)*(&156696576)+(&137774109)*(&117506048))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((&5865472) * &1 + (&950272) * &1 / &2)) /\
  (&171783439058)*(&110400449)+(&137774109)*(&77682557)+(&862200676190719) = (&3144219907694)*(&6035371)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (&5865472) * ((&0) * x + (&1) * y) / s pow 1 + (&950272) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6035371
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &171783439058` [mpos] THEN
  note `&0:real < &137774109` [npos] THEN
  note `&0:real < &862200676190719` [ppos] THEN
  note `&0:real < &3144219907694` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&171783439058)*(-- &11730944)+(&137774109)*(-- &22740992))*s pow 1 = (&3144219907694)*((&5865472) * &0 + (&950272) * -- &1 / &2) /\ ((&171783439058)*(&156696576)+(&137774109)*(&117506048))*s pow 1 = (&3144219907694)*((&5865472) * &1 + (&950272) * &1 / &2) /\ (&171783439058)*(&110400449)+(&137774109)*(&77682557)+(&862200676190719) = (&3144219907694)*(&6035371)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &2301846313712` in
let npos = REAL_ARITH `!s:real. &0:real < &16174375623571` in
let ppos = REAL_ARITH `!s:real. &0:real < &28743965364681507` in
let qpos = REAL_ARITH `!s:real. &0:real < &3144219907694` in
let mqrel = REAL_ARITH `
  ((&2301846313712)*(-- &11730944)+(&16174375623571)*(-- &22740992))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((&439386112) * &0 + (&185892864) * -- &1 / &2)) /\
  ((&2301846313712)*(&156696576)+(&16174375623571)*(&117506048))*(&30902639 / &41749730) pow 1 = (&3144219907694)*(((&439386112) * &1 + (&185892864) * &1 / &2)) /\
  (&2301846313712)*(&110400449)+(&16174375623571)*(&77682557)+(&28743965364681507) = (&3144219907694)*(&480443643)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (&439386112) * ((&0) * x + (&1) * y) / s pow 1 + (&185892864) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &480443643
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2301846313712` [mpos] THEN
  note `&0:real < &16174375623571` [npos] THEN
  note `&0:real < &28743965364681507` [ppos] THEN
  note `&0:real < &3144219907694` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2301846313712)*(-- &11730944)+(&16174375623571)*(-- &22740992))*s pow 1 = (&3144219907694)*((&439386112) * &0 + (&185892864) * -- &1 / &2) /\ ((&2301846313712)*(&156696576)+(&16174375623571)*(&117506048))*s pow 1 = (&3144219907694)*((&439386112) * &1 + (&185892864) * &1 / &2) /\ (&2301846313712)*(&110400449)+(&16174375623571)*(&77682557)+(&28743965364681507) = (&3144219907694)*(&480443643)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &1774363525000` in
let npos = REAL_ARITH `!s:real. &0:real < &205784419170` in
let ppos = REAL_ARITH `!s:real. &0:real < &4794410551616344693` in
let qpos = REAL_ARITH `!s:real. &0:real < &4088944484563` in
let mqrel = REAL_ARITH `
  ((&1774363525000)*(-- &22740992)+(&205784419170)*(-- &166330368))*(&30902639 / &41749730) pow 1 = (&4088944484563)*(((&49741824) * &0 + (&27000832) * -- &1 / &2)) /\
  ((&1774363525000)*(&117506048)+(&205784419170)*(&684523520))*(&30902639 / &41749730) pow 1 = (&4088944484563)*(((&49741824) * &1 + (&27000832) * &1 / &2)) /\
  (&1774363525000)*(&77682557)+(&205784419170)*(&441063407)+(&4794410551616344693) = (&4088944484563)*(&57079641)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (-- &166330368) * x + (&684523520) * y <= &441063407 ==>
  (&49741824) * ((&0) * x + (&1) * y) / s pow 1 + (&27000832) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &57079641
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1774363525000` [mpos] THEN
  note `&0:real < &205784419170` [npos] THEN
  note `&0:real < &4794410551616344693` [ppos] THEN
  note `&0:real < &4088944484563` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1774363525000)*(-- &22740992)+(&205784419170)*(-- &166330368))*s pow 1 = (&4088944484563)*((&49741824) * &0 + (&27000832) * -- &1 / &2) /\ ((&1774363525000)*(&117506048)+(&205784419170)*(&684523520))*s pow 1 = (&4088944484563)*((&49741824) * &1 + (&27000832) * &1 / &2) /\ (&1774363525000)*(&77682557)+(&205784419170)*(&441063407)+(&4794410551616344693) = (&4088944484563)*(&57079641)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &4023546729290` in
let npos = REAL_ARITH `!s:real. &0:real < &6573098366065` in
let ppos = REAL_ARITH `!s:real. &0:real < &51451519548673944289` in
let qpos = REAL_ARITH `!s:real. &0:real < &27095804706868` in
let mqrel = REAL_ARITH `
  ((&4023546729290)*(-- &33882112)+(&6573098366065)*(-- &50659328))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((&33521664) * &0 + (&25640960) * -- &1 / &2)) /\
  ((&4023546729290)*(&135659520)+(&6573098366065)*(&175046656))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((&33521664) * &1 + (&25640960) * &1 / &2)) /\
  (&4023546729290)*(&87245513)+(&6573098366065)*(&111549985)+(&51451519548673944289) = (&27095804706868)*(&41914863)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (&33521664) * ((&0) * x + (&1) * y) / s pow 1 + (&25640960) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &41914863
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4023546729290` [mpos] THEN
  note `&0:real < &6573098366065` [npos] THEN
  note `&0:real < &51451519548673944289` [ppos] THEN
  note `&0:real < &27095804706868` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4023546729290)*(-- &33882112)+(&6573098366065)*(-- &50659328))*s pow 1 = (&27095804706868)*((&33521664) * &0 + (&25640960) * -- &1 / &2) /\ ((&4023546729290)*(&135659520)+(&6573098366065)*(&175046656))*s pow 1 = (&27095804706868)*((&33521664) * &1 + (&25640960) * &1 / &2) /\ (&4023546729290)*(&87245513)+(&6573098366065)*(&111549985)+(&51451519548673944289) = (&27095804706868)*(&41914863)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &73604773990` in
let npos = REAL_ARITH `!s:real. &0:real < &489452959655` in
let ppos = REAL_ARITH `!s:real. &0:real < &3147071396693767703` in
let qpos = REAL_ARITH `!s:real. &0:real < &27095804706868` in
let mqrel = REAL_ARITH `
  ((&73604773990)*(-- &33882112)+(&489452959655)*(-- &50659328))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((&1867776) * &0 + (&1490944) * -- &1 / &2)) /\
  ((&73604773990)*(&135659520)+(&489452959655)*(&175046656))*(&30902639 / &41749730) pow 1 = (&27095804706868)*(((&1867776) * &1 + (&1490944) * &1 / &2)) /\
  (&73604773990)*(&87245513)+(&489452959655)*(&111549985)+(&3147071396693767703) = (&27095804706868)*(&2368161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (&1867776) * ((&0) * x + (&1) * y) / s pow 1 + (&1490944) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &2368161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &73604773990` [mpos] THEN
  note `&0:real < &489452959655` [npos] THEN
  note `&0:real < &3147071396693767703` [ppos] THEN
  note `&0:real < &27095804706868` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&73604773990)*(-- &33882112)+(&489452959655)*(-- &50659328))*s pow 1 = (&27095804706868)*((&1867776) * &0 + (&1490944) * -- &1 / &2) /\ ((&73604773990)*(&135659520)+(&489452959655)*(&175046656))*s pow 1 = (&27095804706868)*((&1867776) * &1 + (&1490944) * &1 / &2) /\ (&73604773990)*(&87245513)+(&489452959655)*(&111549985)+(&3147071396693767703) = (&27095804706868)*(&2368161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &1127885655842` in
let npos = REAL_ARITH `!s:real. &0:real < &29337535271` in
let ppos = REAL_ARITH `!s:real. &0:real < &694746757753979637` in
let qpos = REAL_ARITH `!s:real. &0:real < &1061629260206` in
let mqrel = REAL_ARITH `
  ((&1127885655842)*(-- &3457024)+(&29337535271)*(-- &58130432))*(&30902639 / &41749730) pow 1 = (&1061629260206)*(((&7634944) * &0 + (&7815168) * -- &1 / &2)) /\
  ((&1127885655842)*(&10452992)+(&29337535271)*(&162430976))*(&30902639 / &41749730) pow 1 = (&1061629260206)*(((&7634944) * &1 + (&7815168) * &1 / &2)) /\
  (&1127885655842)*(&6651805)+(&29337535271)*(&104374325)+(&694746757753979637) = (&1061629260206)*(&10605687)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (&7634944) * ((&0) * x + (&1) * y) / s pow 1 + (&7815168) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &10605687
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1127885655842` [mpos] THEN
  note `&0:real < &29337535271` [npos] THEN
  note `&0:real < &694746757753979637` [ppos] THEN
  note `&0:real < &1061629260206` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1127885655842)*(-- &3457024)+(&29337535271)*(-- &58130432))*s pow 1 = (&1061629260206)*((&7634944) * &0 + (&7815168) * -- &1 / &2) /\ ((&1127885655842)*(&10452992)+(&29337535271)*(&162430976))*s pow 1 = (&1061629260206)*((&7634944) * &1 + (&7815168) * &1 / &2) /\ (&1127885655842)*(&6651805)+(&29337535271)*(&104374325)+(&694746757753979637) = (&1061629260206)*(&10605687)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &3824400517190` in
let npos = REAL_ARITH `!s:real. &0:real < &288970756195` in
let ppos = REAL_ARITH `!s:real. &0:real < &32902714294009755887` in
let qpos = REAL_ARITH `!s:real. &0:real < &401053089225884` in
let mqrel = REAL_ARITH `
  ((&3824400517190)*(-- &58130432)+(&288970756195)*(-- &290521088))*(&30902639 / &41749730) pow 1 = (&401053089225884)*(((&950272) * &0 + (&1130496) * -- &1 / &2)) /\
  ((&3824400517190)*(&162430976)+(&288970756195)*(&691929088))*(&30902639 / &41749730) pow 1 = (&401053089225884)*(((&950272) * &1 + (&1130496) * &1 / &2)) /\
  (&3824400517190)*(&104374325)+(&288970756195)*(&457690221)+(&32902714294009755887) = (&401053089225884)*(&1407123)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (&950272) * ((&0) * x + (&1) * y) / s pow 1 + (&1130496) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1407123
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3824400517190` [mpos] THEN
  note `&0:real < &288970756195` [npos] THEN
  note `&0:real < &32902714294009755887` [ppos] THEN
  note `&0:real < &401053089225884` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3824400517190)*(-- &58130432)+(&288970756195)*(-- &290521088))*s pow 1 = (&401053089225884)*((&950272) * &0 + (&1130496) * -- &1 / &2) /\ ((&3824400517190)*(&162430976)+(&288970756195)*(&691929088))*s pow 1 = (&401053089225884)*((&950272) * &1 + (&1130496) * &1 / &2) /\ (&3824400517190)*(&104374325)+(&288970756195)*(&457690221)+(&32902714294009755887) = (&401053089225884)*(&1407123)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &369127816310660` in
let npos = REAL_ARITH `!s:real. &0:real < &51972401888880` in
let ppos = REAL_ARITH `!s:real. &0:real < &3772055864396103944643` in
let qpos = REAL_ARITH `!s:real. &0:real < &100263272306471` in
let mqrel = REAL_ARITH `
  ((&369127816310660)*(-- &58130432)+(&51972401888880)*(-- &290521088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((&438239232) * &0 + (&539754496) * -- &1 / &2)) /\
  ((&369127816310660)*(&162430976)+(&51972401888880)*(&691929088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((&438239232) * &1 + (&539754496) * &1 / &2)) /\
  (&369127816310660)*(&104374325)+(&51972401888880)*(&457690221)+(&3772055864396103944643) = (&100263272306471)*(&659132513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (&438239232) * ((&0) * x + (&1) * y) / s pow 1 + (&539754496) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &659132513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &369127816310660` [mpos] THEN
  note `&0:real < &51972401888880` [npos] THEN
  note `&0:real < &3772055864396103944643` [ppos] THEN
  note `&0:real < &100263272306471` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&369127816310660)*(-- &58130432)+(&51972401888880)*(-- &290521088))*s pow 1 = (&100263272306471)*((&438239232) * &0 + (&539754496) * -- &1 / &2) /\ ((&369127816310660)*(&162430976)+(&51972401888880)*(&691929088))*s pow 1 = (&100263272306471)*((&438239232) * &1 + (&539754496) * &1 / &2) /\ (&369127816310660)*(&104374325)+(&51972401888880)*(&457690221)+(&3772055864396103944643) = (&100263272306471)*(&659132513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &7174023104820` in
let npos = REAL_ARITH `!s:real. &0:real < &2536880593720` in
let ppos = REAL_ARITH `!s:real. &0:real < &121109458119472168827` in
let qpos = REAL_ARITH `!s:real. &0:real < &100263272306471` in
let mqrel = REAL_ARITH `
  ((&7174023104820)*(-- &58130432)+(&2536880593720)*(-- &290521088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((&13041664) * &0 + (&17039360) * -- &1 / &2)) /\
  ((&7174023104820)*(&162430976)+(&2536880593720)*(&691929088))*(&30902639 / &41749730) pow 1 = (&100263272306471)*(((&13041664) * &1 + (&17039360) * &1 / &2)) /\
  (&7174023104820)*(&104374325)+(&2536880593720)*(&457690221)+(&121109458119472168827) = (&100263272306471)*(&20256657)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (&13041664) * ((&0) * x + (&1) * y) / s pow 1 + (&17039360) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20256657
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7174023104820` [mpos] THEN
  note `&0:real < &2536880593720` [npos] THEN
  note `&0:real < &121109458119472168827` [ppos] THEN
  note `&0:real < &100263272306471` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&7174023104820)*(-- &58130432)+(&2536880593720)*(-- &290521088))*s pow 1 = (&100263272306471)*((&13041664) * &0 + (&17039360) * -- &1 / &2) /\ ((&7174023104820)*(&162430976)+(&2536880593720)*(&691929088))*s pow 1 = (&100263272306471)*((&13041664) * &1 + (&17039360) * &1 / &2) /\ (&7174023104820)*(&104374325)+(&2536880593720)*(&457690221)+(&121109458119472168827) = (&100263272306471)*(&20256657)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &597985557763` in
let npos = REAL_ARITH `!s:real. &0:real < &4682198819716` in
let ppos = REAL_ARITH `!s:real. &0:real < &25154837217534606855` in
let qpos = REAL_ARITH `!s:real. &0:real < &29913816357278` in
let mqrel = REAL_ARITH `
  ((&597985557763)*(-- &290521088)+(&4682198819716)*(-- &14442496))*(&30902639 / &41749730) pow 1 = (&29913816357278)*(((&7733248) * &0 + (&11943936) * -- &1 / &2)) /\
  ((&597985557763)*(&691929088)+(&4682198819716)*(&29925376))*(&30902639 / &41749730) pow 1 = (&29913816357278)*(((&7733248) * &1 + (&11943936) * &1 / &2)) /\
  (&597985557763)*(&457690221)+(&4682198819716)*(&20669487)+(&25154837217534606855) = (&29913816357278)*(&13225515)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (-- &14442496) * x + (&29925376) * y <= &20669487 ==>
  (&7733248) * ((&0) * x + (&1) * y) / s pow 1 + (&11943936) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &13225515
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &597985557763` [mpos] THEN
  note `&0:real < &4682198819716` [npos] THEN
  note `&0:real < &25154837217534606855` [ppos] THEN
  note `&0:real < &29913816357278` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&597985557763)*(-- &290521088)+(&4682198819716)*(-- &14442496))*s pow 1 = (&29913816357278)*((&7733248) * &0 + (&11943936) * -- &1 / &2) /\ ((&597985557763)*(&691929088)+(&4682198819716)*(&29925376))*s pow 1 = (&29913816357278)*((&7733248) * &1 + (&11943936) * &1 / &2) /\ (&597985557763)*(&457690221)+(&4682198819716)*(&20669487)+(&25154837217534606855) = (&29913816357278)*(&13225515)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &201808706245` in
let npos = REAL_ARITH `!s:real. &0:real < &48718139480` in
let ppos = REAL_ARITH `!s:real. &0:real < &294989463882239243` in
let qpos = REAL_ARITH `!s:real. &0:real < &2465536149976` in
let mqrel = REAL_ARITH `
  ((&201808706245)*(-- &15433728)+(&48718139480)*(-- &5660672))*(&30902639 / &41749730) pow 1 = (&2465536149976)*(((&897024) * &0 + (&2035712) * -- &1 / &2)) /\
  ((&201808706245)*(&29458432)+(&48718139480)*(&8896512))*(&30902639 / &41749730) pow 1 = (&2465536149976)*(((&897024) * &1 + (&2035712) * &1 / &2)) /\
  (&201808706245)*(&21015329)+(&48718139480)*(&6951751)+(&294989463882239243) = (&2465536149976)*(&1977153)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (&897024) * ((&0) * x + (&1) * y) / s pow 1 + (&2035712) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &1977153
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &201808706245` [mpos] THEN
  note `&0:real < &48718139480` [npos] THEN
  note `&0:real < &294989463882239243` [ppos] THEN
  note `&0:real < &2465536149976` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&201808706245)*(-- &15433728)+(&48718139480)*(-- &5660672))*s pow 1 = (&2465536149976)*((&897024) * &0 + (&2035712) * -- &1 / &2) /\ ((&201808706245)*(&29458432)+(&48718139480)*(&8896512))*s pow 1 = (&2465536149976)*((&897024) * &1 + (&2035712) * &1 / &2) /\ (&201808706245)*(&21015329)+(&48718139480)*(&6951751)+(&294989463882239243) = (&2465536149976)*(&1977153)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &5030842465` in
let npos = REAL_ARITH `!s:real. &0:real < &2605016153080` in
let ppos = REAL_ARITH `!s:real. &0:real < &1157629254166732615` in
let qpos = REAL_ARITH `!s:real. &0:real < &4931072299952` in
let mqrel = REAL_ARITH `
  ((&5030842465)*(-- &15433728)+(&2605016153080)*(-- &5660672))*(&30902639 / &41749730) pow 1 = (&4931072299952)*(((&1275904) * &0 + (&4450304) * -- &1 / &2)) /\
  ((&5030842465)*(&29458432)+(&2605016153080)*(&8896512))*(&30902639 / &41749730) pow 1 = (&4931072299952)*(((&1275904) * &1 + (&4450304) * &1 / &2)) /\
  (&5030842465)*(&21015329)+(&2605016153080)*(&6951751)+(&1157629254166732615) = (&4931072299952)*(&3928715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (&1275904) * ((&0) * x + (&1) * y) / s pow 1 + (&4450304) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3928715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5030842465` [mpos] THEN
  note `&0:real < &2605016153080` [npos] THEN
  note `&0:real < &1157629254166732615` [ppos] THEN
  note `&0:real < &4931072299952` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&5030842465)*(-- &15433728)+(&2605016153080)*(-- &5660672))*s pow 1 = (&4931072299952)*((&1275904) * &0 + (&4450304) * -- &1 / &2) /\ ((&5030842465)*(&29458432)+(&2605016153080)*(&8896512))*s pow 1 = (&4931072299952)*((&1275904) * &1 + (&4450304) * &1 / &2) /\ (&5030842465)*(&21015329)+(&2605016153080)*(&6951751)+(&1157629254166732615) = (&4931072299952)*(&3928715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &16436952200460` in
let npos = REAL_ARITH `!s:real. &0:real < &209583644600` in
let ppos = REAL_ARITH `!s:real. &0:real < &13111944343437400573` in
let qpos = REAL_ARITH `!s:real. &0:real < &26955228602057` in
let mqrel = REAL_ARITH `
  ((&16436952200460)*(-- &5660672)+(&209583644600)*(-- &373096448))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((&2211840) * &0 + (&9404416) * -- &1 / &2)) /\
  ((&16436952200460)*(&8896512)+(&209583644600)*(&503644160))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((&2211840) * &1 + (&9404416) * &1 / &2)) /\
  (&16436952200460)*(&6951751)+(&209583644600)*(&426281637)+(&13111944343437400573) = (&26955228602057)*(&8039969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (-- &373096448) * x + (&503644160) * y <= &426281637 ==>
  (&2211840) * ((&0) * x + (&1) * y) / s pow 1 + (&9404416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &8039969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16436952200460` [mpos] THEN
  note `&0:real < &209583644600` [npos] THEN
  note `&0:real < &13111944343437400573` [ppos] THEN
  note `&0:real < &26955228602057` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&16436952200460)*(-- &5660672)+(&209583644600)*(-- &373096448))*s pow 1 = (&26955228602057)*((&2211840) * &0 + (&9404416) * -- &1 / &2) /\ ((&16436952200460)*(&8896512)+(&209583644600)*(&503644160))*s pow 1 = (&26955228602057)*((&2211840) * &1 + (&9404416) * &1 / &2) /\ (&16436952200460)*(&6951751)+(&209583644600)*(&426281637)+(&13111944343437400573) = (&26955228602057)*(&8039969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &31094530908320` in
let npos = REAL_ARITH `!s:real. &0:real < &1386487658435` in
let ppos = REAL_ARITH `!s:real. &0:real < &53864502514584060544` in
let qpos = REAL_ARITH `!s:real. &0:real < &26955228602057` in
let mqrel = REAL_ARITH `
  ((&31094530908320)*(-- &5660672)+(&1386487658435)*(-- &373096448))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((&7733248) * &0 + (&38076416) * -- &1 / &2)) /\
  ((&31094530908320)*(&8896512)+(&1386487658435)*(&503644160))*(&30902639 / &41749730) pow 1 = (&26955228602057)*(((&7733248) * &1 + (&38076416) * &1 / &2)) /\
  (&31094530908320)*(&6951751)+(&1386487658435)*(&426281637)+(&53864502514584060544) = (&26955228602057)*(&31944087)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (-- &373096448) * x + (&503644160) * y <= &426281637 ==>
  (&7733248) * ((&0) * x + (&1) * y) / s pow 1 + (&38076416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &31944087
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &31094530908320` [mpos] THEN
  note `&0:real < &1386487658435` [npos] THEN
  note `&0:real < &53864502514584060544` [ppos] THEN
  note `&0:real < &26955228602057` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&31094530908320)*(-- &5660672)+(&1386487658435)*(-- &373096448))*s pow 1 = (&26955228602057)*((&7733248) * &0 + (&38076416) * -- &1 / &2) /\ ((&31094530908320)*(&8896512)+(&1386487658435)*(&503644160))*s pow 1 = (&26955228602057)*((&7733248) * &1 + (&38076416) * &1 / &2) /\ (&31094530908320)*(&6951751)+(&1386487658435)*(&426281637)+(&53864502514584060544) = (&26955228602057)*(&31944087)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &12865054050310` in
let npos = REAL_ARITH `!s:real. &0:real < &2171528706490` in
let ppos = REAL_ARITH `!s:real. &0:real < &47005321635144743621` in
let qpos = REAL_ARITH `!s:real. &0:real < &20756962687271` in
let mqrel = REAL_ARITH `
  ((&12865054050310)*(-- &46596096)+(&2171528706490)*(-- &84901888))*(&30902639 / &41749730) pow 1 = (&20756962687271)*(((&1966080) * &0 + (&55902208) * -- &1 / &2)) /\
  ((&12865054050310)*(&51871744)+(&2171528706490)*(&79036416))*(&30902639 / &41749730) pow 1 = (&20756962687271)*(((&1966080) * &1 + (&55902208) * &1 / &2)) /\
  (&12865054050310)*(&49963991)+(&2171528706490)*(&86789633)+(&47005321635144743621) = (&20756962687271)*(&42311631)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &46596096) * x + (&51871744) * y <= &49963991 ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (&1966080) * ((&0) * x + (&1) * y) / s pow 1 + (&55902208) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &42311631
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12865054050310` [mpos] THEN
  note `&0:real < &2171528706490` [npos] THEN
  note `&0:real < &47005321635144743621` [ppos] THEN
  note `&0:real < &20756962687271` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12865054050310)*(-- &46596096)+(&2171528706490)*(-- &84901888))*s pow 1 = (&20756962687271)*((&1966080) * &0 + (&55902208) * -- &1 / &2) /\ ((&12865054050310)*(&51871744)+(&2171528706490)*(&79036416))*s pow 1 = (&20756962687271)*((&1966080) * &1 + (&55902208) * &1 / &2) /\ (&12865054050310)*(&49963991)+(&2171528706490)*(&86789633)+(&47005321635144743621) = (&20756962687271)*(&42311631)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &26186996270875` in
let npos = REAL_ARITH `!s:real. &0:real < &10428852930485` in
let ppos = REAL_ARITH `!s:real. &0:real < &132413825103003430356` in
let qpos = REAL_ARITH `!s:real. &0:real < &34251125351484` in
let mqrel = REAL_ARITH `
  ((&26186996270875)*(-- &84901888)+(&10428852930485)*(-- &134447104))*(&30902639 / &41749730) pow 1 = (&34251125351484)*(((-- &11730944) * &0 + (&156696576) * -- &1 / &2)) /\
  ((&26186996270875)*(&79036416)+(&10428852930485)*(&97124352))*(&30902639 / &41749730) pow 1 = (&34251125351484)*(((-- &11730944) * &1 + (&156696576) * &1 / &2)) /\
  (&26186996270875)*(&86789633)+(&10428852930485)*(&131957561)+(&132413825103003430356) = (&34251125351484)*(&110400449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (-- &11730944) * ((&0) * x + (&1) * y) / s pow 1 + (&156696576) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &110400449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26186996270875` [mpos] THEN
  note `&0:real < &10428852930485` [npos] THEN
  note `&0:real < &132413825103003430356` [ppos] THEN
  note `&0:real < &34251125351484` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&26186996270875)*(-- &84901888)+(&10428852930485)*(-- &134447104))*s pow 1 = (&34251125351484)*((-- &11730944) * &0 + (&156696576) * -- &1 / &2) /\ ((&26186996270875)*(&79036416)+(&10428852930485)*(&97124352))*s pow 1 = (&34251125351484)*((-- &11730944) * &1 + (&156696576) * &1 / &2) /\ (&26186996270875)*(&86789633)+(&10428852930485)*(&131957561)+(&132413825103003430356) = (&34251125351484)*(&110400449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &12877161472010` in
let npos = REAL_ARITH `!s:real. &0:real < &16809589415575` in
let ppos = REAL_ARITH `!s:real. &0:real < &40083105071283583946` in
let qpos = REAL_ARITH `!s:real. &0:real < &43073550662233` in
let mqrel = REAL_ARITH `
  ((&12877161472010)*(-- &134447104)+(&16809589415575)*(-- &100401152))*(&30902639 / &41749730) pow 1 = (&43073550662233)*(((-- &22740992) * &0 + (&117506048) * -- &1 / &2)) /\
  ((&12877161472010)*(&97124352)+(&16809589415575)*(&50266112))*(&30902639 / &41749730) pow 1 = (&43073550662233)*(((-- &22740992) * &1 + (&117506048) * &1 / &2)) /\
  (&12877161472010)*(&131957561)+(&16809589415575)*(&95584823)+(&40083105071283583946) = (&43073550662233)*(&77682557)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (-- &22740992) * ((&0) * x + (&1) * y) / s pow 1 + (&117506048) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &77682557
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &12877161472010` [mpos] THEN
  note `&0:real < &16809589415575` [npos] THEN
  note `&0:real < &40083105071283583946` [ppos] THEN
  note `&0:real < &43073550662233` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&12877161472010)*(-- &134447104)+(&16809589415575)*(-- &100401152))*s pow 1 = (&43073550662233)*((-- &22740992) * &0 + (&117506048) * -- &1 / &2) /\ ((&12877161472010)*(&97124352)+(&16809589415575)*(&50266112))*s pow 1 = (&43073550662233)*((-- &22740992) * &1 + (&117506048) * &1 / &2) /\ (&12877161472010)*(&131957561)+(&16809589415575)*(&95584823)+(&40083105071283583946) = (&43073550662233)*(&77682557)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &687242305530` in
let npos = REAL_ARITH `!s:real. &0:real < &14339383140665` in
let ppos = REAL_ARITH `!s:real. &0:real < &83244168257276362` in
let qpos = REAL_ARITH `!s:real. &0:real < &3313350050941` in
let mqrel = REAL_ARITH `
  ((&687242305530)*(-- &134447104)+(&14339383140665)*(-- &100401152))*(&30902639 / &41749730) pow 1 = (&3313350050941)*(((-- &166330368) * &0 + (&684523520) * -- &1 / &2)) /\
  ((&687242305530)*(&97124352)+(&14339383140665)*(&50266112))*(&30902639 / &41749730) pow 1 = (&3313350050941)*(((-- &166330368) * &1 + (&684523520) * &1 / &2)) /\
  (&687242305530)*(&131957561)+(&14339383140665)*(&95584823)+(&83244168257276362) = (&3313350050941)*(&441063407)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (-- &166330368) * ((&0) * x + (&1) * y) / s pow 1 + (&684523520) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &441063407
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &687242305530` [mpos] THEN
  note `&0:real < &14339383140665` [npos] THEN
  note `&0:real < &83244168257276362` [ppos] THEN
  note `&0:real < &3313350050941` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&687242305530)*(-- &134447104)+(&14339383140665)*(-- &100401152))*s pow 1 = (&3313350050941)*((-- &166330368) * &0 + (&684523520) * -- &1 / &2) /\ ((&687242305530)*(&97124352)+(&14339383140665)*(&50266112))*s pow 1 = (&3313350050941)*((-- &166330368) * &1 + (&684523520) * &1 / &2) /\ (&687242305530)*(&131957561)+(&14339383140665)*(&95584823)+(&83244168257276362) = (&3313350050941)*(&441063407)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &6760575528630` in
let npos = REAL_ARITH `!s:real. &0:real < &22461354740` in
let ppos = REAL_ARITH `!s:real. &0:real < &34212597067729511` in
let qpos = REAL_ARITH `!s:real. &0:real < &7422906595717` in
let mqrel = REAL_ARITH `
  ((&6760575528630)*(-- &100401152)+(&22461354740)*(-- &64782336))*(&30902639 / &41749730) pow 1 = (&7422906595717)*(((-- &33882112) * &0 + (&135659520) * -- &1 / &2)) /\
  ((&6760575528630)*(&50266112)+(&22461354740)*(&27295744))*(&30902639 / &41749730) pow 1 = (&7422906595717)*(((-- &33882112) * &1 + (&135659520) * &1 / &2)) /\
  (&6760575528630)*(&95584823)+(&22461354740)*(&61112343)+(&34212597067729511) = (&7422906595717)*(&87245513)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (-- &64782336) * x + (&27295744) * y <= &61112343 ==>
  (-- &33882112) * ((&0) * x + (&1) * y) / s pow 1 + (&135659520) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &87245513
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6760575528630` [mpos] THEN
  note `&0:real < &22461354740` [npos] THEN
  note `&0:real < &34212597067729511` [ppos] THEN
  note `&0:real < &7422906595717` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6760575528630)*(-- &100401152)+(&22461354740)*(-- &64782336))*s pow 1 = (&7422906595717)*((-- &33882112) * &0 + (&135659520) * -- &1 / &2) /\ ((&6760575528630)*(&50266112)+(&22461354740)*(&27295744))*s pow 1 = (&7422906595717)*((-- &33882112) * &1 + (&135659520) * &1 / &2) /\ (&6760575528630)*(&95584823)+(&22461354740)*(&61112343)+(&34212597067729511) = (&7422906595717)*(&87245513)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &2271561059570` in
let npos = REAL_ARITH `!s:real. &0:real < &34151279140` in
let ppos = REAL_ARITH `!s:real. &0:real < &6705416892720365` in
let qpos = REAL_ARITH `!s:real. &0:real < &1248250297127` in
let mqrel = REAL_ARITH `
  ((&2271561059570)*(-- &64782336)+(&34151279140)*(-- &12943360))*(&30902639 / &41749730) pow 1 = (&1248250297127)*(((-- &50659328) * &0 + (&175046656) * -- &1 / &2)) /\
  ((&2271561059570)*(&27295744)+(&34151279140)*(&4784128))*(&30902639 / &41749730) pow 1 = (&1248250297127)*(((-- &50659328) * &1 + (&175046656) * &1 / &2)) /\
  (&2271561059570)*(&61112343)+(&34151279140)*(&12157023)+(&6705416892720365) = (&1248250297127)*(&111549985)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &64782336) * x + (&27295744) * y <= &61112343 ==>
  (-- &12943360) * x + (&4784128) * y <= &12157023 ==>
  (-- &50659328) * ((&0) * x + (&1) * y) / s pow 1 + (&175046656) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &111549985
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2271561059570` [mpos] THEN
  note `&0:real < &34151279140` [npos] THEN
  note `&0:real < &6705416892720365` [ppos] THEN
  note `&0:real < &1248250297127` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2271561059570)*(-- &64782336)+(&34151279140)*(-- &12943360))*s pow 1 = (&1248250297127)*((-- &50659328) * &0 + (&175046656) * -- &1 / &2) /\ ((&2271561059570)*(&27295744)+(&34151279140)*(&4784128))*s pow 1 = (&1248250297127)*((-- &50659328) * &1 + (&175046656) * &1 / &2) /\ (&2271561059570)*(&61112343)+(&34151279140)*(&12157023)+(&6705416892720365) = (&1248250297127)*(&111549985)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &3356260794700` in
let npos = REAL_ARITH `!s:real. &0:real < &62624595` in
let ppos = REAL_ARITH `!s:real. &0:real < &1968635820771560` in
let qpos = REAL_ARITH `!s:real. &0:real < &1843744150657` in
let mqrel = REAL_ARITH `
  ((&3356260794700)*(-- &12943360)+(&62624595)*(-- &1012072448))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((-- &11010048) * &0 + (&34930688) * -- &1 / &2)) /\
  ((&3356260794700)*(&4784128)+(&62624595)*(&364183552))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((-- &11010048) * &1 + (&34930688) * &1 / &2)) /\
  (&3356260794700)*(&12157023)+(&62624595)*(&949861697)+(&1968635820771560) = (&1843744150657)*(&22163375)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &12943360) * x + (&4784128) * y <= &12157023 ==>
  (-- &1012072448) * x + (&364183552) * y <= &949861697 ==>
  (-- &11010048) * ((&0) * x + (&1) * y) / s pow 1 + (&34930688) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &22163375
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3356260794700` [mpos] THEN
  note `&0:real < &62624595` [npos] THEN
  note `&0:real < &1968635820771560` [ppos] THEN
  note `&0:real < &1843744150657` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&3356260794700)*(-- &12943360)+(&62624595)*(-- &1012072448))*s pow 1 = (&1843744150657)*((-- &11010048) * &0 + (&34930688) * -- &1 / &2) /\ ((&3356260794700)*(&4784128)+(&62624595)*(&364183552))*s pow 1 = (&1843744150657)*((-- &11010048) * &1 + (&34930688) * &1 / &2) /\ (&3356260794700)*(&12157023)+(&62624595)*(&949861697)+(&1968635820771560) = (&1843744150657)*(&22163375)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &204323178620` in
let npos = REAL_ARITH `!s:real. &0:real < &558298264425` in
let ppos = REAL_ARITH `!s:real. &0:real < &25637943832392526` in
let qpos = REAL_ARITH `!s:real. &0:real < &1843744150657` in
let mqrel = REAL_ARITH `
  ((&204323178620)*(-- &12943360)+(&558298264425)*(-- &1012072448))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((-- &145883136) * &0 + (&455802880) * -- &1 / &2)) /\
  ((&204323178620)*(&4784128)+(&558298264425)*(&364183552))*(&30902639 / &41749730) pow 1 = (&1843744150657)*(((-- &145883136) * &1 + (&455802880) * &1 / &2)) /\
  (&204323178620)*(&12157023)+(&558298264425)*(&949861697)+(&25637943832392526) = (&1843744150657)*(&288985723)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &12943360) * x + (&4784128) * y <= &12157023 ==>
  (-- &1012072448) * x + (&364183552) * y <= &949861697 ==>
  (-- &145883136) * ((&0) * x + (&1) * y) / s pow 1 + (&455802880) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &288985723
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &204323178620` [mpos] THEN
  note `&0:real < &558298264425` [npos] THEN
  note `&0:real < &25637943832392526` [ppos] THEN
  note `&0:real < &1843744150657` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&204323178620)*(-- &12943360)+(&558298264425)*(-- &1012072448))*s pow 1 = (&1843744150657)*((-- &145883136) * &0 + (&455802880) * -- &1 / &2) /\ ((&204323178620)*(&4784128)+(&558298264425)*(&364183552))*s pow 1 = (&1843744150657)*((-- &145883136) * &1 + (&455802880) * &1 / &2) /\ (&204323178620)*(&12157023)+(&558298264425)*(&949861697)+(&25637943832392526) = (&1843744150657)*(&288985723)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &53978225917` in
let npos = REAL_ARITH `!s:real. &0:real < &8349946` in
let ppos = REAL_ARITH `!s:real. &0:real < &11073851540025` in
let qpos = REAL_ARITH `!s:real. &0:real < &29604728162` in
let mqrel = REAL_ARITH `
  ((&53978225917)*(-- &3866624)+(&8349946)*(-- &39124992))*(&30902639 / &41749730) pow 1 = (&29604728162)*(((-- &3457024) * &0 + (&10452992) * -- &1 / &2)) /\
  ((&53978225917)*(&1310720)+(&8349946)*(&2621440))*(&30902639 / &41749730) pow 1 = (&29604728162)*(((-- &3457024) * &1 + (&10452992) * &1 / &2)) /\
  (&53978225917)*(&3642043)+(&8349946)*(&38657149)+(&11073851540025) = (&29604728162)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &3457024) * ((&0) * x + (&1) * y) / s pow 1 + (&10452992) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &53978225917` [mpos] THEN
  note `&0:real < &8349946` [npos] THEN
  note `&0:real < &11073851540025` [ppos] THEN
  note `&0:real < &29604728162` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&53978225917)*(-- &3866624)+(&8349946)*(-- &39124992))*s pow 1 = (&29604728162)*((-- &3457024) * &0 + (&10452992) * -- &1 / &2) /\ ((&53978225917)*(&1310720)+(&8349946)*(&2621440))*s pow 1 = (&29604728162)*((-- &3457024) * &1 + (&10452992) * &1 / &2) /\ (&53978225917)*(&3642043)+(&8349946)*(&38657149)+(&11073851540025) = (&29604728162)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &2684060916889` in
let npos = REAL_ARITH `!s:real. &0:real < &66837142757` in
let ppos = REAL_ARITH `!s:real. &0:real < &695414648178580` in
let qpos = REAL_ARITH `!s:real. &0:real < &118418912648` in
let mqrel = REAL_ARITH `
  ((&2684060916889)*(-- &3866624)+(&66837142757)*(-- &39124992))*(&30902639 / &41749730) pow 1 = (&118418912648)*(((-- &58130432) * &0 + (&162430976) * -- &1 / &2)) /\
  ((&2684060916889)*(&1310720)+(&66837142757)*(&2621440))*(&30902639 / &41749730) pow 1 = (&118418912648)*(((-- &58130432) * &1 + (&162430976) * &1 / &2)) /\
  (&2684060916889)*(&3642043)+(&66837142757)*(&38657149)+(&695414648178580) = (&118418912648)*(&104374325)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &58130432) * ((&0) * x + (&1) * y) / s pow 1 + (&162430976) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &104374325
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2684060916889` [mpos] THEN
  note `&0:real < &66837142757` [npos] THEN
  note `&0:real < &695414648178580` [ppos] THEN
  note `&0:real < &118418912648` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2684060916889)*(-- &3866624)+(&66837142757)*(-- &39124992))*s pow 1 = (&118418912648)*((-- &58130432) * &0 + (&162430976) * -- &1 / &2) /\ ((&2684060916889)*(&1310720)+(&66837142757)*(&2621440))*s pow 1 = (&118418912648)*((-- &58130432) * &1 + (&162430976) * &1 / &2) /\ (&2684060916889)*(&3642043)+(&66837142757)*(&38657149)+(&695414648178580) = (&118418912648)*(&104374325)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &613516457323` in
let npos = REAL_ARITH `!s:real. &0:real < &116202023509` in
let ppos = REAL_ARITH `!s:real. &0:real < &48405031888405171` in
let qpos = REAL_ARITH `!s:real. &0:real < &14802364081` in
let mqrel = REAL_ARITH `
  ((&613516457323)*(-- &3866624)+(&116202023509)*(-- &39124992))*(&30902639 / &41749730) pow 1 = (&14802364081)*(((-- &290521088) * &0 + (&691929088) * -- &1 / &2)) /\
  ((&613516457323)*(&1310720)+(&116202023509)*(&2621440))*(&30902639 / &41749730) pow 1 = (&14802364081)*(((-- &290521088) * &1 + (&691929088) * &1 / &2)) /\
  (&613516457323)*(&3642043)+(&116202023509)*(&38657149)+(&48405031888405171) = (&14802364081)*(&457690221)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &290521088) * ((&0) * x + (&1) * y) / s pow 1 + (&691929088) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &457690221
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &613516457323` [mpos] THEN
  note `&0:real < &116202023509` [npos] THEN
  note `&0:real < &48405031888405171` [ppos] THEN
  note `&0:real < &14802364081` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&613516457323)*(-- &3866624)+(&116202023509)*(-- &39124992))*s pow 1 = (&14802364081)*((-- &290521088) * &0 + (&691929088) * -- &1 / &2) /\ ((&613516457323)*(&1310720)+(&116202023509)*(&2621440))*s pow 1 = (&14802364081)*((-- &290521088) * &1 + (&691929088) * &1 / &2) /\ (&613516457323)*(&3642043)+(&116202023509)*(&38657149)+(&48405031888405171) = (&14802364081)*(&457690221)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &1342984439775` in
let npos = REAL_ARITH `!s:real. &0:real < &1467523884365` in
let ppos = REAL_ARITH `!s:real. &0:real < &1754701327831109266` in
let qpos = REAL_ARITH `!s:real. &0:real < &3025121136988` in
let mqrel = REAL_ARITH `
  ((&1342984439775)*(-- &39124992)+(&1467523884365)*(-- &5865472))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((-- &14442496) * &0 + (&29925376) * -- &1 / &2)) /\
  ((&1342984439775)*(&2621440)+(&1467523884365)*(-- &950272))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((-- &14442496) * &1 + (&29925376) * &1 / &2)) /\
  (&1342984439775)*(&38657149)+(&1467523884365)*(&6035371)+(&1754701327831109266) = (&3025121136988)*(&20669487)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &14442496) * ((&0) * x + (&1) * y) / s pow 1 + (&29925376) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &20669487
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1342984439775` [mpos] THEN
  note `&0:real < &1467523884365` [npos] THEN
  note `&0:real < &1754701327831109266` [ppos] THEN
  note `&0:real < &3025121136988` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1342984439775)*(-- &39124992)+(&1467523884365)*(-- &5865472))*s pow 1 = (&3025121136988)*((-- &14442496) * &0 + (&29925376) * -- &1 / &2) /\ ((&1342984439775)*(&2621440)+(&1467523884365)*(-- &950272))*s pow 1 = (&3025121136988)*((-- &14442496) * &1 + (&29925376) * &1 / &2) /\ (&1342984439775)*(&38657149)+(&1467523884365)*(&6035371)+(&1754701327831109266) = (&3025121136988)*(&20669487)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &1258900483555` in
let npos = REAL_ARITH `!s:real. &0:real < &4688348554945` in
let ppos = REAL_ARITH `!s:real. &0:real < &2995341563006731538` in
let qpos = REAL_ARITH `!s:real. &0:real < &3025121136988` in
let mqrel = REAL_ARITH `
  ((&1258900483555)*(-- &39124992)+(&4688348554945)*(-- &5865472))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((-- &19062784) * &0 + (&37560320) * -- &1 / &2)) /\
  ((&1258900483555)*(&2621440)+(&4688348554945)*(-- &950272))*(&30902639 / &41749730) pow 1 = (&3025121136988)*(((-- &19062784) * &1 + (&37560320) * &1 / &2)) /\
  (&1258900483555)*(&38657149)+(&4688348554945)*(&6035371)+(&2995341563006731538) = (&3025121136988)*(&26430931)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &19062784) * ((&0) * x + (&1) * y) / s pow 1 + (&37560320) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &26430931
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1258900483555` [mpos] THEN
  note `&0:real < &4688348554945` [npos] THEN
  note `&0:real < &2995341563006731538` [ppos] THEN
  note `&0:real < &3025121136988` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1258900483555)*(-- &39124992)+(&4688348554945)*(-- &5865472))*s pow 1 = (&3025121136988)*((-- &19062784) * &0 + (&37560320) * -- &1 / &2) /\ ((&1258900483555)*(&2621440)+(&4688348554945)*(-- &950272))*s pow 1 = (&3025121136988)*((-- &19062784) * &1 + (&37560320) * &1 / &2) /\ (&1258900483555)*(&38657149)+(&4688348554945)*(&6035371)+(&2995341563006731538) = (&3025121136988)*(&26430931)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &191777384755` in
let npos = REAL_ARITH `!s:real. &0:real < &1286538804815` in
let ppos = REAL_ARITH `!s:real. &0:real < &715173059404747403` in
let qpos = REAL_ARITH `!s:real. &0:real < &756280284247` in
let mqrel = REAL_ARITH `
  ((&191777384755)*(-- &39124992)+(&1286538804815)*(-- &5865472))*(&30902639 / &41749730) pow 1 = (&756280284247)*(((-- &15433728) * &0 + (&29458432) * -- &1 / &2)) /\
  ((&191777384755)*(&2621440)+(&1286538804815)*(-- &950272))*(&30902639 / &41749730) pow 1 = (&756280284247)*(((-- &15433728) * &1 + (&29458432) * &1 / &2)) /\
  (&191777384755)*(&38657149)+(&1286538804815)*(&6035371)+(&715173059404747403) = (&756280284247)*(&21015329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &15433728) * ((&0) * x + (&1) * y) / s pow 1 + (&29458432) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &21015329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &191777384755` [mpos] THEN
  note `&0:real < &1286538804815` [npos] THEN
  note `&0:real < &715173059404747403` [ppos] THEN
  note `&0:real < &756280284247` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&191777384755)*(-- &39124992)+(&1286538804815)*(-- &5865472))*s pow 1 = (&756280284247)*((-- &15433728) * &0 + (&29458432) * -- &1 / &2) /\ ((&191777384755)*(&2621440)+(&1286538804815)*(-- &950272))*s pow 1 = (&756280284247)*((-- &15433728) * &1 + (&29458432) * &1 / &2) /\ (&191777384755)*(&38657149)+(&1286538804815)*(&6035371)+(&715173059404747403) = (&756280284247)*(&21015329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &22876910677555` in
let npos = REAL_ARITH `!s:real. &0:real < &224300424425` in
let ppos = REAL_ARITH `!s:real. &0:real < &23389983927957967288` in
let qpos = REAL_ARITH `!s:real. &0:real < &38727558026468` in
let mqrel = REAL_ARITH `
  ((&22876910677555)*(-- &5865472)+(&224300424425)*(-- &439386112))*(&30902639 / &41749730) pow 1 = (&38727558026468)*(((-- &5660672) * &0 + (&8896512) * -- &1 / &2)) /\
  ((&22876910677555)*(-- &950272)+(&224300424425)*(-- &185892864))*(&30902639 / &41749730) pow 1 = (&38727558026468)*(((-- &5660672) * &1 + (&8896512) * &1 / &2)) /\
  (&22876910677555)*(&6035371)+(&224300424425)*(&480443643)+(&23389983927957967288) = (&38727558026468)*(&6951751)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &5660672) * ((&0) * x + (&1) * y) / s pow 1 + (&8896512) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6951751
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22876910677555` [mpos] THEN
  note `&0:real < &224300424425` [npos] THEN
  note `&0:real < &23389983927957967288` [ppos] THEN
  note `&0:real < &38727558026468` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&22876910677555)*(-- &5865472)+(&224300424425)*(-- &439386112))*s pow 1 = (&38727558026468)*((-- &5660672) * &0 + (&8896512) * -- &1 / &2) /\ ((&22876910677555)*(-- &950272)+(&224300424425)*(-- &185892864))*s pow 1 = (&38727558026468)*((-- &5660672) * &1 + (&8896512) * &1 / &2) /\ (&22876910677555)*(&6035371)+(&224300424425)*(&480443643)+(&23389983927957967288) = (&38727558026468)*(&6951751)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &1355579574230` in
let npos = REAL_ARITH `!s:real. &0:real < &11442659726360` in
let ppos = REAL_ARITH `!s:real. &0:real < &155052554158734747363` in
let qpos = REAL_ARITH `!s:real. &0:real < &3423734277449` in
let mqrel = REAL_ARITH `
  ((&1355579574230)*(-- &439386112)+(&11442659726360)*(-- &49741824))*(&30902639 / &41749730) pow 1 = (&3423734277449)*(((-- &373096448) * &0 + (&503644160) * -- &1 / &2)) /\
  ((&1355579574230)*(-- &185892864)+(&11442659726360)*(-- &27000832))*(&30902639 / &41749730) pow 1 = (&3423734277449)*(((-- &373096448) * &1 + (&503644160) * &1 / &2)) /\
  (&1355579574230)*(&480443643)+(&11442659726360)*(&57079641)+(&155052554158734747363) = (&3423734277449)*(&426281637)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &373096448) * ((&0) * x + (&1) * y) / s pow 1 + (&503644160) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &426281637
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1355579574230` [mpos] THEN
  note `&0:real < &11442659726360` [npos] THEN
  note `&0:real < &155052554158734747363` [ppos] THEN
  note `&0:real < &3423734277449` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1355579574230)*(-- &439386112)+(&11442659726360)*(-- &49741824))*s pow 1 = (&3423734277449)*((-- &373096448) * &0 + (&503644160) * -- &1 / &2) /\ ((&1355579574230)*(-- &185892864)+(&11442659726360)*(-- &27000832))*s pow 1 = (&3423734277449)*((-- &373096448) * &1 + (&503644160) * &1 / &2) /\ (&1355579574230)*(&480443643)+(&11442659726360)*(&57079641)+(&155052554158734747363) = (&3423734277449)*(&426281637)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &91902542020` in
let npos = REAL_ARITH `!s:real. &0:real < &6938046040` in
let ppos = REAL_ARITH `!s:real. &0:real < &671909032582929435` in
let qpos = REAL_ARITH `!s:real. &0:real < &968890440567` in
let mqrel = REAL_ARITH `
  ((&91902542020)*(-- &49741824)+(&6938046040)*(-- &33521664))*(&30902639 / &41749730) pow 1 = (&968890440567)*(((-- &5701632) * &0 + (&7340032) * -- &1 / &2)) /\
  ((&91902542020)*(-- &27000832)+(&6938046040)*(-- &25640960))*(&30902639 / &41749730) pow 1 = (&968890440567)*(((-- &5701632) * &1 + (&7340032) * &1 / &2)) /\
  (&91902542020)*(&57079641)+(&6938046040)*(&41914863)+(&671909032582929435) = (&968890440567)*(&6407825)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &5701632) * ((&0) * x + (&1) * y) / s pow 1 + (&7340032) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &6407825
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &91902542020` [mpos] THEN
  note `&0:real < &6938046040` [npos] THEN
  note `&0:real < &671909032582929435` [ppos] THEN
  note `&0:real < &968890440567` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&91902542020)*(-- &49741824)+(&6938046040)*(-- &33521664))*s pow 1 = (&968890440567)*((-- &5701632) * &0 + (&7340032) * -- &1 / &2) /\ ((&91902542020)*(-- &27000832)+(&6938046040)*(-- &25640960))*s pow 1 = (&968890440567)*((-- &5701632) * &1 + (&7340032) * &1 / &2) /\ (&91902542020)*(&57079641)+(&6938046040)*(&41914863)+(&671909032582929435) = (&968890440567)*(&6407825)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &6241584635` in
let npos = REAL_ARITH `!s:real. &0:real < &2141990772515` in
let ppos = REAL_ARITH `!s:real. &0:real < &668952384970479192` in
let qpos = REAL_ARITH `!s:real. &0:real < &120149460432` in
let mqrel = REAL_ARITH `
  ((&6241584635)*(-- &33521664)+(&2141990772515)*(-- &1867776))*(&30902639 / &41749730) pow 1 = (&120149460432)*(((-- &46596096) * &0 + (&51871744) * -- &1 / &2)) /\
  ((&6241584635)*(-- &25640960)+(&2141990772515)*(-- &1490944))*(&30902639 / &41749730) pow 1 = (&120149460432)*(((-- &46596096) * &1 + (&51871744) * &1 / &2)) /\
  (&6241584635)*(&41914863)+(&2141990772515)*(&2368161)+(&668952384970479192) = (&120149460432)*(&49963991)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &1867776) * x + (-- &1490944) * y <= &2368161 ==>
  (-- &46596096) * ((&0) * x + (&1) * y) / s pow 1 + (&51871744) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &49963991
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6241584635` [mpos] THEN
  note `&0:real < &2141990772515` [npos] THEN
  note `&0:real < &668952384970479192` [ppos] THEN
  note `&0:real < &120149460432` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6241584635)*(-- &33521664)+(&2141990772515)*(-- &1867776))*s pow 1 = (&120149460432)*((-- &46596096) * &0 + (&51871744) * -- &1 / &2) /\ ((&6241584635)*(-- &25640960)+(&2141990772515)*(-- &1490944))*s pow 1 = (&120149460432)*((-- &46596096) * &1 + (&51871744) * &1 / &2) /\ (&6241584635)*(&41914863)+(&2141990772515)*(&2368161)+(&668952384970479192) = (&120149460432)*(&49963991)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &2736505030` in
let npos = REAL_ARITH `!s:real. &0:real < &66560455910` in
let ppos = REAL_ARITH `!s:real. &0:real < &14102199351063297` in
let qpos = REAL_ARITH `!s:real. &0:real < &1576034589` in
let mqrel = REAL_ARITH `
  ((&2736505030)*(-- &7634944)+(&66560455910)*(-- &950272))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((-- &84901888) * &0 + (&79036416) * -- &1 / &2)) /\
  ((&2736505030)*(-- &7815168)+(&66560455910)*(-- &1130496))*(&30902639 / &41749730) pow 1 = (&1576034589)*(((-- &84901888) * &1 + (&79036416) * &1 / &2)) /\
  (&2736505030)*(&10605687)+(&66560455910)*(&1407123)+(&14102199351063297) = (&1576034589)*(&86789633)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &950272) * x + (-- &1130496) * y <= &1407123 ==>
  (-- &84901888) * ((&0) * x + (&1) * y) / s pow 1 + (&79036416) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &86789633
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2736505030` [mpos] THEN
  note `&0:real < &66560455910` [npos] THEN
  note `&0:real < &14102199351063297` [ppos] THEN
  note `&0:real < &1576034589` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&2736505030)*(-- &7634944)+(&66560455910)*(-- &950272))*s pow 1 = (&1576034589)*((-- &84901888) * &0 + (&79036416) * -- &1 / &2) /\ ((&2736505030)*(-- &7815168)+(&66560455910)*(-- &1130496))*s pow 1 = (&1576034589)*((-- &84901888) * &1 + (&79036416) * &1 / &2) /\ (&2736505030)*(&10605687)+(&66560455910)*(&1407123)+(&14102199351063297) = (&1576034589)*(&86789633)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &13573254720300` in
let npos = REAL_ARITH `!s:real. &0:real < &52348817454560` in
let ppos = REAL_ARITH `!s:real. &0:real < &22549644868526269727` in
let qpos = REAL_ARITH `!s:real. &0:real < &2315627448187` in
let mqrel = REAL_ARITH `
  ((&13573254720300)*(-- &7733248)+(&52348817454560)*(-- &897024))*(&30902639 / &41749730) pow 1 = (&2315627448187)*(((-- &134447104) * &0 + (&97124352) * -- &1 / &2)) /\
  ((&13573254720300)*(-- &11943936)+(&52348817454560)*(-- &2035712))*(&30902639 / &41749730) pow 1 = (&2315627448187)*(((-- &134447104) * &1 + (&97124352) * &1 / &2)) /\
  (&13573254720300)*(&13225515)+(&52348817454560)*(&1977153)+(&22549644868526269727) = (&2315627448187)*(&131957561)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &11943936) * y <= &13225515 ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &134447104) * ((&0) * x + (&1) * y) / s pow 1 + (&97124352) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &131957561
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &13573254720300` [mpos] THEN
  note `&0:real < &52348817454560` [npos] THEN
  note `&0:real < &22549644868526269727` [ppos] THEN
  note `&0:real < &2315627448187` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&13573254720300)*(-- &7733248)+(&52348817454560)*(-- &897024))*s pow 1 = (&2315627448187)*((-- &134447104) * &0 + (&97124352) * -- &1 / &2) /\ ((&13573254720300)*(-- &11943936)+(&52348817454560)*(-- &2035712))*s pow 1 = (&2315627448187)*((-- &134447104) * &1 + (&97124352) * &1 / &2) /\ (&13573254720300)*(&13225515)+(&52348817454560)*(&1977153)+(&22549644868526269727) = (&2315627448187)*(&131957561)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &4919370685900` in
let npos = REAL_ARITH `!s:real. &0:real < &5086954102120` in
let ppos = REAL_ARITH `!s:real. &0:real < &981636297537079227` in
let qpos = REAL_ARITH `!s:real. &0:real < &321109321849` in
let mqrel = REAL_ARITH `
  ((&4919370685900)*(-- &897024)+(&5086954102120)*(-- &1275904))*(&30902639 / &41749730) pow 1 = (&321109321849)*(((-- &100401152) * &0 + (&50266112) * -- &1 / &2)) /\
  ((&4919370685900)*(-- &2035712)+(&5086954102120)*(-- &4450304))*(&30902639 / &41749730) pow 1 = (&321109321849)*(((-- &100401152) * &1 + (&50266112) * &1 / &2)) /\
  (&4919370685900)*(&1977153)+(&5086954102120)*(&3928715)+(&981636297537079227) = (&321109321849)*(&95584823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &100401152) * ((&0) * x + (&1) * y) / s pow 1 + (&50266112) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &95584823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4919370685900` [mpos] THEN
  note `&0:real < &5086954102120` [npos] THEN
  note `&0:real < &981636297537079227` [ppos] THEN
  note `&0:real < &321109321849` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4919370685900)*(-- &897024)+(&5086954102120)*(-- &1275904))*s pow 1 = (&321109321849)*((-- &100401152) * &0 + (&50266112) * -- &1 / &2) /\ ((&4919370685900)*(-- &2035712)+(&5086954102120)*(-- &4450304))*s pow 1 = (&321109321849)*((-- &100401152) * &1 + (&50266112) * &1 / &2) /\ (&4919370685900)*(&1977153)+(&5086954102120)*(&3928715)+(&981636297537079227) = (&321109321849)*(&95584823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &18973415296880` in
let npos = REAL_ARITH `!s:real. &0:real < &5605903246020` in
let ppos = REAL_ARITH `!s:real. &0:real < &1720129124522020139` in
let qpos = REAL_ARITH `!s:real. &0:real < &1985401847833` in
let mqrel = REAL_ARITH `
  ((&18973415296880)*(-- &1275904)+(&5605903246020)*(-- &2211840))*(&30902639 / &41749730) pow 1 = (&1985401847833)*(((-- &64782336) * &0 + (&27295744) * -- &1 / &2)) /\
  ((&18973415296880)*(-- &4450304)+(&5605903246020)*(-- &9404416))*(&30902639 / &41749730) pow 1 = (&1985401847833)*(((-- &64782336) * &1 + (&27295744) * &1 / &2)) /\
  (&18973415296880)*(&3928715)+(&5605903246020)*(&8039969)+(&1720129124522020139) = (&1985401847833)*(&61112343)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &64782336) * ((&0) * x + (&1) * y) / s pow 1 + (&27295744) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &61112343
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &18973415296880` [mpos] THEN
  note `&0:real < &5605903246020` [npos] THEN
  note `&0:real < &1720129124522020139` [ppos] THEN
  note `&0:real < &1985401847833` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&18973415296880)*(-- &1275904)+(&5605903246020)*(-- &2211840))*s pow 1 = (&1985401847833)*((-- &64782336) * &0 + (&27295744) * -- &1 / &2) /\ ((&18973415296880)*(-- &4450304)+(&5605903246020)*(-- &9404416))*s pow 1 = (&1985401847833)*((-- &64782336) * &1 + (&27295744) * &1 / &2) /\ (&18973415296880)*(&3928715)+(&5605903246020)*(&8039969)+(&1720129124522020139) = (&1985401847833)*(&61112343)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &4789832660` in
let npos = REAL_ARITH `!s:real. &0:real < &425088160` in
let ppos = REAL_ARITH `!s:real. &0:real < &130929671336423` in
let qpos = REAL_ARITH `!s:real. &0:real < &4295466821` in
let mqrel = REAL_ARITH `
  ((&4789832660)*(-- &2211840)+(&425088160)*(-- &7733248))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((-- &12943360) * &0 + (&4784128) * -- &1 / &2)) /\
  ((&4789832660)*(-- &9404416)+(&425088160)*(-- &38076416))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((-- &12943360) * &1 + (&4784128) * &1 / &2)) /\
  (&4789832660)*(&8039969)+(&425088160)*(&31944087)+(&130929671336423) = (&4295466821)*(&12157023)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &12943360) * ((&0) * x + (&1) * y) / s pow 1 + (&4784128) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &12157023
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4789832660` [mpos] THEN
  note `&0:real < &425088160` [npos] THEN
  note `&0:real < &130929671336423` [ppos] THEN
  note `&0:real < &4295466821` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&4789832660)*(-- &2211840)+(&425088160)*(-- &7733248))*s pow 1 = (&4295466821)*((-- &12943360) * &0 + (&4784128) * -- &1 / &2) /\ ((&4789832660)*(-- &9404416)+(&425088160)*(-- &38076416))*s pow 1 = (&4295466821)*((-- &12943360) * &1 + (&4784128) * &1 / &2) /\ (&4789832660)*(&8039969)+(&425088160)*(&31944087)+(&130929671336423) = (&4295466821)*(&12157023)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &1820250273700` in
let npos = REAL_ARITH `!s:real. &0:real < &435899442355` in
let ppos = REAL_ARITH `!s:real. &0:real < &1530345386666474` in
let qpos = REAL_ARITH `!s:real. &0:real < &30068267747` in
let mqrel = REAL_ARITH `
  ((&1820250273700)*(-- &2211840)+(&435899442355)*(-- &7733248))*(&30902639 / &41749730) pow 1 = (&30068267747)*(((-- &1012072448) * &0 + (&364183552) * -- &1 / &2)) /\
  ((&1820250273700)*(-- &9404416)+(&435899442355)*(-- &38076416))*(&30902639 / &41749730) pow 1 = (&30068267747)*(((-- &1012072448) * &1 + (&364183552) * &1 / &2)) /\
  (&1820250273700)*(&8039969)+(&435899442355)*(&31944087)+(&1530345386666474) = (&30068267747)*(&949861697)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &1012072448) * ((&0) * x + (&1) * y) / s pow 1 + (&364183552) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &949861697
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1820250273700` [mpos] THEN
  note `&0:real < &435899442355` [npos] THEN
  note `&0:real < &1530345386666474` [ppos] THEN
  note `&0:real < &30068267747` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&1820250273700)*(-- &2211840)+(&435899442355)*(-- &7733248))*s pow 1 = (&30068267747)*((-- &1012072448) * &0 + (&364183552) * -- &1 / &2) /\ ((&1820250273700)*(-- &9404416)+(&435899442355)*(-- &38076416))*s pow 1 = (&30068267747)*((-- &1012072448) * &1 + (&364183552) * &1 / &2) /\ (&1820250273700)*(&8039969)+(&435899442355)*(&31944087)+(&1530345386666474) = (&30068267747)*(&949861697)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &60726880` in
let npos = REAL_ARITH `!s:real. &0:real < &474428750` in
let ppos = REAL_ARITH `!s:real. &0:real < &839369187333` in
let qpos = REAL_ARITH `!s:real. &0:real < &4295466821` in
let mqrel = REAL_ARITH `
  ((&60726880)*(-- &2211840)+(&474428750)*(-- &7733248))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((-- &3866624) * &0 + (&1310720) * -- &1 / &2)) /\
  ((&60726880)*(-- &9404416)+(&474428750)*(-- &38076416))*(&30902639 / &41749730) pow 1 = (&4295466821)*(((-- &3866624) * &1 + (&1310720) * &1 / &2)) /\
  (&60726880)*(&8039969)+(&474428750)*(&31944087)+(&839369187333) = (&4295466821)*(&3642043)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &3866624) * ((&0) * x + (&1) * y) / s pow 1 + (&1310720) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &3642043
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &60726880` [mpos] THEN
  note `&0:real < &474428750` [npos] THEN
  note `&0:real < &839369187333` [ppos] THEN
  note `&0:real < &4295466821` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&60726880)*(-- &2211840)+(&474428750)*(-- &7733248))*s pow 1 = (&4295466821)*((-- &3866624) * &0 + (&1310720) * -- &1 / &2) /\ ((&60726880)*(-- &9404416)+(&474428750)*(-- &38076416))*s pow 1 = (&4295466821)*((-- &3866624) * &1 + (&1310720) * &1 / &2) /\ (&60726880)*(&8039969)+(&474428750)*(&31944087)+(&839369187333) = (&4295466821)*(&3642043)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &6308509452190` in
let npos = REAL_ARITH `!s:real. &0:real < &10437432500` in
let ppos = REAL_ARITH `!s:real. &0:real < &14704318120509597` in
let qpos = REAL_ARITH `!s:real. &0:real < &6935077536463` in
let mqrel = REAL_ARITH `
  ((&6308509452190)*(-- &1966080)+(&10437432500)*(&11730944))*(&30902639 / &41749730) pow 1 = (&6935077536463)*(((-- &39124992) * &0 + (&2621440) * -- &1 / &2)) /\
  ((&6308509452190)*(-- &55902208)+(&10437432500)*(-- &156696576))*(&30902639 / &41749730) pow 1 = (&6935077536463)*(((-- &39124992) * &1 + (&2621440) * &1 / &2)) /\
  (&6308509452190)*(&42311631)+(&10437432500)*(&110400449)+(&14704318120509597) = (&6935077536463)*(&38657149)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1966080) * x + (-- &55902208) * y <= &42311631 ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (-- &39124992) * ((&0) * x + (&1) * y) / s pow 1 + (&2621440) * ((-- &1 / &2) * x + (&1 / &2) * y) / s pow 1 <= &38657149
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6308509452190` [mpos] THEN
  note `&0:real < &10437432500` [npos] THEN
  note `&0:real < &14704318120509597` [ppos] THEN
  note `&0:real < &6935077536463` [qpos] THEN
  note `&0:real < s pow 1` [REAL_POW_LT] THEN
  note `((&6308509452190)*(-- &1966080)+(&10437432500)*(&11730944))*s pow 1 = (&6935077536463)*((-- &39124992) * &0 + (&2621440) * -- &1 / &2) /\ ((&6308509452190)*(-- &55902208)+(&10437432500)*(-- &156696576))*s pow 1 = (&6935077536463)*((-- &39124992) * &1 + (&2621440) * &1 / &2) /\ (&6308509452190)*(&42311631)+(&10437432500)*(&110400449)+(&14704318120509597) = (&6935077536463)*(&38657149)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_H1 x y ==>
  divsteps_H1 (((&0) * x + (&1) * y) / divsteps_s pow 1) (((-- &1 / &2) * x + (&1 / &2) * y) / divsteps_s pow 1)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_H1] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H1] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

(* skipping Gc for approx *)

let theorem5 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &242564839075857156155` in
let npos = REAL_ARITH `!s:real. &0:real < &344860455111173265` in
let ppos = REAL_ARITH `!s:real. &0:real < &2437979017596068594797746` in
let qpos = REAL_ARITH `!s:real. &0:real < &97164692744081004466` in
let mqrel = REAL_ARITH `
  ((&242564839075857156155)*(&11730944)+(&344860455111173265)*(&22740992))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((-- &413007872) * &0 + (-- &32178176) * -- &1 / &2)) /\
  ((&242564839075857156155)*(-- &156696576)+(&344860455111173265)*(-- &117506048))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((-- &413007872) * &1 / &2 + (-- &32178176) * &1 / &4)) /\
  (&242564839075857156155)*(&110400449)+(&344860455111173265)*(&77682557)+(&2437979017596068594797746) = (&97164692744081004466)*(&275907781)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &413007872) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &32178176) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &275907781
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &242564839075857156155` [mpos] THEN
  note `&0:real < &344860455111173265` [npos] THEN
  note `&0:real < &2437979017596068594797746` [ppos] THEN
  note `&0:real < &97164692744081004466` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&242564839075857156155)*(&11730944)+(&344860455111173265)*(&22740992))*s pow 2 = (&97164692744081004466)*((-- &413007872) * &0 + (-- &32178176) * -- &1 / &2) /\ ((&242564839075857156155)*(-- &156696576)+(&344860455111173265)*(-- &117506048))*s pow 2 = (&97164692744081004466)*((-- &413007872) * &1 / &2 + (-- &32178176) * &1 / &4) /\ (&242564839075857156155)*(&110400449)+(&344860455111173265)*(&77682557)+(&2437979017596068594797746) = (&97164692744081004466)*(&275907781)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &178400139401711315` in
let npos = REAL_ARITH `!s:real. &0:real < &26740063102771112545` in
let ppos = REAL_ARITH `!s:real. &0:real < &189275354806787656639026` in
let qpos = REAL_ARITH `!s:real. &0:real < &97164692744081004466` in
let mqrel = REAL_ARITH `
  ((&178400139401711315)*(&11730944)+(&26740063102771112545)*(&22740992))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((-- &32309248) * &0 + (-- &6881280) * -- &1 / &2)) /\
  ((&178400139401711315)*(-- &156696576)+(&26740063102771112545)*(-- &117506048))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((-- &32309248) * &1 / &2 + (-- &6881280) * &1 / &4)) /\
  (&178400139401711315)*(&110400449)+(&26740063102771112545)*(&77682557)+(&189275354806787656639026) = (&97164692744081004466)*(&21583161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &32309248) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &6881280) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &21583161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &178400139401711315` [mpos] THEN
  note `&0:real < &26740063102771112545` [npos] THEN
  note `&0:real < &189275354806787656639026` [ppos] THEN
  note `&0:real < &97164692744081004466` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&178400139401711315)*(&11730944)+(&26740063102771112545)*(&22740992))*s pow 2 = (&97164692744081004466)*((-- &32309248) * &0 + (-- &6881280) * -- &1 / &2) /\ ((&178400139401711315)*(-- &156696576)+(&26740063102771112545)*(-- &117506048))*s pow 2 = (&97164692744081004466)*((-- &32309248) * &1 / &2 + (-- &6881280) * &1 / &4) /\ (&178400139401711315)*(&110400449)+(&26740063102771112545)*(&77682557)+(&189275354806787656639026) = (&97164692744081004466)*(&21583161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &23027736606456850125` in
let npos = REAL_ARITH `!s:real. &0:real < &1321224285945258200` in
let ppos = REAL_ARITH `!s:real. &0:real < &1187394392250784558472905` in
let qpos = REAL_ARITH `!s:real. &0:real < &111850269032273932804` in
let mqrel = REAL_ARITH `
  ((&23027736606456850125)*(&166330368)+(&1321224285945258200)*(&33882112))*(&30902639 / &41749730) pow 2 = (&111850269032273932804)*(((-- &137199616) * &0 + (-- &37961728) * -- &1 / &2)) /\
  ((&23027736606456850125)*(-- &684523520)+(&1321224285945258200)*(-- &135659520))*(&30902639 / &41749730) pow 2 = (&111850269032273932804)*(((-- &137199616) * &1 / &2 + (-- &37961728) * &1 / &4)) /\
  (&23027736606456850125)*(&441063407)+(&1321224285945258200)*(&87245513)+(&1187394392250784558472905) = (&111850269032273932804)*(&91847345)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (-- &137199616) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &37961728) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &91847345
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &23027736606456850125` [mpos] THEN
  note `&0:real < &1321224285945258200` [npos] THEN
  note `&0:real < &1187394392250784558472905` [ppos] THEN
  note `&0:real < &111850269032273932804` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&23027736606456850125)*(&166330368)+(&1321224285945258200)*(&33882112))*s pow 2 = (&111850269032273932804)*((-- &137199616) * &0 + (-- &37961728) * -- &1 / &2) /\ ((&23027736606456850125)*(-- &684523520)+(&1321224285945258200)*(-- &135659520))*s pow 2 = (&111850269032273932804)*((-- &137199616) * &1 / &2 + (-- &37961728) * &1 / &4) /\ (&23027736606456850125)*(&441063407)+(&1321224285945258200)*(&87245513)+(&1187394392250784558472905) = (&111850269032273932804)*(&91847345)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &3921839898914025` in
let npos = REAL_ARITH `!s:real. &0:real < &5805194570370293450` in
let ppos = REAL_ARITH `!s:real. &0:real < &58699914239797360667620` in
let qpos = REAL_ARITH `!s:real. &0:real < &27962567258068483201` in
let mqrel = REAL_ARITH `
  ((&3921839898914025)*(&166330368)+(&5805194570370293450)*(&33882112))*(&30902639 / &41749730) pow 2 = (&27962567258068483201)*(((-- &27099136) * &0 + (-- &7733248) * -- &1 / &2)) /\
  ((&3921839898914025)*(-- &684523520)+(&5805194570370293450)*(-- &135659520))*(&30902639 / &41749730) pow 2 = (&27962567258068483201)*(((-- &27099136) * &1 / &2 + (-- &7733248) * &1 / &4)) /\
  (&3921839898914025)*(&441063407)+(&5805194570370293450)*(&87245513)+(&58699914239797360667620) = (&27962567258068483201)*(&18176645)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (-- &27099136) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &7733248) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18176645
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3921839898914025` [mpos] THEN
  note `&0:real < &5805194570370293450` [npos] THEN
  note `&0:real < &58699914239797360667620` [ppos] THEN
  note `&0:real < &27962567258068483201` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&3921839898914025)*(&166330368)+(&5805194570370293450)*(&33882112))*s pow 2 = (&27962567258068483201)*((-- &27099136) * &0 + (-- &7733248) * -- &1 / &2) /\ ((&3921839898914025)*(-- &684523520)+(&5805194570370293450)*(-- &135659520))*s pow 2 = (&27962567258068483201)*((-- &27099136) * &1 / &2 + (-- &7733248) * &1 / &4) /\ (&3921839898914025)*(&441063407)+(&5805194570370293450)*(&87245513)+(&58699914239797360667620) = (&27962567258068483201)*(&18176645)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &14504706986139137350` in
let npos = REAL_ARITH `!s:real. &0:real < &501995507060995200` in
let ppos = REAL_ARITH `!s:real. &0:real < &171840569480246066947653` in
let qpos = REAL_ARITH `!s:real. &0:real < &35065657154776702799` in
let mqrel = REAL_ARITH `
  ((&14504706986139137350)*(&50659328)+(&501995507060995200)*(&11010048))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((-- &68321280) * &0 + (-- &23134208) * -- &1 / &2)) /\
  ((&14504706986139137350)*(-- &175046656)+(&501995507060995200)*(-- &34930688))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((-- &68321280) * &1 / &2 + (-- &23134208) * &1 / &4)) /\
  (&14504706986139137350)*(&111549985)+(&501995507060995200)*(&22163375)+(&171840569480246066947653) = (&35065657154776702799)*(&46464197)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &68321280) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &23134208) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &46464197
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &14504706986139137350` [mpos] THEN
  note `&0:real < &501995507060995200` [npos] THEN
  note `&0:real < &171840569480246066947653` [ppos] THEN
  note `&0:real < &35065657154776702799` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&14504706986139137350)*(&50659328)+(&501995507060995200)*(&11010048))*s pow 2 = (&35065657154776702799)*((-- &68321280) * &0 + (-- &23134208) * -- &1 / &2) /\ ((&14504706986139137350)*(-- &175046656)+(&501995507060995200)*(-- &34930688))*s pow 2 = (&35065657154776702799)*((-- &68321280) * &1 / &2 + (-- &23134208) * &1 / &4) /\ (&14504706986139137350)*(&111549985)+(&501995507060995200)*(&22163375)+(&171840569480246066947653) = (&35065657154776702799)*(&46464197)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &159488155889170350` in
let npos = REAL_ARITH `!s:real. &0:real < &28410243987721965325` in
let ppos = REAL_ARITH `!s:real. &0:real < &68384306930227553616868` in
let qpos = REAL_ARITH `!s:real. &0:real < &35065657154776702799` in
let mqrel = REAL_ARITH `
  ((&159488155889170350)*(&50659328)+(&28410243987721965325)*(&11010048))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((-- &26869760) * &0 + (-- &10027008) * -- &1 / &2)) /\
  ((&159488155889170350)*(-- &175046656)+(&28410243987721965325)*(-- &34930688))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((-- &26869760) * &1 / &2 + (-- &10027008) * &1 / &4)) /\
  (&159488155889170350)*(&111549985)+(&28410243987721965325)*(&22163375)+(&68384306930227553616868) = (&35065657154776702799)*(&18466107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &26869760) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &10027008) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18466107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &159488155889170350` [mpos] THEN
  note `&0:real < &28410243987721965325` [npos] THEN
  note `&0:real < &68384306930227553616868` [ppos] THEN
  note `&0:real < &35065657154776702799` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&159488155889170350)*(&50659328)+(&28410243987721965325)*(&11010048))*s pow 2 = (&35065657154776702799)*((-- &26869760) * &0 + (-- &10027008) * -- &1 / &2) /\ ((&159488155889170350)*(-- &175046656)+(&28410243987721965325)*(-- &34930688))*s pow 2 = (&35065657154776702799)*((-- &26869760) * &1 / &2 + (-- &10027008) * &1 / &4) /\ (&159488155889170350)*(&111549985)+(&28410243987721965325)*(&22163375)+(&68384306930227553616868) = (&35065657154776702799)*(&18466107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &22547529098834266175` in
let npos = REAL_ARITH `!s:real. &0:real < &1478097881901819200` in
let ppos = REAL_ARITH `!s:real. &0:real < &696100894965659152410479` in
let qpos = REAL_ARITH `!s:real. &0:real < &180745848154096707028` in
let mqrel = REAL_ARITH `
  ((&22547529098834266175)*(&145883136)+(&1478097881901819200)*(&3457024))*(&30902639 / &41749730) pow 2 = (&180745848154096707028)*(((-- &52412416) * &0 + (-- &19972096) * -- &1 / &2)) /\
  ((&22547529098834266175)*(-- &455802880)+(&1478097881901819200)*(-- &10452992))*(&30902639 / &41749730) pow 2 = (&180745848154096707028)*(((-- &52412416) * &1 / &2 + (-- &19972096) * &1 / &4)) /\
  (&22547529098834266175)*(&288985723)+(&1478097881901819200)*(&6651805)+(&696100894965659152410479) = (&180745848154096707028)*(&36108393)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&145883136) * x + (-- &455802880) * y <= &288985723 ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (-- &52412416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &19972096) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &36108393
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22547529098834266175` [mpos] THEN
  note `&0:real < &1478097881901819200` [npos] THEN
  note `&0:real < &696100894965659152410479` [ppos] THEN
  note `&0:real < &180745848154096707028` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&22547529098834266175)*(&145883136)+(&1478097881901819200)*(&3457024))*s pow 2 = (&180745848154096707028)*((-- &52412416) * &0 + (-- &19972096) * -- &1 / &2) /\ ((&22547529098834266175)*(-- &455802880)+(&1478097881901819200)*(-- &10452992))*s pow 2 = (&180745848154096707028)*((-- &52412416) * &1 / &2 + (-- &19972096) * &1 / &4) /\ (&22547529098834266175)*(&288985723)+(&1478097881901819200)*(&6651805)+(&696100894965659152410479) = (&180745848154096707028)*(&36108393)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &27340627519291480240` in
let npos = REAL_ARITH `!s:real. &0:real < &2701711930362995` in
let ppos = REAL_ARITH `!s:real. &0:real < &19265641541820437302675` in
let qpos = REAL_ARITH `!s:real. &0:real < &32807145779983083634` in
let mqrel = REAL_ARITH `
  ((&27340627519291480240)*(&3457024)+(&2701711930362995)*(&58130432))*(&30902639 / &41749730) pow 2 = (&32807145779983083634)*(((-- &7979008) * &0 + (-- &3162112) * -- &1 / &2)) /\
  ((&27340627519291480240)*(-- &10452992)+(&2701711930362995)*(-- &162430976))*(&30902639 / &41749730) pow 2 = (&32807145779983083634)*(((-- &7979008) * &1 / &2 + (-- &3162112) * &1 / &4)) /\
  (&27340627519291480240)*(&6651805)+(&2701711930362995)*(&104374325)+(&19265641541820437302675) = (&32807145779983083634)*(&5552625)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (-- &7979008) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &3162112) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5552625
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &27340627519291480240` [mpos] THEN
  note `&0:real < &2701711930362995` [npos] THEN
  note `&0:real < &19265641541820437302675` [ppos] THEN
  note `&0:real < &32807145779983083634` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&27340627519291480240)*(&3457024)+(&2701711930362995)*(&58130432))*s pow 2 = (&32807145779983083634)*((-- &7979008) * &0 + (-- &3162112) * -- &1 / &2) /\ ((&27340627519291480240)*(-- &10452992)+(&2701711930362995)*(-- &162430976))*s pow 2 = (&32807145779983083634)*((-- &7979008) * &1 / &2 + (-- &3162112) * &1 / &4) /\ (&27340627519291480240)*(&6651805)+(&2701711930362995)*(&104374325)+(&19265641541820437302675) = (&32807145779983083634)*(&5552625)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &376496630295746400` in
let npos = REAL_ARITH `!s:real. &0:real < &13639723408434210725` in
let ppos = REAL_ARITH `!s:real. &0:real < &151111857159341371236794` in
let qpos = REAL_ARITH `!s:real. &0:real < &16403572889991541817` in
let mqrel = REAL_ARITH `
  ((&376496630295746400)*(&3457024)+(&13639723408434210725)*(&58130432))*(&30902639 / &41749730) pow 2 = (&16403572889991541817)*(((-- &121733120) * &0 + (-- &53051392) * -- &1 / &2)) /\
  ((&376496630295746400)*(-- &10452992)+(&13639723408434210725)*(-- &162430976))*(&30902639 / &41749730) pow 2 = (&16403572889991541817)*(((-- &121733120) * &1 / &2 + (-- &53051392) * &1 / &4)) /\
  (&376496630295746400)*(&6651805)+(&13639723408434210725)*(&104374325)+(&151111857159341371236794) = (&16403572889991541817)*(&86950107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (-- &121733120) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &53051392) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &86950107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &376496630295746400` [mpos] THEN
  note `&0:real < &13639723408434210725` [npos] THEN
  note `&0:real < &151111857159341371236794` [ppos] THEN
  note `&0:real < &16403572889991541817` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&376496630295746400)*(&3457024)+(&13639723408434210725)*(&58130432))*s pow 2 = (&16403572889991541817)*((-- &121733120) * &0 + (-- &53051392) * -- &1 / &2) /\ ((&376496630295746400)*(-- &10452992)+(&13639723408434210725)*(-- &162430976))*s pow 2 = (&16403572889991541817)*((-- &121733120) * &1 / &2 + (-- &53051392) * &1 / &4) /\ (&376496630295746400)*(&6651805)+(&13639723408434210725)*(&104374325)+(&151111857159341371236794) = (&16403572889991541817)*(&86950107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &96225827999765749175` in
let npos = REAL_ARITH `!s:real. &0:real < &446218228498662400` in
let ppos = REAL_ARITH `!s:real. &0:real < &4807466056920767214602138` in
let qpos = REAL_ARITH `!s:real. &0:real < &462207934000628528321` in
let mqrel = REAL_ARITH `
  ((&96225827999765749175)*(&290521088)+(&446218228498662400)*(&14442496))*(&30902639 / &41749730) pow 2 = (&462207934000628528321)*(((-- &124731392) * &0 + (-- &66289664) * -- &1 / &2)) /\
  ((&96225827999765749175)*(-- &691929088)+(&446218228498662400)*(-- &29925376))*(&30902639 / &41749730) pow 2 = (&462207934000628528321)*(((-- &124731392) * &1 / &2 + (-- &66289664) * &1 / &4)) /\
  (&96225827999765749175)*(&457690221)+(&446218228498662400)*(&20669487)+(&4807466056920767214602138) = (&462207934000628528321)*(&95315653)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &124731392) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &66289664) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &95315653
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &96225827999765749175` [mpos] THEN
  note `&0:real < &446218228498662400` [npos] THEN
  note `&0:real < &4807466056920767214602138` [ppos] THEN
  note `&0:real < &462207934000628528321` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&96225827999765749175)*(&290521088)+(&446218228498662400)*(&14442496))*s pow 2 = (&462207934000628528321)*((-- &124731392) * &0 + (-- &66289664) * -- &1 / &2) /\ ((&96225827999765749175)*(-- &691929088)+(&446218228498662400)*(-- &29925376))*s pow 2 = (&462207934000628528321)*((-- &124731392) * &1 / &2 + (-- &66289664) * &1 / &4) /\ (&96225827999765749175)*(&457690221)+(&446218228498662400)*(&20669487)+(&4807466056920767214602138) = (&462207934000628528321)*(&95315653)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &26058447328339855` in
let npos = REAL_ARITH `!s:real. &0:real < &439441986369320993960` in
let ppos = REAL_ARITH `!s:real. &0:real < &992574538074542682790138` in
let qpos = REAL_ARITH `!s:real. &0:real < &66029704857232646903` in
let mqrel = REAL_ARITH `
  ((&26058447328339855)*(&290521088)+(&439441986369320993960)*(&14442496))*(&30902639 / &41749730) pow 2 = (&66029704857232646903)*(((-- &165806080) * &0 + (-- &105447424) * -- &1 / &2)) /\
  ((&26058447328339855)*(-- &691929088)+(&439441986369320993960)*(-- &29925376))*(&30902639 / &41749730) pow 2 = (&66029704857232646903)*(((-- &165806080) * &1 / &2 + (-- &105447424) * &1 / &4)) /\
  (&26058447328339855)*(&457690221)+(&439441986369320993960)*(&20669487)+(&992574538074542682790138) = (&66029704857232646903)*(&137755571)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &165806080) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &105447424) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &137755571
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26058447328339855` [mpos] THEN
  note `&0:real < &439441986369320993960` [npos] THEN
  note `&0:real < &992574538074542682790138` [ppos] THEN
  note `&0:real < &66029704857232646903` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&26058447328339855)*(&290521088)+(&439441986369320993960)*(&14442496))*s pow 2 = (&66029704857232646903)*((-- &165806080) * &0 + (-- &105447424) * -- &1 / &2) /\ ((&26058447328339855)*(-- &691929088)+(&439441986369320993960)*(-- &29925376))*s pow 2 = (&66029704857232646903)*((-- &165806080) * &1 / &2 + (-- &105447424) * &1 / &4) /\ (&26058447328339855)*(&457690221)+(&439441986369320993960)*(&20669487)+(&992574538074542682790138) = (&66029704857232646903)*(&137755571)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &2171193951309897800` in
let npos = REAL_ARITH `!s:real. &0:real < &396145444334750` in
let ppos = REAL_ARITH `!s:real. &0:real < &6653437583049254535443` in
let qpos = REAL_ARITH `!s:real. &0:real < &2932722381391629791` in
let mqrel = REAL_ARITH `
  ((&2171193951309897800)*(&19062784)+(&396145444334750)*(&15433728))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((-- &22740992) * &0 + (-- &15466496) * -- &1 / &2)) /\
  ((&2171193951309897800)*(-- &37560320)+(&396145444334750)*(-- &29458432))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((-- &22740992) * &1 / &2 + (-- &15466496) * &1 / &4)) /\
  (&2171193951309897800)*(&26430931)+(&396145444334750)*(&21015329)+(&6653437583049254535443) = (&2932722381391629791)*(&19572823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&19062784) * x + (-- &37560320) * y <= &26430931 ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (-- &22740992) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &15466496) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &19572823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2171193951309897800` [mpos] THEN
  note `&0:real < &396145444334750` [npos] THEN
  note `&0:real < &6653437583049254535443` [ppos] THEN
  note `&0:real < &2932722381391629791` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&2171193951309897800)*(&19062784)+(&396145444334750)*(&15433728))*s pow 2 = (&2932722381391629791)*((-- &22740992) * &0 + (-- &15466496) * -- &1 / &2) /\ ((&2171193951309897800)*(-- &37560320)+(&396145444334750)*(-- &29458432))*s pow 2 = (&2932722381391629791)*((-- &22740992) * &1 / &2 + (-- &15466496) * &1 / &4) /\ (&2171193951309897800)*(&26430931)+(&396145444334750)*(&21015329)+(&6653437583049254535443) = (&2932722381391629791)*(&19572823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &9032116130832300` in
let npos = REAL_ARITH `!s:real. &0:real < &432075836135911825` in
let ppos = REAL_ARITH `!s:real. &0:real < &1081475302568941663188` in
let qpos = REAL_ARITH `!s:real. &0:real < &2932722381391629791` in
let mqrel = REAL_ARITH `
  ((&9032116130832300)*(&19062784)+(&432075836135911825)*(&15433728))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((-- &3604480) * &0 + (-- &2555904) * -- &1 / &2)) /\
  ((&9032116130832300)*(-- &37560320)+(&432075836135911825)*(-- &29458432))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((-- &3604480) * &1 / &2 + (-- &2555904) * &1 / &4)) /\
  (&9032116130832300)*(&26430931)+(&432075836135911825)*(&21015329)+(&1081475302568941663188) = (&2932722381391629791)*(&3177943)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&19062784) * x + (-- &37560320) * y <= &26430931 ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (-- &3604480) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &2555904) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3177943
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9032116130832300` [mpos] THEN
  note `&0:real < &432075836135911825` [npos] THEN
  note `&0:real < &1081475302568941663188` [ppos] THEN
  note `&0:real < &2932722381391629791` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&9032116130832300)*(&19062784)+(&432075836135911825)*(&15433728))*s pow 2 = (&2932722381391629791)*((-- &3604480) * &0 + (-- &2555904) * -- &1 / &2) /\ ((&9032116130832300)*(-- &37560320)+(&432075836135911825)*(-- &29458432))*s pow 2 = (&2932722381391629791)*((-- &3604480) * &1 / &2 + (-- &2555904) * &1 / &4) /\ (&9032116130832300)*(&26430931)+(&432075836135911825)*(&21015329)+(&1081475302568941663188) = (&2932722381391629791)*(&3177943)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &688967916961755037200` in
let npos = REAL_ARITH `!s:real. &0:real < &95867197529009500` in
let ppos = REAL_ARITH `!s:real. &0:real < &504829838004490951343993` in
let qpos = REAL_ARITH `!s:real. &0:real < &832987698651842128423` in
let mqrel = REAL_ARITH `
  ((&688967916961755037200)*(&5660672)+(&95867197529009500)*(&373096448))*(&30902639 / &41749730) pow 2 = (&832987698651842128423)*(((-- &5537792) * &0 + (-- &5177344) * -- &1 / &2)) /\
  ((&688967916961755037200)*(-- &8896512)+(&95867197529009500)*(-- &503644160))*(&30902639 / &41749730) pow 2 = (&832987698651842128423)*(((-- &5537792) * &1 / &2 + (-- &5177344) * &1 / &4)) /\
  (&688967916961755037200)*(&6951751)+(&95867197529009500)*(&426281637)+(&504829838004490951343993) = (&832987698651842128423)*(&5799491)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &5537792) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &5177344) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5799491
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &688967916961755037200` [mpos] THEN
  note `&0:real < &95867197529009500` [npos] THEN
  note `&0:real < &504829838004490951343993` [ppos] THEN
  note `&0:real < &832987698651842128423` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&688967916961755037200)*(&5660672)+(&95867197529009500)*(&373096448))*s pow 2 = (&832987698651842128423)*((-- &5537792) * &0 + (-- &5177344) * -- &1 / &2) /\ ((&688967916961755037200)*(-- &8896512)+(&95867197529009500)*(-- &503644160))*s pow 2 = (&832987698651842128423)*((-- &5537792) * &1 / &2 + (-- &5177344) * &1 / &4) /\ (&688967916961755037200)*(&6951751)+(&95867197529009500)*(&426281637)+(&504829838004490951343993) = (&832987698651842128423)*(&5799491)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &4263475730108313400` in
let npos = REAL_ARITH `!s:real. &0:real < &99034736887365727525` in
let ppos = REAL_ARITH `!s:real. &0:real < &4460222336512199008753918` in
let qpos = REAL_ARITH `!s:real. &0:real < &118998242664548875489` in
let mqrel = REAL_ARITH `
  ((&4263475730108313400)*(&5660672)+(&99034736887365727525)*(&373096448))*(&30902639 / &41749730) pow 2 = (&118998242664548875489)*(((-- &289406976) * &0 + (-- &340459520) * -- &1 / &2)) /\
  ((&4263475730108313400)*(-- &8896512)+(&99034736887365727525)*(-- &503644160))*(&30902639 / &41749730) pow 2 = (&118998242664548875489)*(((-- &289406976) * &1 / &2 + (-- &340459520) * &1 / &4)) /\
  (&4263475730108313400)*(&6951751)+(&99034736887365727525)*(&426281637)+(&4460222336512199008753918) = (&118998242664548875489)*(&355053887)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &289406976) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &340459520) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &355053887
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4263475730108313400` [mpos] THEN
  note `&0:real < &99034736887365727525` [npos] THEN
  note `&0:real < &4460222336512199008753918` [ppos] THEN
  note `&0:real < &118998242664548875489` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&4263475730108313400)*(&5660672)+(&99034736887365727525)*(&373096448))*s pow 2 = (&118998242664548875489)*((-- &289406976) * &0 + (-- &340459520) * -- &1 / &2) /\ ((&4263475730108313400)*(-- &8896512)+(&99034736887365727525)*(-- &503644160))*s pow 2 = (&118998242664548875489)*((-- &289406976) * &1 / &2 + (-- &340459520) * &1 / &4) /\ (&4263475730108313400)*(&6951751)+(&99034736887365727525)*(&426281637)+(&4460222336512199008753918) = (&118998242664548875489)*(&355053887)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &5679695693605044650` in
let npos = REAL_ARITH `!s:real. &0:real < &4793359876450475` in
let ppos = REAL_ARITH `!s:real. &0:real < &4150286826982837138483` in
let qpos = REAL_ARITH `!s:real. &0:real < &13715323621473978202` in
let mqrel = REAL_ARITH `
  ((&5679695693605044650)*(&5701632)+(&4793359876450475)*(&46596096))*(&30902639 / &41749730) pow 2 = (&13715323621473978202)*(((-- &2048000) * &0 + (-- &2605056) * -- &1 / &2)) /\
  ((&5679695693605044650)*(-- &7340032)+(&4793359876450475)*(-- &51871744))*(&30902639 / &41749730) pow 2 = (&13715323621473978202)*(((-- &2048000) * &1 / &2 + (-- &2605056) * &1 / &4)) /\
  (&5679695693605044650)*(&6407825)+(&4793359876450475)*(&49963991)+(&4150286826982837138483) = (&13715323621473978202)*(&2671329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5701632) * x + (-- &7340032) * y <= &6407825 ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (-- &2048000) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &2605056) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &2671329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5679695693605044650` [mpos] THEN
  note `&0:real < &4793359876450475` [npos] THEN
  note `&0:real < &4150286826982837138483` [ppos] THEN
  note `&0:real < &13715323621473978202` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5679695693605044650)*(&5701632)+(&4793359876450475)*(&46596096))*s pow 2 = (&13715323621473978202)*((-- &2048000) * &0 + (-- &2605056) * -- &1 / &2) /\ ((&5679695693605044650)*(-- &7340032)+(&4793359876450475)*(-- &51871744))*s pow 2 = (&13715323621473978202)*((-- &2048000) * &1 / &2 + (-- &2605056) * &1 / &4) /\ (&5679695693605044650)*(&6407825)+(&4793359876450475)*(&49963991)+(&4150286826982837138483) = (&13715323621473978202)*(&2671329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &644053263399436550` in
let npos = REAL_ARITH `!s:real. &0:real < &17059132040298472300` in
let ppos = REAL_ARITH `!s:real. &0:real < &96185408735684562770997` in
let qpos = REAL_ARITH `!s:real. &0:real < &20572985432210967303` in
let mqrel = REAL_ARITH `
  ((&644053263399436550)*(&5701632)+(&17059132040298472300)*(&46596096))*(&30902639 / &41749730) pow 2 = (&20572985432210967303)*(((-- &26116096) * &0 + (-- &42532864) * -- &1 / &2)) /\
  ((&644053263399436550)*(-- &7340032)+(&17059132040298472300)*(-- &51871744))*(&30902639 / &41749730) pow 2 = (&20572985432210967303)*(((-- &26116096) * &1 / &2 + (-- &42532864) * &1 / &4)) /\
  (&644053263399436550)*(&6407825)+(&17059132040298472300)*(&49963991)+(&96185408735684562770997) = (&20572985432210967303)*(&41635449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5701632) * x + (-- &7340032) * y <= &6407825 ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (-- &26116096) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &42532864) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &41635449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &644053263399436550` [mpos] THEN
  note `&0:real < &17059132040298472300` [npos] THEN
  note `&0:real < &96185408735684562770997` [ppos] THEN
  note `&0:real < &20572985432210967303` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&644053263399436550)*(&5701632)+(&17059132040298472300)*(&46596096))*s pow 2 = (&20572985432210967303)*((-- &26116096) * &0 + (-- &42532864) * -- &1 / &2) /\ ((&644053263399436550)*(-- &7340032)+(&17059132040298472300)*(-- &51871744))*s pow 2 = (&20572985432210967303)*((-- &26116096) * &1 / &2 + (-- &42532864) * &1 / &4) /\ (&644053263399436550)*(&6407825)+(&17059132040298472300)*(&49963991)+(&96185408735684562770997) = (&20572985432210967303)*(&41635449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &880602522982346113675` in
let npos = REAL_ARITH `!s:real. &0:real < &692422622152709525` in
let ppos = REAL_ARITH `!s:real. &0:real < &8298273780757572969887730` in
let qpos = REAL_ARITH `!s:real. &0:real < &529225081040329083138` in
let mqrel = REAL_ARITH `
  ((&880602522982346113675)*(&84901888)+(&692422622152709525)*(&134447104))*(&30902639 / &41749730) pow 2 = (&529225081040329083138)*(((-- &66748416) * &0 + (-- &154992640) * -- &1 / &2)) /\
  ((&880602522982346113675)*(-- &79036416)+(&692422622152709525)*(-- &97124352))*(&30902639 / &41749730) pow 2 = (&529225081040329083138)*(((-- &66748416) * &1 / &2 + (-- &154992640) * &1 / &4)) /\
  (&880602522982346113675)*(&86789633)+(&692422622152709525)*(&131957561)+(&8298273780757572969887730) = (&529225081040329083138)*(&144601685)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (-- &66748416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &154992640) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &144601685
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &880602522982346113675` [mpos] THEN
  note `&0:real < &692422622152709525` [npos] THEN
  note `&0:real < &8298273780757572969887730` [ppos] THEN
  note `&0:real < &529225081040329083138` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&880602522982346113675)*(&84901888)+(&692422622152709525)*(&134447104))*s pow 2 = (&529225081040329083138)*((-- &66748416) * &0 + (-- &154992640) * -- &1 / &2) /\ ((&880602522982346113675)*(-- &79036416)+(&692422622152709525)*(-- &97124352))*s pow 2 = (&529225081040329083138)*((-- &66748416) * &1 / &2 + (-- &154992640) * &1 / &4) /\ (&880602522982346113675)*(&86789633)+(&692422622152709525)*(&131957561)+(&8298273780757572969887730) = (&529225081040329083138)*(&144601685)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &60570638438783275` in
let npos = REAL_ARITH `!s:real. &0:real < &251867966228067745325` in
let ppos = REAL_ARITH `!s:real. &0:real < &3605290306696362904653240` in
let qpos = REAL_ARITH `!s:real. &0:real < &2116900324161316332552` in
let mqrel = REAL_ARITH `
  ((&60570638438783275)*(&84901888)+(&251867966228067745325)*(&134447104))*(&30902639 / &41749730) pow 2 = (&2116900324161316332552)*(((-- &3899392) * &0 + (-- &17530880) * -- &1 / &2)) /\
  ((&60570638438783275)*(-- &79036416)+(&251867966228067745325)*(-- &97124352))*(&30902639 / &41749730) pow 2 = (&2116900324161316332552)*(((-- &3899392) * &1 / &2 + (-- &17530880) * &1 / &4)) /\
  (&60570638438783275)*(&86789633)+(&251867966228067745325)*(&131957561)+(&3605290306696362904653240) = (&2116900324161316332552)*(&15704445)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (-- &3899392) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &17530880) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &15704445
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &60570638438783275` [mpos] THEN
  note `&0:real < &251867966228067745325` [npos] THEN
  note `&0:real < &3605290306696362904653240` [ppos] THEN
  note `&0:real < &2116900324161316332552` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&60570638438783275)*(&84901888)+(&251867966228067745325)*(&134447104))*s pow 2 = (&2116900324161316332552)*((-- &3899392) * &0 + (-- &17530880) * -- &1 / &2) /\ ((&60570638438783275)*(-- &79036416)+(&251867966228067745325)*(-- &97124352))*s pow 2 = (&2116900324161316332552)*((-- &3899392) * &1 / &2 + (-- &17530880) * &1 / &4) /\ (&60570638438783275)*(&86789633)+(&251867966228067745325)*(&131957561)+(&3605290306696362904653240) = (&2116900324161316332552)*(&15704445)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &233567353979768600` in
let npos = REAL_ARITH `!s:real. &0:real < &1108200400875978799400` in
let ppos = REAL_ARITH `!s:real. &0:real < &11774469059809228630192881` in
let qpos = REAL_ARITH `!s:real. &0:real < &1331086386563197332887` in
let mqrel = REAL_ARITH `
  ((&233567353979768600)*(&134447104)+(&1108200400875978799400)*(&100401152))*(&30902639 / &41749730) pow 2 = (&1331086386563197332887)*(((-- &65536) * &0 + (-- &91619328) * -- &1 / &2)) /\
  ((&233567353979768600)*(-- &97124352)+(&1108200400875978799400)*(-- &50266112))*(&30902639 / &41749730) pow 2 = (&1331086386563197332887)*(((-- &65536) * &1 / &2 + (-- &91619328) * &1 / &4)) /\
  (&233567353979768600)*(&131957561)+(&1108200400875978799400)*(&95584823)+(&11774469059809228630192881) = (&1331086386563197332887)*(&79611463)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (-- &65536) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &91619328) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &79611463
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &233567353979768600` [mpos] THEN
  note `&0:real < &1108200400875978799400` [npos] THEN
  note `&0:real < &11774469059809228630192881` [ppos] THEN
  note `&0:real < &1331086386563197332887` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&233567353979768600)*(&134447104)+(&1108200400875978799400)*(&100401152))*s pow 2 = (&1331086386563197332887)*((-- &65536) * &0 + (-- &91619328) * -- &1 / &2) /\ ((&233567353979768600)*(-- &97124352)+(&1108200400875978799400)*(-- &50266112))*s pow 2 = (&1331086386563197332887)*((-- &65536) * &1 / &2 + (-- &91619328) * &1 / &4) /\ (&233567353979768600)*(&131957561)+(&1108200400875978799400)*(&95584823)+(&11774469059809228630192881) = (&1331086386563197332887)*(&79611463)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &63573024761396345250` in
let npos = REAL_ARITH `!s:real. &0:real < &3544471748640742150` in
let ppos = REAL_ARITH `!s:real. &0:real < &370422155709931954307417` in
let qpos = REAL_ARITH `!s:real. &0:real < &38574228313758418153` in
let mqrel = REAL_ARITH `
  ((&63573024761396345250)*(&64782336)+(&3544471748640742150)*(&12943360))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((&9371648) * &0 + (-- &118292480) * -- &1 / &2)) /\
  ((&63573024761396345250)*(-- &27295744)+(&3544471748640742150)*(-- &4784128))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((&9371648) * &1 / &2 + (-- &118292480) * &1 / &4)) /\
  (&63573024761396345250)*(&61112343)+(&3544471748640742150)*(&12157023)+(&370422155709931954307417) = (&38574228313758418153)*(&101844089)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&64782336) * x + (-- &27295744) * y <= &61112343 ==>
  (&12943360) * x + (-- &4784128) * y <= &12157023 ==>
  (&9371648) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &118292480) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &101844089
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &63573024761396345250` [mpos] THEN
  note `&0:real < &3544471748640742150` [npos] THEN
  note `&0:real < &370422155709931954307417` [ppos] THEN
  note `&0:real < &38574228313758418153` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&63573024761396345250)*(&64782336)+(&3544471748640742150)*(&12943360))*s pow 2 = (&38574228313758418153)*((&9371648) * &0 + (-- &118292480) * -- &1 / &2) /\ ((&63573024761396345250)*(-- &27295744)+(&3544471748640742150)*(-- &4784128))*s pow 2 = (&38574228313758418153)*((&9371648) * &1 / &2 + (-- &118292480) * &1 / &4) /\ (&63573024761396345250)*(&61112343)+(&3544471748640742150)*(&12157023)+(&370422155709931954307417) = (&38574228313758418153)*(&101844089)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &161231195844243250` in
let npos = REAL_ARITH `!s:real. &0:real < &15235040727314682450` in
let ppos = REAL_ARITH `!s:real. &0:real < &18458396115716671583581` in
let qpos = REAL_ARITH `!s:real. &0:real < &38574228313758418153` in
let mqrel = REAL_ARITH `
  ((&161231195844243250)*(&64782336)+(&15235040727314682450)*(&12943360))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((&753664) * &0 + (-- &5898240) * -- &1 / &2)) /\
  ((&161231195844243250)*(-- &27295744)+(&15235040727314682450)*(-- &4784128))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((&753664) * &1 / &2 + (-- &5898240) * &1 / &4)) /\
  (&161231195844243250)*(&61112343)+(&15235040727314682450)*(&12157023)+(&18458396115716671583581) = (&38574228313758418153)*(&5057377)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&64782336) * x + (-- &27295744) * y <= &61112343 ==>
  (&12943360) * x + (-- &4784128) * y <= &12157023 ==>
  (&753664) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &5898240) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5057377
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &161231195844243250` [mpos] THEN
  note `&0:real < &15235040727314682450` [npos] THEN
  note `&0:real < &18458396115716671583581` [ppos] THEN
  note `&0:real < &38574228313758418153` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&161231195844243250)*(&64782336)+(&15235040727314682450)*(&12943360))*s pow 2 = (&38574228313758418153)*((&753664) * &0 + (-- &5898240) * -- &1 / &2) /\ ((&161231195844243250)*(-- &27295744)+(&15235040727314682450)*(-- &4784128))*s pow 2 = (&38574228313758418153)*((&753664) * &1 / &2 + (-- &5898240) * &1 / &4) /\ (&161231195844243250)*(&61112343)+(&15235040727314682450)*(&12157023)+(&18458396115716671583581) = (&38574228313758418153)*(&5057377)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &15093418730965009325` in
let npos = REAL_ARITH `!s:real. &0:real < &5874480408584441225` in
let ppos = REAL_ARITH `!s:real. &0:real < &1486521386839343548264789` in
let qpos = REAL_ARITH `!s:real. &0:real < &18147353765413591963` in
let mqrel = REAL_ARITH `
  ((&15093418730965009325)*(&1012072448)+(&5874480408584441225)*(&3866624))*(&30902639 / &41749730) pow 2 = (&18147353765413591963)*(((&129499136) * &0 + (-- &923729920) * -- &1 / &2)) /\
  ((&15093418730965009325)*(-- &364183552)+(&5874480408584441225)*(-- &1310720))*(&30902639 / &41749730) pow 2 = (&18147353765413591963)*(((&129499136) * &1 / &2 + (-- &923729920) * &1 / &4)) /\
  (&15093418730965009325)*(&949861697)+(&5874480408584441225)*(&3642043)+(&1486521386839343548264789) = (&18147353765413591963)*(&791274703)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1012072448) * x + (-- &364183552) * y <= &949861697 ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&129499136) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &923729920) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &791274703
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &15093418730965009325` [mpos] THEN
  note `&0:real < &5874480408584441225` [npos] THEN
  note `&0:real < &1486521386839343548264789` [ppos] THEN
  note `&0:real < &18147353765413591963` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&15093418730965009325)*(&1012072448)+(&5874480408584441225)*(&3866624))*s pow 2 = (&18147353765413591963)*((&129499136) * &0 + (-- &923729920) * -- &1 / &2) /\ ((&15093418730965009325)*(-- &364183552)+(&5874480408584441225)*(-- &1310720))*s pow 2 = (&18147353765413591963)*((&129499136) * &1 / &2 + (-- &923729920) * &1 / &4) /\ (&15093418730965009325)*(&949861697)+(&5874480408584441225)*(&3642043)+(&1486521386839343548264789) = (&18147353765413591963)*(&791274703)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &20480719472106575` in
let npos = REAL_ARITH `!s:real. &0:real < &115622376619816980375` in
let ppos = REAL_ARITH `!s:real. &0:real < &45608083068703861137992` in
let qpos = REAL_ARITH `!s:real. &0:real < &72589415061654367852` in
let mqrel = REAL_ARITH `
  ((&20480719472106575)*(&1012072448)+(&115622376619816980375)*(&3866624))*(&30902639 / &41749730) pow 2 = (&72589415061654367852)*(((&1130496) * &0 + (-- &7061504) * -- &1 / &2)) /\
  ((&20480719472106575)*(-- &364183552)+(&115622376619816980375)*(-- &1310720))*(&30902639 / &41749730) pow 2 = (&72589415061654367852)*(((&1130496) * &1 / &2 + (-- &7061504) * &1 / &4)) /\
  (&20480719472106575)*(&949861697)+(&115622376619816980375)*(&3642043)+(&45608083068703861137992) = (&72589415061654367852)*(&6069771)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1012072448) * x + (-- &364183552) * y <= &949861697 ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&1130496) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &7061504) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &6069771
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20480719472106575` [mpos] THEN
  note `&0:real < &115622376619816980375` [npos] THEN
  note `&0:real < &45608083068703861137992` [ppos] THEN
  note `&0:real < &72589415061654367852` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&20480719472106575)*(&1012072448)+(&115622376619816980375)*(&3866624))*s pow 2 = (&72589415061654367852)*((&1130496) * &0 + (-- &7061504) * -- &1 / &2) /\ ((&20480719472106575)*(-- &364183552)+(&115622376619816980375)*(-- &1310720))*s pow 2 = (&72589415061654367852)*((&1130496) * &1 / &2 + (-- &7061504) * &1 / &4) /\ (&20480719472106575)*(&949861697)+(&115622376619816980375)*(&3642043)+(&45608083068703861137992) = (&72589415061654367852)*(&6069771)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &28673007260949205` in
let npos = REAL_ARITH `!s:real. &0:real < &757960924463450565` in
let ppos = REAL_ARITH `!s:real. &0:real < &3266542137660967988856` in
let qpos = REAL_ARITH `!s:real. &0:real < &29275655266669424576` in
let mqrel = REAL_ARITH `
  ((&28673007260949205)*(&3866624)+(&757960924463450565)*(&39124992))*(&30902639 / &41749730) pow 2 = (&29275655266669424576)*(((&481280) * &0 + (-- &1114112) * -- &1 / &2)) /\
  ((&28673007260949205)*(-- &1310720)+(&757960924463450565)*(-- &2621440))*(&30902639 / &41749730) pow 2 = (&29275655266669424576)*(((&481280) * &1 / &2 + (-- &1114112) * &1 / &4)) /\
  (&28673007260949205)*(&3642043)+(&757960924463450565)*(&38657149)+(&3266542137660967988856) = (&29275655266669424576)*(&1004531)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&481280) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &1114112) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &1004531
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &28673007260949205` [mpos] THEN
  note `&0:real < &757960924463450565` [npos] THEN
  note `&0:real < &3266542137660967988856` [ppos] THEN
  note `&0:real < &29275655266669424576` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&28673007260949205)*(&3866624)+(&757960924463450565)*(&39124992))*s pow 2 = (&29275655266669424576)*((&481280) * &0 + (-- &1114112) * -- &1 / &2) /\ ((&28673007260949205)*(-- &1310720)+(&757960924463450565)*(-- &2621440))*s pow 2 = (&29275655266669424576)*((&481280) * &1 / &2 + (-- &1114112) * &1 / &4) /\ (&28673007260949205)*(&3642043)+(&757960924463450565)*(&38657149)+(&3266542137660967988856) = (&29275655266669424576)*(&1004531)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &6213849852077146086775` in
let npos = REAL_ARITH `!s:real. &0:real < &50112398708345875` in
let ppos = REAL_ARITH `!s:real. &0:real < &4002323904669878936888940` in
let qpos = REAL_ARITH `!s:real. &0:real < &598391872521746524526` in
let mqrel = REAL_ARITH `
  ((&6213849852077146086775)*(&5865472)+(&50112398708345875)*(&439386112))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((&44220416) * &0 + (-- &66781184) * -- &1 / &2)) /\
  ((&6213849852077146086775)*(&950272)+(&50112398708345875)*(&185892864))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((&44220416) * &1 / &2 + (-- &66781184) * &1 / &4)) /\
  (&6213849852077146086775)*(&6035371)+(&50112398708345875)*(&480443643)+(&4002323904669878936888940) = (&598391872521746524526)*(&62719715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&44220416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &66781184) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &62719715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6213849852077146086775` [mpos] THEN
  note `&0:real < &50112398708345875` [npos] THEN
  note `&0:real < &4002323904669878936888940` [ppos] THEN
  note `&0:real < &598391872521746524526` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&6213849852077146086775)*(&5865472)+(&50112398708345875)*(&439386112))*s pow 2 = (&598391872521746524526)*((&44220416) * &0 + (-- &66781184) * -- &1 / &2) /\ ((&6213849852077146086775)*(&950272)+(&50112398708345875)*(&185892864))*s pow 2 = (&598391872521746524526)*((&44220416) * &1 / &2 + (-- &66781184) * &1 / &4) /\ (&6213849852077146086775)*(&6035371)+(&50112398708345875)*(&480443643)+(&4002323904669878936888940) = (&598391872521746524526)*(&62719715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &1573055648334269414425` in
let npos = REAL_ARITH `!s:real. &0:real < &86151928579421923625` in
let ppos = REAL_ARITH `!s:real. &0:real < &3922147310120543526848080` in
let qpos = REAL_ARITH `!s:real. &0:real < &598391872521746524526` in
let mqrel = REAL_ARITH `
  ((&1573055648334269414425)*(&5865472)+(&86151928579421923625)*(&439386112))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((&75169792) * &0 + (-- &86212608) * -- &1 / &2)) /\
  ((&1573055648334269414425)*(&950272)+(&86151928579421923625)*(&185892864))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((&75169792) * &1 / &2 + (-- &86212608) * &1 / &4)) /\
  (&1573055648334269414425)*(&6035371)+(&86151928579421923625)*(&480443643)+(&3922147310120543526848080) = (&598391872521746524526)*(&85043005)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&75169792) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &86212608) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &85043005
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1573055648334269414425` [mpos] THEN
  note `&0:real < &86151928579421923625` [npos] THEN
  note `&0:real < &3922147310120543526848080` [ppos] THEN
  note `&0:real < &598391872521746524526` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&1573055648334269414425)*(&5865472)+(&86151928579421923625)*(&439386112))*s pow 2 = (&598391872521746524526)*((&75169792) * &0 + (-- &86212608) * -- &1 / &2) /\ ((&1573055648334269414425)*(&950272)+(&86151928579421923625)*(&185892864))*s pow 2 = (&598391872521746524526)*((&75169792) * &1 / &2 + (-- &86212608) * &1 / &4) /\ (&1573055648334269414425)*(&6035371)+(&86151928579421923625)*(&480443643)+(&3922147310120543526848080) = (&598391872521746524526)*(&85043005)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &11532190030028907250` in
let npos = REAL_ARITH `!s:real. &0:real < &331555553832290784975` in
let ppos = REAL_ARITH `!s:real. &0:real < &138926238419618425663142097` in
let qpos = REAL_ARITH `!s:real. &0:real < &211604848815864575822` in
let mqrel = REAL_ARITH `
  ((&11532190030028907250)*(&439386112)+(&331555553832290784975)*(&49741824))*(&30902639 / &41749730) pow 2 = (&211604848815864575822)*(((&113278976) * &0 + (-- &111640576) * -- &1 / &2)) /\
  ((&11532190030028907250)*(&185892864)+(&331555553832290784975)*(&27000832))*(&30902639 / &41749730) pow 2 = (&211604848815864575822)*(((&113278976) * &1 / &2 + (-- &111640576) * &1 / &4)) /\
  (&11532190030028907250)*(&480443643)+(&331555553832290784975)*(&57079641)+(&138926238419618425663142097) = (&211604848815864575822)*(&116276001)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&113278976) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &111640576) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &116276001
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11532190030028907250` [mpos] THEN
  note `&0:real < &331555553832290784975` [npos] THEN
  note `&0:real < &138926238419618425663142097` [ppos] THEN
  note `&0:real < &211604848815864575822` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&11532190030028907250)*(&439386112)+(&331555553832290784975)*(&49741824))*s pow 2 = (&211604848815864575822)*((&113278976) * &0 + (-- &111640576) * -- &1 / &2) /\ ((&11532190030028907250)*(&185892864)+(&331555553832290784975)*(&27000832))*s pow 2 = (&211604848815864575822)*((&113278976) * &1 / &2 + (-- &111640576) * &1 / &4) /\ (&11532190030028907250)*(&480443643)+(&331555553832290784975)*(&57079641)+(&138926238419618425663142097) = (&211604848815864575822)*(&116276001)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &5842313398504459525` in
let npos = REAL_ARITH `!s:real. &0:real < &211977427263524725` in
let ppos = REAL_ARITH `!s:real. &0:real < &2180887783756198884285135` in
let qpos = REAL_ARITH `!s:real. &0:real < &29941271515392956313` in
let mqrel = REAL_ARITH `
  ((&5842313398504459525)*(&49741824)+(&211977427263524725)*(&33521664))*(&30902639 / &41749730) pow 2 = (&29941271515392956313)*(((&11419648) * &0 + (-- &10895360) * -- &1 / &2)) /\
  ((&5842313398504459525)*(&27000832)+(&211977427263524725)*(&25640960))*(&30902639 / &41749730) pow 2 = (&29941271515392956313)*(((&11419648) * &1 / &2 + (-- &10895360) * &1 / &4)) /\
  (&5842313398504459525)*(&57079641)+(&211977427263524725)*(&41914863)+(&2180887783756198884285135) = (&29941271515392956313)*(&11507295)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&11419648) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &10895360) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &11507295
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5842313398504459525` [mpos] THEN
  note `&0:real < &211977427263524725` [npos] THEN
  note `&0:real < &2180887783756198884285135` [ppos] THEN
  note `&0:real < &29941271515392956313` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5842313398504459525)*(&49741824)+(&211977427263524725)*(&33521664))*s pow 2 = (&29941271515392956313)*((&11419648) * &0 + (-- &10895360) * -- &1 / &2) /\ ((&5842313398504459525)*(&27000832)+(&211977427263524725)*(&25640960))*s pow 2 = (&29941271515392956313)*((&11419648) * &1 / &2 + (-- &10895360) * &1 / &4) /\ (&5842313398504459525)*(&57079641)+(&211977427263524725)*(&41914863)+(&2180887783756198884285135) = (&29941271515392956313)*(&11507295)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &457983748195404475` in
let npos = REAL_ARITH `!s:real. &0:real < &3313083194604814675` in
let ppos = REAL_ARITH `!s:real. &0:real < &280129842114597934682904` in
let qpos = REAL_ARITH `!s:real. &0:real < &7425870803549760096` in
let mqrel = REAL_ARITH `
  ((&457983748195404475)*(&33521664)+(&3313083194604814675)*(&1867776))*(&30902639 / &41749730) pow 2 = (&7425870803549760096)*(((&4050944) * &0 + (-- &3178496) * -- &1 / &2)) /\
  ((&457983748195404475)*(&25640960)+(&3313083194604814675)*(&1490944))*(&30902639 / &41749730) pow 2 = (&7425870803549760096)*(((&4050944) * &1 / &2 + (-- &3178496) * &1 / &4)) /\
  (&457983748195404475)*(&41914863)+(&3313083194604814675)*(&2368161)+(&280129842114597934682904) = (&7425870803549760096)*(&3679349)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&1867776) * x + (&1490944) * y <= &2368161 ==>
  (&4050944) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &3178496) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3679349
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &457983748195404475` [mpos] THEN
  note `&0:real < &3313083194604814675` [npos] THEN
  note `&0:real < &280129842114597934682904` [ppos] THEN
  note `&0:real < &7425870803549760096` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&457983748195404475)*(&33521664)+(&3313083194604814675)*(&1867776))*s pow 2 = (&7425870803549760096)*((&4050944) * &0 + (-- &3178496) * -- &1 / &2) /\ ((&457983748195404475)*(&25640960)+(&3313083194604814675)*(&1490944))*s pow 2 = (&7425870803549760096)*((&4050944) * &1 / &2 + (-- &3178496) * &1 / &4) /\ (&457983748195404475)*(&41914863)+(&3313083194604814675)*(&2368161)+(&280129842114597934682904) = (&7425870803549760096)*(&3679349)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &5248293304724501900` in
let npos = REAL_ARITH `!s:real. &0:real < &1962662989412085400` in
let ppos = REAL_ARITH `!s:real. &0:real < &195044021999714253425339` in
let qpos = REAL_ARITH `!s:real. &0:real < &2858234479812812753` in
let mqrel = REAL_ARITH `
  ((&5248293304724501900)*(&1867776)+(&1962662989412085400)*(&7634944))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((&13631488) * &0 + (-- &9502720) * -- &1 / &2)) /\
  ((&5248293304724501900)*(&1490944)+(&1962662989412085400)*(&7815168))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((&13631488) * &1 / &2 + (-- &9502720) * &1 / &4)) /\
  (&5248293304724501900)*(&2368161)+(&1962662989412085400)*(&10605687)+(&195044021999714253425339) = (&2858234479812812753)*(&11699263)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1867776) * x + (&1490944) * y <= &2368161 ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&13631488) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &9502720) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &11699263
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5248293304724501900` [mpos] THEN
  note `&0:real < &1962662989412085400` [npos] THEN
  note `&0:real < &195044021999714253425339` [ppos] THEN
  note `&0:real < &2858234479812812753` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5248293304724501900)*(&1867776)+(&1962662989412085400)*(&7634944))*s pow 2 = (&2858234479812812753)*((&13631488) * &0 + (-- &9502720) * -- &1 / &2) /\ ((&5248293304724501900)*(&1490944)+(&1962662989412085400)*(&7815168))*s pow 2 = (&2858234479812812753)*((&13631488) * &1 / &2 + (-- &9502720) * &1 / &4) /\ (&5248293304724501900)*(&2368161)+(&1962662989412085400)*(&10605687)+(&195044021999714253425339) = (&2858234479812812753)*(&11699263)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &95035767470439726700` in
let npos = REAL_ARITH `!s:real. &0:real < &101486758344164529600` in
let ppos = REAL_ARITH `!s:real. &0:real < &6080879877492603362433583` in
let qpos = REAL_ARITH `!s:real. &0:real < &2858234479812812753` in
let mqrel = REAL_ARITH `
  ((&95035767470439726700)*(&1867776)+(&101486758344164529600)*(&7634944))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((&540934144) * &0 + (-- &365101056) * -- &1 / &2)) /\
  ((&95035767470439726700)*(&1490944)+(&101486758344164529600)*(&7815168))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((&540934144) * &1 / &2 + (-- &365101056) * &1 / &4)) /\
  (&95035767470439726700)*(&2368161)+(&101486758344164529600)*(&10605687)+(&6080879877492603362433583) = (&2858234479812812753)*(&457442411)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1867776) * x + (&1490944) * y <= &2368161 ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&540934144) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &365101056) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &457442411
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &95035767470439726700` [mpos] THEN
  note `&0:real < &101486758344164529600` [npos] THEN
  note `&0:real < &6080879877492603362433583` [ppos] THEN
  note `&0:real < &2858234479812812753` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&95035767470439726700)*(&1867776)+(&101486758344164529600)*(&7634944))*s pow 2 = (&2858234479812812753)*((&540934144) * &0 + (-- &365101056) * -- &1 / &2) /\ ((&95035767470439726700)*(&1490944)+(&101486758344164529600)*(&7815168))*s pow 2 = (&2858234479812812753)*((&540934144) * &1 / &2 + (-- &365101056) * &1 / &4) /\ (&95035767470439726700)*(&2368161)+(&101486758344164529600)*(&10605687)+(&6080879877492603362433583) = (&2858234479812812753)*(&457442411)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &25828682970625700` in
let npos = REAL_ARITH `!s:real. &0:real < &46903620609234400` in
let ppos = REAL_ARITH `!s:real. &0:real < &2521043689406692895217` in
let qpos = REAL_ARITH `!s:real. &0:real < &48703627955380371` in
let mqrel = REAL_ARITH `
  ((&25828682970625700)*(&7634944)+(&46903620609234400)*(&950272))*(&30902639 / &41749730) pow 2 = (&48703627955380371)*(((&8454144) * &0 + (-- &5439488) * -- &1 / &2)) /\
  ((&25828682970625700)*(&7815168)+(&46903620609234400)*(&1130496))*(&30902639 / &41749730) pow 2 = (&48703627955380371)*(((&8454144) * &1 / &2 + (-- &5439488) * &1 / &4)) /\
  (&25828682970625700)*(&10605687)+(&46903620609234400)*(&1407123)+(&2521043689406692895217) = (&48703627955380371)*(&7031327)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&950272) * x + (&1130496) * y <= &1407123 ==>
  (&8454144) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &5439488) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &7031327
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &25828682970625700` [mpos] THEN
  note `&0:real < &46903620609234400` [npos] THEN
  note `&0:real < &2521043689406692895217` [ppos] THEN
  note `&0:real < &48703627955380371` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&25828682970625700)*(&7634944)+(&46903620609234400)*(&950272))*s pow 2 = (&48703627955380371)*((&8454144) * &0 + (-- &5439488) * -- &1 / &2) /\ ((&25828682970625700)*(&7815168)+(&46903620609234400)*(&1130496))*s pow 2 = (&48703627955380371)*((&8454144) * &1 / &2 + (-- &5439488) * &1 / &4) /\ (&25828682970625700)*(&10605687)+(&46903620609234400)*(&1407123)+(&2521043689406692895217) = (&48703627955380371)*(&7031327)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &574767425185288775` in
let npos = REAL_ARITH `!s:real. &0:real < &108563936321749271825` in
let ppos = REAL_ARITH `!s:real. &0:real < &26287020971768862311486448` in
let qpos = REAL_ARITH `!s:real. &0:real < &95168798971007573576` in
let mqrel = REAL_ARITH `
  ((&574767425185288775)*(&438239232)+(&108563936321749271825)*(&13041664))*(&30902639 / &41749730) pow 2 = (&95168798971007573576)*(((&34471936) * &0 + (-- &19202048) * -- &1 / &2)) /\
  ((&574767425185288775)*(&539754496)+(&108563936321749271825)*(&17039360))*(&30902639 / &41749730) pow 2 = (&95168798971007573576)*(((&34471936) * &1 / &2 + (-- &19202048) * &1 / &4)) /\
  (&574767425185288775)*(&659132513)+(&108563936321749271825)*(&20256657)+(&26287020971768862311486448) = (&95168798971007573576)*(&27364823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&438239232) * x + (&539754496) * y <= &659132513 ==>
  (&13041664) * x + (&17039360) * y <= &20256657 ==>
  (&34471936) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &19202048) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &27364823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &574767425185288775` [mpos] THEN
  note `&0:real < &108563936321749271825` [npos] THEN
  note `&0:real < &26287020971768862311486448` [ppos] THEN
  note `&0:real < &95168798971007573576` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&574767425185288775)*(&438239232)+(&108563936321749271825)*(&13041664))*s pow 2 = (&95168798971007573576)*((&34471936) * &0 + (-- &19202048) * -- &1 / &2) /\ ((&574767425185288775)*(&539754496)+(&108563936321749271825)*(&17039360))*s pow 2 = (&95168798971007573576)*((&34471936) * &1 / &2 + (-- &19202048) * &1 / &4) /\ (&574767425185288775)*(&659132513)+(&108563936321749271825)*(&20256657)+(&26287020971768862311486448) = (&95168798971007573576)*(&27364823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &70485049703237930200` in
let npos = REAL_ARITH `!s:real. &0:real < &102061961529338586600` in
let ppos = REAL_ARITH `!s:real. &0:real < &89207210642451016142195` in
let qpos = REAL_ARITH `!s:real. &0:real < &71558999089814065493` in
let mqrel = REAL_ARITH `
  ((&70485049703237930200)*(&7733248)+(&102061961529338586600)*(&897024))*(&30902639 / &41749730) pow 2 = (&71558999089814065493)*(((&20946944) * &0 + (-- &9748480) * -- &1 / &2)) /\
  ((&70485049703237930200)*(&11943936)+(&102061961529338586600)*(&2035712))*(&30902639 / &41749730) pow 2 = (&71558999089814065493)*(((&20946944) * &1 / &2 + (-- &9748480) * &1 / &4)) /\
  (&70485049703237930200)*(&13225515)+(&102061961529338586600)*(&1977153)+(&89207210642451016142195) = (&71558999089814065493)*(&15848215)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&11943936) * y <= &13225515 ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&20946944) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &9748480) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &15848215
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &70485049703237930200` [mpos] THEN
  note `&0:real < &102061961529338586600` [npos] THEN
  note `&0:real < &89207210642451016142195` [ppos] THEN
  note `&0:real < &71558999089814065493` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&70485049703237930200)*(&7733248)+(&102061961529338586600)*(&897024))*s pow 2 = (&71558999089814065493)*((&20946944) * &0 + (-- &9748480) * -- &1 / &2) /\ ((&70485049703237930200)*(&11943936)+(&102061961529338586600)*(&2035712))*s pow 2 = (&71558999089814065493)*((&20946944) * &1 / &2 + (-- &9748480) * &1 / &4) /\ (&70485049703237930200)*(&13225515)+(&102061961529338586600)*(&1977153)+(&89207210642451016142195) = (&71558999089814065493)*(&15848215)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &198270794889542375` in
let npos = REAL_ARITH `!s:real. &0:real < &1306788429037344442200` in
let ppos = REAL_ARITH `!s:real. &0:real < &286647681335718750272605` in
let qpos = REAL_ARITH `!s:real. &0:real < &143117998179628130986` in
let mqrel = REAL_ARITH `
  ((&198270794889542375)*(&7733248)+(&1306788429037344442200)*(&897024))*(&30902639 / &41749730) pow 2 = (&143117998179628130986)*(((&24879104) * &0 + (-- &8986624) * -- &1 / &2)) /\
  ((&198270794889542375)*(&11943936)+(&1306788429037344442200)*(&2035712))*(&30902639 / &41749730) pow 2 = (&143117998179628130986)*(((&24879104) * &1 / &2 + (-- &8986624) * &1 / &4)) /\
  (&198270794889542375)*(&13225515)+(&1306788429037344442200)*(&1977153)+(&286647681335718750272605) = (&143117998179628130986)*(&18073405)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&11943936) * y <= &13225515 ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&24879104) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &8986624) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18073405
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &198270794889542375` [mpos] THEN
  note `&0:real < &1306788429037344442200` [npos] THEN
  note `&0:real < &286647681335718750272605` [ppos] THEN
  note `&0:real < &143117998179628130986` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&198270794889542375)*(&7733248)+(&1306788429037344442200)*(&897024))*s pow 2 = (&143117998179628130986)*((&24879104) * &0 + (-- &8986624) * -- &1 / &2) /\ ((&198270794889542375)*(&11943936)+(&1306788429037344442200)*(&2035712))*s pow 2 = (&143117998179628130986)*((&24879104) * &1 / &2 + (-- &8986624) * &1 / &4) /\ (&198270794889542375)*(&13225515)+(&1306788429037344442200)*(&1977153)+(&286647681335718750272605) = (&143117998179628130986)*(&18073405)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &1415348443519194800` in
let npos = REAL_ARITH `!s:real. &0:real < &13072799663046750` in
let ppos = REAL_ARITH `!s:real. &0:real < &512149406168526252987` in
let qpos = REAL_ARITH `!s:real. &0:real < &61354156573516131287` in
let mqrel = REAL_ARITH `
  ((&1415348443519194800)*(&1275904)+(&13072799663046750)*(&2211840))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((&131072) * &0 + (-- &32768) * -- &1 / &2)) /\
  ((&1415348443519194800)*(&4450304)+(&13072799663046750)*(&9404416))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((&131072) * &1 / &2 + (-- &32768) * &1 / &4)) /\
  (&1415348443519194800)*(&3928715)+(&13072799663046750)*(&8039969)+(&512149406168526252987) = (&61354156573516131287)*(&92351)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&131072) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &32768) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &92351
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1415348443519194800` [mpos] THEN
  note `&0:real < &13072799663046750` [npos] THEN
  note `&0:real < &512149406168526252987` [ppos] THEN
  note `&0:real < &61354156573516131287` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&1415348443519194800)*(&1275904)+(&13072799663046750)*(&2211840))*s pow 2 = (&61354156573516131287)*((&131072) * &0 + (-- &32768) * -- &1 / &2) /\ ((&1415348443519194800)*(&4450304)+(&13072799663046750)*(&9404416))*s pow 2 = (&61354156573516131287)*((&131072) * &1 / &2 + (-- &32768) * &1 / &4) /\ (&1415348443519194800)*(&3928715)+(&13072799663046750)*(&8039969)+(&512149406168526252987) = (&61354156573516131287)*(&92351)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &18420446245210407200` in
let npos = REAL_ARITH `!s:real. &0:real < &1013000787649762220100` in
let ppos = REAL_ARITH `!s:real. &0:real < &744805521851734192835451` in
let qpos = REAL_ARITH `!s:real. &0:real < &61354156573516131287` in
let mqrel = REAL_ARITH `
  ((&18420446245210407200)*(&1275904)+(&1013000787649762220100)*(&2211840))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((&191823872) * &0 + (-- &40435712) * -- &1 / &2)) /\
  ((&18420446245210407200)*(&4450304)+(&1013000787649762220100)*(&9404416))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((&191823872) * &1 / &2 + (-- &40435712) * &1 / &4)) /\
  (&18420446245210407200)*(&3928715)+(&1013000787649762220100)*(&8039969)+(&744805521851734192835451) = (&61354156573516131287)*(&133937273)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&191823872) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &40435712) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &133937273
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &18420446245210407200` [mpos] THEN
  note `&0:real < &1013000787649762220100` [npos] THEN
  note `&0:real < &744805521851734192835451` [ppos] THEN
  note `&0:real < &61354156573516131287` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&18420446245210407200)*(&1275904)+(&1013000787649762220100)*(&2211840))*s pow 2 = (&61354156573516131287)*((&191823872) * &0 + (-- &40435712) * -- &1 / &2) /\ ((&18420446245210407200)*(&4450304)+(&1013000787649762220100)*(&9404416))*s pow 2 = (&61354156573516131287)*((&191823872) * &1 / &2 + (-- &40435712) * &1 / &4) /\ (&18420446245210407200)*(&3928715)+(&1013000787649762220100)*(&8039969)+(&744805521851734192835451) = (&61354156573516131287)*(&133937273)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &16479650484325600` in
let npos = REAL_ARITH `!s:real. &0:real < &189317907847577025` in
let ppos = REAL_ARITH `!s:real. &0:real < &699264407576074963490` in
let qpos = REAL_ARITH `!s:real. &0:real < &929188823540884333` in
let mqrel = REAL_ARITH `
  ((&16479650484325600)*(&2211840)+(&189317907847577025)*(&7733248))*(&30902639 / &41749730) pow 2 = (&929188823540884333)*(((&9568256) * &0 + (-- &1769472) * -- &1 / &2)) /\
  ((&16479650484325600)*(&9404416)+(&189317907847577025)*(&38076416))*(&30902639 / &41749730) pow 2 = (&929188823540884333)*(((&9568256) * &1 / &2 + (-- &1769472) * &1 / &4)) /\
  (&16479650484325600)*(&8039969)+(&189317907847577025)*(&31944087)+(&699264407576074963490) = (&929188823540884333)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&9568256) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &1769472) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16479650484325600` [mpos] THEN
  note `&0:real < &189317907847577025` [npos] THEN
  note `&0:real < &699264407576074963490` [ppos] THEN
  note `&0:real < &929188823540884333` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&16479650484325600)*(&2211840)+(&189317907847577025)*(&7733248))*s pow 2 = (&929188823540884333)*((&9568256) * &0 + (-- &1769472) * -- &1 / &2) /\ ((&16479650484325600)*(&9404416)+(&189317907847577025)*(&38076416))*s pow 2 = (&929188823540884333)*((&9568256) * &1 / &2 + (-- &1769472) * &1 / &4) /\ (&16479650484325600)*(&8039969)+(&189317907847577025)*(&31944087)+(&699264407576074963490) = (&929188823540884333)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &19745592371054579425` in
let npos = REAL_ARITH `!s:real. &0:real < &31374719191312200` in
let ppos = REAL_ARITH `!s:real. &0:real < &93608349293876871983458` in
let qpos = REAL_ARITH `!s:real. &0:real < &214312197546325425857` in
let mqrel = REAL_ARITH `
  ((&19745592371054579425)*(&1966080)+(&31374719191312200)*(-- &11730944))*(&30902639 / &41749730) pow 2 = (&214312197546325425857)*(((&5767168) * &0 + (-- &196608) * -- &1 / &2)) /\
  ((&19745592371054579425)*(&55902208)+(&31374719191312200)*(&156696576))*(&30902639 / &41749730) pow 2 = (&214312197546325425857)*(((&5767168) * &1 / &2 + (-- &196608) * &1 / &4)) /\
  (&19745592371054579425)*(&42311631)+(&31374719191312200)*(&110400449)+(&93608349293876871983458) = (&214312197546325425857)*(&3914969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1966080) * x + (&55902208) * y <= &42311631 ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (&5767168) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (-- &196608) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3914969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &19745592371054579425` [mpos] THEN
  note `&0:real < &31374719191312200` [npos] THEN
  note `&0:real < &93608349293876871983458` [ppos] THEN
  note `&0:real < &214312197546325425857` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&19745592371054579425)*(&1966080)+(&31374719191312200)*(-- &11730944))*s pow 2 = (&214312197546325425857)*((&5767168) * &0 + (-- &196608) * -- &1 / &2) /\ ((&19745592371054579425)*(&55902208)+(&31374719191312200)*(&156696576))*s pow 2 = (&214312197546325425857)*((&5767168) * &1 / &2 + (-- &196608) * &1 / &4) /\ (&19745592371054579425)*(&42311631)+(&31374719191312200)*(&110400449)+(&93608349293876871983458) = (&214312197546325425857)*(&3914969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &242564839075857156155` in
let npos = REAL_ARITH `!s:real. &0:real < &344860455111173265` in
let ppos = REAL_ARITH `!s:real. &0:real < &2437979017596068594797746` in
let qpos = REAL_ARITH `!s:real. &0:real < &97164692744081004466` in
let mqrel = REAL_ARITH `
  ((&242564839075857156155)*(-- &11730944)+(&344860455111173265)*(-- &22740992))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((&413007872) * &0 + (&32178176) * -- &1 / &2)) /\
  ((&242564839075857156155)*(&156696576)+(&344860455111173265)*(&117506048))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((&413007872) * &1 / &2 + (&32178176) * &1 / &4)) /\
  (&242564839075857156155)*(&110400449)+(&344860455111173265)*(&77682557)+(&2437979017596068594797746) = (&97164692744081004466)*(&275907781)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (&413007872) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&32178176) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &275907781
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &242564839075857156155` [mpos] THEN
  note `&0:real < &344860455111173265` [npos] THEN
  note `&0:real < &2437979017596068594797746` [ppos] THEN
  note `&0:real < &97164692744081004466` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&242564839075857156155)*(-- &11730944)+(&344860455111173265)*(-- &22740992))*s pow 2 = (&97164692744081004466)*((&413007872) * &0 + (&32178176) * -- &1 / &2) /\ ((&242564839075857156155)*(&156696576)+(&344860455111173265)*(&117506048))*s pow 2 = (&97164692744081004466)*((&413007872) * &1 / &2 + (&32178176) * &1 / &4) /\ (&242564839075857156155)*(&110400449)+(&344860455111173265)*(&77682557)+(&2437979017596068594797746) = (&97164692744081004466)*(&275907781)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &178400139401711315` in
let npos = REAL_ARITH `!s:real. &0:real < &26740063102771112545` in
let ppos = REAL_ARITH `!s:real. &0:real < &189275354806787656639026` in
let qpos = REAL_ARITH `!s:real. &0:real < &97164692744081004466` in
let mqrel = REAL_ARITH `
  ((&178400139401711315)*(-- &11730944)+(&26740063102771112545)*(-- &22740992))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((&32309248) * &0 + (&6881280) * -- &1 / &2)) /\
  ((&178400139401711315)*(&156696576)+(&26740063102771112545)*(&117506048))*(&30902639 / &41749730) pow 2 = (&97164692744081004466)*(((&32309248) * &1 / &2 + (&6881280) * &1 / &4)) /\
  (&178400139401711315)*(&110400449)+(&26740063102771112545)*(&77682557)+(&189275354806787656639026) = (&97164692744081004466)*(&21583161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (&32309248) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&6881280) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &21583161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &178400139401711315` [mpos] THEN
  note `&0:real < &26740063102771112545` [npos] THEN
  note `&0:real < &189275354806787656639026` [ppos] THEN
  note `&0:real < &97164692744081004466` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&178400139401711315)*(-- &11730944)+(&26740063102771112545)*(-- &22740992))*s pow 2 = (&97164692744081004466)*((&32309248) * &0 + (&6881280) * -- &1 / &2) /\ ((&178400139401711315)*(&156696576)+(&26740063102771112545)*(&117506048))*s pow 2 = (&97164692744081004466)*((&32309248) * &1 / &2 + (&6881280) * &1 / &4) /\ (&178400139401711315)*(&110400449)+(&26740063102771112545)*(&77682557)+(&189275354806787656639026) = (&97164692744081004466)*(&21583161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &23027736606456850125` in
let npos = REAL_ARITH `!s:real. &0:real < &1321224285945258200` in
let ppos = REAL_ARITH `!s:real. &0:real < &1187394392250784558472905` in
let qpos = REAL_ARITH `!s:real. &0:real < &111850269032273932804` in
let mqrel = REAL_ARITH `
  ((&23027736606456850125)*(-- &166330368)+(&1321224285945258200)*(-- &33882112))*(&30902639 / &41749730) pow 2 = (&111850269032273932804)*(((&137199616) * &0 + (&37961728) * -- &1 / &2)) /\
  ((&23027736606456850125)*(&684523520)+(&1321224285945258200)*(&135659520))*(&30902639 / &41749730) pow 2 = (&111850269032273932804)*(((&137199616) * &1 / &2 + (&37961728) * &1 / &4)) /\
  (&23027736606456850125)*(&441063407)+(&1321224285945258200)*(&87245513)+(&1187394392250784558472905) = (&111850269032273932804)*(&91847345)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &166330368) * x + (&684523520) * y <= &441063407 ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (&137199616) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&37961728) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &91847345
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &23027736606456850125` [mpos] THEN
  note `&0:real < &1321224285945258200` [npos] THEN
  note `&0:real < &1187394392250784558472905` [ppos] THEN
  note `&0:real < &111850269032273932804` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&23027736606456850125)*(-- &166330368)+(&1321224285945258200)*(-- &33882112))*s pow 2 = (&111850269032273932804)*((&137199616) * &0 + (&37961728) * -- &1 / &2) /\ ((&23027736606456850125)*(&684523520)+(&1321224285945258200)*(&135659520))*s pow 2 = (&111850269032273932804)*((&137199616) * &1 / &2 + (&37961728) * &1 / &4) /\ (&23027736606456850125)*(&441063407)+(&1321224285945258200)*(&87245513)+(&1187394392250784558472905) = (&111850269032273932804)*(&91847345)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &3921839898914025` in
let npos = REAL_ARITH `!s:real. &0:real < &5805194570370293450` in
let ppos = REAL_ARITH `!s:real. &0:real < &58699914239797360667620` in
let qpos = REAL_ARITH `!s:real. &0:real < &27962567258068483201` in
let mqrel = REAL_ARITH `
  ((&3921839898914025)*(-- &166330368)+(&5805194570370293450)*(-- &33882112))*(&30902639 / &41749730) pow 2 = (&27962567258068483201)*(((&27099136) * &0 + (&7733248) * -- &1 / &2)) /\
  ((&3921839898914025)*(&684523520)+(&5805194570370293450)*(&135659520))*(&30902639 / &41749730) pow 2 = (&27962567258068483201)*(((&27099136) * &1 / &2 + (&7733248) * &1 / &4)) /\
  (&3921839898914025)*(&441063407)+(&5805194570370293450)*(&87245513)+(&58699914239797360667620) = (&27962567258068483201)*(&18176645)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &166330368) * x + (&684523520) * y <= &441063407 ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (&27099136) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&7733248) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18176645
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3921839898914025` [mpos] THEN
  note `&0:real < &5805194570370293450` [npos] THEN
  note `&0:real < &58699914239797360667620` [ppos] THEN
  note `&0:real < &27962567258068483201` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&3921839898914025)*(-- &166330368)+(&5805194570370293450)*(-- &33882112))*s pow 2 = (&27962567258068483201)*((&27099136) * &0 + (&7733248) * -- &1 / &2) /\ ((&3921839898914025)*(&684523520)+(&5805194570370293450)*(&135659520))*s pow 2 = (&27962567258068483201)*((&27099136) * &1 / &2 + (&7733248) * &1 / &4) /\ (&3921839898914025)*(&441063407)+(&5805194570370293450)*(&87245513)+(&58699914239797360667620) = (&27962567258068483201)*(&18176645)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &14504706986139137350` in
let npos = REAL_ARITH `!s:real. &0:real < &501995507060995200` in
let ppos = REAL_ARITH `!s:real. &0:real < &171840569480246066947653` in
let qpos = REAL_ARITH `!s:real. &0:real < &35065657154776702799` in
let mqrel = REAL_ARITH `
  ((&14504706986139137350)*(-- &50659328)+(&501995507060995200)*(-- &11010048))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((&68321280) * &0 + (&23134208) * -- &1 / &2)) /\
  ((&14504706986139137350)*(&175046656)+(&501995507060995200)*(&34930688))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((&68321280) * &1 / &2 + (&23134208) * &1 / &4)) /\
  (&14504706986139137350)*(&111549985)+(&501995507060995200)*(&22163375)+(&171840569480246066947653) = (&35065657154776702799)*(&46464197)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (-- &11010048) * x + (&34930688) * y <= &22163375 ==>
  (&68321280) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&23134208) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &46464197
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &14504706986139137350` [mpos] THEN
  note `&0:real < &501995507060995200` [npos] THEN
  note `&0:real < &171840569480246066947653` [ppos] THEN
  note `&0:real < &35065657154776702799` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&14504706986139137350)*(-- &50659328)+(&501995507060995200)*(-- &11010048))*s pow 2 = (&35065657154776702799)*((&68321280) * &0 + (&23134208) * -- &1 / &2) /\ ((&14504706986139137350)*(&175046656)+(&501995507060995200)*(&34930688))*s pow 2 = (&35065657154776702799)*((&68321280) * &1 / &2 + (&23134208) * &1 / &4) /\ (&14504706986139137350)*(&111549985)+(&501995507060995200)*(&22163375)+(&171840569480246066947653) = (&35065657154776702799)*(&46464197)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &159488155889170350` in
let npos = REAL_ARITH `!s:real. &0:real < &28410243987721965325` in
let ppos = REAL_ARITH `!s:real. &0:real < &68384306930227553616868` in
let qpos = REAL_ARITH `!s:real. &0:real < &35065657154776702799` in
let mqrel = REAL_ARITH `
  ((&159488155889170350)*(-- &50659328)+(&28410243987721965325)*(-- &11010048))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((&26869760) * &0 + (&10027008) * -- &1 / &2)) /\
  ((&159488155889170350)*(&175046656)+(&28410243987721965325)*(&34930688))*(&30902639 / &41749730) pow 2 = (&35065657154776702799)*(((&26869760) * &1 / &2 + (&10027008) * &1 / &4)) /\
  (&159488155889170350)*(&111549985)+(&28410243987721965325)*(&22163375)+(&68384306930227553616868) = (&35065657154776702799)*(&18466107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (-- &11010048) * x + (&34930688) * y <= &22163375 ==>
  (&26869760) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&10027008) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18466107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &159488155889170350` [mpos] THEN
  note `&0:real < &28410243987721965325` [npos] THEN
  note `&0:real < &68384306930227553616868` [ppos] THEN
  note `&0:real < &35065657154776702799` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&159488155889170350)*(-- &50659328)+(&28410243987721965325)*(-- &11010048))*s pow 2 = (&35065657154776702799)*((&26869760) * &0 + (&10027008) * -- &1 / &2) /\ ((&159488155889170350)*(&175046656)+(&28410243987721965325)*(&34930688))*s pow 2 = (&35065657154776702799)*((&26869760) * &1 / &2 + (&10027008) * &1 / &4) /\ (&159488155889170350)*(&111549985)+(&28410243987721965325)*(&22163375)+(&68384306930227553616868) = (&35065657154776702799)*(&18466107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &22547529098834266175` in
let npos = REAL_ARITH `!s:real. &0:real < &1478097881901819200` in
let ppos = REAL_ARITH `!s:real. &0:real < &696100894965659152410479` in
let qpos = REAL_ARITH `!s:real. &0:real < &180745848154096707028` in
let mqrel = REAL_ARITH `
  ((&22547529098834266175)*(-- &145883136)+(&1478097881901819200)*(-- &3457024))*(&30902639 / &41749730) pow 2 = (&180745848154096707028)*(((&52412416) * &0 + (&19972096) * -- &1 / &2)) /\
  ((&22547529098834266175)*(&455802880)+(&1478097881901819200)*(&10452992))*(&30902639 / &41749730) pow 2 = (&180745848154096707028)*(((&52412416) * &1 / &2 + (&19972096) * &1 / &4)) /\
  (&22547529098834266175)*(&288985723)+(&1478097881901819200)*(&6651805)+(&696100894965659152410479) = (&180745848154096707028)*(&36108393)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &145883136) * x + (&455802880) * y <= &288985723 ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (&52412416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&19972096) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &36108393
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22547529098834266175` [mpos] THEN
  note `&0:real < &1478097881901819200` [npos] THEN
  note `&0:real < &696100894965659152410479` [ppos] THEN
  note `&0:real < &180745848154096707028` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&22547529098834266175)*(-- &145883136)+(&1478097881901819200)*(-- &3457024))*s pow 2 = (&180745848154096707028)*((&52412416) * &0 + (&19972096) * -- &1 / &2) /\ ((&22547529098834266175)*(&455802880)+(&1478097881901819200)*(&10452992))*s pow 2 = (&180745848154096707028)*((&52412416) * &1 / &2 + (&19972096) * &1 / &4) /\ (&22547529098834266175)*(&288985723)+(&1478097881901819200)*(&6651805)+(&696100894965659152410479) = (&180745848154096707028)*(&36108393)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &27340627519291480240` in
let npos = REAL_ARITH `!s:real. &0:real < &2701711930362995` in
let ppos = REAL_ARITH `!s:real. &0:real < &19265641541820437302675` in
let qpos = REAL_ARITH `!s:real. &0:real < &32807145779983083634` in
let mqrel = REAL_ARITH `
  ((&27340627519291480240)*(-- &3457024)+(&2701711930362995)*(-- &58130432))*(&30902639 / &41749730) pow 2 = (&32807145779983083634)*(((&7979008) * &0 + (&3162112) * -- &1 / &2)) /\
  ((&27340627519291480240)*(&10452992)+(&2701711930362995)*(&162430976))*(&30902639 / &41749730) pow 2 = (&32807145779983083634)*(((&7979008) * &1 / &2 + (&3162112) * &1 / &4)) /\
  (&27340627519291480240)*(&6651805)+(&2701711930362995)*(&104374325)+(&19265641541820437302675) = (&32807145779983083634)*(&5552625)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (&7979008) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&3162112) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5552625
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &27340627519291480240` [mpos] THEN
  note `&0:real < &2701711930362995` [npos] THEN
  note `&0:real < &19265641541820437302675` [ppos] THEN
  note `&0:real < &32807145779983083634` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&27340627519291480240)*(-- &3457024)+(&2701711930362995)*(-- &58130432))*s pow 2 = (&32807145779983083634)*((&7979008) * &0 + (&3162112) * -- &1 / &2) /\ ((&27340627519291480240)*(&10452992)+(&2701711930362995)*(&162430976))*s pow 2 = (&32807145779983083634)*((&7979008) * &1 / &2 + (&3162112) * &1 / &4) /\ (&27340627519291480240)*(&6651805)+(&2701711930362995)*(&104374325)+(&19265641541820437302675) = (&32807145779983083634)*(&5552625)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &376496630295746400` in
let npos = REAL_ARITH `!s:real. &0:real < &13639723408434210725` in
let ppos = REAL_ARITH `!s:real. &0:real < &151111857159341371236794` in
let qpos = REAL_ARITH `!s:real. &0:real < &16403572889991541817` in
let mqrel = REAL_ARITH `
  ((&376496630295746400)*(-- &3457024)+(&13639723408434210725)*(-- &58130432))*(&30902639 / &41749730) pow 2 = (&16403572889991541817)*(((&121733120) * &0 + (&53051392) * -- &1 / &2)) /\
  ((&376496630295746400)*(&10452992)+(&13639723408434210725)*(&162430976))*(&30902639 / &41749730) pow 2 = (&16403572889991541817)*(((&121733120) * &1 / &2 + (&53051392) * &1 / &4)) /\
  (&376496630295746400)*(&6651805)+(&13639723408434210725)*(&104374325)+(&151111857159341371236794) = (&16403572889991541817)*(&86950107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (&121733120) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&53051392) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &86950107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &376496630295746400` [mpos] THEN
  note `&0:real < &13639723408434210725` [npos] THEN
  note `&0:real < &151111857159341371236794` [ppos] THEN
  note `&0:real < &16403572889991541817` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&376496630295746400)*(-- &3457024)+(&13639723408434210725)*(-- &58130432))*s pow 2 = (&16403572889991541817)*((&121733120) * &0 + (&53051392) * -- &1 / &2) /\ ((&376496630295746400)*(&10452992)+(&13639723408434210725)*(&162430976))*s pow 2 = (&16403572889991541817)*((&121733120) * &1 / &2 + (&53051392) * &1 / &4) /\ (&376496630295746400)*(&6651805)+(&13639723408434210725)*(&104374325)+(&151111857159341371236794) = (&16403572889991541817)*(&86950107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &96225827999765749175` in
let npos = REAL_ARITH `!s:real. &0:real < &446218228498662400` in
let ppos = REAL_ARITH `!s:real. &0:real < &4807466056920767214602138` in
let qpos = REAL_ARITH `!s:real. &0:real < &462207934000628528321` in
let mqrel = REAL_ARITH `
  ((&96225827999765749175)*(-- &290521088)+(&446218228498662400)*(-- &14442496))*(&30902639 / &41749730) pow 2 = (&462207934000628528321)*(((&124731392) * &0 + (&66289664) * -- &1 / &2)) /\
  ((&96225827999765749175)*(&691929088)+(&446218228498662400)*(&29925376))*(&30902639 / &41749730) pow 2 = (&462207934000628528321)*(((&124731392) * &1 / &2 + (&66289664) * &1 / &4)) /\
  (&96225827999765749175)*(&457690221)+(&446218228498662400)*(&20669487)+(&4807466056920767214602138) = (&462207934000628528321)*(&95315653)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (-- &14442496) * x + (&29925376) * y <= &20669487 ==>
  (&124731392) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&66289664) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &95315653
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &96225827999765749175` [mpos] THEN
  note `&0:real < &446218228498662400` [npos] THEN
  note `&0:real < &4807466056920767214602138` [ppos] THEN
  note `&0:real < &462207934000628528321` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&96225827999765749175)*(-- &290521088)+(&446218228498662400)*(-- &14442496))*s pow 2 = (&462207934000628528321)*((&124731392) * &0 + (&66289664) * -- &1 / &2) /\ ((&96225827999765749175)*(&691929088)+(&446218228498662400)*(&29925376))*s pow 2 = (&462207934000628528321)*((&124731392) * &1 / &2 + (&66289664) * &1 / &4) /\ (&96225827999765749175)*(&457690221)+(&446218228498662400)*(&20669487)+(&4807466056920767214602138) = (&462207934000628528321)*(&95315653)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &26058447328339855` in
let npos = REAL_ARITH `!s:real. &0:real < &439441986369320993960` in
let ppos = REAL_ARITH `!s:real. &0:real < &992574538074542682790138` in
let qpos = REAL_ARITH `!s:real. &0:real < &66029704857232646903` in
let mqrel = REAL_ARITH `
  ((&26058447328339855)*(-- &290521088)+(&439441986369320993960)*(-- &14442496))*(&30902639 / &41749730) pow 2 = (&66029704857232646903)*(((&165806080) * &0 + (&105447424) * -- &1 / &2)) /\
  ((&26058447328339855)*(&691929088)+(&439441986369320993960)*(&29925376))*(&30902639 / &41749730) pow 2 = (&66029704857232646903)*(((&165806080) * &1 / &2 + (&105447424) * &1 / &4)) /\
  (&26058447328339855)*(&457690221)+(&439441986369320993960)*(&20669487)+(&992574538074542682790138) = (&66029704857232646903)*(&137755571)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (-- &14442496) * x + (&29925376) * y <= &20669487 ==>
  (&165806080) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&105447424) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &137755571
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &26058447328339855` [mpos] THEN
  note `&0:real < &439441986369320993960` [npos] THEN
  note `&0:real < &992574538074542682790138` [ppos] THEN
  note `&0:real < &66029704857232646903` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&26058447328339855)*(-- &290521088)+(&439441986369320993960)*(-- &14442496))*s pow 2 = (&66029704857232646903)*((&165806080) * &0 + (&105447424) * -- &1 / &2) /\ ((&26058447328339855)*(&691929088)+(&439441986369320993960)*(&29925376))*s pow 2 = (&66029704857232646903)*((&165806080) * &1 / &2 + (&105447424) * &1 / &4) /\ (&26058447328339855)*(&457690221)+(&439441986369320993960)*(&20669487)+(&992574538074542682790138) = (&66029704857232646903)*(&137755571)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &2171193951309897800` in
let npos = REAL_ARITH `!s:real. &0:real < &396145444334750` in
let ppos = REAL_ARITH `!s:real. &0:real < &6653437583049254535443` in
let qpos = REAL_ARITH `!s:real. &0:real < &2932722381391629791` in
let mqrel = REAL_ARITH `
  ((&2171193951309897800)*(-- &19062784)+(&396145444334750)*(-- &15433728))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((&22740992) * &0 + (&15466496) * -- &1 / &2)) /\
  ((&2171193951309897800)*(&37560320)+(&396145444334750)*(&29458432))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((&22740992) * &1 / &2 + (&15466496) * &1 / &4)) /\
  (&2171193951309897800)*(&26430931)+(&396145444334750)*(&21015329)+(&6653437583049254535443) = (&2932722381391629791)*(&19572823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &19062784) * x + (&37560320) * y <= &26430931 ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (&22740992) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&15466496) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &19572823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2171193951309897800` [mpos] THEN
  note `&0:real < &396145444334750` [npos] THEN
  note `&0:real < &6653437583049254535443` [ppos] THEN
  note `&0:real < &2932722381391629791` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&2171193951309897800)*(-- &19062784)+(&396145444334750)*(-- &15433728))*s pow 2 = (&2932722381391629791)*((&22740992) * &0 + (&15466496) * -- &1 / &2) /\ ((&2171193951309897800)*(&37560320)+(&396145444334750)*(&29458432))*s pow 2 = (&2932722381391629791)*((&22740992) * &1 / &2 + (&15466496) * &1 / &4) /\ (&2171193951309897800)*(&26430931)+(&396145444334750)*(&21015329)+(&6653437583049254535443) = (&2932722381391629791)*(&19572823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &9032116130832300` in
let npos = REAL_ARITH `!s:real. &0:real < &432075836135911825` in
let ppos = REAL_ARITH `!s:real. &0:real < &1081475302568941663188` in
let qpos = REAL_ARITH `!s:real. &0:real < &2932722381391629791` in
let mqrel = REAL_ARITH `
  ((&9032116130832300)*(-- &19062784)+(&432075836135911825)*(-- &15433728))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((&3604480) * &0 + (&2555904) * -- &1 / &2)) /\
  ((&9032116130832300)*(&37560320)+(&432075836135911825)*(&29458432))*(&30902639 / &41749730) pow 2 = (&2932722381391629791)*(((&3604480) * &1 / &2 + (&2555904) * &1 / &4)) /\
  (&9032116130832300)*(&26430931)+(&432075836135911825)*(&21015329)+(&1081475302568941663188) = (&2932722381391629791)*(&3177943)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &19062784) * x + (&37560320) * y <= &26430931 ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (&3604480) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&2555904) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3177943
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9032116130832300` [mpos] THEN
  note `&0:real < &432075836135911825` [npos] THEN
  note `&0:real < &1081475302568941663188` [ppos] THEN
  note `&0:real < &2932722381391629791` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&9032116130832300)*(-- &19062784)+(&432075836135911825)*(-- &15433728))*s pow 2 = (&2932722381391629791)*((&3604480) * &0 + (&2555904) * -- &1 / &2) /\ ((&9032116130832300)*(&37560320)+(&432075836135911825)*(&29458432))*s pow 2 = (&2932722381391629791)*((&3604480) * &1 / &2 + (&2555904) * &1 / &4) /\ (&9032116130832300)*(&26430931)+(&432075836135911825)*(&21015329)+(&1081475302568941663188) = (&2932722381391629791)*(&3177943)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &688967916961755037200` in
let npos = REAL_ARITH `!s:real. &0:real < &95867197529009500` in
let ppos = REAL_ARITH `!s:real. &0:real < &504829838004490951343993` in
let qpos = REAL_ARITH `!s:real. &0:real < &832987698651842128423` in
let mqrel = REAL_ARITH `
  ((&688967916961755037200)*(-- &5660672)+(&95867197529009500)*(-- &373096448))*(&30902639 / &41749730) pow 2 = (&832987698651842128423)*(((&5537792) * &0 + (&5177344) * -- &1 / &2)) /\
  ((&688967916961755037200)*(&8896512)+(&95867197529009500)*(&503644160))*(&30902639 / &41749730) pow 2 = (&832987698651842128423)*(((&5537792) * &1 / &2 + (&5177344) * &1 / &4)) /\
  (&688967916961755037200)*(&6951751)+(&95867197529009500)*(&426281637)+(&504829838004490951343993) = (&832987698651842128423)*(&5799491)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (-- &373096448) * x + (&503644160) * y <= &426281637 ==>
  (&5537792) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&5177344) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5799491
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &688967916961755037200` [mpos] THEN
  note `&0:real < &95867197529009500` [npos] THEN
  note `&0:real < &504829838004490951343993` [ppos] THEN
  note `&0:real < &832987698651842128423` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&688967916961755037200)*(-- &5660672)+(&95867197529009500)*(-- &373096448))*s pow 2 = (&832987698651842128423)*((&5537792) * &0 + (&5177344) * -- &1 / &2) /\ ((&688967916961755037200)*(&8896512)+(&95867197529009500)*(&503644160))*s pow 2 = (&832987698651842128423)*((&5537792) * &1 / &2 + (&5177344) * &1 / &4) /\ (&688967916961755037200)*(&6951751)+(&95867197529009500)*(&426281637)+(&504829838004490951343993) = (&832987698651842128423)*(&5799491)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &4263475730108313400` in
let npos = REAL_ARITH `!s:real. &0:real < &99034736887365727525` in
let ppos = REAL_ARITH `!s:real. &0:real < &4460222336512199008753918` in
let qpos = REAL_ARITH `!s:real. &0:real < &118998242664548875489` in
let mqrel = REAL_ARITH `
  ((&4263475730108313400)*(-- &5660672)+(&99034736887365727525)*(-- &373096448))*(&30902639 / &41749730) pow 2 = (&118998242664548875489)*(((&289406976) * &0 + (&340459520) * -- &1 / &2)) /\
  ((&4263475730108313400)*(&8896512)+(&99034736887365727525)*(&503644160))*(&30902639 / &41749730) pow 2 = (&118998242664548875489)*(((&289406976) * &1 / &2 + (&340459520) * &1 / &4)) /\
  (&4263475730108313400)*(&6951751)+(&99034736887365727525)*(&426281637)+(&4460222336512199008753918) = (&118998242664548875489)*(&355053887)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (-- &373096448) * x + (&503644160) * y <= &426281637 ==>
  (&289406976) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&340459520) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &355053887
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4263475730108313400` [mpos] THEN
  note `&0:real < &99034736887365727525` [npos] THEN
  note `&0:real < &4460222336512199008753918` [ppos] THEN
  note `&0:real < &118998242664548875489` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&4263475730108313400)*(-- &5660672)+(&99034736887365727525)*(-- &373096448))*s pow 2 = (&118998242664548875489)*((&289406976) * &0 + (&340459520) * -- &1 / &2) /\ ((&4263475730108313400)*(&8896512)+(&99034736887365727525)*(&503644160))*s pow 2 = (&118998242664548875489)*((&289406976) * &1 / &2 + (&340459520) * &1 / &4) /\ (&4263475730108313400)*(&6951751)+(&99034736887365727525)*(&426281637)+(&4460222336512199008753918) = (&118998242664548875489)*(&355053887)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &5679695693605044650` in
let npos = REAL_ARITH `!s:real. &0:real < &4793359876450475` in
let ppos = REAL_ARITH `!s:real. &0:real < &4150286826982837138483` in
let qpos = REAL_ARITH `!s:real. &0:real < &13715323621473978202` in
let mqrel = REAL_ARITH `
  ((&5679695693605044650)*(-- &5701632)+(&4793359876450475)*(-- &46596096))*(&30902639 / &41749730) pow 2 = (&13715323621473978202)*(((&2048000) * &0 + (&2605056) * -- &1 / &2)) /\
  ((&5679695693605044650)*(&7340032)+(&4793359876450475)*(&51871744))*(&30902639 / &41749730) pow 2 = (&13715323621473978202)*(((&2048000) * &1 / &2 + (&2605056) * &1 / &4)) /\
  (&5679695693605044650)*(&6407825)+(&4793359876450475)*(&49963991)+(&4150286826982837138483) = (&13715323621473978202)*(&2671329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5701632) * x + (&7340032) * y <= &6407825 ==>
  (-- &46596096) * x + (&51871744) * y <= &49963991 ==>
  (&2048000) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&2605056) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &2671329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5679695693605044650` [mpos] THEN
  note `&0:real < &4793359876450475` [npos] THEN
  note `&0:real < &4150286826982837138483` [ppos] THEN
  note `&0:real < &13715323621473978202` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5679695693605044650)*(-- &5701632)+(&4793359876450475)*(-- &46596096))*s pow 2 = (&13715323621473978202)*((&2048000) * &0 + (&2605056) * -- &1 / &2) /\ ((&5679695693605044650)*(&7340032)+(&4793359876450475)*(&51871744))*s pow 2 = (&13715323621473978202)*((&2048000) * &1 / &2 + (&2605056) * &1 / &4) /\ (&5679695693605044650)*(&6407825)+(&4793359876450475)*(&49963991)+(&4150286826982837138483) = (&13715323621473978202)*(&2671329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &644053263399436550` in
let npos = REAL_ARITH `!s:real. &0:real < &17059132040298472300` in
let ppos = REAL_ARITH `!s:real. &0:real < &96185408735684562770997` in
let qpos = REAL_ARITH `!s:real. &0:real < &20572985432210967303` in
let mqrel = REAL_ARITH `
  ((&644053263399436550)*(-- &5701632)+(&17059132040298472300)*(-- &46596096))*(&30902639 / &41749730) pow 2 = (&20572985432210967303)*(((&26116096) * &0 + (&42532864) * -- &1 / &2)) /\
  ((&644053263399436550)*(&7340032)+(&17059132040298472300)*(&51871744))*(&30902639 / &41749730) pow 2 = (&20572985432210967303)*(((&26116096) * &1 / &2 + (&42532864) * &1 / &4)) /\
  (&644053263399436550)*(&6407825)+(&17059132040298472300)*(&49963991)+(&96185408735684562770997) = (&20572985432210967303)*(&41635449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5701632) * x + (&7340032) * y <= &6407825 ==>
  (-- &46596096) * x + (&51871744) * y <= &49963991 ==>
  (&26116096) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&42532864) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &41635449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &644053263399436550` [mpos] THEN
  note `&0:real < &17059132040298472300` [npos] THEN
  note `&0:real < &96185408735684562770997` [ppos] THEN
  note `&0:real < &20572985432210967303` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&644053263399436550)*(-- &5701632)+(&17059132040298472300)*(-- &46596096))*s pow 2 = (&20572985432210967303)*((&26116096) * &0 + (&42532864) * -- &1 / &2) /\ ((&644053263399436550)*(&7340032)+(&17059132040298472300)*(&51871744))*s pow 2 = (&20572985432210967303)*((&26116096) * &1 / &2 + (&42532864) * &1 / &4) /\ (&644053263399436550)*(&6407825)+(&17059132040298472300)*(&49963991)+(&96185408735684562770997) = (&20572985432210967303)*(&41635449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &880602522982346113675` in
let npos = REAL_ARITH `!s:real. &0:real < &692422622152709525` in
let ppos = REAL_ARITH `!s:real. &0:real < &8298273780757572969887730` in
let qpos = REAL_ARITH `!s:real. &0:real < &529225081040329083138` in
let mqrel = REAL_ARITH `
  ((&880602522982346113675)*(-- &84901888)+(&692422622152709525)*(-- &134447104))*(&30902639 / &41749730) pow 2 = (&529225081040329083138)*(((&66748416) * &0 + (&154992640) * -- &1 / &2)) /\
  ((&880602522982346113675)*(&79036416)+(&692422622152709525)*(&97124352))*(&30902639 / &41749730) pow 2 = (&529225081040329083138)*(((&66748416) * &1 / &2 + (&154992640) * &1 / &4)) /\
  (&880602522982346113675)*(&86789633)+(&692422622152709525)*(&131957561)+(&8298273780757572969887730) = (&529225081040329083138)*(&144601685)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (&66748416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&154992640) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &144601685
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &880602522982346113675` [mpos] THEN
  note `&0:real < &692422622152709525` [npos] THEN
  note `&0:real < &8298273780757572969887730` [ppos] THEN
  note `&0:real < &529225081040329083138` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&880602522982346113675)*(-- &84901888)+(&692422622152709525)*(-- &134447104))*s pow 2 = (&529225081040329083138)*((&66748416) * &0 + (&154992640) * -- &1 / &2) /\ ((&880602522982346113675)*(&79036416)+(&692422622152709525)*(&97124352))*s pow 2 = (&529225081040329083138)*((&66748416) * &1 / &2 + (&154992640) * &1 / &4) /\ (&880602522982346113675)*(&86789633)+(&692422622152709525)*(&131957561)+(&8298273780757572969887730) = (&529225081040329083138)*(&144601685)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &60570638438783275` in
let npos = REAL_ARITH `!s:real. &0:real < &251867966228067745325` in
let ppos = REAL_ARITH `!s:real. &0:real < &3605290306696362904653240` in
let qpos = REAL_ARITH `!s:real. &0:real < &2116900324161316332552` in
let mqrel = REAL_ARITH `
  ((&60570638438783275)*(-- &84901888)+(&251867966228067745325)*(-- &134447104))*(&30902639 / &41749730) pow 2 = (&2116900324161316332552)*(((&3899392) * &0 + (&17530880) * -- &1 / &2)) /\
  ((&60570638438783275)*(&79036416)+(&251867966228067745325)*(&97124352))*(&30902639 / &41749730) pow 2 = (&2116900324161316332552)*(((&3899392) * &1 / &2 + (&17530880) * &1 / &4)) /\
  (&60570638438783275)*(&86789633)+(&251867966228067745325)*(&131957561)+(&3605290306696362904653240) = (&2116900324161316332552)*(&15704445)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (&3899392) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&17530880) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &15704445
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &60570638438783275` [mpos] THEN
  note `&0:real < &251867966228067745325` [npos] THEN
  note `&0:real < &3605290306696362904653240` [ppos] THEN
  note `&0:real < &2116900324161316332552` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&60570638438783275)*(-- &84901888)+(&251867966228067745325)*(-- &134447104))*s pow 2 = (&2116900324161316332552)*((&3899392) * &0 + (&17530880) * -- &1 / &2) /\ ((&60570638438783275)*(&79036416)+(&251867966228067745325)*(&97124352))*s pow 2 = (&2116900324161316332552)*((&3899392) * &1 / &2 + (&17530880) * &1 / &4) /\ (&60570638438783275)*(&86789633)+(&251867966228067745325)*(&131957561)+(&3605290306696362904653240) = (&2116900324161316332552)*(&15704445)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &233567353979768600` in
let npos = REAL_ARITH `!s:real. &0:real < &1108200400875978799400` in
let ppos = REAL_ARITH `!s:real. &0:real < &11774469059809228630192881` in
let qpos = REAL_ARITH `!s:real. &0:real < &1331086386563197332887` in
let mqrel = REAL_ARITH `
  ((&233567353979768600)*(-- &134447104)+(&1108200400875978799400)*(-- &100401152))*(&30902639 / &41749730) pow 2 = (&1331086386563197332887)*(((&65536) * &0 + (&91619328) * -- &1 / &2)) /\
  ((&233567353979768600)*(&97124352)+(&1108200400875978799400)*(&50266112))*(&30902639 / &41749730) pow 2 = (&1331086386563197332887)*(((&65536) * &1 / &2 + (&91619328) * &1 / &4)) /\
  (&233567353979768600)*(&131957561)+(&1108200400875978799400)*(&95584823)+(&11774469059809228630192881) = (&1331086386563197332887)*(&79611463)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (&65536) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&91619328) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &79611463
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &233567353979768600` [mpos] THEN
  note `&0:real < &1108200400875978799400` [npos] THEN
  note `&0:real < &11774469059809228630192881` [ppos] THEN
  note `&0:real < &1331086386563197332887` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&233567353979768600)*(-- &134447104)+(&1108200400875978799400)*(-- &100401152))*s pow 2 = (&1331086386563197332887)*((&65536) * &0 + (&91619328) * -- &1 / &2) /\ ((&233567353979768600)*(&97124352)+(&1108200400875978799400)*(&50266112))*s pow 2 = (&1331086386563197332887)*((&65536) * &1 / &2 + (&91619328) * &1 / &4) /\ (&233567353979768600)*(&131957561)+(&1108200400875978799400)*(&95584823)+(&11774469059809228630192881) = (&1331086386563197332887)*(&79611463)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &63573024761396345250` in
let npos = REAL_ARITH `!s:real. &0:real < &3544471748640742150` in
let ppos = REAL_ARITH `!s:real. &0:real < &370422155709931954307417` in
let qpos = REAL_ARITH `!s:real. &0:real < &38574228313758418153` in
let mqrel = REAL_ARITH `
  ((&63573024761396345250)*(-- &64782336)+(&3544471748640742150)*(-- &12943360))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((-- &9371648) * &0 + (&118292480) * -- &1 / &2)) /\
  ((&63573024761396345250)*(&27295744)+(&3544471748640742150)*(&4784128))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((-- &9371648) * &1 / &2 + (&118292480) * &1 / &4)) /\
  (&63573024761396345250)*(&61112343)+(&3544471748640742150)*(&12157023)+(&370422155709931954307417) = (&38574228313758418153)*(&101844089)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &64782336) * x + (&27295744) * y <= &61112343 ==>
  (-- &12943360) * x + (&4784128) * y <= &12157023 ==>
  (-- &9371648) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&118292480) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &101844089
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &63573024761396345250` [mpos] THEN
  note `&0:real < &3544471748640742150` [npos] THEN
  note `&0:real < &370422155709931954307417` [ppos] THEN
  note `&0:real < &38574228313758418153` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&63573024761396345250)*(-- &64782336)+(&3544471748640742150)*(-- &12943360))*s pow 2 = (&38574228313758418153)*((-- &9371648) * &0 + (&118292480) * -- &1 / &2) /\ ((&63573024761396345250)*(&27295744)+(&3544471748640742150)*(&4784128))*s pow 2 = (&38574228313758418153)*((-- &9371648) * &1 / &2 + (&118292480) * &1 / &4) /\ (&63573024761396345250)*(&61112343)+(&3544471748640742150)*(&12157023)+(&370422155709931954307417) = (&38574228313758418153)*(&101844089)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &161231195844243250` in
let npos = REAL_ARITH `!s:real. &0:real < &15235040727314682450` in
let ppos = REAL_ARITH `!s:real. &0:real < &18458396115716671583581` in
let qpos = REAL_ARITH `!s:real. &0:real < &38574228313758418153` in
let mqrel = REAL_ARITH `
  ((&161231195844243250)*(-- &64782336)+(&15235040727314682450)*(-- &12943360))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((-- &753664) * &0 + (&5898240) * -- &1 / &2)) /\
  ((&161231195844243250)*(&27295744)+(&15235040727314682450)*(&4784128))*(&30902639 / &41749730) pow 2 = (&38574228313758418153)*(((-- &753664) * &1 / &2 + (&5898240) * &1 / &4)) /\
  (&161231195844243250)*(&61112343)+(&15235040727314682450)*(&12157023)+(&18458396115716671583581) = (&38574228313758418153)*(&5057377)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &64782336) * x + (&27295744) * y <= &61112343 ==>
  (-- &12943360) * x + (&4784128) * y <= &12157023 ==>
  (-- &753664) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&5898240) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &5057377
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &161231195844243250` [mpos] THEN
  note `&0:real < &15235040727314682450` [npos] THEN
  note `&0:real < &18458396115716671583581` [ppos] THEN
  note `&0:real < &38574228313758418153` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&161231195844243250)*(-- &64782336)+(&15235040727314682450)*(-- &12943360))*s pow 2 = (&38574228313758418153)*((-- &753664) * &0 + (&5898240) * -- &1 / &2) /\ ((&161231195844243250)*(&27295744)+(&15235040727314682450)*(&4784128))*s pow 2 = (&38574228313758418153)*((-- &753664) * &1 / &2 + (&5898240) * &1 / &4) /\ (&161231195844243250)*(&61112343)+(&15235040727314682450)*(&12157023)+(&18458396115716671583581) = (&38574228313758418153)*(&5057377)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &15093418730965009325` in
let npos = REAL_ARITH `!s:real. &0:real < &5874480408584441225` in
let ppos = REAL_ARITH `!s:real. &0:real < &1486521386839343548264789` in
let qpos = REAL_ARITH `!s:real. &0:real < &18147353765413591963` in
let mqrel = REAL_ARITH `
  ((&15093418730965009325)*(-- &1012072448)+(&5874480408584441225)*(-- &3866624))*(&30902639 / &41749730) pow 2 = (&18147353765413591963)*(((-- &129499136) * &0 + (&923729920) * -- &1 / &2)) /\
  ((&15093418730965009325)*(&364183552)+(&5874480408584441225)*(&1310720))*(&30902639 / &41749730) pow 2 = (&18147353765413591963)*(((-- &129499136) * &1 / &2 + (&923729920) * &1 / &4)) /\
  (&15093418730965009325)*(&949861697)+(&5874480408584441225)*(&3642043)+(&1486521386839343548264789) = (&18147353765413591963)*(&791274703)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1012072448) * x + (&364183552) * y <= &949861697 ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &129499136) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&923729920) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &791274703
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &15093418730965009325` [mpos] THEN
  note `&0:real < &5874480408584441225` [npos] THEN
  note `&0:real < &1486521386839343548264789` [ppos] THEN
  note `&0:real < &18147353765413591963` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&15093418730965009325)*(-- &1012072448)+(&5874480408584441225)*(-- &3866624))*s pow 2 = (&18147353765413591963)*((-- &129499136) * &0 + (&923729920) * -- &1 / &2) /\ ((&15093418730965009325)*(&364183552)+(&5874480408584441225)*(&1310720))*s pow 2 = (&18147353765413591963)*((-- &129499136) * &1 / &2 + (&923729920) * &1 / &4) /\ (&15093418730965009325)*(&949861697)+(&5874480408584441225)*(&3642043)+(&1486521386839343548264789) = (&18147353765413591963)*(&791274703)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &20480719472106575` in
let npos = REAL_ARITH `!s:real. &0:real < &115622376619816980375` in
let ppos = REAL_ARITH `!s:real. &0:real < &45608083068703861137992` in
let qpos = REAL_ARITH `!s:real. &0:real < &72589415061654367852` in
let mqrel = REAL_ARITH `
  ((&20480719472106575)*(-- &1012072448)+(&115622376619816980375)*(-- &3866624))*(&30902639 / &41749730) pow 2 = (&72589415061654367852)*(((-- &1130496) * &0 + (&7061504) * -- &1 / &2)) /\
  ((&20480719472106575)*(&364183552)+(&115622376619816980375)*(&1310720))*(&30902639 / &41749730) pow 2 = (&72589415061654367852)*(((-- &1130496) * &1 / &2 + (&7061504) * &1 / &4)) /\
  (&20480719472106575)*(&949861697)+(&115622376619816980375)*(&3642043)+(&45608083068703861137992) = (&72589415061654367852)*(&6069771)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1012072448) * x + (&364183552) * y <= &949861697 ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &1130496) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&7061504) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &6069771
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20480719472106575` [mpos] THEN
  note `&0:real < &115622376619816980375` [npos] THEN
  note `&0:real < &45608083068703861137992` [ppos] THEN
  note `&0:real < &72589415061654367852` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&20480719472106575)*(-- &1012072448)+(&115622376619816980375)*(-- &3866624))*s pow 2 = (&72589415061654367852)*((-- &1130496) * &0 + (&7061504) * -- &1 / &2) /\ ((&20480719472106575)*(&364183552)+(&115622376619816980375)*(&1310720))*s pow 2 = (&72589415061654367852)*((-- &1130496) * &1 / &2 + (&7061504) * &1 / &4) /\ (&20480719472106575)*(&949861697)+(&115622376619816980375)*(&3642043)+(&45608083068703861137992) = (&72589415061654367852)*(&6069771)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &28673007260949205` in
let npos = REAL_ARITH `!s:real. &0:real < &757960924463450565` in
let ppos = REAL_ARITH `!s:real. &0:real < &3266542137660967988856` in
let qpos = REAL_ARITH `!s:real. &0:real < &29275655266669424576` in
let mqrel = REAL_ARITH `
  ((&28673007260949205)*(-- &3866624)+(&757960924463450565)*(-- &39124992))*(&30902639 / &41749730) pow 2 = (&29275655266669424576)*(((-- &481280) * &0 + (&1114112) * -- &1 / &2)) /\
  ((&28673007260949205)*(&1310720)+(&757960924463450565)*(&2621440))*(&30902639 / &41749730) pow 2 = (&29275655266669424576)*(((-- &481280) * &1 / &2 + (&1114112) * &1 / &4)) /\
  (&28673007260949205)*(&3642043)+(&757960924463450565)*(&38657149)+(&3266542137660967988856) = (&29275655266669424576)*(&1004531)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &481280) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&1114112) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &1004531
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &28673007260949205` [mpos] THEN
  note `&0:real < &757960924463450565` [npos] THEN
  note `&0:real < &3266542137660967988856` [ppos] THEN
  note `&0:real < &29275655266669424576` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&28673007260949205)*(-- &3866624)+(&757960924463450565)*(-- &39124992))*s pow 2 = (&29275655266669424576)*((-- &481280) * &0 + (&1114112) * -- &1 / &2) /\ ((&28673007260949205)*(&1310720)+(&757960924463450565)*(&2621440))*s pow 2 = (&29275655266669424576)*((-- &481280) * &1 / &2 + (&1114112) * &1 / &4) /\ (&28673007260949205)*(&3642043)+(&757960924463450565)*(&38657149)+(&3266542137660967988856) = (&29275655266669424576)*(&1004531)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &6213849852077146086775` in
let npos = REAL_ARITH `!s:real. &0:real < &50112398708345875` in
let ppos = REAL_ARITH `!s:real. &0:real < &4002323904669878936888940` in
let qpos = REAL_ARITH `!s:real. &0:real < &598391872521746524526` in
let mqrel = REAL_ARITH `
  ((&6213849852077146086775)*(-- &5865472)+(&50112398708345875)*(-- &439386112))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((-- &44220416) * &0 + (&66781184) * -- &1 / &2)) /\
  ((&6213849852077146086775)*(-- &950272)+(&50112398708345875)*(-- &185892864))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((-- &44220416) * &1 / &2 + (&66781184) * &1 / &4)) /\
  (&6213849852077146086775)*(&6035371)+(&50112398708345875)*(&480443643)+(&4002323904669878936888940) = (&598391872521746524526)*(&62719715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &44220416) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&66781184) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &62719715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &6213849852077146086775` [mpos] THEN
  note `&0:real < &50112398708345875` [npos] THEN
  note `&0:real < &4002323904669878936888940` [ppos] THEN
  note `&0:real < &598391872521746524526` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&6213849852077146086775)*(-- &5865472)+(&50112398708345875)*(-- &439386112))*s pow 2 = (&598391872521746524526)*((-- &44220416) * &0 + (&66781184) * -- &1 / &2) /\ ((&6213849852077146086775)*(-- &950272)+(&50112398708345875)*(-- &185892864))*s pow 2 = (&598391872521746524526)*((-- &44220416) * &1 / &2 + (&66781184) * &1 / &4) /\ (&6213849852077146086775)*(&6035371)+(&50112398708345875)*(&480443643)+(&4002323904669878936888940) = (&598391872521746524526)*(&62719715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &1573055648334269414425` in
let npos = REAL_ARITH `!s:real. &0:real < &86151928579421923625` in
let ppos = REAL_ARITH `!s:real. &0:real < &3922147310120543526848080` in
let qpos = REAL_ARITH `!s:real. &0:real < &598391872521746524526` in
let mqrel = REAL_ARITH `
  ((&1573055648334269414425)*(-- &5865472)+(&86151928579421923625)*(-- &439386112))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((-- &75169792) * &0 + (&86212608) * -- &1 / &2)) /\
  ((&1573055648334269414425)*(-- &950272)+(&86151928579421923625)*(-- &185892864))*(&30902639 / &41749730) pow 2 = (&598391872521746524526)*(((-- &75169792) * &1 / &2 + (&86212608) * &1 / &4)) /\
  (&1573055648334269414425)*(&6035371)+(&86151928579421923625)*(&480443643)+(&3922147310120543526848080) = (&598391872521746524526)*(&85043005)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &75169792) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&86212608) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &85043005
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1573055648334269414425` [mpos] THEN
  note `&0:real < &86151928579421923625` [npos] THEN
  note `&0:real < &3922147310120543526848080` [ppos] THEN
  note `&0:real < &598391872521746524526` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&1573055648334269414425)*(-- &5865472)+(&86151928579421923625)*(-- &439386112))*s pow 2 = (&598391872521746524526)*((-- &75169792) * &0 + (&86212608) * -- &1 / &2) /\ ((&1573055648334269414425)*(-- &950272)+(&86151928579421923625)*(-- &185892864))*s pow 2 = (&598391872521746524526)*((-- &75169792) * &1 / &2 + (&86212608) * &1 / &4) /\ (&1573055648334269414425)*(&6035371)+(&86151928579421923625)*(&480443643)+(&3922147310120543526848080) = (&598391872521746524526)*(&85043005)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &11532190030028907250` in
let npos = REAL_ARITH `!s:real. &0:real < &331555553832290784975` in
let ppos = REAL_ARITH `!s:real. &0:real < &138926238419618425663142097` in
let qpos = REAL_ARITH `!s:real. &0:real < &211604848815864575822` in
let mqrel = REAL_ARITH `
  ((&11532190030028907250)*(-- &439386112)+(&331555553832290784975)*(-- &49741824))*(&30902639 / &41749730) pow 2 = (&211604848815864575822)*(((-- &113278976) * &0 + (&111640576) * -- &1 / &2)) /\
  ((&11532190030028907250)*(-- &185892864)+(&331555553832290784975)*(-- &27000832))*(&30902639 / &41749730) pow 2 = (&211604848815864575822)*(((-- &113278976) * &1 / &2 + (&111640576) * &1 / &4)) /\
  (&11532190030028907250)*(&480443643)+(&331555553832290784975)*(&57079641)+(&138926238419618425663142097) = (&211604848815864575822)*(&116276001)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &113278976) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&111640576) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &116276001
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11532190030028907250` [mpos] THEN
  note `&0:real < &331555553832290784975` [npos] THEN
  note `&0:real < &138926238419618425663142097` [ppos] THEN
  note `&0:real < &211604848815864575822` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&11532190030028907250)*(-- &439386112)+(&331555553832290784975)*(-- &49741824))*s pow 2 = (&211604848815864575822)*((-- &113278976) * &0 + (&111640576) * -- &1 / &2) /\ ((&11532190030028907250)*(-- &185892864)+(&331555553832290784975)*(-- &27000832))*s pow 2 = (&211604848815864575822)*((-- &113278976) * &1 / &2 + (&111640576) * &1 / &4) /\ (&11532190030028907250)*(&480443643)+(&331555553832290784975)*(&57079641)+(&138926238419618425663142097) = (&211604848815864575822)*(&116276001)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &5842313398504459525` in
let npos = REAL_ARITH `!s:real. &0:real < &211977427263524725` in
let ppos = REAL_ARITH `!s:real. &0:real < &2180887783756198884285135` in
let qpos = REAL_ARITH `!s:real. &0:real < &29941271515392956313` in
let mqrel = REAL_ARITH `
  ((&5842313398504459525)*(-- &49741824)+(&211977427263524725)*(-- &33521664))*(&30902639 / &41749730) pow 2 = (&29941271515392956313)*(((-- &11419648) * &0 + (&10895360) * -- &1 / &2)) /\
  ((&5842313398504459525)*(-- &27000832)+(&211977427263524725)*(-- &25640960))*(&30902639 / &41749730) pow 2 = (&29941271515392956313)*(((-- &11419648) * &1 / &2 + (&10895360) * &1 / &4)) /\
  (&5842313398504459525)*(&57079641)+(&211977427263524725)*(&41914863)+(&2180887783756198884285135) = (&29941271515392956313)*(&11507295)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &11419648) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&10895360) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &11507295
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5842313398504459525` [mpos] THEN
  note `&0:real < &211977427263524725` [npos] THEN
  note `&0:real < &2180887783756198884285135` [ppos] THEN
  note `&0:real < &29941271515392956313` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5842313398504459525)*(-- &49741824)+(&211977427263524725)*(-- &33521664))*s pow 2 = (&29941271515392956313)*((-- &11419648) * &0 + (&10895360) * -- &1 / &2) /\ ((&5842313398504459525)*(-- &27000832)+(&211977427263524725)*(-- &25640960))*s pow 2 = (&29941271515392956313)*((-- &11419648) * &1 / &2 + (&10895360) * &1 / &4) /\ (&5842313398504459525)*(&57079641)+(&211977427263524725)*(&41914863)+(&2180887783756198884285135) = (&29941271515392956313)*(&11507295)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &457983748195404475` in
let npos = REAL_ARITH `!s:real. &0:real < &3313083194604814675` in
let ppos = REAL_ARITH `!s:real. &0:real < &280129842114597934682904` in
let qpos = REAL_ARITH `!s:real. &0:real < &7425870803549760096` in
let mqrel = REAL_ARITH `
  ((&457983748195404475)*(-- &33521664)+(&3313083194604814675)*(-- &1867776))*(&30902639 / &41749730) pow 2 = (&7425870803549760096)*(((-- &4050944) * &0 + (&3178496) * -- &1 / &2)) /\
  ((&457983748195404475)*(-- &25640960)+(&3313083194604814675)*(-- &1490944))*(&30902639 / &41749730) pow 2 = (&7425870803549760096)*(((-- &4050944) * &1 / &2 + (&3178496) * &1 / &4)) /\
  (&457983748195404475)*(&41914863)+(&3313083194604814675)*(&2368161)+(&280129842114597934682904) = (&7425870803549760096)*(&3679349)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &1867776) * x + (-- &1490944) * y <= &2368161 ==>
  (-- &4050944) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&3178496) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3679349
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &457983748195404475` [mpos] THEN
  note `&0:real < &3313083194604814675` [npos] THEN
  note `&0:real < &280129842114597934682904` [ppos] THEN
  note `&0:real < &7425870803549760096` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&457983748195404475)*(-- &33521664)+(&3313083194604814675)*(-- &1867776))*s pow 2 = (&7425870803549760096)*((-- &4050944) * &0 + (&3178496) * -- &1 / &2) /\ ((&457983748195404475)*(-- &25640960)+(&3313083194604814675)*(-- &1490944))*s pow 2 = (&7425870803549760096)*((-- &4050944) * &1 / &2 + (&3178496) * &1 / &4) /\ (&457983748195404475)*(&41914863)+(&3313083194604814675)*(&2368161)+(&280129842114597934682904) = (&7425870803549760096)*(&3679349)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &5248293304724501900` in
let npos = REAL_ARITH `!s:real. &0:real < &1962662989412085400` in
let ppos = REAL_ARITH `!s:real. &0:real < &195044021999714253425339` in
let qpos = REAL_ARITH `!s:real. &0:real < &2858234479812812753` in
let mqrel = REAL_ARITH `
  ((&5248293304724501900)*(-- &1867776)+(&1962662989412085400)*(-- &7634944))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((-- &13631488) * &0 + (&9502720) * -- &1 / &2)) /\
  ((&5248293304724501900)*(-- &1490944)+(&1962662989412085400)*(-- &7815168))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((-- &13631488) * &1 / &2 + (&9502720) * &1 / &4)) /\
  (&5248293304724501900)*(&2368161)+(&1962662989412085400)*(&10605687)+(&195044021999714253425339) = (&2858234479812812753)*(&11699263)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1867776) * x + (-- &1490944) * y <= &2368161 ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &13631488) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&9502720) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &11699263
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5248293304724501900` [mpos] THEN
  note `&0:real < &1962662989412085400` [npos] THEN
  note `&0:real < &195044021999714253425339` [ppos] THEN
  note `&0:real < &2858234479812812753` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&5248293304724501900)*(-- &1867776)+(&1962662989412085400)*(-- &7634944))*s pow 2 = (&2858234479812812753)*((-- &13631488) * &0 + (&9502720) * -- &1 / &2) /\ ((&5248293304724501900)*(-- &1490944)+(&1962662989412085400)*(-- &7815168))*s pow 2 = (&2858234479812812753)*((-- &13631488) * &1 / &2 + (&9502720) * &1 / &4) /\ (&5248293304724501900)*(&2368161)+(&1962662989412085400)*(&10605687)+(&195044021999714253425339) = (&2858234479812812753)*(&11699263)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &95035767470439726700` in
let npos = REAL_ARITH `!s:real. &0:real < &101486758344164529600` in
let ppos = REAL_ARITH `!s:real. &0:real < &6080879877492603362433583` in
let qpos = REAL_ARITH `!s:real. &0:real < &2858234479812812753` in
let mqrel = REAL_ARITH `
  ((&95035767470439726700)*(-- &1867776)+(&101486758344164529600)*(-- &7634944))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((-- &540934144) * &0 + (&365101056) * -- &1 / &2)) /\
  ((&95035767470439726700)*(-- &1490944)+(&101486758344164529600)*(-- &7815168))*(&30902639 / &41749730) pow 2 = (&2858234479812812753)*(((-- &540934144) * &1 / &2 + (&365101056) * &1 / &4)) /\
  (&95035767470439726700)*(&2368161)+(&101486758344164529600)*(&10605687)+(&6080879877492603362433583) = (&2858234479812812753)*(&457442411)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1867776) * x + (-- &1490944) * y <= &2368161 ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &540934144) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&365101056) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &457442411
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &95035767470439726700` [mpos] THEN
  note `&0:real < &101486758344164529600` [npos] THEN
  note `&0:real < &6080879877492603362433583` [ppos] THEN
  note `&0:real < &2858234479812812753` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&95035767470439726700)*(-- &1867776)+(&101486758344164529600)*(-- &7634944))*s pow 2 = (&2858234479812812753)*((-- &540934144) * &0 + (&365101056) * -- &1 / &2) /\ ((&95035767470439726700)*(-- &1490944)+(&101486758344164529600)*(-- &7815168))*s pow 2 = (&2858234479812812753)*((-- &540934144) * &1 / &2 + (&365101056) * &1 / &4) /\ (&95035767470439726700)*(&2368161)+(&101486758344164529600)*(&10605687)+(&6080879877492603362433583) = (&2858234479812812753)*(&457442411)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &25828682970625700` in
let npos = REAL_ARITH `!s:real. &0:real < &46903620609234400` in
let ppos = REAL_ARITH `!s:real. &0:real < &2521043689406692895217` in
let qpos = REAL_ARITH `!s:real. &0:real < &48703627955380371` in
let mqrel = REAL_ARITH `
  ((&25828682970625700)*(-- &7634944)+(&46903620609234400)*(-- &950272))*(&30902639 / &41749730) pow 2 = (&48703627955380371)*(((-- &8454144) * &0 + (&5439488) * -- &1 / &2)) /\
  ((&25828682970625700)*(-- &7815168)+(&46903620609234400)*(-- &1130496))*(&30902639 / &41749730) pow 2 = (&48703627955380371)*(((-- &8454144) * &1 / &2 + (&5439488) * &1 / &4)) /\
  (&25828682970625700)*(&10605687)+(&46903620609234400)*(&1407123)+(&2521043689406692895217) = (&48703627955380371)*(&7031327)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &950272) * x + (-- &1130496) * y <= &1407123 ==>
  (-- &8454144) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&5439488) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &7031327
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &25828682970625700` [mpos] THEN
  note `&0:real < &46903620609234400` [npos] THEN
  note `&0:real < &2521043689406692895217` [ppos] THEN
  note `&0:real < &48703627955380371` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&25828682970625700)*(-- &7634944)+(&46903620609234400)*(-- &950272))*s pow 2 = (&48703627955380371)*((-- &8454144) * &0 + (&5439488) * -- &1 / &2) /\ ((&25828682970625700)*(-- &7815168)+(&46903620609234400)*(-- &1130496))*s pow 2 = (&48703627955380371)*((-- &8454144) * &1 / &2 + (&5439488) * &1 / &4) /\ (&25828682970625700)*(&10605687)+(&46903620609234400)*(&1407123)+(&2521043689406692895217) = (&48703627955380371)*(&7031327)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &574767425185288775` in
let npos = REAL_ARITH `!s:real. &0:real < &108563936321749271825` in
let ppos = REAL_ARITH `!s:real. &0:real < &26287020971768862311486448` in
let qpos = REAL_ARITH `!s:real. &0:real < &95168798971007573576` in
let mqrel = REAL_ARITH `
  ((&574767425185288775)*(-- &438239232)+(&108563936321749271825)*(-- &13041664))*(&30902639 / &41749730) pow 2 = (&95168798971007573576)*(((-- &34471936) * &0 + (&19202048) * -- &1 / &2)) /\
  ((&574767425185288775)*(-- &539754496)+(&108563936321749271825)*(-- &17039360))*(&30902639 / &41749730) pow 2 = (&95168798971007573576)*(((-- &34471936) * &1 / &2 + (&19202048) * &1 / &4)) /\
  (&574767425185288775)*(&659132513)+(&108563936321749271825)*(&20256657)+(&26287020971768862311486448) = (&95168798971007573576)*(&27364823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &438239232) * x + (-- &539754496) * y <= &659132513 ==>
  (-- &13041664) * x + (-- &17039360) * y <= &20256657 ==>
  (-- &34471936) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&19202048) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &27364823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &574767425185288775` [mpos] THEN
  note `&0:real < &108563936321749271825` [npos] THEN
  note `&0:real < &26287020971768862311486448` [ppos] THEN
  note `&0:real < &95168798971007573576` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&574767425185288775)*(-- &438239232)+(&108563936321749271825)*(-- &13041664))*s pow 2 = (&95168798971007573576)*((-- &34471936) * &0 + (&19202048) * -- &1 / &2) /\ ((&574767425185288775)*(-- &539754496)+(&108563936321749271825)*(-- &17039360))*s pow 2 = (&95168798971007573576)*((-- &34471936) * &1 / &2 + (&19202048) * &1 / &4) /\ (&574767425185288775)*(&659132513)+(&108563936321749271825)*(&20256657)+(&26287020971768862311486448) = (&95168798971007573576)*(&27364823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &70485049703237930200` in
let npos = REAL_ARITH `!s:real. &0:real < &102061961529338586600` in
let ppos = REAL_ARITH `!s:real. &0:real < &89207210642451016142195` in
let qpos = REAL_ARITH `!s:real. &0:real < &71558999089814065493` in
let mqrel = REAL_ARITH `
  ((&70485049703237930200)*(-- &7733248)+(&102061961529338586600)*(-- &897024))*(&30902639 / &41749730) pow 2 = (&71558999089814065493)*(((-- &20946944) * &0 + (&9748480) * -- &1 / &2)) /\
  ((&70485049703237930200)*(-- &11943936)+(&102061961529338586600)*(-- &2035712))*(&30902639 / &41749730) pow 2 = (&71558999089814065493)*(((-- &20946944) * &1 / &2 + (&9748480) * &1 / &4)) /\
  (&70485049703237930200)*(&13225515)+(&102061961529338586600)*(&1977153)+(&89207210642451016142195) = (&71558999089814065493)*(&15848215)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &11943936) * y <= &13225515 ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &20946944) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&9748480) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &15848215
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &70485049703237930200` [mpos] THEN
  note `&0:real < &102061961529338586600` [npos] THEN
  note `&0:real < &89207210642451016142195` [ppos] THEN
  note `&0:real < &71558999089814065493` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&70485049703237930200)*(-- &7733248)+(&102061961529338586600)*(-- &897024))*s pow 2 = (&71558999089814065493)*((-- &20946944) * &0 + (&9748480) * -- &1 / &2) /\ ((&70485049703237930200)*(-- &11943936)+(&102061961529338586600)*(-- &2035712))*s pow 2 = (&71558999089814065493)*((-- &20946944) * &1 / &2 + (&9748480) * &1 / &4) /\ (&70485049703237930200)*(&13225515)+(&102061961529338586600)*(&1977153)+(&89207210642451016142195) = (&71558999089814065493)*(&15848215)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &198270794889542375` in
let npos = REAL_ARITH `!s:real. &0:real < &1306788429037344442200` in
let ppos = REAL_ARITH `!s:real. &0:real < &286647681335718750272605` in
let qpos = REAL_ARITH `!s:real. &0:real < &143117998179628130986` in
let mqrel = REAL_ARITH `
  ((&198270794889542375)*(-- &7733248)+(&1306788429037344442200)*(-- &897024))*(&30902639 / &41749730) pow 2 = (&143117998179628130986)*(((-- &24879104) * &0 + (&8986624) * -- &1 / &2)) /\
  ((&198270794889542375)*(-- &11943936)+(&1306788429037344442200)*(-- &2035712))*(&30902639 / &41749730) pow 2 = (&143117998179628130986)*(((-- &24879104) * &1 / &2 + (&8986624) * &1 / &4)) /\
  (&198270794889542375)*(&13225515)+(&1306788429037344442200)*(&1977153)+(&286647681335718750272605) = (&143117998179628130986)*(&18073405)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &11943936) * y <= &13225515 ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &24879104) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&8986624) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &18073405
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &198270794889542375` [mpos] THEN
  note `&0:real < &1306788429037344442200` [npos] THEN
  note `&0:real < &286647681335718750272605` [ppos] THEN
  note `&0:real < &143117998179628130986` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&198270794889542375)*(-- &7733248)+(&1306788429037344442200)*(-- &897024))*s pow 2 = (&143117998179628130986)*((-- &24879104) * &0 + (&8986624) * -- &1 / &2) /\ ((&198270794889542375)*(-- &11943936)+(&1306788429037344442200)*(-- &2035712))*s pow 2 = (&143117998179628130986)*((-- &24879104) * &1 / &2 + (&8986624) * &1 / &4) /\ (&198270794889542375)*(&13225515)+(&1306788429037344442200)*(&1977153)+(&286647681335718750272605) = (&143117998179628130986)*(&18073405)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &1415348443519194800` in
let npos = REAL_ARITH `!s:real. &0:real < &13072799663046750` in
let ppos = REAL_ARITH `!s:real. &0:real < &512149406168526252987` in
let qpos = REAL_ARITH `!s:real. &0:real < &61354156573516131287` in
let mqrel = REAL_ARITH `
  ((&1415348443519194800)*(-- &1275904)+(&13072799663046750)*(-- &2211840))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((-- &131072) * &0 + (&32768) * -- &1 / &2)) /\
  ((&1415348443519194800)*(-- &4450304)+(&13072799663046750)*(-- &9404416))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((-- &131072) * &1 / &2 + (&32768) * &1 / &4)) /\
  (&1415348443519194800)*(&3928715)+(&13072799663046750)*(&8039969)+(&512149406168526252987) = (&61354156573516131287)*(&92351)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &131072) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&32768) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &92351
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1415348443519194800` [mpos] THEN
  note `&0:real < &13072799663046750` [npos] THEN
  note `&0:real < &512149406168526252987` [ppos] THEN
  note `&0:real < &61354156573516131287` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&1415348443519194800)*(-- &1275904)+(&13072799663046750)*(-- &2211840))*s pow 2 = (&61354156573516131287)*((-- &131072) * &0 + (&32768) * -- &1 / &2) /\ ((&1415348443519194800)*(-- &4450304)+(&13072799663046750)*(-- &9404416))*s pow 2 = (&61354156573516131287)*((-- &131072) * &1 / &2 + (&32768) * &1 / &4) /\ (&1415348443519194800)*(&3928715)+(&13072799663046750)*(&8039969)+(&512149406168526252987) = (&61354156573516131287)*(&92351)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &18420446245210407200` in
let npos = REAL_ARITH `!s:real. &0:real < &1013000787649762220100` in
let ppos = REAL_ARITH `!s:real. &0:real < &744805521851734192835451` in
let qpos = REAL_ARITH `!s:real. &0:real < &61354156573516131287` in
let mqrel = REAL_ARITH `
  ((&18420446245210407200)*(-- &1275904)+(&1013000787649762220100)*(-- &2211840))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((-- &191823872) * &0 + (&40435712) * -- &1 / &2)) /\
  ((&18420446245210407200)*(-- &4450304)+(&1013000787649762220100)*(-- &9404416))*(&30902639 / &41749730) pow 2 = (&61354156573516131287)*(((-- &191823872) * &1 / &2 + (&40435712) * &1 / &4)) /\
  (&18420446245210407200)*(&3928715)+(&1013000787649762220100)*(&8039969)+(&744805521851734192835451) = (&61354156573516131287)*(&133937273)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &191823872) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&40435712) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &133937273
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &18420446245210407200` [mpos] THEN
  note `&0:real < &1013000787649762220100` [npos] THEN
  note `&0:real < &744805521851734192835451` [ppos] THEN
  note `&0:real < &61354156573516131287` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&18420446245210407200)*(-- &1275904)+(&1013000787649762220100)*(-- &2211840))*s pow 2 = (&61354156573516131287)*((-- &191823872) * &0 + (&40435712) * -- &1 / &2) /\ ((&18420446245210407200)*(-- &4450304)+(&1013000787649762220100)*(-- &9404416))*s pow 2 = (&61354156573516131287)*((-- &191823872) * &1 / &2 + (&40435712) * &1 / &4) /\ (&18420446245210407200)*(&3928715)+(&1013000787649762220100)*(&8039969)+(&744805521851734192835451) = (&61354156573516131287)*(&133937273)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &16479650484325600` in
let npos = REAL_ARITH `!s:real. &0:real < &189317907847577025` in
let ppos = REAL_ARITH `!s:real. &0:real < &699264407576074963490` in
let qpos = REAL_ARITH `!s:real. &0:real < &929188823540884333` in
let mqrel = REAL_ARITH `
  ((&16479650484325600)*(-- &2211840)+(&189317907847577025)*(-- &7733248))*(&30902639 / &41749730) pow 2 = (&929188823540884333)*(((-- &9568256) * &0 + (&1769472) * -- &1 / &2)) /\
  ((&16479650484325600)*(-- &9404416)+(&189317907847577025)*(-- &38076416))*(&30902639 / &41749730) pow 2 = (&929188823540884333)*(((-- &9568256) * &1 / &2 + (&1769472) * &1 / &4)) /\
  (&16479650484325600)*(&8039969)+(&189317907847577025)*(&31944087)+(&699264407576074963490) = (&929188823540884333)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &9568256) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&1769472) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16479650484325600` [mpos] THEN
  note `&0:real < &189317907847577025` [npos] THEN
  note `&0:real < &699264407576074963490` [ppos] THEN
  note `&0:real < &929188823540884333` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&16479650484325600)*(-- &2211840)+(&189317907847577025)*(-- &7733248))*s pow 2 = (&929188823540884333)*((-- &9568256) * &0 + (&1769472) * -- &1 / &2) /\ ((&16479650484325600)*(-- &9404416)+(&189317907847577025)*(-- &38076416))*s pow 2 = (&929188823540884333)*((-- &9568256) * &1 / &2 + (&1769472) * &1 / &4) /\ (&16479650484325600)*(&8039969)+(&189317907847577025)*(&31944087)+(&699264407576074963490) = (&929188823540884333)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &19745592371054579425` in
let npos = REAL_ARITH `!s:real. &0:real < &31374719191312200` in
let ppos = REAL_ARITH `!s:real. &0:real < &93608349293876871983458` in
let qpos = REAL_ARITH `!s:real. &0:real < &214312197546325425857` in
let mqrel = REAL_ARITH `
  ((&19745592371054579425)*(-- &1966080)+(&31374719191312200)*(&11730944))*(&30902639 / &41749730) pow 2 = (&214312197546325425857)*(((-- &5767168) * &0 + (&196608) * -- &1 / &2)) /\
  ((&19745592371054579425)*(-- &55902208)+(&31374719191312200)*(-- &156696576))*(&30902639 / &41749730) pow 2 = (&214312197546325425857)*(((-- &5767168) * &1 / &2 + (&196608) * &1 / &4)) /\
  (&19745592371054579425)*(&42311631)+(&31374719191312200)*(&110400449)+(&93608349293876871983458) = (&214312197546325425857)*(&3914969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1966080) * x + (-- &55902208) * y <= &42311631 ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (-- &5767168) * ((&0) * x + (&1 / &2) * y) / s pow 2 + (&196608) * ((-- &1 / &2) * x + (&1 / &4) * y) / s pow 2 <= &3914969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &19745592371054579425` [mpos] THEN
  note `&0:real < &31374719191312200` [npos] THEN
  note `&0:real < &93608349293876871983458` [ppos] THEN
  note `&0:real < &214312197546325425857` [qpos] THEN
  note `&0:real < s pow 2` [REAL_POW_LT] THEN
  note `((&19745592371054579425)*(-- &1966080)+(&31374719191312200)*(&11730944))*s pow 2 = (&214312197546325425857)*((-- &5767168) * &0 + (&196608) * -- &1 / &2) /\ ((&19745592371054579425)*(-- &55902208)+(&31374719191312200)*(-- &156696576))*s pow 2 = (&214312197546325425857)*((-- &5767168) * &1 / &2 + (&196608) * &1 / &4) /\ (&19745592371054579425)*(&42311631)+(&31374719191312200)*(&110400449)+(&93608349293876871983458) = (&214312197546325425857)*(&3914969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_H1 x y ==>
  divsteps_H0 (((&0) * x + (&1 / &2) * y) / divsteps_s pow 2) (((-- &1 / &2) * x + (&1 / &4) * y) / divsteps_s pow 2)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_H1] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H0] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

(* skipping Gc for approx *)

let theorem_2 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &204929635534647025470747692901442625` in
let npos = REAL_ARITH `!s:real. &0:real < &3638344403324880127553958167765375` in
let ppos = REAL_ARITH `!s:real. &0:real < &2694431604612903319067477561320154812474166` in
let qpos = REAL_ARITH `!s:real. &0:real < &92789667564834664730166985936857586` in
let mqrel = REAL_ARITH `
  ((&204929635534647025470747692901442625)*(&11730944)+(&3638344403324880127553958167765375)*(&22740992))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((-- &413007872) * &0 + (-- &32178176) * -- &1 / &4)) /\
  ((&204929635534647025470747692901442625)*(-- &156696576)+(&3638344403324880127553958167765375)*(-- &117506048))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((-- &413007872) * &1 / &4 + (-- &32178176) * &1 / &16)) /\
  (&204929635534647025470747692901442625)*(&110400449)+(&3638344403324880127553958167765375)*(&77682557)+(&2694431604612903319067477561320154812474166) = (&92789667564834664730166985936857586)*(&275907781)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &413007872) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &32178176) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &275907781
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &204929635534647025470747692901442625` [mpos] THEN
  note `&0:real < &3638344403324880127553958167765375` [npos] THEN
  note `&0:real < &2694431604612903319067477561320154812474166` [ppos] THEN
  note `&0:real < &92789667564834664730166985936857586` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&204929635534647025470747692901442625)*(&11730944)+(&3638344403324880127553958167765375)*(&22740992))*s pow 4 = (&92789667564834664730166985936857586)*((-- &413007872) * &0 + (-- &32178176) * -- &1 / &4) /\ ((&204929635534647025470747692901442625)*(-- &156696576)+(&3638344403324880127553958167765375)*(-- &117506048))*s pow 4 = (&92789667564834664730166985936857586)*((-- &413007872) * &1 / &4 + (-- &32178176) * &1 / &16) /\ (&204929635534647025470747692901442625)*(&110400449)+(&3638344403324880127553958167765375)*(&77682557)+(&2694431604612903319067477561320154812474166) = (&92789667564834664730166985936857586)*(&275907781)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &167959783185043418249156727988728750` in
let npos = REAL_ARITH `!s:real. &0:real < &6141127957784722201038723270863125` in
let ppos = REAL_ARITH `!s:real. &0:real < &2474849543777879224888802025444955207416994` in
let qpos = REAL_ARITH `!s:real. &0:real < &844687290922823485264389121414603979` in
let mqrel = REAL_ARITH `
  ((&167959783185043418249156727988728750)*(&22740992)+(&6141127957784722201038723270863125)*(&166330368))*(&30902639 / &41749730) pow 4 = (&844687290922823485264389121414603979)*(((-- &32309248) * &0 + (-- &6881280) * -- &1 / &4)) /\
  ((&167959783185043418249156727988728750)*(-- &117506048)+(&6141127957784722201038723270863125)*(-- &684523520))*(&30902639 / &41749730) pow 4 = (&844687290922823485264389121414603979)*(((-- &32309248) * &1 / &4 + (-- &6881280) * &1 / &16)) /\
  (&167959783185043418249156727988728750)*(&77682557)+(&6141127957784722201038723270863125)*(&441063407)+(&2474849543777879224888802025444955207416994) = (&844687290922823485264389121414603979)*(&21583161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (-- &32309248) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &6881280) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &21583161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &167959783185043418249156727988728750` [mpos] THEN
  note `&0:real < &6141127957784722201038723270863125` [npos] THEN
  note `&0:real < &2474849543777879224888802025444955207416994` [ppos] THEN
  note `&0:real < &844687290922823485264389121414603979` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&167959783185043418249156727988728750)*(&22740992)+(&6141127957784722201038723270863125)*(&166330368))*s pow 4 = (&844687290922823485264389121414603979)*((-- &32309248) * &0 + (-- &6881280) * -- &1 / &4) /\ ((&167959783185043418249156727988728750)*(-- &117506048)+(&6141127957784722201038723270863125)*(-- &684523520))*s pow 4 = (&844687290922823485264389121414603979)*((-- &32309248) * &1 / &4 + (-- &6881280) * &1 / &16) /\ (&167959783185043418249156727988728750)*(&77682557)+(&6141127957784722201038723270863125)*(&441063407)+(&2474849543777879224888802025444955207416994) = (&844687290922823485264389121414603979)*(&21583161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &556106375834249123933342406983038125` in
let npos = REAL_ARITH `!s:real. &0:real < &127117607956817867275011962144749375` in
let ppos = REAL_ARITH `!s:real. &0:real < &10746085031793161931827589380217138679377240` in
let qpos = REAL_ARITH `!s:real. &0:real < &799629410461913117482625118169441292` in
let mqrel = REAL_ARITH `
  ((&556106375834249123933342406983038125)*(&33882112)+(&127117607956817867275011962144749375)*(&50659328))*(&30902639 / &41749730) pow 4 = (&799629410461913117482625118169441292)*(((-- &137199616) * &0 + (-- &37961728) * -- &1 / &4)) /\
  ((&556106375834249123933342406983038125)*(-- &135659520)+(&127117607956817867275011962144749375)*(-- &175046656))*(&30902639 / &41749730) pow 4 = (&799629410461913117482625118169441292)*(((-- &137199616) * &1 / &4 + (-- &37961728) * &1 / &16)) /\
  (&556106375834249123933342406983038125)*(&87245513)+(&127117607956817867275011962144749375)*(&111549985)+(&10746085031793161931827589380217138679377240) = (&799629410461913117482625118169441292)*(&91847345)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (-- &137199616) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &37961728) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &91847345
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &556106375834249123933342406983038125` [mpos] THEN
  note `&0:real < &127117607956817867275011962144749375` [npos] THEN
  note `&0:real < &10746085031793161931827589380217138679377240` [ppos] THEN
  note `&0:real < &799629410461913117482625118169441292` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&556106375834249123933342406983038125)*(&33882112)+(&127117607956817867275011962144749375)*(&50659328))*s pow 4 = (&799629410461913117482625118169441292)*((-- &137199616) * &0 + (-- &37961728) * -- &1 / &4) /\ ((&556106375834249123933342406983038125)*(-- &135659520)+(&127117607956817867275011962144749375)*(-- &175046656))*s pow 4 = (&799629410461913117482625118169441292)*((-- &137199616) * &1 / &4 + (-- &37961728) * &1 / &16) /\ (&556106375834249123933342406983038125)*(&87245513)+(&127117607956817867275011962144749375)*(&111549985)+(&10746085031793161931827589380217138679377240) = (&799629410461913117482625118169441292)*(&91847345)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &20706012709213606496090613782752500` in
let npos = REAL_ARITH `!s:real. &0:real < &11567142347992150446754116037472500` in
let ppos = REAL_ARITH `!s:real. &0:real < &536823724970120101546519573632816825811335` in
let qpos = REAL_ARITH `!s:real. &0:real < &199907352615478279370656279542360323` in
let mqrel = REAL_ARITH `
  ((&20706012709213606496090613782752500)*(&33882112)+(&11567142347992150446754116037472500)*(&50659328))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((-- &27099136) * &0 + (-- &7733248) * -- &1 / &4)) /\
  ((&20706012709213606496090613782752500)*(-- &135659520)+(&11567142347992150446754116037472500)*(-- &175046656))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((-- &27099136) * &1 / &4 + (-- &7733248) * &1 / &16)) /\
  (&20706012709213606496090613782752500)*(&87245513)+(&11567142347992150446754116037472500)*(&111549985)+(&536823724970120101546519573632816825811335) = (&199907352615478279370656279542360323)*(&18176645)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (-- &27099136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &7733248) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18176645
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20706012709213606496090613782752500` [mpos] THEN
  note `&0:real < &11567142347992150446754116037472500` [npos] THEN
  note `&0:real < &536823724970120101546519573632816825811335` [ppos] THEN
  note `&0:real < &199907352615478279370656279542360323` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&20706012709213606496090613782752500)*(&33882112)+(&11567142347992150446754116037472500)*(&50659328))*s pow 4 = (&199907352615478279370656279542360323)*((-- &27099136) * &0 + (-- &7733248) * -- &1 / &4) /\ ((&20706012709213606496090613782752500)*(-- &135659520)+(&11567142347992150446754116037472500)*(-- &175046656))*s pow 4 = (&199907352615478279370656279542360323)*((-- &27099136) * &1 / &4 + (-- &7733248) * &1 / &16) /\ (&20706012709213606496090613782752500)*(&87245513)+(&11567142347992150446754116037472500)*(&111549985)+(&536823724970120101546519573632816825811335) = (&199907352615478279370656279542360323)*(&18176645)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &1380097028452409046014329820742500` in
let npos = REAL_ARITH `!s:real. &0:real < &52251711558934336051032083071433125` in
let ppos = REAL_ARITH `!s:real. &0:real < &243911296664608832466250370871023207588988` in
let qpos = REAL_ARITH `!s:real. &0:real < &33486759217199340064739661083634479` in
let mqrel = REAL_ARITH `
  ((&1380097028452409046014329820742500)*(&50659328)+(&52251711558934336051032083071433125)*(&11010048))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((-- &68321280) * &0 + (-- &23134208) * -- &1 / &4)) /\
  ((&1380097028452409046014329820742500)*(-- &175046656)+(&52251711558934336051032083071433125)*(-- &34930688))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((-- &68321280) * &1 / &4 + (-- &23134208) * &1 / &16)) /\
  (&1380097028452409046014329820742500)*(&111549985)+(&52251711558934336051032083071433125)*(&22163375)+(&243911296664608832466250370871023207588988) = (&33486759217199340064739661083634479)*(&46464197)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &68321280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &23134208) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &46464197
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1380097028452409046014329820742500` [mpos] THEN
  note `&0:real < &52251711558934336051032083071433125` [npos] THEN
  note `&0:real < &243911296664608832466250370871023207588988` [ppos] THEN
  note `&0:real < &33486759217199340064739661083634479` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1380097028452409046014329820742500)*(&50659328)+(&52251711558934336051032083071433125)*(&11010048))*s pow 4 = (&33486759217199340064739661083634479)*((-- &68321280) * &0 + (-- &23134208) * -- &1 / &4) /\ ((&1380097028452409046014329820742500)*(-- &175046656)+(&52251711558934336051032083071433125)*(-- &34930688))*s pow 4 = (&33486759217199340064739661083634479)*((-- &68321280) * &1 / &4 + (-- &23134208) * &1 / &16) /\ (&1380097028452409046014329820742500)*(&111549985)+(&52251711558934336051032083071433125)*(&22163375)+(&243911296664608832466250370871023207588988) = (&33486759217199340064739661083634479)*(&46464197)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &22345571017203353423292888054109000` in
let npos = REAL_ARITH `!s:real. &0:real < &921558461541721461491021668413250` in
let ppos = REAL_ARITH `!s:real. &0:real < &44445603688228070643474620887584899715249` in
let qpos = REAL_ARITH `!s:real. &0:real < &15664970807315914493641797391911257` in
let mqrel = REAL_ARITH `
  ((&22345571017203353423292888054109000)*(&3457024)+(&921558461541721461491021668413250)*(&58130432))*(&30902639 / &41749730) pow 4 = (&15664970807315914493641797391911257)*(((-- &26869760) * &0 + (-- &10027008) * -- &1 / &4)) /\
  ((&22345571017203353423292888054109000)*(-- &10452992)+(&921558461541721461491021668413250)*(-- &162430976))*(&30902639 / &41749730) pow 4 = (&15664970807315914493641797391911257)*(((-- &26869760) * &1 / &4 + (-- &10027008) * &1 / &16)) /\
  (&22345571017203353423292888054109000)*(&6651805)+(&921558461541721461491021668413250)*(&104374325)+(&44445603688228070643474620887584899715249) = (&15664970807315914493641797391911257)*(&18466107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (-- &26869760) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &10027008) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18466107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22345571017203353423292888054109000` [mpos] THEN
  note `&0:real < &921558461541721461491021668413250` [npos] THEN
  note `&0:real < &44445603688228070643474620887584899715249` [ppos] THEN
  note `&0:real < &15664970807315914493641797391911257` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&22345571017203353423292888054109000)*(&3457024)+(&921558461541721461491021668413250)*(&58130432))*s pow 4 = (&15664970807315914493641797391911257)*((-- &26869760) * &0 + (-- &10027008) * -- &1 / &4) /\ ((&22345571017203353423292888054109000)*(-- &10452992)+(&921558461541721461491021668413250)*(-- &162430976))*s pow 4 = (&15664970807315914493641797391911257)*((-- &26869760) * &1 / &4 + (-- &10027008) * &1 / &16) /\ (&22345571017203353423292888054109000)*(&6651805)+(&921558461541721461491021668413250)*(&104374325)+(&44445603688228070643474620887584899715249) = (&15664970807315914493641797391911257)*(&18466107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &52581772738743909166577227278149500` in
let npos = REAL_ARITH `!s:real. &0:real < &5837992721650789096875641800605375` in
let ppos = REAL_ARITH `!s:real. &0:real < &172173595998526204964089087732111535915627` in
let qpos = REAL_ARITH `!s:real. &0:real < &31329941614631828987283594783822514` in
let mqrel = REAL_ARITH `
  ((&52581772738743909166577227278149500)*(&3457024)+(&5837992721650789096875641800605375)*(&58130432))*(&30902639 / &41749730) pow 4 = (&31329941614631828987283594783822514)*(((-- &52412416) * &0 + (-- &19972096) * -- &1 / &4)) /\
  ((&52581772738743909166577227278149500)*(-- &10452992)+(&5837992721650789096875641800605375)*(-- &162430976))*(&30902639 / &41749730) pow 4 = (&31329941614631828987283594783822514)*(((-- &52412416) * &1 / &4 + (-- &19972096) * &1 / &16)) /\
  (&52581772738743909166577227278149500)*(&6651805)+(&5837992721650789096875641800605375)*(&104374325)+(&172173595998526204964089087732111535915627) = (&31329941614631828987283594783822514)*(&36108393)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (-- &52412416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &19972096) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &36108393
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &52581772738743909166577227278149500` [mpos] THEN
  note `&0:real < &5837992721650789096875641800605375` [npos] THEN
  note `&0:real < &172173595998526204964089087732111535915627` [ppos] THEN
  note `&0:real < &31329941614631828987283594783822514` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&52581772738743909166577227278149500)*(&3457024)+(&5837992721650789096875641800605375)*(&58130432))*s pow 4 = (&31329941614631828987283594783822514)*((-- &52412416) * &0 + (-- &19972096) * -- &1 / &4) /\ ((&52581772738743909166577227278149500)*(-- &10452992)+(&5837992721650789096875641800605375)*(-- &162430976))*s pow 4 = (&31329941614631828987283594783822514)*((-- &52412416) * &1 / &4 + (-- &19972096) * &1 / &16) /\ (&52581772738743909166577227278149500)*(&6651805)+(&5837992721650789096875641800605375)*(&104374325)+(&172173595998526204964089087732111535915627) = (&31329941614631828987283594783822514)*(&36108393)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &254500867501803720275859649030723125` in
let npos = REAL_ARITH `!s:real. &0:real < &2722026816574750092819952941709375` in
let ppos = REAL_ARITH `!s:real. &0:real < &5049993718305482520440667115078148369619750` in
let qpos = REAL_ARITH `!s:real. &0:real < &5917776732800559364215099444406446098` in
let mqrel = REAL_ARITH `
  ((&254500867501803720275859649030723125)*(&58130432)+(&2722026816574750092819952941709375)*(&290521088))*(&30902639 / &41749730) pow 4 = (&5917776732800559364215099444406446098)*(((-- &7979008) * &0 + (-- &3162112) * -- &1 / &4)) /\
  ((&254500867501803720275859649030723125)*(-- &162430976)+(&2722026816574750092819952941709375)*(-- &691929088))*(&30902639 / &41749730) pow 4 = (&5917776732800559364215099444406446098)*(((-- &7979008) * &1 / &4 + (-- &3162112) * &1 / &16)) /\
  (&254500867501803720275859649030723125)*(&104374325)+(&2722026816574750092819952941709375)*(&457690221)+(&5049993718305482520440667115078148369619750) = (&5917776732800559364215099444406446098)*(&5552625)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &7979008) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &3162112) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5552625
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &254500867501803720275859649030723125` [mpos] THEN
  note `&0:real < &2722026816574750092819952941709375` [npos] THEN
  note `&0:real < &5049993718305482520440667115078148369619750` [ppos] THEN
  note `&0:real < &5917776732800559364215099444406446098` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&254500867501803720275859649030723125)*(&58130432)+(&2722026816574750092819952941709375)*(&290521088))*s pow 4 = (&5917776732800559364215099444406446098)*((-- &7979008) * &0 + (-- &3162112) * -- &1 / &4) /\ ((&254500867501803720275859649030723125)*(-- &162430976)+(&2722026816574750092819952941709375)*(-- &691929088))*s pow 4 = (&5917776732800559364215099444406446098)*((-- &7979008) * &1 / &4 + (-- &3162112) * &1 / &16) /\ (&254500867501803720275859649030723125)*(&104374325)+(&2722026816574750092819952941709375)*(&457690221)+(&5049993718305482520440667115078148369619750) = (&5917776732800559364215099444406446098)*(&5552625)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &888252132580854510599447718923974375` in
let npos = REAL_ARITH `!s:real. &0:real < &272277307157224843728209332643633125` in
let ppos = REAL_ARITH `!s:real. &0:real < &39946282405547205249500139425984008923323743` in
let qpos = REAL_ARITH `!s:real. &0:real < &2958888366400279682107549722203223049` in
let mqrel = REAL_ARITH `
  ((&888252132580854510599447718923974375)*(&58130432)+(&272277307157224843728209332643633125)*(&290521088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((-- &121733120) * &0 + (-- &53051392) * -- &1 / &4)) /\
  ((&888252132580854510599447718923974375)*(-- &162430976)+(&272277307157224843728209332643633125)*(-- &691929088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((-- &121733120) * &1 / &4 + (-- &53051392) * &1 / &16)) /\
  (&888252132580854510599447718923974375)*(&104374325)+(&272277307157224843728209332643633125)*(&457690221)+(&39946282405547205249500139425984008923323743) = (&2958888366400279682107549722203223049)*(&86950107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &121733120) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &53051392) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &86950107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &888252132580854510599447718923974375` [mpos] THEN
  note `&0:real < &272277307157224843728209332643633125` [npos] THEN
  note `&0:real < &39946282405547205249500139425984008923323743` [ppos] THEN
  note `&0:real < &2958888366400279682107549722203223049` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&888252132580854510599447718923974375)*(&58130432)+(&272277307157224843728209332643633125)*(&290521088))*s pow 4 = (&2958888366400279682107549722203223049)*((-- &121733120) * &0 + (-- &53051392) * -- &1 / &4) /\ ((&888252132580854510599447718923974375)*(-- &162430976)+(&272277307157224843728209332643633125)*(-- &691929088))*s pow 4 = (&2958888366400279682107549722203223049)*((-- &121733120) * &1 / &4 + (-- &53051392) * &1 / &16) /\ (&888252132580854510599447718923974375)*(&104374325)+(&272277307157224843728209332643633125)*(&457690221)+(&39946282405547205249500139425984008923323743) = (&2958888366400279682107549722203223049)*(&86950107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &32277370543451167438279721306468875` in
let npos = REAL_ARITH `!s:real. &0:real < &2725412573599532403531848085687879000` in
let ppos = REAL_ARITH `!s:real. &0:real < &13038006446641999506219597655285590930349171` in
let qpos = REAL_ARITH `!s:real. &0:real < &882792284533004591120349721078470082` in
let mqrel = REAL_ARITH `
  ((&32277370543451167438279721306468875)*(&290521088)+(&2725412573599532403531848085687879000)*(&14442496))*(&30902639 / &41749730) pow 4 = (&882792284533004591120349721078470082)*(((-- &124731392) * &0 + (-- &66289664) * -- &1 / &4)) /\
  ((&32277370543451167438279721306468875)*(-- &691929088)+(&2725412573599532403531848085687879000)*(-- &29925376))*(&30902639 / &41749730) pow 4 = (&882792284533004591120349721078470082)*(((-- &124731392) * &1 / &4 + (-- &66289664) * &1 / &16)) /\
  (&32277370543451167438279721306468875)*(&457690221)+(&2725412573599532403531848085687879000)*(&20669487)+(&13038006446641999506219597655285590930349171) = (&882792284533004591120349721078470082)*(&95315653)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &124731392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &66289664) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &95315653
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &32277370543451167438279721306468875` [mpos] THEN
  note `&0:real < &2725412573599532403531848085687879000` [npos] THEN
  note `&0:real < &13038006446641999506219597655285590930349171` [ppos] THEN
  note `&0:real < &882792284533004591120349721078470082` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&32277370543451167438279721306468875)*(&290521088)+(&2725412573599532403531848085687879000)*(&14442496))*s pow 4 = (&882792284533004591120349721078470082)*((-- &124731392) * &0 + (-- &66289664) * -- &1 / &4) /\ ((&32277370543451167438279721306468875)*(-- &691929088)+(&2725412573599532403531848085687879000)*(-- &29925376))*s pow 4 = (&882792284533004591120349721078470082)*((-- &124731392) * &1 / &4 + (-- &66289664) * &1 / &16) /\ (&32277370543451167438279721306468875)*(&457690221)+(&2725412573599532403531848085687879000)*(&20669487)+(&13038006446641999506219597655285590930349171) = (&882792284533004591120349721078470082)*(&95315653)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &38503616108028969372696233358541250` in
let npos = REAL_ARITH `!s:real. &0:real < &36127511195106065791022039601275000` in
let ppos = REAL_ARITH `!s:real. &0:real < &192586845187099428505456791763630249299653` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&38503616108028969372696233358541250)*(&15433728)+(&36127511195106065791022039601275000)*(&5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &165806080) * &0 + (-- &105447424) * -- &1 / &4)) /\
  ((&38503616108028969372696233358541250)*(-- &29458432)+(&36127511195106065791022039601275000)*(-- &8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &165806080) * &1 / &4 + (-- &105447424) * &1 / &16)) /\
  (&38503616108028969372696233358541250)*(&21015329)+(&36127511195106065791022039601275000)*(&6951751)+(&192586845187099428505456791763630249299653) = (&9095112875435851152418329474851893)*(&137755571)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &165806080) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &105447424) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &137755571
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &38503616108028969372696233358541250` [mpos] THEN
  note `&0:real < &36127511195106065791022039601275000` [npos] THEN
  note `&0:real < &192586845187099428505456791763630249299653` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&38503616108028969372696233358541250)*(&15433728)+(&36127511195106065791022039601275000)*(&5660672))*s pow 4 = (&9095112875435851152418329474851893)*((-- &165806080) * &0 + (-- &105447424) * -- &1 / &4) /\ ((&38503616108028969372696233358541250)*(-- &29458432)+(&36127511195106065791022039601275000)*(-- &8896512))*s pow 4 = (&9095112875435851152418329474851893)*((-- &165806080) * &1 / &4 + (-- &105447424) * &1 / &16) /\ (&38503616108028969372696233358541250)*(&21015329)+(&36127511195106065791022039601275000)*(&6951751)+(&192586845187099428505456791763630249299653) = (&9095112875435851152418329474851893)*(&137755571)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &3348912086853546741967028383750000` in
let npos = REAL_ARITH `!s:real. &0:real < &11566106601985907081782373657560000` in
let ppos = REAL_ARITH `!s:real. &0:real < &27233852042160971319627078273798161593939` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&3348912086853546741967028383750000)*(&15433728)+(&11566106601985907081782373657560000)*(&5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &22740992) * &0 + (-- &15466496) * -- &1 / &4)) /\
  ((&3348912086853546741967028383750000)*(-- &29458432)+(&11566106601985907081782373657560000)*(-- &8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &22740992) * &1 / &4 + (-- &15466496) * &1 / &16)) /\
  (&3348912086853546741967028383750000)*(&21015329)+(&11566106601985907081782373657560000)*(&6951751)+(&27233852042160971319627078273798161593939) = (&9095112875435851152418329474851893)*(&19572823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &22740992) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &15466496) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &19572823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3348912086853546741967028383750000` [mpos] THEN
  note `&0:real < &11566106601985907081782373657560000` [npos] THEN
  note `&0:real < &27233852042160971319627078273798161593939` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3348912086853546741967028383750000)*(&15433728)+(&11566106601985907081782373657560000)*(&5660672))*s pow 4 = (&9095112875435851152418329474851893)*((-- &22740992) * &0 + (-- &15466496) * -- &1 / &4) /\ ((&3348912086853546741967028383750000)*(-- &29458432)+(&11566106601985907081782373657560000)*(-- &8896512))*s pow 4 = (&9095112875435851152418329474851893)*((-- &22740992) * &1 / &4 + (-- &15466496) * &1 / &16) /\ (&3348912086853546741967028383750000)*(&21015329)+(&11566106601985907081782373657560000)*(&6951751)+(&27233852042160971319627078273798161593939) = (&9095112875435851152418329474851893)*(&19572823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &329816053254762185835165176803750` in
let npos = REAL_ARITH `!s:real. &0:real < &2521005779196350341220952707025000` in
let ppos = REAL_ARITH `!s:real. &0:real < &4447152981536879285851528064411523937349` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&329816053254762185835165176803750)*(&15433728)+(&2521005779196350341220952707025000)*(&5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &3604480) * &0 + (-- &2555904) * -- &1 / &4)) /\
  ((&329816053254762185835165176803750)*(-- &29458432)+(&2521005779196350341220952707025000)*(-- &8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &3604480) * &1 / &4 + (-- &2555904) * &1 / &16)) /\
  (&329816053254762185835165176803750)*(&21015329)+(&2521005779196350341220952707025000)*(&6951751)+(&4447152981536879285851528064411523937349) = (&9095112875435851152418329474851893)*(&3177943)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &3604480) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &2555904) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3177943
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &329816053254762185835165176803750` [mpos] THEN
  note `&0:real < &2521005779196350341220952707025000` [npos] THEN
  note `&0:real < &4447152981536879285851528064411523937349` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&329816053254762185835165176803750)*(&15433728)+(&2521005779196350341220952707025000)*(&5660672))*s pow 4 = (&9095112875435851152418329474851893)*((-- &3604480) * &0 + (-- &2555904) * -- &1 / &4) /\ ((&329816053254762185835165176803750)*(-- &29458432)+(&2521005779196350341220952707025000)*(-- &8896512))*s pow 4 = (&9095112875435851152418329474851893)*((-- &3604480) * &1 / &4 + (-- &2555904) * &1 / &16) /\ (&329816053254762185835165176803750)*(&21015329)+(&2521005779196350341220952707025000)*(&6951751)+(&4447152981536879285851528064411523937349) = (&9095112875435851152418329474851893)*(&3177943)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &168429563048608533821506680104375` in
let npos = REAL_ARITH `!s:real. &0:real < &10344841223590918054184737796399375` in
let ppos = REAL_ARITH `!s:real. &0:real < &25761035472925267231956663499969294126999` in
let qpos = REAL_ARITH `!s:real. &0:real < &28252030659593626075480540339059139` in
let mqrel = REAL_ARITH `
  ((&168429563048608533821506680104375)*(&373096448)+(&10344841223590918054184737796399375)*(&5701632))*(&30902639 / &41749730) pow 4 = (&28252030659593626075480540339059139)*(((-- &5537792) * &0 + (-- &5177344) * -- &1 / &4)) /\
  ((&168429563048608533821506680104375)*(-- &503644160)+(&10344841223590918054184737796399375)*(-- &7340032))*(&30902639 / &41749730) pow 4 = (&28252030659593626075480540339059139)*(((-- &5537792) * &1 / &4 + (-- &5177344) * &1 / &16)) /\
  (&168429563048608533821506680104375)*(&426281637)+(&10344841223590918054184737796399375)*(&6407825)+(&25761035472925267231956663499969294126999) = (&28252030659593626075480540339059139)*(&5799491)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (&5701632) * x + (-- &7340032) * y <= &6407825 ==>
  (-- &5537792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &5177344) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5799491
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &168429563048608533821506680104375` [mpos] THEN
  note `&0:real < &10344841223590918054184737796399375` [npos] THEN
  note `&0:real < &25761035472925267231956663499969294126999` [ppos] THEN
  note `&0:real < &28252030659593626075480540339059139` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&168429563048608533821506680104375)*(&373096448)+(&10344841223590918054184737796399375)*(&5701632))*s pow 4 = (&28252030659593626075480540339059139)*((-- &5537792) * &0 + (-- &5177344) * -- &1 / &4) /\ ((&168429563048608533821506680104375)*(-- &503644160)+(&10344841223590918054184737796399375)*(-- &7340032))*s pow 4 = (&28252030659593626075480540339059139)*((-- &5537792) * &1 / &4 + (-- &5177344) * &1 / &16) /\ (&168429563048608533821506680104375)*(&426281637)+(&10344841223590918054184737796399375)*(&6407825)+(&25761035472925267231956663499969294126999) = (&28252030659593626075480540339059139)*(&5799491)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &3458335165401603898569539288826586250` in
let npos = REAL_ARITH `!s:real. &0:real < &147823810552799285054680728697152500` in
let ppos = REAL_ARITH `!s:real. &0:real < &31870947276912747436674164364227104462667613` in
let qpos = REAL_ARITH `!s:real. &0:real < &612562646364046066852172396132938249` in
let mqrel = REAL_ARITH `
  ((&3458335165401603898569539288826586250)*(&46596096)+(&147823810552799285054680728697152500)*(&84901888))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((-- &289406976) * &0 + (-- &340459520) * -- &1 / &4)) /\
  ((&3458335165401603898569539288826586250)*(-- &51871744)+(&147823810552799285054680728697152500)*(-- &79036416))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((-- &289406976) * &1 / &4 + (-- &340459520) * &1 / &16)) /\
  (&3458335165401603898569539288826586250)*(&49963991)+(&147823810552799285054680728697152500)*(&86789633)+(&31870947276912747436674164364227104462667613) = (&612562646364046066852172396132938249)*(&355053887)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (-- &289406976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &340459520) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &355053887
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3458335165401603898569539288826586250` [mpos] THEN
  note `&0:real < &147823810552799285054680728697152500` [npos] THEN
  note `&0:real < &31870947276912747436674164364227104462667613` [ppos] THEN
  note `&0:real < &612562646364046066852172396132938249` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3458335165401603898569539288826586250)*(&46596096)+(&147823810552799285054680728697152500)*(&84901888))*s pow 4 = (&612562646364046066852172396132938249)*((-- &289406976) * &0 + (-- &340459520) * -- &1 / &4) /\ ((&3458335165401603898569539288826586250)*(-- &51871744)+(&147823810552799285054680728697152500)*(-- &79036416))*s pow 4 = (&612562646364046066852172396132938249)*((-- &289406976) * &1 / &4 + (-- &340459520) * &1 / &16) /\ (&3458335165401603898569539288826586250)*(&49963991)+(&147823810552799285054680728697152500)*(&86789633)+(&31870947276912747436674164364227104462667613) = (&612562646364046066852172396132938249)*(&355053887)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &32933391348885589944081909895448125` in
let npos = REAL_ARITH `!s:real. &0:real < &13233208848768352561466516952056250` in
let ppos = REAL_ARITH `!s:real. &0:real < &478723714745886334616205672242590008202717` in
let qpos = REAL_ARITH `!s:real. &0:real < &1225125292728092133704344792265876498` in
let mqrel = REAL_ARITH `
  ((&32933391348885589944081909895448125)*(&46596096)+(&13233208848768352561466516952056250)*(&84901888))*(&30902639 / &41749730) pow 4 = (&1225125292728092133704344792265876498)*(((-- &2048000) * &0 + (-- &2605056) * -- &1 / &4)) /\
  ((&32933391348885589944081909895448125)*(-- &51871744)+(&13233208848768352561466516952056250)*(-- &79036416))*(&30902639 / &41749730) pow 4 = (&1225125292728092133704344792265876498)*(((-- &2048000) * &1 / &4 + (-- &2605056) * &1 / &16)) /\
  (&32933391348885589944081909895448125)*(&49963991)+(&13233208848768352561466516952056250)*(&86789633)+(&478723714745886334616205672242590008202717) = (&1225125292728092133704344792265876498)*(&2671329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (-- &2048000) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &2605056) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &2671329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &32933391348885589944081909895448125` [mpos] THEN
  note `&0:real < &13233208848768352561466516952056250` [npos] THEN
  note `&0:real < &478723714745886334616205672242590008202717` [ppos] THEN
  note `&0:real < &1225125292728092133704344792265876498` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&32933391348885589944081909895448125)*(&46596096)+(&13233208848768352561466516952056250)*(&84901888))*s pow 4 = (&1225125292728092133704344792265876498)*((-- &2048000) * &0 + (-- &2605056) * -- &1 / &4) /\ ((&32933391348885589944081909895448125)*(-- &51871744)+(&13233208848768352561466516952056250)*(-- &79036416))*s pow 4 = (&1225125292728092133704344792265876498)*((-- &2048000) * &1 / &4 + (-- &2605056) * &1 / &16) /\ (&32933391348885589944081909895448125)*(&49963991)+(&13233208848768352561466516952056250)*(&86789633)+(&478723714745886334616205672242590008202717) = (&1225125292728092133704344792265876498)*(&2671329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &286441340941804108389780726423053125` in
let npos = REAL_ARITH `!s:real. &0:real < &85437462422241121870479023832561875` in
let ppos = REAL_ARITH `!s:real. &0:real < &5950496995960097009603125073265570454349604` in
let qpos = REAL_ARITH `!s:real. &0:real < &1010791429476243681930188507312638596` in
let mqrel = REAL_ARITH `
  ((&286441340941804108389780726423053125)*(&84901888)+(&85437462422241121870479023832561875)*(&134447104))*(&30902639 / &41749730) pow 4 = (&1010791429476243681930188507312638596)*(((-- &26116096) * &0 + (-- &42532864) * -- &1 / &4)) /\
  ((&286441340941804108389780726423053125)*(-- &79036416)+(&85437462422241121870479023832561875)*(-- &97124352))*(&30902639 / &41749730) pow 4 = (&1010791429476243681930188507312638596)*(((-- &26116096) * &1 / &4 + (-- &42532864) * &1 / &16)) /\
  (&286441340941804108389780726423053125)*(&86789633)+(&85437462422241121870479023832561875)*(&131957561)+(&5950496995960097009603125073265570454349604) = (&1010791429476243681930188507312638596)*(&41635449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (-- &26116096) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &42532864) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &41635449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &286441340941804108389780726423053125` [mpos] THEN
  note `&0:real < &85437462422241121870479023832561875` [npos] THEN
  note `&0:real < &5950496995960097009603125073265570454349604` [ppos] THEN
  note `&0:real < &1010791429476243681930188507312638596` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&286441340941804108389780726423053125)*(&84901888)+(&85437462422241121870479023832561875)*(&134447104))*s pow 4 = (&1010791429476243681930188507312638596)*((-- &26116096) * &0 + (-- &42532864) * -- &1 / &4) /\ ((&286441340941804108389780726423053125)*(-- &79036416)+(&85437462422241121870479023832561875)*(-- &97124352))*s pow 4 = (&1010791429476243681930188507312638596)*((-- &26116096) * &1 / &4 + (-- &42532864) * &1 / &16) /\ (&286441340941804108389780726423053125)*(&86789633)+(&85437462422241121870479023832561875)*(&131957561)+(&5950496995960097009603125073265570454349604) = (&1010791429476243681930188507312638596)*(&41635449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &990725856037588372534636930271310000` in
let npos = REAL_ARITH `!s:real. &0:real < &307658908603501312845414901644589375` in
let ppos = REAL_ARITH `!s:real. &0:real < &23669386238912878490918043812977545439399370` in
let qpos = REAL_ARITH `!s:real. &0:real < &1271151689169521189335689489976324727` in
let mqrel = REAL_ARITH `
  ((&990725856037588372534636930271310000)*(&134447104)+(&307658908603501312845414901644589375)*(&100401152))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((-- &66748416) * &0 + (-- &154992640) * -- &1 / &4)) /\
  ((&990725856037588372534636930271310000)*(-- &97124352)+(&307658908603501312845414901644589375)*(-- &50266112))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((-- &66748416) * &1 / &4 + (-- &154992640) * &1 / &16)) /\
  (&990725856037588372534636930271310000)*(&131957561)+(&307658908603501312845414901644589375)*(&95584823)+(&23669386238912878490918043812977545439399370) = (&1271151689169521189335689489976324727)*(&144601685)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (-- &66748416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &154992640) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &144601685
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &990725856037588372534636930271310000` [mpos] THEN
  note `&0:real < &307658908603501312845414901644589375` [npos] THEN
  note `&0:real < &23669386238912878490918043812977545439399370` [ppos] THEN
  note `&0:real < &1271151689169521189335689489976324727` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&990725856037588372534636930271310000)*(&134447104)+(&307658908603501312845414901644589375)*(&100401152))*s pow 4 = (&1271151689169521189335689489976324727)*((-- &66748416) * &0 + (-- &154992640) * -- &1 / &4) /\ ((&990725856037588372534636930271310000)*(-- &97124352)+(&307658908603501312845414901644589375)*(-- &50266112))*s pow 4 = (&1271151689169521189335689489976324727)*((-- &66748416) * &1 / &4 + (-- &154992640) * &1 / &16) /\ (&990725856037588372534636930271310000)*(&131957561)+(&307658908603501312845414901644589375)*(&95584823)+(&23669386238912878490918043812977545439399370) = (&1271151689169521189335689489976324727)*(&144601685)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &41039657466749285895423646280629375` in
let npos = REAL_ARITH `!s:real. &0:real < &35139685704084893838638940466060000` in
let ppos = REAL_ARITH `!s:real. &0:real < &810156786838348409627601763543428853205845` in
let qpos = REAL_ARITH `!s:real. &0:real < &438117597115876417199306125508442646` in
let mqrel = REAL_ARITH `
  ((&41039657466749285895423646280629375)*(&100401152)+(&35139685704084893838638940466060000)*(&64782336))*(&30902639 / &41749730) pow 4 = (&438117597115876417199306125508442646)*(((-- &3899392) * &0 + (-- &17530880) * -- &1 / &4)) /\
  ((&41039657466749285895423646280629375)*(-- &50266112)+(&35139685704084893838638940466060000)*(-- &27295744))*(&30902639 / &41749730) pow 4 = (&438117597115876417199306125508442646)*(((-- &3899392) * &1 / &4 + (-- &17530880) * &1 / &16)) /\
  (&41039657466749285895423646280629375)*(&95584823)+(&35139685704084893838638940466060000)*(&61112343)+(&810156786838348409627601763543428853205845) = (&438117597115876417199306125508442646)*(&15704445)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&64782336) * x + (-- &27295744) * y <= &61112343 ==>
  (-- &3899392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &17530880) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &15704445
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &41039657466749285895423646280629375` [mpos] THEN
  note `&0:real < &35139685704084893838638940466060000` [npos] THEN
  note `&0:real < &810156786838348409627601763543428853205845` [ppos] THEN
  note `&0:real < &438117597115876417199306125508442646` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&41039657466749285895423646280629375)*(&100401152)+(&35139685704084893838638940466060000)*(&64782336))*s pow 4 = (&438117597115876417199306125508442646)*((-- &3899392) * &0 + (-- &17530880) * -- &1 / &4) /\ ((&41039657466749285895423646280629375)*(-- &50266112)+(&35139685704084893838638940466060000)*(-- &27295744))*s pow 4 = (&438117597115876417199306125508442646)*((-- &3899392) * &1 / &4 + (-- &17530880) * &1 / &16) /\ (&41039657466749285895423646280629375)*(&95584823)+(&35139685704084893838638940466060000)*(&61112343)+(&810156786838348409627601763543428853205845) = (&438117597115876417199306125508442646)*(&15704445)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &11646021311340957645118776550342125` in
let npos = REAL_ARITH `!s:real. &0:real < &552988245220020036296495776550125` in
let ppos = REAL_ARITH `!s:real. &0:real < &5761945166021636832791359073384344602714` in
let qpos = REAL_ARITH `!s:real. &0:real < &873670724422695819113281824617278` in
let mqrel = REAL_ARITH `
  ((&11646021311340957645118776550342125)*(&3866624)+(&552988245220020036296495776550125)*(&39124992))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((-- &65536) * &0 + (-- &91619328) * -- &1 / &4)) /\
  ((&11646021311340957645118776550342125)*(-- &1310720)+(&552988245220020036296495776550125)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((-- &65536) * &1 / &4 + (-- &91619328) * &1 / &16)) /\
  (&11646021311340957645118776550342125)*(&3642043)+(&552988245220020036296495776550125)*(&38657149)+(&5761945166021636832791359073384344602714) = (&873670724422695819113281824617278)*(&79611463)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (-- &65536) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &91619328) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &79611463
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11646021311340957645118776550342125` [mpos] THEN
  note `&0:real < &552988245220020036296495776550125` [npos] THEN
  note `&0:real < &5761945166021636832791359073384344602714` [ppos] THEN
  note `&0:real < &873670724422695819113281824617278` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&11646021311340957645118776550342125)*(&3866624)+(&552988245220020036296495776550125)*(&39124992))*s pow 4 = (&873670724422695819113281824617278)*((-- &65536) * &0 + (-- &91619328) * -- &1 / &4) /\ ((&11646021311340957645118776550342125)*(-- &1310720)+(&552988245220020036296495776550125)*(-- &2621440))*s pow 4 = (&873670724422695819113281824617278)*((-- &65536) * &1 / &4 + (-- &91619328) * &1 / &16) /\ (&11646021311340957645118776550342125)*(&3642043)+(&552988245220020036296495776550125)*(&38657149)+(&5761945166021636832791359073384344602714) = (&873670724422695819113281824617278)*(&79611463)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &16987308225750991158262403498842625` in
let npos = REAL_ARITH `!s:real. &0:real < &2721191314796380445076080755246625` in
let ppos = REAL_ARITH `!s:real. &0:real < &10894392903570612626398101539072298284484` in
let qpos = REAL_ARITH `!s:real. &0:real < &1747341448845391638226563649234556` in
let mqrel = REAL_ARITH `
  ((&16987308225750991158262403498842625)*(&3866624)+(&2721191314796380445076080755246625)*(&39124992))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((&9371648) * &0 + (-- &118292480) * -- &1 / &4)) /\
  ((&16987308225750991158262403498842625)*(-- &1310720)+(&2721191314796380445076080755246625)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((&9371648) * &1 / &4 + (-- &118292480) * &1 / &16)) /\
  (&16987308225750991158262403498842625)*(&3642043)+(&2721191314796380445076080755246625)*(&38657149)+(&10894392903570612626398101539072298284484) = (&1747341448845391638226563649234556)*(&101844089)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&9371648) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &118292480) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &101844089
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16987308225750991158262403498842625` [mpos] THEN
  note `&0:real < &2721191314796380445076080755246625` [npos] THEN
  note `&0:real < &10894392903570612626398101539072298284484` [ppos] THEN
  note `&0:real < &1747341448845391638226563649234556` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&16987308225750991158262403498842625)*(&3866624)+(&2721191314796380445076080755246625)*(&39124992))*s pow 4 = (&1747341448845391638226563649234556)*((&9371648) * &0 + (-- &118292480) * -- &1 / &4) /\ ((&16987308225750991158262403498842625)*(-- &1310720)+(&2721191314796380445076080755246625)*(-- &2621440))*s pow 4 = (&1747341448845391638226563649234556)*((&9371648) * &1 / &4 + (-- &118292480) * &1 / &16) /\ (&16987308225750991158262403498842625)*(&3642043)+(&2721191314796380445076080755246625)*(&38657149)+(&10894392903570612626398101539072298284484) = (&1747341448845391638226563649234556)*(&101844089)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &112678808019215675275853510680875` in
let npos = REAL_ARITH `!s:real. &0:real < &43711933950157479690767573573875` in
let ppos = REAL_ARITH `!s:real. &0:real < &109081305850215475290664583554273369903` in
let qpos = REAL_ARITH `!s:real. &0:real < &436835362211347909556640912308639` in
let mqrel = REAL_ARITH `
  ((&112678808019215675275853510680875)*(&3866624)+(&43711933950157479690767573573875)*(&39124992))*(&30902639 / &41749730) pow 4 = (&436835362211347909556640912308639)*(((&753664) * &0 + (-- &5898240) * -- &1 / &4)) /\
  ((&112678808019215675275853510680875)*(-- &1310720)+(&43711933950157479690767573573875)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&436835362211347909556640912308639)*(((&753664) * &1 / &4 + (-- &5898240) * &1 / &16)) /\
  (&112678808019215675275853510680875)*(&3642043)+(&43711933950157479690767573573875)*(&38657149)+(&109081305850215475290664583554273369903) = (&436835362211347909556640912308639)*(&5057377)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&753664) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &5898240) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5057377
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &112678808019215675275853510680875` [mpos] THEN
  note `&0:real < &43711933950157479690767573573875` [npos] THEN
  note `&0:real < &109081305850215475290664583554273369903` [ppos] THEN
  note `&0:real < &436835362211347909556640912308639` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&112678808019215675275853510680875)*(&3866624)+(&43711933950157479690767573573875)*(&39124992))*s pow 4 = (&436835362211347909556640912308639)*((&753664) * &0 + (-- &5898240) * -- &1 / &4) /\ ((&112678808019215675275853510680875)*(-- &1310720)+(&43711933950157479690767573573875)*(-- &2621440))*s pow 4 = (&436835362211347909556640912308639)*((&753664) * &1 / &4 + (-- &5898240) * &1 / &16) /\ (&112678808019215675275853510680875)*(&3642043)+(&43711933950157479690767573573875)*(&38657149)+(&109081305850215475290664583554273369903) = (&436835362211347909556640912308639)*(&5057377)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &54718796401045656811824127480213375` in
let npos = REAL_ARITH `!s:real. &0:real < &28951313918468724283355808106121375` in
let ppos = REAL_ARITH `!s:real. &0:real < &64163620681854107922897523564508909851868` in
let qpos = REAL_ARITH `!s:real. &0:real < &1747341448845391638226563649234556` in
let mqrel = REAL_ARITH `
  ((&54718796401045656811824127480213375)*(&3866624)+(&28951313918468724283355808106121375)*(&39124992))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((&129499136) * &0 + (-- &923729920) * -- &1 / &4)) /\
  ((&54718796401045656811824127480213375)*(-- &1310720)+(&28951313918468724283355808106121375)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((&129499136) * &1 / &4 + (-- &923729920) * &1 / &16)) /\
  (&54718796401045656811824127480213375)*(&3642043)+(&28951313918468724283355808106121375)*(&38657149)+(&64163620681854107922897523564508909851868) = (&1747341448845391638226563649234556)*(&791274703)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&129499136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &923729920) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &791274703
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &54718796401045656811824127480213375` [mpos] THEN
  note `&0:real < &28951313918468724283355808106121375` [npos] THEN
  note `&0:real < &64163620681854107922897523564508909851868` [ppos] THEN
  note `&0:real < &1747341448845391638226563649234556` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&54718796401045656811824127480213375)*(&3866624)+(&28951313918468724283355808106121375)*(&39124992))*s pow 4 = (&1747341448845391638226563649234556)*((&129499136) * &0 + (-- &923729920) * -- &1 / &4) /\ ((&54718796401045656811824127480213375)*(-- &1310720)+(&28951313918468724283355808106121375)*(-- &2621440))*s pow 4 = (&1747341448845391638226563649234556)*((&129499136) * &1 / &4 + (-- &923729920) * &1 / &16) /\ (&54718796401045656811824127480213375)*(&3642043)+(&28951313918468724283355808106121375)*(&38657149)+(&64163620681854107922897523564508909851868) = (&1747341448845391638226563649234556)*(&791274703)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &895316110230202070990308902696875` in
let npos = REAL_ARITH `!s:real. &0:real < &962156252499773890500083819716875` in
let ppos = REAL_ARITH `!s:real. &0:real < &1968852426982449004793167532923111421704` in
let qpos = REAL_ARITH `!s:real. &0:real < &6989365795381566552906254596938224` in
let mqrel = REAL_ARITH `
  ((&895316110230202070990308902696875)*(&3866624)+(&962156252499773890500083819716875)*(&39124992))*(&30902639 / &41749730) pow 4 = (&6989365795381566552906254596938224)*(((&1130496) * &0 + (-- &7061504) * -- &1 / &4)) /\
  ((&895316110230202070990308902696875)*(-- &1310720)+(&962156252499773890500083819716875)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&6989365795381566552906254596938224)*(((&1130496) * &1 / &4 + (-- &7061504) * &1 / &16)) /\
  (&895316110230202070990308902696875)*(&3642043)+(&962156252499773890500083819716875)*(&38657149)+(&1968852426982449004793167532923111421704) = (&6989365795381566552906254596938224)*(&6069771)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&1130496) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &7061504) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &6069771
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &895316110230202070990308902696875` [mpos] THEN
  note `&0:real < &962156252499773890500083819716875` [npos] THEN
  note `&0:real < &1968852426982449004793167532923111421704` [ppos] THEN
  note `&0:real < &6989365795381566552906254596938224` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&895316110230202070990308902696875)*(&3866624)+(&962156252499773890500083819716875)*(&39124992))*s pow 4 = (&6989365795381566552906254596938224)*((&1130496) * &0 + (-- &7061504) * -- &1 / &4) /\ ((&895316110230202070990308902696875)*(-- &1310720)+(&962156252499773890500083819716875)*(-- &2621440))*s pow 4 = (&6989365795381566552906254596938224)*((&1130496) * &1 / &4 + (-- &7061504) * &1 / &16) /\ (&895316110230202070990308902696875)*(&3642043)+(&962156252499773890500083819716875)*(&38657149)+(&1968852426982449004793167532923111421704) = (&6989365795381566552906254596938224)*(&6069771)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &333938857495047337494601915751788125` in
let npos = REAL_ARITH `!s:real. &0:real < &369329763392946559507136970465625` in
let ppos = REAL_ARITH `!s:real. &0:real < &103262452074721270250360467926361469155654` in
let qpos = REAL_ARITH `!s:real. &0:real < &2285792559280199317040906350714547384` in
let mqrel = REAL_ARITH `
  ((&333938857495047337494601915751788125)*(&5865472)+(&369329763392946559507136970465625)*(&439386112))*(&30902639 / &41749730) pow 4 = (&2285792559280199317040906350714547384)*(((&481280) * &0 + (-- &1114112) * -- &1 / &4)) /\
  ((&333938857495047337494601915751788125)*(&950272)+(&369329763392946559507136970465625)*(&185892864))*(&30902639 / &41749730) pow 4 = (&2285792559280199317040906350714547384)*(((&481280) * &1 / &4 + (-- &1114112) * &1 / &16)) /\
  (&333938857495047337494601915751788125)*(&6035371)+(&369329763392946559507136970465625)*(&480443643)+(&103262452074721270250360467926361469155654) = (&2285792559280199317040906350714547384)*(&1004531)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&481280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &1114112) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &1004531
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &333938857495047337494601915751788125` [mpos] THEN
  note `&0:real < &369329763392946559507136970465625` [npos] THEN
  note `&0:real < &103262452074721270250360467926361469155654` [ppos] THEN
  note `&0:real < &2285792559280199317040906350714547384` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&333938857495047337494601915751788125)*(&5865472)+(&369329763392946559507136970465625)*(&439386112))*s pow 4 = (&2285792559280199317040906350714547384)*((&481280) * &0 + (-- &1114112) * -- &1 / &4) /\ ((&333938857495047337494601915751788125)*(&950272)+(&369329763392946559507136970465625)*(&185892864))*s pow 4 = (&2285792559280199317040906350714547384)*((&481280) * &1 / &4 + (-- &1114112) * &1 / &16) /\ (&333938857495047337494601915751788125)*(&6035371)+(&369329763392946559507136970465625)*(&480443643)+(&103262452074721270250360467926361469155654) = (&2285792559280199317040906350714547384)*(&1004531)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &113177830445023728519238989322717500` in
let npos = REAL_ARITH `!s:real. &0:real < &34657373313844233550130905553472500` in
let ppos = REAL_ARITH `!s:real. &0:real < &586547345971719081715432878086409243799445` in
let qpos = REAL_ARITH `!s:real. &0:real < &285724069910024914630113293839318423` in
let mqrel = REAL_ARITH `
  ((&113177830445023728519238989322717500)*(&5865472)+(&34657373313844233550130905553472500)*(&439386112))*(&30902639 / &41749730) pow 4 = (&285724069910024914630113293839318423)*(((&44220416) * &0 + (-- &66781184) * -- &1 / &4)) /\
  ((&113177830445023728519238989322717500)*(&950272)+(&34657373313844233550130905553472500)*(&185892864))*(&30902639 / &41749730) pow 4 = (&285724069910024914630113293839318423)*(((&44220416) * &1 / &4 + (-- &66781184) * &1 / &16)) /\
  (&113177830445023728519238989322717500)*(&6035371)+(&34657373313844233550130905553472500)*(&480443643)+(&586547345971719081715432878086409243799445) = (&285724069910024914630113293839318423)*(&62719715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&44220416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &66781184) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &62719715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &113177830445023728519238989322717500` [mpos] THEN
  note `&0:real < &34657373313844233550130905553472500` [npos] THEN
  note `&0:real < &586547345971719081715432878086409243799445` [ppos] THEN
  note `&0:real < &285724069910024914630113293839318423` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&113177830445023728519238989322717500)*(&5865472)+(&34657373313844233550130905553472500)*(&439386112))*s pow 4 = (&285724069910024914630113293839318423)*((&44220416) * &0 + (-- &66781184) * -- &1 / &4) /\ ((&113177830445023728519238989322717500)*(&950272)+(&34657373313844233550130905553472500)*(&185892864))*s pow 4 = (&285724069910024914630113293839318423)*((&44220416) * &1 / &4 + (-- &66781184) * &1 / &16) /\ (&113177830445023728519238989322717500)*(&6035371)+(&34657373313844233550130905553472500)*(&480443643)+(&586547345971719081715432878086409243799445) = (&285724069910024914630113293839318423)*(&62719715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &8858476654897939762069639796634375` in
let npos = REAL_ARITH `!s:real. &0:real < &7270557190292799534475201446448750` in
let ppos = REAL_ARITH `!s:real. &0:real < &164888823917505789374642032704055929830` in
let qpos = REAL_ARITH `!s:real. &0:real < &9531036264030891446297399111769491` in
let mqrel = REAL_ARITH `
  ((&8858476654897939762069639796634375)*(&49741824)+(&7270557190292799534475201446448750)*(&33521664))*(&30902639 / &41749730) pow 4 = (&9531036264030891446297399111769491)*(((&75169792) * &0 + (-- &86212608) * -- &1 / &4)) /\
  ((&8858476654897939762069639796634375)*(&27000832)+(&7270557190292799534475201446448750)*(&25640960))*(&30902639 / &41749730) pow 4 = (&9531036264030891446297399111769491)*(((&75169792) * &1 / &4 + (-- &86212608) * &1 / &16)) /\
  (&8858476654897939762069639796634375)*(&57079641)+(&7270557190292799534475201446448750)*(&41914863)+(&164888823917505789374642032704055929830) = (&9531036264030891446297399111769491)*(&85043005)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&75169792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &86212608) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &85043005
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8858476654897939762069639796634375` [mpos] THEN
  note `&0:real < &7270557190292799534475201446448750` [npos] THEN
  note `&0:real < &164888823917505789374642032704055929830` [ppos] THEN
  note `&0:real < &9531036264030891446297399111769491` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&8858476654897939762069639796634375)*(&49741824)+(&7270557190292799534475201446448750)*(&33521664))*s pow 4 = (&9531036264030891446297399111769491)*((&75169792) * &0 + (-- &86212608) * -- &1 / &4) /\ ((&8858476654897939762069639796634375)*(&27000832)+(&7270557190292799534475201446448750)*(&25640960))*s pow 4 = (&9531036264030891446297399111769491)*((&75169792) * &1 / &4 + (-- &86212608) * &1 / &16) /\ (&8858476654897939762069639796634375)*(&57079641)+(&7270557190292799534475201446448750)*(&41914863)+(&164888823917505789374642032704055929830) = (&9531036264030891446297399111769491)*(&85043005)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &7957981814636520866220618994375` in
let npos = REAL_ARITH `!s:real. &0:real < &11318252582691869844044422144498750` in
let ppos = REAL_ARITH `!s:real. &0:real < &98804352363922191042865976247032896014` in
let qpos = REAL_ARITH `!s:real. &0:real < &4084729827441810619841742476472639` in
let mqrel = REAL_ARITH `
  ((&7957981814636520866220618994375)*(&49741824)+(&11318252582691869844044422144498750)*(&33521664))*(&30902639 / &41749730) pow 4 = (&4084729827441810619841742476472639)*(((&113278976) * &0 + (-- &111640576) * -- &1 / &4)) /\
  ((&7957981814636520866220618994375)*(&27000832)+(&11318252582691869844044422144498750)*(&25640960))*(&30902639 / &41749730) pow 4 = (&4084729827441810619841742476472639)*(((&113278976) * &1 / &4 + (-- &111640576) * &1 / &16)) /\
  (&7957981814636520866220618994375)*(&57079641)+(&11318252582691869844044422144498750)*(&41914863)+(&98804352363922191042865976247032896014) = (&4084729827441810619841742476472639)*(&116276001)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&49741824) * x + (&27000832) * y <= &57079641 ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&113278976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &111640576) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &116276001
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7957981814636520866220618994375` [mpos] THEN
  note `&0:real < &11318252582691869844044422144498750` [npos] THEN
  note `&0:real < &98804352363922191042865976247032896014` [ppos] THEN
  note `&0:real < &4084729827441810619841742476472639` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&7957981814636520866220618994375)*(&49741824)+(&11318252582691869844044422144498750)*(&33521664))*s pow 4 = (&4084729827441810619841742476472639)*((&113278976) * &0 + (-- &111640576) * -- &1 / &4) /\ ((&7957981814636520866220618994375)*(&27000832)+(&11318252582691869844044422144498750)*(&25640960))*s pow 4 = (&4084729827441810619841742476472639)*((&113278976) * &1 / &4 + (-- &111640576) * &1 / &16) /\ (&7957981814636520866220618994375)*(&57079641)+(&11318252582691869844044422144498750)*(&41914863)+(&98804352363922191042865976247032896014) = (&4084729827441810619841742476472639)*(&116276001)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_ARITH `!s:real. &0:real < &3607848588414387984902623361875` in
let npos = REAL_ARITH `!s:real. &0:real < &17161776188015998509869168253836875` in
let ppos = REAL_ARITH `!s:real. &0:real < &8959065050212919978873377562094456360` in
let qpos = REAL_ARITH `!s:real. &0:real < &3545753420204009754397118720367408` in
let mqrel = REAL_ARITH `
  ((&3607848588414387984902623361875)*(&33521664)+(&17161776188015998509869168253836875)*(&1867776))*(&30902639 / &41749730) pow 4 = (&3545753420204009754397118720367408)*(((&11419648) * &0 + (-- &10895360) * -- &1 / &4)) /\
  ((&3607848588414387984902623361875)*(&25640960)+(&17161776188015998509869168253836875)*(&1490944))*(&30902639 / &41749730) pow 4 = (&3545753420204009754397118720367408)*(((&11419648) * &1 / &4 + (-- &10895360) * &1 / &16)) /\
  (&3607848588414387984902623361875)*(&41914863)+(&17161776188015998509869168253836875)*(&2368161)+(&8959065050212919978873377562094456360) = (&3545753420204009754397118720367408)*(&11507295)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33521664) * x + (&25640960) * y <= &41914863 ==>
  (&1867776) * x + (&1490944) * y <= &2368161 ==>
  (&11419648) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &10895360) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &11507295
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3607848588414387984902623361875` [mpos] THEN
  note `&0:real < &17161776188015998509869168253836875` [npos] THEN
  note `&0:real < &8959065050212919978873377562094456360` [ppos] THEN
  note `&0:real < &3545753420204009754397118720367408` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3607848588414387984902623361875)*(&33521664)+(&17161776188015998509869168253836875)*(&1867776))*s pow 4 = (&3545753420204009754397118720367408)*((&11419648) * &0 + (-- &10895360) * -- &1 / &4) /\ ((&3607848588414387984902623361875)*(&25640960)+(&17161776188015998509869168253836875)*(&1490944))*s pow 4 = (&3545753420204009754397118720367408)*((&11419648) * &1 / &4 + (-- &10895360) * &1 / &16) /\ (&3607848588414387984902623361875)*(&41914863)+(&17161776188015998509869168253836875)*(&2368161)+(&8959065050212919978873377562094456360) = (&3545753420204009754397118720367408)*(&11507295)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L29 =
let mpos = REAL_ARITH `!s:real. &0:real < &21388155028925486666480145193125` in
let npos = REAL_ARITH `!s:real. &0:real < &914908972181639058372435589375` in
let ppos = REAL_ARITH `!s:real. &0:real < &48439294848239220525220318422817012` in
let qpos = REAL_ARITH `!s:real. &0:real < &62014205908917866074846726590788` in
let mqrel = REAL_ARITH `
  ((&21388155028925486666480145193125)*(&7634944)+(&914908972181639058372435589375)*(&950272))*(&30902639 / &41749730) pow 4 = (&62014205908917866074846726590788)*(((&4050944) * &0 + (-- &3178496) * -- &1 / &4)) /\
  ((&21388155028925486666480145193125)*(&7815168)+(&914908972181639058372435589375)*(&1130496))*(&30902639 / &41749730) pow 4 = (&62014205908917866074846726590788)*(((&4050944) * &1 / &4 + (-- &3178496) * &1 / &16)) /\
  (&21388155028925486666480145193125)*(&10605687)+(&914908972181639058372435589375)*(&1407123)+(&48439294848239220525220318422817012) = (&62014205908917866074846726590788)*(&3679349)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&950272) * x + (&1130496) * y <= &1407123 ==>
  (&4050944) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &3178496) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3679349
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &21388155028925486666480145193125` [mpos] THEN
  note `&0:real < &914908972181639058372435589375` [npos] THEN
  note `&0:real < &48439294848239220525220318422817012` [ppos] THEN
  note `&0:real < &62014205908917866074846726590788` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&21388155028925486666480145193125)*(&7634944)+(&914908972181639058372435589375)*(&950272))*s pow 4 = (&62014205908917866074846726590788)*((&4050944) * &0 + (-- &3178496) * -- &1 / &4) /\ ((&21388155028925486666480145193125)*(&7815168)+(&914908972181639058372435589375)*(&1130496))*s pow 4 = (&62014205908917866074846726590788)*((&4050944) * &1 / &4 + (-- &3178496) * &1 / &16) /\ (&21388155028925486666480145193125)*(&10605687)+(&914908972181639058372435589375)*(&1407123)+(&48439294848239220525220318422817012) = (&62014205908917866074846726590788)*(&3679349)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L30 =
let mpos = REAL_ARITH `!s:real. &0:real < &500610569684293069675483624375` in
let npos = REAL_ARITH `!s:real. &0:real < &125100855120761099170283787098125` in
let ppos = REAL_ARITH `!s:real. &0:real < &38516595092018891067780522058782311` in
let qpos = REAL_ARITH `!s:real. &0:real < &15503551477229466518711681647697` in
let mqrel = REAL_ARITH `
  ((&500610569684293069675483624375)*(&7634944)+(&125100855120761099170283787098125)*(&950272))*(&30902639 / &41749730) pow 4 = (&15503551477229466518711681647697)*(((&13631488) * &0 + (-- &9502720) * -- &1 / &4)) /\
  ((&500610569684293069675483624375)*(&7815168)+(&125100855120761099170283787098125)*(&1130496))*(&30902639 / &41749730) pow 4 = (&15503551477229466518711681647697)*(((&13631488) * &1 / &4 + (-- &9502720) * &1 / &16)) /\
  (&500610569684293069675483624375)*(&10605687)+(&125100855120761099170283787098125)*(&1407123)+(&38516595092018891067780522058782311) = (&15503551477229466518711681647697)*(&11699263)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7634944) * x + (&7815168) * y <= &10605687 ==>
  (&950272) * x + (&1130496) * y <= &1407123 ==>
  (&13631488) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &9502720) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &11699263
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &500610569684293069675483624375` [mpos] THEN
  note `&0:real < &125100855120761099170283787098125` [npos] THEN
  note `&0:real < &38516595092018891067780522058782311` [ppos] THEN
  note `&0:real < &15503551477229466518711681647697` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&500610569684293069675483624375)*(&7634944)+(&125100855120761099170283787098125)*(&950272))*s pow 4 = (&15503551477229466518711681647697)*((&13631488) * &0 + (-- &9502720) * -- &1 / &4) /\ ((&500610569684293069675483624375)*(&7815168)+(&125100855120761099170283787098125)*(&1130496))*s pow 4 = (&15503551477229466518711681647697)*((&13631488) * &1 / &4 + (-- &9502720) * &1 / &16) /\ (&500610569684293069675483624375)*(&10605687)+(&125100855120761099170283787098125)*(&1407123)+(&38516595092018891067780522058782311) = (&15503551477229466518711681647697)*(&11699263)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L31 =
let mpos = REAL_ARITH `!s:real. &0:real < &958396494497110475652658980634500` in
let npos = REAL_ARITH `!s:real. &0:real < &2058904246024185581194850767796750` in
let ppos = REAL_ARITH `!s:real. &0:real < &300998299337111868517121647879909118457` in
let qpos = REAL_ARITH `!s:real. &0:real < &2970298068313904261849643948620537` in
let mqrel = REAL_ARITH `
  ((&958396494497110475652658980634500)*(&950272)+(&2058904246024185581194850767796750)*(&438239232))*(&30902639 / &41749730) pow 4 = (&2970298068313904261849643948620537)*(((&540934144) * &0 + (-- &365101056) * -- &1 / &4)) /\
  ((&958396494497110475652658980634500)*(&1130496)+(&2058904246024185581194850767796750)*(&539754496))*(&30902639 / &41749730) pow 4 = (&2970298068313904261849643948620537)*(((&540934144) * &1 / &4 + (-- &365101056) * &1 / &16)) /\
  (&958396494497110475652658980634500)*(&1407123)+(&2058904246024185581194850767796750)*(&659132513)+(&300998299337111868517121647879909118457) = (&2970298068313904261849643948620537)*(&457442411)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&950272) * x + (&1130496) * y <= &1407123 ==>
  (&438239232) * x + (&539754496) * y <= &659132513 ==>
  (&540934144) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &365101056) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &457442411
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &958396494497110475652658980634500` [mpos] THEN
  note `&0:real < &2058904246024185581194850767796750` [npos] THEN
  note `&0:real < &300998299337111868517121647879909118457` [ppos] THEN
  note `&0:real < &2970298068313904261849643948620537` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&958396494497110475652658980634500)*(&950272)+(&2058904246024185581194850767796750)*(&438239232))*s pow 4 = (&2970298068313904261849643948620537)*((&540934144) * &0 + (-- &365101056) * -- &1 / &4) /\ ((&958396494497110475652658980634500)*(&1130496)+(&2058904246024185581194850767796750)*(&539754496))*s pow 4 = (&2970298068313904261849643948620537)*((&540934144) * &1 / &4 + (-- &365101056) * &1 / &16) /\ (&958396494497110475652658980634500)*(&1407123)+(&2058904246024185581194850767796750)*(&659132513)+(&300998299337111868517121647879909118457) = (&2970298068313904261849643948620537)*(&457442411)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L32 =
let mpos = REAL_ARITH `!s:real. &0:real < &29052675475126387457373756545625` in
let npos = REAL_ARITH `!s:real. &0:real < &30594366142986198828396093339049375` in
let ppos = REAL_ARITH `!s:real. &0:real < &143466736158737598758750844915263210992` in
let qpos = REAL_ARITH `!s:real. &0:real < &90883642706751747964043020369581896` in
let mqrel = REAL_ARITH `
  ((&29052675475126387457373756545625)*(&438239232)+(&30594366142986198828396093339049375)*(&13041664))*(&30902639 / &41749730) pow 4 = (&90883642706751747964043020369581896)*(((&8454144) * &0 + (-- &5439488) * -- &1 / &4)) /\
  ((&29052675475126387457373756545625)*(&539754496)+(&30594366142986198828396093339049375)*(&17039360))*(&30902639 / &41749730) pow 4 = (&90883642706751747964043020369581896)*(((&8454144) * &1 / &4 + (-- &5439488) * &1 / &16)) /\
  (&29052675475126387457373756545625)*(&659132513)+(&30594366142986198828396093339049375)*(&20256657)+(&143466736158737598758750844915263210992) = (&90883642706751747964043020369581896)*(&7031327)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&438239232) * x + (&539754496) * y <= &659132513 ==>
  (&13041664) * x + (&17039360) * y <= &20256657 ==>
  (&8454144) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &5439488) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &7031327
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &29052675475126387457373756545625` [mpos] THEN
  note `&0:real < &30594366142986198828396093339049375` [npos] THEN
  note `&0:real < &143466736158737598758750844915263210992` [ppos] THEN
  note `&0:real < &90883642706751747964043020369581896` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&29052675475126387457373756545625)*(&438239232)+(&30594366142986198828396093339049375)*(&13041664))*s pow 4 = (&90883642706751747964043020369581896)*((&8454144) * &0 + (-- &5439488) * -- &1 / &4) /\ ((&29052675475126387457373756545625)*(&539754496)+(&30594366142986198828396093339049375)*(&17039360))*s pow 4 = (&90883642706751747964043020369581896)*((&8454144) * &1 / &4 + (-- &5439488) * &1 / &16) /\ (&29052675475126387457373756545625)*(&659132513)+(&30594366142986198828396093339049375)*(&20256657)+(&143466736158737598758750844915263210992) = (&90883642706751747964043020369581896)*(&7031327)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L33 =
let mpos = REAL_ARITH `!s:real. &0:real < &141180811867689340356584235239687500` in
let npos = REAL_ARITH `!s:real. &0:real < &1227428067132137049179503021640000` in
let ppos = REAL_ARITH `!s:real. &0:real < &411934394476186557812895738869873942719` in
let qpos = REAL_ARITH `!s:real. &0:real < &68336918990778565567448378876875253` in
let mqrel = REAL_ARITH `
  ((&141180811867689340356584235239687500)*(&7733248)+(&1227428067132137049179503021640000)*(&897024))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((&34471936) * &0 + (-- &19202048) * -- &1 / &4)) /\
  ((&141180811867689340356584235239687500)*(&11943936)+(&1227428067132137049179503021640000)*(&2035712))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((&34471936) * &1 / &4 + (-- &19202048) * &1 / &16)) /\
  (&141180811867689340356584235239687500)*(&13225515)+(&1227428067132137049179503021640000)*(&1977153)+(&411934394476186557812895738869873942719) = (&68336918990778565567448378876875253)*(&27364823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&11943936) * y <= &13225515 ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&34471936) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &19202048) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &27364823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &141180811867689340356584235239687500` [mpos] THEN
  note `&0:real < &1227428067132137049179503021640000` [npos] THEN
  note `&0:real < &411934394476186557812895738869873942719` [ppos] THEN
  note `&0:real < &68336918990778565567448378876875253` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&141180811867689340356584235239687500)*(&7733248)+(&1227428067132137049179503021640000)*(&897024))*s pow 4 = (&68336918990778565567448378876875253)*((&34471936) * &0 + (-- &19202048) * -- &1 / &4) /\ ((&141180811867689340356584235239687500)*(&11943936)+(&1227428067132137049179503021640000)*(&2035712))*s pow 4 = (&68336918990778565567448378876875253)*((&34471936) * &1 / &4 + (-- &19202048) * &1 / &16) /\ (&141180811867689340356584235239687500)*(&13225515)+(&1227428067132137049179503021640000)*(&1977153)+(&411934394476186557812895738869873942719) = (&68336918990778565567448378876875253)*(&27364823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L34 =
let mpos = REAL_ARITH `!s:real. &0:real < &36685933654372176015536943731099375` in
let npos = REAL_ARITH `!s:real. &0:real < &302260237907858709434953507707670000` in
let ppos = REAL_ARITH `!s:real. &0:real < &213082608301124092948194847623923660270` in
let qpos = REAL_ARITH `!s:real. &0:real < &68336918990778565567448378876875253` in
let mqrel = REAL_ARITH `
  ((&36685933654372176015536943731099375)*(&7733248)+(&302260237907858709434953507707670000)*(&897024))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((&20946944) * &0 + (-- &9748480) * -- &1 / &4)) /\
  ((&36685933654372176015536943731099375)*(&11943936)+(&302260237907858709434953507707670000)*(&2035712))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((&20946944) * &1 / &4 + (-- &9748480) * &1 / &16)) /\
  (&36685933654372176015536943731099375)*(&13225515)+(&302260237907858709434953507707670000)*(&1977153)+(&213082608301124092948194847623923660270) = (&68336918990778565567448378876875253)*(&15848215)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&11943936) * y <= &13225515 ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&20946944) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &9748480) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &15848215
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &36685933654372176015536943731099375` [mpos] THEN
  note `&0:real < &302260237907858709434953507707670000` [npos] THEN
  note `&0:real < &213082608301124092948194847623923660270` [ppos] THEN
  note `&0:real < &68336918990778565567448378876875253` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&36685933654372176015536943731099375)*(&7733248)+(&302260237907858709434953507707670000)*(&897024))*s pow 4 = (&68336918990778565567448378876875253)*((&20946944) * &0 + (-- &9748480) * -- &1 / &4) /\ ((&36685933654372176015536943731099375)*(&11943936)+(&302260237907858709434953507707670000)*(&2035712))*s pow 4 = (&68336918990778565567448378876875253)*((&20946944) * &1 / &4 + (-- &9748480) * &1 / &16) /\ (&36685933654372176015536943731099375)*(&13225515)+(&302260237907858709434953507707670000)*(&1977153)+(&213082608301124092948194847623923660270) = (&68336918990778565567448378876875253)*(&15848215)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L35 =
let mpos = REAL_ARITH `!s:real. &0:real < &503266584955403242640771196303619375` in
let npos = REAL_ARITH `!s:real. &0:real < &90892339601155865220073637586066250` in
let ppos = REAL_ARITH `!s:real. &0:real < &18029506647568188026693225850737659376315` in
let qpos = REAL_ARITH `!s:real. &0:real < &75810542776419476045144980706456248` in
let mqrel = REAL_ARITH `
  ((&503266584955403242640771196303619375)*(&897024)+(&90892339601155865220073637586066250)*(&1275904))*(&30902639 / &41749730) pow 4 = (&75810542776419476045144980706456248)*(((&24879104) * &0 + (-- &8986624) * -- &1 / &4)) /\
  ((&503266584955403242640771196303619375)*(&2035712)+(&90892339601155865220073637586066250)*(&4450304))*(&30902639 / &41749730) pow 4 = (&75810542776419476045144980706456248)*(((&24879104) * &1 / &4 + (-- &8986624) * &1 / &16)) /\
  (&503266584955403242640771196303619375)*(&1977153)+(&90892339601155865220073637586066250)*(&3928715)+(&18029506647568188026693225850737659376315) = (&75810542776419476045144980706456248)*(&18073405)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&897024) * x + (&2035712) * y <= &1977153 ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&24879104) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &8986624) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18073405
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &503266584955403242640771196303619375` [mpos] THEN
  note `&0:real < &90892339601155865220073637586066250` [npos] THEN
  note `&0:real < &18029506647568188026693225850737659376315` [ppos] THEN
  note `&0:real < &75810542776419476045144980706456248` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&503266584955403242640771196303619375)*(&897024)+(&90892339601155865220073637586066250)*(&1275904))*s pow 4 = (&75810542776419476045144980706456248)*((&24879104) * &0 + (-- &8986624) * -- &1 / &4) /\ ((&503266584955403242640771196303619375)*(&2035712)+(&90892339601155865220073637586066250)*(&4450304))*s pow 4 = (&75810542776419476045144980706456248)*((&24879104) * &1 / &4 + (-- &8986624) * &1 / &16) /\ (&503266584955403242640771196303619375)*(&1977153)+(&90892339601155865220073637586066250)*(&3928715)+(&18029506647568188026693225850737659376315) = (&75810542776419476045144980706456248)*(&18073405)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L36 =
let mpos = REAL_ARITH `!s:real. &0:real < &823349025229725594870409205110000` in
let npos = REAL_ARITH `!s:real. &0:real < &247992118761536353067517163716250` in
let ppos = REAL_ARITH `!s:real. &0:real < &182437369227090606646966088182037343327` in
let qpos = REAL_ARITH `!s:real. &0:real < &58591568926915384436921730048211127` in
let mqrel = REAL_ARITH `
  ((&823349025229725594870409205110000)*(&1275904)+(&247992118761536353067517163716250)*(&2211840))*(&30902639 / &41749730) pow 4 = (&58591568926915384436921730048211127)*(((&131072) * &0 + (-- &32768) * -- &1 / &4)) /\
  ((&823349025229725594870409205110000)*(&4450304)+(&247992118761536353067517163716250)*(&9404416))*(&30902639 / &41749730) pow 4 = (&58591568926915384436921730048211127)*(((&131072) * &1 / &4 + (-- &32768) * &1 / &16)) /\
  (&823349025229725594870409205110000)*(&3928715)+(&247992118761536353067517163716250)*(&8039969)+(&182437369227090606646966088182037343327) = (&58591568926915384436921730048211127)*(&92351)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1275904) * x + (&4450304) * y <= &3928715 ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&131072) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &32768) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &92351
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &823349025229725594870409205110000` [mpos] THEN
  note `&0:real < &247992118761536353067517163716250` [npos] THEN
  note `&0:real < &182437369227090606646966088182037343327` [ppos] THEN
  note `&0:real < &58591568926915384436921730048211127` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&823349025229725594870409205110000)*(&1275904)+(&247992118761536353067517163716250)*(&2211840))*s pow 4 = (&58591568926915384436921730048211127)*((&131072) * &0 + (-- &32768) * -- &1 / &4) /\ ((&823349025229725594870409205110000)*(&4450304)+(&247992118761536353067517163716250)*(&9404416))*s pow 4 = (&58591568926915384436921730048211127)*((&131072) * &1 / &4 + (-- &32768) * &1 / &16) /\ (&823349025229725594870409205110000)*(&3928715)+(&247992118761536353067517163716250)*(&8039969)+(&182437369227090606646966088182037343327) = (&58591568926915384436921730048211127)*(&92351)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L37 =
let mpos = REAL_ARITH `!s:real. &0:real < &8642955173432132900866246243175000` in
let npos = REAL_ARITH `!s:real. &0:real < &1392267044025768584432302784714375` in
let ppos = REAL_ARITH `!s:real. &0:real < &4885491972977278885506385298071359845164` in
let qpos = REAL_ARITH `!s:real. &0:real < &887350328667310054276850955482893` in
let mqrel = REAL_ARITH `
  ((&8642955173432132900866246243175000)*(&2211840)+(&1392267044025768584432302784714375)*(&7733248))*(&30902639 / &41749730) pow 4 = (&887350328667310054276850955482893)*(((&191823872) * &0 + (-- &40435712) * -- &1 / &4)) /\
  ((&8642955173432132900866246243175000)*(&9404416)+(&1392267044025768584432302784714375)*(&38076416))*(&30902639 / &41749730) pow 4 = (&887350328667310054276850955482893)*(((&191823872) * &1 / &4 + (-- &40435712) * &1 / &16)) /\
  (&8642955173432132900866246243175000)*(&8039969)+(&1392267044025768584432302784714375)*(&31944087)+(&4885491972977278885506385298071359845164) = (&887350328667310054276850955482893)*(&133937273)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&2211840) * x + (&9404416) * y <= &8039969 ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&191823872) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &40435712) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &133937273
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8642955173432132900866246243175000` [mpos] THEN
  note `&0:real < &1392267044025768584432302784714375` [npos] THEN
  note `&0:real < &4885491972977278885506385298071359845164` [ppos] THEN
  note `&0:real < &887350328667310054276850955482893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&8642955173432132900866246243175000)*(&2211840)+(&1392267044025768584432302784714375)*(&7733248))*s pow 4 = (&887350328667310054276850955482893)*((&191823872) * &0 + (-- &40435712) * -- &1 / &4) /\ ((&8642955173432132900866246243175000)*(&9404416)+(&1392267044025768584432302784714375)*(&38076416))*s pow 4 = (&887350328667310054276850955482893)*((&191823872) * &1 / &4 + (-- &40435712) * &1 / &16) /\ (&8642955173432132900866246243175000)*(&8039969)+(&1392267044025768584432302784714375)*(&31944087)+(&4885491972977278885506385298071359845164) = (&887350328667310054276850955482893)*(&133937273)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L38 =
let mpos = REAL_ARITH `!s:real. &0:real < &7160060353860069881406485216116875` in
let npos = REAL_ARITH `!s:real. &0:real < &282741397271001247869474009780625` in
let ppos = REAL_ARITH `!s:real. &0:real < &11744814199458114325219693500395315238560` in
let qpos = REAL_ARITH `!s:real. &0:real < &37949046121792503575095911571998092` in
let mqrel = REAL_ARITH `
  ((&7160060353860069881406485216116875)*(&7733248)+(&282741397271001247869474009780625)*(&1966080))*(&30902639 / &41749730) pow 4 = (&37949046121792503575095911571998092)*(((&9568256) * &0 + (-- &1769472) * -- &1 / &4)) /\
  ((&7160060353860069881406485216116875)*(&38076416)+(&282741397271001247869474009780625)*(&55902208))*(&30902639 / &41749730) pow 4 = (&37949046121792503575095911571998092)*(((&9568256) * &1 / &4 + (-- &1769472) * &1 / &16)) /\
  (&7160060353860069881406485216116875)*(&31944087)+(&282741397271001247869474009780625)*(&42311631)+(&11744814199458114325219693500395315238560) = (&37949046121792503575095911571998092)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&7733248) * x + (&38076416) * y <= &31944087 ==>
  (&1966080) * x + (&55902208) * y <= &42311631 ==>
  (&9568256) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &1769472) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7160060353860069881406485216116875` [mpos] THEN
  note `&0:real < &282741397271001247869474009780625` [npos] THEN
  note `&0:real < &11744814199458114325219693500395315238560` [ppos] THEN
  note `&0:real < &37949046121792503575095911571998092` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&7160060353860069881406485216116875)*(&7733248)+(&282741397271001247869474009780625)*(&1966080))*s pow 4 = (&37949046121792503575095911571998092)*((&9568256) * &0 + (-- &1769472) * -- &1 / &4) /\ ((&7160060353860069881406485216116875)*(&38076416)+(&282741397271001247869474009780625)*(&55902208))*s pow 4 = (&37949046121792503575095911571998092)*((&9568256) * &1 / &4 + (-- &1769472) * &1 / &16) /\ (&7160060353860069881406485216116875)*(&31944087)+(&282741397271001247869474009780625)*(&42311631)+(&11744814199458114325219693500395315238560) = (&37949046121792503575095911571998092)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L39 =
let mpos = REAL_ARITH `!s:real. &0:real < &17310647413980044835140939659926875` in
let npos = REAL_ARITH `!s:real. &0:real < &44433503667840357287748098246250` in
let ppos = REAL_ARITH `!s:real. &0:real < &63899680603422525290763037393770396514618` in
let qpos = REAL_ARITH `!s:real. &0:real < &204662383050906187513512909431248097` in
let mqrel = REAL_ARITH `
  ((&17310647413980044835140939659926875)*(&1966080)+(&44433503667840357287748098246250)*(-- &11730944))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((&5767168) * &0 + (-- &196608) * -- &1 / &4)) /\
  ((&17310647413980044835140939659926875)*(&55902208)+(&44433503667840357287748098246250)*(&156696576))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((&5767168) * &1 / &4 + (-- &196608) * &1 / &16)) /\
  (&17310647413980044835140939659926875)*(&42311631)+(&44433503667840357287748098246250)*(&110400449)+(&63899680603422525290763037393770396514618) = (&204662383050906187513512909431248097)*(&3914969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&1966080) * x + (&55902208) * y <= &42311631 ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (&5767168) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &196608) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3914969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &17310647413980044835140939659926875` [mpos] THEN
  note `&0:real < &44433503667840357287748098246250` [npos] THEN
  note `&0:real < &63899680603422525290763037393770396514618` [ppos] THEN
  note `&0:real < &204662383050906187513512909431248097` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&17310647413980044835140939659926875)*(&1966080)+(&44433503667840357287748098246250)*(-- &11730944))*s pow 4 = (&204662383050906187513512909431248097)*((&5767168) * &0 + (-- &196608) * -- &1 / &4) /\ ((&17310647413980044835140939659926875)*(&55902208)+(&44433503667840357287748098246250)*(&156696576))*s pow 4 = (&204662383050906187513512909431248097)*((&5767168) * &1 / &4 + (-- &196608) * &1 / &16) /\ (&17310647413980044835140939659926875)*(&42311631)+(&44433503667840357287748098246250)*(&110400449)+(&63899680603422525290763037393770396514618) = (&204662383050906187513512909431248097)*(&3914969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L40 =
let mpos = REAL_ARITH `!s:real. &0:real < &204929635534647025470747692901442625` in
let npos = REAL_ARITH `!s:real. &0:real < &3638344403324880127553958167765375` in
let ppos = REAL_ARITH `!s:real. &0:real < &2694431604612903319067477561320154812474166` in
let qpos = REAL_ARITH `!s:real. &0:real < &92789667564834664730166985936857586` in
let mqrel = REAL_ARITH `
  ((&204929635534647025470747692901442625)*(-- &11730944)+(&3638344403324880127553958167765375)*(-- &22740992))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((&413007872) * &0 + (&32178176) * -- &1 / &4)) /\
  ((&204929635534647025470747692901442625)*(&156696576)+(&3638344403324880127553958167765375)*(&117506048))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((&413007872) * &1 / &4 + (&32178176) * &1 / &16)) /\
  (&204929635534647025470747692901442625)*(&110400449)+(&3638344403324880127553958167765375)*(&77682557)+(&2694431604612903319067477561320154812474166) = (&92789667564834664730166985936857586)*(&275907781)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &11730944) * x + (&156696576) * y <= &110400449 ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (&413007872) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&32178176) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &275907781
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &204929635534647025470747692901442625` [mpos] THEN
  note `&0:real < &3638344403324880127553958167765375` [npos] THEN
  note `&0:real < &2694431604612903319067477561320154812474166` [ppos] THEN
  note `&0:real < &92789667564834664730166985936857586` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&204929635534647025470747692901442625)*(-- &11730944)+(&3638344403324880127553958167765375)*(-- &22740992))*s pow 4 = (&92789667564834664730166985936857586)*((&413007872) * &0 + (&32178176) * -- &1 / &4) /\ ((&204929635534647025470747692901442625)*(&156696576)+(&3638344403324880127553958167765375)*(&117506048))*s pow 4 = (&92789667564834664730166985936857586)*((&413007872) * &1 / &4 + (&32178176) * &1 / &16) /\ (&204929635534647025470747692901442625)*(&110400449)+(&3638344403324880127553958167765375)*(&77682557)+(&2694431604612903319067477561320154812474166) = (&92789667564834664730166985936857586)*(&275907781)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L41 =
let mpos = REAL_ARITH `!s:real. &0:real < &167959783185043418249156727988728750` in
let npos = REAL_ARITH `!s:real. &0:real < &6141127957784722201038723270863125` in
let ppos = REAL_ARITH `!s:real. &0:real < &2474849543777879224888802025444955207416994` in
let qpos = REAL_ARITH `!s:real. &0:real < &844687290922823485264389121414603979` in
let mqrel = REAL_ARITH `
  ((&167959783185043418249156727988728750)*(-- &22740992)+(&6141127957784722201038723270863125)*(-- &166330368))*(&30902639 / &41749730) pow 4 = (&844687290922823485264389121414603979)*(((&32309248) * &0 + (&6881280) * -- &1 / &4)) /\
  ((&167959783185043418249156727988728750)*(&117506048)+(&6141127957784722201038723270863125)*(&684523520))*(&30902639 / &41749730) pow 4 = (&844687290922823485264389121414603979)*(((&32309248) * &1 / &4 + (&6881280) * &1 / &16)) /\
  (&167959783185043418249156727988728750)*(&77682557)+(&6141127957784722201038723270863125)*(&441063407)+(&2474849543777879224888802025444955207416994) = (&844687290922823485264389121414603979)*(&21583161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &22740992) * x + (&117506048) * y <= &77682557 ==>
  (-- &166330368) * x + (&684523520) * y <= &441063407 ==>
  (&32309248) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&6881280) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &21583161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &167959783185043418249156727988728750` [mpos] THEN
  note `&0:real < &6141127957784722201038723270863125` [npos] THEN
  note `&0:real < &2474849543777879224888802025444955207416994` [ppos] THEN
  note `&0:real < &844687290922823485264389121414603979` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&167959783185043418249156727988728750)*(-- &22740992)+(&6141127957784722201038723270863125)*(-- &166330368))*s pow 4 = (&844687290922823485264389121414603979)*((&32309248) * &0 + (&6881280) * -- &1 / &4) /\ ((&167959783185043418249156727988728750)*(&117506048)+(&6141127957784722201038723270863125)*(&684523520))*s pow 4 = (&844687290922823485264389121414603979)*((&32309248) * &1 / &4 + (&6881280) * &1 / &16) /\ (&167959783185043418249156727988728750)*(&77682557)+(&6141127957784722201038723270863125)*(&441063407)+(&2474849543777879224888802025444955207416994) = (&844687290922823485264389121414603979)*(&21583161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L42 =
let mpos = REAL_ARITH `!s:real. &0:real < &556106375834249123933342406983038125` in
let npos = REAL_ARITH `!s:real. &0:real < &127117607956817867275011962144749375` in
let ppos = REAL_ARITH `!s:real. &0:real < &10746085031793161931827589380217138679377240` in
let qpos = REAL_ARITH `!s:real. &0:real < &799629410461913117482625118169441292` in
let mqrel = REAL_ARITH `
  ((&556106375834249123933342406983038125)*(-- &33882112)+(&127117607956817867275011962144749375)*(-- &50659328))*(&30902639 / &41749730) pow 4 = (&799629410461913117482625118169441292)*(((&137199616) * &0 + (&37961728) * -- &1 / &4)) /\
  ((&556106375834249123933342406983038125)*(&135659520)+(&127117607956817867275011962144749375)*(&175046656))*(&30902639 / &41749730) pow 4 = (&799629410461913117482625118169441292)*(((&137199616) * &1 / &4 + (&37961728) * &1 / &16)) /\
  (&556106375834249123933342406983038125)*(&87245513)+(&127117607956817867275011962144749375)*(&111549985)+(&10746085031793161931827589380217138679377240) = (&799629410461913117482625118169441292)*(&91847345)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (&137199616) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&37961728) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &91847345
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &556106375834249123933342406983038125` [mpos] THEN
  note `&0:real < &127117607956817867275011962144749375` [npos] THEN
  note `&0:real < &10746085031793161931827589380217138679377240` [ppos] THEN
  note `&0:real < &799629410461913117482625118169441292` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&556106375834249123933342406983038125)*(-- &33882112)+(&127117607956817867275011962144749375)*(-- &50659328))*s pow 4 = (&799629410461913117482625118169441292)*((&137199616) * &0 + (&37961728) * -- &1 / &4) /\ ((&556106375834249123933342406983038125)*(&135659520)+(&127117607956817867275011962144749375)*(&175046656))*s pow 4 = (&799629410461913117482625118169441292)*((&137199616) * &1 / &4 + (&37961728) * &1 / &16) /\ (&556106375834249123933342406983038125)*(&87245513)+(&127117607956817867275011962144749375)*(&111549985)+(&10746085031793161931827589380217138679377240) = (&799629410461913117482625118169441292)*(&91847345)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L43 =
let mpos = REAL_ARITH `!s:real. &0:real < &20706012709213606496090613782752500` in
let npos = REAL_ARITH `!s:real. &0:real < &11567142347992150446754116037472500` in
let ppos = REAL_ARITH `!s:real. &0:real < &536823724970120101546519573632816825811335` in
let qpos = REAL_ARITH `!s:real. &0:real < &199907352615478279370656279542360323` in
let mqrel = REAL_ARITH `
  ((&20706012709213606496090613782752500)*(-- &33882112)+(&11567142347992150446754116037472500)*(-- &50659328))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((&27099136) * &0 + (&7733248) * -- &1 / &4)) /\
  ((&20706012709213606496090613782752500)*(&135659520)+(&11567142347992150446754116037472500)*(&175046656))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((&27099136) * &1 / &4 + (&7733248) * &1 / &16)) /\
  (&20706012709213606496090613782752500)*(&87245513)+(&11567142347992150446754116037472500)*(&111549985)+(&536823724970120101546519573632816825811335) = (&199907352615478279370656279542360323)*(&18176645)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33882112) * x + (&135659520) * y <= &87245513 ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (&27099136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&7733248) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18176645
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &20706012709213606496090613782752500` [mpos] THEN
  note `&0:real < &11567142347992150446754116037472500` [npos] THEN
  note `&0:real < &536823724970120101546519573632816825811335` [ppos] THEN
  note `&0:real < &199907352615478279370656279542360323` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&20706012709213606496090613782752500)*(-- &33882112)+(&11567142347992150446754116037472500)*(-- &50659328))*s pow 4 = (&199907352615478279370656279542360323)*((&27099136) * &0 + (&7733248) * -- &1 / &4) /\ ((&20706012709213606496090613782752500)*(&135659520)+(&11567142347992150446754116037472500)*(&175046656))*s pow 4 = (&199907352615478279370656279542360323)*((&27099136) * &1 / &4 + (&7733248) * &1 / &16) /\ (&20706012709213606496090613782752500)*(&87245513)+(&11567142347992150446754116037472500)*(&111549985)+(&536823724970120101546519573632816825811335) = (&199907352615478279370656279542360323)*(&18176645)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L44 =
let mpos = REAL_ARITH `!s:real. &0:real < &1380097028452409046014329820742500` in
let npos = REAL_ARITH `!s:real. &0:real < &52251711558934336051032083071433125` in
let ppos = REAL_ARITH `!s:real. &0:real < &243911296664608832466250370871023207588988` in
let qpos = REAL_ARITH `!s:real. &0:real < &33486759217199340064739661083634479` in
let mqrel = REAL_ARITH `
  ((&1380097028452409046014329820742500)*(-- &50659328)+(&52251711558934336051032083071433125)*(-- &11010048))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((&68321280) * &0 + (&23134208) * -- &1 / &4)) /\
  ((&1380097028452409046014329820742500)*(&175046656)+(&52251711558934336051032083071433125)*(&34930688))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((&68321280) * &1 / &4 + (&23134208) * &1 / &16)) /\
  (&1380097028452409046014329820742500)*(&111549985)+(&52251711558934336051032083071433125)*(&22163375)+(&243911296664608832466250370871023207588988) = (&33486759217199340064739661083634479)*(&46464197)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &50659328) * x + (&175046656) * y <= &111549985 ==>
  (-- &11010048) * x + (&34930688) * y <= &22163375 ==>
  (&68321280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&23134208) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &46464197
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1380097028452409046014329820742500` [mpos] THEN
  note `&0:real < &52251711558934336051032083071433125` [npos] THEN
  note `&0:real < &243911296664608832466250370871023207588988` [ppos] THEN
  note `&0:real < &33486759217199340064739661083634479` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1380097028452409046014329820742500)*(-- &50659328)+(&52251711558934336051032083071433125)*(-- &11010048))*s pow 4 = (&33486759217199340064739661083634479)*((&68321280) * &0 + (&23134208) * -- &1 / &4) /\ ((&1380097028452409046014329820742500)*(&175046656)+(&52251711558934336051032083071433125)*(&34930688))*s pow 4 = (&33486759217199340064739661083634479)*((&68321280) * &1 / &4 + (&23134208) * &1 / &16) /\ (&1380097028452409046014329820742500)*(&111549985)+(&52251711558934336051032083071433125)*(&22163375)+(&243911296664608832466250370871023207588988) = (&33486759217199340064739661083634479)*(&46464197)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L45 =
let mpos = REAL_ARITH `!s:real. &0:real < &22345571017203353423292888054109000` in
let npos = REAL_ARITH `!s:real. &0:real < &921558461541721461491021668413250` in
let ppos = REAL_ARITH `!s:real. &0:real < &44445603688228070643474620887584899715249` in
let qpos = REAL_ARITH `!s:real. &0:real < &15664970807315914493641797391911257` in
let mqrel = REAL_ARITH `
  ((&22345571017203353423292888054109000)*(-- &3457024)+(&921558461541721461491021668413250)*(-- &58130432))*(&30902639 / &41749730) pow 4 = (&15664970807315914493641797391911257)*(((&26869760) * &0 + (&10027008) * -- &1 / &4)) /\
  ((&22345571017203353423292888054109000)*(&10452992)+(&921558461541721461491021668413250)*(&162430976))*(&30902639 / &41749730) pow 4 = (&15664970807315914493641797391911257)*(((&26869760) * &1 / &4 + (&10027008) * &1 / &16)) /\
  (&22345571017203353423292888054109000)*(&6651805)+(&921558461541721461491021668413250)*(&104374325)+(&44445603688228070643474620887584899715249) = (&15664970807315914493641797391911257)*(&18466107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (&26869760) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&10027008) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18466107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &22345571017203353423292888054109000` [mpos] THEN
  note `&0:real < &921558461541721461491021668413250` [npos] THEN
  note `&0:real < &44445603688228070643474620887584899715249` [ppos] THEN
  note `&0:real < &15664970807315914493641797391911257` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&22345571017203353423292888054109000)*(-- &3457024)+(&921558461541721461491021668413250)*(-- &58130432))*s pow 4 = (&15664970807315914493641797391911257)*((&26869760) * &0 + (&10027008) * -- &1 / &4) /\ ((&22345571017203353423292888054109000)*(&10452992)+(&921558461541721461491021668413250)*(&162430976))*s pow 4 = (&15664970807315914493641797391911257)*((&26869760) * &1 / &4 + (&10027008) * &1 / &16) /\ (&22345571017203353423292888054109000)*(&6651805)+(&921558461541721461491021668413250)*(&104374325)+(&44445603688228070643474620887584899715249) = (&15664970807315914493641797391911257)*(&18466107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L46 =
let mpos = REAL_ARITH `!s:real. &0:real < &52581772738743909166577227278149500` in
let npos = REAL_ARITH `!s:real. &0:real < &5837992721650789096875641800605375` in
let ppos = REAL_ARITH `!s:real. &0:real < &172173595998526204964089087732111535915627` in
let qpos = REAL_ARITH `!s:real. &0:real < &31329941614631828987283594783822514` in
let mqrel = REAL_ARITH `
  ((&52581772738743909166577227278149500)*(-- &3457024)+(&5837992721650789096875641800605375)*(-- &58130432))*(&30902639 / &41749730) pow 4 = (&31329941614631828987283594783822514)*(((&52412416) * &0 + (&19972096) * -- &1 / &4)) /\
  ((&52581772738743909166577227278149500)*(&10452992)+(&5837992721650789096875641800605375)*(&162430976))*(&30902639 / &41749730) pow 4 = (&31329941614631828987283594783822514)*(((&52412416) * &1 / &4 + (&19972096) * &1 / &16)) /\
  (&52581772738743909166577227278149500)*(&6651805)+(&5837992721650789096875641800605375)*(&104374325)+(&172173595998526204964089087732111535915627) = (&31329941614631828987283594783822514)*(&36108393)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3457024) * x + (&10452992) * y <= &6651805 ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (&52412416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&19972096) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &36108393
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &52581772738743909166577227278149500` [mpos] THEN
  note `&0:real < &5837992721650789096875641800605375` [npos] THEN
  note `&0:real < &172173595998526204964089087732111535915627` [ppos] THEN
  note `&0:real < &31329941614631828987283594783822514` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&52581772738743909166577227278149500)*(-- &3457024)+(&5837992721650789096875641800605375)*(-- &58130432))*s pow 4 = (&31329941614631828987283594783822514)*((&52412416) * &0 + (&19972096) * -- &1 / &4) /\ ((&52581772738743909166577227278149500)*(&10452992)+(&5837992721650789096875641800605375)*(&162430976))*s pow 4 = (&31329941614631828987283594783822514)*((&52412416) * &1 / &4 + (&19972096) * &1 / &16) /\ (&52581772738743909166577227278149500)*(&6651805)+(&5837992721650789096875641800605375)*(&104374325)+(&172173595998526204964089087732111535915627) = (&31329941614631828987283594783822514)*(&36108393)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L47 =
let mpos = REAL_ARITH `!s:real. &0:real < &254500867501803720275859649030723125` in
let npos = REAL_ARITH `!s:real. &0:real < &2722026816574750092819952941709375` in
let ppos = REAL_ARITH `!s:real. &0:real < &5049993718305482520440667115078148369619750` in
let qpos = REAL_ARITH `!s:real. &0:real < &5917776732800559364215099444406446098` in
let mqrel = REAL_ARITH `
  ((&254500867501803720275859649030723125)*(-- &58130432)+(&2722026816574750092819952941709375)*(-- &290521088))*(&30902639 / &41749730) pow 4 = (&5917776732800559364215099444406446098)*(((&7979008) * &0 + (&3162112) * -- &1 / &4)) /\
  ((&254500867501803720275859649030723125)*(&162430976)+(&2722026816574750092819952941709375)*(&691929088))*(&30902639 / &41749730) pow 4 = (&5917776732800559364215099444406446098)*(((&7979008) * &1 / &4 + (&3162112) * &1 / &16)) /\
  (&254500867501803720275859649030723125)*(&104374325)+(&2722026816574750092819952941709375)*(&457690221)+(&5049993718305482520440667115078148369619750) = (&5917776732800559364215099444406446098)*(&5552625)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (&7979008) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&3162112) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5552625
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &254500867501803720275859649030723125` [mpos] THEN
  note `&0:real < &2722026816574750092819952941709375` [npos] THEN
  note `&0:real < &5049993718305482520440667115078148369619750` [ppos] THEN
  note `&0:real < &5917776732800559364215099444406446098` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&254500867501803720275859649030723125)*(-- &58130432)+(&2722026816574750092819952941709375)*(-- &290521088))*s pow 4 = (&5917776732800559364215099444406446098)*((&7979008) * &0 + (&3162112) * -- &1 / &4) /\ ((&254500867501803720275859649030723125)*(&162430976)+(&2722026816574750092819952941709375)*(&691929088))*s pow 4 = (&5917776732800559364215099444406446098)*((&7979008) * &1 / &4 + (&3162112) * &1 / &16) /\ (&254500867501803720275859649030723125)*(&104374325)+(&2722026816574750092819952941709375)*(&457690221)+(&5049993718305482520440667115078148369619750) = (&5917776732800559364215099444406446098)*(&5552625)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L48 =
let mpos = REAL_ARITH `!s:real. &0:real < &888252132580854510599447718923974375` in
let npos = REAL_ARITH `!s:real. &0:real < &272277307157224843728209332643633125` in
let ppos = REAL_ARITH `!s:real. &0:real < &39946282405547205249500139425984008923323743` in
let qpos = REAL_ARITH `!s:real. &0:real < &2958888366400279682107549722203223049` in
let mqrel = REAL_ARITH `
  ((&888252132580854510599447718923974375)*(-- &58130432)+(&272277307157224843728209332643633125)*(-- &290521088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((&121733120) * &0 + (&53051392) * -- &1 / &4)) /\
  ((&888252132580854510599447718923974375)*(&162430976)+(&272277307157224843728209332643633125)*(&691929088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((&121733120) * &1 / &4 + (&53051392) * &1 / &16)) /\
  (&888252132580854510599447718923974375)*(&104374325)+(&272277307157224843728209332643633125)*(&457690221)+(&39946282405547205249500139425984008923323743) = (&2958888366400279682107549722203223049)*(&86950107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &58130432) * x + (&162430976) * y <= &104374325 ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (&121733120) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&53051392) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &86950107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &888252132580854510599447718923974375` [mpos] THEN
  note `&0:real < &272277307157224843728209332643633125` [npos] THEN
  note `&0:real < &39946282405547205249500139425984008923323743` [ppos] THEN
  note `&0:real < &2958888366400279682107549722203223049` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&888252132580854510599447718923974375)*(-- &58130432)+(&272277307157224843728209332643633125)*(-- &290521088))*s pow 4 = (&2958888366400279682107549722203223049)*((&121733120) * &0 + (&53051392) * -- &1 / &4) /\ ((&888252132580854510599447718923974375)*(&162430976)+(&272277307157224843728209332643633125)*(&691929088))*s pow 4 = (&2958888366400279682107549722203223049)*((&121733120) * &1 / &4 + (&53051392) * &1 / &16) /\ (&888252132580854510599447718923974375)*(&104374325)+(&272277307157224843728209332643633125)*(&457690221)+(&39946282405547205249500139425984008923323743) = (&2958888366400279682107549722203223049)*(&86950107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L49 =
let mpos = REAL_ARITH `!s:real. &0:real < &32277370543451167438279721306468875` in
let npos = REAL_ARITH `!s:real. &0:real < &2725412573599532403531848085687879000` in
let ppos = REAL_ARITH `!s:real. &0:real < &13038006446641999506219597655285590930349171` in
let qpos = REAL_ARITH `!s:real. &0:real < &882792284533004591120349721078470082` in
let mqrel = REAL_ARITH `
  ((&32277370543451167438279721306468875)*(-- &290521088)+(&2725412573599532403531848085687879000)*(-- &14442496))*(&30902639 / &41749730) pow 4 = (&882792284533004591120349721078470082)*(((&124731392) * &0 + (&66289664) * -- &1 / &4)) /\
  ((&32277370543451167438279721306468875)*(&691929088)+(&2725412573599532403531848085687879000)*(&29925376))*(&30902639 / &41749730) pow 4 = (&882792284533004591120349721078470082)*(((&124731392) * &1 / &4 + (&66289664) * &1 / &16)) /\
  (&32277370543451167438279721306468875)*(&457690221)+(&2725412573599532403531848085687879000)*(&20669487)+(&13038006446641999506219597655285590930349171) = (&882792284533004591120349721078470082)*(&95315653)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &290521088) * x + (&691929088) * y <= &457690221 ==>
  (-- &14442496) * x + (&29925376) * y <= &20669487 ==>
  (&124731392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&66289664) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &95315653
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &32277370543451167438279721306468875` [mpos] THEN
  note `&0:real < &2725412573599532403531848085687879000` [npos] THEN
  note `&0:real < &13038006446641999506219597655285590930349171` [ppos] THEN
  note `&0:real < &882792284533004591120349721078470082` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&32277370543451167438279721306468875)*(-- &290521088)+(&2725412573599532403531848085687879000)*(-- &14442496))*s pow 4 = (&882792284533004591120349721078470082)*((&124731392) * &0 + (&66289664) * -- &1 / &4) /\ ((&32277370543451167438279721306468875)*(&691929088)+(&2725412573599532403531848085687879000)*(&29925376))*s pow 4 = (&882792284533004591120349721078470082)*((&124731392) * &1 / &4 + (&66289664) * &1 / &16) /\ (&32277370543451167438279721306468875)*(&457690221)+(&2725412573599532403531848085687879000)*(&20669487)+(&13038006446641999506219597655285590930349171) = (&882792284533004591120349721078470082)*(&95315653)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L50 =
let mpos = REAL_ARITH `!s:real. &0:real < &38503616108028969372696233358541250` in
let npos = REAL_ARITH `!s:real. &0:real < &36127511195106065791022039601275000` in
let ppos = REAL_ARITH `!s:real. &0:real < &192586845187099428505456791763630249299653` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&38503616108028969372696233358541250)*(-- &15433728)+(&36127511195106065791022039601275000)*(-- &5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&165806080) * &0 + (&105447424) * -- &1 / &4)) /\
  ((&38503616108028969372696233358541250)*(&29458432)+(&36127511195106065791022039601275000)*(&8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&165806080) * &1 / &4 + (&105447424) * &1 / &16)) /\
  (&38503616108028969372696233358541250)*(&21015329)+(&36127511195106065791022039601275000)*(&6951751)+(&192586845187099428505456791763630249299653) = (&9095112875435851152418329474851893)*(&137755571)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (&165806080) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&105447424) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &137755571
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &38503616108028969372696233358541250` [mpos] THEN
  note `&0:real < &36127511195106065791022039601275000` [npos] THEN
  note `&0:real < &192586845187099428505456791763630249299653` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&38503616108028969372696233358541250)*(-- &15433728)+(&36127511195106065791022039601275000)*(-- &5660672))*s pow 4 = (&9095112875435851152418329474851893)*((&165806080) * &0 + (&105447424) * -- &1 / &4) /\ ((&38503616108028969372696233358541250)*(&29458432)+(&36127511195106065791022039601275000)*(&8896512))*s pow 4 = (&9095112875435851152418329474851893)*((&165806080) * &1 / &4 + (&105447424) * &1 / &16) /\ (&38503616108028969372696233358541250)*(&21015329)+(&36127511195106065791022039601275000)*(&6951751)+(&192586845187099428505456791763630249299653) = (&9095112875435851152418329474851893)*(&137755571)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L51 =
let mpos = REAL_ARITH `!s:real. &0:real < &3348912086853546741967028383750000` in
let npos = REAL_ARITH `!s:real. &0:real < &11566106601985907081782373657560000` in
let ppos = REAL_ARITH `!s:real. &0:real < &27233852042160971319627078273798161593939` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&3348912086853546741967028383750000)*(-- &15433728)+(&11566106601985907081782373657560000)*(-- &5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&22740992) * &0 + (&15466496) * -- &1 / &4)) /\
  ((&3348912086853546741967028383750000)*(&29458432)+(&11566106601985907081782373657560000)*(&8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&22740992) * &1 / &4 + (&15466496) * &1 / &16)) /\
  (&3348912086853546741967028383750000)*(&21015329)+(&11566106601985907081782373657560000)*(&6951751)+(&27233852042160971319627078273798161593939) = (&9095112875435851152418329474851893)*(&19572823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (&22740992) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&15466496) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &19572823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3348912086853546741967028383750000` [mpos] THEN
  note `&0:real < &11566106601985907081782373657560000` [npos] THEN
  note `&0:real < &27233852042160971319627078273798161593939` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3348912086853546741967028383750000)*(-- &15433728)+(&11566106601985907081782373657560000)*(-- &5660672))*s pow 4 = (&9095112875435851152418329474851893)*((&22740992) * &0 + (&15466496) * -- &1 / &4) /\ ((&3348912086853546741967028383750000)*(&29458432)+(&11566106601985907081782373657560000)*(&8896512))*s pow 4 = (&9095112875435851152418329474851893)*((&22740992) * &1 / &4 + (&15466496) * &1 / &16) /\ (&3348912086853546741967028383750000)*(&21015329)+(&11566106601985907081782373657560000)*(&6951751)+(&27233852042160971319627078273798161593939) = (&9095112875435851152418329474851893)*(&19572823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L52 =
let mpos = REAL_ARITH `!s:real. &0:real < &329816053254762185835165176803750` in
let npos = REAL_ARITH `!s:real. &0:real < &2521005779196350341220952707025000` in
let ppos = REAL_ARITH `!s:real. &0:real < &4447152981536879285851528064411523937349` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&329816053254762185835165176803750)*(-- &15433728)+(&2521005779196350341220952707025000)*(-- &5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&3604480) * &0 + (&2555904) * -- &1 / &4)) /\
  ((&329816053254762185835165176803750)*(&29458432)+(&2521005779196350341220952707025000)*(&8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((&3604480) * &1 / &4 + (&2555904) * &1 / &16)) /\
  (&329816053254762185835165176803750)*(&21015329)+(&2521005779196350341220952707025000)*(&6951751)+(&4447152981536879285851528064411523937349) = (&9095112875435851152418329474851893)*(&3177943)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &15433728) * x + (&29458432) * y <= &21015329 ==>
  (-- &5660672) * x + (&8896512) * y <= &6951751 ==>
  (&3604480) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&2555904) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3177943
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &329816053254762185835165176803750` [mpos] THEN
  note `&0:real < &2521005779196350341220952707025000` [npos] THEN
  note `&0:real < &4447152981536879285851528064411523937349` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&329816053254762185835165176803750)*(-- &15433728)+(&2521005779196350341220952707025000)*(-- &5660672))*s pow 4 = (&9095112875435851152418329474851893)*((&3604480) * &0 + (&2555904) * -- &1 / &4) /\ ((&329816053254762185835165176803750)*(&29458432)+(&2521005779196350341220952707025000)*(&8896512))*s pow 4 = (&9095112875435851152418329474851893)*((&3604480) * &1 / &4 + (&2555904) * &1 / &16) /\ (&329816053254762185835165176803750)*(&21015329)+(&2521005779196350341220952707025000)*(&6951751)+(&4447152981536879285851528064411523937349) = (&9095112875435851152418329474851893)*(&3177943)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L53 =
let mpos = REAL_ARITH `!s:real. &0:real < &168429563048608533821506680104375` in
let npos = REAL_ARITH `!s:real. &0:real < &10344841223590918054184737796399375` in
let ppos = REAL_ARITH `!s:real. &0:real < &25761035472925267231956663499969294126999` in
let qpos = REAL_ARITH `!s:real. &0:real < &28252030659593626075480540339059139` in
let mqrel = REAL_ARITH `
  ((&168429563048608533821506680104375)*(-- &373096448)+(&10344841223590918054184737796399375)*(-- &5701632))*(&30902639 / &41749730) pow 4 = (&28252030659593626075480540339059139)*(((&5537792) * &0 + (&5177344) * -- &1 / &4)) /\
  ((&168429563048608533821506680104375)*(&503644160)+(&10344841223590918054184737796399375)*(&7340032))*(&30902639 / &41749730) pow 4 = (&28252030659593626075480540339059139)*(((&5537792) * &1 / &4 + (&5177344) * &1 / &16)) /\
  (&168429563048608533821506680104375)*(&426281637)+(&10344841223590918054184737796399375)*(&6407825)+(&25761035472925267231956663499969294126999) = (&28252030659593626075480540339059139)*(&5799491)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &373096448) * x + (&503644160) * y <= &426281637 ==>
  (-- &5701632) * x + (&7340032) * y <= &6407825 ==>
  (&5537792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&5177344) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5799491
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &168429563048608533821506680104375` [mpos] THEN
  note `&0:real < &10344841223590918054184737796399375` [npos] THEN
  note `&0:real < &25761035472925267231956663499969294126999` [ppos] THEN
  note `&0:real < &28252030659593626075480540339059139` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&168429563048608533821506680104375)*(-- &373096448)+(&10344841223590918054184737796399375)*(-- &5701632))*s pow 4 = (&28252030659593626075480540339059139)*((&5537792) * &0 + (&5177344) * -- &1 / &4) /\ ((&168429563048608533821506680104375)*(&503644160)+(&10344841223590918054184737796399375)*(&7340032))*s pow 4 = (&28252030659593626075480540339059139)*((&5537792) * &1 / &4 + (&5177344) * &1 / &16) /\ (&168429563048608533821506680104375)*(&426281637)+(&10344841223590918054184737796399375)*(&6407825)+(&25761035472925267231956663499969294126999) = (&28252030659593626075480540339059139)*(&5799491)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L54 =
let mpos = REAL_ARITH `!s:real. &0:real < &3458335165401603898569539288826586250` in
let npos = REAL_ARITH `!s:real. &0:real < &147823810552799285054680728697152500` in
let ppos = REAL_ARITH `!s:real. &0:real < &31870947276912747436674164364227104462667613` in
let qpos = REAL_ARITH `!s:real. &0:real < &612562646364046066852172396132938249` in
let mqrel = REAL_ARITH `
  ((&3458335165401603898569539288826586250)*(-- &46596096)+(&147823810552799285054680728697152500)*(-- &84901888))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((&289406976) * &0 + (&340459520) * -- &1 / &4)) /\
  ((&3458335165401603898569539288826586250)*(&51871744)+(&147823810552799285054680728697152500)*(&79036416))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((&289406976) * &1 / &4 + (&340459520) * &1 / &16)) /\
  (&3458335165401603898569539288826586250)*(&49963991)+(&147823810552799285054680728697152500)*(&86789633)+(&31870947276912747436674164364227104462667613) = (&612562646364046066852172396132938249)*(&355053887)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &46596096) * x + (&51871744) * y <= &49963991 ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (&289406976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&340459520) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &355053887
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3458335165401603898569539288826586250` [mpos] THEN
  note `&0:real < &147823810552799285054680728697152500` [npos] THEN
  note `&0:real < &31870947276912747436674164364227104462667613` [ppos] THEN
  note `&0:real < &612562646364046066852172396132938249` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3458335165401603898569539288826586250)*(-- &46596096)+(&147823810552799285054680728697152500)*(-- &84901888))*s pow 4 = (&612562646364046066852172396132938249)*((&289406976) * &0 + (&340459520) * -- &1 / &4) /\ ((&3458335165401603898569539288826586250)*(&51871744)+(&147823810552799285054680728697152500)*(&79036416))*s pow 4 = (&612562646364046066852172396132938249)*((&289406976) * &1 / &4 + (&340459520) * &1 / &16) /\ (&3458335165401603898569539288826586250)*(&49963991)+(&147823810552799285054680728697152500)*(&86789633)+(&31870947276912747436674164364227104462667613) = (&612562646364046066852172396132938249)*(&355053887)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L55 =
let mpos = REAL_ARITH `!s:real. &0:real < &32933391348885589944081909895448125` in
let npos = REAL_ARITH `!s:real. &0:real < &13233208848768352561466516952056250` in
let ppos = REAL_ARITH `!s:real. &0:real < &478723714745886334616205672242590008202717` in
let qpos = REAL_ARITH `!s:real. &0:real < &1225125292728092133704344792265876498` in
let mqrel = REAL_ARITH `
  ((&32933391348885589944081909895448125)*(-- &46596096)+(&13233208848768352561466516952056250)*(-- &84901888))*(&30902639 / &41749730) pow 4 = (&1225125292728092133704344792265876498)*(((&2048000) * &0 + (&2605056) * -- &1 / &4)) /\
  ((&32933391348885589944081909895448125)*(&51871744)+(&13233208848768352561466516952056250)*(&79036416))*(&30902639 / &41749730) pow 4 = (&1225125292728092133704344792265876498)*(((&2048000) * &1 / &4 + (&2605056) * &1 / &16)) /\
  (&32933391348885589944081909895448125)*(&49963991)+(&13233208848768352561466516952056250)*(&86789633)+(&478723714745886334616205672242590008202717) = (&1225125292728092133704344792265876498)*(&2671329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &46596096) * x + (&51871744) * y <= &49963991 ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (&2048000) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&2605056) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &2671329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &32933391348885589944081909895448125` [mpos] THEN
  note `&0:real < &13233208848768352561466516952056250` [npos] THEN
  note `&0:real < &478723714745886334616205672242590008202717` [ppos] THEN
  note `&0:real < &1225125292728092133704344792265876498` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&32933391348885589944081909895448125)*(-- &46596096)+(&13233208848768352561466516952056250)*(-- &84901888))*s pow 4 = (&1225125292728092133704344792265876498)*((&2048000) * &0 + (&2605056) * -- &1 / &4) /\ ((&32933391348885589944081909895448125)*(&51871744)+(&13233208848768352561466516952056250)*(&79036416))*s pow 4 = (&1225125292728092133704344792265876498)*((&2048000) * &1 / &4 + (&2605056) * &1 / &16) /\ (&32933391348885589944081909895448125)*(&49963991)+(&13233208848768352561466516952056250)*(&86789633)+(&478723714745886334616205672242590008202717) = (&1225125292728092133704344792265876498)*(&2671329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L56 =
let mpos = REAL_ARITH `!s:real. &0:real < &286441340941804108389780726423053125` in
let npos = REAL_ARITH `!s:real. &0:real < &85437462422241121870479023832561875` in
let ppos = REAL_ARITH `!s:real. &0:real < &5950496995960097009603125073265570454349604` in
let qpos = REAL_ARITH `!s:real. &0:real < &1010791429476243681930188507312638596` in
let mqrel = REAL_ARITH `
  ((&286441340941804108389780726423053125)*(-- &84901888)+(&85437462422241121870479023832561875)*(-- &134447104))*(&30902639 / &41749730) pow 4 = (&1010791429476243681930188507312638596)*(((&26116096) * &0 + (&42532864) * -- &1 / &4)) /\
  ((&286441340941804108389780726423053125)*(&79036416)+(&85437462422241121870479023832561875)*(&97124352))*(&30902639 / &41749730) pow 4 = (&1010791429476243681930188507312638596)*(((&26116096) * &1 / &4 + (&42532864) * &1 / &16)) /\
  (&286441340941804108389780726423053125)*(&86789633)+(&85437462422241121870479023832561875)*(&131957561)+(&5950496995960097009603125073265570454349604) = (&1010791429476243681930188507312638596)*(&41635449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &84901888) * x + (&79036416) * y <= &86789633 ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (&26116096) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&42532864) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &41635449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &286441340941804108389780726423053125` [mpos] THEN
  note `&0:real < &85437462422241121870479023832561875` [npos] THEN
  note `&0:real < &5950496995960097009603125073265570454349604` [ppos] THEN
  note `&0:real < &1010791429476243681930188507312638596` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&286441340941804108389780726423053125)*(-- &84901888)+(&85437462422241121870479023832561875)*(-- &134447104))*s pow 4 = (&1010791429476243681930188507312638596)*((&26116096) * &0 + (&42532864) * -- &1 / &4) /\ ((&286441340941804108389780726423053125)*(&79036416)+(&85437462422241121870479023832561875)*(&97124352))*s pow 4 = (&1010791429476243681930188507312638596)*((&26116096) * &1 / &4 + (&42532864) * &1 / &16) /\ (&286441340941804108389780726423053125)*(&86789633)+(&85437462422241121870479023832561875)*(&131957561)+(&5950496995960097009603125073265570454349604) = (&1010791429476243681930188507312638596)*(&41635449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L57 =
let mpos = REAL_ARITH `!s:real. &0:real < &990725856037588372534636930271310000` in
let npos = REAL_ARITH `!s:real. &0:real < &307658908603501312845414901644589375` in
let ppos = REAL_ARITH `!s:real. &0:real < &23669386238912878490918043812977545439399370` in
let qpos = REAL_ARITH `!s:real. &0:real < &1271151689169521189335689489976324727` in
let mqrel = REAL_ARITH `
  ((&990725856037588372534636930271310000)*(-- &134447104)+(&307658908603501312845414901644589375)*(-- &100401152))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&66748416) * &0 + (&154992640) * -- &1 / &4)) /\
  ((&990725856037588372534636930271310000)*(&97124352)+(&307658908603501312845414901644589375)*(&50266112))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&66748416) * &1 / &4 + (&154992640) * &1 / &16)) /\
  (&990725856037588372534636930271310000)*(&131957561)+(&307658908603501312845414901644589375)*(&95584823)+(&23669386238912878490918043812977545439399370) = (&1271151689169521189335689489976324727)*(&144601685)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &134447104) * x + (&97124352) * y <= &131957561 ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (&66748416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&154992640) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &144601685
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &990725856037588372534636930271310000` [mpos] THEN
  note `&0:real < &307658908603501312845414901644589375` [npos] THEN
  note `&0:real < &23669386238912878490918043812977545439399370` [ppos] THEN
  note `&0:real < &1271151689169521189335689489976324727` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&990725856037588372534636930271310000)*(-- &134447104)+(&307658908603501312845414901644589375)*(-- &100401152))*s pow 4 = (&1271151689169521189335689489976324727)*((&66748416) * &0 + (&154992640) * -- &1 / &4) /\ ((&990725856037588372534636930271310000)*(&97124352)+(&307658908603501312845414901644589375)*(&50266112))*s pow 4 = (&1271151689169521189335689489976324727)*((&66748416) * &1 / &4 + (&154992640) * &1 / &16) /\ (&990725856037588372534636930271310000)*(&131957561)+(&307658908603501312845414901644589375)*(&95584823)+(&23669386238912878490918043812977545439399370) = (&1271151689169521189335689489976324727)*(&144601685)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L58 =
let mpos = REAL_ARITH `!s:real. &0:real < &41039657466749285895423646280629375` in
let npos = REAL_ARITH `!s:real. &0:real < &35139685704084893838638940466060000` in
let ppos = REAL_ARITH `!s:real. &0:real < &810156786838348409627601763543428853205845` in
let qpos = REAL_ARITH `!s:real. &0:real < &438117597115876417199306125508442646` in
let mqrel = REAL_ARITH `
  ((&41039657466749285895423646280629375)*(-- &100401152)+(&35139685704084893838638940466060000)*(-- &64782336))*(&30902639 / &41749730) pow 4 = (&438117597115876417199306125508442646)*(((&3899392) * &0 + (&17530880) * -- &1 / &4)) /\
  ((&41039657466749285895423646280629375)*(&50266112)+(&35139685704084893838638940466060000)*(&27295744))*(&30902639 / &41749730) pow 4 = (&438117597115876417199306125508442646)*(((&3899392) * &1 / &4 + (&17530880) * &1 / &16)) /\
  (&41039657466749285895423646280629375)*(&95584823)+(&35139685704084893838638940466060000)*(&61112343)+(&810156786838348409627601763543428853205845) = (&438117597115876417199306125508442646)*(&15704445)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &100401152) * x + (&50266112) * y <= &95584823 ==>
  (-- &64782336) * x + (&27295744) * y <= &61112343 ==>
  (&3899392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&17530880) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &15704445
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &41039657466749285895423646280629375` [mpos] THEN
  note `&0:real < &35139685704084893838638940466060000` [npos] THEN
  note `&0:real < &810156786838348409627601763543428853205845` [ppos] THEN
  note `&0:real < &438117597115876417199306125508442646` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&41039657466749285895423646280629375)*(-- &100401152)+(&35139685704084893838638940466060000)*(-- &64782336))*s pow 4 = (&438117597115876417199306125508442646)*((&3899392) * &0 + (&17530880) * -- &1 / &4) /\ ((&41039657466749285895423646280629375)*(&50266112)+(&35139685704084893838638940466060000)*(&27295744))*s pow 4 = (&438117597115876417199306125508442646)*((&3899392) * &1 / &4 + (&17530880) * &1 / &16) /\ (&41039657466749285895423646280629375)*(&95584823)+(&35139685704084893838638940466060000)*(&61112343)+(&810156786838348409627601763543428853205845) = (&438117597115876417199306125508442646)*(&15704445)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L59 =
let mpos = REAL_ARITH `!s:real. &0:real < &11646021311340957645118776550342125` in
let npos = REAL_ARITH `!s:real. &0:real < &552988245220020036296495776550125` in
let ppos = REAL_ARITH `!s:real. &0:real < &5761945166021636832791359073384344602714` in
let qpos = REAL_ARITH `!s:real. &0:real < &873670724422695819113281824617278` in
let mqrel = REAL_ARITH `
  ((&11646021311340957645118776550342125)*(-- &3866624)+(&552988245220020036296495776550125)*(-- &39124992))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((&65536) * &0 + (&91619328) * -- &1 / &4)) /\
  ((&11646021311340957645118776550342125)*(&1310720)+(&552988245220020036296495776550125)*(&2621440))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((&65536) * &1 / &4 + (&91619328) * &1 / &16)) /\
  (&11646021311340957645118776550342125)*(&3642043)+(&552988245220020036296495776550125)*(&38657149)+(&5761945166021636832791359073384344602714) = (&873670724422695819113281824617278)*(&79611463)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (&65536) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&91619328) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &79611463
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &11646021311340957645118776550342125` [mpos] THEN
  note `&0:real < &552988245220020036296495776550125` [npos] THEN
  note `&0:real < &5761945166021636832791359073384344602714` [ppos] THEN
  note `&0:real < &873670724422695819113281824617278` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&11646021311340957645118776550342125)*(-- &3866624)+(&552988245220020036296495776550125)*(-- &39124992))*s pow 4 = (&873670724422695819113281824617278)*((&65536) * &0 + (&91619328) * -- &1 / &4) /\ ((&11646021311340957645118776550342125)*(&1310720)+(&552988245220020036296495776550125)*(&2621440))*s pow 4 = (&873670724422695819113281824617278)*((&65536) * &1 / &4 + (&91619328) * &1 / &16) /\ (&11646021311340957645118776550342125)*(&3642043)+(&552988245220020036296495776550125)*(&38657149)+(&5761945166021636832791359073384344602714) = (&873670724422695819113281824617278)*(&79611463)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L60 =
let mpos = REAL_ARITH `!s:real. &0:real < &16987308225750991158262403498842625` in
let npos = REAL_ARITH `!s:real. &0:real < &2721191314796380445076080755246625` in
let ppos = REAL_ARITH `!s:real. &0:real < &10894392903570612626398101539072298284484` in
let qpos = REAL_ARITH `!s:real. &0:real < &1747341448845391638226563649234556` in
let mqrel = REAL_ARITH `
  ((&16987308225750991158262403498842625)*(-- &3866624)+(&2721191314796380445076080755246625)*(-- &39124992))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((-- &9371648) * &0 + (&118292480) * -- &1 / &4)) /\
  ((&16987308225750991158262403498842625)*(&1310720)+(&2721191314796380445076080755246625)*(&2621440))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((-- &9371648) * &1 / &4 + (&118292480) * &1 / &16)) /\
  (&16987308225750991158262403498842625)*(&3642043)+(&2721191314796380445076080755246625)*(&38657149)+(&10894392903570612626398101539072298284484) = (&1747341448845391638226563649234556)*(&101844089)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &9371648) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&118292480) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &101844089
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &16987308225750991158262403498842625` [mpos] THEN
  note `&0:real < &2721191314796380445076080755246625` [npos] THEN
  note `&0:real < &10894392903570612626398101539072298284484` [ppos] THEN
  note `&0:real < &1747341448845391638226563649234556` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&16987308225750991158262403498842625)*(-- &3866624)+(&2721191314796380445076080755246625)*(-- &39124992))*s pow 4 = (&1747341448845391638226563649234556)*((-- &9371648) * &0 + (&118292480) * -- &1 / &4) /\ ((&16987308225750991158262403498842625)*(&1310720)+(&2721191314796380445076080755246625)*(&2621440))*s pow 4 = (&1747341448845391638226563649234556)*((-- &9371648) * &1 / &4 + (&118292480) * &1 / &16) /\ (&16987308225750991158262403498842625)*(&3642043)+(&2721191314796380445076080755246625)*(&38657149)+(&10894392903570612626398101539072298284484) = (&1747341448845391638226563649234556)*(&101844089)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L61 =
let mpos = REAL_ARITH `!s:real. &0:real < &112678808019215675275853510680875` in
let npos = REAL_ARITH `!s:real. &0:real < &43711933950157479690767573573875` in
let ppos = REAL_ARITH `!s:real. &0:real < &109081305850215475290664583554273369903` in
let qpos = REAL_ARITH `!s:real. &0:real < &436835362211347909556640912308639` in
let mqrel = REAL_ARITH `
  ((&112678808019215675275853510680875)*(-- &3866624)+(&43711933950157479690767573573875)*(-- &39124992))*(&30902639 / &41749730) pow 4 = (&436835362211347909556640912308639)*(((-- &753664) * &0 + (&5898240) * -- &1 / &4)) /\
  ((&112678808019215675275853510680875)*(&1310720)+(&43711933950157479690767573573875)*(&2621440))*(&30902639 / &41749730) pow 4 = (&436835362211347909556640912308639)*(((-- &753664) * &1 / &4 + (&5898240) * &1 / &16)) /\
  (&112678808019215675275853510680875)*(&3642043)+(&43711933950157479690767573573875)*(&38657149)+(&109081305850215475290664583554273369903) = (&436835362211347909556640912308639)*(&5057377)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &753664) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&5898240) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &5057377
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &112678808019215675275853510680875` [mpos] THEN
  note `&0:real < &43711933950157479690767573573875` [npos] THEN
  note `&0:real < &109081305850215475290664583554273369903` [ppos] THEN
  note `&0:real < &436835362211347909556640912308639` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&112678808019215675275853510680875)*(-- &3866624)+(&43711933950157479690767573573875)*(-- &39124992))*s pow 4 = (&436835362211347909556640912308639)*((-- &753664) * &0 + (&5898240) * -- &1 / &4) /\ ((&112678808019215675275853510680875)*(&1310720)+(&43711933950157479690767573573875)*(&2621440))*s pow 4 = (&436835362211347909556640912308639)*((-- &753664) * &1 / &4 + (&5898240) * &1 / &16) /\ (&112678808019215675275853510680875)*(&3642043)+(&43711933950157479690767573573875)*(&38657149)+(&109081305850215475290664583554273369903) = (&436835362211347909556640912308639)*(&5057377)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L62 =
let mpos = REAL_ARITH `!s:real. &0:real < &54718796401045656811824127480213375` in
let npos = REAL_ARITH `!s:real. &0:real < &28951313918468724283355808106121375` in
let ppos = REAL_ARITH `!s:real. &0:real < &64163620681854107922897523564508909851868` in
let qpos = REAL_ARITH `!s:real. &0:real < &1747341448845391638226563649234556` in
let mqrel = REAL_ARITH `
  ((&54718796401045656811824127480213375)*(-- &3866624)+(&28951313918468724283355808106121375)*(-- &39124992))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((-- &129499136) * &0 + (&923729920) * -- &1 / &4)) /\
  ((&54718796401045656811824127480213375)*(&1310720)+(&28951313918468724283355808106121375)*(&2621440))*(&30902639 / &41749730) pow 4 = (&1747341448845391638226563649234556)*(((-- &129499136) * &1 / &4 + (&923729920) * &1 / &16)) /\
  (&54718796401045656811824127480213375)*(&3642043)+(&28951313918468724283355808106121375)*(&38657149)+(&64163620681854107922897523564508909851868) = (&1747341448845391638226563649234556)*(&791274703)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &129499136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&923729920) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &791274703
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &54718796401045656811824127480213375` [mpos] THEN
  note `&0:real < &28951313918468724283355808106121375` [npos] THEN
  note `&0:real < &64163620681854107922897523564508909851868` [ppos] THEN
  note `&0:real < &1747341448845391638226563649234556` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&54718796401045656811824127480213375)*(-- &3866624)+(&28951313918468724283355808106121375)*(-- &39124992))*s pow 4 = (&1747341448845391638226563649234556)*((-- &129499136) * &0 + (&923729920) * -- &1 / &4) /\ ((&54718796401045656811824127480213375)*(&1310720)+(&28951313918468724283355808106121375)*(&2621440))*s pow 4 = (&1747341448845391638226563649234556)*((-- &129499136) * &1 / &4 + (&923729920) * &1 / &16) /\ (&54718796401045656811824127480213375)*(&3642043)+(&28951313918468724283355808106121375)*(&38657149)+(&64163620681854107922897523564508909851868) = (&1747341448845391638226563649234556)*(&791274703)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L63 =
let mpos = REAL_ARITH `!s:real. &0:real < &895316110230202070990308902696875` in
let npos = REAL_ARITH `!s:real. &0:real < &962156252499773890500083819716875` in
let ppos = REAL_ARITH `!s:real. &0:real < &1968852426982449004793167532923111421704` in
let qpos = REAL_ARITH `!s:real. &0:real < &6989365795381566552906254596938224` in
let mqrel = REAL_ARITH `
  ((&895316110230202070990308902696875)*(-- &3866624)+(&962156252499773890500083819716875)*(-- &39124992))*(&30902639 / &41749730) pow 4 = (&6989365795381566552906254596938224)*(((-- &1130496) * &0 + (&7061504) * -- &1 / &4)) /\
  ((&895316110230202070990308902696875)*(&1310720)+(&962156252499773890500083819716875)*(&2621440))*(&30902639 / &41749730) pow 4 = (&6989365795381566552906254596938224)*(((-- &1130496) * &1 / &4 + (&7061504) * &1 / &16)) /\
  (&895316110230202070990308902696875)*(&3642043)+(&962156252499773890500083819716875)*(&38657149)+(&1968852426982449004793167532923111421704) = (&6989365795381566552906254596938224)*(&6069771)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &3866624) * x + (&1310720) * y <= &3642043 ==>
  (-- &39124992) * x + (&2621440) * y <= &38657149 ==>
  (-- &1130496) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&7061504) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &6069771
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &895316110230202070990308902696875` [mpos] THEN
  note `&0:real < &962156252499773890500083819716875` [npos] THEN
  note `&0:real < &1968852426982449004793167532923111421704` [ppos] THEN
  note `&0:real < &6989365795381566552906254596938224` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&895316110230202070990308902696875)*(-- &3866624)+(&962156252499773890500083819716875)*(-- &39124992))*s pow 4 = (&6989365795381566552906254596938224)*((-- &1130496) * &0 + (&7061504) * -- &1 / &4) /\ ((&895316110230202070990308902696875)*(&1310720)+(&962156252499773890500083819716875)*(&2621440))*s pow 4 = (&6989365795381566552906254596938224)*((-- &1130496) * &1 / &4 + (&7061504) * &1 / &16) /\ (&895316110230202070990308902696875)*(&3642043)+(&962156252499773890500083819716875)*(&38657149)+(&1968852426982449004793167532923111421704) = (&6989365795381566552906254596938224)*(&6069771)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L64 =
let mpos = REAL_ARITH `!s:real. &0:real < &333938857495047337494601915751788125` in
let npos = REAL_ARITH `!s:real. &0:real < &369329763392946559507136970465625` in
let ppos = REAL_ARITH `!s:real. &0:real < &103262452074721270250360467926361469155654` in
let qpos = REAL_ARITH `!s:real. &0:real < &2285792559280199317040906350714547384` in
let mqrel = REAL_ARITH `
  ((&333938857495047337494601915751788125)*(-- &5865472)+(&369329763392946559507136970465625)*(-- &439386112))*(&30902639 / &41749730) pow 4 = (&2285792559280199317040906350714547384)*(((-- &481280) * &0 + (&1114112) * -- &1 / &4)) /\
  ((&333938857495047337494601915751788125)*(-- &950272)+(&369329763392946559507136970465625)*(-- &185892864))*(&30902639 / &41749730) pow 4 = (&2285792559280199317040906350714547384)*(((-- &481280) * &1 / &4 + (&1114112) * &1 / &16)) /\
  (&333938857495047337494601915751788125)*(&6035371)+(&369329763392946559507136970465625)*(&480443643)+(&103262452074721270250360467926361469155654) = (&2285792559280199317040906350714547384)*(&1004531)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &481280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&1114112) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &1004531
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &333938857495047337494601915751788125` [mpos] THEN
  note `&0:real < &369329763392946559507136970465625` [npos] THEN
  note `&0:real < &103262452074721270250360467926361469155654` [ppos] THEN
  note `&0:real < &2285792559280199317040906350714547384` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&333938857495047337494601915751788125)*(-- &5865472)+(&369329763392946559507136970465625)*(-- &439386112))*s pow 4 = (&2285792559280199317040906350714547384)*((-- &481280) * &0 + (&1114112) * -- &1 / &4) /\ ((&333938857495047337494601915751788125)*(-- &950272)+(&369329763392946559507136970465625)*(-- &185892864))*s pow 4 = (&2285792559280199317040906350714547384)*((-- &481280) * &1 / &4 + (&1114112) * &1 / &16) /\ (&333938857495047337494601915751788125)*(&6035371)+(&369329763392946559507136970465625)*(&480443643)+(&103262452074721270250360467926361469155654) = (&2285792559280199317040906350714547384)*(&1004531)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L65 =
let mpos = REAL_ARITH `!s:real. &0:real < &113177830445023728519238989322717500` in
let npos = REAL_ARITH `!s:real. &0:real < &34657373313844233550130905553472500` in
let ppos = REAL_ARITH `!s:real. &0:real < &586547345971719081715432878086409243799445` in
let qpos = REAL_ARITH `!s:real. &0:real < &285724069910024914630113293839318423` in
let mqrel = REAL_ARITH `
  ((&113177830445023728519238989322717500)*(-- &5865472)+(&34657373313844233550130905553472500)*(-- &439386112))*(&30902639 / &41749730) pow 4 = (&285724069910024914630113293839318423)*(((-- &44220416) * &0 + (&66781184) * -- &1 / &4)) /\
  ((&113177830445023728519238989322717500)*(-- &950272)+(&34657373313844233550130905553472500)*(-- &185892864))*(&30902639 / &41749730) pow 4 = (&285724069910024914630113293839318423)*(((-- &44220416) * &1 / &4 + (&66781184) * &1 / &16)) /\
  (&113177830445023728519238989322717500)*(&6035371)+(&34657373313844233550130905553472500)*(&480443643)+(&586547345971719081715432878086409243799445) = (&285724069910024914630113293839318423)*(&62719715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &5865472) * x + (-- &950272) * y <= &6035371 ==>
  (-- &439386112) * x + (-- &185892864) * y <= &480443643 ==>
  (-- &44220416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&66781184) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &62719715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &113177830445023728519238989322717500` [mpos] THEN
  note `&0:real < &34657373313844233550130905553472500` [npos] THEN
  note `&0:real < &586547345971719081715432878086409243799445` [ppos] THEN
  note `&0:real < &285724069910024914630113293839318423` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&113177830445023728519238989322717500)*(-- &5865472)+(&34657373313844233550130905553472500)*(-- &439386112))*s pow 4 = (&285724069910024914630113293839318423)*((-- &44220416) * &0 + (&66781184) * -- &1 / &4) /\ ((&113177830445023728519238989322717500)*(-- &950272)+(&34657373313844233550130905553472500)*(-- &185892864))*s pow 4 = (&285724069910024914630113293839318423)*((-- &44220416) * &1 / &4 + (&66781184) * &1 / &16) /\ (&113177830445023728519238989322717500)*(&6035371)+(&34657373313844233550130905553472500)*(&480443643)+(&586547345971719081715432878086409243799445) = (&285724069910024914630113293839318423)*(&62719715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L66 =
let mpos = REAL_ARITH `!s:real. &0:real < &8858476654897939762069639796634375` in
let npos = REAL_ARITH `!s:real. &0:real < &7270557190292799534475201446448750` in
let ppos = REAL_ARITH `!s:real. &0:real < &164888823917505789374642032704055929830` in
let qpos = REAL_ARITH `!s:real. &0:real < &9531036264030891446297399111769491` in
let mqrel = REAL_ARITH `
  ((&8858476654897939762069639796634375)*(-- &49741824)+(&7270557190292799534475201446448750)*(-- &33521664))*(&30902639 / &41749730) pow 4 = (&9531036264030891446297399111769491)*(((-- &75169792) * &0 + (&86212608) * -- &1 / &4)) /\
  ((&8858476654897939762069639796634375)*(-- &27000832)+(&7270557190292799534475201446448750)*(-- &25640960))*(&30902639 / &41749730) pow 4 = (&9531036264030891446297399111769491)*(((-- &75169792) * &1 / &4 + (&86212608) * &1 / &16)) /\
  (&8858476654897939762069639796634375)*(&57079641)+(&7270557190292799534475201446448750)*(&41914863)+(&164888823917505789374642032704055929830) = (&9531036264030891446297399111769491)*(&85043005)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &75169792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&86212608) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &85043005
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8858476654897939762069639796634375` [mpos] THEN
  note `&0:real < &7270557190292799534475201446448750` [npos] THEN
  note `&0:real < &164888823917505789374642032704055929830` [ppos] THEN
  note `&0:real < &9531036264030891446297399111769491` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&8858476654897939762069639796634375)*(-- &49741824)+(&7270557190292799534475201446448750)*(-- &33521664))*s pow 4 = (&9531036264030891446297399111769491)*((-- &75169792) * &0 + (&86212608) * -- &1 / &4) /\ ((&8858476654897939762069639796634375)*(-- &27000832)+(&7270557190292799534475201446448750)*(-- &25640960))*s pow 4 = (&9531036264030891446297399111769491)*((-- &75169792) * &1 / &4 + (&86212608) * &1 / &16) /\ (&8858476654897939762069639796634375)*(&57079641)+(&7270557190292799534475201446448750)*(&41914863)+(&164888823917505789374642032704055929830) = (&9531036264030891446297399111769491)*(&85043005)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L67 =
let mpos = REAL_ARITH `!s:real. &0:real < &7957981814636520866220618994375` in
let npos = REAL_ARITH `!s:real. &0:real < &11318252582691869844044422144498750` in
let ppos = REAL_ARITH `!s:real. &0:real < &98804352363922191042865976247032896014` in
let qpos = REAL_ARITH `!s:real. &0:real < &4084729827441810619841742476472639` in
let mqrel = REAL_ARITH `
  ((&7957981814636520866220618994375)*(-- &49741824)+(&11318252582691869844044422144498750)*(-- &33521664))*(&30902639 / &41749730) pow 4 = (&4084729827441810619841742476472639)*(((-- &113278976) * &0 + (&111640576) * -- &1 / &4)) /\
  ((&7957981814636520866220618994375)*(-- &27000832)+(&11318252582691869844044422144498750)*(-- &25640960))*(&30902639 / &41749730) pow 4 = (&4084729827441810619841742476472639)*(((-- &113278976) * &1 / &4 + (&111640576) * &1 / &16)) /\
  (&7957981814636520866220618994375)*(&57079641)+(&11318252582691869844044422144498750)*(&41914863)+(&98804352363922191042865976247032896014) = (&4084729827441810619841742476472639)*(&116276001)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &49741824) * x + (-- &27000832) * y <= &57079641 ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &113278976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&111640576) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &116276001
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7957981814636520866220618994375` [mpos] THEN
  note `&0:real < &11318252582691869844044422144498750` [npos] THEN
  note `&0:real < &98804352363922191042865976247032896014` [ppos] THEN
  note `&0:real < &4084729827441810619841742476472639` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&7957981814636520866220618994375)*(-- &49741824)+(&11318252582691869844044422144498750)*(-- &33521664))*s pow 4 = (&4084729827441810619841742476472639)*((-- &113278976) * &0 + (&111640576) * -- &1 / &4) /\ ((&7957981814636520866220618994375)*(-- &27000832)+(&11318252582691869844044422144498750)*(-- &25640960))*s pow 4 = (&4084729827441810619841742476472639)*((-- &113278976) * &1 / &4 + (&111640576) * &1 / &16) /\ (&7957981814636520866220618994375)*(&57079641)+(&11318252582691869844044422144498750)*(&41914863)+(&98804352363922191042865976247032896014) = (&4084729827441810619841742476472639)*(&116276001)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L68 =
let mpos = REAL_ARITH `!s:real. &0:real < &3607848588414387984902623361875` in
let npos = REAL_ARITH `!s:real. &0:real < &17161776188015998509869168253836875` in
let ppos = REAL_ARITH `!s:real. &0:real < &8959065050212919978873377562094456360` in
let qpos = REAL_ARITH `!s:real. &0:real < &3545753420204009754397118720367408` in
let mqrel = REAL_ARITH `
  ((&3607848588414387984902623361875)*(-- &33521664)+(&17161776188015998509869168253836875)*(-- &1867776))*(&30902639 / &41749730) pow 4 = (&3545753420204009754397118720367408)*(((-- &11419648) * &0 + (&10895360) * -- &1 / &4)) /\
  ((&3607848588414387984902623361875)*(-- &25640960)+(&17161776188015998509869168253836875)*(-- &1490944))*(&30902639 / &41749730) pow 4 = (&3545753420204009754397118720367408)*(((-- &11419648) * &1 / &4 + (&10895360) * &1 / &16)) /\
  (&3607848588414387984902623361875)*(&41914863)+(&17161776188015998509869168253836875)*(&2368161)+(&8959065050212919978873377562094456360) = (&3545753420204009754397118720367408)*(&11507295)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &33521664) * x + (-- &25640960) * y <= &41914863 ==>
  (-- &1867776) * x + (-- &1490944) * y <= &2368161 ==>
  (-- &11419648) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&10895360) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &11507295
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3607848588414387984902623361875` [mpos] THEN
  note `&0:real < &17161776188015998509869168253836875` [npos] THEN
  note `&0:real < &8959065050212919978873377562094456360` [ppos] THEN
  note `&0:real < &3545753420204009754397118720367408` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3607848588414387984902623361875)*(-- &33521664)+(&17161776188015998509869168253836875)*(-- &1867776))*s pow 4 = (&3545753420204009754397118720367408)*((-- &11419648) * &0 + (&10895360) * -- &1 / &4) /\ ((&3607848588414387984902623361875)*(-- &25640960)+(&17161776188015998509869168253836875)*(-- &1490944))*s pow 4 = (&3545753420204009754397118720367408)*((-- &11419648) * &1 / &4 + (&10895360) * &1 / &16) /\ (&3607848588414387984902623361875)*(&41914863)+(&17161776188015998509869168253836875)*(&2368161)+(&8959065050212919978873377562094456360) = (&3545753420204009754397118720367408)*(&11507295)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L69 =
let mpos = REAL_ARITH `!s:real. &0:real < &21388155028925486666480145193125` in
let npos = REAL_ARITH `!s:real. &0:real < &914908972181639058372435589375` in
let ppos = REAL_ARITH `!s:real. &0:real < &48439294848239220525220318422817012` in
let qpos = REAL_ARITH `!s:real. &0:real < &62014205908917866074846726590788` in
let mqrel = REAL_ARITH `
  ((&21388155028925486666480145193125)*(-- &7634944)+(&914908972181639058372435589375)*(-- &950272))*(&30902639 / &41749730) pow 4 = (&62014205908917866074846726590788)*(((-- &4050944) * &0 + (&3178496) * -- &1 / &4)) /\
  ((&21388155028925486666480145193125)*(-- &7815168)+(&914908972181639058372435589375)*(-- &1130496))*(&30902639 / &41749730) pow 4 = (&62014205908917866074846726590788)*(((-- &4050944) * &1 / &4 + (&3178496) * &1 / &16)) /\
  (&21388155028925486666480145193125)*(&10605687)+(&914908972181639058372435589375)*(&1407123)+(&48439294848239220525220318422817012) = (&62014205908917866074846726590788)*(&3679349)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &950272) * x + (-- &1130496) * y <= &1407123 ==>
  (-- &4050944) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&3178496) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3679349
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &21388155028925486666480145193125` [mpos] THEN
  note `&0:real < &914908972181639058372435589375` [npos] THEN
  note `&0:real < &48439294848239220525220318422817012` [ppos] THEN
  note `&0:real < &62014205908917866074846726590788` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&21388155028925486666480145193125)*(-- &7634944)+(&914908972181639058372435589375)*(-- &950272))*s pow 4 = (&62014205908917866074846726590788)*((-- &4050944) * &0 + (&3178496) * -- &1 / &4) /\ ((&21388155028925486666480145193125)*(-- &7815168)+(&914908972181639058372435589375)*(-- &1130496))*s pow 4 = (&62014205908917866074846726590788)*((-- &4050944) * &1 / &4 + (&3178496) * &1 / &16) /\ (&21388155028925486666480145193125)*(&10605687)+(&914908972181639058372435589375)*(&1407123)+(&48439294848239220525220318422817012) = (&62014205908917866074846726590788)*(&3679349)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L70 =
let mpos = REAL_ARITH `!s:real. &0:real < &500610569684293069675483624375` in
let npos = REAL_ARITH `!s:real. &0:real < &125100855120761099170283787098125` in
let ppos = REAL_ARITH `!s:real. &0:real < &38516595092018891067780522058782311` in
let qpos = REAL_ARITH `!s:real. &0:real < &15503551477229466518711681647697` in
let mqrel = REAL_ARITH `
  ((&500610569684293069675483624375)*(-- &7634944)+(&125100855120761099170283787098125)*(-- &950272))*(&30902639 / &41749730) pow 4 = (&15503551477229466518711681647697)*(((-- &13631488) * &0 + (&9502720) * -- &1 / &4)) /\
  ((&500610569684293069675483624375)*(-- &7815168)+(&125100855120761099170283787098125)*(-- &1130496))*(&30902639 / &41749730) pow 4 = (&15503551477229466518711681647697)*(((-- &13631488) * &1 / &4 + (&9502720) * &1 / &16)) /\
  (&500610569684293069675483624375)*(&10605687)+(&125100855120761099170283787098125)*(&1407123)+(&38516595092018891067780522058782311) = (&15503551477229466518711681647697)*(&11699263)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7634944) * x + (-- &7815168) * y <= &10605687 ==>
  (-- &950272) * x + (-- &1130496) * y <= &1407123 ==>
  (-- &13631488) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&9502720) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &11699263
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &500610569684293069675483624375` [mpos] THEN
  note `&0:real < &125100855120761099170283787098125` [npos] THEN
  note `&0:real < &38516595092018891067780522058782311` [ppos] THEN
  note `&0:real < &15503551477229466518711681647697` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&500610569684293069675483624375)*(-- &7634944)+(&125100855120761099170283787098125)*(-- &950272))*s pow 4 = (&15503551477229466518711681647697)*((-- &13631488) * &0 + (&9502720) * -- &1 / &4) /\ ((&500610569684293069675483624375)*(-- &7815168)+(&125100855120761099170283787098125)*(-- &1130496))*s pow 4 = (&15503551477229466518711681647697)*((-- &13631488) * &1 / &4 + (&9502720) * &1 / &16) /\ (&500610569684293069675483624375)*(&10605687)+(&125100855120761099170283787098125)*(&1407123)+(&38516595092018891067780522058782311) = (&15503551477229466518711681647697)*(&11699263)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L71 =
let mpos = REAL_ARITH `!s:real. &0:real < &958396494497110475652658980634500` in
let npos = REAL_ARITH `!s:real. &0:real < &2058904246024185581194850767796750` in
let ppos = REAL_ARITH `!s:real. &0:real < &300998299337111868517121647879909118457` in
let qpos = REAL_ARITH `!s:real. &0:real < &2970298068313904261849643948620537` in
let mqrel = REAL_ARITH `
  ((&958396494497110475652658980634500)*(-- &950272)+(&2058904246024185581194850767796750)*(-- &438239232))*(&30902639 / &41749730) pow 4 = (&2970298068313904261849643948620537)*(((-- &540934144) * &0 + (&365101056) * -- &1 / &4)) /\
  ((&958396494497110475652658980634500)*(-- &1130496)+(&2058904246024185581194850767796750)*(-- &539754496))*(&30902639 / &41749730) pow 4 = (&2970298068313904261849643948620537)*(((-- &540934144) * &1 / &4 + (&365101056) * &1 / &16)) /\
  (&958396494497110475652658980634500)*(&1407123)+(&2058904246024185581194850767796750)*(&659132513)+(&300998299337111868517121647879909118457) = (&2970298068313904261849643948620537)*(&457442411)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &950272) * x + (-- &1130496) * y <= &1407123 ==>
  (-- &438239232) * x + (-- &539754496) * y <= &659132513 ==>
  (-- &540934144) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&365101056) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &457442411
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &958396494497110475652658980634500` [mpos] THEN
  note `&0:real < &2058904246024185581194850767796750` [npos] THEN
  note `&0:real < &300998299337111868517121647879909118457` [ppos] THEN
  note `&0:real < &2970298068313904261849643948620537` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&958396494497110475652658980634500)*(-- &950272)+(&2058904246024185581194850767796750)*(-- &438239232))*s pow 4 = (&2970298068313904261849643948620537)*((-- &540934144) * &0 + (&365101056) * -- &1 / &4) /\ ((&958396494497110475652658980634500)*(-- &1130496)+(&2058904246024185581194850767796750)*(-- &539754496))*s pow 4 = (&2970298068313904261849643948620537)*((-- &540934144) * &1 / &4 + (&365101056) * &1 / &16) /\ (&958396494497110475652658980634500)*(&1407123)+(&2058904246024185581194850767796750)*(&659132513)+(&300998299337111868517121647879909118457) = (&2970298068313904261849643948620537)*(&457442411)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L72 =
let mpos = REAL_ARITH `!s:real. &0:real < &29052675475126387457373756545625` in
let npos = REAL_ARITH `!s:real. &0:real < &30594366142986198828396093339049375` in
let ppos = REAL_ARITH `!s:real. &0:real < &143466736158737598758750844915263210992` in
let qpos = REAL_ARITH `!s:real. &0:real < &90883642706751747964043020369581896` in
let mqrel = REAL_ARITH `
  ((&29052675475126387457373756545625)*(-- &438239232)+(&30594366142986198828396093339049375)*(-- &13041664))*(&30902639 / &41749730) pow 4 = (&90883642706751747964043020369581896)*(((-- &8454144) * &0 + (&5439488) * -- &1 / &4)) /\
  ((&29052675475126387457373756545625)*(-- &539754496)+(&30594366142986198828396093339049375)*(-- &17039360))*(&30902639 / &41749730) pow 4 = (&90883642706751747964043020369581896)*(((-- &8454144) * &1 / &4 + (&5439488) * &1 / &16)) /\
  (&29052675475126387457373756545625)*(&659132513)+(&30594366142986198828396093339049375)*(&20256657)+(&143466736158737598758750844915263210992) = (&90883642706751747964043020369581896)*(&7031327)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &438239232) * x + (-- &539754496) * y <= &659132513 ==>
  (-- &13041664) * x + (-- &17039360) * y <= &20256657 ==>
  (-- &8454144) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&5439488) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &7031327
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &29052675475126387457373756545625` [mpos] THEN
  note `&0:real < &30594366142986198828396093339049375` [npos] THEN
  note `&0:real < &143466736158737598758750844915263210992` [ppos] THEN
  note `&0:real < &90883642706751747964043020369581896` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&29052675475126387457373756545625)*(-- &438239232)+(&30594366142986198828396093339049375)*(-- &13041664))*s pow 4 = (&90883642706751747964043020369581896)*((-- &8454144) * &0 + (&5439488) * -- &1 / &4) /\ ((&29052675475126387457373756545625)*(-- &539754496)+(&30594366142986198828396093339049375)*(-- &17039360))*s pow 4 = (&90883642706751747964043020369581896)*((-- &8454144) * &1 / &4 + (&5439488) * &1 / &16) /\ (&29052675475126387457373756545625)*(&659132513)+(&30594366142986198828396093339049375)*(&20256657)+(&143466736158737598758750844915263210992) = (&90883642706751747964043020369581896)*(&7031327)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L73 =
let mpos = REAL_ARITH `!s:real. &0:real < &141180811867689340356584235239687500` in
let npos = REAL_ARITH `!s:real. &0:real < &1227428067132137049179503021640000` in
let ppos = REAL_ARITH `!s:real. &0:real < &411934394476186557812895738869873942719` in
let qpos = REAL_ARITH `!s:real. &0:real < &68336918990778565567448378876875253` in
let mqrel = REAL_ARITH `
  ((&141180811867689340356584235239687500)*(-- &7733248)+(&1227428067132137049179503021640000)*(-- &897024))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((-- &34471936) * &0 + (&19202048) * -- &1 / &4)) /\
  ((&141180811867689340356584235239687500)*(-- &11943936)+(&1227428067132137049179503021640000)*(-- &2035712))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((-- &34471936) * &1 / &4 + (&19202048) * &1 / &16)) /\
  (&141180811867689340356584235239687500)*(&13225515)+(&1227428067132137049179503021640000)*(&1977153)+(&411934394476186557812895738869873942719) = (&68336918990778565567448378876875253)*(&27364823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &11943936) * y <= &13225515 ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &34471936) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&19202048) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &27364823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &141180811867689340356584235239687500` [mpos] THEN
  note `&0:real < &1227428067132137049179503021640000` [npos] THEN
  note `&0:real < &411934394476186557812895738869873942719` [ppos] THEN
  note `&0:real < &68336918990778565567448378876875253` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&141180811867689340356584235239687500)*(-- &7733248)+(&1227428067132137049179503021640000)*(-- &897024))*s pow 4 = (&68336918990778565567448378876875253)*((-- &34471936) * &0 + (&19202048) * -- &1 / &4) /\ ((&141180811867689340356584235239687500)*(-- &11943936)+(&1227428067132137049179503021640000)*(-- &2035712))*s pow 4 = (&68336918990778565567448378876875253)*((-- &34471936) * &1 / &4 + (&19202048) * &1 / &16) /\ (&141180811867689340356584235239687500)*(&13225515)+(&1227428067132137049179503021640000)*(&1977153)+(&411934394476186557812895738869873942719) = (&68336918990778565567448378876875253)*(&27364823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L74 =
let mpos = REAL_ARITH `!s:real. &0:real < &36685933654372176015536943731099375` in
let npos = REAL_ARITH `!s:real. &0:real < &302260237907858709434953507707670000` in
let ppos = REAL_ARITH `!s:real. &0:real < &213082608301124092948194847623923660270` in
let qpos = REAL_ARITH `!s:real. &0:real < &68336918990778565567448378876875253` in
let mqrel = REAL_ARITH `
  ((&36685933654372176015536943731099375)*(-- &7733248)+(&302260237907858709434953507707670000)*(-- &897024))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((-- &20946944) * &0 + (&9748480) * -- &1 / &4)) /\
  ((&36685933654372176015536943731099375)*(-- &11943936)+(&302260237907858709434953507707670000)*(-- &2035712))*(&30902639 / &41749730) pow 4 = (&68336918990778565567448378876875253)*(((-- &20946944) * &1 / &4 + (&9748480) * &1 / &16)) /\
  (&36685933654372176015536943731099375)*(&13225515)+(&302260237907858709434953507707670000)*(&1977153)+(&213082608301124092948194847623923660270) = (&68336918990778565567448378876875253)*(&15848215)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &11943936) * y <= &13225515 ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &20946944) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&9748480) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &15848215
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &36685933654372176015536943731099375` [mpos] THEN
  note `&0:real < &302260237907858709434953507707670000` [npos] THEN
  note `&0:real < &213082608301124092948194847623923660270` [ppos] THEN
  note `&0:real < &68336918990778565567448378876875253` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&36685933654372176015536943731099375)*(-- &7733248)+(&302260237907858709434953507707670000)*(-- &897024))*s pow 4 = (&68336918990778565567448378876875253)*((-- &20946944) * &0 + (&9748480) * -- &1 / &4) /\ ((&36685933654372176015536943731099375)*(-- &11943936)+(&302260237907858709434953507707670000)*(-- &2035712))*s pow 4 = (&68336918990778565567448378876875253)*((-- &20946944) * &1 / &4 + (&9748480) * &1 / &16) /\ (&36685933654372176015536943731099375)*(&13225515)+(&302260237907858709434953507707670000)*(&1977153)+(&213082608301124092948194847623923660270) = (&68336918990778565567448378876875253)*(&15848215)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L75 =
let mpos = REAL_ARITH `!s:real. &0:real < &503266584955403242640771196303619375` in
let npos = REAL_ARITH `!s:real. &0:real < &90892339601155865220073637586066250` in
let ppos = REAL_ARITH `!s:real. &0:real < &18029506647568188026693225850737659376315` in
let qpos = REAL_ARITH `!s:real. &0:real < &75810542776419476045144980706456248` in
let mqrel = REAL_ARITH `
  ((&503266584955403242640771196303619375)*(-- &897024)+(&90892339601155865220073637586066250)*(-- &1275904))*(&30902639 / &41749730) pow 4 = (&75810542776419476045144980706456248)*(((-- &24879104) * &0 + (&8986624) * -- &1 / &4)) /\
  ((&503266584955403242640771196303619375)*(-- &2035712)+(&90892339601155865220073637586066250)*(-- &4450304))*(&30902639 / &41749730) pow 4 = (&75810542776419476045144980706456248)*(((-- &24879104) * &1 / &4 + (&8986624) * &1 / &16)) /\
  (&503266584955403242640771196303619375)*(&1977153)+(&90892339601155865220073637586066250)*(&3928715)+(&18029506647568188026693225850737659376315) = (&75810542776419476045144980706456248)*(&18073405)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &897024) * x + (-- &2035712) * y <= &1977153 ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &24879104) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&8986624) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &18073405
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &503266584955403242640771196303619375` [mpos] THEN
  note `&0:real < &90892339601155865220073637586066250` [npos] THEN
  note `&0:real < &18029506647568188026693225850737659376315` [ppos] THEN
  note `&0:real < &75810542776419476045144980706456248` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&503266584955403242640771196303619375)*(-- &897024)+(&90892339601155865220073637586066250)*(-- &1275904))*s pow 4 = (&75810542776419476045144980706456248)*((-- &24879104) * &0 + (&8986624) * -- &1 / &4) /\ ((&503266584955403242640771196303619375)*(-- &2035712)+(&90892339601155865220073637586066250)*(-- &4450304))*s pow 4 = (&75810542776419476045144980706456248)*((-- &24879104) * &1 / &4 + (&8986624) * &1 / &16) /\ (&503266584955403242640771196303619375)*(&1977153)+(&90892339601155865220073637586066250)*(&3928715)+(&18029506647568188026693225850737659376315) = (&75810542776419476045144980706456248)*(&18073405)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L76 =
let mpos = REAL_ARITH `!s:real. &0:real < &823349025229725594870409205110000` in
let npos = REAL_ARITH `!s:real. &0:real < &247992118761536353067517163716250` in
let ppos = REAL_ARITH `!s:real. &0:real < &182437369227090606646966088182037343327` in
let qpos = REAL_ARITH `!s:real. &0:real < &58591568926915384436921730048211127` in
let mqrel = REAL_ARITH `
  ((&823349025229725594870409205110000)*(-- &1275904)+(&247992118761536353067517163716250)*(-- &2211840))*(&30902639 / &41749730) pow 4 = (&58591568926915384436921730048211127)*(((-- &131072) * &0 + (&32768) * -- &1 / &4)) /\
  ((&823349025229725594870409205110000)*(-- &4450304)+(&247992118761536353067517163716250)*(-- &9404416))*(&30902639 / &41749730) pow 4 = (&58591568926915384436921730048211127)*(((-- &131072) * &1 / &4 + (&32768) * &1 / &16)) /\
  (&823349025229725594870409205110000)*(&3928715)+(&247992118761536353067517163716250)*(&8039969)+(&182437369227090606646966088182037343327) = (&58591568926915384436921730048211127)*(&92351)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1275904) * x + (-- &4450304) * y <= &3928715 ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &131072) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&32768) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &92351
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &823349025229725594870409205110000` [mpos] THEN
  note `&0:real < &247992118761536353067517163716250` [npos] THEN
  note `&0:real < &182437369227090606646966088182037343327` [ppos] THEN
  note `&0:real < &58591568926915384436921730048211127` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&823349025229725594870409205110000)*(-- &1275904)+(&247992118761536353067517163716250)*(-- &2211840))*s pow 4 = (&58591568926915384436921730048211127)*((-- &131072) * &0 + (&32768) * -- &1 / &4) /\ ((&823349025229725594870409205110000)*(-- &4450304)+(&247992118761536353067517163716250)*(-- &9404416))*s pow 4 = (&58591568926915384436921730048211127)*((-- &131072) * &1 / &4 + (&32768) * &1 / &16) /\ (&823349025229725594870409205110000)*(&3928715)+(&247992118761536353067517163716250)*(&8039969)+(&182437369227090606646966088182037343327) = (&58591568926915384436921730048211127)*(&92351)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L77 =
let mpos = REAL_ARITH `!s:real. &0:real < &8642955173432132900866246243175000` in
let npos = REAL_ARITH `!s:real. &0:real < &1392267044025768584432302784714375` in
let ppos = REAL_ARITH `!s:real. &0:real < &4885491972977278885506385298071359845164` in
let qpos = REAL_ARITH `!s:real. &0:real < &887350328667310054276850955482893` in
let mqrel = REAL_ARITH `
  ((&8642955173432132900866246243175000)*(-- &2211840)+(&1392267044025768584432302784714375)*(-- &7733248))*(&30902639 / &41749730) pow 4 = (&887350328667310054276850955482893)*(((-- &191823872) * &0 + (&40435712) * -- &1 / &4)) /\
  ((&8642955173432132900866246243175000)*(-- &9404416)+(&1392267044025768584432302784714375)*(-- &38076416))*(&30902639 / &41749730) pow 4 = (&887350328667310054276850955482893)*(((-- &191823872) * &1 / &4 + (&40435712) * &1 / &16)) /\
  (&8642955173432132900866246243175000)*(&8039969)+(&1392267044025768584432302784714375)*(&31944087)+(&4885491972977278885506385298071359845164) = (&887350328667310054276850955482893)*(&133937273)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &2211840) * x + (-- &9404416) * y <= &8039969 ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &191823872) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&40435712) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &133937273
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &8642955173432132900866246243175000` [mpos] THEN
  note `&0:real < &1392267044025768584432302784714375` [npos] THEN
  note `&0:real < &4885491972977278885506385298071359845164` [ppos] THEN
  note `&0:real < &887350328667310054276850955482893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&8642955173432132900866246243175000)*(-- &2211840)+(&1392267044025768584432302784714375)*(-- &7733248))*s pow 4 = (&887350328667310054276850955482893)*((-- &191823872) * &0 + (&40435712) * -- &1 / &4) /\ ((&8642955173432132900866246243175000)*(-- &9404416)+(&1392267044025768584432302784714375)*(-- &38076416))*s pow 4 = (&887350328667310054276850955482893)*((-- &191823872) * &1 / &4 + (&40435712) * &1 / &16) /\ (&8642955173432132900866246243175000)*(&8039969)+(&1392267044025768584432302784714375)*(&31944087)+(&4885491972977278885506385298071359845164) = (&887350328667310054276850955482893)*(&133937273)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L78 =
let mpos = REAL_ARITH `!s:real. &0:real < &7160060353860069881406485216116875` in
let npos = REAL_ARITH `!s:real. &0:real < &282741397271001247869474009780625` in
let ppos = REAL_ARITH `!s:real. &0:real < &11744814199458114325219693500395315238560` in
let qpos = REAL_ARITH `!s:real. &0:real < &37949046121792503575095911571998092` in
let mqrel = REAL_ARITH `
  ((&7160060353860069881406485216116875)*(-- &7733248)+(&282741397271001247869474009780625)*(-- &1966080))*(&30902639 / &41749730) pow 4 = (&37949046121792503575095911571998092)*(((-- &9568256) * &0 + (&1769472) * -- &1 / &4)) /\
  ((&7160060353860069881406485216116875)*(-- &38076416)+(&282741397271001247869474009780625)*(-- &55902208))*(&30902639 / &41749730) pow 4 = (&37949046121792503575095911571998092)*(((-- &9568256) * &1 / &4 + (&1769472) * &1 / &16)) /\
  (&7160060353860069881406485216116875)*(&31944087)+(&282741397271001247869474009780625)*(&42311631)+(&11744814199458114325219693500395315238560) = (&37949046121792503575095911571998092)*(&6651805)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &7733248) * x + (-- &38076416) * y <= &31944087 ==>
  (-- &1966080) * x + (-- &55902208) * y <= &42311631 ==>
  (-- &9568256) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&1769472) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &6651805
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &7160060353860069881406485216116875` [mpos] THEN
  note `&0:real < &282741397271001247869474009780625` [npos] THEN
  note `&0:real < &11744814199458114325219693500395315238560` [ppos] THEN
  note `&0:real < &37949046121792503575095911571998092` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&7160060353860069881406485216116875)*(-- &7733248)+(&282741397271001247869474009780625)*(-- &1966080))*s pow 4 = (&37949046121792503575095911571998092)*((-- &9568256) * &0 + (&1769472) * -- &1 / &4) /\ ((&7160060353860069881406485216116875)*(-- &38076416)+(&282741397271001247869474009780625)*(-- &55902208))*s pow 4 = (&37949046121792503575095911571998092)*((-- &9568256) * &1 / &4 + (&1769472) * &1 / &16) /\ (&7160060353860069881406485216116875)*(&31944087)+(&282741397271001247869474009780625)*(&42311631)+(&11744814199458114325219693500395315238560) = (&37949046121792503575095911571998092)*(&6651805)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L79 =
let mpos = REAL_ARITH `!s:real. &0:real < &17310647413980044835140939659926875` in
let npos = REAL_ARITH `!s:real. &0:real < &44433503667840357287748098246250` in
let ppos = REAL_ARITH `!s:real. &0:real < &63899680603422525290763037393770396514618` in
let qpos = REAL_ARITH `!s:real. &0:real < &204662383050906187513512909431248097` in
let mqrel = REAL_ARITH `
  ((&17310647413980044835140939659926875)*(-- &1966080)+(&44433503667840357287748098246250)*(&11730944))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((-- &5767168) * &0 + (&196608) * -- &1 / &4)) /\
  ((&17310647413980044835140939659926875)*(-- &55902208)+(&44433503667840357287748098246250)*(-- &156696576))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((-- &5767168) * &1 / &4 + (&196608) * &1 / &16)) /\
  (&17310647413980044835140939659926875)*(&42311631)+(&44433503667840357287748098246250)*(&110400449)+(&63899680603422525290763037393770396514618) = (&204662383050906187513512909431248097)*(&3914969)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1966080) * x + (-- &55902208) * y <= &42311631 ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (-- &5767168) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (&196608) * ((-- &1 / &4) * x + (&1 / &16) * y) / s pow 4 <= &3914969
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &17310647413980044835140939659926875` [mpos] THEN
  note `&0:real < &44433503667840357287748098246250` [npos] THEN
  note `&0:real < &63899680603422525290763037393770396514618` [ppos] THEN
  note `&0:real < &204662383050906187513512909431248097` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&17310647413980044835140939659926875)*(-- &1966080)+(&44433503667840357287748098246250)*(&11730944))*s pow 4 = (&204662383050906187513512909431248097)*((-- &5767168) * &0 + (&196608) * -- &1 / &4) /\ ((&17310647413980044835140939659926875)*(-- &55902208)+(&44433503667840357287748098246250)*(-- &156696576))*s pow 4 = (&204662383050906187513512909431248097)*((-- &5767168) * &1 / &4 + (&196608) * &1 / &16) /\ (&17310647413980044835140939659926875)*(&42311631)+(&44433503667840357287748098246250)*(&110400449)+(&63899680603422525290763037393770396514618) = (&204662383050906187513512909431248097)*(&3914969)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
prove(`
  !x:real y:real.
  divsteps_H1 x y ==>
  divsteps_H0 (((&0) * x + (&1 / &4) * y) / divsteps_s pow 4) (((-- &1 / &4) * x + (&1 / &16) * y) / divsteps_s pow 4)
  `,
  note `divsteps_s = &30902639 / &41749730` [divsteps_s] THEN
  note `&0 < divsteps_s` [divsteps_s] THEN
  REWRITE_TAC[divsteps_H1] THEN
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[divsteps_H0] THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L0 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L1 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L2 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L3 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L4 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L5 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L6 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L7 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L8 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L9 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L10 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L11 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L12 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L13 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L14 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L15 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L16 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L17 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L18 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L19 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L20 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L21 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L22 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L23 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L24 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L25 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L26 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L27 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L28 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L29 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L30 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L31 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L32 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L33 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L34 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L35 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L36 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L37 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L38 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L39 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L40 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L41 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L42 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L43 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L44 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L45 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L46 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L47 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L48 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L49 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L50 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L51 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L52 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L53 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L54 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L55 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L56 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L57 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L58 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L59 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L60 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L61 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L62 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L63 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L64 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L65 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L66 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L67 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L68 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L69 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L70 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L71 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L72 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L73 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L74 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L75 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L76 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L77 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L78 THEN
  specialize[`divsteps_s`;`x:real`;`y:real`]L79 THEN
  ASM_SIMP_TAC[]
  );;

(* skipping Gc for approx *)

let theorem_1 =
let L0 =
let mpos = REAL_ARITH `!s:real. &0:real < &15186194255707404162767752808734375` in
let npos = REAL_ARITH `!s:real. &0:real < &470106848579286602671531184984626250` in
let ppos = REAL_ARITH `!s:real. &0:real < &3925384152977471872498718920682455954540882` in
let qpos = REAL_ARITH `!s:real. &0:real < &204662383050906187513512909431248097` in
let mqrel = REAL_ARITH `
  ((&15186194255707404162767752808734375)*(-- &1966080)+(&470106848579286602671531184984626250)*(&11730944))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((-- &413007872) * &0 + (-- &32178176) * -- &1 / &4)) /\
  ((&15186194255707404162767752808734375)*(-- &55902208)+(&470106848579286602671531184984626250)*(-- &156696576))*(&30902639 / &41749730) pow 4 = (&204662383050906187513512909431248097)*(((-- &413007872) * &1 / &4 + (-- &32178176) * &3 / &16)) /\
  (&15186194255707404162767752808734375)*(&42311631)+(&470106848579286602671531184984626250)*(&110400449)+(&3925384152977471872498718920682455954540882) = (&204662383050906187513512909431248097)*(&275907781)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (-- &1966080) * x + (-- &55902208) * y <= &42311631 ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (-- &413007872) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &32178176) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &275907781
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &15186194255707404162767752808734375` [mpos] THEN
  note `&0:real < &470106848579286602671531184984626250` [npos] THEN
  note `&0:real < &3925384152977471872498718920682455954540882` [ppos] THEN
  note `&0:real < &204662383050906187513512909431248097` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&15186194255707404162767752808734375)*(-- &1966080)+(&470106848579286602671531184984626250)*(&11730944))*s pow 4 = (&204662383050906187513512909431248097)*((-- &413007872) * &0 + (-- &32178176) * -- &1 / &4) /\ ((&15186194255707404162767752808734375)*(-- &55902208)+(&470106848579286602671531184984626250)*(-- &156696576))*s pow 4 = (&204662383050906187513512909431248097)*((-- &413007872) * &1 / &4 + (-- &32178176) * &3 / &16) /\ (&15186194255707404162767752808734375)*(&42311631)+(&470106848579286602671531184984626250)*(&110400449)+(&3925384152977471872498718920682455954540882) = (&204662383050906187513512909431248097)*(&275907781)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L1 =
let mpos = REAL_ARITH `!s:real. &0:real < &1539184162524702427790720234036125` in
let npos = REAL_ARITH `!s:real. &0:real < &22590714834447720522688113673065875` in
let ppos = REAL_ARITH `!s:real. &0:real < &77863218754157772608940838858540631046846` in
let qpos = REAL_ARITH `!s:real. &0:real < &92789667564834664730166985936857586` in
let mqrel = REAL_ARITH `
  ((&1539184162524702427790720234036125)*(&11730944)+(&22590714834447720522688113673065875)*(&22740992))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((-- &32309248) * &0 + (-- &6881280) * -- &1 / &4)) /\
  ((&1539184162524702427790720234036125)*(-- &156696576)+(&22590714834447720522688113673065875)*(-- &117506048))*(&30902639 / &41749730) pow 4 = (&92789667564834664730166985936857586)*(((-- &32309248) * &1 / &4 + (-- &6881280) * &3 / &16)) /\
  (&1539184162524702427790720234036125)*(&110400449)+(&22590714834447720522688113673065875)*(&77682557)+(&77863218754157772608940838858540631046846) = (&92789667564834664730166985936857586)*(&21583161)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&11730944) * x + (-- &156696576) * y <= &110400449 ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (-- &32309248) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &6881280) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &21583161
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1539184162524702427790720234036125` [mpos] THEN
  note `&0:real < &22590714834447720522688113673065875` [npos] THEN
  note `&0:real < &77863218754157772608940838858540631046846` [ppos] THEN
  note `&0:real < &92789667564834664730166985936857586` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1539184162524702427790720234036125)*(&11730944)+(&22590714834447720522688113673065875)*(&22740992))*s pow 4 = (&92789667564834664730166985936857586)*((-- &32309248) * &0 + (-- &6881280) * -- &1 / &4) /\ ((&1539184162524702427790720234036125)*(-- &156696576)+(&22590714834447720522688113673065875)*(-- &117506048))*s pow 4 = (&92789667564834664730166985936857586)*((-- &32309248) * &1 / &4 + (-- &6881280) * &3 / &16) /\ (&1539184162524702427790720234036125)*(&110400449)+(&22590714834447720522688113673065875)*(&77682557)+(&77863218754157772608940838858540631046846) = (&92789667564834664730166985936857586)*(&21583161)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L2 =
let mpos = REAL_ARITH `!s:real. &0:real < &1110880506105534282282364982097291250` in
let npos = REAL_ARITH `!s:real. &0:real < &490366437497375881475384637318759375` in
let ppos = REAL_ARITH `!s:real. &0:real < &7750410269238573358707812807407916765926145` in
let qpos = REAL_ARITH `!s:real. &0:real < &3378749163691293941057556485658415916` in
let mqrel = REAL_ARITH `
  ((&1110880506105534282282364982097291250)*(&22740992)+(&490366437497375881475384637318759375)*(&166330368))*(&30902639 / &41749730) pow 4 = (&3378749163691293941057556485658415916)*(((-- &137199616) * &0 + (-- &37961728) * -- &1 / &4)) /\
  ((&1110880506105534282282364982097291250)*(-- &117506048)+(&490366437497375881475384637318759375)*(-- &684523520))*(&30902639 / &41749730) pow 4 = (&3378749163691293941057556485658415916)*(((-- &137199616) * &1 / &4 + (-- &37961728) * &3 / &16)) /\
  (&1110880506105534282282364982097291250)*(&77682557)+(&490366437497375881475384637318759375)*(&441063407)+(&7750410269238573358707812807407916765926145) = (&3378749163691293941057556485658415916)*(&91847345)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (-- &137199616) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &37961728) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &91847345
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1110880506105534282282364982097291250` [mpos] THEN
  note `&0:real < &490366437497375881475384637318759375` [npos] THEN
  note `&0:real < &7750410269238573358707812807407916765926145` [ppos] THEN
  note `&0:real < &3378749163691293941057556485658415916` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1110880506105534282282364982097291250)*(&22740992)+(&490366437497375881475384637318759375)*(&166330368))*s pow 4 = (&3378749163691293941057556485658415916)*((-- &137199616) * &0 + (-- &37961728) * -- &1 / &4) /\ ((&1110880506105534282282364982097291250)*(-- &117506048)+(&490366437497375881475384637318759375)*(-- &684523520))*s pow 4 = (&3378749163691293941057556485658415916)*((-- &137199616) * &1 / &4 + (-- &37961728) * &3 / &16) /\ (&1110880506105534282282364982097291250)*(&77682557)+(&490366437497375881475384637318759375)*(&441063407)+(&7750410269238573358707812807407916765926145) = (&3378749163691293941057556485658415916)*(&91847345)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L3 =
let mpos = REAL_ARITH `!s:real. &0:real < &4510190509053607548284584741645000` in
let npos = REAL_ARITH `!s:real. &0:real < &4055981360449017229343159737350000` in
let ppos = REAL_ARITH `!s:real. &0:real < &54060628719429082215176973658609339695065` in
let qpos = REAL_ARITH `!s:real. &0:real < &120669612988974783609198445916371997` in
let mqrel = REAL_ARITH `
  ((&4510190509053607548284584741645000)*(&22740992)+(&4055981360449017229343159737350000)*(&166330368))*(&30902639 / &41749730) pow 4 = (&120669612988974783609198445916371997)*(((-- &27099136) * &0 + (-- &7733248) * -- &1 / &4)) /\
  ((&4510190509053607548284584741645000)*(-- &117506048)+(&4055981360449017229343159737350000)*(-- &684523520))*(&30902639 / &41749730) pow 4 = (&120669612988974783609198445916371997)*(((-- &27099136) * &1 / &4 + (-- &7733248) * &3 / &16)) /\
  (&4510190509053607548284584741645000)*(&77682557)+(&4055981360449017229343159737350000)*(&441063407)+(&54060628719429082215176973658609339695065) = (&120669612988974783609198445916371997)*(&18176645)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&22740992) * x + (-- &117506048) * y <= &77682557 ==>
  (&166330368) * x + (-- &684523520) * y <= &441063407 ==>
  (-- &27099136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &7733248) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &18176645
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &4510190509053607548284584741645000` [mpos] THEN
  note `&0:real < &4055981360449017229343159737350000` [npos] THEN
  note `&0:real < &54060628719429082215176973658609339695065` [ppos] THEN
  note `&0:real < &120669612988974783609198445916371997` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&4510190509053607548284584741645000)*(&22740992)+(&4055981360449017229343159737350000)*(&166330368))*s pow 4 = (&120669612988974783609198445916371997)*((-- &27099136) * &0 + (-- &7733248) * -- &1 / &4) /\ ((&4510190509053607548284584741645000)*(-- &117506048)+(&4055981360449017229343159737350000)*(-- &684523520))*s pow 4 = (&120669612988974783609198445916371997)*((-- &27099136) * &1 / &4 + (-- &7733248) * &3 / &16) /\ (&4510190509053607548284584741645000)*(&77682557)+(&4055981360449017229343159737350000)*(&441063407)+(&54060628719429082215176973658609339695065) = (&120669612988974783609198445916371997)*(&18176645)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L4 =
let mpos = REAL_ARITH `!s:real. &0:real < &51376713332859941322904120521353125` in
let npos = REAL_ARITH `!s:real. &0:real < &41670081535882747374890841520704375` in
let ppos = REAL_ARITH `!s:real. &0:real < &157849932418245252604677998972068827393131` in
let qpos = REAL_ARITH `!s:real. &0:real < &199907352615478279370656279542360323` in
let mqrel = REAL_ARITH `
  ((&51376713332859941322904120521353125)*(&33882112)+(&41670081535882747374890841520704375)*(&50659328))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((-- &68321280) * &0 + (-- &23134208) * -- &1 / &4)) /\
  ((&51376713332859941322904120521353125)*(-- &135659520)+(&41670081535882747374890841520704375)*(-- &175046656))*(&30902639 / &41749730) pow 4 = (&199907352615478279370656279542360323)*(((-- &68321280) * &1 / &4 + (-- &23134208) * &3 / &16)) /\
  (&51376713332859941322904120521353125)*(&87245513)+(&41670081535882747374890841520704375)*(&111549985)+(&157849932418245252604677998972068827393131) = (&199907352615478279370656279542360323)*(&46464197)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&33882112) * x + (-- &135659520) * y <= &87245513 ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (-- &68321280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &23134208) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &46464197
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &51376713332859941322904120521353125` [mpos] THEN
  note `&0:real < &41670081535882747374890841520704375` [npos] THEN
  note `&0:real < &157849932418245252604677998972068827393131` [ppos] THEN
  note `&0:real < &199907352615478279370656279542360323` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&51376713332859941322904120521353125)*(&33882112)+(&41670081535882747374890841520704375)*(&50659328))*s pow 4 = (&199907352615478279370656279542360323)*((-- &68321280) * &0 + (-- &23134208) * -- &1 / &4) /\ ((&51376713332859941322904120521353125)*(-- &135659520)+(&41670081535882747374890841520704375)*(-- &175046656))*s pow 4 = (&199907352615478279370656279542360323)*((-- &68321280) * &1 / &4 + (-- &23134208) * &3 / &16) /\ (&51376713332859941322904120521353125)*(&87245513)+(&41670081535882747374890841520704375)*(&111549985)+(&157849932418245252604677998972068827393131) = (&199907352615478279370656279542360323)*(&46464197)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L5 =
let mpos = REAL_ARITH `!s:real. &0:real < &5019846593859092672046618483922500` in
let npos = REAL_ARITH `!s:real. &0:real < &2302377059711813385102332013828125` in
let ppos = REAL_ARITH `!s:real. &0:real < &7377820374966062300416899734874702018878` in
let qpos = REAL_ARITH `!s:real. &0:real < &33486759217199340064739661083634479` in
let mqrel = REAL_ARITH `
  ((&5019846593859092672046618483922500)*(&50659328)+(&2302377059711813385102332013828125)*(&11010048))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((-- &26869760) * &0 + (-- &10027008) * -- &1 / &4)) /\
  ((&5019846593859092672046618483922500)*(-- &175046656)+(&2302377059711813385102332013828125)*(-- &34930688))*(&30902639 / &41749730) pow 4 = (&33486759217199340064739661083634479)*(((-- &26869760) * &1 / &4 + (-- &10027008) * &3 / &16)) /\
  (&5019846593859092672046618483922500)*(&111549985)+(&2302377059711813385102332013828125)*(&22163375)+(&7377820374966062300416899734874702018878) = (&33486759217199340064739661083634479)*(&18466107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &26869760) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &10027008) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &18466107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5019846593859092672046618483922500` [mpos] THEN
  note `&0:real < &2302377059711813385102332013828125` [npos] THEN
  note `&0:real < &7377820374966062300416899734874702018878` [ppos] THEN
  note `&0:real < &33486759217199340064739661083634479` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&5019846593859092672046618483922500)*(&50659328)+(&2302377059711813385102332013828125)*(&11010048))*s pow 4 = (&33486759217199340064739661083634479)*((-- &26869760) * &0 + (-- &10027008) * -- &1 / &4) /\ ((&5019846593859092672046618483922500)*(-- &175046656)+(&2302377059711813385102332013828125)*(-- &34930688))*s pow 4 = (&33486759217199340064739661083634479)*((-- &26869760) * &1 / &4 + (-- &10027008) * &3 / &16) /\ (&5019846593859092672046618483922500)*(&111549985)+(&2302377059711813385102332013828125)*(&22163375)+(&7377820374966062300416899734874702018878) = (&33486759217199340064739661083634479)*(&18466107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L6 =
let mpos = REAL_ARITH `!s:real. &0:real < &31368534495352801976524935204647500` in
let npos = REAL_ARITH `!s:real. &0:real < &58034523185859166140096530011566875` in
let ppos = REAL_ARITH `!s:real. &0:real < &51211795701045495053471695329207000838363` in
let qpos = REAL_ARITH `!s:real. &0:real < &133947036868797360258958644334537916` in
let mqrel = REAL_ARITH `
  ((&31368534495352801976524935204647500)*(&50659328)+(&58034523185859166140096530011566875)*(&11010048))*(&30902639 / &41749730) pow 4 = (&133947036868797360258958644334537916)*(((-- &52412416) * &0 + (-- &19972096) * -- &1 / &4)) /\
  ((&31368534495352801976524935204647500)*(-- &175046656)+(&58034523185859166140096530011566875)*(-- &34930688))*(&30902639 / &41749730) pow 4 = (&133947036868797360258958644334537916)*(((-- &52412416) * &1 / &4 + (-- &19972096) * &3 / &16)) /\
  (&31368534495352801976524935204647500)*(&111549985)+(&58034523185859166140096530011566875)*(&22163375)+(&51211795701045495053471695329207000838363) = (&133947036868797360258958644334537916)*(&36108393)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &52412416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &19972096) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &36108393
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &31368534495352801976524935204647500` [mpos] THEN
  note `&0:real < &58034523185859166140096530011566875` [npos] THEN
  note `&0:real < &51211795701045495053471695329207000838363` [ppos] THEN
  note `&0:real < &133947036868797360258958644334537916` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&31368534495352801976524935204647500)*(&50659328)+(&58034523185859166140096530011566875)*(&11010048))*s pow 4 = (&133947036868797360258958644334537916)*((-- &52412416) * &0 + (-- &19972096) * -- &1 / &4) /\ ((&31368534495352801976524935204647500)*(-- &175046656)+(&58034523185859166140096530011566875)*(-- &34930688))*s pow 4 = (&133947036868797360258958644334537916)*((-- &52412416) * &1 / &4 + (-- &19972096) * &3 / &16) /\ (&31368534495352801976524935204647500)*(&111549985)+(&58034523185859166140096530011566875)*(&22163375)+(&51211795701045495053471695329207000838363) = (&133947036868797360258958644334537916)*(&36108393)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L7 =
let mpos = REAL_ARITH `!s:real. &0:real < &2479921187615363530675171637162500` in
let npos = REAL_ARITH `!s:real. &0:real < &20629488341785659214095047613550625` in
let ppos = REAL_ARITH `!s:real. &0:real < &9903408136806220107343980598183694907625` in
let qpos = REAL_ARITH `!s:real. &0:real < &133947036868797360258958644334537916` in
let mqrel = REAL_ARITH `
  ((&2479921187615363530675171637162500)*(&50659328)+(&20629488341785659214095047613550625)*(&11010048))*(&30902639 / &41749730) pow 4 = (&133947036868797360258958644334537916)*(((-- &7979008) * &0 + (-- &3162112) * -- &1 / &4)) /\
  ((&2479921187615363530675171637162500)*(-- &175046656)+(&20629488341785659214095047613550625)*(-- &34930688))*(&30902639 / &41749730) pow 4 = (&133947036868797360258958644334537916)*(((-- &7979008) * &1 / &4 + (-- &3162112) * &3 / &16)) /\
  (&2479921187615363530675171637162500)*(&111549985)+(&20629488341785659214095047613550625)*(&22163375)+(&9903408136806220107343980598183694907625) = (&133947036868797360258958644334537916)*(&5552625)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&50659328) * x + (-- &175046656) * y <= &111549985 ==>
  (&11010048) * x + (-- &34930688) * y <= &22163375 ==>
  (-- &7979008) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &3162112) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &5552625
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &2479921187615363530675171637162500` [mpos] THEN
  note `&0:real < &20629488341785659214095047613550625` [npos] THEN
  note `&0:real < &9903408136806220107343980598183694907625` [ppos] THEN
  note `&0:real < &133947036868797360258958644334537916` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&2479921187615363530675171637162500)*(&50659328)+(&20629488341785659214095047613550625)*(&11010048))*s pow 4 = (&133947036868797360258958644334537916)*((-- &7979008) * &0 + (-- &3162112) * -- &1 / &4) /\ ((&2479921187615363530675171637162500)*(-- &175046656)+(&20629488341785659214095047613550625)*(-- &34930688))*s pow 4 = (&133947036868797360258958644334537916)*((-- &7979008) * &1 / &4 + (-- &3162112) * &3 / &16) /\ (&2479921187615363530675171637162500)*(&111549985)+(&20629488341785659214095047613550625)*(&22163375)+(&9903408136806220107343980598183694907625) = (&133947036868797360258958644334537916)*(&5552625)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L8 =
let mpos = REAL_ARITH `!s:real. &0:real < &5430571672634899051591059238224375` in
let npos = REAL_ARITH `!s:real. &0:real < &873887768256234341762925153163145000` in
let ppos = REAL_ARITH `!s:real. &0:real < &121828216383416243527928996422137873794233` in
let qpos = REAL_ARITH `!s:real. &0:real < &86303711205654902031280075355773994` in
let mqrel = REAL_ARITH `
  ((&5430571672634899051591059238224375)*(&145883136)+(&873887768256234341762925153163145000)*(&3457024))*(&30902639 / &41749730) pow 4 = (&86303711205654902031280075355773994)*(((-- &121733120) * &0 + (-- &53051392) * -- &1 / &4)) /\
  ((&5430571672634899051591059238224375)*(-- &455802880)+(&873887768256234341762925153163145000)*(-- &10452992))*(&30902639 / &41749730) pow 4 = (&86303711205654902031280075355773994)*(((-- &121733120) * &1 / &4 + (-- &53051392) * &3 / &16)) /\
  (&5430571672634899051591059238224375)*(&288985723)+(&873887768256234341762925153163145000)*(&6651805)+(&121828216383416243527928996422137873794233) = (&86303711205654902031280075355773994)*(&86950107)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&145883136) * x + (-- &455802880) * y <= &288985723 ==>
  (&3457024) * x + (-- &10452992) * y <= &6651805 ==>
  (-- &121733120) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &53051392) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &86950107
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5430571672634899051591059238224375` [mpos] THEN
  note `&0:real < &873887768256234341762925153163145000` [npos] THEN
  note `&0:real < &121828216383416243527928996422137873794233` [ppos] THEN
  note `&0:real < &86303711205654902031280075355773994` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&5430571672634899051591059238224375)*(&145883136)+(&873887768256234341762925153163145000)*(&3457024))*s pow 4 = (&86303711205654902031280075355773994)*((-- &121733120) * &0 + (-- &53051392) * -- &1 / &4) /\ ((&5430571672634899051591059238224375)*(-- &455802880)+(&873887768256234341762925153163145000)*(-- &10452992))*s pow 4 = (&86303711205654902031280075355773994)*((-- &121733120) * &1 / &4 + (-- &53051392) * &3 / &16) /\ (&5430571672634899051591059238224375)*(&288985723)+(&873887768256234341762925153163145000)*(&6651805)+(&121828216383416243527928996422137873794233) = (&86303711205654902031280075355773994)*(&86950107)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L9 =
let mpos = REAL_ARITH `!s:real. &0:real < &1702410638248513980287262872943724375` in
let npos = REAL_ARITH `!s:real. &0:real < &221665647611876563941682721044648125` in
let ppos = REAL_ARITH `!s:real. &0:real < &2886216313950181561977753833900457794928497` in
let qpos = REAL_ARITH `!s:real. &0:real < &2958888366400279682107549722203223049` in
let mqrel = REAL_ARITH `
  ((&1702410638248513980287262872943724375)*(&58130432)+(&221665647611876563941682721044648125)*(&290521088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((-- &124731392) * &0 + (-- &66289664) * -- &1 / &4)) /\
  ((&1702410638248513980287262872943724375)*(-- &162430976)+(&221665647611876563941682721044648125)*(-- &691929088))*(&30902639 / &41749730) pow 4 = (&2958888366400279682107549722203223049)*(((-- &124731392) * &1 / &4 + (-- &66289664) * &3 / &16)) /\
  (&1702410638248513980287262872943724375)*(&104374325)+(&221665647611876563941682721044648125)*(&457690221)+(&2886216313950181561977753833900457794928497) = (&2958888366400279682107549722203223049)*(&95315653)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&58130432) * x + (-- &162430976) * y <= &104374325 ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (-- &124731392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &66289664) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &95315653
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1702410638248513980287262872943724375` [mpos] THEN
  note `&0:real < &221665647611876563941682721044648125` [npos] THEN
  note `&0:real < &2886216313950181561977753833900457794928497` [ppos] THEN
  note `&0:real < &2958888366400279682107549722203223049` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1702410638248513980287262872943724375)*(&58130432)+(&221665647611876563941682721044648125)*(&290521088))*s pow 4 = (&2958888366400279682107549722203223049)*((-- &124731392) * &0 + (-- &66289664) * -- &1 / &4) /\ ((&1702410638248513980287262872943724375)*(-- &162430976)+(&221665647611876563941682721044648125)*(-- &691929088))*s pow 4 = (&2958888366400279682107549722203223049)*((-- &124731392) * &1 / &4 + (-- &66289664) * &3 / &16) /\ (&1702410638248513980287262872943724375)*(&104374325)+(&221665647611876563941682721044648125)*(&457690221)+(&2886216313950181561977753833900457794928497) = (&2958888366400279682107549722203223049)*(&95315653)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L10 =
let mpos = REAL_ARITH `!s:real. &0:real < &107888078799397677369206024057396625` in
let npos = REAL_ARITH `!s:real. &0:real < &513829644052562887782969096982517000` in
let ppos = REAL_ARITH `!s:real. &0:real < &804863838198444349991510456584638636480286` in
let qpos = REAL_ARITH `!s:real. &0:real < &441396142266502295560174860539235041` in
let mqrel = REAL_ARITH `
  ((&107888078799397677369206024057396625)*(&290521088)+(&513829644052562887782969096982517000)*(&14442496))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &165806080) * &0 + (-- &105447424) * -- &1 / &4)) /\
  ((&107888078799397677369206024057396625)*(-- &691929088)+(&513829644052562887782969096982517000)*(-- &29925376))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &165806080) * &1 / &4 + (-- &105447424) * &3 / &16)) /\
  (&107888078799397677369206024057396625)*(&457690221)+(&513829644052562887782969096982517000)*(&20669487)+(&804863838198444349991510456584638636480286) = (&441396142266502295560174860539235041)*(&137755571)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &165806080) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &105447424) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &137755571
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &107888078799397677369206024057396625` [mpos] THEN
  note `&0:real < &513829644052562887782969096982517000` [npos] THEN
  note `&0:real < &804863838198444349991510456584638636480286` [ppos] THEN
  note `&0:real < &441396142266502295560174860539235041` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&107888078799397677369206024057396625)*(&290521088)+(&513829644052562887782969096982517000)*(&14442496))*s pow 4 = (&441396142266502295560174860539235041)*((-- &165806080) * &0 + (-- &105447424) * -- &1 / &4) /\ ((&107888078799397677369206024057396625)*(-- &691929088)+(&513829644052562887782969096982517000)*(-- &29925376))*s pow 4 = (&441396142266502295560174860539235041)*((-- &165806080) * &1 / &4 + (-- &105447424) * &3 / &16) /\ (&107888078799397677369206024057396625)*(&457690221)+(&513829644052562887782969096982517000)*(&20669487)+(&804863838198444349991510456584638636480286) = (&441396142266502295560174860539235041)*(&137755571)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L11 =
let mpos = REAL_ARITH `!s:real. &0:real < &9373418496821953525070798817732000` in
let npos = REAL_ARITH `!s:real. &0:real < &205133611900629906290399398060144000` in
let ppos = REAL_ARITH `!s:real. &0:real < &109240057686025413670976859837862587990743` in
let qpos = REAL_ARITH `!s:real. &0:real < &441396142266502295560174860539235041` in
let mqrel = REAL_ARITH `
  ((&9373418496821953525070798817732000)*(&290521088)+(&205133611900629906290399398060144000)*(&14442496))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &22740992) * &0 + (-- &15466496) * -- &1 / &4)) /\
  ((&9373418496821953525070798817732000)*(-- &691929088)+(&205133611900629906290399398060144000)*(-- &29925376))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &22740992) * &1 / &4 + (-- &15466496) * &3 / &16)) /\
  (&9373418496821953525070798817732000)*(&457690221)+(&205133611900629906290399398060144000)*(&20669487)+(&109240057686025413670976859837862587990743) = (&441396142266502295560174860539235041)*(&19572823)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &22740992) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &15466496) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &19572823
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &9373418496821953525070798817732000` [mpos] THEN
  note `&0:real < &205133611900629906290399398060144000` [npos] THEN
  note `&0:real < &109240057686025413670976859837862587990743` [ppos] THEN
  note `&0:real < &441396142266502295560174860539235041` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&9373418496821953525070798817732000)*(&290521088)+(&205133611900629906290399398060144000)*(&14442496))*s pow 4 = (&441396142266502295560174860539235041)*((-- &22740992) * &0 + (-- &15466496) * -- &1 / &4) /\ ((&9373418496821953525070798817732000)*(-- &691929088)+(&205133611900629906290399398060144000)*(-- &29925376))*s pow 4 = (&441396142266502295560174860539235041)*((-- &22740992) * &1 / &4 + (-- &15466496) * &3 / &16) /\ (&9373418496821953525070798817732000)*(&457690221)+(&205133611900629906290399398060144000)*(&20669487)+(&109240057686025413670976859837862587990743) = (&441396142266502295560174860539235041)*(&19572823)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L12 =
let mpos = REAL_ARITH `!s:real. &0:real < &921444529481034691344130006622875` in
let npos = REAL_ARITH `!s:real. &0:real < &46522865751421472754878653266007000` in
let ppos = REAL_ARITH `!s:real. &0:real < &19391861353667958841608616783443873086288` in
let qpos = REAL_ARITH `!s:real. &0:real < &441396142266502295560174860539235041` in
let mqrel = REAL_ARITH `
  ((&921444529481034691344130006622875)*(&290521088)+(&46522865751421472754878653266007000)*(&14442496))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &3604480) * &0 + (-- &2555904) * -- &1 / &4)) /\
  ((&921444529481034691344130006622875)*(-- &691929088)+(&46522865751421472754878653266007000)*(-- &29925376))*(&30902639 / &41749730) pow 4 = (&441396142266502295560174860539235041)*(((-- &3604480) * &1 / &4 + (-- &2555904) * &3 / &16)) /\
  (&921444529481034691344130006622875)*(&457690221)+(&46522865751421472754878653266007000)*(&20669487)+(&19391861353667958841608616783443873086288) = (&441396142266502295560174860539235041)*(&3177943)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&290521088) * x + (-- &691929088) * y <= &457690221 ==>
  (&14442496) * x + (-- &29925376) * y <= &20669487 ==>
  (-- &3604480) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &2555904) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &3177943
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &921444529481034691344130006622875` [mpos] THEN
  note `&0:real < &46522865751421472754878653266007000` [npos] THEN
  note `&0:real < &19391861353667958841608616783443873086288` [ppos] THEN
  note `&0:real < &441396142266502295560174860539235041` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&921444529481034691344130006622875)*(&290521088)+(&46522865751421472754878653266007000)*(&14442496))*s pow 4 = (&441396142266502295560174860539235041)*((-- &3604480) * &0 + (-- &2555904) * -- &1 / &4) /\ ((&921444529481034691344130006622875)*(-- &691929088)+(&46522865751421472754878653266007000)*(-- &29925376))*s pow 4 = (&441396142266502295560174860539235041)*((-- &3604480) * &1 / &4 + (-- &2555904) * &3 / &16) /\ (&921444529481034691344130006622875)*(&457690221)+(&46522865751421472754878653266007000)*(&20669487)+(&19391861353667958841608616783443873086288) = (&441396142266502295560174860539235041)*(&3177943)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L13 =
let mpos = REAL_ARITH `!s:real. &0:real < &1869487016402398995162604329398750` in
let npos = REAL_ARITH `!s:real. &0:real < &1831060839570770154710962034645000` in
let ppos = REAL_ARITH `!s:real. &0:real < &730061531602587569396106509993762952713` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&1869487016402398995162604329398750)*(&15433728)+(&1831060839570770154710962034645000)*(&5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &5537792) * &0 + (-- &5177344) * -- &1 / &4)) /\
  ((&1869487016402398995162604329398750)*(-- &29458432)+(&1831060839570770154710962034645000)*(-- &8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &5537792) * &1 / &4 + (-- &5177344) * &3 / &16)) /\
  (&1869487016402398995162604329398750)*(&21015329)+(&1831060839570770154710962034645000)*(&6951751)+(&730061531602587569396106509993762952713) = (&9095112875435851152418329474851893)*(&5799491)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &5537792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &5177344) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &5799491
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &1869487016402398995162604329398750` [mpos] THEN
  note `&0:real < &1831060839570770154710962034645000` [npos] THEN
  note `&0:real < &730061531602587569396106509993762952713` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&1869487016402398995162604329398750)*(&15433728)+(&1831060839570770154710962034645000)*(&5660672))*s pow 4 = (&9095112875435851152418329474851893)*((-- &5537792) * &0 + (-- &5177344) * -- &1 / &4) /\ ((&1869487016402398995162604329398750)*(-- &29458432)+(&1831060839570770154710962034645000)*(-- &8896512))*s pow 4 = (&9095112875435851152418329474851893)*((-- &5537792) * &1 / &4 + (-- &5177344) * &3 / &16) /\ (&1869487016402398995162604329398750)*(&21015329)+(&1831060839570770154710962034645000)*(&6951751)+(&730061531602587569396106509993762952713) = (&9095112875435851152418329474851893)*(&5799491)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L14 =
let mpos = REAL_ARITH `!s:real. &0:real < &14085420662705393260216147144061250` in
let npos = REAL_ARITH `!s:real. &0:real < &417190343446244962813386255366355000` in
let ppos = REAL_ARITH `!s:real. &0:real < &33042042554317034898811672618662056451841` in
let qpos = REAL_ARITH `!s:real. &0:real < &9095112875435851152418329474851893` in
let mqrel = REAL_ARITH `
  ((&14085420662705393260216147144061250)*(&15433728)+(&417190343446244962813386255366355000)*(&5660672))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &289406976) * &0 + (-- &340459520) * -- &1 / &4)) /\
  ((&14085420662705393260216147144061250)*(-- &29458432)+(&417190343446244962813386255366355000)*(-- &8896512))*(&30902639 / &41749730) pow 4 = (&9095112875435851152418329474851893)*(((-- &289406976) * &1 / &4 + (-- &340459520) * &3 / &16)) /\
  (&14085420662705393260216147144061250)*(&21015329)+(&417190343446244962813386255366355000)*(&6951751)+(&33042042554317034898811672618662056451841) = (&9095112875435851152418329474851893)*(&355053887)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&15433728) * x + (-- &29458432) * y <= &21015329 ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (-- &289406976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &340459520) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &355053887
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &14085420662705393260216147144061250` [mpos] THEN
  note `&0:real < &417190343446244962813386255366355000` [npos] THEN
  note `&0:real < &33042042554317034898811672618662056451841` [ppos] THEN
  note `&0:real < &9095112875435851152418329474851893` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&14085420662705393260216147144061250)*(&15433728)+(&417190343446244962813386255366355000)*(&5660672))*s pow 4 = (&9095112875435851152418329474851893)*((-- &289406976) * &0 + (-- &340459520) * -- &1 / &4) /\ ((&14085420662705393260216147144061250)*(-- &29458432)+(&417190343446244962813386255366355000)*(-- &8896512))*s pow 4 = (&9095112875435851152418329474851893)*((-- &289406976) * &1 / &4 + (-- &340459520) * &3 / &16) /\ (&14085420662705393260216147144061250)*(&21015329)+(&417190343446244962813386255366355000)*(&6951751)+(&33042042554317034898811672618662056451841) = (&9095112875435851152418329474851893)*(&355053887)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L15 =
let mpos = REAL_ARITH `!s:real. &0:real < &146354086969939950159778291601315000` in
let npos = REAL_ARITH `!s:real. &0:real < &422877831915728528546218011941875` in
let ppos = REAL_ARITH `!s:real. &0:real < &16598371378190054467858169510048576388829` in
let qpos = REAL_ARITH `!s:real. &0:real < &454560481417902727865916220808911876` in
let mqrel = REAL_ARITH `
  ((&146354086969939950159778291601315000)*(&5660672)+(&422877831915728528546218011941875)*(&373096448))*(&30902639 / &41749730) pow 4 = (&454560481417902727865916220808911876)*(((-- &2048000) * &0 + (-- &2605056) * -- &1 / &4)) /\
  ((&146354086969939950159778291601315000)*(-- &8896512)+(&422877831915728528546218011941875)*(-- &503644160))*(&30902639 / &41749730) pow 4 = (&454560481417902727865916220808911876)*(((-- &2048000) * &1 / &4 + (-- &2605056) * &3 / &16)) /\
  (&146354086969939950159778291601315000)*(&6951751)+(&422877831915728528546218011941875)*(&426281637)+(&16598371378190054467858169510048576388829) = (&454560481417902727865916220808911876)*(&2671329)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &2048000) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &2605056) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &2671329
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &146354086969939950159778291601315000` [mpos] THEN
  note `&0:real < &422877831915728528546218011941875` [npos] THEN
  note `&0:real < &16598371378190054467858169510048576388829` [ppos] THEN
  note `&0:real < &454560481417902727865916220808911876` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&146354086969939950159778291601315000)*(&5660672)+(&422877831915728528546218011941875)*(&373096448))*s pow 4 = (&454560481417902727865916220808911876)*((-- &2048000) * &0 + (-- &2605056) * -- &1 / &4) /\ ((&146354086969939950159778291601315000)*(-- &8896512)+(&422877831915728528546218011941875)*(-- &503644160))*s pow 4 = (&454560481417902727865916220808911876)*((-- &2048000) * &1 / &4 + (-- &2605056) * &3 / &16) /\ (&146354086969939950159778291601315000)*(&6951751)+(&422877831915728528546218011941875)*(&426281637)+(&16598371378190054467858169510048576388829) = (&454560481417902727865916220808911876)*(&2671329)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L16 =
let mpos = REAL_ARITH `!s:real. &0:real < &316963550113022019458478767294865000` in
let npos = REAL_ARITH `!s:real. &0:real < &70718579502117286593545237134015625` in
let ppos = REAL_ARITH `!s:real. &0:real < &770718534669486415901792339021616960518442` in
let qpos = REAL_ARITH `!s:real. &0:real < &795480842481329773765353386415595783` in
let mqrel = REAL_ARITH `
  ((&316963550113022019458478767294865000)*(&5660672)+(&70718579502117286593545237134015625)*(&373096448))*(&30902639 / &41749730) pow 4 = (&795480842481329773765353386415595783)*(((-- &26116096) * &0 + (-- &42532864) * -- &1 / &4)) /\
  ((&316963550113022019458478767294865000)*(-- &8896512)+(&70718579502117286593545237134015625)*(-- &503644160))*(&30902639 / &41749730) pow 4 = (&795480842481329773765353386415595783)*(((-- &26116096) * &1 / &4 + (-- &42532864) * &3 / &16)) /\
  (&316963550113022019458478767294865000)*(&6951751)+(&70718579502117286593545237134015625)*(&426281637)+(&770718534669486415901792339021616960518442) = (&795480842481329773765353386415595783)*(&41635449)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5660672) * x + (-- &8896512) * y <= &6951751 ==>
  (&373096448) * x + (-- &503644160) * y <= &426281637 ==>
  (-- &26116096) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &42532864) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &41635449
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &316963550113022019458478767294865000` [mpos] THEN
  note `&0:real < &70718579502117286593545237134015625` [npos] THEN
  note `&0:real < &770718534669486415901792339021616960518442` [ppos] THEN
  note `&0:real < &795480842481329773765353386415595783` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&316963550113022019458478767294865000)*(&5660672)+(&70718579502117286593545237134015625)*(&373096448))*s pow 4 = (&795480842481329773765353386415595783)*((-- &26116096) * &0 + (-- &42532864) * -- &1 / &4) /\ ((&316963550113022019458478767294865000)*(-- &8896512)+(&70718579502117286593545237134015625)*(-- &503644160))*s pow 4 = (&795480842481329773765353386415595783)*((-- &26116096) * &1 / &4 + (-- &42532864) * &3 / &16) /\ (&316963550113022019458478767294865000)*(&6951751)+(&70718579502117286593545237134015625)*(&426281637)+(&770718534669486415901792339021616960518442) = (&795480842481329773765353386415595783)*(&41635449)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L17 =
let mpos = REAL_ARITH `!s:real. &0:real < &172253502778792162518347155328661250` in
let npos = REAL_ARITH `!s:real. &0:real < &33350572577766979965283544817871250` in
let ppos = REAL_ARITH `!s:real. &0:real < &70840340327546950604858664817672477063155` in
let qpos = REAL_ARITH `!s:real. &0:real < &19646647616114964541917985749196263` in
let mqrel = REAL_ARITH `
  ((&172253502778792162518347155328661250)*(&5701632)+(&33350572577766979965283544817871250)*(&46596096))*(&30902639 / &41749730) pow 4 = (&19646647616114964541917985749196263)*(((-- &66748416) * &0 + (-- &154992640) * -- &1 / &4)) /\
  ((&172253502778792162518347155328661250)*(-- &7340032)+(&33350572577766979965283544817871250)*(-- &51871744))*(&30902639 / &41749730) pow 4 = (&19646647616114964541917985749196263)*(((-- &66748416) * &1 / &4 + (-- &154992640) * &3 / &16)) /\
  (&172253502778792162518347155328661250)*(&6407825)+(&33350572577766979965283544817871250)*(&49963991)+(&70840340327546950604858664817672477063155) = (&19646647616114964541917985749196263)*(&144601685)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5701632) * x + (-- &7340032) * y <= &6407825 ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (-- &66748416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &154992640) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &144601685
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &172253502778792162518347155328661250` [mpos] THEN
  note `&0:real < &33350572577766979965283544817871250` [npos] THEN
  note `&0:real < &70840340327546950604858664817672477063155` [ppos] THEN
  note `&0:real < &19646647616114964541917985749196263` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&172253502778792162518347155328661250)*(&5701632)+(&33350572577766979965283544817871250)*(&46596096))*s pow 4 = (&19646647616114964541917985749196263)*((-- &66748416) * &0 + (-- &154992640) * -- &1 / &4) /\ ((&172253502778792162518347155328661250)*(-- &7340032)+(&33350572577766979965283544817871250)*(-- &51871744))*s pow 4 = (&19646647616114964541917985749196263)*((-- &66748416) * &1 / &4 + (-- &154992640) * &3 / &16) /\ (&172253502778792162518347155328661250)*(&6407825)+(&33350572577766979965283544817871250)*(&49963991)+(&70840340327546950604858664817672477063155) = (&19646647616114964541917985749196263)*(&144601685)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L18 =
let mpos = REAL_ARITH `!s:real. &0:real < &43710224969247178138564198647019375` in
let npos = REAL_ARITH `!s:real. &0:real < &81354707027530713656616323574473750` in
let ppos = REAL_ARITH `!s:real. &0:real < &375273936165258614569827406628228259857430` in
let qpos = REAL_ARITH `!s:real. &0:real < &612562646364046066852172396132938249` in
let mqrel = REAL_ARITH `
  ((&43710224969247178138564198647019375)*(&46596096)+(&81354707027530713656616323574473750)*(&84901888))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((-- &3899392) * &0 + (-- &17530880) * -- &1 / &4)) /\
  ((&43710224969247178138564198647019375)*(-- &51871744)+(&81354707027530713656616323574473750)*(-- &79036416))*(&30902639 / &41749730) pow 4 = (&612562646364046066852172396132938249)*(((-- &3899392) * &1 / &4 + (-- &17530880) * &3 / &16)) /\
  (&43710224969247178138564198647019375)*(&49963991)+(&81354707027530713656616323574473750)*(&86789633)+(&375273936165258614569827406628228259857430) = (&612562646364046066852172396132938249)*(&15704445)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&46596096) * x + (-- &51871744) * y <= &49963991 ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (-- &3899392) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &17530880) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &15704445
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &43710224969247178138564198647019375` [mpos] THEN
  note `&0:real < &81354707027530713656616323574473750` [npos] THEN
  note `&0:real < &375273936165258614569827406628228259857430` [ppos] THEN
  note `&0:real < &612562646364046066852172396132938249` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&43710224969247178138564198647019375)*(&46596096)+(&81354707027530713656616323574473750)*(&84901888))*s pow 4 = (&612562646364046066852172396132938249)*((-- &3899392) * &0 + (-- &17530880) * -- &1 / &4) /\ ((&43710224969247178138564198647019375)*(-- &51871744)+(&81354707027530713656616323574473750)*(-- &79036416))*s pow 4 = (&612562646364046066852172396132938249)*((-- &3899392) * &1 / &4 + (-- &17530880) * &3 / &16) /\ (&43710224969247178138564198647019375)*(&49963991)+(&81354707027530713656616323574473750)*(&86789633)+(&375273936165258614569827406628228259857430) = (&612562646364046066852172396132938249)*(&15704445)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L19 =
let mpos = REAL_ARITH `!s:real. &0:real < &61685286183798904213661679314483125` in
let npos = REAL_ARITH `!s:real. &0:real < &247886351831865468114486071020851875` in
let ppos = REAL_ARITH `!s:real. &0:real < &2171170501919814936467784032220602938192974` in
let qpos = REAL_ARITH `!s:real. &0:real < &505395714738121840965094253656319298` in
let mqrel = REAL_ARITH `
  ((&61685286183798904213661679314483125)*(&84901888)+(&247886351831865468114486071020851875)*(&134447104))*(&30902639 / &41749730) pow 4 = (&505395714738121840965094253656319298)*(((-- &65536) * &0 + (-- &91619328) * -- &1 / &4)) /\
  ((&61685286183798904213661679314483125)*(-- &79036416)+(&247886351831865468114486071020851875)*(-- &97124352))*(&30902639 / &41749730) pow 4 = (&505395714738121840965094253656319298)*(((-- &65536) * &1 / &4 + (-- &91619328) * &3 / &16)) /\
  (&61685286183798904213661679314483125)*(&86789633)+(&247886351831865468114486071020851875)*(&131957561)+(&2171170501919814936467784032220602938192974) = (&505395714738121840965094253656319298)*(&79611463)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&84901888) * x + (-- &79036416) * y <= &86789633 ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (-- &65536) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &91619328) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &79611463
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &61685286183798904213661679314483125` [mpos] THEN
  note `&0:real < &247886351831865468114486071020851875` [npos] THEN
  note `&0:real < &2171170501919814936467784032220602938192974` [ppos] THEN
  note `&0:real < &505395714738121840965094253656319298` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&61685286183798904213661679314483125)*(&84901888)+(&247886351831865468114486071020851875)*(&134447104))*s pow 4 = (&505395714738121840965094253656319298)*((-- &65536) * &0 + (-- &91619328) * -- &1 / &4) /\ ((&61685286183798904213661679314483125)*(-- &79036416)+(&247886351831865468114486071020851875)*(-- &97124352))*s pow 4 = (&505395714738121840965094253656319298)*((-- &65536) * &1 / &4 + (-- &91619328) * &3 / &16) /\ (&61685286183798904213661679314483125)*(&86789633)+(&247886351831865468114486071020851875)*(&131957561)+(&2171170501919814936467784032220602938192974) = (&505395714738121840965094253656319298)*(&79611463)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L20 =
let mpos = REAL_ARITH `!s:real. &0:real < &714633533828267030437760302576970000` in
let npos = REAL_ARITH `!s:real. &0:real < &290384529562173223173701140987931875` in
let ppos = REAL_ARITH `!s:real. &0:real < &7401633771353346868412477646604934011385578` in
let qpos = REAL_ARITH `!s:real. &0:real < &1271151689169521189335689489976324727` in
let mqrel = REAL_ARITH `
  ((&714633533828267030437760302576970000)*(&134447104)+(&290384529562173223173701140987931875)*(&100401152))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&9371648) * &0 + (-- &118292480) * -- &1 / &4)) /\
  ((&714633533828267030437760302576970000)*(-- &97124352)+(&290384529562173223173701140987931875)*(-- &50266112))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&9371648) * &1 / &4 + (-- &118292480) * &3 / &16)) /\
  (&714633533828267030437760302576970000)*(&131957561)+(&290384529562173223173701140987931875)*(&95584823)+(&7401633771353346868412477646604934011385578) = (&1271151689169521189335689489976324727)*(&101844089)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&9371648) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &118292480) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &101844089
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &714633533828267030437760302576970000` [mpos] THEN
  note `&0:real < &290384529562173223173701140987931875` [npos] THEN
  note `&0:real < &7401633771353346868412477646604934011385578` [ppos] THEN
  note `&0:real < &1271151689169521189335689489976324727` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&714633533828267030437760302576970000)*(&134447104)+(&290384529562173223173701140987931875)*(&100401152))*s pow 4 = (&1271151689169521189335689489976324727)*((&9371648) * &0 + (-- &118292480) * -- &1 / &4) /\ ((&714633533828267030437760302576970000)*(-- &97124352)+(&290384529562173223173701140987931875)*(-- &50266112))*s pow 4 = (&1271151689169521189335689489976324727)*((&9371648) * &1 / &4 + (-- &118292480) * &3 / &16) /\ (&714633533828267030437760302576970000)*(&131957561)+(&290384529562173223173701140987931875)*(&95584823)+(&7401633771353346868412477646604934011385578) = (&1271151689169521189335689489976324727)*(&101844089)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L21 =
let mpos = REAL_ARITH `!s:real. &0:real < &88107460264435580262885117890000` in
let npos = REAL_ARITH `!s:real. &0:real < &97222025119377192014218061120000` in
let ppos = REAL_ARITH `!s:real. &0:real < &1325217926133635280807670308936482811111` in
let qpos = REAL_ARITH `!s:real. &0:real < &4398448751451630412926261210990743` in
let mqrel = REAL_ARITH `
  ((&88107460264435580262885117890000)*(&134447104)+(&97222025119377192014218061120000)*(&100401152))*(&30902639 / &41749730) pow 4 = (&4398448751451630412926261210990743)*(((&753664) * &0 + (-- &5898240) * -- &1 / &4)) /\
  ((&88107460264435580262885117890000)*(-- &97124352)+(&97222025119377192014218061120000)*(-- &50266112))*(&30902639 / &41749730) pow 4 = (&4398448751451630412926261210990743)*(((&753664) * &1 / &4 + (-- &5898240) * &3 / &16)) /\
  (&88107460264435580262885117890000)*(&131957561)+(&97222025119377192014218061120000)*(&95584823)+(&1325217926133635280807670308936482811111) = (&4398448751451630412926261210990743)*(&5057377)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&753664) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &5898240) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &5057377
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &88107460264435580262885117890000` [mpos] THEN
  note `&0:real < &97222025119377192014218061120000` [npos] THEN
  note `&0:real < &1325217926133635280807670308936482811111` [ppos] THEN
  note `&0:real < &4398448751451630412926261210990743` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&88107460264435580262885117890000)*(&134447104)+(&97222025119377192014218061120000)*(&100401152))*s pow 4 = (&4398448751451630412926261210990743)*((&753664) * &0 + (-- &5898240) * -- &1 / &4) /\ ((&88107460264435580262885117890000)*(-- &97124352)+(&97222025119377192014218061120000)*(-- &50266112))*s pow 4 = (&4398448751451630412926261210990743)*((&753664) * &1 / &4 + (-- &5898240) * &3 / &16) /\ (&88107460264435580262885117890000)*(&131957561)+(&97222025119377192014218061120000)*(&95584823)+(&1325217926133635280807670308936482811111) = (&4398448751451630412926261210990743)*(&5057377)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L22 =
let mpos = REAL_ARITH `!s:real. &0:real < &3580593001309827585228887417302890000` in
let npos = REAL_ARITH `!s:real. &0:real < &4945615488926002261824403313791223125` in
let ppos = REAL_ARITH `!s:real. &0:real < &60618074793996155972395610321011741380559206` in
let qpos = REAL_ARITH `!s:real. &0:real < &1271151689169521189335689489976324727` in
let mqrel = REAL_ARITH `
  ((&3580593001309827585228887417302890000)*(&134447104)+(&4945615488926002261824403313791223125)*(&100401152))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&129499136) * &0 + (-- &923729920) * -- &1 / &4)) /\
  ((&3580593001309827585228887417302890000)*(-- &97124352)+(&4945615488926002261824403313791223125)*(-- &50266112))*(&30902639 / &41749730) pow 4 = (&1271151689169521189335689489976324727)*(((&129499136) * &1 / &4 + (-- &923729920) * &3 / &16)) /\
  (&3580593001309827585228887417302890000)*(&131957561)+(&4945615488926002261824403313791223125)*(&95584823)+(&60618074793996155972395610321011741380559206) = (&1271151689169521189335689489976324727)*(&791274703)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&129499136) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &923729920) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &791274703
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3580593001309827585228887417302890000` [mpos] THEN
  note `&0:real < &4945615488926002261824403313791223125` [npos] THEN
  note `&0:real < &60618074793996155972395610321011741380559206` [ppos] THEN
  note `&0:real < &1271151689169521189335689489976324727` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3580593001309827585228887417302890000)*(&134447104)+(&4945615488926002261824403313791223125)*(&100401152))*s pow 4 = (&1271151689169521189335689489976324727)*((&129499136) * &0 + (-- &923729920) * -- &1 / &4) /\ ((&3580593001309827585228887417302890000)*(-- &97124352)+(&4945615488926002261824403313791223125)*(-- &50266112))*s pow 4 = (&1271151689169521189335689489976324727)*((&129499136) * &1 / &4 + (-- &923729920) * &3 / &16) /\ (&3580593001309827585228887417302890000)*(&131957561)+(&4945615488926002261824403313791223125)*(&95584823)+(&60618074793996155972395610321011741380559206) = (&1271151689169521189335689489976324727)*(&791274703)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L23 =
let mpos = REAL_ARITH `!s:real. &0:real < &89526294193521491158842612719470000` in
let npos = REAL_ARITH `!s:real. &0:real < &177959030491217800191103425020990625` in
let ppos = REAL_ARITH `!s:real. &0:real < &2038544780188480735541187512398347470155693` in
let qpos = REAL_ARITH `!s:real. &0:real < &5084606756678084757342757959905298908` in
let mqrel = REAL_ARITH `
  ((&89526294193521491158842612719470000)*(&134447104)+(&177959030491217800191103425020990625)*(&100401152))*(&30902639 / &41749730) pow 4 = (&5084606756678084757342757959905298908)*(((&1130496) * &0 + (-- &7061504) * -- &1 / &4)) /\
  ((&89526294193521491158842612719470000)*(-- &97124352)+(&177959030491217800191103425020990625)*(-- &50266112))*(&30902639 / &41749730) pow 4 = (&5084606756678084757342757959905298908)*(((&1130496) * &1 / &4 + (-- &7061504) * &3 / &16)) /\
  (&89526294193521491158842612719470000)*(&131957561)+(&177959030491217800191103425020990625)*(&95584823)+(&2038544780188480735541187512398347470155693) = (&5084606756678084757342757959905298908)*(&6069771)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&134447104) * x + (-- &97124352) * y <= &131957561 ==>
  (&100401152) * x + (-- &50266112) * y <= &95584823 ==>
  (&1130496) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &7061504) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &6069771
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &89526294193521491158842612719470000` [mpos] THEN
  note `&0:real < &177959030491217800191103425020990625` [npos] THEN
  note `&0:real < &2038544780188480735541187512398347470155693` [ppos] THEN
  note `&0:real < &5084606756678084757342757959905298908` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&89526294193521491158842612719470000)*(&134447104)+(&177959030491217800191103425020990625)*(&100401152))*s pow 4 = (&5084606756678084757342757959905298908)*((&1130496) * &0 + (-- &7061504) * -- &1 / &4) /\ ((&89526294193521491158842612719470000)*(-- &97124352)+(&177959030491217800191103425020990625)*(-- &50266112))*s pow 4 = (&5084606756678084757342757959905298908)*((&1130496) * &1 / &4 + (-- &7061504) * &3 / &16) /\ (&89526294193521491158842612719470000)*(&131957561)+(&177959030491217800191103425020990625)*(&95584823)+(&2038544780188480735541187512398347470155693) = (&5084606756678084757342757959905298908)*(&6069771)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L24 =
let mpos = REAL_ARITH `!s:real. &0:real < &3095951839748729714918386937720125` in
let npos = REAL_ARITH `!s:real. &0:real < &25558758947398769619362794974125` in
let ppos = REAL_ARITH `!s:real. &0:real < &1778450744422220645212058104847683700888` in
let qpos = REAL_ARITH `!s:real. &0:real < &13978731590763133105812509193876448` in
let mqrel = REAL_ARITH `
  ((&3095951839748729714918386937720125)*(&3866624)+(&25558758947398769619362794974125)*(&39124992))*(&30902639 / &41749730) pow 4 = (&13978731590763133105812509193876448)*(((&481280) * &0 + (-- &1114112) * -- &1 / &4)) /\
  ((&3095951839748729714918386937720125)*(-- &1310720)+(&25558758947398769619362794974125)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&13978731590763133105812509193876448)*(((&481280) * &1 / &4 + (-- &1114112) * &3 / &16)) /\
  (&3095951839748729714918386937720125)*(&3642043)+(&25558758947398769619362794974125)*(&38657149)+(&1778450744422220645212058104847683700888) = (&13978731590763133105812509193876448)*(&1004531)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&481280) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &1114112) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &1004531
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &3095951839748729714918386937720125` [mpos] THEN
  note `&0:real < &25558758947398769619362794974125` [npos] THEN
  note `&0:real < &1778450744422220645212058104847683700888` [ppos] THEN
  note `&0:real < &13978731590763133105812509193876448` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&3095951839748729714918386937720125)*(&3866624)+(&25558758947398769619362794974125)*(&39124992))*s pow 4 = (&13978731590763133105812509193876448)*((&481280) * &0 + (-- &1114112) * -- &1 / &4) /\ ((&3095951839748729714918386937720125)*(-- &1310720)+(&25558758947398769619362794974125)*(-- &2621440))*s pow 4 = (&13978731590763133105812509193876448)*((&481280) * &1 / &4 + (-- &1114112) * &3 / &16) /\ (&3095951839748729714918386937720125)*(&3642043)+(&25558758947398769619362794974125)*(&38657149)+(&1778450744422220645212058104847683700888) = (&13978731590763133105812509193876448)*(&1004531)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L25 =
let mpos = REAL_ARITH `!s:real. &0:real < &962460071328271944225128251157875` in
let npos = REAL_ARITH `!s:real. &0:real < &1146878100226590555327098135844875` in
let ppos = REAL_ARITH `!s:real. &0:real < &6956020268778142910642693608466305935770` in
let qpos = REAL_ARITH `!s:real. &0:real < &873670724422695819113281824617278` in
let mqrel = REAL_ARITH `
  ((&962460071328271944225128251157875)*(&3866624)+(&1146878100226590555327098135844875)*(&39124992))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((&44220416) * &0 + (-- &66781184) * -- &1 / &4)) /\
  ((&962460071328271944225128251157875)*(-- &1310720)+(&1146878100226590555327098135844875)*(-- &2621440))*(&30902639 / &41749730) pow 4 = (&873670724422695819113281824617278)*(((&44220416) * &1 / &4 + (-- &66781184) * &3 / &16)) /\
  (&962460071328271944225128251157875)*(&3642043)+(&1146878100226590555327098135844875)*(&38657149)+(&6956020268778142910642693608466305935770) = (&873670724422695819113281824617278)*(&62719715)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&3866624) * x + (-- &1310720) * y <= &3642043 ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&44220416) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &66781184) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &62719715
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &962460071328271944225128251157875` [mpos] THEN
  note `&0:real < &1146878100226590555327098135844875` [npos] THEN
  note `&0:real < &6956020268778142910642693608466305935770` [ppos] THEN
  note `&0:real < &873670724422695819113281824617278` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&962460071328271944225128251157875)*(&3866624)+(&1146878100226590555327098135844875)*(&39124992))*s pow 4 = (&873670724422695819113281824617278)*((&44220416) * &0 + (-- &66781184) * -- &1 / &4) /\ ((&962460071328271944225128251157875)*(-- &1310720)+(&1146878100226590555327098135844875)*(-- &2621440))*s pow 4 = (&873670724422695819113281824617278)*((&44220416) * &1 / &4 + (-- &66781184) * &3 / &16) /\ (&962460071328271944225128251157875)*(&3642043)+(&1146878100226590555327098135844875)*(&38657149)+(&6956020268778142910642693608466305935770) = (&873670724422695819113281824617278)*(&62719715)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L26 =
let mpos = REAL_ARITH `!s:real. &0:real < &14343856553696550210082066638561875` in
let npos = REAL_ARITH `!s:real. &0:real < &450757386939316806057763957585938750` in
let ppos = REAL_ARITH `!s:real. &0:real < &521123125816288086685357311672358362141305` in
let qpos = REAL_ARITH `!s:real. &0:real < &44637460623792556954403645289892786` in
let mqrel = REAL_ARITH `
  ((&14343856553696550210082066638561875)*(&39124992)+(&450757386939316806057763957585938750)*(&5865472))*(&30902639 / &41749730) pow 4 = (&44637460623792556954403645289892786)*(((&75169792) * &0 + (-- &86212608) * -- &1 / &4)) /\
  ((&14343856553696550210082066638561875)*(-- &2621440)+(&450757386939316806057763957585938750)*(&950272))*(&30902639 / &41749730) pow 4 = (&44637460623792556954403645289892786)*(((&75169792) * &1 / &4 + (-- &86212608) * &3 / &16)) /\
  (&14343856553696550210082066638561875)*(&38657149)+(&450757386939316806057763957585938750)*(&6035371)+(&521123125816288086685357311672358362141305) = (&44637460623792556954403645289892786)*(&85043005)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&39124992) * x + (-- &2621440) * y <= &38657149 ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&75169792) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &86212608) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &85043005
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &14343856553696550210082066638561875` [mpos] THEN
  note `&0:real < &450757386939316806057763957585938750` [npos] THEN
  note `&0:real < &521123125816288086685357311672358362141305` [ppos] THEN
  note `&0:real < &44637460623792556954403645289892786` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&14343856553696550210082066638561875)*(&39124992)+(&450757386939316806057763957585938750)*(&5865472))*s pow 4 = (&44637460623792556954403645289892786)*((&75169792) * &0 + (-- &86212608) * -- &1 / &4) /\ ((&14343856553696550210082066638561875)*(-- &2621440)+(&450757386939316806057763957585938750)*(&950272))*s pow 4 = (&44637460623792556954403645289892786)*((&75169792) * &1 / &4 + (-- &86212608) * &3 / &16) /\ (&14343856553696550210082066638561875)*(&38657149)+(&450757386939316806057763957585938750)*(&6035371)+(&521123125816288086685357311672358362141305) = (&44637460623792556954403645289892786)*(&85043005)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L27 =
let mpos = REAL_ARITH `!s:real. &0:real < &5496344841156139268675193742577513125` in
let npos = REAL_ARITH `!s:real. &0:real < &47555432017425670596157784072175625` in
let ppos = REAL_ARITH `!s:real. &0:real < &10425519213960055690052435653370545406586596` in
let qpos = REAL_ARITH `!s:real. &0:real < &571448139820049829260226587678636846` in
let mqrel = REAL_ARITH `
  ((&5496344841156139268675193742577513125)*(&5865472)+(&47555432017425670596157784072175625)*(&439386112))*(&30902639 / &41749730) pow 4 = (&571448139820049829260226587678636846)*(((&113278976) * &0 + (-- &111640576) * -- &1 / &4)) /\
  ((&5496344841156139268675193742577513125)*(&950272)+(&47555432017425670596157784072175625)*(&185892864))*(&30902639 / &41749730) pow 4 = (&571448139820049829260226587678636846)*(((&113278976) * &1 / &4 + (-- &111640576) * &3 / &16)) /\
  (&5496344841156139268675193742577513125)*(&6035371)+(&47555432017425670596157784072175625)*(&480443643)+(&10425519213960055690052435653370545406586596) = (&571448139820049829260226587678636846)*(&116276001)
` in
prove(`
  !s x y:real.
  s = &30902639 / &41749730 ==>
  &0 < s ==>
  (&5865472) * x + (&950272) * y <= &6035371 ==>
  (&439386112) * x + (&185892864) * y <= &480443643 ==>
  (&113278976) * ((&0) * x + (&1 / &4) * y) / s pow 4 + (-- &111640576) * ((-- &1 / &4) * x + (&3 / &16) * y) / s pow 4 <= &116276001
  `,
  REPEAT STRIP_TAC THEN
  note `&0:real < &5496344841156139268675193742577513125` [mpos] THEN
  note `&0:real < &47555432017425670596157784072175625` [npos] THEN
  note `&0:real < &10425519213960055690052435653370545406586596` [ppos] THEN
  note `&0:real < &571448139820049829260226587678636846` [qpos] THEN
  note `&0:real < s pow 4` [REAL_POW_LT] THEN
  note `((&5496344841156139268675193742577513125)*(&5865472)+(&47555432017425670596157784072175625)*(&439386112))*s pow 4 = (&571448139820049829260226587678636846)*((&113278976) * &0 + (-- &111640576) * -- &1 / &4) /\ ((&5496344841156139268675193742577513125)*(&950272)+(&47555432017425670596157784072175625)*(&185892864))*s pow 4 = (&571448139820049829260226587678636846)*((&113278976) * &1 / &4 + (-- &111640576) * &3 / &16) /\ (&5496344841156139268675193742577513125)*(&6035371)+(&47555432017425670596157784072175625)*(&480443643)+(&10425519213960055690052435653370545406586596) = (&571448139820049829260226587678636846)*(&116276001)` [mqrel] THEN
  ASM_MESON_TAC[generic_2;REAL_LT_IMP_LE]
) in
let L28 =
let mpos = REAL_