{- This module was generated from data in the Kate syntax
   highlighting file dot.xml, version 1.1, by Postula Loïs (lois.postula@live.be) -}

module Text.Highlighting.Kate.Syntax.Dot
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "dot"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.dot"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("dot","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("dot","Normal") -> return ()
      ("dot","DetectAll") -> return ()
      ("dot","DetectComments") -> return ()
      ("dot","RegionCurly") -> return ()
      ("dot","RegionSquare") -> return ()
      ("dot","RegionParen") -> return ()
      ("dot","String") -> (popContext) >> pEndLine
      ("dot","CommentSL") -> (popContext) >> pEndLine
      ("dot","CommentML") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "digraph node edge subgraph"
list_attributes = Set.fromList $ words $ "center layers margin mclimit name nodesep nslimit ordering page pagedir rank rankdir ranksep ratio rotate size distortion fillcolor fontcolor fontname fontsize height layer orientation peripheries regular shape shapefile sides skew width arrowhead arrowsize arrowtail constraint decorateP dir headclip headlabel labelangle labeldistance labelfontcolor labelfontname labelfontsize minlen port_label_distance samehead sametail tailclip taillabel weight color bgcolor label URL fontcolor fontname fontsize layer style"

regex_'5cb'5cw'2b'5cb = compileRegex True "\\b\\w+\\b"

parseRules ("dot","Normal") =
  (((parseRules ("dot","DetectAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("dot","DetectAll") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_attributes >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("dot","String"))
   <|>
   ((pAnyChar ";=" >>= withAttribute OtherTok))
   <|>
   ((pDetect2Chars False '-' '>' >>= withAttribute OtherTok))
   <|>
   ((pFloat >>= withAttribute DecValTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5cb'5cw'2b'5cb >>= withAttribute FunctionTok))
   <|>
   ((parseRules ("dot","DetectComments")))
   <|>
   ((pDetectChar False '{' >>= withAttribute OtherTok) >>~ pushContext ("dot","RegionCurly"))
   <|>
   ((pDetectChar False '[' >>= withAttribute OtherTok) >>~ pushContext ("dot","RegionSquare"))
   <|>
   ((pDetectChar False '(' >>= withAttribute OtherTok) >>~ pushContext ("dot","RegionParen"))
   <|>
   ((pAnyChar ")]}" >>= withAttribute ErrorTok))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","DetectAll")) >> pDefault >>= withAttribute NormalTok))

parseRules ("dot","DetectComments") =
  (((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("dot","CommentSL"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("dot","CommentML"))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","DetectComments")) >> pDefault >>= withAttribute NormalTok))

parseRules ("dot","RegionCurly") =
  (((pDetectChar False '}' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("dot","DetectAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","RegionCurly")) >> pDefault >>= withAttribute CommentTok))

parseRules ("dot","RegionSquare") =
  (((pDetectChar False ']' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("dot","DetectAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","RegionSquare")) >> pDefault >>= withAttribute CommentTok))

parseRules ("dot","RegionParen") =
  (((pDetectChar False ')' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((parseRules ("dot","DetectAll")))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","RegionParen")) >> pDefault >>= withAttribute CommentTok))

parseRules ("dot","String") =
  (((pDetect2Chars False '\\' '\\' >>= withAttribute CharTok))
   <|>
   ((pDetect2Chars False '\\' '"' >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("dot","CommentSL") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","CommentSL")) >> pDefault >>= withAttribute CommentTok))

parseRules ("dot","CommentML") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("dot","CommentML")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("dot","Normal") <|> fail ("Unknown context" ++ show x)
